//@ui5-bundle sap/ui/rta/library-preload.js
/*
 * ! OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/rta/api/startAdaptation',["sap/ui/rta/util/adaptationStarter","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/base/util/merge"],function(a,L,b,m){"use strict";
function c(l){if(!b.isValidLayer(l)){throw new Error("An invalid layer is passed");}}
function s(o,l,d,e,f){var D={flexSettings:{developerMode:false,layer:L.CUSTOMER}};o=m(D,o);return Promise.resolve().then(c.bind(this,o.flexSettings.layer)).then(a.bind(this,o,l,d,e,f));}
return s;});
sap.ui.predefine('sap/ui/rta/api/startKeyUserAdaptation',["sap/ui/rta/util/adaptationStarter","sap/ui/fl/Layer"],function(a,L){"use strict";
function s(p){var o={rootControl:p.rootControl,flexSettings:{developerMode:false,layer:L.CUSTOMER}};return a(o);}
return s;});
sap.ui.predefine('sap/ui/rta/plugin/CompVariant',["sap/base/util/restricted/_omit","sap/base/util/isEmptyObject","sap/ui/dt/Util","sap/ui/rta/plugin/Plugin","sap/ui/rta/plugin/RenameHandler","sap/ui/rta/Utils","sap/ui/fl/write/api/ContextSharingAPI"],function(_,i,D,P,R,U,C){"use strict";
var a=P.extend("sap.ui.rta.plugin.CompVariant",{metadata:{library:"sap.ui.rta",properties:{oldValue:{type:"string"}}}});
function b(o){return o.getElement().getMetadata().getName()==="sap.ui.comp.smartvariants.SmartVariantManagement";}
function c(o,n,p){var k=o.getDesignTimeMetadata();var t=o.getElement();return this.getCommandFactory().getCommandFor(t,n,p,k).then(function(l){this.fireElementModified({command:l});}.bind(this)).catch(function(m){throw D.createError(n,m,"sap.ui.rta.plugin.CompVariant");});}
function g(o){return o.getElement().getAllVariants();}
function r(o){this.startEdit(o[0]);}
a.prototype.startEdit=function(o){var v=o.getDesignTimeMetadata().getData().variantRenameDomRef;R.startEdit.call(this,{overlay:o,domRef:v,pluginMethodName:"plugin.CompVariant.startEdit"});};
a.prototype.stopEdit=function(k){R._stopEdit.call(this,k,"plugin.CompVariant.stopEdit");};
a.prototype._emitLabelChangeEvent=function(){var o=this._oEditedOverlay;var v=o.getElement().getPresentVariantId();var t=R._getCurrentEditableFieldText.call(this);var p={newVariantProperties:{}};p.newVariantProperties[v]={name:t};c.call(this,o,"compVariantUpdate",p);};
function d(o){var v=o[0].getElement();var p={layer:this.getCommandFactory().getFlexSettings().layer,contextSharingComponentContainer:C.createComponent(this.getCommandFactory().getFlexSettings()),rtaStyleClass:U.getRtaStyleClassName()};v.openManageViewsDialogForKeyUser(p,function(k){if(!i(k)){c.call(this,o[0],"compVariantUpdate",{newVariantProperties:_(k,["default"]),newDefaultVariantId:k.default,oldDefaultVariantId:v.getDefaultVariantId()});}}.bind(this));}
function e(o){return g(o[0]).length>1;}
function s(o,p){var v=o[0].getElement();c.call(this,o[0],"compVariantSwitch",{targetVariantId:p.eventItem.getParameters().item.getProperty("key"),sourceVariantId:v.getPresentVariantId()});}
function f(o){var v=o[0].getElement();v.getPresentVariantContent().then(function(k){var p={onlySave:true,newVariantProperties:{}};p.newVariantProperties[v.getPresentVariantId()]={content:k};c.call(this,o[0],"compVariantUpdate",p);}.bind(this));}
function h(o){return o[0].getElement().currentVariantGetModified();}
function j(o){var v=o[0].getElement();var k=C.createComponent(this.getCommandFactory().getFlexSettings());v.openSaveAsDialogForKeyUser(U.getRtaStyleClassName(),function(l){if(l){c.call(this,o[0],"compVariantSaveAs",{newVariantProperties:{"default":l.default,executeOnSelection:l.executeOnSelection,content:l.content,type:l.type,text:l.text,contexts:l.contexts},previousDirtyFlag:v.getModified(),previousVariantId:v.getPresentVariantId(),previousDefault:v.getDefaultVariantId()});}}.bind(this),k);}
a.prototype._isEditable=function(o){return b(o)&&this.hasStableId(o);};
a.prototype.getMenuItems=function(E){var o=E[0];var v=o.getElement();var m=[];if(this._isEditable(o)){var l=this.getCommandFactory().getFlexSettings().layer;var L=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var V=g(o);var k=V.find(function(n){return n.getId()===v.getPresentVariantId();});if(k.isRenameEnabled(l)){m.push({id:"CTX_COMP_VARIANT_RENAME",text:L.getText("CTX_RENAME"),handler:r.bind(this),enabled:true,rank:210,icon:"sap-icon://edit"});}if(k.isEditEnabled(l)){m.push({id:"CTX_COMP_VARIANT_SAVE",text:L.getText("CTX_VARIANT_SAVE"),handler:f.bind(this),enabled:h,rank:220,icon:"sap-icon://save"});}m.push({id:"CTX_COMP_VARIANT_SAVE_AS",text:L.getText("CTX_VARIANT_SAVEAS"),handler:j.bind(this),enabled:true,rank:230,icon:"sap-icon://duplicate"});m.push({id:"CTX_COMP_VARIANT_MANAGE",text:L.getText("CTX_VARIANT_MANAGE"),handler:d.bind(this),enabled:true,rank:240,icon:"sap-icon://action-settings"});var S=V.map(function(n){var p=v.getPresentVariantId()===n.getId();var I={id:n.getId(),text:n.getText("variantName"),icon:p?"sap-icon://accept":"blank",enabled:!p};return I;});m.push({id:"CTX_COMP_VARIANT_SWITCH",text:L.getText("CTX_VARIANT_SWITCH"),handler:s.bind(this),enabled:e,submenu:S,rank:250,icon:"sap-icon://switch-views"});}return m;};
a.prototype.getActionName=function(){return"compVariant";};
return a;});
sap.ui.predefine('sap/ui/rta/util/adaptationStarter',["sap/ui/rta/RuntimeAuthoring","sap/ui/core/Control","sap/ui/fl/Utils","sap/ui/fl/Layer","sap/ui/fl/write/api/FeaturesAPI","sap/ui/core/UIComponent","sap/base/Log"],function(R,C,F,L,a,U,b){"use strict";
function c(l){if(L.CUSTOMER===l){return a.isKeyUser().then(function(i){if(!i){throw new Error("Key user rights have not been granted to the current user");}});}return Promise.resolve();}
function d(o,l,e,f,g){if(!(o.rootControl instanceof C)&&!(o.rootControl instanceof U)){return Promise.reject(new Error("An invalid root control was passed"));}var r;return c(o.flexSettings.layer).then(function(){o.rootControl=F.getAppComponentForControl(o.rootControl);r=new R(o);if(e){r.attachEvent("start",e);}if(f){r.attachEvent("failed",f);}var O=g||function(){r.destroy();};r.attachEvent("stop",O);if(l){return l(r);}}).then(function(){return r.start();}).then(function(){return r;}).catch(function(E){if(E!=="Reload triggered"){b.error("UI Adaptation could not be started",E.message);}throw E;});}
return d;});
sap.ui.predefine('sap/ui/rta/util/changeVisualization/categories/RenameVisualization',[],function(){"use strict";var R={};
R.getDescription=function(p,f){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var k=p.originalLabel?"TXT_CHANGEVISUALIZATION_CHANGE_RENAME_FROM_TO":"TXT_CHANGEVISUALIZATION_CHANGE_RENAME_TO";return r.getText(k,[p.newLabel||f,p.originalLabel]);};
return R;});
sap.ui.predefine('sap/ui/rta/util/changeVisualization/categories/getVisualizationCategory',["sap/ui/rta/util/changeVisualization/categories/RenameVisualization"],function(R){"use strict";var c={rename:R};return function(C){return c[C];};});
/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/rta/Client',["sap/ui/base/ManagedObject","sap/ui/core/postmessage/Bus","sap/base/util/uid","sap/base/util/merge","sap/ui/rta/util/ServiceEventBus","sap/ui/thirdparty/URI"],function(M,P,u,m,S,U){"use strict";var C='sap.ui.rta.service.receiver';var a='pending';var b='accepted';var c='declined';
var d=M.extend("sap.ui.rta.Client",{
metadata:{library:"sap.ui.rta",properties:{window:"object",origin:"string"}},
_bInit:false,
constructor:function(){M.apply(this,arguments);if(!this.getWindow()){throw new TypeError("sap.ui.rta.Client: window parameter is required");}if(!this.getOrigin()){throw new TypeError("sap.ui.rta.Client: origin parameter is required");}this._oPostMessageBus=P.getInstance();this._sStatus=a;this._mPendingRequests={};this._aRequestQueue=[];this._oServiceEventBus=null;this._mEventHandlerIds={};this._oPostMessageBus.subscribeOnce(C,P.event.READY,function(e){if(!this._isValidMessage(e)){return;}this._oPostMessageBus.subscribeOnce(C,P.event.ACCEPTED,function(e){if(!this._isValidMessage(e)){return;}this._sStatus=b;var r=this._aRequestQueue.slice();this._aRequestQueue=[];r.forEach(this._sendRequest,this);this._oPostMessageBus.subscribe(C,'getService',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'callMethod',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'subscribe',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'unsubscribe',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'event',this._receiverEvents,this);},this);this._oPostMessageBus.subscribeOnce(C,P.event.DECLINED,function(e){if(!this._isValidMessage(e)){return;}this._sStatus=c;var r=this._aRequestQueue.slice();this._aRequestQueue=[];r.forEach(function(R){R.reject(new Error('sap.ui.rta.Client.getService(): connection to RuntimeAuthoring instance has been refused'));});},this);this._oPostMessageBus.publish({target:this.getWindow(),origin:this.getOrigin(),channelId:C,eventId:P.event.CONNECT,data:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("SERVICE_NAME")});},this);this._bInit=true;}
});
d.prototype.destroy=function(){this._oPostMessageBus.unsubscribe(C,'getService',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'callMethod',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'subscribe',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'unsubscribe',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'event',this._receiverEvents,this);M.prototype.destroy.apply(this,arguments);};
d.prototype.getService=function(s){if(typeof s!=="string"){throw new TypeError('sap.ui.rta.Client.getService(): invalid service name specified');}return this._sendRequest(this._createRequest({target:this.getWindow(),origin:this.getOrigin(),channelId:C,eventId:'getService',data:{arguments:[s]}}));};
d.prototype._createRequest=function(p){var r=u();var R={id:r,request:{target:p.target,origin:p.origin,channelId:C,eventId:p.eventId,data:{id:r,type:'request',body:p.data}}};R.promise=new Promise(function(f,e){R.resolve=f;R.reject=e;});return R;};
d.prototype._sendRequest=function(r){switch(this._sStatus){case b:this._mPendingRequests[r.id]=r;this._oPostMessageBus.publish(r.request);break;case a:this._aRequestQueue.push(r);break;case c:r.reject(new Error('sap.ui.rta.Client.getService(): connection to RuntimeAuthoring instance has been refused'));break;}return r.promise;};
d.prototype._isValidMessage=function(e){return this.getWindow()===e.source&&this.getOrigin()===e.origin;};
d.prototype._receiverMethods=function(e){if(!this._isValidMessage(e)){return;}var D=e.data;if(D.type!=='response'){return;}var r=this._mPendingRequests[D.id];switch(e.eventId){case'getService':var s=r.request.data.body.arguments[0];var f=D.body.methods||[];var E=D.body.events;var g=m(f.reduce(function(R,h){R[h]=function(){return this._sendRequest(this._createRequest({target:e.source,origin:e.origin,channelId:C,eventId:'callMethod',data:{service:s,method:h,arguments:Array.prototype.slice.call(arguments)}}));}.bind(this);return R;}.bind(this),{}),D.body.properties);if(Array.isArray(E)&&E.length>0){if(!this._oServiceEventBus){this._oServiceEventBus=new S();}m(g,{attachEvent:function(h,i,o){if(typeof(h)!=="string"||!h){throw new TypeError("sap.ui.rta.Client: sEventName must be a non-empty string when calling attachEvent() for a service");}if(typeof i!=="function"){throw new TypeError("sap.ui.rta.Client: fnFunction must be a function when calling attachEvent() for a service");}var j=this._oServiceEventBus.getChannel(s);var k=!j||!j.hasListeners(h);this._oServiceEventBus.subscribe(s,h,i,o);if(k){this._sendRequest(this._createRequest({target:e.source,origin:e.origin,channelId:C,eventId:'subscribe',data:{service:s,event:h}})).then(function(R){this._mEventHandlerIds[s+','+h]=R.id;this._checkIfEventAlive(s,h);}.bind(this));}}.bind(this),detachEvent:function(h,i,o){if(typeof(h)!=="string"||!h){throw new TypeError("sap.ui.rta.Client: sEventName must be a non-empty string when calling detachEvent() for a service");}if(typeof i!=="function"){throw new TypeError("sap.ui.rta.Client: fnFunction must be a function when calling detachEvent() for a service");}this._oServiceEventBus.unsubscribe(s,h,i,o);this._checkIfEventAlive(s,h);}.bind(this),attachEventOnce:function(h,i,o){function O(){g.detachEvent(h,O);i.apply(o,arguments);}g.attachEvent(h,O);}});}r.resolve(g);delete this._mPendingRequests[D.id];break;case'callMethod':if(D.status==='success'){r.resolve(D.body);}else{r.reject(D.body);}delete this._mPendingRequests[D.id];break;case'subscribe':case'unsubscribe':r.resolve(D.body);delete this._mPendingRequests[D.id];break;}};
d.prototype._checkIfEventAlive=function(s,e){var E=this._oServiceEventBus.getChannel(s);var f=this._mEventHandlerIds[s+','+e];if((!E||!E.hasListeners(e))&&f){this._sendRequest(this._createRequest({target:this.getWindow(),origin:this.getOrigin(),channelId:C,eventId:'unsubscribe',data:{service:s,event:e,id:f}}));}};
d.prototype._receiverEvents=function(e){if(!this._isValidMessage(e)){return;}var r=e.data.body;this._oServiceEventBus.publish(r.service,r.event,r.data);};
d.prototype.setWindow=function(v){if(this._bInit){throw new TypeError("sap.ui.rta.Client: Window parameter cannot be changed at runtime; recreate instance of the Client.");}if(!v){throw new TypeError("sap.ui.rta.Client: Window parameter is required");}if(v===window){throw new TypeError("sap.ui.rta.Client: Window object has to be different from the one where Client is running");}this.setProperty('window',v);return this;};
d.prototype.setOrigin=function(v){if(this._bInit){throw new TypeError("sap.ui.rta.Client: Cannot change origin parameter at runtime; recreate instance of the Client.");}if(!v){throw new TypeError("sap.ui.rta.Client: Origin parameter is required");}if(typeof v!=='string'){throw new TypeError("sap.ui.rta.Client: Origin parameter has to be a string");}if(new U(v).origin()!==v){throw new TypeError("sap.ui.rta.Client: Origin string is invalid");}this.setProperty('origin',v);return this;};
return d;});
sap.ui.predefine('sap/ui/rta/RuntimeAuthoring',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/Standalone","sap/ui/rta/toolbar/Personalization","sap/ui/rta/toolbar/FioriLike","sap/ui/dt/DesignTime","sap/ui/dt/Overlay","sap/ui/rta/command/Stack","sap/ui/rta/command/LREPSerializer","sap/ui/rta/Utils","sap/ui/dt/Util","sap/ui/dt/ElementUtil","sap/ui/fl/library","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/Layer","sap/ui/fl/write/api/ReloadInfoAPI","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/write/api/VersionsAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/m/MessageBox","sap/m/MessageToast","sap/ui/rta/util/PluginManager","sap/ui/rta/util/PopupManager","sap/ui/core/BusyIndicator","sap/ui/dt/DOMUtil","sap/ui/rta/util/StylesLoader","sap/ui/rta/appVariant/Feature","sap/ui/Device","sap/ui/rta/service/index","sap/ui/rta/util/ServiceEventBus","sap/ui/dt/OverlayRegistry","sap/base/strings/capitalize","sap/base/util/UriParameters","sap/ui/performance/Measurement","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/model/json/JSONModel","sap/ui/rta/util/validateFlexEnabled","sap/ui/rta/util/changeVisualization/ChangeVisualization"],function(q,M,F,S,P,a,D,O,C,L,U,b,E,f,c,d,e,R,g,V,h,i,j,k,l,B,m,n,o,p,r,s,t,u,v,w,x,K,J,y,z){"use strict";var A="STARTING";var G="STARTED";var H="STOPPED";var I="FAILED";var N="SERVICE_STARTING";var Q="SERVICE_STARTED";var T="SERVICE_FAILED";
var W=M.extend("sap.ui.rta.RuntimeAuthoring",{
metadata:{library:"sap.ui.rta",associations:{rootControl:{type:"sap.ui.base.ManagedObject"}},properties:{customFieldUrl:"string",showCreateCustomField:"boolean",showToolbars:{type:"boolean",defaultValue:true},triggeredFromDialog:{type:"boolean",defaultValue:false},showWindowUnloadDialog:{type:"boolean",defaultValue:true},commandStack:{type:"any"},flexSettings:{type:"object",defaultValue:{layer:e.CUSTOMER,developerMode:true}},mode:{type:"string",defaultValue:"adaptation"},metadataScope:{type:"string",defaultValue:"default"}},events:{start:{parameters:{editablePluginsCount:{type:"int"}}},stop:{},failed:{},selectionChange:{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},modeChanged:{},undoRedoStackModified:{}}},
_sAppTitle:null,
_dependents:null,
_sStatus:H,
constructor:function(){M.apply(this,arguments);this._dependents={};this._mServices={};this._mCustomServicesDictinary={};this._mUShellServices={};this.addDependent(new k(),"pluginManager");this.addDependent(new l(),"popupManager");if(this.getShowToolbars()){this.getPopupManager().attachOpen(this.onPopupOpen,this);this.getPopupManager().attachClose(this.onPopupClose,this);this.addDependent(new z(),"changeVisualization");}if(window.parent!==window){this.startService("receiver");}if(this._shouldValidateFlexEnabled()){this.attachEvent("start",y.bind(null,this));}this._loadUShellServicesPromise=c.getUShellServices(["URLParsing","AppLifeCycle","CrossApplicationNavigation"]).then(function($){this._mUShellServices=$;}.bind(this));},
_RELOAD:{NOT_NEEDED:"NO_RELOAD",VIA_HASH:"CROSS_APP_NAVIGATION",RELOAD_PAGE:"HARD_RELOAD"}
});
W.prototype._shouldValidateFlexEnabled=function(){var $=document.location.hostname;var a1=$.endsWith(".sap"+".corp")||$==="localhost";if(a1){var b1=v.fromQuery(window.location.search).get("sap-ui-rta-skip-flex-validation");a1=b1!=="true";}return a1;};
W.prototype.addDependent=function($,a1,b1){b1=typeof b1==="undefined"?true:!!b1;if(!(a1 in this._dependents)){if(a1&&b1){this["get"+u(a1,0)]=this.getDependent.bind(this,a1);}this._dependents[a1||$.getId()]=$;}else{throw b.createError("RuntimeAuthoring#addDependent",b.printf("Can't add dependency with same key '{0}'",a1),"sap.ui.rta");}};
W.prototype.getDependent=function($){return this._dependents[$];};
W.prototype.getDependents=function(){return this._dependents;};
W.prototype.removeDependent=function($){delete this._dependents[$];};
W.prototype.onPopupOpen=function($){var a1=$.getParameters().getSource();if(a1.isA("sap.m.Dialog")&&this.getToolbar().type==="fiori"){this.getToolbar().setColor("contrast");}this.getToolbar().bringToFront();};
W.prototype.onPopupClose=function($){if($.getParameters().isA("sap.m.Dialog")){this.getToolbar().setColor();}};
W.prototype.setPlugins=function($){if(this._sStatus!==H){throw new Error("Cannot replace plugins: runtime authoring already started");}this.getPluginManager().setPlugins($);};
W.prototype.getPlugins=function(){return this.getPluginManager&&this.getPluginManager()&&this.getPluginManager().getPlugins();};
W.prototype.getDefaultPlugins=function(){return this.getPluginManager().getDefaultPlugins(this.getFlexSettings());};
W.prototype.setFlexSettings=function($){var a1=v.fromQuery(window.location.search);var b1=a1.get("sap-ui-layer");$=q.extend({},this.getFlexSettings(),$);if(b1){$.layer=b1.toUpperCase();}if($.scenario||$.baseId){var c1=c.buildLrepRootNamespace($.baseId,$.scenario,$.projectId);$.rootNamespace=c1;$.namespace=c1+"changes/";}U.setRtaStyleClassName($.layer);this.setProperty("flexSettings",$);};
W.prototype.getLayer=function(){return this.getFlexSettings().layer;};
W.prototype.getRootControlInstance=function(){if(!this._oRootControl){this._oRootControl=E.getElementInstance(this.getRootControl());}return this._oRootControl;};
W.prototype._getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};
W.prototype._setVersionsModel=function($){this._oVersionsModel=$;};
W.prototype._initVersioning=function(){return V.initialize({selector:this.getRootControlInstance(),layer:this.getLayer()}).then(this._setVersionsModel.bind(this));};
function X($,a1){if($.isA("sap.ui.core.UIComponent")){$=$.getRootControl();}if($){$[a1?"addStyleClass":"removeStyleClass"]("sapUiRtaRoot");}}
W.prototype.start=function(){var $;var a1;if(this._sStatus===H){this._sStatus=A;var b1=this.getRootControlInstance();if(!b1){a1=new Error("Root control not found");x.error(a1);return Promise.reject(a1);}return this._loadUShellServicesPromise.then(this._initVersioning.bind(this)).then(this._determineReload.bind(this)).then(function(c1){if(c1){return Promise.reject("Reload triggered");}this._oSerializer=new L({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});this.getPluginManager().preparePlugins(this.getFlexSettings(),this._handleElementModified.bind(this),this.getCommandStack());var d1=this.getPluginManager().getPluginList();$=new Promise(function(e1,f1){w.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new D({scope:this.getMetadataScope(),plugins:d1});this._oDesignTime.addRootElement(this._oRootControl);q(O.getOverlayContainer()).addClass("sapUiRta");if(this.getLayer()===e.USER){q(O.getOverlayContainer()).addClass("sapUiRtaPersonalize");}else{q("body").addClass("sapUiRtaMode");}this._oDesignTime.getSelectionManager().attachChange(function(g1){this.fireSelectionChange({selection:g1.getParameter("selection")});},this);this._oDesignTime.attachEventOnce("synced",function(){e1();w.end("rta.dt.startup","Measurement of RTA: DesignTime start up");},this);this._oDesignTime.attachEventOnce("syncFailed",function(g1){f1(g1.getParameter("error"));});}.bind(this));this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);}.bind(this)).then(function(){if(this.getShowToolbars()){return this._getToolbarButtonsVisibility().then(this._createToolsMenu.bind(this));}}.bind(this)).then(this._onStackModified.bind(this)).then(function(){O.getOverlayContainer().get(0).style.setProperty("--sap-ui-rta-scrollbar-scrollWidth",m.getScrollbarWidth()+"px");O.getOverlayContainer().get(0).style.setProperty("--sap-ui-rta-scrollbar-scrollWidthPlusTwo",m.getScrollbarWidth()+2+"px");return $;}).then(function(){this.getPopupManager().setRta(this);if(this.getShowToolbars()){return this.getToolbar().show();}}.bind(this)).then(function(){if(p.browser.name==="ff"){q(document).on("contextmenu",_);}}).then(function(){this.fnKeyDown=this._onKeyDown.bind(this);q(document).on("keydown",this.fnKeyDown);X(this.getRootControlInstance(),true);}.bind(this)).then(function(){this._sStatus=G;this.fireStart({editablePluginsCount:this.getPluginManager().getEditableOverlaysCount()});}.bind(this)).catch(function(a1){if(a1!=="Reload triggered"){this._sStatus=I;this.fireFailed(a1);}if(a1){this.destroy();return Promise.reject(a1);}}.bind(this));}};
function _(){return false;}
W.prototype._getToolbarButtonsVisibility=function(){return g.isPublishAvailable().then(function($){return o.isSaveAsAvailable(this.getRootControlInstance(),this.getLayer(),this._oSerializer).then(function(a1){return{publishAvailable:$,saveAsAvailable:$&&a1};});}.bind(this));};
W.prototype._isOldVersionDisplayed=function(){return V.isOldVersionDisplayed({selector:this.getRootControlInstance(),layer:this.getLayer()});};
W.prototype._isDraftAvailable=function(){return V.isDraftAvailable({selector:this.getRootControlInstance(),layer:this.getLayer()});};
var Y=function($){B.hide();var a1=$.userMessage||$.stack||$.message||$.status||$;var b1=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");x.error("Failed to transfer changes",a1);var c1=b1.getText("MSG_LREP_TRANSFER_ERROR")+"\n"+b1.getText("MSG_ERROR_REASON",a1);i.error(c1,{styleClass:U.getRtaStyleClassName()});};
W.prototype.setCommandStack=function($){var a1=this.getProperty("commandStack");if(a1){a1.detachModified(this._onStackModified,this);}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack;}var b1=this.setProperty("commandStack",$);if($){$.attachModified(this._onStackModified,this);}if(this.getPluginManager&&this.getPluginManager()){this.getPluginManager().provideCommandStack("settings",$);}return b1;};
W.prototype.getCommandStack=function(){var $=this.getProperty("commandStack");if(!$){$=new C();this._oInternalCommandStack=$;this.setCommandStack($);}return $;};
W.prototype._onStackModified=function(){var $=this._oVersionsModel.getProperty("/backendDraft");var a1=this._oVersionsModel.getProperty("/displayedVersion")===sap.ui.fl.Versions.Draft;var b1=this.getCommandStack();var c1=b1.canUndo();if(!this.getShowToolbars()||!c1||this._bUserDiscardedDraft||a1||!$){return this._modifyStack();}return U.showMessageBox("warning","MSG_DRAFT_DISCARD_AND_CREATE_NEW_DIALOG",{titleKey:"TIT_DRAFT_DISCARD_DIALOG",actions:[i.Action.OK,i.Action.CANCEL],emphasizedAction:i.Action.OK}).then(function(d1){if(d1===i.Action.OK){this._discardDraftConfirmed();}else{this.undo();}}.bind(this));};
W.prototype._discardDraftConfirmed=function(){this._bUserDiscardedDraft=true;this._modifyStack();};
W.prototype._modifyStack=function(){if(this.getShowToolbars()){var $=this.getCommandStack();var a1=$.canUndo();var b1=$.canRedo();this._oVersionsModel.setDirtyChanges(a1);this._oToolbarControlsModel.setProperty("/undoEnabled",a1);this._oToolbarControlsModel.setProperty("/redoEnabled",b1);this._oToolbarControlsModel.setProperty("/publishEnabled",this.bInitialPublishEnabled||a1);this._oToolbarControlsModel.setProperty("/restoreEnabled",this.bInitialResetEnabled||a1);}this.fireUndoRedoStackModified();return Promise.resolve();};
W.prototype._checkToolbarAndExecuteFunction=function($,a1){if(this.getShowToolbars()&&this.getToolbar&&this.getToolbar()){return this.getToolbar()[$](a1);}};
W.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get();}return[];};
W.prototype.stop=function($,a1){this._checkToolbarAndExecuteFunction("setBusy",true);return this._handleReloadOnExit(a1).then(function(b1){return(($)?Promise.resolve():this._serializeToLrep(this)).then(this._checkToolbarAndExecuteFunction.bind(this,"hide",$)).then(function(){this.fireStop();if(b1.reloadMethod&&(b1.reloadMethod!==this._RELOAD.NOT_NEEDED)){b1.deleteMaxLayer=true;b1.onExit=true;b1.triggerHardReload=(b1.reloadMethod===this._RELOAD.RELOAD_PAGE);return this._handleUrlParameterOnExit(b1);}}.bind(this));}.bind(this)).catch(Y).then(function(){this._checkToolbarAndExecuteFunction("setBusy",false);this._sStatus=H;q("body").removeClass("sapUiRtaMode");}.bind(this));};
W.prototype.restore=function(){return this._onRestore();};
W.prototype.transport=function(){return this._onTransport();};
W.prototype.undo=function(){return this._onUndo();};
W.prototype.redo=function(){return this._onRedo();};
W.prototype.canUndo=function(){return this.getCommandStack().canUndo();};
W.prototype.canRedo=function(){return this.getCommandStack().canRedo();};
W.prototype._onKeyDown=function($){var a1=p.os.macintosh;var b1=O.getOverlayContainer().get(0).contains(document.activeElement);var c1=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);var d1=false;q(".sapUiDtContextMenu").each(function(h1,i1){if(i1.contains(document.activeElement)){d1=true;}});var e1=document.body===document.activeElement;var f1=q(document.activeElement).parents(".sapUiRtaEditableField").length>0;if((b1||c1||d1||e1)&&!f1){var g1=a1?$.metaKey:$.ctrlKey;if($.keyCode===K.Z&&$.shiftKey===false&&$.altKey===false&&g1===true){this._onUndo().then($.stopPropagation.bind($));}else if(((a1&&$.keyCode===K.Z&&$.shiftKey===true)||(!a1&&$.keyCode===K.Y&&$.shiftKey===false))&&$.altKey===false&&g1===true){this._onRedo().then($.stopPropagation.bind($));}}};
W.prototype._onUnload=function(){var $=this.getCommandStack();var a1=$.canUndo()||$.canRedo();if(a1&&this.getShowWindowUnloadDialog()){return this._getTextResources().getText("MSG_UNSAVED_CHANGES");}window.onbeforeunload=this._oldUnloadHandler;};
W.prototype._serializeAndSave=function(){return this._oSerializer.saveCommands(this._oVersionsModel.getProperty("/versioningEnabled"));};
W.prototype._serializeToLrep=function(){if(!this._bReloadNeeded){return this._oSerializer.needsReload().then(function($){this._bReloadNeeded=$;return this._serializeAndSave();}.bind(this));}return this._serializeAndSave();};
W.prototype._onUndo=function(){this.getPluginManager().handleStopCutPaste();return this.getCommandStack().undo();};
W.prototype._onRedo=function(){this.getPluginManager().handleStopCutPaste();return this.getCommandStack().redo();};
W.prototype._onActivate=function($){var a1=$.getParameter("versionTitle");if(this._isOldVersionDisplayed()&&this._isDraftAvailable()){return U.showMessageBox("warning","MSG_DRAFT_DISCARD_ON_REACTIVATE_DIALOG",{titleKey:"TIT_DRAFT_DISCARD_ON_REACTIVATE_DIALOG",actions:[i.Action.OK,i.Action.CANCEL],emphasizedAction:i.Action.OK}).then(function(b1){if(b1===i.Action.OK){this._activate(a1);}}.bind(this));}return this._activate(a1);};
W.prototype._activate=function($){var a1=this.getLayer();var b1=this.getRootControlInstance();return V.activate({layer:a1,selector:b1,title:$}).then(function(){this._showMessageToast("MSG_DRAFT_ACTIVATION_SUCCESS");this.bInitialResetEnabled=true;this._oToolbarControlsModel.setProperty("/restoreEnabled",true);this.getCommandStack().removeAllCommands();}.bind(this)).catch(function(c1){U.showMessageBox("error","MSG_DRAFT_ACTIVATION_FAILED",{error:c1});});};
W.prototype._handleDiscard=function(){var $=this.getLayer();var a1={isDraftAvailable:false,layer:$};W.enableRestart($,this.getRootControlInstance());if(!c.getUshellContainer()){this.getCommandStack().removeAllCommands();return this._triggerHardReload(a1);}var b1=true;this.getCommandStack().removeAllCommands();var c1=this._removeVersionParameterForFLP(a1,c.getParsedURLHash(this._getUShellService("URLParsing")),b1);this._triggerCrossAppNavigation(c1);return this.stop(true,true);};
W.prototype._onDiscardDraft=function(){return U.showMessageBox("warning","MSG_DRAFT_DISCARD_DIALOG",{actions:[i.Action.OK,i.Action.CANCEL],emphasizedAction:i.Action.OK}).then(function($){if($===i.Action.OK){return V.discardDraft({layer:this.getLayer(),selector:this.getRootControlInstance(),updateState:true}).then(this._handleDiscard.bind(this));}return undefined;}.bind(this));};
W.prototype._onSwitchVersion=function($){var a1=$.getParameter("version");var b1=this._oVersionsModel.getProperty("/displayedVersion");if(a1===b1){return;}if(this.canUndo()){this._nSwitchToVersion=a1;U.showMessageBox("warning","MSG_SWITCH_VERSION_DIALOG",{titleKey:"TIT_SWITCH_VERSION_DIALOG",actions:[i.Action.YES,i.Action.NO,i.Action.CANCEL],emphasizedAction:i.Action.YES}).then(function(c1){if(c1===i.Action.YES){this._serializeToLrep(this).then(this._switchVersion.bind(this,this._nSwitchToVersion));}else if(c1===i.Action.NO){this.getCommandStack().removeAllCommands(true);this._switchVersion(this._nSwitchToVersion);}return undefined;}.bind(this));return;}this._switchVersion(a1);};
W.prototype._switchVersion=function($){var a1=$.toString();W.enableRestart(this.getLayer(),this.getRootControlInstance());if(!c.getUshellContainer()){if(!R.hasVersionParameterWithValue({value:a1},this._getUShellService("URLParsing"))){var b1={versionSwitch:true,version:a1};return this._triggerHardReload(b1);}return this._reloadPage();}var c1=c.getParsedURLHash(this._getUShellService("URLParsing"));V.loadVersionForApplication({selector:this.getRootControlInstance(),layer:this.getLayer(),version:$});var d1=c1.params[sap.ui.fl.Versions.UrlParameter];if(d1&&d1[0]===a1&&this._getUShellService("AppLifeCycle")){this._getUShellService("AppLifeCycle").reloadCurrentApp();}else{c1.params[sap.ui.fl.Versions.UrlParameter]=a1;this._triggerCrossAppNavigation(c1);}return undefined;};
W.prototype._setUriParameter=function($){document.location.search=$;};
W.prototype._createToolsMenu=function($){if(!this.getDependent("toolbar")){var a1=this.getLayer()===e.USER;var b1={rtaInformation:{flexSettings:this.getFlexSettings(),rootControl:this.getRootControlInstance(),commandStack:this.getCommandStack()},textResources:this._getTextResources(),restore:this._onRestore.bind(this),exit:this.stop.bind(this,false,a1)};if(!a1){b1.transport=this._onTransport.bind(this);b1.undo=this._onUndo.bind(this);b1.redo=this._onRedo.bind(this);b1.modeChange=this._onModeChange.bind(this);b1.activate=this._onActivate.bind(this);b1.discardDraft=this._onDiscardDraft.bind(this);b1.switchVersion=this._onSwitchVersion.bind(this);b1.onCommandCategorySelection=this.getChangeVisualization?this.getChangeVisualization().onCommandCategorySelection.bind(this.getChangeVisualization()):function(){};}var c1;if(a1){c1=new P(b1);}else if(U.isOriginalFioriToolbarAccessible()){c1=new F(b1);}else if(U.getFiori2Renderer()){c1=new a(b1);}else{c1=new S(b1);}this.addDependent(c1,"toolbar");return c1.onFragmentLoaded().then(function(){var d1=$.saveAsAvailable;var e1=d1&&o.isOverviewExtended();this._oToolbarControlsModel=new J({undoEnabled:false,redoEnabled:false,translationVisible:false,translationEnabled:false,publishVisible:$.publishAvailable,publishEnabled:this.bInitialPublishEnabled,restoreEnabled:this.bInitialResetEnabled,appVariantsOverviewVisible:d1&&e1,appVariantsOverviewEnabled:d1&&e1,saveAsVisible:d1,saveAsEnabled:false,manageAppsVisible:d1&&!e1,manageAppsEnabled:d1&&!e1,modeSwitcher:this.getMode()});if(d1){o.isManifestSupported().then(function(f1){this._oToolbarControlsModel.setProperty("/saveAsEnabled",f1);this._oToolbarControlsModel.setProperty("/appVariantsOverviewEnabled",f1);this._oToolbarControlsModel.setProperty("/manageAppsEnabled",f1);}.bind(this));}this.getToolbar().setModel(this._oVersionsModel,"versions");this.getToolbar().setModel(this._oToolbarControlsModel,"controls");}.bind(this));}return Promise.resolve();};
W.prototype.destroy=function(){q.map(this._dependents,function($,a1){this.removeDependent(a1);$.destroy(true);}.bind(this));Object.keys(this._mServices).forEach(function($){this.stopService($);},this);if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;q(document).off("keydown",this.fnKeyDown);}if(this.getRootControlInstance()){X(this.getRootControlInstance(),false);}this.setCommandStack(null);if(this._oServiceEventBus){this._oServiceEventBus.destroy();}if(p.browser.name==="ff"){q(document).off("contextmenu",_);}window.onbeforeunload=this._oldUnloadHandler;M.prototype.destroy.apply(this,arguments);};
W.prototype._onTransport=function(){this.getPluginManager().handleStopCutPaste();B.show(500);return this._serializeToLrep().then(function(){B.hide();var $=c.isApplicationVariant(this._oRootControl)&&!c.isVariantByStartupParameter(this._oRootControl);return(($)?o.getAppVariantDescriptor(this._oRootControl):Promise.resolve()).then(function(a1){var b1=[];if(a1){b1.push(a1);}return h.publish({selector:this.getRootControlInstance(),styleClass:U.getRtaStyleClassName(),layer:this.getLayer(),appVariantDescriptors:b1}).then(function(c1){if(c1!=="Error"&&c1!=="Cancel"){j.show(c1);if(this.getShowToolbars()){h.getResetAndPublishInfo({selector:this.getRootControlInstance(),layer:this.getLayer()}).then(function(d1){this._oToolbarControlsModel.setProperty("/publishEnabled",d1.isPublishEnabled);this._oToolbarControlsModel.setProperty("/restoreEnabled",d1.isResetEnabled);}.bind(this));}}}.bind(this));}.bind(this));}.bind(this))["catch"](Y);};
W.prototype._deleteChanges=function(){var $=this.getLayer();var a1=c.getAppComponentForControl(this.getRootControlInstance());return h.reset({selector:a1,layer:$}).then(function(){R.removeInfoSessionStorage(a1);var b1={isDraftAvailable:R.hasVersionParameterWithValue({value:$},this._getUShellService("URLParsing")),layer:$,deleteMaxLayer:false,triggerHardReload:true};return this._handleUrlParameterOnExit(b1);}.bind(this)).catch(function(b1){if(b1!=="cancel"){U.showMessageBox("error","MSG_RESTORE_FAILED",{error:b1});}});};
W.prototype._reloadPage=function(){window.location.reload();};
W.prototype._showMessageToast=function($){var a1=this._getTextResources().getText($);j.show(a1);};
W.needsRestart=function($){return!!window.sessionStorage.getItem("sap.ui.rta.restart."+$);};
W.enableRestart=function($,a1){var b1=c.getComponentClassName(a1);var c1=b1||true;window.sessionStorage.setItem("sap.ui.rta.restart."+$,c1);};
W.disableRestart=function($){window.sessionStorage.removeItem("sap.ui.rta.restart."+$);};
W.prototype._onRestore=function(){var $=this.getLayer();var a1=$===e.USER?"FORM_PERS_RESET_MESSAGE_PERSONALIZATION":"FORM_PERS_RESET_MESSAGE";var b1=$===e.USER?"BTN_RESTORE":"FORM_PERS_RESET_TITLE";this.getPluginManager().handleStopCutPaste();return U.showMessageBox("warning",a1,{titleKey:b1,actions:[i.Action.OK,i.Action.CANCEL],emphasizedAction:i.Action.OK}).then(function(c1){if(c1===i.Action.OK){W.enableRestart($,this.getRootControlInstance());return this._deleteChanges().then(function(){this.getCommandStack().removeAllCommands();}.bind(this));}return undefined;}.bind(this));};
W.prototype._scheduleOnCreated=function($,a1){function b1(c1){var d1=c1.getParameter("elementOverlay");if(d1.getElement().getId()===$){this._oDesignTime.detachEvent("elementOverlayCreated",b1,this);a1(d1);}}this._oDesignTime.attachEvent("elementOverlayCreated",b1,this);};
W.prototype._scheduleOnCreatedAndVisible=function($,a1){function b1(d1){var e1=d1.getSource();if(e1.getGeometry()&&e1.getGeometry().visible){e1.detachEvent("geometryChanged",b1);a1(e1);}}function c1(d1){if(!d1.getGeometry()||!d1.getGeometry().visible){d1.attachEvent("geometryChanged",b1);}else{a1(d1);}}this._scheduleOnCreated($,function(d1){if(d1.isRendered()){c1(d1);}else{d1.attachEventOnce("afterRendering",function(e1){c1(e1.getSource());});}});};
W.prototype._scheduleRenameOnCreatedContainer=function($,a1){var b1=function(c1){c1.setSelected(true);this.getPluginManager().getPlugin("rename").startEdit(c1);}.bind(this);this._scheduleOnCreatedAndVisible(a1,function(c1){var d1=this.getPluginManager().getPlugin("createContainer").getCreatedContainerId($,c1.getElement().getId());var e1=t.getOverlay(d1);if(e1){b1(e1);}else{this._scheduleOnCreatedAndVisible(d1,b1);}}.bind(this));};
W.prototype._handleElementModified=function($){this.getPluginManager().handleStopCutPaste();var a1=$.getParameter("action");var b1=$.getParameter("newControlId");var c1=$.getParameter("command");if(c1 instanceof sap.ui.rta.command.BaseCommand){if(b1){this._scheduleOnCreated(b1,function(d1){var e1=d1.getDesignTimeMetadata();var f1=e1.getData().select;if(typeof f1==="function"){f1(d1.getElement());}});if(a1){this._scheduleRenameOnCreatedContainer(a1,b1);}}return this.getCommandStack().pushAndExecute(c1).catch(function(d1){if(d1&&d1.message&&d1.message.indexOf("The following Change cannot be applied because of a dependency")>-1){U.showMessageBox("error","MSG_DEPENDENCY_ERROR",{error:d1});}x.error("sap.ui.rta: "+d1.message);});}return Promise.resolve();};
W.prototype._buildNavigationArguments=function($){return{target:{semanticObject:$.semanticObject,action:$.action,context:$.contextRaw},params:$.params,appSpecificRoute:$.appSpecificRoute,writeHistory:false};};
W.prototype._triggerCrossAppNavigation=function($){if((this.getLayer()!==e.USER)&&this._getUShellService("CrossApplicationNavigation")){this._getUShellService("CrossApplicationNavigation").toExternal(this._buildNavigationArguments($));return true;}return false;};
W.prototype._removeVersionParameterForFLP=function($,a1,b1){var c1=this.getLayer();if(c1===e.USER){return a1;}var d1=c.getParameter(f.Versions.UrlParameter,this._getUShellService("URLParsing"));if(d1){delete a1.params[f.Versions.UrlParameter];}else if((this._isDraftAvailable()||b1)&&!$.hasHigherLayerChanges&&this._getUShellService("AppLifeCycle")){this._getUShellService("AppLifeCycle").reloadCurrentApp();}return a1;};
W.prototype._removeMaxLayerParameterForFLP=function($,a1){if($.deleteMaxLayer&&$.hasHigherLayerChanges){delete a1.params[d.FL_MAX_LAYER_PARAM];}return a1;};
W.prototype._handleUrlParameterOnExit=function($){if(!c.getUshellContainer()){return this._triggerHardReload($);}var a1=c.getParsedURLHash(this._getUShellService("URLParsing"));if(!a1){return undefined;}if($.allContexts&&!$.hasHigherLayerChanges&&this._getUShellService("AppLifeCycle")){this._getUShellService("AppLifeCycle").reloadCurrentApp();}a1=this._removeMaxLayerParameterForFLP($,a1);a1=this._removeVersionParameterForFLP($,a1,false);this._triggerCrossAppNavigation(a1);if($.triggerHardReload){this._reloadPage();}};
W.prototype._getReloadMessageOnStart=function($){var a1;var b1=$.layer===e.CUSTOMER;if($.hasHigherLayerChanges&&$.isDraftAvailable){a1=b1?"MSG_VIEWS_OR_PERSONALIZATION_AND_DRAFT_EXISTS":"MSG_HIGHER_LAYER_CHANGES_AND_DRAFT_EXISTS";}else if($.hasHigherLayerChanges&&$.allContexts){a1="MSG_RESTRICTED_CONTEXT_EXIST_AND_PERSONALIZATION";}else if($.hasHigherLayerChanges){a1=b1?"MSG_PERSONALIZATION_OR_PUBLIC_VIEWS_EXISTS":"MSG_HIGHER_LAYER_CHANGES_EXIST";}else if($.isDraftAvailable){a1="MSG_DRAFT_EXISTS";}else if($.allContexts){a1="MSG_RESTRICTED_CONTEXT_EXIST";}return a1;};
W.prototype._getReloadMessageOnExit=function($){var a1=$.layer===e.CUSTOMER;if($.hasHigherLayerChanges){if(!a1){return"MSG_RELOAD_WITH_ALL_CHANGES";}if($.isDraftAvailable){return"MSG_RELOAD_WITH_VIEWS_PERSONALIZATION_AND_WITHOUT_DRAFT";}if($.allContexts){return"MSG_RELOAD_WITH_PERSONALIZATION_AND_RESTRICTED_CONTEXT";}return"MSG_RELOAD_WITH_PERSONALIZATION_AND_VIEWS";}if($.initialDraftGotActivated){return"MSG_RELOAD_ACTIVATED_DRAFT";}if($.isDraftAvailable){return"MSG_RELOAD_WITHOUT_DRAFT";}if($.changesNeedReload){return"MSG_RELOAD_NEEDED";}if($.allContexts){return"MSG_RELOAD_WITHOUT_ALL_CONTEXT";}};
W.prototype._handleReloadMessageBoxOnExit=function($){var a1=this._getReloadMessageOnExit($);if(a1){return U.showMessageBox("information",a1,{titleKey:"HEADER_RELOAD_NEEDED"});}return Promise.resolve();};
W.prototype._triggerReloadOnStart=function($){if(this._getUShellService("CrossApplicationNavigation")){if($.isDraftAvailable){V.loadDraftForApplication({selector:$.selector,layer:$.layer});}else{V.loadVersionForApplication({selector:$.selector,layer:$.layer,allContexts:$.allContexts});}}var a1=this._getReloadMessageOnStart($);if(!a1){return Promise.resolve();}return U.showMessageBox("information",a1).then(function(){W.enableRestart($.layer,this.getRootControlInstance());if($.allContexts&&!$.hasHigherLayerChanges&&this._getUShellService("AppLifeCycle")){this._getUShellService("AppLifeCycle").reloadCurrentApp();}if(c.getUshellContainer()){var b1=R.handleParametersOnStart($);return this._triggerCrossAppNavigation(b1);}return this._triggerHardReload($);}.bind(this));};
W.prototype._determineReload=function(){var $={hasHigherLayerChanges:false,isDraftAvailable:false,layer:this.getLayer(),selector:this.getRootControlInstance(),ignoreMaxLayerParameter:false,includeCtrlVariants:true,URLParsingService:this._getUShellService("URLParsing")};return R.getReloadReasonsForStart($).then(function($){var a1=h.getResetAndPublishInfoFromSession($.selector);this.bInitialResetEnabled=!!a1.isResetEnabled;this.bInitialPublishEnabled=!!a1.isPublishEnabled;if($.hasHigherLayerChanges||$.isDraftAvailable||$.allContexts){return this._triggerReloadOnStart($);}return undefined;}.bind(this));};
W.prototype._triggerHardReload=function($){$.parameters=document.location.search;$.URLParsingService=this._getUShellService("URLParsing");var a1=R.handleUrlParametersForStandalone($);if(document.location.search!==a1){this._setUriParameter(a1);return Promise.resolve();}return this._reloadPage();};
W.prototype._handleReloadOnExit=function($){if($){return Promise.resolve({reloadMethod:this._RELOAD.NOT_NEEDED});}var a1=this._bReloadNeeded?Promise.resolve(this._bReloadNeeded):this._oSerializer.needsReload();return a1.then(function(b1){var c1={layer:this.getLayer(),selector:this.getRootControlInstance(),changesNeedReload:b1,isDraftAvailable:this._oVersionsModel.getProperty("/draftAvailable"),versioningEnabled:this._oVersionsModel.getProperty("/versioningEnabled"),activeVersion:this._oVersionsModel.getProperty("/activeVersion"),URLParsingService:this._getUShellService("URLParsing")};c1=R.getReloadMethod(c1);return this._handleReloadMessageBoxOnExit(c1).then(function(){return c1;});}.bind(this));};
W.prototype._onModeChange=function($){this.setMode($.getParameter("item").getKey());};
W.prototype.setMode=function($){var a1=this.getMode();if(a1!==$){var b1=this.getChangeVisualization&&this.getChangeVisualization();if($==="visualization"||a1==="visualization"){b1.triggerModeChange(this.getRootControl(),this.getToolbar());}var c1=this.getPluginManager().getPlugin("tabHandling");var d1=this.getPluginManager().getPlugin("selection");if(a1==="navigation"||$==="navigation"){this._oDesignTime.setEnabled($!=="navigation");c1[($==="navigation")?"restoreTabIndex":"removeTabIndex"]();}c1[($==="adaptation")?"restoreOverlayTabIndex":"removeOverlayTabIndex"]();d1.setIsActive(!($==="visualization"));O.getOverlayContainer().toggleClass("sapUiRtaVisualizationMode",($==="visualization"));if($==="visualization"){q(".sapUiDtOverlayMovable").css("cursor","default");}else{q(".sapUiDtOverlayMovable").css("cursor","move");}this._oToolbarControlsModel.setProperty("/modeSwitcher",$);this.setProperty("mode",$);this.fireModeChanged({mode:$});}};
W.prototype.setMetadataScope=function($){if(this._sStatus!==H){x.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return;}this.setProperty("metadataScope",$);};
function Z($){if(r.hasOwnProperty($)){return r[$].replace(/\./g,"/");}}
W.prototype.startService=function($){if(this._sStatus!==G){return new Promise(function(c1,d1){this.attachEventOnce("start",c1);this.attachEventOnce("failed",d1);}.bind(this)).then(function(){return this.startService($);}.bind(this),function(){return Promise.reject(b.createError("RuntimeAuthoring#startService",b.printf("Can't start the service '{0}' while RTA has been failed during a startup",$),"sap.ui.rta"));});}var a1=Z($);var b1;if(!a1){return Promise.reject(b.createError("RuntimeAuthoring#startService",b.printf("Unknown service. Can't find any registered service by name '{0}'",$),"sap.ui.rta"));}b1=this._mServices[$];if(b1){switch(b1.status){case Q:{return Promise.resolve(b1.exports);}case N:{return b1.initPromise;}case T:{return b1.initPromise;}default:{return Promise.reject(b.createError("RuntimeAuthoring#startService",b.printf("Unknown service status. Service name = '{0}'",$),"sap.ui.rta"));}}}else{this._mServices[$]=b1={status:N,location:a1,initPromise:new Promise(function(c1,d1){sap.ui.require([a1],function(e1){b1.factory=e1;if(!this._oServiceEventBus){this._oServiceEventBus=new s();}b.wrapIntoPromise(e1)(this,this._oServiceEventBus.publish.bind(this._oServiceEventBus,$)).then(function(f1){if(this.bIsDestroyed){throw b.createError("RuntimeAuthoring#startService",b.printf("RuntimeAuthoring instance is destroyed while initialising the service '{0}'",$),"sap.ui.rta");}if(!q.isPlainObject(f1)){throw b.createError("RuntimeAuthoring#startService",b.printf("Invalid service format. Service should return simple javascript object after initialisation. Service name = '{0}'",$),"sap.ui.rta");}b1.service=f1;b1.exports={};if(Array.isArray(f1.events)&&f1.events.length>0){q.extend(b1.exports,{attachEvent:this._oServiceEventBus.subscribe.bind(this._oServiceEventBus,$),detachEvent:this._oServiceEventBus.unsubscribe.bind(this._oServiceEventBus,$),attachEventOnce:this._oServiceEventBus.subscribeOnce.bind(this._oServiceEventBus,$)});}var g1=f1.exports||{};q.extend(b1.exports,Object.keys(g1).reduce(function(h1,i1){var j1=g1[i1];h1[i1]=typeof j1==="function"?b.waitForSynced(this._oDesignTime,j1):j1;return h1;}.bind(this),{}));b1.status=Q;c1(Object.freeze(b1.exports));}.bind(this)).catch(d1);}.bind(this),function(e1){b1.status=T;d1(b.propagateError(e1,"RuntimeAuthoring#startService",b.printf("Can't load service '{0}' by its name: {1}",$,a1),"sap.ui.rta"));});}.bind(this)).catch(function(c1){b1.status=T;return Promise.reject(b.propagateError(c1,"RuntimeAuthoring#startService",b.printf("Error during service '{0}' initialisation.",$),"sap.ui.rta"));})};return b1.initPromise;}};
W.prototype.stopService=function($){var a1=this._mServices[$];if(a1){if(a1.status===Q){if(typeof a1.service.destroy==="function"){a1.service.destroy();}}delete this._mServices[$];}else{throw b.createError("RuntimeAuthoring#stopService",b.printf("Can't destroy service: unable to find service with name '{0}'",$),"sap.ui.rta");}};
W.prototype.getService=function($){return this.startService($);};
W.prototype._getUShellService=function($){return c.getUshellContainer()&&this._mUShellServices[$];};
return W;});
sap.ui.predefine('sap/ui/rta/Utils',["sap/ui/thirdparty/jquery","sap/ui/fl/write/api/FieldExtensibility","sap/ui/fl/Utils","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/dt/OverlayUtil","sap/ui/dt/DOMUtil","sap/ui/dt/ElementUtil","sap/ui/dt/MetadataPropagationUtil","sap/ui/rta/util/hasStableId","sap/m/MessageBox","sap/ui/rta/util/BindingsExtractor","sap/base/util/restricted/_omit","sap/ui/model/json/JSONModel","sap/ui/core/Fragment"],function(q,F,a,L,b,O,D,E,M,h,c,B,_,J,d){"use strict";var U={};U.RESOLVED_PROMISE=Promise.resolve(true);U._sFocusableOverlayClass=".sapUiDtOverlaySelectable";U._sRtaStyleClassName='';
U.getRtaStyleClassName=function(){return U._sRtaStyleClassName;};
U.setRtaStyleClassName=function(l){if(l===L.USER){U._sRtaStyleClassName="";}else if(b.getLayerIndex(l)>-1){U._sRtaStyleClassName="sapUiRTABorder";}};
U.isServiceUpToDate=function(C){return F.isExtensibilityEnabled(C).then(function(e){if(e){var o=C.getModel();if(o&&o.sServiceUrl){return F.isServiceOutdated(o.sServiceUrl).then(function(s){if(s){F.setServiceValid(o.sServiceUrl);sap.ui.getCore().getEventBus().publish("sap.ui.core.UnrecoverableClientStateCorruption","RequestReload",{});}});}}});};
U.openRemoveConfirmationDialog=function(e,t){var T=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var s;return new Promise(function(r){s=T.getText("CTX_REMOVE_TITLE");var f={messageText:t,titleText:s,icon:"sap-icon://question-mark",removeText:T.getText("BTN_FREP_REMOVE"),cancelText:T.getText("BTN_FREP_CANCEL")};var o=new J();o.setData(f);var g;var C=function(){if(g){g.close();g.destroy();g=null;}};var i={removeField:function(){C();r(true);},closeDialog:function(){C();r(false);}};if(!g){d.load({name:"sap.ui.rta.view.RemoveElementDialog",controller:i}).then(function(j){g=j;g.setModel(o);g.addStyleClass(U.getRtaStyleClassName());g.open();});}else{g.addStyleClass(U.getRtaStyleClassName());g.open();}});};
U.isOverlaySelectable=function(o){return o.isSelectable()&&D.isVisible(o.getDomRef());};
U.getPropertyValue=function(e,p){var o=e.getMetadata().getPropertyLikeSetting(p);var P=o._sGetter;return e[P]();};
U.getOverlayInstanceForDom=function(o){var i=q(o).attr("id");if(i){return sap.ui.getCore().byId(i);}};
U.getFocusedOverlay=function(){if(document.activeElement){var e=sap.ui.getCore().byId(document.activeElement.id);if(e instanceof sap.ui.dt.ElementOverlay){return e;}}};
U.getFocusableParentOverlay=function(o){if(!o){return undefined;}var f=o.getParentElementOverlay();while(f&&!f.getSelectable()){f=f.getParentElementOverlay();}return f;};
U.getFirstFocusableDescendantOverlay=function(o){return O.getFirstDescendantByCondition(o,this.isOverlaySelectable);};
U.getLastFocusableDescendantOverlay=function(o){return O.getLastDescendantByCondition(o,this.isOverlaySelectable);};
U.getNextFocusableSiblingOverlay=function(o){var N=true;var n=O.getNextSiblingOverlay(o);while(n&&!this.isOverlaySelectable(n)){n=O.getNextSiblingOverlay(n);}if(!n){n=this._findSiblingOverlay(o,N);}return n;};
U.getPreviousFocusableSiblingOverlay=function(o){var P=false;var p=O.getPreviousSiblingOverlay(o);while(p&&!this.isOverlaySelectable(p)){p=O.getPreviousSiblingOverlay(p);}if(!p){p=this._findSiblingOverlay(o,P);}return p;};
U._findSiblingOverlay=function(o,n){var p=o.getParentElementOverlay();if(p){var s=n?O.getNextSiblingOverlay(p):O.getPreviousSiblingOverlay(p);if(!s){return this._findSiblingOverlay(p,n);}var e=n?this.getFirstFocusableDescendantOverlay(s):this.getLastFocusableDescendantOverlay(s);return e;}return undefined;};
U.getIndex=function(p,C,A,g){var i;if(g&&typeof g==="function"){i=g(p,C);}else{var o=p.getMetadata();var e=o.getAggregation(A);var G=e._sGetter;var f=p[G]();if(Array.isArray(f)&&C){i=f.indexOf(C)+1;}else{i=0;}}return i;};
U.createFieldLabelId=function(p,e,s){return(p.getId()+"_"+e+"_"+s).replace("/","_");};
U.getElementBindingPaths=function(e){var p={};if(e.mBindingInfos){for(var i in e.mBindingInfos){var P=e.mBindingInfos[i].parts[0].path?e.mBindingInfos[i].parts[0].path:"";P=P.split("/")[P.split("/").length-1];p[P]={valueProperty:i};}}return p;};
U.isOriginalFioriToolbarAccessible=function(){var r=U.getFiori2Renderer();return r&&r.getRootControl&&r.getRootControl().getOUnifiedShell().getHeader();};
U.getFiori2Renderer=function(){var C=a.getUshellContainer()||{};return typeof C.getRenderer==="function"?C.getRenderer("fiori2"):undefined;};
U.extendWith=function(e,s,C){if(!(typeof C==="function")){throw new Error('In order to use extendWith() utility function fnCustomizer should be provided!');}for(var S in s){if(s.hasOwnProperty(S)){if(C(e[S],s[S],S,e,s)){e[S]=s[S];}}}};
U.isElementInViewport=function(o){if(o instanceof q){o=o.get(0);}var r=o.getBoundingClientRect();return(r.top>=0&&r.left>=0&&r.bottom<=(window.innerHeight||document.documentElement.clientHeight)&&r.right<=(window.innerWidth||document.documentElement.clientWidth));};
U.showMessageBox=function(s,e,p){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta",true).then(function(r){p=p||{};var f=r.getText(e,p.error?[p.error.userMessage||p.error.message||p.error]:undefined);var t=p.titleKey&&r.getText(p.titleKey);var o=_(p,["titleKey","error"]);o.title=t;o.styleClass=U.getRtaStyleClassName();return m(s,f,o);});};
function m(s,e,o){return new Promise(function(r){o.onClose=r;c[s](e,o);});}
U.checkSourceTargetBindingCompatibility=function(s,t,o){o=o||s.getModel();var S=B.collectBindingPaths(s,o);var e;var T;if(S.bindingPaths.length===0){return true;}e=B.getBindingContextPath(s);T=B.getBindingContextPath(t);if(e===T){return true;}return false;};
U.doIfAllControlsAreAvailable=function(C,f){if(C.every(function(o){return o&&!o._bIsBeingDestroyed;})){return f();}};
U.buildHashMapFromArray=function(A,k,v){return A.reduce(function(e,i){e[i[k]]=i[v];return e;},{});};
U.checkTargetZone=function(A,o,p,e){function H(A,f,r,p){var g=A.getDesignTimeMetadata();var i=g.getAction("move",f);if(!i){return Promise.resolve(false);}return p.hasChangeHandler(i.changeType,r);}return E.checkTargetZone(A,o,e).then(function(t){if(!t){return false;}var f=o.getElement();var T=A.getParent();var g=o.getRelevantContainer();if(!f||!T){return false;}var i=T.getElement();var j=A.getDesignTimeMetadata();var v=M.getRelevantContainerForPropagation(j.getData(),f);v=v||i;if(!g||!v||!h(T)||g!==v){return false;}if(o.getParent().getElement()!==i&&!U.checkSourceTargetBindingCompatibility(f,i)){return false;}return H(A,f,v,p);});};
return U;},true);
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantDialog',["sap/m/Button","sap/m/Dialog","sap/m/DialogRenderer","sap/m/GenericTile","sap/m/ImageContent","sap/m/Input","sap/m/Label","sap/m/SelectDialog","sap/m/StandardListItem","sap/m/TextArea","sap/m/TileContent","sap/m/VBox","sap/ui/core/library","sap/ui/core/IconPool","sap/ui/core/Title","sap/ui/layout/form/SimpleForm","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/json/JSONModel","sap/ui/rta/Utils","sap/ui/layout/form/ResponsiveGridLayout"],function(B,D,a,G,I,b,L,S,c,T,d,V,e,f,g,h,F,i,J,R){"use strict";var j=e.ValueState;var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var o;var t;var k;var s;var l;var m;var n;var p;var q;var u;var v;var C;var w;
function _(){o=new G("tile",{header:"{/title}",subheader:"{/subtitle}",ariaLabel:r.getText("APP_VARIANT_TILE_ARIA_LABEL"),tileContent:[new d({content:[new I({src:"{/icon}"})]})]}).addStyleClass("sapUiMediumMarginBegin").addStyleClass("sapUiTinyMarginTop").addStyleClass("sapUiTinyMarginBottom");}
function x(M){var N=M.getParameter("value");var O=new F("name",i.Contains,N);var P=M.getSource().getBinding("items");P.filter([O]);}
function y(M){var N=M.getParameter("selectedContexts");if(N&&N.length){N.forEach(function(O){var P=O.getObject().name;q.setValue(P);C.setProperty("/icon",O.getObject().icon);});}M.getSource().getBinding("items").filter([]);}
function z(){if(!v){v=new S("selectDialog",{noDataText:r.getText("APP_VARIANT_ICON_NO_DATA"),title:r.getText("APP_VARIANT_ICON_SELECT_ICON"),search:function(N){x(N);},confirm:function(N){y(N);},cancel:function(N){y(N);}});}v.addStyleClass(R.getRtaStyleClassName());v.bindAggregation("items",{path:"/icons",template:new c({title:"{name}",description:"",icon:"{icon}",iconDensityAware:false,iconInset:false,type:"Active"})});var U=f.getIconNames();var M=[];U.forEach(function(N){var O=f.getIconInfo(N);M.push({icon:O.uri,name:(O.text==="")?N.toLowerCase():O.text});});w.setProperty("/icons",M);v.setModel(w);v.getBinding("items").filter([]);v.open();}
function A(){t=new L({required:true,text:r.getText("APP_DIALOG_TITLE_TEXT"),textAlign:"Left"});k=new b("titleInput",{value:"{/title}",valueLiveUpdate:true,placeholder:r.getText("SAVE_AS_DIALOG_PLACEHOLDER_TITLE_TEXT"),liveChange:function(){var M=sap.ui.getCore().byId("saveButton");if(this.getValue()===""){this.setValueState(j.Error);M.setEnabled(false);}else{this.setValueState(j.None);M.setEnabled(true);}}});s=new L({text:r.getText("APP_DIALOG_SUB_TITLE_TEXT"),textAlign:"Left"});l=new b({value:"{/subtitle}",valueLiveUpdate:true});m=new L({text:r.getText("APP_DIALOG_DESCRIPTION_TEXT"),textAlign:"Left"});n=new T({rows:4});p=new L({text:r.getText("APP_DIALOG_ICON_TEXT"),textAlign:"Left"});q=new b("selectInput",{showValueHelp:true,liveChange:function(M){z(M);},valueHelpRequest:function(M){z(M);},value:"{/iconname}",valueLiveUpdate:true});}
function E(){u=new h({editable:true,layout:"ResponsiveGridLayout",labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:4,adjustLabelSpan:false,emptySpanXL:0,emptySpanL:0,emptySpanM:0,emptySpanS:0,columnsXL:2,columnsL:2,columnsM:2,singleContainerFullSize:false,content:[new g("title1"),t,k,s,l,p,q,m,n,new g("title2"),o]});return u;}
function H(){var M=new V({items:[E()]}).addStyleClass("sapUISmallMargin");return M;}
var K=D.extend("sap.ui.rta.appVariant.AppVariantDialog",{
metadata:{library:"sap.ui.rta",events:{create:{},cancel:{}}},
init:function(){D.prototype.init.apply(this);this.setTitle(r.getText("CREATE_APP_VARIANT_DIALOG_TITLE"));this.setContentWidth("700px");this.setContentHeight("250px");C=new J({title:null,subtitle:null,icon:" ",iconname:null});w=new J({icons:null});sap.ui.getCore().setModel(C);_();A();this.addContent(H());this._createButtons();this.addStyleClass(R.getRtaStyleClassName());},
onAfterRendering:function(){document.getElementById('title1').style.height="0px";document.getElementById('title2').style.height="0px";document.getElementById('tile').style.float="left";},
_onCreate:function(){var M=k.getValue()||" ";var N=l.getValue()||" ";var O=n.getValue()||" ";var P=q.getValue()?f.getIconInfo(q.getValue()).uri:" ";this.fireCreate({title:M,subTitle:N,description:O,icon:P});this.close();this.destroy();},
_createButtons:function(){this.addButton(new B("saveButton",{text:r.getText("APP_VARIANT_DIALOG_SAVE"),tooltip:r.getText("TOOLTIP_APP_VARIANT_DIALOG_SAVE"),enabled:false,press:function(){this._onCreate();}.bind(this)}));this.addButton(new B({text:r.getText("SAVE_AS_APP_VARIANT_DIALOG_CANCEL"),tooltip:r.getText("TOOLTIP_SAVE_AS_APP_VARIANT_DIALOG_CANCEL"),press:function(){this.fireCancel();this.close();this.destroy();}.bind(this)}));},
destroy:function(){if(C){C.destroy();}D.prototype.destroy.apply(this,arguments);},
renderer:a
});
return K;});
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantManager',["sap/ui/base/ManagedObject","sap/ui/rta/appVariant/AppVariantDialog","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/rta/appVariant/Feature","sap/ui/rta/appVariant/S4HanaCloudBackend"],function(M,A,a,R,S){"use strict";
var b=M.extend("sap.ui.rta.appVariant.AppVariantManager",{metadata:{library:"sap.ui.rta",properties:{commandSerializer:{type:"object"},layer:{type:"string"}}}});
b.prototype._openDialog=function(c,C){var d=new A("appVariantDialog");d.attachCreate(c);d.attachCancel(C);d.attachAfterClose(function(){this.destroy();});d.open();return d;};
b.prototype._prepareAppVariantData=function(d,p){return{referenceAppId:d["sap.app"].id,title:p.title,subTitle:p.subTitle,description:p.description,icon:p.icon,inbounds:d["sap.app"].crossNavigation&&d["sap.app"].crossNavigation.inbounds?d["sap.app"].crossNavigation.inbounds:null};};
b.prototype.createAllInlineChanges=function(o,s){var c=a.getId(o.referenceAppId);var d=[];var p={};p.content=a.prepareTextsChange("title",o.title);d.push(a.createInlineChange(p,"appdescr_app_setTitle",s));p.content=a.prepareTextsChange("subtitle",o.subTitle);d.push(a.createInlineChange(p,"appdescr_app_setSubTitle",s));p.content=a.prepareTextsChange("description",o.description);d.push(a.createInlineChange(p,"appdescr_app_setDescription",s));p=a.getInlineChangeInputIcon(o.icon);d.push(a.createInlineChange(p,"appdescr_ui_setIcon",s));return a.getInboundInfo(o.inbounds).then(function(i){var C=i.currentRunningInbound;if(i.addNewInboundRequired){var I=a.prepareAddNewInboundChange(C,c,o).then(function(p){return a.createInlineChange(p,"appdescr_app_addNewInbound",s);});d.push(I);p=a.prepareRemoveAllInboundsExceptOneChange(C);d.push(a.createInlineChange(p,"appdescr_app_removeAllInboundsExceptOne",s));}else{p=a.prepareChangeInboundChange(C,c,o);d.push(a.createInlineChange(p,"appdescr_app_changeInbound",s));}return Promise.all(d);});};
b.prototype.createAppVariant=function(s,v){var p={id:s,layer:this.getLayer()};return a.createAppVariant(v,p);};
b.prototype.deleteAppVariant=function(s){return a.deleteAppVariant({appId:s},this.getLayer());};
b.prototype.processSaveAsDialog=function(d,s){return new Promise(function(r,c){var C=function(o){var p=o.getParameters();var e=this._prepareAppVariantData(d,p);r(e);}.bind(this);var f=function(){if(!s){return R.onGetOverview(true,this.getLayer());}c();}.bind(this);return this._openDialog(C,f);}.bind(this));};
b.prototype._clearRTACommandStack=function(){return this.getCommandSerializer().clearCommandStack();};
b.prototype.clearRTACommandStack=function(c){var C=this.getCommandSerializer().getCommandStack();if(c&&C.getAllExecutedCommands().length){return this._clearRTACommandStack();}return Promise.resolve();};
b.prototype.triggerCatalogPublishing=function(s,r,c){var t=c?a.triggerCatalogAssignment:a.triggerCatalogUnAssignment;return t(s,this.getLayer(),r).catch(function(e){var m=c?"MSG_CATALOG_ASSIGNMENT_FAILED":"MSG_DELETE_APP_VARIANT_FAILED";return a.catchErrorDialog(e,m,s);});};
b.prototype.notifyKeyUserWhenPublishingIsReady=function(i,s,c){var o=new S();return o.notifyFlpCustomizingIsReady(i,c).catch(function(e){var m=c?"MSG_TILE_CREATION_FAILED":"MSG_DELETE_APP_VARIANT_FAILED";if(!c&&e.error==="locked"){m="MSG_CATALOGS_LOCKED";}return a.catchErrorDialog(e,m,s);});};
b.prototype.showSuccessMessage=function(s){return a.showRelevantDialog(s,true);};
return b;},true);
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantOverviewDialog',["sap/ui/core/ComponentContainer","sap/m/Button","sap/m/Dialog","sap/m/DialogRenderer","sap/ui/rta/appVariant/manageApps/webapp/Component","sap/ui/rta/Utils"],function(C,B,D,a,M,R){"use strict";
var A=D.extend("sap.ui.rta.appVariant.AppVariantOverviewDialog",{
metadata:{library:"sap.ui.rta",properties:{idRunningApp:"string",isOverviewForKeyUser:{type:"boolean"},layer:"string"},events:{cancel:{}}},
constructor:function(){D.prototype.constructor.apply(this,arguments);this._oTextResources=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");this.oManageAppsComponent=new M("sap.ui.rta.appVariant.manageApps",{idRunningApp:this.getIdRunningApp(),isOverviewForKeyUser:this.getIsOverviewForKeyUser(),layer:this.getLayer()});this.oManageAppsComponentContainer=new C({component:this.oManageAppsComponent});this.addContent(this.oManageAppsComponentContainer);this._createButton();this.setContentWidth("1000px");this.setContentHeight("450px");this.setHorizontalScrolling(false);this.setTitle(this._oTextResources.getText("APP_VARIANT_OVERVIEW_DIALOG_TITLE"));this.addStyleClass(R.getRtaStyleClassName());},
destroy:function(){D.prototype.destroy.apply(this,arguments);},
renderer:a
});
A.prototype._createButton=function(){this.addButton(new B({text:this._oTextResources.getText("APP_VARIANT_DIALOG_CLOSE"),press:function(){this.close();this.fireCancel();}.bind(this)}));};
return A;});
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantUtils',["sap/ui/fl/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/core/BusyIndicator","sap/base/util/uid","sap/base/Log","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/write/api/AppVariantWriteAPI","sap/ui/fl/write/api/ChangesWriteAPI"],function(F,M,R,B,u,L,P,A,C){"use strict";var a={};var H=56;a._newAppVariantId=null;
a.getManifirstSupport=function(r){var m='/sap/bc/ui2/app_index/ui5_app_mani_first_supported/?id='+r;return new Promise(function(b,c){var x=new XMLHttpRequest();x.open("GET",m);x.send();x.onload=function(){if(x.status>=200&&x.status<400){b(x.response);}else{c({status:x.status,message:x.statusText});}};});};
a.getNewAppVariantId=function(){return a._newAppVariantId;};
a.setNewAppVariantId=function(n){a._newAppVariantId=n;};
a.trimIdIfRequired=function(i){if(i.length>H){var I=i.split('.');var t;var g=I[I.length-1].length;var G=I.pop();t=I.join(".");if(t.length>g){t=t.substring(0,t.length-g);}else{return i.substr(0,H);}if(t[t.length-1]==='.'){t=t+G;}else{t=t+"."+G;}return this.trimIdIfRequired(t);}return i;};
a.getId=function(b){var c;var i=b.split('.');if(i[0]!=="customer"){i[0]="customer."+i[0];}var r=false;var d=/^id.*/i;i.forEach(function(s,e,f){if(s.match(d)){s=s.replace(d,u().replace(/-/g,"_"));f[e]=s;r=true;}});c=i.join(".");if(!r){c=c+"."+u().replace(/-/g,"_");}c=this.trimIdIfRequired(c);this.setNewAppVariantId(c);return c;};
a.createAppVariant=function(s,p){p.version="1.0.0";return A.saveAs(Object.assign({selector:s},p));};
a.getInlineChangeInput=function(v,c){return{type:"XTIT",maxLength:50,comment:c,value:{"":v}};};
a.prepareTextsChange=function(p,s){var c="New "+p+" entered by a key user via RTA tool";return this.getInlineChangeInput(s,c);};
a.getInlineChangeInputIcon=function(i){return{content:{icon:i}};};
a.prepareRemoveAllInboundsExceptOneChange=function(i){return{content:{inboundId:i}};};
a.getInboundInfo=function(i){var I={};if(!i){I.currentRunningInbound="customer.savedAsAppVariant";I.addNewInboundRequired=true;return Promise.resolve(I);}return F.getUShellService("URLParsing").then(function(U){return F.getParsedURLHash(U);}).then(function(p){var b=Object.keys(i);var c=[];if(b.length===1&&b[0]==="customer.savedAsAppVariant"){return{currentRunningInbound:"customer.savedAsAppVariant",addNewInboundRequired:false};}b.forEach(function(s){if((i[s].action===p.action)&&(i[s].semanticObject===p.semanticObject)){c.push(s);}});switch(c.length){case 0:I.currentRunningInbound="customer.savedAsAppVariant";I.addNewInboundRequired=true;break;case 1:I.currentRunningInbound=c[0];I.addNewInboundRequired=false;break;default:I.currentRunningInbound="customer.savedAsAppVariant";I.addNewInboundRequired=true;break;}return I;});};
a.getInboundPropertiesKey=function(s,c,p){return s+"_sap.app.crossNavigation.inbounds."+c+"."+p;};
a.getInlineChangeForInboundPropertySaveAs=function(c,s){return{inboundId:c,entityPropertyChange:{propertyPath:"signature/parameters/sap-appvar-id",operation:"UPSERT",propertyValue:{required:true,filter:{value:s,format:"plain"},launcherValue:{value:s}}}};};
a.prepareAddNewInboundChange=function(c,s,o){return F.getUShellService("URLParsing").then(function(U){return F.getParsedURLHash(U);}).then(function(p){var b={content:{inbound:{}},texts:{}};var i=this.getInboundPropertiesKey(o.referenceAppId,c,"title");var I=this.getInboundPropertiesKey(o.referenceAppId,c,"subTitle");b.content.inbound[c]={semanticObject:p.semanticObject,action:p.action,title:"{{"+i+"}}",subTitle:"{{"+I+"}}",icon:o.icon,signature:{parameters:{"sap-appvar-id":{required:true,filter:{value:s,format:"plain"},launcherValue:{value:s}}},additionalParameters:"ignored"}};b.texts[i]=this.prepareTextsChange("title",o.title);b.texts[I]=this.prepareTextsChange("subTitle",o.subTitle);return b;}.bind(this));};
a.prepareChangeInboundChange=function(c,s,o){var p={content:{},texts:{}};var i=this.getInboundPropertiesKey(o.referenceAppId,c,"title");var I=this.getInboundPropertiesKey(o.referenceAppId,c,"subTitle");p.content={inboundId:c,entityPropertyChange:[{propertyPath:"signature/parameters/sap-appvar-id",operation:"UPSERT",propertyValue:{required:true,filter:{value:s,format:"plain"},launcherValue:{value:s}}},{propertyPath:"title",operation:"UPSERT",propertyValue:"{{"+i+"}}"},{propertyPath:"subTitle",operation:"UPSERT",propertyValue:"{{"+I+"}}"},{propertyPath:"icon",operation:"UPSERT",propertyValue:o.icon}]};p.texts[i]=this.prepareTextsChange("title",o.title);p.texts[I]=this.prepareTextsChange("subTitle",o.subTitle);return p;};
a.createInlineChange=function(p,i,s){var c={changeType:i,content:p.content};if(p.texts){c.texts=p.texts;}return C.create({changeSpecificData:c,selector:s});};
a.addChangesToPersistence=function(b,s){b.forEach(function(c){return P.add({change:c,selector:s});});return Promise.resolve();};
a.getTransportInput=function(p,n,N,t){return{getPackage:function(){return p;},getNamespace:function(){return n;},getId:function(){return N;},getDefinition:function(){return{fileType:t};}};};
a.triggerCatalogAssignment=function(s,l,r){return A.assignCatalogs({selector:{appId:s},action:"assignCatalogs",assignFromAppId:r,layer:l});};
a.triggerCatalogUnAssignment=function(s,l){return A.unassignCatalogs({selector:{appId:s},action:"unassignCatalogs",layer:l});};
a.isS4HanaCloud=function(s){return s.isAtoEnabled()&&s.isAtoAvailable();};
a.copyId=function(i){var t=document.createElement("textarea");t.value=i;document.body.appendChild(t);t.select();document.execCommand('copy');document.body.removeChild(t);return true;};
a.getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};
a.getText=function(m,t){var T=this.getTextResources();return t?T.getText(m,t):T.getText(m);};
a._getErrorMessageText=function(e){var E;if(e.messages&&e.messages.length){E=e.messages.map(function(e){return e.text;}).join("\n");}else if(e.iamAppId){E="IAM App Id: "+e.iamAppId;}else{E=e.stack||e.message||e.status||e;}return E;};
a.buildErrorInfo=function(m,e,s){var E=this._getErrorMessageText(e);var b=a.getText(m)+"\n\n";if(s){b+=a.getText("MSG_APP_VARIANT_ID",s)+"\n";}b+=a.getText("MSG_TECHNICAL_ERROR",E);L.error("App variant error: ",E);return{text:b,appVariantId:s,error:true};};
a.buildSuccessInfo=function(s,S,i){var b=i?"CLOUD":"ON_PREMISE";var o=S?"":"_OVERVIEW_LIST";var t=i?undefined:s;var m=a.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE")+"\n\n";m+=a.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_"+b+"_MESSAGE"+o,t);return{text:m,appVariantId:s,copyId:!i};};
a.buildFinalSuccessInfoS4HANACloud=function(){var m=a.getText("MSG_SAVE_APP_VARIANT_NEW_TILE_AVAILABLE");return{text:m};};
a.buildDeleteSuccessMessage=function(s,i){var m=i?"DELETE_APP_VARIANT_SUCCESS_MESSAGE_CLOUD":"DELETE_APP_VARIANT_SUCCESS_MESSAGE";var b=a.getText(m,s);return{text:b};};
a.showRelevantDialog=function(i,s){B.hide();var t;var r;var o;var c;var b=[];if(s){t=this.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE_TITLE");r=this.getText("SAVE_APP_VARIANT_OK_TEXT");}else{t=this.getText("HEADER_SAVE_APP_VARIANT_FAILED");r=this.getText("SAVE_APP_VARIANT_CLOSE_TEXT");}if(i&&i.copyId){c=this.getText("SAVE_APP_VARIANT_COPY_ID_TEXT");b.push(c);}else if(i&&i.deleteAppVariant){t=this.getText("DELETE_APP_VARIANT_INFO_MESSAGE_TITLE");o=this.getText("DELETE_APP_VARIANT_OK_TEXT");b.push(o);r=this.getText("DELETE_APP_VARIANT_CLOSE_TEXT");}b.push(r);return new Promise(function(d,e){var f=function(g){if(g===c){a.copyId(i.appVariantId);}if(s){d();}else if(i.overviewDialog){d(false);}else if(i.deleteAppVariant&&g===o){d();}else if(i.deleteAppVariant&&g===r){e(i.deleteAppVariant);}else if(i.error){e(i.error);}else{d();}};M.show(i.text,{icon:(s||i.deleteAppVariant)?M.Icon.INFORMATION:M.Icon.ERROR,onClose:f,title:t,actions:b,styleClass:R.getRtaStyleClassName()});});};
a.closeOverviewDialog=function(){sap.ui.getCore().getEventBus().publish("sap.ui.rta.appVariant.manageApps.controller.ManageApps","navigate");};
a.navigateToFLPHomepage=function(){var U=F.getUshellContainer();var c;if(U){return U.getServiceAsync("AppConfiguration").then(function(o){var b=o.getCurrentApplication();c=b.componentHandle.getInstance();if(c){return U.getServiceAsync("CrossApplicationNavigation");}return undefined;}).then(function(o){if(o&&o.toExternal){o.toExternal({target:{shellHash:"#"}},c);}}).catch(function(e){throw new Error("Error navigating to FLP Homepage: "+e);});}return Promise.resolve();};
a.deleteAppVariant=function(s,l){B.hide();return A.deleteAppVariant({selector:s,layer:l});};
a.handleBeforeUnloadEvent=function(){var m=a.getText("MSG_DO_NOT_CLOSE_BROWSER");return m;};
a.showMessage=function(m){var s=a.getText(m);var i={text:s,copyId:false};return a.showRelevantDialog(i,true);};
a.catchErrorDialog=function(e,m,i){B.hide();var E=a.buildErrorInfo(m,e,i);return a.showRelevantDialog(E,false);};
return a;},true);
sap.ui.predefine('sap/ui/rta/appVariant/Feature',["sap/ui/fl/Utils","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/core/BusyIndicator","sap/base/util/UriParameters","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/appVariant/AppVariantFactory","sap/ui/fl/write/api/FeaturesAPI","sap/base/util/merge"],function(F,A,B,U,S,a,b,m){"use strict";var o;var c;var r;var C;var _;var g=function(){return F.getAppDescriptor(r);};var G=function(){return S.getInstance();};var s=function(){window.onbeforeunload=_;};var f=function(i){var M=i?"MSG_DO_NOT_CLOSE_BROWSER_CURRENTLY_ADAPTING":"MSG_DO_NOT_CLOSE_BROWSER";_=window.onbeforeunload;window.onbeforeunload=A.handleBeforeUnloadEvent;return A.showMessage(M);};var t=function(i,j){return c.triggerCatalogPublishing(i,j,true);};var T=function(i){return c.triggerCatalogPublishing(i,null,false);};var R=function(i,j){if(o){A.closeOverviewDialog();return this.onGetOverview(true,j);}else if(!o&&i){B.hide();return this.onGetOverview(true,j);}return Promise.resolve();};var d=function(i,I,j){return i?A.navigateToFLPHomepage():R.call(this,!I,j);};var e=function(i,j){if(i&&i.response&&i.response.IAMId){return c.notifyKeyUserWhenPublishingIsReady(i.response.IAMId,j,true);}return Promise.resolve();};var h=function(i,j){if(i&&i.response&&i.response.IAMId&&i.response.inProgress){return c.notifyKeyUserWhenPublishingIsReady(i.response.IAMId,j,false);}return Promise.resolve();};sap.ui.getCore().getEventBus().subscribe("sap.ui.rta.appVariant.manageApps.controller.ManageApps","navigate",function(){if(o){o.destroy();o=null;}});return{onGetOverview:function(i,l){var D=g();return new Promise(function(j){var k=function(){A.closeOverviewDialog();};sap.ui.require(["sap/ui/rta/appVariant/AppVariantOverviewDialog"],function(n){if(!o){o=new n({idRunningApp:D["sap.app"].id,isOverviewForKeyUser:i,layer:l});}o.attachCancel(k);o.oPopup.attachOpened(function(){j(o);});o.open();});});},isOverviewExtended:function(){var u=U.fromQuery(window.location.search);var M=u.get("sap-ui-xx-app-variant-overview-extended");if(!M){return false;}return M.toLowerCase()==='true';},isManifestSupported:function(){var D=g();return A.getManifirstSupport(D["sap.app"].id).then(function(i){return i.response;}).catch(function(E){var i=A.buildErrorInfo("MSG_APP_VARIANT_FEATURE_FAILED",E);i.overviewDialog=true;return A.showRelevantDialog(i,false);});},isSaveAsAvailable:function(i,j,l){r=i;C=l;var D=g();if(D["sap.app"]&&D["sap.app"].id){return b.isSaveAsAvailable(j).then(function(I){if(I){if(D["sap.app"].crossNavigation&&D["sap.app"].crossNavigation.inbounds){return A.getInboundInfo(D["sap.app"].crossNavigation.inbounds);}return A.getInboundInfo();}return undefined;}).then(function(I){return!!I;});}return Promise.resolve(false);},getAppVariantDescriptor:function(i){r=i;var D=g();if(D["sap.app"]&&D["sap.app"].id){return a.load({id:D["sap.app"].id});}return Promise.resolve(false);},_determineSelector:function(i,D){return i?r:{appId:D["sap.app"].id,appVersion:D["sap.app"].applicationVersion.version};},onSaveAs:function(i,j,k,l){var I;var n;var D=g();var p=true;if(l&&l["sap.app"].id===D["sap.app"].id){j=true;D=m({},l);l=null;}else if(l){p=false;D=m({},l);l=null;}var v=this._determineSelector(p,D);return new Promise(function(q){var P=function(){return c.processSaveAsDialog(D,i);};var u=function(K){B.show();return c.createAllInlineChanges(K,v);};var w=function(K){var L=K.slice();return A.addChangesToPersistence(L,v);};var x=function(){var K=A.getNewAppVariantId();return c.createAppVariant(K,v).catch(function(L){var M=L.messageKey;if(!M){M="MSG_SAVE_APP_VARIANT_FAILED";}return A.catchErrorDialog(L,M,K);});};var y=function(K){n=null;n=m({},K.response);return c.clearRTACommandStack(j);};var z=function(){var K=F.getUshellContainer();if(K&&j){K.setDirtyFlag(false);}};var E=function(K){z();I=A.isS4HanaCloud(K);var L=A.buildSuccessInfo(n.id,i,I);return c.showSuccessMessage(L);};var H=function(){var K=A.buildFinalSuccessInfoS4HANACloud();return c.showSuccessMessage(K);};var J=function(){B.show();if(I){var K;return f().then(function(){return t(n.id,n.reference);}).then(function(L){K=Object.assign({},L);B.hide();return d.call(this,i,null,k);}.bind(this)).then(function(){return e(K,n.id);}).then(function(){s();return H();}).then(function(){return i?q():d.call(this,i,I,k);}.bind(this));}B.hide();return d.call(this,i,I,k);};sap.ui.require(["sap/ui/rta/appVariant/AppVariantManager"],function(K){if(!c){c=new K({commandSerializer:C,layer:k});}return P().then(u).then(w).then(x).then(y).then(G).then(E).then(J.bind(this)).then(q).catch(function(L){if(!L){return false;}if(I){s();}return d.call(this,null,I,k).then(q);}.bind(this));}.bind(this));}.bind(this));},onDeleteFromOverviewDialog:function(i,j,k){var I;return new Promise(function(l){sap.ui.require(["sap/ui/rta/appVariant/AppVariantManager"],function(n){if(!c){c=new n({rootControl:r,commandSerializer:C,layer:k});}var D=function(){return c.deleteAppVariant(i).catch(function(E){if(E==='cancel'){return Promise.reject("cancel");}var M=E.messageKey;if(!M){M="MSG_DELETE_APP_VARIANT_FAILED";}return A.catchErrorDialog(E,M,i);});};var p=function(){A.closeOverviewDialog();var v=A.buildDeleteSuccessMessage(i,I);return c.showSuccessMessage(v);};var q=function(v){I=A.isS4HanaCloud(v);if(I){var w;return f(j).then(function(){return T(i);}).then(function(x){w=Object.assign({},x);return R.call(this,!j,k);}.bind(this)).then(function(){return h(w,i);});}B.show();return Promise.resolve();};var u=function(){if(I){s();}B.hide();return j?l():R.call(this,!I,I,k).then(l);};if(j){A.closeOverviewDialog();A.navigateToFLPHomepage();}return G().then(q.bind(this)).then(D).then(p).then(u.bind(this)).catch(function(E){if(E==='cancel'){return false;}if(I){s();}return R.call(this,null,I,k).then(l);}.bind(this));}.bind(this));}.bind(this));}};});
sap.ui.predefine('sap/ui/rta/appVariant/S4HanaCloudBackend',["sap/ui/base/ManagedObject","sap/ui/model/odata/v2/ODataModel","sap/base/Log"],function(M,O,L){"use strict";var m;
var S=M.extend("sap.ui.rta.appVariant.S4HanaCloudBackend",{
metadata:{library:"sap.ui.rta"},
constructor:function(){M.apply(this,arguments);}
});
S.prototype.notifyFlpCustomizingIsReady=function(i,a,c,b){var t=this;return new Promise(function(r,d){function e(n){return!isNaN(parseFloat(n))&&isFinite(n);}var f=e(c)?c:2500;var R=e(b)?b:-1;function g(){if(R===0){r({iamAppId:i,customizingIsReady:false});return;}else if(R>0){R=R-1;}this.checkCatalogCustomizingIsReady(i,a).then(function(I){if(I){r({iamAppId:i,customizingIsReady:true});}else{setTimeout(g.bind(t),f);}}).catch(function(E){var T=a?"creation":"deletion";L.error("Catalog publishing failed for app variant "+T+". AppVarStatus is "+E.message);d({iamAppId:i,error:E.message});});}setTimeout(g.bind(t),f);});};
S._isAppReady=function(a,A){var c=a.data.results;if(!Array.isArray(c)){throw new Error(a.requestUri+" returned unexpected result: "+a);}var i=c.every(function(C){return C.ActualStatus===1;});var I=c.every(function(C){return C.ActualStatus===2;});var e=c.some(function(C){return C.ActualStatus===5;});var b=c.some(function(C){return C.ActualStatus===4;});if(e||b){var t=e?"error":"locked";throw new Error(t);}return A?I:i;};
S._getODataModel=function(){if(!m){m=new Promise(function(r,a){var o=new O("/sap/opu/odata/sap/APS_IAM_APP_SRV");o.attachMetadataFailed(function(e){a(e);m=null;});o.metadataLoaded().then(function(){r(o);});});}return m;};
S._readODataModel=function(o,i){return new Promise(function(r,a){var s=function(d,R){r(R);};var f=function(e){a(e);};o.read("/aps_iam_app_ddl('"+i+"')/to_BusinessCatalogAssignment",{success:s,error:f});});};
S.prototype.checkCatalogCustomizingIsReady=function(i,a){return S._getODataModel().then(function(o){return S._readODataModel(o,i);}).then(function(A){return S._isAppReady(A,a);});};
return S;});
sap.ui.predefine('sap/ui/rta/appVariant/Utils',["sap/ui/rta/appVariant/AppVariantUtils","sap/ui/fl/registry/Settings","sap/ui/fl/Utils","sap/base/i18n/ResourceBundle","sap/ui/fl/write/api/AppVariantWriteAPI","sap/ui/core/IconPool"],function(A,S,F,R,a,I){"use strict";var U={};var m=sap.ui.require.toUrl("sap/ui/rta/appVariant/manageApps/")+"webapp";var i=R.create({url:m+"/i18n/i18n.properties"});
U._checkNavigationSupported=function(n){var u=F.getUshellContainer();return u.getServiceAsync("CrossApplicationNavigation").then(function(N){return N.getLinks(n);}).catch(function(e){throw new Error("Error retrieving ushell service CrossApplicationNavigation: "+e);});};
U._checkAppType=function(o,b){if(o&&b){return i.getText("MAA_ORIGINAL_TYPE");}else if(b){return i.getText("MAA_APP_VARIANT_TYPE");}else if(o){return i.getText("MAA_ORIGINAL_TYPE");}return undefined;};
U._calculateCurrentStatus=function(s,b){var n=A.getNewAppVariantId();if(b==='R'){return i.getText("MAA_OPERATION_IN_PROGRESS");}else if(n===s){A.setNewAppVariantId(null);if(b!=='E'){return i.getText("MAA_NEW_APP_VARIANT");}}};
U._checkMenuItemOptions=function(p,b){var o={};if(p.isKeyUser){if(p.isOriginal){o.delAppVarButtonVisibility=false;o.adaptUIButtonVisibility=false;return o;}if(p.appVarStatus==='U'||p.appVarStatus==='E'||p.appVarStatus==='R'){o.saveAsButtonEnabled=false;}o.adaptUIButtonVisibility=true;if(b){if(p.isS4HanaCloud){o.delAppVarButtonEnabled=true;o.delAppVarButtonVisibility=true;}else{o.delAppVarButtonEnabled=false;o.delAppVarButtonVisibility=true;}}else{o.delAppVarButtonVisibility=true;if(p.appVarStatus==='R'){o.delAppVarButtonEnabled=false;}else{o.delAppVarButtonEnabled=true;}}}else{o.delAppVarButtonVisibility=false;o.adaptUIButtonVisibility=false;}return o;};
U._getNavigationInfo=function(p){var n={};var s=p.startWith.semanticObject;var b=p.startWith.action;var P=p.startWith.parameters;var N={semanticObject:s,action:b,params:P};return this._checkNavigationSupported(N).then(function(r){var d;if(r.length&&p.isKeyUser){n.adaptUIButtonEnabled=true;if(p.appVarStatus==='R'||p.appVarStatus==='U'||p.appVarStatus==='E'){n.adaptUIButtonEnabled=false;n.appVarStatus=p.appVarStatus;}}else{n.adaptUIButtonEnabled=false;}d=this._checkMenuItemOptions(p,n.adaptUIButtonEnabled);n.semanticObject=s;n.action=b;if(P){Object.keys(P).forEach(function(c){if(P[c].value){P[c]=P[c].value;}});n.params=P;}n=Object.assign({},n,d);return n;}.bind(this));};
U._prepareAppVariantAttributes=function(o){return{appId:o.appId,title:o.title||'',subTitle:o.subTitle||'',description:o.description||'',icon:o.iconUrl||'',iconText:o.iconText,isOriginal:o.isOriginal,isAppVariant:o.isAppVariant,descriptorUrl:o.descriptorUrl,appVarStatus:o.appVarStatus};};
U.getAppVariantOverviewAttributes=function(o,k){var b;var s=o.iconUrl;if(s&&I.isIconURI(s)){o.iconText=s.split('//')[1];}b=this._prepareAppVariantAttributes(o);b.isKeyUser=k;b.typeOfApp=this._checkAppType(o.isOriginal,o.isAppVariant);b.currentStatus=this._calculateCurrentStatus(o.appId,o.appVarStatus);var c;return S.getInstance().then(function(d){c=A.isS4HanaCloud(d);b.isS4HanaCloud=c;var p={isKeyUser:k,isOriginal:o.isOriginal,isS4HanaCloud:c,appVarStatus:o.appVarStatus};if(o.hasStartableIntent){p.startWith=o.startWith;return this._getNavigationInfo(p).then(function(n){b=Object.assign({},b,n);return b;});}b.adaptUIButtonEnabled=false;var D=this._checkMenuItemOptions(p,false);b=Object.assign({},b,D);return Promise.resolve(b);}.bind(this));};
U.getAppVariantOverview=function(r,k){var l=k?'CUSTOMER*':'VENDOR';var p={selector:{appId:r},layer:l};return a.listAllAppVariants(p).then(function(o){var b=[];var c;if(o.response&&o.response.items){c=o.response.items;}else{return Promise.resolve([]);}c.forEach(function(d){if(!d.isDescriptorVariant){b.push(this.getAppVariantOverviewAttributes(d,k));}},this);return Promise.all(b).then(function(d){return d;});}.bind(this));};
U.getDescriptor=function(p){return a.getManifest(p).then(function(r){return r.response;});};
return U;},true);
sap.ui.predefine('sap/ui/rta/appVariant/manageApps/webapp/Component',["sap/ui/core/UIComponent"],function(U){"use strict";var _;var a;var b;return U.extend("sap.ui.rta.appVariant.manageApps.webapp.Component",{metadata:{manifest:"json",library:"sap.ui.rta",version:"0.9",properties:{idRunningApp:"string",isOverviewForKeyUser:{type:"boolean"},layer:"string"}},constructor:function(){_=arguments[1].idRunningApp;a=arguments[1].isOverviewForKeyUser;b=arguments[1].layer;U.prototype.constructor.apply(this,arguments);},init:function(){this.setIdRunningApp(_);this.setIsOverviewForKeyUser(a);this.setLayer(b);U.prototype.init.apply(this,arguments);}});});
sap.ui.predefine('sap/ui/rta/appVariant/manageApps/webapp/controller/ManageApps.controller',["sap/ui/core/mvc/Controller","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/rta/appVariant/manageApps/webapp/model/models","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/rta/appVariant/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/rta/appVariant/Feature","sap/ui/rta/RuntimeAuthoring","sap/ui/core/BusyIndicator","sap/base/i18n/ResourceBundle","sap/m/MessageToast"],function(C,L,F,M,A,a,b,R,c,d,B,e,f){"use strict";var _;var g;var h;var i;var m;var I;return C.extend("sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps",{onInit:function(){_=this.getOwnerComponent().getIdRunningApp();g=this.getOwnerComponent().getIsOverviewForKeyUser();h=this.getOwnerComponent().getLayer();var u=F.getUshellContainer();if(!I){this._createResourceBundle();}B.show();return Promise.resolve().then(function(){if(u){return u.getServiceAsync("CrossApplicationNavigation").then(function(o){i=o;});}return undefined;}).then(a.getAppVariantOverview.bind(a,_,g)).then(function(j){B.hide();if(j.length){return this._arrangeOverviewDataAndBindToModel(j).then(function(j){return this._highlightNewCreatedAppVariant(j);}.bind(this));}A.closeOverviewDialog();return this._showMessageWhenNoAppVariantsExist();}.bind(this)).catch(function(E){A.closeOverviewDialog();var o=A.buildErrorInfo("MSG_MANAGE_APPS_FAILED",E);o.overviewDialog=true;B.hide();return A.showRelevantDialog(o,false);});},_createResourceBundle:function(){m=sap.ui.require.toUrl("sap/ui/rta/appVariant/manageApps/")+"webapp";I=e.create({url:m+"/i18n/i18n.properties"});},_showMessageWhenNoAppVariantsExist:function(){return R.showMessageBox(b.Icon.INFORMATION,"MSG_APP_VARIANT_OVERVIEW_SAP_DEVELOPER",{titleKey:"TITLE_APP_VARIANT_OVERVIEW_SAP_DEVELOPER"});},_highlightNewCreatedAppVariant:function(j){var t=this.byId("Table1");t.focus();j.forEach(function(o,k){if(o.currentStatus===I.getText("MAA_NEW_APP_VARIANT")||o.currentStatus===I.getText("MAA_OPERATION_IN_PROGRESS")){if(t.getItems().length>=k){t.getItems()[k].focus();}}});return Promise.resolve();},_arrangeOverviewDataAndBindToModel:function(j){var k=j.filter(function(q){return q.appId===_;});var o=k[0];if(o&&o.appVarStatus!=="R"){o.currentStatus=I.getText("MAA_CURRENTLY_ADAPTING");}j=j.filter(function(q){return q.appId!==_;});j.unshift(o);var r=j.filter(function(q){return q.isOriginal;});var l=r[0];j=j.filter(function(q){return!q.isOriginal;});j.unshift(l);var n={appVariants:j};var p=M.createModel(n);this.getView().setModel(p);return Promise.resolve(j);},formatRowHighlight:function(v){if(v===I.getText("MAA_CURRENTLY_ADAPTING")){return"Success";}else if(v===I.getText("MAA_NEW_APP_VARIANT")){return"Information";}else if(v===I.getText("MAA_OPERATION_IN_PROGRESS")){return"Warning";}return"None";},formatDelButtonTooltip:function(D,j){if(!I){this._createResourceBundle();}if(!D&&!j){return I.getText("TOOLTIP_DELETE_APP_VAR");}return undefined;},formatAdaptUIButtonTooltip:function(j,s){if(!I){this._createResourceBundle();}if(!j){switch(s){case'R':return I.getText("TOOLTIP_ADAPTUI_STATUS_RUNNING");case'U':return I.getText("TOOLTIP_ADAPTUI_STATUS_UNPBLSHD_ERROR");case'E':return I.getText("TOOLTIP_ADAPTUI_STATUS_UNPBLSHD_ERROR");case'P':return I.getText("TOOLTIP_ADAPTUI_STATUS_PUBLISHED");case undefined:return I.getText("TOOLTIP_ADAPTUI_ON_PREMISE");default:}}},formatAdaptUIButtonVisibility:function(v,k){return v&&k;},getModelProperty:function(s,j){return this.getView().getModel().getProperty(s,j);},onMenuAction:function(E){var o=E.getParameter("item");var s="";while(o instanceof sap.m.MenuItem){s=o.getText()+" > "+s;o=o.getParent();}s=s.substr(0,s.lastIndexOf(" > "));if(!I){this._createResourceBundle();}if(s===I.getText("MAA_DIALOG_ADAPT_UI")){return this.handleUiAdaptation(E);}else if(s===I.getText("MAA_DIALOG_COPY_ID")){return this.copyId(E);}else if(s===I.getText("MAA_DIALOG_DELETE_APPVAR")){return this.deleteAppVariant(E);}else if(s===I.getText("MAA_DIALOG_SAVE_AS_APP")){return this.saveAsAppVariant(E);}return undefined;},handleUiAdaptation:function(E){var s=this.getModelProperty("semanticObject",E.getSource().getBindingContext());var j=this.getModelProperty("action",E.getSource().getBindingContext());var p=this.getModelProperty("params",E.getSource().getBindingContext());var n;if(s&&j&&p){n={target:{semanticObject:s,action:j},params:p,writeHistory:false};d.enableRestart(L.CUSTOMER);if(i){i.toExternal(n);}A.closeOverviewDialog();return true;}return false;},saveAsAppVariant:function(E){A.closeOverviewDialog();var D=this.getModelProperty("descriptorUrl",E.getSource().getBindingContext());B.show();return a.getDescriptor({appVarUrl:D,layer:h}).then(function(o){B.hide();return c.onSaveAs(false,false,h,o);});},copyId:function(E){var s=this.getModelProperty("appId",E.getSource().getBindingContext());A.copyId(s);f.show(I.getText("MAA_COPY_ID_SUCCESS"));},deleteAppVariant:function(E){var o={};if(!I){this._createResourceBundle();}var s=I.getText("MSG_APP_VARIANT_DELETE_CONFIRMATION");o.text=s;o.deleteAppVariant=true;var j=this.getModelProperty("appId",E.getSource().getBindingContext());var k=this.getModelProperty("currentStatus",E.getSource().getBindingContext());var l=k===I.getText("MAA_CURRENTLY_ADAPTING");return A.showRelevantDialog(o).then(function(){return c.onDeleteFromOverviewDialog(j,l,h);}).catch(function(){return true;});}});});
sap.ui.predefine('sap/ui/rta/appVariant/manageApps/webapp/model/models',["sap/ui/model/json/JSONModel"],function(J){"use strict";return{createModel:function(d){var m=new J(d);m.setDefaultBindingMode("OneWay");return m;}};});
sap.ui.predefine('sap/ui/rta/command/AddIFrame',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var A=F.extend("sap.ui.rta.command.AddIFrame",{metadata:{library:"sap.ui.rta",properties:{baseId:{type:"string",group:"content"},targetAggregation:{type:"string",group:"content"},index:{type:"int",group:"content"},url:{type:"string",group:"content"},width:{type:"string",group:"content"},height:{type:"string",group:"content"},changeType:{type:"string",defaultValue:"addIFrame"}},associations:{},events:{}}});
A.prototype.applySettings=function(s){var S={};Object.keys(s).filter(function(b){return b!=="url";}).forEach(function(b){S[b]=s[b];});var a=[].slice.call(arguments);a[0]=S;F.prototype.applySettings.apply(this,a);this.setUrl(s.url);};
A.prototype._getChangeSpecificData=function(){var c=F.prototype._getChangeSpecificData.call(this);var C=c.changeType;delete c.changeType;return{changeType:C,content:c};};
return A;},true);
sap.ui.predefine('sap/ui/rta/command/AddProperty',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var A=F.extend("sap.ui.rta.command.AddProperty",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int"},newControlId:{type:"string"},bindingString:{type:"string"},entityType:{type:"string"},parentId:{type:"string"},oDataServiceVersion:{type:"string"},oDataServiceUri:{type:"string"},modelType:{type:"string"},relevantContainerId:{type:"string"},propertyName:{type:"string"}}}});
A.prototype._getChangeSpecificData=function(){return{changeType:this.getChangeType(),index:this.getIndex(),newControlId:this.getNewControlId(),bindingPath:this.getBindingString(),parentId:this.getParentId(),modelType:this.getModelType(),relevantContainerId:this.getRelevantContainerId(),oDataServiceVersion:this.getODataServiceVersion(),oDataInformation:{oDataServiceUri:this.getODataServiceUri(),propertyName:this.getPropertyName(),entityType:this.getEntityType()}};};
return A;},true);
sap.ui.predefine('sap/ui/rta/command/AddXML',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var A=F.extend("sap.ui.rta.command.AddXML",{metadata:{library:"sap.ui.rta",properties:{fragment:{type:"string",group:"content"},fragmentPath:{type:"string",group:"content"},targetAggregation:{type:"string",group:"content"},index:{type:"int",group:"content"},changeType:{type:"string",defaultValue:"addXML"}},associations:{},events:{}}});
A.prototype.bindProperty=function(n,b){if(n==="fragment"){return this.setFragment(b.bindingString);}return F.prototype.bindProperty.apply(this,arguments);};
A.prototype._applyChange=function(c){var m={};m[c.getModuleName()]=this.getFragment();sap.ui.require.preload(m);return F.prototype._applyChange.apply(this,arguments);};
return A;},true);
sap.ui.predefine('sap/ui/rta/command/AddXMLAtExtensionPoint',["sap/ui/rta/command/FlexCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/api/ExtensionPointRegistryAPI","sap/ui/fl/Utils"],function(F,J,C,E,U){"use strict";
var A=F.extend("sap.ui.rta.command.AddXMLAtExtensionPoint",{metadata:{library:"sap.ui.rta",properties:{fragment:{type:"string",group:"content"},fragmentPath:{type:"string",group:"content"},changeType:{type:"string",defaultValue:"addXMLAtExtensionPoint"}},associations:{},events:{}}});
A.prototype.bindProperty=function(n,b){if(n==="fragment"){return this.setFragment(b.bindingString);}return F.prototype.bindProperty.apply(this,arguments);};
A.prototype.getAppComponent=function(){var v=this.getSelector().view;return U.getAppComponentForControl(v);};
A.prototype._applyChange=function(c){var m={};m[c.getModuleName()]=this.getFragment();sap.ui.require.preload(m);var o=c.change||c;var a=this.getAppComponent();var s=o.getSelector();var v=J.bySelector(s.viewSelector,a);var e=E.getExtensionPointInfo({name:s.name,view:v});var S=e.targetControl;o.setExtensionPointInfo(e);var p={modifier:J,appComponent:a,view:v};return C.apply(Object.assign({change:o,element:S},p)).then(function(r){if(!r.success){return Promise.reject(r.error);}});};
return A;},true);
sap.ui.predefine('sap/ui/rta/command/AppDescriptorCommand',["sap/ui/rta/command/BaseCommand","sap/ui/fl/write/_internal/appVariant/AppVariantInlineChangeFactory","sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory"],function(B,A,D){"use strict";
var a=B.extend("sap.ui.rta.command.AppDescriptor",{metadata:{library:"sap.ui.rta",properties:{reference:{type:"string"},appComponent:{type:"object"},layer:{type:"string"},changeType:{type:"string"},parameters:{type:"object"},texts:{type:"object"}},events:{}}});
a.prototype.needsReload=true;
a.prototype.prepare=function(f){this.setLayer(f.layer);return true;};
a.prototype.getPreparedChange=function(){return this._oPreparedChange;};
a.prototype.setCompositeId=function(c){this._sCompositeId=c;};
a.prototype.createAndStoreChange=function(){return A.createDescriptorInlineChange({changeType:this.getChangeType(),content:this.getParameters(),texts:this.getTexts(),support:{compositeCommand:this._sCompositeId||""}}).then(function(o){return new D().createNew(this.getReference(),o,this.getLayer(),this.getAppComponent());}.bind(this)).then(function(o){var c=o.store();this._oPreparedChange=c;}.bind(this));};
return a;});
sap.ui.predefine('sap/ui/rta/command/BaseCommand',["sap/ui/base/ManagedObject"],function(M){"use strict";
var B=M.extend("sap.ui.rta.command.BaseCommand",{metadata:{library:"sap.ui.rta",properties:{name:{type:"string"},runtimeOnly:{type:"boolean"}},associations:{element:{type:"sap.ui.core.Element"}},events:{}}});
B.prototype.getElement=function(){var i=this.getAssociation("element");return sap.ui.getCore().byId(i);};
B.prototype.prepare=function(){return true;};
B.prototype.execute=function(){return Promise.resolve();};
B.prototype.getVariantChange=function(){return this._oVariantChange;};
B.prototype.undo=function(){return Promise.resolve();};
B.prototype.isEnabled=function(){return true;};
return B;});
sap.ui.predefine('sap/ui/rta/command/BindProperty',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var B=F.extend("sap.ui.rta.command.BindProperty",{metadata:{library:"sap.ui.rta",properties:{propertyName:{type:"string"},newBinding:{type:"string"},changeType:{type:"string",defaultValue:"propertyBindingChange"}},associations:{},events:{}}});
B.prototype.bindProperty=function(n,b){if(n==="newBinding"){return this.setNewBinding(b.bindingString);}return F.prototype.bindProperty.apply(this,arguments);};
B.prototype._getChangeSpecificData=function(){var e=this.getElement();var s={changeType:this.getChangeType(),selector:{id:e.getId(),type:e.getMetadata().getName()},content:{property:this.getPropertyName(),newBinding:this.getNewBinding()}};return s;};
return B;});
sap.ui.predefine('sap/ui/rta/command/Combine',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var C=F.extend("sap.ui.rta.command.Combine",{metadata:{library:"sap.ui.rta",properties:{source:{type:"any"},combineElements:{type:"any[]"}},associations:{},events:{}}});
C.prototype._getChangeSpecificData=function(){var f=[];this.getCombineElements().forEach(function(o){f.push(o.getId());});var s={changeType:this.getChangeType(),sourceControlId:this.getSource().getId(),combineElementIds:f};return s;};
return C;});
sap.ui.predefine('sap/ui/rta/command/CommandFactory',["sap/base/util/merge","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/Layer"],function(m,L,M,E,O,D,F,a){"use strict";
function e(J){var K=E.getAggregationInformation(J.getElement());if(K.elementId){var N=O.getOverlay(K.elementId);var P=N.getParentElementOverlay();var Q=P?!!E.getAggregationInformation(P.getElement()).templateId:false;if(Q){throw D.createError("CommandFactory#evaluateTemplateBinding","Multiple template bindings are not supported","sap.ui.rta");}var T=E.extractTemplateId(K);if(T){return{templateSelector:K.elementId,originalSelector:T,content:{boundAggregation:K.aggregation}};}}return undefined;}
function g(J,K){var N=(typeof J==="string")?sap.ui.getCore().byId(J):J;var P=O.getOverlay(N);if(P){var Q=E.getAggregationInformation(N);if(typeof K==="number"){Q.stack[0].index=K;}return E.extractTemplateId(Q);}return N.getId();}
function b(J){if(!J){throw new Error("adjustment for template failed");}}
function c(J,K){var N;var P=false;var V=false;if(typeof K==="string"){N=K;}else if(K){N=K.changeType;P=K.jsOnly===true;V=K.CAUTION_variantIndependent===true;}if(!N){return false;}J.setChangeType(N);J.setJsOnly(P);if(J.setVariantIndependent){J.setVariantIndependent(V);}else{L.error("the variant independent Flag is not available for the action used in: ",N);}return true;}
function d(J,S,K){var N={changeType:S.name};if(K){Object.assign(N,K.getAction(S.name,J));}return N;}
function f(S){S.element=sap.ui.getCore().byId(g(S.element));b(S.element);}
function h(J,S,K){var N=S.element||sap.ui.getCore().byId(S.element.id);var P=K.getActionDataFromAggregations("createContainer",N)[0];return P;}
function i(S){S.element=sap.ui.getCore().byId(g(S.element));b(S.element);S.parentId=g(S.parentId);b(S.parentId);}
function j(J,S,K){var N=S.movedElements[0].element||sap.ui.getCore().byId(S.movedElements[0].id);var P=K.getAction("move",N);return P;}
function k(S){var T=S.movedElements.map(function(J){var K=sap.ui.getCore().byId(g(J.element,J.sourceIndex));b(K);return K;});S.movedElements.forEach(function(J,K){J.element=T[K];});S.element=sap.ui.getCore().byId(g(S.element));b(S.element);S.source.parent=sap.ui.getCore().byId(g(S.source.parent));b(S.source.parent);S.target.parent=sap.ui.getCore().byId(g(S.target.parent));b(S.target.parent);}
function l(J,S,K){return K.getAction("localReset",J);}
function n(J,S,K){var R=S.renamedElement;var N=K.getAction("rename",R);return N;}
function o(S){S.element=sap.ui.getCore().byId(g(S.element));b(S.element);S.renamedElement=sap.ui.getCore().byId(g(S.renamedElement));b(S.renamedElement);}
function p(J,S,K){var R=S.removedElement;if(!R){R=J;}else if(!(R instanceof M)){throw new Error("No valid 'removedElement' found");}var N=K.getAction("remove",R);return N;}
function q(S){S.element=sap.ui.getCore().byId(g(S.element));b(S.element);S.removedElement=sap.ui.getCore().byId(g(S.removedElement));b(S.removedElement);}
function r(J,S,K){var N=S.source;var P=K.getAction("combine",N);return P;}
function s(S){S.element=sap.ui.getCore().byId(g(S.element));b(S.element);S.source=sap.ui.getCore().byId(g(S.source));b(S.source);var T=S.combineElements.map(function(J){J=sap.ui.getCore().byId(g(J));b(J);return J;});S.combineElements=T;}
function t(J,S,K){var N=S.source;var P=K.getAction("split",N);return P;}
function u(S){S.element=sap.ui.getCore().byId(g(S.element));b(S.element);S.parentElement=sap.ui.getCore().byId(g(S.parentElement));b(S.parentElement);S.source=sap.ui.getCore().byId(g(S.source));b(S.source);}
function v(J,S,K){var N=S.element;return K.getAction("add",N,"delegate");}
function w(S){S.element=sap.ui.getCore().byId(g(S.element));b(S.element);S.parentId=g(S.parentId);b(S.parentId);}
function x(J,S,K){var R=S.element;var N=K.getAction("reveal",R);return N;}
function y(S){S.element=sap.ui.getCore().byId(g(S.element));b(S.element);if(S.revealedElementId){S.revealedElementId=g(S.revealedElementId);b(S.revealedElementId);}if(S.directParent){S.directParent=sap.ui.getCore().byId(g(S.directParent));b(S.directParent);}}
function z(J,S,K){var N=K.getAction("add",S.element);if(N&&N.custom&&typeof N.custom.getItems==="function"){var P=Object.assign(N.custom,{changeOnRelevantContainer:S.changeOnRelevantContainer,changeType:S.changeType});delete S["changeOnRelevantContainer"];return P;}return undefined;}
function A(J,S,K){return K.getAction("addIFrame",S.element)||K.getActionDataFromAggregations("addIFrame",S.element)[0];}
function B(){return"propertyBindingChange";}
function C(){return"propertyChange";}
var G={composite:{clazz:"sap/ui/rta/command/CompositeCommand",noSelector:true},property:{clazz:"sap/ui/rta/command/Property",adjustForBinding:f,configure:C},bindProperty:{clazz:"sap/ui/rta/command/BindProperty",configure:B},addXML:{clazz:"sap/ui/rta/command/AddXML",configure:d,adjustForBinding:f},addXMLAtExtensionPoint:{clazz:"sap/ui/rta/command/AddXMLAtExtensionPoint",configure:d,adjustForBinding:f},createContainer:{clazz:"sap/ui/rta/command/CreateContainer",configure:h,adjustForBinding:i},move:{clazz:"sap/ui/rta/command/Move",configure:j,adjustForBinding:k},remove:{clazz:"sap/ui/rta/command/Remove",configure:p,adjustForBinding:q},localReset:{clazz:"sap/ui/rta/command/LocalReset",configure:l},rename:{clazz:"sap/ui/rta/command/Rename",configure:n,adjustForBinding:o},addDelegateProperty:{clazz:"sap/ui/rta/command/AddProperty",configure:v,adjustForBinding:w},reveal:{clazz:"sap/ui/rta/command/Reveal",configure:x,adjustForBinding:y},customAdd:{clazz:"sap/ui/rta/command/CustomAdd",configure:z},combine:{clazz:"sap/ui/rta/command/Combine",configure:r,adjustForBinding:s},split:{clazz:"sap/ui/rta/command/Split",configure:t,adjustForBinding:u},"switch":{clazz:"sap/ui/rta/command/ControlVariantSwitch"},save:{clazz:"sap/ui/rta/command/ControlVariantSave"},saveAs:{clazz:"sap/ui/rta/command/ControlVariantSaveAs"},setTitle:{clazz:"sap/ui/rta/command/ControlVariantSetTitle"},configure:{clazz:"sap/ui/rta/command/ControlVariantConfigure"},settings:{clazz:"sap/ui/rta/command/Settings"},addLibrary:{clazz:"sap/ui/rta/command/appDescriptor/AddLibrary",noSelector:true},appDescriptor:{clazz:"sap/ui/rta/command/AppDescriptorCommand",noSelector:true},addIFrame:{clazz:"sap/ui/rta/command/AddIFrame",configure:A},compVariantSaveAs:{clazz:"sap/ui/rta/command/compVariant/CompVariantSaveAs"},compVariantSwitch:{clazz:"sap/ui/rta/command/compVariant/CompVariantSwitch"},compVariantUpdate:{clazz:"sap/ui/rta/command/compVariant/CompVariantUpdate"}};
function H(J,K,S,N,P,V){var Q;K=K[0].toLowerCase()+K.slice(1);var R=G[K];var T=P;if(!R){return Promise.reject(D.createError("CommandFactory#getCommandFor","Command '"+K+"' doesn't exist, check typing","sap.ui.rta"));}return new Promise(function(U){var W=R.clazz;sap.ui.require([W],function(X){U(X);});}).then(function(U){var W=J instanceof M;if(!R.noSelector){S=Object.assign({},S,!W&&{selector:J});}S=Object.assign({},S,{element:W?J:undefined,name:K});var X;if(R.configure){X=R.configure(J,S,N);}var Y;if(W){Y=O.getOverlay(J);}if(X&&X.changeOnRelevantContainer){Object.assign(S,{element:Y.getRelevantContainer()});J=S.element;Y=O.getOverlay(J);}var Z;if(Y&&J.sParentAggregationName){Z=e(Y);}if(Z){if(R.adjustForBinding){R.adjustForBinding(S);}T=m(Z,T);}Q=new U(S);var $=true;if(R.configure){$=c(Q,X);}if($){return Q.prepare(T,V,K);}return undefined;}).then(function(U){if(U){return Q;}Q.destroy();return undefined;});}
var I=M.extend("sap.ui.rta.command.CommandFactory",{metadata:{library:"sap.ui.rta",properties:{flexSettings:{type:"object"}}}});
I.prototype.init=function(){this.setProperty("flexSettings",{layer:a.CUSTOMER,developerMode:true});};
I.prototype.setFlexSettings=function(J){this.setProperty("flexSettings",Object.assign(this.getFlexSettings(),J));};
I.prototype.getCommandFor=function(J,K,S,N,V){return H(J,K,S,N,this.getFlexSettings(),V);};
I.getCommandFor=function(J,K,S,N,P){if(!P){P={layer:a.CUSTOMER,developerMode:true};}if(P.scenario||P.baseId){var Q=F.buildLrepRootNamespace(P.baseId,P.scenario,P.projectId);P.rootNamespace=Q;P.namespace=Q+"changes/";}return H(J,K,S,N,P);};
return I;},true);
sap.ui.predefine('sap/ui/rta/command/CompositeCommand',["sap/ui/rta/command/BaseCommand","sap/ui/fl/Utils"],function(B,F){"use strict";
var C=B.extend("sap.ui.rta.command.CompositeCommand",{metadata:{library:"sap.ui.rta",properties:{},aggregations:{commands:{type:"sap.ui.rta.command.BaseCommand",multiple:true}},events:{}}});
C.prototype.execute=function(){var p=[];this._forEachCommand(function(c){p.push(c.execute.bind(c));});return F.execPromiseQueueSequentially(p,true).catch(function(e){var c=this.getCommands();c.forEach(function(o){if(o instanceof sap.ui.rta.command.FlexCommand){if(!o._aRecordedUndo){this.removeCommand(o);}}}.bind(this));return this.undo().then(function(){return Promise.reject(e);});}.bind(this));};
C.prototype.undo=function(){var p=[];this._forEachCommandInReverseOrder(function(c){p.push(c.undo.bind(c));});return F.execPromiseQueueSequentially(p);};
C.prototype._forEachCommand=function(d){var c=this.getCommands();c.forEach(d,this);};
C.prototype._forEachCommandInReverseOrder=function(d){var c=this.getCommands();for(var i=c.length-1;i>=0;i--){d.call(this,c[i]);}};
C.prototype._addCompositeIdToChange=function(c){if(!this._sCompositeId){this._sCompositeId=F.createDefaultFileName("composite");}if(c.getPreparedChange&&c.getPreparedChange()){var o=c.getPreparedChange().getDefinition();if(!o.support.compositeCommand){o.support.compositeCommand=this._sCompositeId;}}else if(c.setCompositeId){c.setCompositeId(this._sCompositeId);}};
C.prototype.addCommand=function(c,s){this._addCompositeIdToChange(c);return this.addAggregation("commands",c,s);};
C.prototype.insertCommand=function(c,i,s){this._addCompositeIdToChange(c);return this.insertAggregation("commands",c,i,s);};
return C;});
sap.ui.predefine('sap/ui/rta/command/ControlVariantConfigure',["sap/ui/rta/command/BaseCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils"],function(B,J,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantConfigure",{metadata:{library:"sap.ui.rta",properties:{control:{type:"any"},changes:{type:"array"}},associations:{},events:{}}});
C.prototype.prepare=function(F){this.sLayer=F.layer;return true;};
C.prototype.getPreparedChange=function(){if(!this._aPreparedChanges){return undefined;}return this._aPreparedChanges;};
C.prototype.execute=function(){var v=this.getControl();this.oAppComponent=f.getAppComponentForControl(v);this.oModel=this.oAppComponent.getModel(f.VARIANT_MODEL_NAME);this.sVariantManagementReference=J.getSelector(v,this.oAppComponent).id;this._aPreparedChanges=[];this.getChanges().forEach(function(c){c.appComponent=this.oAppComponent;c.generator=sap.ui.rta.GENERATOR_NAME;this._aPreparedChanges.push(this.oModel.addVariantChange(this.sVariantManagementReference,c));}.bind(this));return Promise.resolve().then(function(){this.oModel.checkUpdate(true);}.bind(this));};
C.prototype.undo=function(){var p;this.getChanges().forEach(function(c,i){p={};Object.keys(c).forEach(function(P){var O="original"+P.charAt(0).toUpperCase()+P.substr(1);if(P==="visible"){p[P]=true;}else if(c[O]){p[P]=c[O];p[O]=c[P];}else if(P.indexOf("original")===-1){p[P]=c[P];}});var o=this._aPreparedChanges[i];this.oModel.deleteVariantChange(this.sVariantManagementReference,p,o);}.bind(this));return Promise.resolve().then(function(){this.oModel.checkUpdate(true);this._aPreparedChanges=null;}.bind(this));};
return C;});
sap.ui.predefine('sap/ui/rta/command/ControlVariantSave',["sap/ui/rta/command/BaseCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils"],function(B,J,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantSave",{metadata:{library:"sap.ui.rta",properties:{model:{type:"object"}},associations:{},events:{}}});
C.prototype.prepare=function(){this.oAppComponent=f.getAppComponentForControl(this.getElement());this.sVariantManagementReference=J.getSelector(this.getElement(),this.oAppComponent).id;return true;};
C.prototype.execute=function(){var c=this.getModel().getCurrentVariantReference(this.sVariantManagementReference);this._aControlChanges=this.getModel().getVariant(c,this.sVariantManagementReference).controlChanges;this._aDirtyChanges=this.getModel()._getDirtyChangesFromVariantChanges(this._aControlChanges);this._aDirtyChanges.forEach(function(o){if(o.getFileType()==="change"){o.assignedToVariant=true;}});this.getModel().oData[this.sVariantManagementReference].modified=false;this.getModel().checkUpdate(true);return Promise.resolve();};
C.prototype.undo=function(){this._aDirtyChanges.forEach(function(c){if(c.getFileType()==="change"){c.assignedToVariant=false;}});this.getModel().checkDirtyStateForControlModels([this.sVariantManagementReference]);return Promise.resolve();};
return C;});
sap.ui.predefine('sap/ui/rta/command/ControlVariantSaveAs',["sap/ui/rta/command/BaseCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/rta/Utils","sap/ui/fl/Utils","sap/ui/fl/write/api/ContextSharingAPI"],function(B,J,r,f,C){"use strict";
var a=B.extend("sap.ui.rta.command.ControlVariantSaveAs",{metadata:{library:"sap.ui.rta",properties:{sourceVariantReference:{type:"string"},sourceDefaultVariant:{type:"string"},model:{type:"object"},newVariantParameters:{type:"object"}},associations:{},events:{}}});
a.prototype.prepare=function(F){this.oVariantManagementControl=this.getElement();this.oAppComponent=f.getAppComponentForControl(this.oVariantManagementControl);this.sVariantManagementReference=J.getSelector(this.oVariantManagementControl,this.oAppComponent).id;this.oModel=this.getModel();this.setSourceDefaultVariant(this.oModel.getData()[this.sVariantManagementReference].defaultVariant);this.sLayer=F.layer;function s(e,A){var p=e.getParameters();this.setNewVariantParameters(p);this.oVariantManagementControl.detachSave(s,this);this.oVariantManagementControl.detachCancel(h,this);A.resolve(true);}function h(e,A){this.oVariantManagementControl.detachSave(s,this);this.oVariantManagementControl.detachCancel(h,this);A.resolve(false);}return new Promise(function(b){this.oVariantManagementControl.attachSave({resolve:b},s,this);this.oVariantManagementControl.attachCancel({resolve:b},h,this);this.oVariantManagementControl.openSaveAsDialogForKeyUser(r.getRtaStyleClassName(),C.createComponent(F));}.bind(this)).then(function(S){return S;});};
a.prototype.getPreparedChange=function(){if(!this._aPreparedChanges){return undefined;}return this._aPreparedChanges;};
a.prototype.execute=function(){var s=this.getSourceVariantReference();this._aControlChanges=this.oModel.getVariant(s,this.sVariantManagementReference).controlChanges;var p=this.getNewVariantParameters();p.layer=this.sLayer;p.newVariantReference=this.sNewVariantReference;p.generator=sap.ui.rta.GENERATOR_NAME;return this.oModel._handleSave(this.oVariantManagementControl,p).then(function(d){this._aPreparedChanges=d;this._oVariantChange=d[0];this.sNewVariantReference=this._oVariantChange.getDefinition().fileName;this._aPreparedChanges.forEach(function(c){if(c.getFileType()==="change"){c.assignedToVariant=true;}});this.getModel().checkDirtyStateForControlModels([this.sVariantManagementReference]);}.bind(this));};
a.prototype.undo=function(){if(this._oVariantChange){this._aPreparedChanges.forEach(function(c){if(c.getFileType()==="ctrl_variant_management_change"){this.oModel.oFlexController.deleteChange(c,this.oAppComponent);}}.bind(this));var p={variant:this._oVariantChange,sourceVariantReference:this.getSourceVariantReference(),variantManagementReference:this.sVariantManagementReference,component:this.oAppComponent};return this.oModel.removeVariant(p,true).then(function(){this._aControlChanges.forEach(function(c){this.oModel.oFlexController.addPreparedChange(c,this.oAppComponent);var o=sap.ui.getCore().byId(J.getControlIdBySelector(c.getSelector(),this.oAppComponent));this.oModel.oFlexController.applyChange(c,o);}.bind(this));this.oModel.getData()[this.sVariantManagementReference].defaultVariant=this.getSourceDefaultVariant();this.oModel.getData()[this.sVariantManagementReference].originalDefaultVariant=this.getSourceDefaultVariant();this._aPreparedChanges=null;this._oVariantChange=null;this.getModel().checkUpdate(true);}.bind(this));}return Promise.resolve();};
return a;});
sap.ui.predefine('sap/ui/rta/command/ControlVariantSetTitle',["sap/ui/rta/command/BaseCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils"],function(B,J,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantSetTitle",{metadata:{library:"sap.ui.rta",properties:{oldText:{type:"string"},newText:{type:"string"}},associations:{},events:{}}});
C.prototype.prepare=function(F){this.sLayer=F.layer;return true;};
C.prototype.getPreparedChange=function(){this._oPreparedChange=this.getVariantChange();if(!this._oPreparedChange){return undefined;}return this._oPreparedChange;};
C.prototype.execute=function(){var v=this.getElement();var V=v.getTitle().getBinding("text");this.oAppComponent=f.getAppComponentForControl(v);this.oModel=this.oAppComponent.getModel(f.VARIANT_MODEL_NAME);this.sVariantManagementReference=J.getSelector(v,this.oAppComponent).id;this.sCurrentVariant=this.oModel.getCurrentVariantReference(this.sVariantManagementReference);var c=this.oModel.getVariantProperty(this.sCurrentVariant,"title");this.setOldText(c);var p={appComponent:this.oAppComponent,variantReference:this.sCurrentVariant,changeType:"setTitle",title:this.getNewText(),layer:this.sLayer,generator:sap.ui.rta.GENERATOR_NAME};return Promise.resolve(this.oModel.addVariantChange(this.sVariantManagementReference,p)).then(function(o){this._oVariantChange=o;V.checkUpdate(true);}.bind(this));};
C.prototype.undo=function(){var v=this.getElement().getTitle().getBinding("text");var p={variantReference:this.sCurrentVariant,changeType:"setTitle",title:this.getOldText()};var c=this._oVariantChange;return Promise.resolve(this.oModel.deleteVariantChange(this.sVariantManagementReference,p,c)).then(function(){this._oVariantChange=null;v.checkUpdate(true);}.bind(this));};
return C;});
sap.ui.predefine('sap/ui/rta/command/ControlVariantSwitch',["sap/ui/rta/command/BaseCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils"],function(B,J,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantSwitch",{metadata:{library:"sap.ui.rta",properties:{targetVariantReference:{type:"string"},sourceVariantReference:{type:"string"}},associations:{},events:{}}});
C.prototype._getAppComponent=function(){var e=this.getElement();return e?f.getAppComponentForControl(e):this.getSelector().appComponent;};
C.prototype.execute=function(){var e=this.getElement();var a=this._getAppComponent();var n=this.getTargetVariantReference();this.oModel=a.getModel(f.VARIANT_MODEL_NAME);this.sVariantManagementReference=J.getSelector(e,a).id;return this._updateModelVariant(n,a);};
C.prototype.undo=function(){var o=this.getSourceVariantReference();var a=this._getAppComponent();return this._updateModelVariant(o,a);};
C.prototype._updateModelVariant=function(v,a){if(this.getTargetVariantReference()!==this.getSourceVariantReference()){return this.oModel.updateCurrentVariant({variantManagementReference:this.sVariantManagementReference,newVariantReference:v,appComponent:a});}return Promise.resolve();};
return C;});
sap.ui.predefine('sap/ui/rta/command/CreateContainer',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var C=F.extend("sap.ui.rta.command.CreateContainer",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int",group:"content"},newControlId:{type:"string",group:"content"},label:{type:"string"},parentId:{type:"string",group:"content"}},associations:{},events:{}}});
C.prototype._getChangeSpecificData=function(){var s=F.prototype._getChangeSpecificData.apply(this);s.newLabel=this.getLabel();return s;};
return C;});
sap.ui.predefine('sap/ui/rta/command/CustomAdd',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var C=F.extend("sap.ui.rta.command.CustomAdd",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int",group:"content"},addElementInfo:{type:"object",group:"content"},aggregationName:{type:"string",group:"content"},customItemId:{type:"string",group:"content"}}}});
return C;});
sap.ui.predefine('sap/ui/rta/command/FlexCommand',["sap/ui/rta/command/BaseCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils","sap/base/Log","sap/base/util/merge","sap/ui/fl/write/api/ChangesWriteAPI","sap/base/util/values"],function(B,J,F,L,m,C,o){"use strict";
var a=B.extend("sap.ui.rta.command.FlexCommand",{metadata:{library:"sap.ui.rta",properties:{changeType:{type:"string"},jsOnly:{type:"boolean",defaultValue:false},selector:{type:"object"},variantIndependent:{type:"boolean",defaultValue:false}},associations:{},events:{}}});
a.prototype.getElementId=function(){var e=this.getElement();return e?e.getId():this.getSelector().id;};
a.prototype.getAppComponent=function(){var e=this.getElement();return e?F.getAppComponentForControl(e):this.getSelector().appComponent;};
a.prototype.prepare=function(f,v,c){var s;if(!this.getSelector()&&f&&f.templateSelector){s={id:f.templateSelector,appComponent:this.getAppComponent(),controlType:F.getControlType(sap.ui.getCore().byId(f.templateSelector))};this.setSelector(s);}else if(!this.getSelector()&&this.getElement()){s={id:this.getElement().getId(),appComponent:this.getAppComponent(),controlType:F.getControlType(this.getElement())};this.setSelector(s);}return this._createChange(f,v,c).then(function(b){this._oPreparedChange=b;return true;}.bind(this)).catch(function(e){L.error(e.message||e.name);return false;});};
a.prototype.getPreparedChange=function(){return this._oPreparedChange;};
a.prototype.execute=function(){var c=this.getPreparedChange();return this._applyChange(c);};
a.prototype._getChangeSpecificData=function(){var p=this.getMetadata().getProperties();var c={changeType:this.getChangeType()};o(p).filter(function(P){return P.group==="content";}).forEach(function(P){c[P.name]=P.get(this);},this);return c;};
a.prototype._createChange=function(f,v,c){return this._createChangeFromData(this._getChangeSpecificData(),f,v,c);};
a.prototype._createChangeFromData=function(c,f,v,s){if(f){c=m({},c,f);}c.jsOnly=this.getJsOnly();var M=this.getAppComponent().getModel(F.VARIANT_MODEL_NAME);var V;if(M&&v){V=M.getCurrentVariantReference(v);}if(V&&!this.getVariantIndependent()){var b={variantManagementReference:v,variantReference:V};c=Object.assign({},c,b);}c.command=s;c.generator=sap.ui.rta.GENERATOR_NAME;return C.create({changeSpecificData:c,selector:this._validateControlForChange(f)}).then(function(d){if(f&&f.originalSelector){d.addDependentControl(f.originalSelector,"originalSelector",{modifier:J,appComponent:this.getAppComponent()});d.getDefinition().selector=Object.assign(d.getDefinition().selector,J.getSelector(this.getSelector().id,this.getAppComponent()));d.setContent(Object.assign({},d.getContent(),f.content));}return d;}.bind(this));};
a.prototype.undo=function(){var c=this.getElement()||J.bySelector(this.getSelector());var b=this.getPreparedChange();return C.revert({change:b,element:c});};
a.prototype._applyChange=function(c){var b=c.change||c;var A=this.getAppComponent();var s=J.bySelector(b.getSelector(),A);var p={modifier:J,appComponent:A,view:F.getViewForControl(s)};return C.apply(Object.assign({change:b,element:s},p)).then(function(r){if(!r.success){return Promise.reject(r.error);}return undefined;});};
a.prototype._validateControlForChange=function(f){if(f&&f.originalSelector&&f.content&&f.content.boundAggregation){return{id:f.originalSelector,appComponent:this.getAppComponent(),controlType:F.getControlType(sap.ui.getCore().byId(f.originalSelector))};}return this.getElement()||this.getSelector();};
return a;});
sap.ui.predefine('sap/ui/rta/command/LREPSerializer',["sap/ui/base/ManagedObject","sap/ui/rta/command/FlexCommand","sap/ui/rta/command/AppDescriptorCommand","sap/ui/fl/Utils","sap/ui/fl/Change","sap/ui/dt/ElementUtil","sap/base/Log","sap/ui/fl/write/api/PersistenceWriteAPI"],function(M,F,A,a,C,E,L,P){"use strict";
var b=M.extend("sap.ui.rta.command.LREPSerializer",{metadata:{library:"sap.ui.rta",associations:{rootControl:{type:"sap.ui.core.Control"}},properties:{commandStack:{type:"object"}},aggregations:{}}});
function g(r){return E.getElementInstance(r);}
b.prototype._lastPromise=Promise.resolve();
b.prototype.setCommandStack=function(c){if(this.getCommandStack()){this.getCommandStack().removeCommandExecutionHandler(this._fnHandleCommandExecuted);}this.setProperty("commandStack",c);c.addCommandExecutionHandler(this._fnHandleCommandExecuted);};
b.prototype.init=function(){this._fnHandleCommandExecuted=this.handleCommandExecuted.bind(this);};
b.prototype.exit=function(){this.getCommandStack().removeCommandExecutionHandler(this._fnHandleCommandExecuted);};
b.prototype._isPersistedChange=function(p){return!!this.getCommandStack()._aPersistedChanges&&this.getCommandStack()._aPersistedChanges.indexOf(p.getId())!==-1;};
b.prototype.handleCommandExecuted=function(e){return(function(e){var p=e;this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var c=this.getCommandStack().getSubCommands(p.command);if(p.undo){var r=[];c.forEach(function(o){if(!(o instanceof F||o instanceof A)||o.getRuntimeOnly()){return;}var f=o.getPreparedChange();var h=o.getAppComponent();if(h){r.push(P.remove({change:f,selector:h}));}});return Promise.all(r);}var d=[];c.forEach(function(o){if(o.getRuntimeOnly()){return;}if(o instanceof F){var f=o.getAppComponent();if(f){var h=o.getPreparedChange();if(h.getState()===C.states.DELETED){h.setState(C.states.NEW);}if(!this._isPersistedChange(h)){P.add({change:o.getPreparedChange(),selector:f});}}}else if(o instanceof A){d.push(o.createAndStoreChange());}}.bind(this));return Promise.all(d);}.bind(this));return this._lastPromise;}.bind(this))(e);};
b.prototype.needsReload=function(){this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var c=this.getCommandStack().getAllExecutedCommands();return c.some(function(o){return!!o.needsReload;});}.bind(this));return this._lastPromise;};
b.prototype.saveCommands=function(s){this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var r=g(this.getRootControl());if(!r){throw new Error("Can't save commands without root control instance!");}return P.save({selector:r,skipUpdateCache:false,draft:!!s});}.bind(this)).then(function(){L.info("UI adaptation successfully transfered changes to layered repository");this.getCommandStack().removeAllCommands();}.bind(this));return this._lastPromise;};
b.prototype._triggerUndoChanges=function(){var c=this.getCommandStack();var p=[];var d=c.getAllExecutedCommands();d.forEach(function(o){p.push(o.undo.bind(o));});p=p.reverse();return a.execPromiseQueueSequentially(p,false,true);};
b.prototype.clearCommandStack=function(){var c=this.getCommandStack();c.detachCommandExecuted(this.handleCommandExecuted.bind(this));return this._triggerUndoChanges().then(function(){c.removeAllCommands();c.attachCommandExecuted(this.handleCommandExecuted.bind(this));return true;}.bind(this));};
return b;});
sap.ui.predefine('sap/ui/rta/command/LocalReset',["sap/ui/rta/command/BaseCommand","sap/ui/fl/Utils","sap/ui/fl/write/api/LocalResetAPI"],function(B,F,L){"use strict";
var a=B.extend("sap.ui.rta.command.LocalReset",{metadata:{library:"sap.ui.rta",properties:{currentVariant:{type:"string"},changeType:{type:"string"},jsOnly:{type:"boolean"}},associations:{},events:{}}});
a.prototype.prepare=function(f){var c=this.getElement();this._oAppComponent=F.getAppComponentForControl(c);this._aAffectedChanges=L.getNestedUIChangesForControl(c,{layer:f.layer,currentVariant:this.getCurrentVariant()});return Promise.resolve(true);};
a.prototype.execute=function(){return L.resetChanges(this._aAffectedChanges,this._oAppComponent);};
a.prototype.undo=function(){return L.restoreChanges(this._aAffectedChanges,this._oAppComponent);};
return a;});
sap.ui.predefine('sap/ui/rta/command/Move',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var M=F.extend("sap.ui.rta.command.Move",{metadata:{library:"sap.ui.rta",properties:{movedElements:{type:"any[]"},target:{type:"any"},source:{type:"any"}},associations:{},events:{}}});
M.prototype._getChangeSpecificData=function(){var s=this.getSource();var t=this.getTarget();if(s.parent){s.id=s.parent.getId();delete s.parent;}if(t.parent){t.id=t.parent.getId();delete t.parent;}var S={changeType:this.getChangeType(),source:s,target:t,movedElements:[]};this.getMovedElements().forEach(function(m){S.movedElements.push({id:m.id||(m.element&&m.element.getId()),sourceIndex:m.sourceIndex,targetIndex:m.targetIndex});});return S;};
return M;});
sap.ui.predefine('sap/ui/rta/command/Property',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var P=F.extend("sap.ui.rta.command.Property",{metadata:{library:"sap.ui.rta",properties:{propertyName:{type:"string"},newValue:{type:"any"},semanticMeaning:{type:"string"},changeType:{type:"string",defaultValue:"propertyChange"}},associations:{},events:{}}});
P.prototype._getChangeSpecificData=function(){var e=this.getElement();return{changeType:this.getChangeType(),selector:{id:e.getId(),type:e.getMetadata().getName()},content:{property:this.getPropertyName(),newValue:this.getNewValue(),semantic:this.getSemanticMeaning()}};};
return P;});
sap.ui.predefine('sap/ui/rta/command/Remove',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var R=F.extend("sap.ui.rta.command.Remove",{metadata:{library:"sap.ui.rta",properties:{removedElement:{type:"any"}},associations:{},events:{}}});
R.prototype._getChangeSpecificData=function(){var e=this.getRemovedElement()||this.getElement();var s={changeType:this.getChangeType(),removedElement:{id:e.getId()}};return s;};
return R;});
sap.ui.predefine('sap/ui/rta/command/Rename',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var R=F.extend("sap.ui.rta.command.Rename",{metadata:{library:"sap.ui.rta",properties:{renamedElement:{type:"object"},newValue:{type:"string",defaultValue:"new text"}},associations:{},events:{}}});
R.prototype._getChangeSpecificData=function(){var s={changeType:this.getChangeType(),renamedElement:{id:this.getRenamedElement().getId()},value:this.getNewValue()};return s;};
return R;});
sap.ui.predefine('sap/ui/rta/command/Reveal',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var R=F.extend("sap.ui.rta.command.Reveal",{metadata:{library:"sap.ui.rta",properties:{revealedElementId:{type:"string"},directParent:"object"}}});
R.prototype._getChangeSpecificData=function(){var s={changeType:this.getChangeType()};if(this.getRevealedElementId()){s.revealedElementId=this.getRevealedElementId();}return s;};
return R;});
sap.ui.predefine('sap/ui/rta/command/Settings',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var S=F.extend("sap.ui.rta.command.Settings",{metadata:{library:"sap.ui.rta",properties:{content:{type:"any",group:"content"}},associations:{},events:{}}});
S.prototype.execute=function(){if(this.getElement()){return F.prototype.execute.apply(this,arguments);}return Promise.resolve();};
S.prototype.undo=function(){if(this.getElement()){return F.prototype.undo.apply(this,arguments);}return Promise.resolve();};
return S;});
sap.ui.predefine('sap/ui/rta/command/Split',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var S=F.extend("sap.ui.rta.command.Split",{metadata:{library:"sap.ui.rta",properties:{newElementIds:{type:"string[]"},source:{type:"any"},parentElement:{type:"any"}},associations:{},events:{}}});
S.prototype._getChangeSpecificData=function(){var s={newElementIds:this.getNewElementIds(),sourceControlId:this.getSource().getId(),changeType:this.getChangeType(),parentId:this.getParentElement().getId()};return s;};
return S;});
sap.ui.predefine('sap/ui/rta/command/Stack',["sap/ui/base/ManagedObject","sap/ui/fl/Utils","sap/ui/rta/command/Settings","sap/ui/rta/command/CompositeCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/write/api/PersistenceWriteAPI"],function(M,F,S,C,J,P){"use strict";
function _(c,d,f){var o=c[f];if(o){d.push(o);}return d;}
function a(c,m,s,o){var d=o.getSelector();var e=new S({selector:d,changeType:o.getDefinition().changeType,element:J.bySelector(d,c)});e._oPreparedChange=o;if(o.getUndoOperations()){e._aRecordedUndo=o.getUndoOperations();o.resetUndoOperations();}var f=o.getDefinition().support.compositeCommand;if(f){if(!m[f]){m[f]=new C();s.pushExecutedCommand(m[f]);}m[f].addCommand(e);}else{s.pushExecutedCommand(e);}}
var b=M.extend("sap.ui.rta.command.Stack",{metadata:{library:"sap.ui.rta",properties:{},aggregations:{commands:{type:"sap.ui.rta.command.BaseCommand",multiple:true}},events:{modified:{},commandExecuted:{parameters:{command:{type:"object"},undo:{type:"boolean"}}}}}});
b.initializeWithChanges=function(c,f){var s=new b();s._aPersistedChanges=f;if(f&&f.length>0){var o=F.getComponentForControl(c);var A=F.getAppDescriptor(o)["sap.app"].id;var p={oComponent:o,appName:A,selector:c,invalidateCache:false};return P._getUIChanges(p).then(function(d){var m={};var e={};d.forEach(function(g){e[g.getDefinition().fileName]=g;});f.reduce(_.bind(null,e),[]).forEach(a.bind(null,o,m,s));return s;});}return Promise.resolve(s);};
b.prototype.addCommandExecutionHandler=function(h){this._aCommandExecutionHandler.push(h);};
b.prototype.removeCommandExecutionHandler=function(h){var i=this._aCommandExecutionHandler.indexOf(h);if(i>-1){this._aCommandExecutionHandler.splice(i,1);}};
b.prototype.init=function(){this._aCommandExecutionHandler=[];this._toBeExecuted=-1;this._oLastCommand=Promise.resolve();};
b.prototype._waitForCommandExecutionHandler=function(p){return Promise.all(this._aCommandExecutionHandler.map(function(h){return h(p);}));};
b.prototype._getCommandToBeExecuted=function(){return this.getCommands()[this._toBeExecuted];};
b.prototype.pushExecutedCommand=function(c){this.push(c,true);};
b.prototype.push=function(c,e){if(this._bUndoneCommands){this._bUndoneCommands=false;while(this._toBeExecuted>-1){this.pop();}}this.insertCommand(c,0);if(!e){this._toBeExecuted++;}this.fireModified();};
b.prototype.top=function(){return this.getCommands()[0];};
b.prototype.pop=function(){if(this._toBeExecuted>-1){this._toBeExecuted--;}return this.removeCommand(0);};
b.prototype.removeCommand=function(o,s){var r=this.removeAggregation("commands",o,s);this.fireModified();return r;};
b.prototype.removeAllCommands=function(s){var c=this.removeAllAggregation("commands",s);this._toBeExecuted=-1;this.fireModified();return c;};
b.prototype.isEmpty=function(){return this.getCommands().length===0;};
b.prototype.execute=function(){this._oLastCommand=this._oLastCommand.catch(function(){}).then(function(){var c=this._getCommandToBeExecuted();if(c){return c.execute().then(function(){this._toBeExecuted--;var p={command:c,undo:false};this.fireCommandExecuted(p);this.fireModified();return this._waitForCommandExecutionHandler(p);}.bind(this)).catch(function(e){e=e||new Error("Executing of the change failed.");e.index=this._toBeExecuted;e.command=this.removeCommand(this._toBeExecuted);this._toBeExecuted--;return Promise.reject(e);}.bind(this));}return undefined;}.bind(this));return this._oLastCommand;};
b.prototype._unExecute=function(){if(this.canUndo()){this._bUndoneCommands=true;this._toBeExecuted++;var c=this._getCommandToBeExecuted();if(c){return c.undo().then(function(){var p={command:c,undo:true};this.fireCommandExecuted(p);this.fireModified();return this._waitForCommandExecutionHandler(p);}.bind(this));}return Promise.resolve();}return Promise.resolve();};
b.prototype.canUndo=function(){return(this._toBeExecuted+1)<this.getCommands().length;};
b.prototype.undo=function(){return this._unExecute();};
b.prototype.canRedo=function(){return!!this._getCommandToBeExecuted();};
b.prototype.redo=function(){return this.execute();};
b.prototype.pushAndExecute=function(c){this.push(c);return this.execute();};
b.prototype.getAllExecutedCommands=function(){var A=[];var c=this.getCommands();for(var i=c.length-1;i>this._toBeExecuted;i--){var s=this.getSubCommands(c[i]);A=A.concat(s);}return A;};
b.prototype.getSubCommands=function(c){var d=[];if(c.getCommands){c.getCommands().forEach(function(s){var e=this.getSubCommands(s);d=d.concat(e);},this);}else{d.push(c);}return d;};
return b;});
sap.ui.predefine('sap/ui/rta/command/appDescriptor/AddLibrary',["sap/ui/rta/command/AppDescriptorCommand"],function(A){"use strict";
var a=A.extend("sap.ui.rta.command.appDescriptor.AddLibrary",{metadata:{library:"sap.ui.rta",events:{}}});
a.prototype.init=function(){this.setChangeType("appdescr_ui5_addLibraries");};
a.prototype.execute=function(){var p=[];if(this.getParameters().libraries){var l=Object.keys(this.getParameters().libraries);l.forEach(function(L){p.push(sap.ui.getCore().loadLibrary(L,true));});}return Promise.all(p);};
return a;},true);
sap.ui.predefine('sap/ui/rta/command/compVariant/CompVariantSaveAs',["sap/ui/fl/write/api/SmartVariantManagementWriteAPI","sap/ui/rta/command/BaseCommand"],function(S,B){"use strict";
var C=B.extend("sap.ui.rta.command.CompVariantSaveAs",{metadata:{library:"sap.ui.rta",properties:{newVariantProperties:{type:"object"},previousDirtyFlag:{type:"boolean"},previousVariantId:{type:"string"},previousDefault:{type:"string"}}}});
C.prototype.prepare=function(f,v,c){this.mInformation={layer:f.layer,command:c,generator:sap.ui.rta.GENERATOR_NAME};return true;};
C.prototype.getPreparedChange=function(){return this._oVariant;};
C.prototype.execute=function(){var n=this.getNewVariantProperties();var p={changeSpecificData:{id:this._oVariant?this._oVariant.getId():undefined,type:n.type,texts:{variantName:n.text},content:n.content,executeOnSelection:n.executeOnSelection,favorite:true,contexts:n.contexts,layer:this.mInformation.layer},control:this.getElement(),command:this.mInformation.command,generator:this.mInformation.generator};this._oVariant=S.addVariant(p);if(n.default){S.setDefaultVariantId(Object.assign({},this.mInformation,{control:this.getElement(),defaultVariantId:this._oVariant.getId()}));}this.getElement().addVariant(this._oVariant,n.default);this.getElement().activateVariant(this._oVariant.getId());return Promise.resolve();};
C.prototype.undo=function(){S.removeVariant({id:this._oVariant.getId(),control:this.getElement(),revert:true});if(this.getNewVariantProperties().default){S.setDefaultVariantId(Object.assign({},this.mInformation,{control:this.getElement(),defaultVariantId:this.getPreviousDefault()}));}this.getElement().removeWeakVariant({previousDirtyFlag:this.getPreviousDirtyFlag(),previousVariantId:this.getPreviousVariantId(),previousDefault:this.getPreviousDefault(),variantId:this._oVariant.getId()});return Promise.resolve();};
return C;});
sap.ui.predefine('sap/ui/rta/command/compVariant/CompVariantSwitch',["sap/ui/rta/command/BaseCommand"],function(B){"use strict";
var C=B.extend("sap.ui.rta.command.CompVariantSwitch",{metadata:{library:"sap.ui.rta",properties:{sourceVariantId:{type:"string"},targetVariantId:{type:"string"}}}});
C.prototype.execute=function(){this.getElement().activateVariant(this.getTargetVariantId());return Promise.resolve();};
C.prototype.undo=function(){this.getElement().activateVariant(this.getSourceVariantId());return Promise.resolve();};
return C;});
sap.ui.predefine('sap/ui/rta/command/compVariant/CompVariantUpdate',["sap/base/util/each","sap/ui/fl/write/api/SmartVariantManagementWriteAPI","sap/ui/rta/command/BaseCommand"],function(e,S,B){"use strict";
var C=B.extend("sap.ui.rta.command.CompVariantUpdate",{metadata:{library:"sap.ui.rta",properties:{newVariantProperties:{type:"object"},newDefaultVariantId:{type:"string"},oldDefaultVariantId:{type:"string"},onlySave:{type:"boolean"}}}});
C.prototype.prepare=function(f,v,s){this.mInformation={layer:f.layer,command:s,generator:sap.ui.rta.GENERATOR_NAME};return true;};
function c(f,k,v){var p=Object.assign({},v,this.mInformation,{id:k,control:this.getElement()});return S[f](p);}
C.prototype.execute=function(){if(this.getOnlySave()){this.getElement().setModified(false);var k=Object.keys(this.getNewVariantProperties())[0];c.call(this,"updateVariant",k,this.getNewVariantProperties()[k]);}else{e(this.getNewVariantProperties(),function(v,V){if(V.deleted){c.call(this,"removeVariant",v,{});this.getElement().removeVariant({variantId:v});}else{var o=c.call(this,"updateVariant",v,V);this.getElement().updateVariant(o);}}.bind(this));if(this.getNewDefaultVariantId()){c.call(this,"setDefaultVariantId",undefined,{defaultVariantId:this.getNewDefaultVariantId()});this.getElement().setDefaultVariantId(this.getNewDefaultVariantId());}}return Promise.resolve();};
C.prototype.undo=function(){if(this.getOnlySave()){this.getElement().setModified(true);var v=Object.keys(this.getNewVariantProperties())[0];c.call(this,"revert",v,{});}else{e(this.getNewVariantProperties(),function(v,V){var o=c.call(this,"revert",v,{});if(V.deleted){this.getElement().addVariant(o);}else{this.getElement().updateVariant(o);}}.bind(this));if(this.getNewDefaultVariantId()){c.call(this,"revertSetDefaultVariantId",this.getOldDefaultVariantId());this.getElement().setDefaultVariantId(this.getOldDefaultVariantId());}}return Promise.resolve();};
return C;});
sap.ui.predefine('sap/ui/rta/enablement/TestDelegate',["sap/base/util/isPlainObject","sap/base/util/merge"],function(i,m){"use strict";
function a(o,k){return o[k]&&typeof o[k]==="string";}
function c(p){if(!p.appComponent.isA("sap.ui.core.Component")){return false;}if(!i(p.modifier)){return false;}if(p.modifier.targets==="xmlTree"&&!a(p.view,"nodeName")){return false;}if(p.payload&&!i(p.payload)){return false;}return["aggregationName","bindingPath"].every(a.bind(null,p));}
var T={getPropertyInfo:function(p){return Promise.resolve().then(function(){var v=p.element.isA("sap.ui.core.Element")&&p.aggregationName&&typeof p.aggregationName==="string"&&(!p.payload||typeof p.payload==="object");if(v){return[];}return undefined;});},createLabel:function(p){return Promise.resolve().then(function(){var P=c(p)&&a(p,"labelFor");if(P){return p.modifier.createControl("sap.m.Label",p.appComponent,p.view,p.labelFor+"-label",{labelFor:p.labelFor,text:p.bindingPath},true);}return undefined;});},createControlForProperty:function(p){return Promise.resolve().then(function(){var P=c(p)&&(a(p.element,"nodeName")||p.element.isA("sap.ui.core.Element"))&&i(p.fieldSelector)&&a(p.fieldSelector,"id");if(P){var b=[p.modifier.createControl("sap.m.Text",p.appComponent,p.view,p.fieldSelector,{text:"{"+p.bindingPath+"}"})];if(p.payload.valueHelpId){var v=m({},p.fieldSelector,{id:p.fieldSelector.id+"-"+p.payload.valueHelpId});b.push(p.modifier.createControl("sap.ui.core.Element",p.appComponent,p.view,v,true));}return Promise.all(b).then(function(C){return{control:C[0],valueHelp:C[1]};});}return undefined;});},createLayout:function(p){var P=c(p)&&p.fieldSelector&&typeof p.fieldSelector==="object"&&typeof p.fieldSelector.id==="string";if(P){if(!p.payload.useCreateLayout){return Promise.resolve();}var l;var v;var s;var L=m({},p);var M=L.modifier;L.fieldSelector.id+="-field";return T.createControlForProperty(L).then(function(C){s=C;v=s.valueHelp;return M.createControl(L.payload.layoutType,L.appComponent,L.view,p.fieldSelector);}).then(function(C){l=C;return M.insertAggregation(l,L.payload.aggregation,s.control,0,L.view);}).then(function(){if(L.payload.labelAggregation){var C=Object.assign({labelFor:M.getId(s.control)},L);return T.createLabel(C);}return undefined;}).then(function(o){if(o){return M.insertAggregation(l,L.payload.labelAggregation,o,0,L.view);}return undefined;}).then(function(){return{control:l,valueHelp:v};});}return undefined;}};return T;});
sap.ui.predefine('sap/ui/rta/enablement/elementActionTest',["sap/ui/core/UIComponent","sap/ui/core/ComponentContainer","sap/ui/core/mvc/XMLView","sap/ui/rta/command/CommandFactory","sap/ui/dt/DesignTime","sap/ui/dt/DesignTimeStatus","sap/ui/dt/OverlayRegistry","sap/ui/fl/ChangePersistence","sap/ui/model/Model","sap/ui/fl/registry/Settings","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Cache","sap/ui/fl/Layer","sap/ui/thirdparty/sinon-4","sap/ui/fl/library"],function(U,C,X,a,D,b,O,c,M,S,P,d,L,s){"use strict";var e=function(m,o){if(e._only&&(m.indexOf(e._only)<0)){return;}if(typeof o.xmlView==="string"){o.xmlView={viewContent:o.xmlView};}var f=s.sandbox.create();o.before=o.before||function(){};o.after=o.after||function(){};QUnit.module(m,function(){QUnit.test("When using the 'controlEnablingCheck' function to test if your control is ready for UI adaptation at runtime",function(x){x.ok(o.afterAction,"then you implement a function to check if your action has been successful: See the afterAction parameter.");x.ok(o.afterUndo,"then you implement a function to check if the undo has been successful: See the afterUndo parameter.");x.ok(o.afterRedo,"then you implement a function to check if the redo has been successful: See the afterRedo parameter.");x.ok(o.xmlView,"then you provide an XML view to test on: See the.xmlView parameter.");var y=new DOMParser().parseFromString(o.xmlView.viewContent,"application/xml").documentElement;x.ok(y.tagName.match("View$"),"then you use the sap.ui.core.mvc View tag as the first tag in your view");x.ok(o.action,"then you provide an action: See the action parameter.");x.ok(o.action.name,"then you provide an action name: See the action.name parameter.");x.ok(o.action.controlId||o.action.control,"then you provide the control or control's id to operate the action on: See the action.controlId.");});});var g="sap.ui.rta.control.enabling.comp";var h=false;var A=true;var i=U.extend(g,{metadata:{interfaces:["sap.ui.core.IAsyncContentCreation"],manifest:{"sap.app":{id:g,type:"application"}}},createContent:function(){var V=Object.assign({},o.xmlView);V.id=this.createId("view");if(V.async===undefined){V.async=this.getComponentData().async;}V.definition=V.viewContent;this.oViewPromise=X.create(V);return this.oViewPromise;}});function j(x){this.oUiComponent=new i({id:"comp",componentData:{async:x}});return this.oUiComponent.oViewPromise.then(function(){this.oUiComponentContainer=new C({component:this.oUiComponent,height:"100%"});this.oUiComponentContainer.placeAt(o.placeAt||"qunit-fixture");this.oView=this.oUiComponent.getRootControl();if(o.model instanceof M){this.oView.setModel(o.model);}sap.ui.getCore().applyChanges();return o.model&&o.model.getMetaModel()&&o.model.getMetaModel().loaded();}.bind(this));}function k(x){var y=[].concat(o.previousActions||[],o.action);var z=[];return y.reduce(function(B,E){return B.then(l.bind(this,x,E)).then(function(F){z.push(F);return F.execute();});}.bind(this),Promise.resolve()).then(function(){return z;});}function l(x,y){return Promise.resolve().then(function(){var z;var B;var E;if(typeof y.control==="function"){z=y.control(this.oView);}else{z=this.oView.byId(y.controlId);}var F=y.name;return z.getMetadata().loadDesignTime(z).then(function(){if(y.parameter){if(typeof y.parameter==="function"){B=y.parameter(this.oView);}else{B=y.parameter;}}else{B={};}sap.ui.getCore().applyChanges();this.oDesignTime=new D({rootElements:[this.oView]});return new Promise(function(G){this.oDesignTime.attachEventOnce("synced",function(){var H=O.getOverlay(z);E=H.getDesignTimeMetadata();var R=E.getAction("getResponsibleElement",z);var I;if(y.name==="move"){var J=O.getOverlay(B.movedElements[0].element||B.movedElements[0].id);var K=J.getRelevantContainer();z=K;E=J.getParentAggregationOverlay().getDesignTimeMetadata();}else if(y.name==="addODataProperty"){x.ok(false,"addODataProperty action is deprecated. Use addViaDelegate action instead.");}else if(Array.isArray(y.name)){var N=E.getActionDataFromAggregations(y.name[0],z,undefined,y.name[1]);x.equal(N.length,1,"there should be only one aggregation with the possibility to do an add "+y.name[1]+" action");I=H.getAggregationOverlay(N[0].aggregation);E=I.getDesignTimeMetadata();F="addDelegateProperty";}else if(R){if(y.name==="reveal"){z=y.revealedElement(this.oView);H=O.getOverlay(y.revealedElement(this.oView));E=H.getDesignTimeMetadata();}else{z=R;H=O.getOverlay(z);E=H.getDesignTimeMetadata();G(z.getMetadata().loadDesignTime(z));}}G();}.bind(this));}.bind(this));}.bind(this)).then(function(){var G=new a({flexSettings:{layer:o.layer||L.CUSTOMER}});return G.getCommandFor(z,F,B,E);}).then(function(G){x.ok(G,"then the registration for action to change type, the registration for change and control type to change handler is available and "+o.action.name+" is a valid action");return G;});}.bind(this)).catch(function(z){throw new Error(z);});}function n(x){return x.reduce(function(y,z){return y.then(z.execute.bind(z));},Promise.resolve());}function u(x){var y=x.slice().reverse();return y.reduce(function(z,B){return z.then(B.undo.bind(B));},Promise.resolve());}function p(x){x.forEach(function(y){y.destroy();});}function q(V,x,y){var R={remainingCommands:[],deletedCommands:[]};if(x.length===1){R.remainingCommands.push(x[0]);return Promise.resolve(R);}var z=x.map(function(B){return B.getPreparedChange();});return P._condense({selector:V,changes:z}).then(function(B){if(o.changesAfterCondensing!==undefined){y.equal(B.length,o.changesAfterCondensing,"after condensing the amount of changes is correct");}var E=B.map(function(F){return F.getId();});x.forEach(function(F){if(E.indexOf(F.getPreparedChange().getId())>-1){R.remainingCommands.push(F);}else{R.deletedCommands.push(F);}});return R;});}function r(x){var y=[];x.forEach(function(z){var B=z.getPreparedChange();if(z.getAppComponent){y.push(P.remove({change:B,selector:z.getAppComponent()}));}});return Promise.all(y);}function t(x){var y=[];f.stub(c.prototype,"getChangesForComponent").resolves(y);f.stub(c.prototype,"getCacheKey").resolves("etag-123");return j.call(this,h).then(v.bind(this,x,y));}function v(x,y){var z=[].concat(o.previousActions||[],o.action);var B=[];return z.reduce(function(E,F){return E.then(l.bind(this,x,F)).then(function(G){B.push(G);y.push(G.getPreparedChange());this.oUiComponentContainer.destroy();return j.call(this,A);}.bind(this));}.bind(this),Promise.resolve()).then(function(){this.aCommands=B;}.bind(this));}if(!o.jsOnly){QUnit.module(m+" on async views",{before:function(x){this.hookContext={};return o.before.call(this.hookContext,x);},after:function(x){return o.after.call(this.hookContext,x);},beforeEach:function(){f.stub(S,"getInstance").resolves({_oSettings:{}});},afterEach:function(){this.oUiComponentContainer.destroy();this.oDesignTime.destroy();p(this.aCommands);f.restore();}},function(){QUnit.test("When applying the change directly on the XMLView",function(x){return t.call(this,x).then(function(){return o.afterAction(this.oUiComponent,this.oView,x);}.bind(this));});QUnit.test("When executing on XML and reverting the change in JS (e.g. variant switch)",function(x){return t.call(this,x).then(function(){return u(this.aCommands);}.bind(this)).then(function(){return r(this.aCommands);}.bind(this)).then(function(){sap.ui.getCore().applyChanges();o.afterUndo(this.oUiComponent,this.oView,x);}.bind(this));});QUnit.test("When executing on XML, reverting the change in JS (e.g. variant switch) and applying again",function(x){return t.call(this,x).then(function(){return q(this.oView,this.aCommands,x);}.bind(this)).then(function(y){this.aRemainingCommands=y.remainingCommands;return u(this.aCommands);}.bind(this)).then(function(){return r(this.aCommands);}.bind(this)).then(function(){return n(this.aRemainingCommands);}.bind(this)).then(function(){sap.ui.getCore().applyChanges();o.afterRedo(this.oUiComponent,this.oView,x);}.bind(this));});});}function w(x){if(x.getStatus()!==b.SYNCED){return new Promise(function(R){x.attachEventOnce("synced",R);});}return Promise.resolve();}QUnit.module(m,{before:function(x){this.hookContext={};return o.before.call(this.hookContext,x);},after:function(x){return o.after.call(this.hookContext,x);},beforeEach:function(x){f.stub(c.prototype,"getChangesForComponent").returns(Promise.resolve([]));f.stub(c.prototype,"getCacheKey").returns(d.NOTAG);f.stub(S,"getInstance").returns(Promise.resolve({_oSettings:{}}));return j.call(this,h).then(k.bind(this,x)).then(function(y){this.aCommands=y;}.bind(this));},afterEach:function(){this.oDesignTime.destroy();this.oUiComponentContainer.destroy();p(this.aCommands);f.restore();}},function(){QUnit.test("When executing the underlying command on the control at runtime",function(x){return w(this.oDesignTime).then(function(){sap.ui.getCore().applyChanges();return o.afterAction(this.oUiComponent,this.oView,x);}.bind(this));});QUnit.test("When executing and undoing the command",function(x){return w(this.oDesignTime).then(u.bind(null,this.aCommands)).then(r.bind(null,this.aCommands)).then(function(){sap.ui.getCore().applyChanges();return o.afterUndo(this.oUiComponent,this.oView,x);}.bind(this));});QUnit.test("When executing, undoing and redoing the command",function(x){return w(this.oDesignTime).then(q.bind(this,this.oView,this.aCommands,x)).then(function(y){this.aRemainingCommands=y.remainingCommands;return u(this.aCommands);}.bind(this)).then(r.bind(null,this.aCommands)).then(function(){return n(this.aRemainingCommands);}.bind(this)).then(function(){sap.ui.getCore().applyChanges();return o.afterRedo(this.oUiComponent,this.oView,x);}.bind(this));});});};
e.skip=function(){};
e.only=function(m){e._only=m;};
return e;});
sap.ui.predefine('sap/ui/rta/library',["sap/ui/core/Core","sap/ui/core/library","sap/m/library","sap/ui/fl/library","sap/ui/dt/library"],function(){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.rta",version:"1.96.3",dependencies:["sap.ui.core","sap.m","sap.ui.fl","sap.ui.dt"],types:[],interfaces:[],controls:[],elements:[]});sap.ui.rta.GENERATOR_NAME="sap.ui.rta.command";return sap.ui.rta;});
sap.ui.predefine('sap/ui/rta/plugin/AddXMLAtExtensionPoint',["sap/ui/rta/plugin/Plugin","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/write/api/ExtensionPointRegistryAPI","sap/base/util/values"],function(P,D,F,M,E,v){"use strict";
var A=P.extend("sap.ui.rta.plugin.AddXMLAtExtensionPoint",{metadata:{library:"sap.ui.rta",properties:{fragmentHandler:{type:"function"}},associations:{},events:{}}});
var a="addXMLAtExtensionPoint";var b="appdescr_ui5_setFlexExtensionPointEnabled";
function g(o){var f=o.getId();var j=E.getExtensionPointInfoByParentId({parentId:f});return j.length?j:v(E.getExtensionPointInfoByViewId({viewId:f}));}
function h(o){return g(o).length>0;}
function i(){return sap.ui.getCore().getConfiguration().getDesignMode();}
A.prototype.bAppDescriptorCommandAlreadyAvailable=false;
A.prototype._isEditable=function(o){if(i()){var f=o.getElement();return this.hasChangeHandler(a,f).then(function(H){return H&&h(f);});}return Promise.resolve(false);};
A.prototype.isEnabled=function(f){return f.length===1;};
A.prototype.isAvailable=function(o){if(i()){var f=o[0].getElement();return h(f);}return false;};
function c(o,m,C){var s=m.extensionPointName;var V=F.getViewForControl(o);var f={name:s,view:V};var j={fragment:m.fragment,fragmentPath:m.fragmentPath};return this.getCommandFactory().getCommandFor(f,a,j).then(function(k){return C.addCommand(k);});}
function d(o,C){var f=M.isFlexExtensionPointHandlingEnabled(o);if(f||this.bAppDescriptorCommandAlreadyAvailable){return Promise.resolve();}var j=F.getAppComponentForControl(o);var r=j.getManifestEntry("sap.app").id;return this.getCommandFactory().getCommandFor(o,"appDescriptor",{reference:r,appComponent:j,changeType:b,parameters:{flexExtensionPointEnabled:true},texts:{}}).then(function(k){this.bAppDescriptorCommandAlreadyAvailable=true;return C.addCommand(k);}.bind(this));}
function e(f,m){var C;var o=f[0];var j=o.getElement();return this.getCommandFactory().getCommandFor(j,"composite").then(function(_){C=_;}).then(function(){return c.call(this,j,m,C);}.bind(this)).then(function(){return d.call(this,j,C);}.bind(this)).then(function(){return C;});}
A.prototype.handler=function(f,p){return Promise.resolve().then(function(){var j=p.fragmentHandler||this.getFragmentHandler();if(!j){return Promise.reject("Fragment handler function is not available in the handler");}var o=f[0];var k=o.getElement();var l=g(k);return j(o,l);}.bind(this)).then(function(m){if(!m.extensionPointName||!(typeof m.extensionPointName==="string")){return Promise.reject("Extension point name is not selected!");}if(!m.fragmentPath||!(typeof m.fragmentPath==="string")){return Promise.reject("Fragment path is not available");}return m;}).then(function(m){return e.call(this,f,m);}.bind(this)).then(function(C){this.fireElementModified({command:C});}.bind(this)).catch(function(j){throw D.propagateError(j,"AddXMLAtExtensionPoint#handler","Error occured in AddXMLAtExtensionPoint handler function","sap.ui.rta");});};
A.prototype.getMenuItems=function(f){return this._getMenuItems(f,{pluginId:"CTX_ADDXML_AT_EXTENSIONPOINT",rank:110,icon:"sap-icon://add-equipment"});};
A.prototype.getActionName=function(){return"AddXMLAtExtensionPoint";};
A.prototype.getAction=function(){return{changeType:a};};
return A;});
sap.ui.predefine('sap/ui/rta/plugin/BaseCreate',["sap/ui/rta/plugin/Plugin","sap/ui/fl/Utils","sap/ui/rta/Utils"],function(P,F,R){"use strict";
var B=P.extend("sap.ui.rta.plugin.BaseCreate",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
B.prototype._isEditable=function(o){return Promise.all([this._isEditableCheck(o,true),this._isEditableCheck(o,false)]).then(function(p){return{asSibling:p[0],asChild:p[1]};});};
B.prototype._isEditableCheck=function(o,O){var p=this._getParentOverlay(O,o);var a;if(!p||!p.getParentElementOverlay()){return Promise.resolve(false);}if(O){a=o.getParentAggregationOverlay().getAggregationName();}return this.checkAggregationsOnSelf(p,this.getActionName(),a).then(function(e){if(e){var b=F.getViewForControl(p.getElement());return this.hasStableId(o)&&F.checkControlId(b);}return false;}.bind(this));};
B.prototype._getParentOverlay=function(s,o){var p;var r=this.getResponsibleElementOverlay(o);if(s){p=r.getParentElementOverlay();}else{p=r;}return p;};
B.prototype.getCreateActions=function(s,o){var r=this.getResponsibleElementOverlay(o);var p=this._getParentOverlay(s,r);var d=p.getDesignTimeMetadata();var a=d.getActionDataFromAggregations(this.getActionName(),r.getElement());if(s){var b=r.getParentAggregationOverlay().getAggregationName();return a.filter(function(A){return A.aggregation===b;});}return a;};
B.prototype.getCreateAction=function(s,o,a){var A=this.getCreateActions(s,o);if(a){var c;A.some(function(b){if(b.aggregation===a){c=b;return true;}});return c;}return A[0];};
B.prototype.isAvailable=function(s,e){return this._isEditableByPlugin(e[0],s);};
B.prototype.isActionEnabled=function(a,s,e){if(!a){return false;}if(a.isEnabled&&typeof a.isEnabled==="function"){var I=a.isEnabled;var p=this._getParentOverlay(s,e);return I(p.getElement());}return true;};
B.prototype.getCreatedContainerId=function(a,n){var I=n;if(a.getCreatedContainerId&&typeof a.getCreatedContainerId==="function"){var m=a.getCreatedContainerId;I=m(n);}return I;};
B.prototype._determineIndex=function(p,s,a,g){return R.getIndex(p,s,a,g);};
B.prototype._getText=function(a,e,d,t){if(!a){return t;}var A=d.getAggregationDescription(a.aggregation,e);if(!A){return t;}var c=A.singular;var T=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");return T.getText(t,c);};
B.prototype.getActionName=function(){throw new Error("abstract");};
function i(){}
B.prototype.getMenuItems=function(e){i(e);throw new Error("abstract");};
B.prototype.handleCreate=function(s,o){i(s,o);throw new Error("abstract");};
return B;});
sap.ui.predefine('sap/ui/rta/plugin/Combine',["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/dt/Util"],function(P,U,D){"use strict";
var C=P.extend("sap.ui.rta.plugin.Combine",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
C.prototype._isEditable=function(o){var c=this.getAction(o);if(!o.isRoot()&&c&&c.changeType&&c.changeOnRelevantContainer){var r=o.getRelevantContainer();return this.hasChangeHandler(c.changeType,r).then(function(h){return h&&this.hasStableId(o)&&this._checkRelevantContainerStableID(c,o);}.bind(this));}return false;};
C.prototype._checkForSameRelevantContainer=function(e){var r=[];for(var i=0,n=e.length;i<n;i++){r[i]=e[i].getRelevantContainer();var c=this.getAction(e[i]);if(!c||!c.changeType){return false;}if(i>0){if((r[0]!==r[i])||(this.getAction(e[0]).changeType!==c.changeType)){return false;}}}return true;};
C.prototype._checkBindingCompatibilityOfControls=function(c,m){return c.every(function(s){return c.every(function(t){return s!==t?U.checkSourceTargetBindingCompatibility(s,t,m):true;});});};
C.prototype.isAvailable=function(e){if(e.length<=1){return false;}return(e.every(function(E){return this._isEditableByPlugin(E);},this)&&this._checkForSameRelevantContainer(e));};
C.prototype.isEnabled=function(e){if(!this.isAvailable(e)||e.length<=1){return false;}var c=e.map(function(E){return E.getElement();});var a=e.every(function(E){var A=this.getAction(E);if(!A){return false;}if(typeof A.isEnabled!=="undefined"){if(typeof A.isEnabled==="function"){return A.isEnabled(c);}return A.isEnabled;}return true;},this);if(a){var d=c[0]&&c[0].getModel();return this._checkBindingCompatibilityOfControls(c,d);}return a;};
C.prototype.handleCombine=function(e,c){var o;var E=e.map(function(a){if(a.getElement().getId()===c.getId()){o=a;}return a.getElement();});var d=o.getDesignTimeMetadata();var v=this.getVariantManagementReference(o);return this.getCommandFactory().getCommandFor(c,"combine",{source:c,combineElements:E},d,v).then(function(a){this.fireElementModified({command:a});}.bind(this)).catch(function(m){throw D.createError("Combine#handleCombine",m,"sap.ui.rta");});};
C.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_GROUP_FIELDS",rank:90,icon:"sap-icon://combine"});};
C.prototype.getActionName=function(){return"combine";};
C.prototype.handler=function(e,p){this.handleCombine(e,p.contextElement);};
return C;});
sap.ui.predefine('sap/ui/rta/plugin/ControlVariant',["sap/ui/rta/plugin/Plugin","sap/ui/rta/plugin/RenameHandler","sap/ui/rta/Utils","sap/ui/dt/ElementOverlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/Layer","sap/ui/fl/variants/VariantManagement","sap/ui/fl/write/api/ContextSharingAPI","sap/ui/base/ManagedObject","sap/base/Log"],function(P,R,U,E,O,a,D,f,L,V,C,M,b){"use strict";E.prototype._variantManagement=undefined;
E.prototype.getVariantManagement=function(){return this._variantManagement;};
E.prototype.setVariantManagement=function(k){this._variantManagement=k;};
E.prototype.hasVariantManagement=function(){return!!this._variantManagement;};
function d(o){var m=o.getElement().getManageDialog();if(m&&!m.bIsDestroyed){m.destroy();}}
var c=P.extend("sap.ui.rta.plugin.ControlVariant",{metadata:{library:"sap.ui.rta",properties:{oldValue:"string"},associations:{},events:{}}});
c.prototype.registerElementOverlay=function(o){var e=o.getElement();var v;P.prototype.registerElementOverlay.apply(this,arguments);if(e instanceof V){var A=e.getFor();var g;var h=f.getAppComponentForControl(e);var s=e.getId();v=h.getLocalId(s)||s;o.setVariantManagement(v);if(!A||(Array.isArray(A)&&A.length===0)){return;}g=!Array.isArray(A)?[A]:A;g.forEach(function(i){var j=i instanceof M?i:sap.ui.getCore().byId(i);var k=O.getOverlay(j);this._propagateVariantManagement(k,v);}.bind(this));o.attachEvent("editableChange",R._manageClickEvent,this);d(o);}else if(!o.getVariantManagement()){v=this._getVariantManagementFromParent(o);if(v){o.setVariantManagement(v);o.attachEvent("editableChange",R._manageClickEvent,this);}}};
c.prototype._isPersonalizationMode=function(){return this.getCommandFactory().getFlexSettings().layer===L.USER;};
c.prototype._propagateVariantManagement=function(p,v){var e=[];p.setVariantManagement(v);e=a.getAllChildOverlays(p);e.forEach(function(o){e=e.concat(this._propagateVariantManagement(o,v));}.bind(this));return e;};
c.prototype._getVariantManagementFromParent=function(o){var v=o.getVariantManagement();if(!v&&o.getParentElementOverlay()){return this._getVariantManagementFromParent(o.getParentElementOverlay());}return v;};
c.prototype.deregisterElementOverlay=function(o){if(this._isVariantManagementControl(o)){d(o);}o.detachEvent("editableChange",R._manageClickEvent,this);o.detachBrowserEvent("click",R._onClick,this);this.removeFromPluginsList(o);P.prototype.deregisterElementOverlay.apply(this,arguments);};
c.prototype._getVariantModel=function(e){var A=f.getAppComponentForControl(e);return A?A.getModel(f.VARIANT_MODEL_NAME):undefined;};
c.prototype._isEditable=function(o){if(this._isPersonalizationMode()){return false;}return this._isVariantManagementControl(o)&&this.hasStableId(o);};
c.prototype._isVariantManagementControl=function(o){var e=o.getElement();var A=e.getAssociation("for");return!!(A&&e instanceof V);};
c.prototype.isVariantSwitchAvailable=function(e){return this._isVariantManagementControl(e);};
c.prototype.isVariantSwitchEnabled=function(e){var o=e[0];var v=[];if(this._isVariantManagementControl(o)){var g=o.getElement();var s=o.getVariantManagement?o.getVariantManagement():undefined;if(!s){return false;}var m=this._getVariantModel(g);if(m){v=m.getData()[s].variants.reduce(function(r,i){if(i.visible){return r.concat(i);}return r;},[]);}var h=v.length>1;return h;}return false;};
c.prototype.setDesignTime=function(o){R._setDesignTime.call(this,o);};
c.prototype.isRenameAvailable=function(e){return this._isVariantManagementControl(e);};
c.prototype.isRenameEnabled=function(e){return this._isVariantManagementControl(e[0]);};
c.prototype.isVariantSaveAvailable=function(e){return this._isVariantManagementControl(e);};
c.prototype.isVariantSaveEnabled=function(e){var o=e[0];var g=o.getElement();var m=this._getVariantModel(g);var v=o.getVariantManagement();return m.oData[v]&&m.oData[v].modified;};
c.prototype.isVariantSaveAsAvailable=function(e){return this._isVariantManagementControl(e);};
c.prototype.isVariantSaveAsEnabled=function(e){return this._isVariantManagementControl(e[0]);};
c.prototype.isVariantConfigureAvailable=function(e){return this._isVariantManagementControl(e);};
c.prototype.isVariantConfigureEnabled=function(e){return this._isVariantManagementControl(e[0]);};
c.prototype.switchVariant=function(t,n,s){var o=t.getDesignTimeMetadata();var T=t.getElement();this.getCommandFactory().getCommandFor(T,"switch",{targetVariantReference:n,sourceVariantReference:s},o).then(function(S){this.fireElementModified({command:S});}.bind(this)).catch(function(m){throw D.createError("ControlVariant#switchVariant",m,"sap.ui.rta");});};
c.prototype.renameVariant=function(e){this.startEdit(e[0]);};
c.prototype.startEdit=function(v){var e=v.getDesignTimeMetadata().getData().variantRenameDomRef;R.startEdit.call(this,{overlay:v,domRef:e,pluginMethodName:"plugin.ControlVariant.startEdit"});};
c.prototype.stopEdit=function(r){R._stopEdit.call(this,r,"plugin.ControlVariant.stopEdit");};
c.prototype.createSaveCommand=function(e){var o=e[0];var g=o.getElement();var h=o.getDesignTimeMetadata();var m=this._getVariantModel(g);var v=o.getVariantManagement();return this.getCommandFactory().getCommandFor(g,"save",{model:m},h,v).then(function(s){this.fireElementModified({command:s});}.bind(this));};
c.prototype.createSaveAsCommand=function(e){var o=e[0];var g=o.getElement();var h=o.getDesignTimeMetadata();var m=this._getVariantModel(g);var v=o.getVariantManagement();var s=m.getCurrentVariantReference(v);return this.getCommandFactory().getCommandFor(g,"saveAs",{sourceVariantReference:s,model:m},h,v).then(function(S){this.fireElementModified({command:S});}.bind(this));};
c.prototype._emitLabelChangeEvent=function(){var t=R._getCurrentEditableFieldText.call(this);var o=this._oEditedOverlay;var e=o.getDesignTimeMetadata();var r=o.getElement();var v=o.getVariantManagement();return this._createSetTitleCommand({text:t,element:r,designTimeMetadata:e,variantManagementReference:v}).then(function(s){this.fireElementModified({command:s});}.bind(this));};
c.prototype._createSetTitleCommand=function(p){this._$oEditableControlDomRef.text(p.text);return this.getCommandFactory().getCommandFor(p.element,"setTitle",{newText:p.text},p.designTimeMetadata,p.variantManagementReference).catch(function(m){b.error("Error during rename: ",m);});};
c.prototype._prepareOverlayForValueState=function(o,v){o.getValueState=function(){return"Error";};o.getValueStateText=function(){return v;};o.getDomRefForValueStateMessage=function(){return this.$();};};
c.prototype.configureVariants=function(e){var o=e[0];var v=o.getElement();var s=o.getVariantManagement();var m=this._getVariantModel(v);var g=o.getDesignTimeMetadata();var F=this.getCommandFactory().getFlexSettings();m.manageVariants(v,s,F.layer,U.getRtaStyleClassName()).then(function(h){return this.getCommandFactory().getCommandFor(v,"configure",{control:v,changes:h},g,s);}.bind(this)).then(function(h){this.fireElementModified({command:h});}.bind(this)).catch(function(h){throw D.createError("ControlVariant#configureVariants",h,"sap.ui.rta");});};
c.prototype.getMenuItems=function(e){var o=e[0];var m=[];if(this.isRenameAvailable(o)){m.push({id:"CTX_VARIANT_SET_TITLE",text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("CTX_RENAME"),handler:this.renameVariant.bind(this),enabled:this.isRenameEnabled.bind(this),rank:210,icon:"sap-icon://edit"});}if(this.isVariantSaveAvailable(o)){m.push({id:"CTX_VARIANT_SAVE",text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("CTX_VARIANT_SAVE"),handler:this.createSaveCommand.bind(this),enabled:this.isVariantSaveEnabled.bind(this),rank:220,icon:"sap-icon://save"});}if(this.isVariantSaveAsAvailable(o)){m.push({id:"CTX_VARIANT_SAVEAS",text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("CTX_VARIANT_SAVEAS"),handler:this.createSaveAsCommand.bind(this),enabled:this.isVariantSaveAsEnabled.bind(this),rank:225,icon:"sap-icon://duplicate"});}if(this.isVariantConfigureAvailable(o)){m.push({id:"CTX_VARIANT_MANAGE",text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("CTX_VARIANT_MANAGE"),handler:this.configureVariants.bind(this),enabled:this.isVariantConfigureEnabled.bind(this),startSection:true,rank:230,icon:"sap-icon://action-settings"});}if(this.isVariantSwitchAvailable(o)){var g=this._getVariantModel(o.getElement());var s=o.getVariantManagement();var S=g.getData()[s].variants.reduce(function(r,v){if(v.visible){var h=g.getData()[s].currentVariant===v.key;var i={id:v.key,text:v.title,icon:h?"sap-icon://accept":"blank",enabled:!h};return r.concat(i);}return r;},[]);m.push({id:"CTX_VARIANT_SWITCH_SUBMENU",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_SWITCH'),handler:function(e,p){var n=p.eventItem.getParameters().item.getProperty("key");var t=e[0];var h=g.getData()[s].currentVariant;return this.switchVariant(t,n,h);}.bind(this),enabled:this.isVariantSwitchEnabled.bind(this),submenu:S,rank:240,icon:"sap-icon://switch-views"});}return m;};
c.prototype.getActionName=function(){return"controlVariant";};
return c;});
sap.ui.predefine('sap/ui/rta/plugin/CreateContainer',["sap/ui/rta/plugin/BaseCreate","sap/ui/fl/Utils","sap/ui/rta/Utils","sap/ui/dt/Util","sap/base/util/uid"],function(B,F,R,D,u){"use strict";
var C=B.extend("sap.ui.rta.plugin.CreateContainer",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
C.prototype.isEnabled=function(s,e){var E=e[0];var a=this.getCreateAction(s,E);return this.isActionEnabled(a,s,E);};
C.prototype.getCreateContainerText=function(s,o){var a=this.getCreateAction(s,o);var p=this._getParentOverlay(s,o);var d=p.getDesignTimeMetadata();var e=p.getElement();var t="CTX_CREATE_CONTAINER";return this._getText(a,e,d,t);};
C.prototype._getContainerTitle=function(a,e,d){var t="TITLE_CREATE_CONTAINER";return this._getText(a,e,d,t);};
C.prototype.handleCreate=function(s,o){var a=this.getCreateAction(s,o);var p=this._getParentOverlay(s,o);var P=p.getElement();var d=p.getDesignTimeMetadata();var v=F.getViewForControl(P);var S;if(s){S=o.getElement();}var n=v.createId(u());var g=d.getAggregation(a.aggregation).getIndex;var i=this._determineIndex(P,S,a.aggregation,g);var V=this.getVariantManagementReference(p);return this.getCommandFactory().getCommandFor(P,"createContainer",{newControlId:n,label:this._getContainerTitle(a,P,d),index:i,parentId:P.getId()},d,V).then(function(c){this.fireElementModified({command:c,action:a,newControlId:n});}.bind(this)).catch(function(m){throw D.createError("CreateContainer#handleCreate",m,"sap.ui.rta");});};
C.prototype.getMenuItems=function(e){var o=true;var p="CTX_CREATE_SIBLING_CONTAINER";var r=40;var m=[];for(var i=0;i<2;i++){if(this.isAvailable(o,e)){m.push({id:p,text:this.getCreateContainerText.bind(this,o),handler:this.handleCreate.bind(this,o,e[0]),enabled:this.isEnabled.bind(this,o),icon:"sap-icon://add-folder",rank:r});}o=false;p="CTX_CREATE_CHILD_CONTAINER";r=50;}return m;};
C.prototype.getActionName=function(){return"createContainer";};
return C;});
sap.ui.predefine('sap/ui/rta/plugin/CutPaste',["sap/ui/dt/plugin/CutPaste","sap/ui/dt/Util","sap/ui/rta/plugin/Plugin","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/Utils"],function(C,D,P,R,U){"use strict";
var a=C.extend("sap.ui.rta.plugin.CutPaste",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{dragStarted:{},elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});
U.extendWith(a.prototype,P.prototype,function(d,s,p){return p!=="getMetadata";});
a.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setElementMover(new R({commandFactory:this.getCommandFactory()}));};
a.prototype._isEditable=function(o,p){return this.getElementMover().isEditable(o,p.onRegistration).then(function(e){if(e){return true;}return this._isPasteEditable(o);}.bind(this));};
a.prototype._isPasteEditable=function(o){var e=this.getElementMover();if(!this.hasStableId(o)){return Promise.resolve(false);}return e.isMoveAvailableOnRelevantContainer(o).then(function(m){if(!m){return false;}return U.doIfAllControlsAreAvailable([o],function(){return e.isMoveAvailableForChildren(o);});});};
a.prototype.isAvailable=function(e){return e.every(function(E){return E.getMovable();});};
a.prototype.registerElementOverlay=function(){C.prototype.registerElementOverlay.apply(this,arguments);P.prototype.registerElementOverlay.apply(this,arguments);};
a.prototype.deregisterElementOverlay=function(){C.prototype.deregisterElementOverlay.apply(this,arguments);P.prototype.removeFromPluginsList.apply(this,arguments);};
a.prototype.paste=function(t){this._executePaste(t);D.waitForSynced(this.getDesignTime())().then(function(){return this.getElementMover().buildMoveCommand();}.bind(this)).then(function(m){this.fireElementModified({command:m});this.stopCutAndPaste();}.bind(this)).catch(function(m){throw D.createError("CutPaste#paste",m,"sap.ui.rta");});};
a.prototype.cut=function(o){return C.prototype.cut.apply(this,arguments).then(function(){o.setSelected(false);});};
a.prototype.getMenuItems=function(e){var m=[];var p=this.enhanceItemWithResponsibleElement({id:'CTX_PASTE',text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_PASTE'),handler:function(e){return this.paste(e[0]);}.bind(this),enabled:function(e){return this.isElementPasteable(e[0]);}.bind(this),rank:80,icon:"sap-icon://paste"},e,["move"]);var r=p.responsible||e;if(this.isAvailable(r)){var c=this.enhanceItemWithResponsibleElement({id:'CTX_CUT',text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_CUT'),handler:function(e){return this.cut(e[0]);}.bind(this),enabled:function(e){return e.length===1;},rank:70,icon:"sap-icon://scissors"},e,["move"]);m.push(c,p);return m;}return this._isPasteEditable(e[0]).then(function(b){if(b){m.push(p);}return m;});};
return a;});
sap.ui.predefine('sap/ui/rta/plugin/DragDrop',["sap/ui/dt/plugin/ControlDragDrop","sap/ui/dt/Util","sap/ui/dt/OverlayRegistry","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils"],function(C,D,O,R,P,U){"use strict";
var a=C.extend("sap.ui.rta.plugin.DragDrop",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{dragStarted:{},elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});
U.extendWith(a.prototype,P.prototype,function(d,s,p){return p!=="getMetadata";});
a.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setElementMover(new R({commandFactory:this.getCommandFactory()}));};
a.prototype.setCommandFactory=function(c){this.setProperty("commandFactory",c);this.getElementMover().setCommandFactory(c);};
a.prototype._isEditable=function(o,p){return this.getElementMover().isEditable(o,p.onRegistration);};
a.prototype.registerElementOverlay=function(){C.prototype.registerElementOverlay.apply(this,arguments);P.prototype.registerElementOverlay.apply(this,arguments);};
a.prototype.deregisterElementOverlay=function(){C.prototype.deregisterElementOverlay.apply(this,arguments);P.prototype.removeFromPluginsList.apply(this,arguments);};
a.prototype.onDragStart=function(o){this.fireDragStarted();C.prototype.onDragStart.apply(this,arguments);this.getSelectedOverlays().forEach(function(o){o.setSelected(false);});o.$().addClass("sapUiRtaOverlayPlaceholder");};
a.prototype.onDragEnd=function(o){this.getElementMover().buildMoveCommand().then(function(c){this.fireElementModified({command:c});o.$().removeClass("sapUiRtaOverlayPlaceholder");o.setSelected(true);o.focus();C.prototype.onDragEnd.apply(this,arguments);this._updateRelevantOverlays();}.bind(this)).catch(function(e){throw D.propagateError(e,"DragDrop#onDragEnd","Error accured during onDragEnd execution","sap.ui.rta.plugin");});};
a.prototype.onMovableChange=function(){C.prototype.onMovableChange.apply(this,arguments);};
a.prototype._updateRelevantOverlays=function(){var p=this.getElementMover().getSourceAndTargetParentInformation();var s=p.sourceParentInformation.parent;var t=p.targetParentInformation.parent;var S=p.sourceParentInformation.aggregation;var T=p.targetParentInformation.aggregation;var b=s&&s.getAggregation(S);var r=[];if(b&&b.length>0){var o=O.getOverlay(b[0]);r=this._getRelevantOverlays(o,S);}if(t&&(t!==s||((t===s)&&(S!==T)))){var c=t&&t.getAggregation(T);if(c&&c.length>1){var i=p.targetParentInformation.index;var d=c[i+1]||c[i-1];var e=O.getOverlay(d);var f=this._getRelevantOverlays(e,T);r=r.concat(f);}}if(r.length>0){r=r.filter(function(g,I,h){return I===h.indexOf(g);});this.evaluateEditable(r,{onRegistration:false});}};
return a;});
sap.ui.predefine('sap/ui/rta/plugin/EasyAdd',["sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/dt/OverlayRegistry","sap/m/Button","sap/ui/thirdparty/jquery"],function(A,O,B,q){"use strict";
var E=A.extend("sap.ui.rta.plugin.EasyAdd",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
E.prototype.registerElementOverlay=function(o){var c=o.getElement();if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"&&this.hasStableId(o)){o.addStyleClass("sapUiRtaPersAdd");c.addStyleClass("sapUiRtaMarginBottom");}else if(c.getMetadata().getName()==="sap.uxap.ObjectPageLayout"&&this.hasStableId(o)){o.addStyleClass("sapUiRtaPersAddTop");c.$("sectionsContainer").addClass("sapUiRtaPaddingTop");}var a=function(d,o,i){var C;var e="sections";if(d){C=o.getDesignTimeMetadata().getName().plural;}else{C=o.getDesignTimeMetadata().getAggregation(e).childNames.plural();}this.clearCachedElements();this.showAvailableElements(d,e,[o],i,C);}.bind(this);var f=function(o,d,S,C,i){var e=function(h){var o=O.getOverlay(h.currentTarget.id.replace("-AddButton",""));a(S,o,i);h.stopPropagation();};var g=typeof C==="function"?C():C;this._addButton(o,e,d,g,S);}.bind(this);if(o.hasStyleClass("sapUiRtaPersAdd")){var b=o.hasStyleClass("sapUiRtaPersAdd")&&o.$().children(".sapUiRtaPersAddIconOuter").length<=0;if(b){f(o,o.$(),true,o.getDesignTimeMetadata().getName().singular);}}else if(o.hasStyleClass("sapUiRtaPersAddTop")){if(o.getAggregationOverlay("sections").$().children(".sapUiRtaPersAddIconOuter").length<=0){var s=o.getAggregationOverlay("sections").$();f(o,s,false,o.getDesignTimeMetadata().getAggregation("sections").childNames.singular,0);}}A.prototype.registerElementOverlay.apply(this,arguments);};
E.prototype.deregisterElementOverlay=function(o){var c=o.getElement();if(o._oAddButton){o._oAddButton.destroy();}if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"){o.removeStyleClass("sapUiRtaPersAdd");c.removeStyleClass("sapUiRtaMarginBottom");}else if(c.getMetadata().getName()==="sap.uxap.ObjectPageLayout"){o.removeStyleClass("sapUiRtaPersAddTop");c.$("sectionsContainer").removeClass("sapUiRtaPaddingTop");}};
E.prototype._isEditable=function(o){return A.prototype._isEditable.apply(this,arguments).then(function(i){if(o._oAddButton){var I=o.hasStyleClass("sapUiRtaPersAddTop");var s=I?"asChild":"asSibling";o._oAddButton.setEnabled(i[s]);if(I){var l=o.getElement();l.attachEventOnce("onAfterRenderingDOMReady",function(){l.$("sectionsContainer").addClass("sapUiRtaPaddingTop");});}}return i;});};
E.prototype._addButton=function(o,c,a,C,b){var i=o.getEditableByPlugins().indexOf(this._retrievePluginName(b))>-1;var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var I=o.getId()+"-AddButton";var h=q("<div class='sapUiRtaPersAddIconOuter' draggable='true' tabindex='-1'> </div>");o._oAddButton=new B(I,{text:t.getText("CTX_ADD_ELEMENTS",C),icon:"sap-icon://add",enabled:i}).placeAt(h.get(0)).attachBrowserEvent('click',c).attachBrowserEvent('tap',c);a.append(h);h[0].addEventListener("mouseover",function(e){e.stopPropagation();var o=e.fromElement?O.getOverlay(e.fromElement.id):null;if(o&&o.getMetadata().getName()==="sap.ui.dt.ElementOverlay"){var p=o.getParentElementOverlay();p.removeStyleClass("sapUiRtaOverlayHover");}});h[0].addEventListener("mouseleave",function(e){e.stopPropagation();var o=e.toElement?O.getOverlay(e.toElement.id):null;if(o&&o.getMetadata().getName()==="sap.ui.dt.ElementOverlay"){var p=o.getParentElementOverlay();if(p.getMovable()){p.addStyleClass("sapUiRtaOverlayHover");}}});h[0].addEventListener("click",function(e){e.stopPropagation();});h[0].addEventListener("contextmenu",function(e){e.stopPropagation();e.preventDefault();});h[0].addEventListener("dragstart",function(e){e.stopPropagation();e.preventDefault();});};
return E;});
sap.ui.predefine('sap/ui/rta/plugin/EasyRemove',["sap/ui/rta/plugin/Remove","sap/m/Button","sap/ui/thirdparty/jquery"],function(R,B,q){"use strict";
var E=R.extend("sap.ui.rta.plugin.EasyRemove",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
E.prototype.registerElementOverlay=function(o){var c=o.getElement();if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"&&this.hasStableId(o)){o.addStyleClass("sapUiRtaPersDelete");}if(o.hasStyleClass("sapUiRtaPersDelete")&&o.$().children(".sapUiRtaPersDeleteClick").length<=0){var a=function(o){this.handler([o]);}.bind(this);var d=this._addButton(o);d.attachBrowserEvent("contextmenu",function(e){e.stopPropagation();e.preventDefault();});var O=function(e){var o=sap.ui.getCore().byId(e.currentTarget.id.replace("-DeleteIcon",""));a(o);e.stopPropagation();e.preventDefault();};d.attachBrowserEvent("click",O).attachBrowserEvent("tap",O);}R.prototype.registerElementOverlay.apply(this,arguments);};
E.prototype._isEditable=function(o){if(o._oDeleteButton){o._oDeleteButton.setEnabled(this.isEnabled([o]));}return R.prototype._isEditable.apply(this,arguments);};
E.prototype._addButton=function(o){var e=this.isEnabled([o]);var i=o.getId()+"-DeleteIcon";var h=q("<div class='sapUiRtaPersDeleteClick' draggable='true'> </div>");var H=q("<div class='sapUiRtaPersDeleteIconOuter'> </div>");o._oDeleteButton=new B(i,{icon:"sap-icon://less",tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("CTX_REMOVE"),enabled:e}).placeAt(H.get(0));h.append(H);o.$().append(h);h[0].addEventListener("dragstart",function(a){a.stopPropagation();a.preventDefault();});return o._oDeleteButton;};
E.prototype.deregisterElementOverlay=function(o){var c=o.getElement();if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"){o.removeStyleClass("sapUiRtaPersDelete");if(o._oDeleteButton){o._oDeleteButton.destroy();}}};
return E;});
sap.ui.predefine('sap/ui/rta/plugin/LocalReset',["sap/ui/rta/plugin/Plugin","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/write/api/LocalResetAPI","sap/ui/rta/command/CompositeCommand","sap/m/MessageToast","sap/ui/dt/OverlayRegistry"],function(P,D,F,L,C,M,O){"use strict";
function g(v,V){return V?v.getCurrentVariantReference(V):"";}
var a=P.extend("sap.ui.rta.plugin.LocalReset",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
a.prototype._isEditable=function(o){var l=this.getAction(o);return!!l;};
a.prototype.isEnabled=function(e){if(e.length!==1){return false;}var E=e[0];var o=E.getElement();var A=this.getAction(E);if(!A){return false;}var i=true;if(typeof A.isEnabled!=="undefined"){if(typeof A.isEnabled==="function"){i=A.isEnabled(o);}else{i=A.isEnabled;}}var r=A.changeOnRelevantContainer?E.getRelevantContainer():o;var R=O.getOverlay(r);var b=F.getAppComponentForControl(r);var v=b.getModel(F.VARIANT_MODEL_NAME);var c=g(v,this.getVariantManagementReference(R));return(i&&L.isResetEnabled(r,{layer:this.getCommandFactory().getFlexSettings().layer,currentVariant:c}));};
a.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_LOCAL_RESET",rank:61,icon:"sap-icon://reset"});};
a.prototype.getActionName=function(){return"localReset";};
a.prototype.handler=function(o){var b=o[0];var e=b.getElement();var d=b.getDesignTimeMetadata();var v=this.getVariantManagementReference(b);var A=F.getAppComponentForControl(e);var V=A.getModel(F.VARIANT_MODEL_NAME);var c=g(V,v);var h=!!c;var f=h?A.byId(v)||sap.ui.getCore().byId(v):undefined;var i=this.getCommandFactory();var j=new C();return Promise.all([i.getCommandFor(e,"localReset",{currentVariant:c},d,v),h&&i.getCommandFor(f,"save",{model:V},d,v)].filter(Boolean)).then(function(k){k.forEach(function(l){j.addCommand(l);});this.fireElementModified({command:j});if(h){var m=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("MSG_LOCAL_RESET_VARIANT_SAVE");M.show(m,{duration:5000});}}.bind(this)).catch(function(E){throw D.propagateError(E,"LocalReset#handler","Error occured during handler execution","sap.ui.rta.plugin");});};
return a;});
sap.ui.predefine('sap/ui/rta/plugin/Plugin',["sap/ui/dt/Plugin","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/fl/changeHandler/JsControlTreeModifier","sap/ui/rta/util/hasStableId"],function(P,C,O,a,J,h){"use strict";
function _(p,c,s){var r=s;if(typeof this.getActionName()==="string"){if(this.isResponsibleElementActionAvailable(s)){r=this.getResponsibleElementOverlay(s);}}var e=r.getElement()&&r.getDesignTimeMetadata()&&!r.getDesignTimeMetadata().markedAsNotAdaptable()&&this._isEditable(r,Object.assign({sourceElementOverlay:s},p));if(e&&typeof e.then==="function"){e.then(function(E){this._handleModifyPluginList(s,E);}.bind(this));c.push(e);}else{this._handleModifyPluginList(s,e);}return c;}
var B=P.extend("sap.ui.rta.plugin.Plugin",{metadata:{"abstract":true,library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});
B.prototype._isEditable=function(){};
B.prototype.executeWhenVisible=function(e,c){var g=function(E){if(E.getSource().getGeometry()&&E.getSource().getGeometry().visible){e.detachEvent("geometryChanged",g,this);c();}};var o=e.getGeometry();if(e.getElementVisibility()&&(!o||!o.visible)){e.attachEvent("geometryChanged",g,this);}else{c();}};
var b=function(e){var p=e.getParameters();var r;var o=e.getSource();if(p.type==="propertyChanged"&&p.name==="visible"){r=this._getRelevantOverlays(o);if(p.value===true){this.executeWhenVisible(o,function(){this.evaluateEditable(r,{onRegistration:false});}.bind(this));}else{this.evaluateEditable(r,{onRegistration:false});}}else if(p.type==="afterRendering"){if(this.getDesignTime().getStatus()==="synced"){this.evaluateEditable([o],{onRegistration:false});}else{this.getDesignTime().attachEventOnce("synced",function(){this.evaluateEditable([o],{onRegistration:false});},this);}}else if(p.type==="insertAggregation"||p.type==="removeAggregation"){r=this._getRelevantOverlays(o,p.name);this.evaluateEditable(r,{onRegistration:false});}else if(p.type==="addOrSetAggregation"){if(this.getDesignTime().getStatus()==="synced"){r=this._getRelevantOverlays(o,p.name);this.evaluateEditable(r,{onRegistration:false});}else{this.getDesignTime().attachEventOnce("synced",function(){r=this._getRelevantOverlays(o,p.name);this.evaluateEditable(r,{onRegistration:false});},this);}}};
B.prototype._getRelevantOverlays=function(o,A){var c=o.getRelevantOverlays();if(c.length===0){var r=a.findAllOverlaysInContainer(o);if(A){var d=o.getAggregationOverlay(A);var e=d?d.getChildren():[];e=e.filter(function(f){return r.indexOf(f)===-1;});r=r.concat(e);}o.setRelevantOverlays(r);return r;}return c;};
B.prototype.evaluateEditable=function(o,p){if(!p.onRegistration&&this.getDesignTime()&&this.getDesignTime().getBusyPlugins().length){return;}this.setProcessingStatus(true);var c=o.reduce(_.bind(this,p),[]);if(c.length){Promise.all(c).then(function(){this.setProcessingStatus(false);}.bind(this)).catch(function(){this.setProcessingStatus(false);}.bind(this));}else{this.setProcessingStatus(false);}};
B.prototype._handleModifyPluginList=function(o,e){if(e!==undefined&&e!==null){if(typeof e==="boolean"){this._modifyPluginList(o,e);}else{this._modifyPluginList(o,e.asChild,false);this._modifyPluginList(o,e.asSibling,true);}}};
B.prototype._modifyPluginList=function(o,i,c){if(i){this.addToPluginsList(o,c);}else{this.removeFromPluginsList(o,c);}};
B.prototype._retrievePluginName=function(s){var n=this.getMetadata().getName();if(s!==undefined){n+=s?".asSibling":".asChild";}return n;};
B.prototype._isEditableByPlugin=function(o,s){var p=this._retrievePluginName(s);var c=o.getEditableByPlugins();return c.indexOf(p)>-1;};
B.prototype.registerElementOverlay=function(o){this.executeWhenVisible(o,function(){this.evaluateEditable([o],{onRegistration:true});o.attachElementModified(b,this);}.bind(this));};
B.prototype.deregisterElementOverlay=function(o){this.removeFromPluginsList(o);this.removeFromPluginsList(o,true);this.removeFromPluginsList(o,false);o.detachElementModified(b,this);};
B.prototype.hasStableId=function(o){return h(o);};
B.prototype.getVariantManagementReference=function(o){var v;if(o.getVariantManagement){v=o.getVariantManagement();}return v;};
B.prototype.checkAggregationsOnSelf=function(o,A,p,s){var d=o.getDesignTimeMetadata();var e=o.getElement();var c=d.getActionDataFromAggregations(A,e,undefined,s);var f=c.filter(function(j){if(j&&p){return j.aggregation===p;}return true;})[0];var g=f?f.changeType:null;var i=f&&f.changeOnRelevantContainer;if(i){e=o.getRelevantContainer();var r=O.getOverlay(e);if(!this.hasStableId(r)){return Promise.resolve(false);}}if(g){return this.hasChangeHandler(g,e);}return Promise.resolve(false);};
B.prototype.removeFromPluginsList=function(o,s){var n=this._retrievePluginName(s);o.removeEditableByPlugin(n);if(!o.getEditableByPlugins().length){o.setEditable(false);}};
B.prototype.addToPluginsList=function(o,s){var n=this._retrievePluginName(s);var p=o.getEditableByPlugins();if(p.indexOf(n)===-1){o.addEditableByPlugin(n);o.setEditable(true);}};
B.prototype.hasChangeHandler=function(c,e,s){return C.getChangeHandler({changeType:c,element:e,modifier:J,layer:this.getCommandFactory().getFlexSettings().layer,controlType:s}).then(function(){return true;}).catch(function(){return false;});};
B.prototype.isAvailable=function(e){return e.every(function(E){return this._isEditableByPlugin(E);},this);};
B.prototype._checkRelevantContainerStableID=function(A,e){if(A.changeOnRelevantContainer){var r=e.getRelevantContainer();var R=O.getOverlay(r);if(!this.hasStableId(R)){return false;}}return true;};
return B;});
sap.ui.predefine('sap/ui/rta/plugin/RTAElementMover',["sap/ui/dt/plugin/ElementMover","sap/ui/dt/OverlayUtil","sap/ui/dt/ElementUtil","sap/ui/rta/Utils","sap/ui/rta/command/CommandFactory","sap/ui/rta/plugin/Plugin","sap/ui/dt/OverlayRegistry"],function(E,O,a,U,C,P,b){"use strict";
var R=E.extend("sap.ui.rta.plugin.RTAElementMover",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"any",defaultValue:C},movableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]}},associations:{},events:{}}});
R.prototype.init=function(){this.oBasePlugin=new P({commandFactory:this.getCommandFactory()});};
R.prototype.exit=function(){this.oBasePlugin.destroy();};
R.prototype.setCommandFactory=function(o){this.setProperty("commandFactory",o);this.oBasePlugin.setCommandFactory(o);};
R.prototype.isEditable=function(o,d){var e=o.getElement();if(!this.isMovableType(e)){return Promise.resolve(false);}return this.checkMovable(o,d).then(function(m){o.setMovable(m);return m;});};
function i(o,d){var D=o.getDesignTimeMetadata();var p=o.getParentElementOverlay();var n=D.markedAsNotAdaptable();if(!D||!p||n){return Promise.resolve(false);}var e=o.getElement();if(a.isElementDirectTemplateChild(e)){return Promise.resolve(false);}var r=o.getRelevantContainer();var f=b.getOverlay(r);if(!f){return Promise.resolve(false);}return this.isMoveAvailableOnRelevantContainer(o).then(function(v){if(v){v=this.oBasePlugin.hasStableId(o)&&this.oBasePlugin.hasStableId(p)&&this.oBasePlugin.hasStableId(f);}return v;}.bind(this)).then(function(v){if(v){return c.call(this,o,f,d);}return v;}.bind(this));}
function c(o,r,d){var e=O.findAllUniqueAggregationOverlaysInContainer(o,r);var v=e.map(function(A){return this.checkTargetZone(A,o,d).then(function(V){return V?A:undefined;});}.bind(this));return Promise.all(v).then(function(V){V=V.filter(function(g){return!!g;});if(V.length<1){return false;}else if(V.length===1){var f=V[0].getChildren().filter(function(g){var h=g.getElement();return(h&&h.getVisible()&&h.getParent());});return f.length>1;}return true;});}
E.prototype._getMoveAction=function(o){var p;var d=o.getParentAggregationOverlay();if(d){p=d.getDesignTimeMetadata();}return p?p.getAction("move",o.getElement()):undefined;};
E.prototype.isMovableType=function(){return true;};
R.prototype.checkMovable=function(o,d){return i.call(this,o,d);};
R.prototype.checkTargetZone=function(A,o,d){var m=o||this.getMovedOverlay();return U.checkTargetZone(A,m,this.oBasePlugin,d);};
R.prototype.isMoveAvailableOnRelevantContainer=function(o){var d;var m=this._getMoveAction(o);if(m&&m.changeType){d=o.getRelevantContainer();var r=b.getOverlay(d);if(!this.oBasePlugin.hasStableId(r)){return Promise.resolve(false);}return this.oBasePlugin.hasChangeHandler(m.changeType,d);}return Promise.resolve(false);};
R.prototype.isMoveAvailableForChildren=function(o){var d=o.getDesignTimeMetadata();var A=d.getAggregationNamesWithAction("move");var e=[];A.forEach(function(f){var g=o.getAggregationOverlay(f);if(g){var h=g.getChildren();var j=h.map(this.checkMovable.bind(this));e=e.concat(j);}else{e.push(Promise.resolve(false));}}.bind(this));return Promise.all(e).then(function(m){return m.some(function(M){return M;});});};
R.prototype.buildMoveCommand=function(){var m=this.getMovedOverlay();var p=m.getParentAggregationOverlay();var M=m.getElement();var s=this._getSource();var r=m.getRelevantContainer();var t=O.getParentInformation(m);var S=s.index;var T=t.index;var d=this._compareSourceAndTarget(s,t);if(d){return Promise.resolve();}delete s.index;delete t.index;var v=this.oBasePlugin.getVariantManagementReference(m);return this.getCommandFactory().getCommandFor(r,"Move",{movedElements:[{element:M,sourceIndex:S,targetIndex:T}],source:s,target:t},p.getDesignTimeMetadata(),v);};
return R;});
sap.ui.predefine('sap/ui/rta/plugin/Remove',["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/rta/command/CompositeCommand","sap/ui/dt/OverlayRegistry","sap/ui/events/KeyCodes","sap/base/Log"],function(P,U,C,O,K,L){"use strict";
var R=P.extend("sap.ui.rta.plugin.Remove",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
R.prototype.registerElementOverlay=function(o){if(this.isEnabled([o])){o.attachBrowserEvent("keydown",this._onKeyDown,this);}P.prototype.registerElementOverlay.apply(this,arguments);};
R.prototype._isEditable=function(e){var E=e.getElement();var r=this.getAction(e);if(r&&r.changeType){if(r.changeOnRelevantContainer){E=e.getRelevantContainer();}return this.hasChangeHandler(r.changeType,E).then(function(h){return h&&this._checkRelevantContainerStableID(r,e)&&this.hasStableId(e);}.bind(this));}return false;};
R.prototype.isEnabled=function(e){var r=e.map(function(E){return this.getResponsibleElementOverlay(E);}.bind(this));var E=r[0];var a=this.getAction(E);var i=false;if(!a){return i;}if(typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){i=a.isEnabled(E.getElement());}else{i=a.isEnabled;}}else{i=true;}return i&&this._canBeRemovedFromAggregation(r);};
R.prototype._canBeRemovedFromAggregation=function(e){var o=e[0];var E=o.getElement();var p=E.getParent();if(!p){return false;}var a=p.getAggregation(E.sParentAggregationName);if(!Array.isArray(a)){return true;}if(a.length===1){return false;}var n=e.length;var i=a.filter(function(E){var b=O.getOverlay(E);return!(b&&b.getElementVisibility());});return!(i.length===(a.length-n));};
R.prototype._getConfirmationText=function(o){var a=this.getAction(o);if(a&&a.getConfirmationText){return a.getConfirmationText(o.getElement());}};
R.prototype.deregisterElementOverlay=function(o){if(this.isEnabled([o])){o.detachBrowserEvent("keydown",this._onKeyDown,this);}P.prototype.deregisterElementOverlay.apply(this,arguments);};
R.prototype._onKeyDown=function(e){if(e.keyCode===K.DELETE){e.stopPropagation();this.removeElement();}};
R.prototype.removeElement=function(e){var t=e||this.getSelectedOverlays();t=t.filter(function(E){return this.isEnabled([E]);},this);if(t.length>0){this.handler(t);}};
R.prototype._getRemoveCommand=function(r,d,v){return this.getCommandFactory().getCommandFor(r,"Remove",{removedElement:r},d,v);};
R.prototype._fireElementModified=function(c){if(c.getCommands().length){this.fireElementModified({command:c});}};
R.prototype.handler=function(e){var p=[];var c=new C();function s(o){o.setSelected(true);setTimeout(function(){o.focus();},0);}var n=R._getElementToFocus(e);e.forEach(function(o){var r=this.getResponsibleElementOverlay(o);var a=r.getElement();var d=r.getDesignTimeMetadata();var v=this.getVariantManagementReference(r);var b=this._getConfirmationText(r);p.push(Promise.resolve().then(function(){if(b){return U.openRemoveConfirmationDialog(a,b);}return true;}).then(function(f){if(!f){throw Error("Cancelled");}return this._getRemoveCommand(a,d,v);}.bind(this)).then(function(f){c.addCommand(f);}).catch(function(E){if(E&&E.message==="Cancelled"){if(e.length===1){n=o;}}else{throw E;}}));o.setSelected(false);},this);if(p.length){return Promise.all(p).then(function(){s(n);this._fireElementModified(c);}.bind(this)).catch(function(E){L.error("Error during remove: ",E);});}};
R._getElementToFocus=function(s){var n;if(s.length===1){var o=s[0];var S=o.getParent().getAggregation(o.sParentAggregationName);if(S.length>1){var i=S.indexOf(o);var c=S.slice(i+1);if(i!==0){c=c.concat(S.slice(0,i).reverse());}n=c.filter(function(a){return a.getElement().getVisible();}).shift();}}if(!n){n=O.getOverlay(s[0].getRelevantContainer());}return n;};
R.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_REMOVE",rank:60,icon:"sap-icon://less"});};
R.prototype.getActionName=function(){return"remove";};
return R;});
sap.ui.predefine('sap/ui/rta/plugin/Rename',["sap/ui/rta/plugin/Plugin","sap/ui/rta/plugin/RenameHandler","sap/base/Log"],function(P,R,L){"use strict";
var a=P.extend("sap.ui.rta.plugin.Rename",{metadata:{library:"sap.ui.rta",properties:{oldValue:"string"},associations:{},events:{editable:{},nonEditable:{}}}});
a.prototype.exit=function(){P.prototype.exit.apply(this,arguments);this.setBusy(false);R._exit.call(this);};
a.prototype.setDesignTime=function(d){R._setDesignTime.call(this,d);};
a.prototype.startEdit=function(o){var e=o.getElement();var d=o.getDesignTimeMetadata();var D=d.getAction("rename",e).domRef;R.startEdit.call(this,{overlay:o,domRef:D,pluginMethodName:"plugin.Rename.startEdit"});};
a.prototype.stopEdit=function(r){R._stopEdit.call(this,r,"plugin.Rename.stopEdit");};
a.prototype.handler=function(e){e=this.getSelectedOverlays()||e;this.startEdit(e[0]);};
a.prototype.isRenameAvailable=function(o){return this._isEditableByPlugin(o);};
a.prototype.isRenameEnabled=function(o){return this.isEnabled(o);};
a.prototype.isEnabled=function(e){if(e.length>1){return false;}var t=e[0];var r=this.getResponsibleElementOverlay(t);var i=true;if(!this.getAction(r)){i=false;}var T=this.getAction(t);if(i&&typeof T.isEnabled!=="undefined"){if(typeof T.isEnabled==="function"){i=T.isEnabled(t.getElement());}else{i=T.isEnabled;}}if(i){var d=t.getDesignTimeMetadata();var A=d.getAssociatedDomRef(t.getElement(),T.domRef);if(!(A&&A.get(0))){i=false;}}return i;};
a.prototype.registerElementOverlay=function(o){o.attachEvent("editableChange",R._manageClickEvent,this);P.prototype.registerElementOverlay.apply(this,arguments);};
a.prototype._isEditable=function(o){var e=o.getElement();var r=this.getAction(o);if(r&&r.changeType){if(r.changeOnRelevantContainer){e=o.getRelevantContainer();}return this.hasChangeHandler(r.changeType,e).then(function(h){return h&&this._checkRelevantContainerStableID(r,o)&&this.hasStableId(o);}.bind(this));}return false;};
a.prototype.deregisterElementOverlay=function(o){o.detachEvent("editableChange",R._manageClickEvent,this);o.detachBrowserEvent("click",R._onClick,this);this.removeFromPluginsList(o);};
a.prototype._emitLabelChangeEvent=function(){var t=R._getCurrentEditableFieldText.call(this);this._$oEditableControlDomRef.text(t);var r=this.getResponsibleElementOverlay(this._oEditedOverlay);var o=r.getElement();var d=r.getDesignTimeMetadata();var v=this.getVariantManagementReference(r);return this.getCommandFactory().getCommandFor(o,"rename",{renamedElement:o,newValue:t},d,v).then(function(b){this.fireElementModified({command:b});}.bind(this)).catch(function(e){L.error("Error during rename : ",e);});};
a.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_RENAME",rank:10,icon:"sap-icon://edit"});};
a.prototype.getActionName=function(){return"rename";};
return a;});
sap.ui.predefine('sap/ui/rta/plugin/RenameHandler',["sap/ui/base/BindingParser","sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/rta/plugin/Plugin","sap/ui/dt/Overlay","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/rta/Utils","sap/ui/dt/DOMUtil","sap/ui/events/KeyCodes"],function(B,q,D,P,O,E,a,U,b,K){"use strict";var e="\xa0";
function c(n,o){if(o===n){throw Error("sameTextError");}var d;var f;try{d=B.complexParser(n,undefined,true);}catch(g){f=true;}if(d&&typeof d==="object"||f){throw Error(sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("RENAME_BINDING_ERROR_TEXT"));}}
var R={errorStyleClass:"sapUiRtaErrorBg",validators:{noEmptyText:{validatorFunction:function(n){return n!==e;},errorMessage:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("RENAME_EMPTY_ERROR_TEXT")}},_manageClickEvent:function(v){var o=v.getSource?v.getSource():v;if(o.isSelected()&&this.isRenameAvailable(o)&&this.isRenameEnabled([o])){o.attachBrowserEvent("click",R._onClick,this);}else{o.detachBrowserEvent("click",R._onClick,this);}},startEdit:function(p){this.setBusy(true);this._oEditedOverlay=p.overlay;var o=p.overlay.getElement();var d=this._oEditedOverlay.getDesignTimeMetadata();var v=d.getAssociatedDomRef(o,p.domRef);if(!U.isElementInViewport(v)){v.get(0).scrollIntoView();}this._$oEditableControlDomRef=q(v);var w=0;var f=a.getOverlay(v instanceof q?v.get(0).id:v.id);if(!f){f=this._oEditedOverlay;var _=q(E.getDomRef(o));var g=this._$oEditableControlDomRef.parent();var C=parseInt(_.outerWidth());if(!isNaN(C)){var i=parseInt(this._$oEditableControlDomRef.outerWidth());var h=parseInt(g.outerWidth());w=C-i;if(w<0&&h){if(g.get(0).id!==_.get(0).id&&g.children(":visible").length===1&&g.children(":visible").get(0).id===this._$oEditableControlDomRef.get(0).id&&C>h){w=C-h;}else{w=0;}}}}var j=q("<div class='sapUiRtaEditableField'></div>").css({"white-space":"nowrap",overflow:"hidden",width:"calc(100% - ("+w+"px))"}).appendTo(f.$());this._$editableField=q("<div contentEditable='true'></div>").appendTo(j);if(this._$oEditableControlDomRef.text()===""){this._$oEditableControlDomRef.text("_?_");this._$editableField.text("");}else{this._$editableField.text(this._$oEditableControlDomRef.text());}this.setOldValue(R._getCurrentEditableFieldText.call(this));b.copyComputedStyle(this._$oEditableControlDomRef,this._$editableField);this._$editableField.children().remove();this._$editableField.css("visibility","hidden");this._$editableField.css({"-moz-user-modify":"read-write","-webkit-user-modify":"read-write","-ms-user-modify":"read-write","user-modify":"read-write","text-overflow":"clip","white-space":"nowrap"});if(D.browser.name==="ed"&&o.getMetadata().getName()==="sap.ui.fl.variants.VariantManagement"){this._$editableField.css({"line-height":"normal"});}O.getMutationObserver().ignoreOnce({target:this._$oEditableControlDomRef.get(0)});this._$editableField.one("focus",R._onEditableFieldFocus.bind(this));this._$editableField.on("blur",R._onEditableFieldBlur.bind(this));this._$editableField.on("keydown",R._onEditableFieldKeydown.bind(this));this._$editableField.on("dragstart",R._stopPropagation.bind(this));this._$editableField.on("drag",R._stopPropagation.bind(this));this._$editableField.on("dragend",R._stopPropagation.bind(this));this._$editableField.on("click",R._stopPropagation.bind(this));this._$editableField.on("mousedown",R._stopPropagation.bind(this));this._$oEditableControlDomRef.css("visibility","hidden");j.offset({left:this._$oEditableControlDomRef.offset().left});this._$editableField.offset({left:this._$oEditableControlDomRef.offset().left});this._$editableField.offset({top:this._$oEditableControlDomRef.offset().top});this._$editableField.css("visibility","");this._$editableField.trigger("focus");p.overlay.setSelected(true);sap.ui.getCore().getEventBus().publish("sap.ui.rta",p.pluginMethodName,{overlay:p.overlay,editableField:this._$editableField});},_setDesignTime:function(d){this._aSelection=[];var o=this.getDesignTime();if(o){o.getSelectionManager().detachChange(R._onDesignTimeSelectionChange,this);}P.prototype.setDesignTime.apply(this,arguments);if(d){d.getSelectionManager().attachChange(R._onDesignTimeSelectionChange,this);this._aSelection=this.getSelectedOverlays();}},_onDesignTimeSelectionChange:function(o){var s=o.getParameter("selection");this._aSelection.forEach(R._manageClickEvent,this);s.forEach(R._manageClickEvent,this);this._aSelection=s;},_stopPropagation:function(o){o.stopPropagation();},_preventDefault:function(o){o.preventDefault();},_onEditableFieldFocus:function(o){var d=o.target;var r=document.createRange();r.selectNodeContents(d);var s=window.getSelection();s.removeAllRanges();s.addRange(r);},_stopEdit:function(r,p){var o;this.setBusy(false);if(this._$oEditableControlDomRef.text()==="_?_"){this._$oEditableControlDomRef.text("");}this._oEditedOverlay.$().find(".sapUiRtaEditableField").remove();O.getMutationObserver().ignoreOnce({target:this._$oEditableControlDomRef.get(0)});this._$oEditableControlDomRef.css("visibility","visible");if(r){o=this._oEditedOverlay;o.setSelected(true);o.focus();}delete this._$editableField;delete this._$oEditableControlDomRef;delete this._oEditedOverlay;delete this._bBlurOrKeyDownStarted;sap.ui.getCore().getEventBus().publish("sap.ui.rta",p,{overlay:o});},_onEditableFieldBlur:function(){return R._handlePostRename.call(this,false);},_handlePostRename:function(r,o){if(!this._bBlurOrKeyDownStarted){this._oEditedOverlay.removeStyleClass(R.errorStyleClass);this._bBlurOrKeyDownStarted=true;if(o){R._preventDefault.call(this,o);R._stopPropagation.call(this,o);}return Promise.resolve().then(R._validateNewText.bind(this)).then(this._emitLabelChangeEvent.bind(this)).catch(function(d){if(d.message==="sameTextError"){return;}throw d;}).then(function(f){this.stopEdit(r);if(typeof f==="function"){f();}}.bind(this)).catch(function(d){return R._handleInvalidRename.call(this,d.message,r);}.bind(this));}return Promise.resolve();},_handleInvalidRename:function(s,r){return U.showMessageBox("error",s,{titleKey:"RENAME_ERROR_TITLE"}).then(function(){var o=this._oEditedOverlay;o.setIgnoreEnterKeyUpOnce(false);o.addStyleClass(R.errorStyleClass);this.stopEdit(r);this.startEdit(o);}.bind(this));},_validateNewText:function(){var s;var n=R._getCurrentEditableFieldText.call(this);c(n,this.getOldValue());var r=this.getResponsibleElementOverlay(this._oEditedOverlay);var o=this.getAction(r);var v=o&&o.validators||[];v.some(function(V){var d;if(typeof V==="string"&&R.validators[V]){d=R.validators[V];}else{d=V;}if(!d.validatorFunction(n)){s=d.errorMessage;return true;}});if(s){throw Error(s);}},_onEditableFieldKeydown:function(o){switch(o.keyCode){case K.ENTER:this._oEditedOverlay.setIgnoreEnterKeyUpOnce(true);return R._handlePostRename.call(this,true,o);case K.ESCAPE:this._oEditedOverlay.removeStyleClass(R.errorStyleClass);this.stopEdit(true);R._preventDefault.call(this,o);break;case K.DELETE:R._stopPropagation.call(this,o);break;default:}return Promise.resolve();},_getCurrentEditableFieldText:function(){var t=this._$editableField.text().trim();return t===""?e:t;},_onClick:function(o){var d=sap.ui.getCore().byId(o.currentTarget.id);if(this.isRenameEnabled([d])&&!o.metaKey&&!o.ctrlKey){this.startEdit(d);R._preventDefault.call(this,o);}},_exit:function(){if(this._$oEditableControlDomRef){this.stopEdit(false);}}};return R;},true);
sap.ui.predefine('sap/ui/rta/plugin/Selection',["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/dt/OverlayRegistry","sap/ui/events/KeyCodes","sap/ui/dt/Overlay","sap/base/util/restricted/_intersection","sap/m/InstanceManager","sap/ui/Device"],function(P,U,O,K,a,_,I,D){"use strict";
var S=P.extend("sap.ui.rta.plugin.Selection",{metadata:{library:"sap.ui.rta",properties:{multiSelectionRequiredPlugins:{type:"string[]"},isActive:{type:"boolean",defaultValue:true}},associations:{},events:{elementEditableChange:{parameters:{editable:{type:"boolean"}}}}}});
function p(e){e.preventDefault();e.stopPropagation();}
function h(e,m){var s=m.slice();e.forEach(function(E){s=_(s,E.getEditableByPlugins());});return s.length>0;}
function b(e){return e.every(function(E){return E.getRelevantContainer()===e[0].getRelevantContainer();});}
function c(e){return e.every(function(E){return E.getParentElementOverlay()===e[0].getParentElementOverlay();});}
function i(e){return e.every(function(E){return E.getElement().getMetadata().getName()===e[0].getElement().getMetadata().getName();});}
S.prototype.init=function(){this._multiSelectionValidator=this._multiSelectionValidator.bind(this);P.prototype.init.apply(this,arguments);};
S.prototype._checkDeveloperMode=function(o,d){if(d){var e=this.getCommandFactory().getFlexSettings().developerMode;if(e&&this.hasStableId(o)){o.setEditable(true);o.setSelectable(true);this.fireElementEditableChange({editable:true});return true;}}return false;};
S.prototype.registerElementOverlay=function(o){var d=o.getDesignTimeMetadata();if(!d.markedAsNotAdaptable()&&!this._checkDeveloperMode(o,d)){o.attachEditableChange(this._onEditableChange,this);this._adaptSelectable(o);}o.attachBrowserEvent("click",this._selectOverlay,this);o.attachBrowserEvent("contextmenu",this._selectOverlay,this);o.attachBrowserEvent("keydown",this._onKeyDown,this);o.attachBrowserEvent("mousedown",this._onMouseDown,this);o.attachBrowserEvent("mouseover",this._onMouseover,this);o.attachBrowserEvent("mouseleave",this._onMouseleave,this);};
S.prototype._onEditableChange=function(e){var o=e.getSource();this._adaptSelectable(o);};
S.prototype._adaptSelectable=function(o){var s=o.getEditable();if(o.getSelectable()!==s){o.setSelectable(s);if(!s){this._removePreviousHover();}this.fireElementEditableChange({editable:s});}};
S.prototype.deregisterElementOverlay=function(o){o.detachBrowserEvent("click",this._selectOverlay,this);o.detachBrowserEvent("contextmenu",this._selectOverlay,this);o.detachBrowserEvent("keydown",this._onKeyDown,this);o.detachBrowserEvent("mousedown",this._onMouseDown,this);o.detachBrowserEvent("mouseover",this._onMouseover,this);o.detachBrowserEvent("mouseleave",this._onMouseleave,this);o.detachEditableChange(this._onEditableChange,this);};
S.prototype._setFocusOnOverlay=function(o,e){if(o&&o.getSelectable()){o.focus();e.stopPropagation();}};
S.prototype._onKeyDown=function(e){if(!this.getIsActive()){return;}var o=U.getFocusedOverlay();if(e.keyCode===K.ENTER){this._selectOverlay(e);}else if(e.keyCode===K.ARROW_UP&&e.shiftKey===false&&e.altKey===false){if(o){var d=U.getFocusableParentOverlay(o);this._setFocusOnOverlay(d,e);e.preventDefault();}}else if(e.keyCode===K.ARROW_DOWN&&e.shiftKey===false&&e.altKey===false){if(o){var f=U.getFirstFocusableDescendantOverlay(o);this._setFocusOnOverlay(f,e);e.preventDefault();}}else if(e.keyCode===K.ARROW_LEFT&&e.shiftKey===false&&e.altKey===false){if(o){var g=U.getPreviousFocusableSiblingOverlay(o);this._setFocusOnOverlay(g,e);e.preventDefault();}}else if(e.keyCode===K.ARROW_RIGHT&&e.shiftKey===false&&e.altKey===false){if(o){var n=U.getNextFocusableSiblingOverlay(o);this._setFocusOnOverlay(n,e);e.preventDefault();}}else if(e.keyCode===K.ESCAPE){if(o){this._deselectOverlays();}}};
S.prototype._deselectOverlays=function(){this.getDesignTime().getSelectionManager().reset();};
S.prototype._selectOverlay=function(e){if(!this.getIsActive()){p(e);return;}var o=O.getOverlay(e.currentTarget.id);var m=e.metaKey||e.ctrlKey;var C=e.type==="contextmenu";if(o&&o.getSelectable()){if(o.isSelected()){if(!C){this.getDesignTime().getSelectionManager().remove(o);}}else if(m){this.getDesignTime().getSelectionManager().add(o);}else{this.getDesignTime().getSelectionManager().set(o);}p(e);}else if(o&&o.isRoot()){p(e);}};
S.prototype._onMouseDown=function(e){if(!this.getIsActive()){p(e);I.getOpenPopovers().forEach(function(d){if(d._bOpenedByChangeIndicator){d.close();}});return;}if(D.browser.name==="ie"){var t=O.getOverlay(e.target.id);var T=jQuery(e.target).hasClass("sapUiDtOverlayScrollContainer");var o=O.getOverlay(e.currentTarget.id);if(o&&(T||t instanceof a)){if(o.getSelectable()){o.focus();e.stopPropagation();}else{o.getDomRef().blur();}}}};
S.prototype._onMouseover=function(e){if(!this.getIsActive()){p(e);return;}var o=O.getOverlay(e.currentTarget.id);if(o.isSelectable()){if(o!==this._oHoverTarget){this._removePreviousHover();this._oHoverTarget=o;o.addStyleClass("sapUiRtaOverlayHover");}p(e);}};
S.prototype._onMouseleave=function(e){if(!this.getIsActive()){p(e);return;}var o=O.getOverlay(e.currentTarget.id);if(o.isSelectable()){this._removePreviousHover();p(e);}};
S.prototype._removePreviousHover=function(){if(this._oHoverTarget){this._oHoverTarget.removeStyleClass("sapUiRtaOverlayHover");}delete this._oHoverTarget;};
S.prototype.setDesignTime=function(){if(this.getDesignTime()){this.getDesignTime().getSelectionManager().removeValidator(this._multiSelectionValidator);}P.prototype.setDesignTime.apply(this,arguments);if(this.getDesignTime()){this.getDesignTime().getSelectionManager().addValidator(this._multiSelectionValidator);}};
S.prototype._multiSelectionValidator=function(e){return(e.length===1||(h(e,this.getMultiSelectionRequiredPlugins())&&b(e)&&(c(e)||i(e))));};
return S;});
sap.ui.predefine('sap/ui/rta/plugin/Settings',["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/dt/Util","sap/base/Log"],function(P,U,D,B){"use strict";
var S=P.extend("sap.ui.rta.plugin.Settings",{metadata:{library:"sap.ui.rta",properties:{commandStack:{type:"any"}},associations:{},events:{}}});
var p="CTX_SETTINGS";
S.prototype._isEditable=function(o){var s=this.getAction(o);if(s){if(s.handler){return this.hasStableId(o);}var h=Object.keys(s).some(function(a){var b=s[a];return b.handler&&this._checkRelevantContainerStableID(b,o);}.bind(this));if(h){return this.hasStableId(o);}}return false;};
S.prototype.isEnabled=function(e){var E=e[0];var a=this.getAction(E);if(!a){return false;}if(typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){return a.isEnabled(E.getElement());}return a.isEnabled;}return true;};
S.prototype._getUnsavedChanges=function(i,c){var e;var u=this.getCommandStack().getAllExecutedCommands().filter(function(C){e=C.getElementId&&C.getElementId()||C.getElement&&C.getElement().getId();return e===i&&c.indexOf(C.getChangeType())>=0;}).map(function(C){return C.getPreparedChange();});return u;};
S.prototype._handleFlexChangeCommand=function(c,s,C,o){var m=c.changeSpecificData;var v;var a=c.selectorElement||c.selectorControl;var b;var d;if(a.controlType){b=a.controlType;}else{d=a;}return this.hasChangeHandler(m.changeType,d,b).then(function(h){if(s[0].getVariantManagement&&h&&!o.CAUTION_variantIndependent){v=s[0].getVariantManagement();}return this.getCommandFactory().getCommandFor(a,"settings",m,undefined,v);}.bind(this)).then(function(e){var r=o.runtimeOnly;if(e&&r){e.setRuntimeOnly(r);}return C.addCommand(e);});};
S.prototype._handleAppDescriptorChangeCommand=function(c,e,C){var m=c.changeSpecificData;var o=c.appComponent;var M=o.getManifest();var r=M["sap.app"].id;return this.getCommandFactory().getCommandFor(e,"appDescriptor",{reference:r,appComponent:o,changeType:m.appDescriptorChangeType,parameters:m.content.parameters,texts:m.content.texts}).then(function(a){return C.addCommand(a);});};
S.prototype._handleCompositeCommand=function(e,E,c,s){var C;return this.getCommandFactory().getCommandFor(E,"composite").then(function(_){C=_;}).then(function(){return c.map(function(m){var a=m.changeSpecificData;if(a.changeType){return this._handleFlexChangeCommand(m,e,C,s);}else if(a.appDescriptorChangeType){return this._handleAppDescriptorChangeCommand(m,E,C);}},this);}.bind(this)).then(function(a){return Promise.all(a);}).then(function(){if(C.getCommands().length>0){this.fireElementModified({command:C});}}.bind(this));};
S.prototype.handler=function(e,m,s){m=m||{};var E=e[0].getElement();var h=m.fnHandler;if(!h){h=e[0].getDesignTimeMetadata().getAction("settings").handler;if(!h){throw new Error("Handler not found for settings action");}}m.getUnsavedChanges=this._getUnsavedChanges.bind(this);m.styleClass=U.getRtaStyleClassName();return h(E,m).then(function(c){if(c.length>0){return this._handleCompositeCommand(e,E,c,s);}}.bind(this)).catch(function(v){throw D.propagateError(v,"Settings#handler","Error occured during handler execution","sap.ui.rta.plugin");});};
S.prototype.getMenuItems=function(e){var E=e[0];var s=this.getAction(E);var m=[];if(s){var r=110;if(s.handler){s={settings:s};}var a=Object.keys(s);a.forEach(function(b,i,A){var o=s[b];if(o.handler&&this._checkRelevantContainerStableID(o,E)&&this.isAvailable([E])){var c=A.length===1;m.push({id:c?p:p+i,rank:c?r:r+i,text:this.getActionText(E,o,p),icon:g(o),enabled:(typeof o.isEnabled==="function"&&function(e){return o.isEnabled(e[0].getElement());}||o.isEnabled||this.isEnabled([E])),handler:function(h,e,d){d=d||{};d.fnHandler=h;return this.handler(e,d,o);}.bind(this,o.handler),submenu:f(o.submenu)});}else{B.warning("Handler not found for settings action '"+b+"' or relevant container has no stable id");}},this);}return m;};
function f(s){if(s){return s.map(function(o,i){return{id:o.key||p+"_SUB_"+i,icon:o.icon||"blank",text:o.name||"",enabled:o.hasOwnProperty("enabled")?o.enabled:true};});}}
function g(s){var d="sap-icon://key-user-settings";var a=s.icon;if(!a){return d;}if(typeof a!=="string"){B.error("Icon setting for settingsAction should be a string");return d;}return a;}
S.prototype.getActionName=function(){return"settings";};
return S;});
sap.ui.predefine('sap/ui/rta/plugin/Split',["sap/ui/rta/plugin/Plugin","sap/ui/dt/Util","sap/ui/fl/Utils","sap/base/util/uid"],function(P,D,F,u){"use strict";
var S=P.extend("sap.ui.rta.plugin.Split",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
S.prototype._isEditable=function(o){var s=this.getAction(o);if(s&&s.changeType&&s.changeOnRelevantContainer){var r=o.getRelevantContainer();return this.hasChangeHandler(s.changeType,r).then(function(h){return h&&this.hasStableId(o)&&this._checkRelevantContainerStableID(s,o);}.bind(this));}return false;};
S.prototype.isAvailable=function(e){if(e.length!==1){return false;}var E=e[0];if(!this._isEditableByPlugin(E)){return false;}var s=this.getAction(E);var o=E.getElement();if(s&&s.getControlsCount(o)<=1){return false;}return true;};
S.prototype.isEnabled=function(e){var E=e[0];var a=this.getAction(E);if(!a||!this.isAvailable(e)){return false;}var A=true;if(typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){A=a.isEnabled(E.getElement());}else{A=a.isEnabled;}}return A;};
S.prototype.handleSplit=function(e){var s=e.getElement();var p=s.getParent();var d=e.getDesignTimeMetadata();var E=this.getAction(e).getControlsCount(s);var v=F.getViewForControl(s);var n=[];for(var i=0;i<E;i++){n.push(v.createId(u()));}var o=this.getAction(e);var V=this.getVariantManagementReference(e,o);return this.getCommandFactory().getCommandFor(s,"split",{newElementIds:n,source:s,parentElement:p},d,V).then(function(a){this.fireElementModified({command:a});}.bind(this)).catch(function(a){throw D.propagateError(a,"Split#handleSplit","Error occured during handleSplit execution","sap.ui.rta.plugin");});};
S.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_UNGROUP_FIELDS",rank:100,icon:"sap-icon://split"});};
S.prototype.getActionName=function(){return"split";};
S.prototype.handler=function(e){this.handleSplit(e[0]);};
return S;});
sap.ui.predefine('sap/ui/rta/plugin/Stretch',["sap/ui/rta/plugin/Plugin","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/base/util/includes","sap/base/util/restricted/_debounce"],function(P,O,a,b,_){"use strict";
var S=P.extend("sap.ui.rta.plugin.Stretch",{metadata:{library:"sap.ui.rta",properties:{},associations:{stretchCandidates:{type:"sap.ui.core.Control",multiple:true}},events:{}}});
S.STRETCHSTYLECLASS="sapUiRtaStretchPaddingTop";
function s(p,o){return(p&&p.getGeometry()&&o.getGeometry()&&p.getGeometry().position.top===o.getGeometry().position.top&&p.getGeometry().position.left===o.getGeometry().position.left);}
function t(o,A){var e=o.getElement();if(e.addStyleClass&&e.removeStyleClass){if(A){e.addStyleClass(S.STRETCHSTYLECLASS);}else{e.removeStyleClass(S.STRETCHSTYLECLASS);}}else{var E=o.getAssociatedDomRef();if(E){if(A){E.addClass(S.STRETCHSTYLECLASS);}else{E.removeClass(S.STRETCHSTYLECLASS);}}}}
function c(r,C,i){var p=r.getGeometry();if(!p){return false;}var h=p.size.height;if(i){h-=parseInt(jQuery(p.domRef).css("padding-top"));}var e=Math.round(p.size.width)*Math.round(h);C=C||a.getAllChildOverlays(r);var f=C.map(function(j){return j.getGeometry();});var o=a.getGeometry(f);if(!o){return false;}var g=Math.round(o.size.width)*Math.round(o.size.height);return g===e;}
function d(r,C){var A=C.some(function(o){return o.getEditable()&&o.getGeometry();});if(A){return true;}var e=[];C.forEach(function(o){e=e.concat(a.getAllChildOverlays(o));});if(!e.length){return false;}if(c(r,e)){return d(r,e);}return false;}
S.prototype.setDesignTime=function(D){P.prototype.setDesignTime.apply(this,arguments);if(D){D.attachEventOnce("synced",this._onDTSynced,this);}};
S.prototype.exit=function(){if(this.getDesignTime()){this.getDesignTime().detachEvent("elementOverlayAdded",this._onElementOverlayChanged);this.getDesignTime().detachEvent("elementOverlayMoved",this._onElementOverlayChanged);this.getDesignTime().detachEvent("elementPropertyChanged",this._onElementPropertyChanged);this.getDesignTime().detachEvent("elementOverlayEditableChanged",this._onElementOverlayEditableChanged);this.getDesignTime().detachEvent("elementOverlayDestroyed",this._onElementOverlayDestroyed);}};
S.prototype.addStretchCandidate=function(o){var e=o.getElement();if(!b(this.getStretchCandidates(),e.getId())){this.addAssociation("stretchCandidates",e);}};
S.prototype.removeStretchCandidate=function(o){this.removeAssociation("stretchCandidates",o.getElement());t(o,false);};
S.prototype.registerElementOverlay=function(o){this._checkParentAndAddToStretchCandidates(o);o.attachElementModified(this._onElementModified,this);P.prototype.registerElementOverlay.apply(this,arguments);};
S.prototype.deregisterElementOverlay=function(o){t(o,false);};
S.prototype._isEditable=function(){return false;};
S.prototype._onDTSynced=function(){this._setStyleClassForAllStretchCandidates();this.getDesignTime().attachEvent("elementOverlayAdded",this._onElementOverlayChanged,this);this.getDesignTime().attachEvent("elementOverlayMoved",this._onElementOverlayChanged,this);this.getDesignTime().attachEvent("elementPropertyChanged",this._onElementPropertyChanged,this);this.getDesignTime().attachEvent("elementOverlayEditableChanged",this._onElementOverlayEditableChanged,this);this.getDesignTime().attachEvent("elementOverlayDestroyed",this._onElementOverlayDestroyed,this);};
S.prototype._onElementModified=function(e){if(this.getDesignTime().getBusyPlugins().length){return;}var p=e.getParameters();var o=e.getSource();if(p.type==="afterRendering"){if(!this.fnDebounced){this.fnDebounced=_(function(){this._setStyleClassForAllStretchCandidates(this._getNewStretchCandidates(this._aOverlaysCollected));this._aOverlaysCollected=[];this.fnDebounced=undefined;}.bind(this),16);}if(!this._aOverlaysCollected){this._aOverlaysCollected=[];}if(!b(this._aOverlaysCollected,o)){this._aOverlaysCollected.push(o);this.fnDebounced();}}};
S.prototype._onElementOverlayDestroyed=function(e){if(this.getDesignTime().getBusyPlugins().length){return;}var n=[];var p=e.getParameters().elementOverlay.getParentElementOverlay();if(p&&!p._bIsBeingDestroyed){var r=this._getRelevantOverlays(p).filter(function(o){return o.getElement();});n=this._getNewStretchCandidates(r);}this._setStyleClassForAllStretchCandidates(n);};
S.prototype._onElementOverlayEditableChanged=function(e){var o=O.getOverlay(e.getParameters().id);if(this.getDesignTime().getBusyPlugins().length||!o){return;}var f=this._getRelevantOverlaysOnEditableChange(o);this._setStyleClassForAllStretchCandidates(f);};
S.prototype._onElementPropertyChanged=function(e){var o=O.getOverlay(e.getParameters().id);if(this.getDesignTime().getBusyPlugins().length||!o){return;}var r=this._getRelevantOverlays(o);var D=_(function(){if(!this.bIsDestroyed&&!o.bIsDestroyed){var n=this._getNewStretchCandidates(r).concat(this._getRelevantOverlaysOnEditableChange(o));n=n.filter(function(i,p,A){return A.indexOf(i)===p;});this._setStyleClassForAllStretchCandidates(n);}}.bind(this));r.forEach(function(o){o.attachEventOnce("geometryChanged",D);});};
S.prototype._onElementOverlayChanged=function(e){var o=O.getOverlay(e.getParameters().id);if(this.getDesignTime().getBusyPlugins().length||!o){return;}var r=this._getRelevantOverlays(o);var n=this._getNewStretchCandidates(r);this._setStyleClassForAllStretchCandidates(n);};
S.prototype._getRelevantOverlaysOnEditableChange=function(o){var r=b(this.getStretchCandidates(),o.getElement().getId())?[o.getElement().getId()]:[];var p=o.getParentAggregationOverlay();if(!p){return r;}var e=p.getChildren();e.splice(e.indexOf(o),1);var A=e.some(function(o){return o.getEditable()&&o.getGeometry();});if(A){return r;}return r.concat(this._getRelevantParents(o));};
S.prototype._getRelevantParents=function(o){var r=[];for(var i=0;i<25;i++){o=o.getParentElementOverlay();if(!o){return r;}if(!b(this.getStretchCandidates(),o.getElement().getId())){return r;}r.push(o.getElement().getId());}};
S.prototype._getNewStretchCandidates=function(o){var n=[];o.forEach(function(e){if(this._reevaluateStretching(e)){n.push(e.getElement().getId());}},this);return n;};
S.prototype._reevaluateStretching=function(o){if(!o.bIsDestroyed){var e=o.getAssociatedDomRef();if(e){var i=e.hasClass(S.STRETCHSTYLECLASS);var f=c(o,undefined,i);if(i&&!f){this.removeStretchCandidate(o);}else if(!i&&f){this.addStretchCandidate(o);return true;}}}};
S.prototype._checkParentAndAddToStretchCandidates=function(o){var p=o.getParentElementOverlay();var $=p&&p.getAssociatedDomRef();if($){if(s(p,o)){if(c(p)){this.addStretchCandidate(p);}}}};
S.prototype._setStyleClassForAllStretchCandidates=function(e){if(!Array.isArray(e)){e=this.getStretchCandidates();}e.forEach(function(E){var o=O.getOverlay(E);var C=a.getAllChildOverlays(o);var A=o.getEditable()&&d(o,C);t(o,A);},this);};
return S;});
sap.ui.predefine('sap/ui/rta/plugin/additionalElements/ActionExtractor',["sap/base/util/restricted/_difference","sap/base/util/merge","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/fl/apply/api/DelegateMediatorAPI","sap/ui/rta/plugin/additionalElements/AdditionalElementsUtils","sap/ui/rta/Utils"],function(d,m,L,J,E,O,D,A,U){"use strict";var a={};
function l(){var k=[];var r=D.getKnownDefaultDelegateLibraries();r.forEach(function(s){var o=sap.ui.getCore().loadLibrary(s,{async:true}).then(function(){return Promise.resolve(s);}).catch(function(v){L.warning("Required library not available: ",v);return Promise.resolve();});k.push(o);});return Promise.all(k);}
function g(k,o,p){return p.hasChangeHandler(k.changeType,k.element).then(function(H){if(H){return{aggregationName:k.aggregation,addPropertyActionData:{designTimeMetadata:o,action:k,delegateInfo:{payload:k.delegateInfo.payload||{},delegate:k.delegateInfo.instance,modelType:k.delegateInfo.modelType,requiredLibraries:k.delegateInfo.requiredLibraries}}};}return undefined;});}
function c(s,S,p){var P=A.getParents(s,S,p);var o=P.parentOverlay&&P.parentOverlay.getDesignTimeMetadata();var k=o?o.getActionDataFromAggregations("addODataProperty",P.parent):[];if(k.length>0){L.error("Outdated addODataProperty action in designtime metadata in "+o.getData().designtimeModule+" or propagated or via instance specific designtime metadata.");}}
function b(p,s,P){var o=p.getElement();if(!o){return[];}var I=E.getAggregation(o,s,P).filter(function(C){var k=O.getOverlay(C);if(!P.hasStableId(k)){return false;}var r=p.getRelevantContainer(true);var R=O.getOverlay(r);var n=p;var q=false;do{q=!n.getElementVisibility();if(q){break;}if(n===R){break;}else{n=n.getParentElementOverlay();}}while(n);if(q){return true;}return k.getElementVisibility()===false;},this);return I.map(function(k){return{element:k,sourceAggregation:s};});}
function e(p,C){return C.sParentAggregationName;}
function i(C,p,k,P){var v=k.changeType&&P.hasStableId(C);if(v&&C!==p.relevantContainerOverlay){v=P.hasStableId(p.relevantContainerOverlay);}return v;}
function f(k,p,P,n){function F(o,q){var C=q.changeOnRelevantContainer?p.relevantContainer:p.parent;var r=O.getOverlay(C);var v=i(r,p,q,P);if(v){q.element=C;return D.getDelegateForControl({control:p.relevantContainer,modifier:J,supportsDefault:q.supportsDefaultDelegate}).then(function(s){if(s&&s.names&&s.names.length){var R=D.getRequiredLibrariesForDefaultDelegate({delegateName:s.names,control:p.relevantContainer});if(d(R,n.filter(Boolean)).length===0){q.delegateInfo=s;o.push(q);}}return o;});}return o;}return k.reduce(function(o,q){return o.then(function(r){return F(r,q);});},Promise.resolve([]));}
function h(p,_,s,k,P){var I=p.reduce(function(n,q){var t=[];k.forEach(function(u){t=t.concat(b.call(this,q,u,P));}.bind(this),[]);return q?n.concat(t):n;}.bind(this),[]);var o={elements:[],controlTypeNames:[]};var r=I.reduce(function(n,q){return n.then(function(R){return j(R,q,P,s);});},Promise.resolve(o));return r.then(function(R){if(R.elements.length>0){_[s]={reveal:R};}return _;});}
function j(r,I,p,t){return Promise.resolve().then(function(){var o=I.element;var k;var R;var n=false;var H=Promise.resolve();var s=I.sourceAggregation;var q=O.getOverlay(o);if(q){k=q.getDesignTimeMetadata();R=k&&k.getAction("reveal",o);if(R&&R.changeType){var u=o;if(R.changeOnRelevantContainer){u=q.getRelevantContainer();}H=p.hasChangeHandler(R.changeType,u).then(function(v){var P=A.getParents(true,q,p);if(v){if(R.changeOnRelevantContainer){n=p.hasStableId(P.relevantContainerOverlay)&&p.hasStableId(P.parentOverlay);}else{n=true;}if(!R.getAggregationName){R.getAggregationName=e;}if(n&&(s!==t)){var w=P.parentOverlay.getAggregationOverlay(t);return U.checkTargetZone(w,q,p);}}return n;});}}return H.then(function(v){if(v){r.elements.push({element:o,designTimeMetadata:k,action:R,sourceAggregation:s,targetAggregation:t});var N=k.getName(o);if(N){r.controlTypeNames.push(N);}}return r;});});}
a.getActions=function(s,S,p,I){var k=s?"asSibling":"asChild";if(!I&&S._mAddActions){return Promise.resolve(S._mAddActions[k]);}var r=this._getRevealActions(s,S,p);var o=this._getAddViaDelegateActions(s,S,p);var C=this._getCustomAddActions(s,S,p);return Promise.all([r,o,C,c(s,S,p)]).then(function(n){var q=m(n[0],n[1],n[2]);S._mAddActions=S._mAddActions||{asSibling:{},asChild:{}};S._mAddActions[k]=q;return q;});};
a.getActionsOrUndef=function(s,o){var S=s?"asSibling":"asChild";return o._mAddActions&&o._mAddActions[S];};
a._getRevealActions=function(s,S,p){var P=A.getParents(s,S,p);var k=[P.parentOverlay];if(P.relevantContainer!==P.parent){k=E.findAllSiblingsInContainer(P.parent,P.relevantContainer).map(function(o){return O.getOverlay(o);}).filter(function(o){return o;});}var n=[];if(P.parentOverlay){n=P.parentOverlay.getAggregationOverlays().filter(function(o){return!o.getDesignTimeMetadata().isIgnored(P.parent);}).map(function(o){return o.getAggregationName();});return n.reduce(function(o,q){return o.then(function(r){return h(k,r,q,n,p);});},Promise.resolve({}));}return Promise.resolve({});};
a._getAddViaDelegateActions=function(s,S,p){var P=A.getParents(s,S,p);var o=P.parentOverlay&&P.parentOverlay.getDesignTimeMetadata();return Promise.resolve().then(function(){var k=o?o.getActionDataFromAggregations("add",P.parent,undefined,"delegate"):[];if(k.length){return l().then(f.bind(this,k,P,p));}return[];}.bind(this)).then(function(k){return k.reduce(function(n,q){return n.then(function(r){return g.call(this,q,o,p).then(function(t){if(t){t.addPropertyActionData.relevantContainer=P.relevantContainer;if(!r[t.aggregationName]){r[t.aggregationName]={};}r[t.aggregationName].addViaDelegate=t.addPropertyActionData;}return r;});}.bind(this));}.bind(this),Promise.resolve({}));}.bind(this));};
a._getCustomAddActions=function(s,o,p){var P=A.getParents(s,o,p);var k=P.parentOverlay&&P.parentOverlay.getDesignTimeMetadata();var n=k&&k.getActionDataFromAggregations("add",P.parent,undefined,"custom")||[];function q(r,C){var I=[];return Promise.resolve().then(function(){if(r&&typeof r.getItems==="function"){var t=O.getOverlay(C);if(p.hasStableId(t)){return r.getItems(C);}}return I;}).then(function(t){I=t||[];var u=I.reduce(function(v,w){if(w.changeSpecificData.changeOnRelevantContainer){C=P.relevantContainer;}if(w.changeSpecificData.changeType){v.push(p.hasChangeHandler(w.changeSpecificData.changeType,C));}return v;},[]);return Promise.all(u);}).then(function(H){if(H.indexOf(false)===-1){return{aggregationName:r.aggregation,addViaCustom:{designTimeMetadata:k,action:r,items:I}};}return undefined;});}var C=P.parent;return n.reduce(function(r,t){return r.then(function(R){return q.call(this,t,C).then(function(u){if(u){R[u.aggregationName]={addViaCustom:u.addViaCustom};}return R;});}.bind(this));}.bind(this),Promise.resolve({}));};
return a;});
sap.ui.predefine('sap/ui/rta/plugin/additionalElements/AddElementsDialog',["sap/ui/base/ManagedObject","sap/ui/core/Fragment","sap/ui/fl/write/api/FieldExtensibility","sap/ui/model/json/JSONModel","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/resource/ResourceModel","sap/ui/model/Sorter","sap/ui/rta/Utils"],function(M,F,a,J,b,c,R,S,U){"use strict";
var A=M.extend("sap.ui.rta.plugin.additionalElements.AddElementsDialog",{metadata:{library:"sap.ui.rta",properties:{customFieldEnabled:{type:"boolean",defaultValue:false},businessContextVisible:{type:"boolean",defaultValue:false},title:{type:"string"}},events:{opened:{},openCustomField:{}}}});
var r;
A.prototype.init=function(){this._oDialogPromise=F.load({id:this.getId(),name:"sap.ui.rta.plugin.additionalElements.AddElementsDialog",controller:this});this._oDialogModel=new J({elements:[],customFieldEnabled:false,customFieldVisible:false,businessContextVisible:false,customFieldButtonTooltip:"",businessContextTexts:[{text:""}]});this._oDialogPromise.then(function(d){d.setModel(this._oDialogModel);if(!r){r=new R({bundleName:"sap.ui.rta.messagebundle"});}d.setModel(r,"i18n");d.addStyleClass(U.getRtaStyleClassName());this._oDialogModel.setProperty("/listNoDataText",r.getProperty("MSG_NO_FIELDS").toLowerCase());this._oList=sap.ui.getCore().byId(this.getId()+"--rta_addElementsDialogList");this._bDescendingSortOrder=false;}.bind(this));};
A.prototype.exit=function(){this._oDialogPromise.then(function(d){d.destroy();});if(M.prototype.exit){M.prototype.exit.apply(this,arguments);}};
A.prototype.setCustomFieldButtonVisible=function(v){this._oDialogModel.setProperty("/customFieldVisible",v);};
A.prototype._submitDialog=function(){return this._oDialogPromise.then(function(d){d.close();this._fnResolveOnDialogConfirm();}.bind(this));};
A.prototype._cancelDialog=function(){this._oDialogModel.getObject("/elements").forEach(function(e){e.selected=false;});this._oDialogPromise.then(function(d){d.close();});this._fnRejectOnDialogCancel();};
A.prototype.setElements=function(e){this._oDialogModel.setProperty("/elements",e);};
A.prototype.getElements=function(){return this._oDialogModel.getProperty("/elements");};
A.prototype.getSelectedElements=function(){return this._oDialogModel.getObject("/elements").filter(function(e){return e.selected;});};
A.prototype.open=function(){return new Promise(function(d,e){this._fnResolveOnDialogConfirm=d;this._fnRejectOnDialogCancel=e;this._oDialogPromise.then(function(D){D.attachAfterOpen(function(){this.fireOpened();}.bind(this));D.open();}.bind(this));}.bind(this));};
A.prototype._resortList=function(){this._bDescendingSortOrder=!this._bDescendingSortOrder;var B=this._oList.getBinding("items");var s=[];s.push(new S("label",this._bDescendingSortOrder));B.sort(s);};
A.prototype._updateModelFilter=function(e){var v=e.getParameter("newValue");var B=this._oList.getBinding("items");if((typeof v)==="string"){var f=new b("label",c.Contains,v);var o=new b("originalLabel",c.Contains,v);var p=new b("parentPropertyName",c.Contains,v);var d=new b("duplicateName",c.EQ,true);var P=new b({filters:[p,d],and:true});var g=new b({filters:[f,o,P],and:false});B.filter([g]);}else{B.filter([]);}};
A.prototype._redirectToCustomFieldCreation=function(){this.fireOpenCustomField();this._oDialogPromise.then(function(d){d.close();});};
A.prototype.setTitle=function(t){M.prototype.setProperty.call(this,"title",t,true);this._oDialogPromise.then(function(d){d.setTitle(t);});};
A.prototype.setCustomFieldEnabled=function(C){this.setProperty("customFieldEnabled",C,true);this._oDialogModel.setProperty("/customFieldEnabled",this.getProperty("customFieldEnabled"));};
A.prototype._setBusinessContextVisible=function(B){this.setProperty("businessContextVisible",B,true);this._oDialogModel.setProperty("/businessContextVisible",B);};
A.prototype.addExtensionData=function(e){this._removeExtensionDataTexts();var B=this._oDialogModel.getObject("/businessContextTexts");if(e&&e.length>0){e.forEach(function(C){B.push({text:C.description});},this);}else{B.push({text:r.getProperty("MSG_NO_BUSINESS_CONTEXTS")});}this._setBusinessContextVisible(true);return a.getTexts().then(function(f){if(f){this._oDialogModel.setProperty("/customFieldButtonTooltip",f.tooltip);this._oDialogModel.setProperty("/businessContextTexts/0/text",f.headerText);}}.bind(this));};
A.prototype._removeExtensionDataTexts=function(){var B=this._oDialogModel.getObject("/businessContextTexts");B.splice(1);};
return A;});
sap.ui.predefine('sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer',["sap/base/util/ObjectPath","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/dt/ElementUtil","sap/ui/fl/apply/api/DelegateMediatorAPI","sap/ui/rta/util/BindingsExtractor","sap/ui/thirdparty/jquery"],function(O,L,J,E,D,B,q){"use strict";
function _(j,H,M){if(!j){return false;}var I=j.getBindingInfo(H,M);var P=I&&I.path;if(!P){return false;}if(P.indexOf(">")>-1){P=P.split(">").pop();}return P.indexOf("/")===0;}
function a(j,H,I,M){var K;if(H){K=j.getBindingInfo(I,M);if(typeof K.model==="string"&&K.model!==M){K=undefined;}}else{K=j.getBindingContext(M);}return K;}
function b(j,H,M){var I=_(j,H,M);var K=a(j,I,H,M);if(K){return I?K.path:K.getPath();}}
function c(P){var j=P.reduce(function(H,I){if(Array.isArray(I.properties)){H=H.concat(I.properties.map(function(K){K.parentPropertyName=I.label||I.name;return K;}));}else{H.push(I);}return H;},[]);return j;}
function d(j,H,I){var P={element:j,aggregationName:H,payload:I.delegateInfo.payload||{}};return I.delegateInfo.delegate.getPropertyInfo(P).then(c.bind(null));}
function g(j,H){return D.getDelegateForControl({control:j,modifier:J,supportsDefault:true}).then(function(I){if(I&&I.instance){return I.instance.getPropertyInfo({element:j,aggregationName:H,payload:I.payload});}return[];});}
function e(j,H,I){var K=I.addViaDelegate;var M;if(K){M=d.bind(null,j,H,K);}else{M=g.bind(null,j,H);}return M().then(function(P){return m(P);});}
function f(P){return P.filter(function(j){return!(j.unsupported||j.hideFromReveal);});}
function h(P,j){j.type="custom";if(j.id){j.itemId=P+"-"+j.id;j.key=j.itemId;}return j;}
function i(P){return{selected:false,label:P.label||P.name,parentPropertyName:P.parentPropertyName?P.parentPropertyName:"",duplicateName:P.duplicateName?P.duplicateName:false,tooltip:P.tooltip||P.label,originalLabel:"",type:"delegate",entityType:P.entityType,name:P.name,bindingPath:P.bindingPath};}
function k(j){var H=j.element;var I=j.action;return{selected:false,label:H.__label||E.getLabelForElement(H,I.getLabel),tooltip:H.__tooltip||E.getLabelForElement(H,I.getLabel)||H.__bindingPath,parentPropertyName:H.__parentPropertyName?H.__parentPropertyName:"",duplicateName:H.__duplicateName?H.__duplicateName:false,originalLabel:H.__renamedLabel&&H.__label!==H.__originalLabel?H.__originalLabel:"",bindingPath:H.__bindingPath,type:"invisible",elementId:H.getId(),sourceAggregation:j.sourceAggregation};}
function l(j,R,H,M){if(R&&R!==j){var I=b(j,H,M);return E.findAllSiblingsInContainer(j,R).filter(function(S){return I===b(S,H,M);});}return[j];}
function m(P){P.forEach(function(M,H,P){if(M["duplicateName"]!==true){for(var j=H+1;j<P.length-1;j++){if(M.label===P[j].label){M["duplicateName"]=true;P[j]["duplicateName"]=true;}}}});return P;}
function n(I,P){return P.some(function(M){return M.label===I.__label;});}
function o(j){return Array.isArray(j)&&j.length>0;}
function p(j,P){return P.filter(function(M){return j.some(function(H){return H===M.bindingPath||H.startsWith(M.bindingPath+'/');});}).pop();}
function r(j){return(q.isPlainObject(j)?j.parts[0].path:!!j.getPath&&j.getPath());}
function s(j,H,M,I){var K=j.getModel(M);var R=l(j,H.relevantContainer,I,M);var N=[];R.forEach(function(j){N=N.concat(B.getBindings(j,K).map(r));});return N;}
function t(j,H){var P={element:j.relevantContainer,aggregationName:H,payload:j.delegateInfo.payload||{}};return j.delegateInfo.delegate.getRepresentedProperties(P);}
function u(j,H,M,I){return t(H,I).then(function(R){if(R===undefined){return s(j,H,M,I);}var K=[];R.forEach(function(N){K=K.concat(N.bindingPaths);});return K;});}
function v(j,H,M,I){return Promise.resolve().then(function(){var K=!!O.get("delegateInfo.delegate.getRepresentedProperties",H);if(K){return u(j,H,M,I);}return s(j,H,M,I);});}
function w(I,S){I.__originalLabel=S.label;I.__tooltip=S.tooltip;I.__bindingPath=S.name;if(I.__label!==I.__originalLabel){I.__renamedLabel=true;}if(S.parentPropertyName){I.__parentPropertyName=S.parentPropertyName;}}
function x(j,H){var I=!!O.get("delegateInfo.delegate.getRepresentedProperties",j);if(I){return t(j,H);}}
function y(I,R){var j;R.some(function(P){if(P.id===I.getId()){j=P;return true;}});return j.bindingPaths||[];}
function z(I,P,j,H){if(!o(j)){return true;}var M=p(j,P);if(M){if(M.hideFromReveal){return false;}w(I,M);return true;}return!H;}
function A(j,H,I,K,R,P){var M=K.addViaDelegate;var N=F(M);var Q=j.getModel(N);var S=true;var T=[];if(R){T=y(I,R);}else if(b(j,H,N)===b(I,H,N)){T=B.collectBindingPaths(I,Q).bindingPaths;}else if(M&&B.getBindings(I,Q).length>0){S=false;}if(S){I.__duplicateName=n(I,P);S=z(I,P,T,!!M);}return S;}
function C(I,j,H,K){var M=j.addViaCustom;if(M&&H){M.items.forEach(function(N){h(K.getParent().getId(),N);if(N.itemId===I.getId()){w(I,N);}});}}
function F(j){return O.get("delegateInfo.payload.modelName",j);}
var G={enhanceInvisibleElements:function(j,H){var R=H.reveal;var I=H.addViaDelegate;var K=j.getMetadata().getAggregation();var M=K?K.name:H.aggregation;return Promise.all([e(j,M,H),x(I,M)]).then(function(N){var P=N[0];var Q=N[1];var S=[];var T=R.elements||[];T.forEach(function(U){var V=U.element;var W=U.action;V.__label=E.getLabelForElement(V,W.getLabel);var X=A(j,M,V,H,Q,P);C(V,H,X,j);if(X){S.push({element:V,action:W,sourceAggregation:U.sourceAggregation});}});return S;}).then(function(N){return N.map(k);});},getUnrepresentedDelegateProperties:function(j,H){var M=F(H);var I=j.getMetadata().getAggregation();var K=I?I.name:H.action.aggregation;return Promise.all([d(j,K,H),v(j,H,M,K)]).then(function(N){var P=N[0];var R=N[1];var Q=H.action.filter?H.action.filter:function(){return true;};var U=f(P);U=U.filter(function(S){var T=false;if(R){T=R.some(function(V){return V===S.bindingPath;});}return!T&&Q(H.relevantContainer,S);});U=m(U);return U;}).then(function(U){return U.map(i);});},getCustomAddItems:function(j,H){return new Promise(function(R){if(Array.isArray(H.items)){R(H.items.map(h.bind(null,j.getParent().getId())).filter(function(I){if(!I.id){L.error("CustomAdd item with label "+I.label+" does not contain an 'id' property","sap.ui.rta.plugin.AdditionalElementsAnalyzer#showAvailableElements");return false;}return!E.getElementInstance(I.itemId);}));}else{R();}});},getFilteredItemsList:function(j){var I=j[0];var H=2;var K=j[H];if(K){var M=I.map(function(N){return N.elementId;});j[H]=K.filter(function(N){return!N.itemId||M.indexOf(N.itemId)===-1;});}return j.reduce(function(N,P){return N.concat(P);},[]);}};return G;});
sap.ui.predefine('sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin',["sap/base/util/each","sap/base/Log","sap/ui/core/IconPool","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/fl/write/api/FieldExtensibility","sap/ui/rta/plugin/additionalElements/AddElementsDialog","sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer","sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/rta/plugin/additionalElements/AdditionalElementsUtils","sap/ui/rta/plugin/additionalElements/CommandBuilder","sap/ui/rta/plugin/additionalElements/ActionExtractor"],function(e,L,I,O,a,F,A,b,P,U,c,C,d){"use strict";var S=true;var f=false;
function i(m,p){var r=p.responsibleElementOverlay.getParentAggregationOverlay().getAggregationName();return Object.keys(m).some(function(s){return s===r;});}
function h(o){return F.onControlSelected(o).then(function(){return Promise.all([U.isServiceUpToDate(o),F.isExtensibilityEnabled(o)]);}).then(function(r){var E=!!r[1];if(E){return F.getExtensionData(o);}return undefined;});}
var g=P.extend("sap.ui.rta.plugin.additionalElements.AdditionalElementsPlugin",{
constructor:function(p){p.dialog=new A();P.apply(this,arguments);},
metadata:{library:"sap.ui.rta",properties:{commandFactory:"object"},aggregations:{dialog:{type:"sap.ui.rta.plugin.additionalElements.AddElementsDialog",multiple:false}},associations:{},events:{}},
_getRelevantOverlays:function(o){var r=a.findAllOverlaysInContainer(o,true);o.setRelevantOverlays(r);return r;},
getContextMenuText:function(o,j,s,H){var t;function k(){t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");return t.getText("CTX_ADD_ELEMENTS",t.getText("MULTIPLE_CONTROL_NAME"));}if(s==="$$OnlyChildCustomField$$"){return k();}if(H){t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");return t.getText("CTX_ADD_ELEMENTS_WITH_SUBMENU");}var p=c.getParents(o,j,this);var m=d.getActionsOrUndef(o,j);if(!s){s=Object.keys(m)[0];}var l=m[s];if(!l){return k();}l.aggregation=s;return c.getText("CTX_ADD_ELEMENTS",l,p.parent,S);},
isAvailable:function(o,E){return E.every(function(j){return this._isEditableByPlugin(j,o);},this);},
isEnabled:function(o,E,s){if(E.length>1){return false;}if(this.getExtensibilityInfo(o)){return true;}var j=this.getResponsibleElementOverlay(E[0]);var p;var k=false;if(o){p=j.getParentElementOverlay();if(p){k=true;}}else{var m=d.getActionsOrUndef(o,j);var l=m[s];if(l&&((l.reveal&&l.reveal.elements.length>0)||l.addViaCustom||l.addViaDelegate)){k=true;}}var n=this.getCachedElements(o);var q=!!(n&&n.length>0);k=k&&q;return k;},
registerElementOverlay:function(o){var m=o.getElement().getModel();if(m){var M=m.getMetaModel();if(M&&M.loaded){M.loaded().then(function(){this.evaluateEditable([o],{onRegistration:true});}.bind(this));}}P.prototype.registerElementOverlay.apply(this,arguments);},
_checkIfCreateFunctionIsAvailable:function(m){return!m||(m&&m.content&&m.content.createFunction);},
showAvailableElements:function(o,s,r,j,k,D){var R=r[0];var p=c.getParents(o,R,this);var v=o&&R.getElement();var m;var l=[];return d.getActions(o,R,this).then(function(n){if(s==="$$OnlyChildCustomField$$"){return[];}m=n[s];return this.getAllElements(o,[p.responsibleElementOverlay],k,D);}.bind(this)).then(function(n){l=n;var E=this.getExtensibilityInfo(o);this.getDialog().setCustomFieldEnabled(!!E);if(E){this.getDialog().detachEvent("openCustomField",this._onOpenCustomField,this);this.getDialog().attachEvent("openCustomField",o,this._onOpenCustomField,this);this.getDialog().setCustomFieldButtonVisible(true);return this.getDialog().addExtensionData(E.extensionData);}return this.getDialog().setCustomFieldButtonVisible(false);}.bind(this)).then(function(){var n=l.filter(function(u){return u.aggregation===s;})[0];var E=n?n.elements:[];this.getDialog().setElements(E);if(D){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var q=t.getText("HEADER_ADDITIONAL_ELEMENTS_WITH_AGGREGATION",D);this.getDialog().setTitle(q);}else if(s||k){this._setDialogTitle(m||{},p.parent,k);}return this.getDialog().open().then(function(){var u=this.getDialog().getSelectedElements();return C.createCommands(p,v,m,j,u,s,this);}.bind(this)).then(function(){var u=O.getOverlay(v)||R;u.focus();}).catch(function(u){if(u instanceof Error){throw u;}});}.bind(this)).catch(function(E){if(E instanceof Error){throw E;}else{L.info("Service not up to date, skipping add dialog","sap.ui.rta");}});},
_setDialogTitle:function(m,p,s){var D=c.getText("HEADER_ADDITIONAL_ELEMENTS",m,p,f,s);this.getDialog().setTitle(D);},
_onOpenCustomField:function(E,o){var r=U.getRtaStyleClassName();return F.onTriggerCreateExtensionData(this.getExtensibilityInfo(o),r);},
_isEditable:function(o,p){return Promise.all([this._isEditableCheck(p.sourceElementOverlay,true),this._isEditableCheck(p.sourceElementOverlay,false)]).then(function(j){return{asSibling:j[0],asChild:j[1]};}).catch(function(E){L.error(E);});},
_isEditableCheck:function(o,j){return Promise.resolve().then(function(){var p=c.getParents(j,o,this);if(!p.relevantContainerOverlay){return false;}return d.getActions(j,o,this,true).then(function(m){this.clearCachedElements();return U.doIfAllControlsAreAvailable([o,p.parentOverlay],function(){var E=false;if(j){E=i(m,p);}else{E=Object.keys(m).some(function(s){if(m[s].addViaDelegate){E=this.checkAggregationsOnSelf(p.parentOverlay,"add",undefined,"delegate");}if(!E&&(m[s].reveal||m[s].addViaCustom)){return true;}return E;}.bind(this));}return E;}.bind(this));}.bind(this)).then(function(E){if(E){E=this.hasStableId(o)&&this.hasStableId(p.parentOverlay);}return E;}.bind(this));}.bind(this));},
getAllElements:function(o,E){var j=E[0];var p=c.getParents(o,j,this);var m;var k=[];var l=false;var n=this.getCachedElements(o);if(n){return n;}this.clearExtensibilityInfo(o);return d.getActions(o,j,this).then(function(q){e(q,function(s){m=q[s];m.aggregation=s;if(m.addViaDelegate){l=true;}k.push({aggregation:s,elementPromises:[m.reveal?b.enhanceInvisibleElements(p.parent,m):Promise.resolve([]),m.addViaDelegate?b.getUnrepresentedDelegateProperties(p.parent,m.addViaDelegate):Promise.resolve([]),m.addViaCustom?b.getCustomAddItems(p.parent,m.addViaCustom,m.aggregation):Promise.resolve([])]});});if(l){return h(p.parent);}return undefined;}).then(function(q){this.setExtensibilityInfo(o,q);}.bind(this)).then(this._combineAnalyzerResults.bind(this,k)).then(function(q){this.setCachedElements(q,o);return q;}.bind(this)).catch(function(q){throw q;});},
getMenuItems:function(E){var m=[];var M;this.clearCachedElements();return Promise.all([this.getAllElements(false,E),this.getAllElements(true,E)]).then(function(j){var H=j[0].length>0;var k=j[0].length>1;var l=j[1].length>0;var n=this.isAvailable(false,E);var o=this.isAvailable(true,E);if(o&&(!n||!H)){M=this._buildMenuItem("CTX_ADD_ELEMENTS_AS_SIBLING",true,E,j,false);}else if(!o&&n&&!k){M=this._buildMenuItem("CTX_ADD_ELEMENTS_AS_CHILD",false,E,j,false);}else if(!o&&n&&k){M=this._buildMenuItem("CTX_ADD_ELEMENTS_AS_CHILD",false,E,j,true);}else if(n&&o&&H&&l){M=this._buildMenuItem("CTX_ADD_ELEMENTS_CHILD_AND_SIBLING",false,E,j,true);}if(M){m.push(this.enhanceItemWithResponsibleElement(M,E,["addViaDelegate","reveal","custom"]));}return m;}.bind(this));},
_buildMenuItem:function(p,o,E,j,H){var s;var v;var k;var l=E[0];if(o){var m=c.getParents(o,l,this);k=m.responsibleElementOverlay.getParentAggregationOverlay().getAggregationName();}else{var n=j[0].length===0&&j[1].length===0;k=n?"$$OnlyChildCustomField$$":j[0]&&j[0][0]&&j[0][0].aggregation;}if(H){s=this._buildSubmenuItems(false,E,j[0]);if(p==="CTX_ADD_ELEMENTS_CHILD_AND_SIBLING"){s=s.concat(this._buildSubmenuItems(true,E,j[1]));}}else{v=function(o,E){return this.showAvailableElements(o,k,E);}.bind(this,o);}var M={id:p,text:this.getContextMenuText.bind(this,o,l,k,H),enabled:H||function(o,E){return this.isEnabled(o,E,k);}.bind(this,o),rank:20,icon:"sap-icon://add",handler:v};if(H){M.submenu=s;}return M;},
_buildSubmenuItems:function(o,E,j){var s=[];var p=o?"CTX_ADD_ELEMENTS_AS_SIBLING":"CTX_ADD_ELEMENTS_AS_CHILD";var k=0;I.registerFont({collectionName:"BusinessSuiteInAppSymbols",fontFamily:"BusinessSuiteInAppSymbols",fontURI:sap.ui.require.toUrl("sap/ushell/themes/base/fonts/"),lazy:true});function l(o,m,E){var n=o?E[0].getParentElementOverlay():E[0];var q=n.getDesignTimeMetadata();var N=q.getAggregationDisplayName(m,n.getElement());return N?N.singular:m;}j.forEach(function(m){var n=m.aggregation;var D=l(o,n,E);var q={id:p+'_'+k,text:D,enabled:function(o,E){return this.isEnabled(o,E,n);}.bind(this,o),handler:function(o,E){return this.showAvailableElements(o,n,E,undefined,undefined,D);}.bind(this,o),icon:o?"sap-icon://BusinessSuiteInAppSymbols/icon-add-outside":"sap-icon://add"};s.push(this.enhanceItemWithResponsibleElement(q,E,["addViaDelegate","reveal","custom"]));k++;}.bind(this));return s;},
_combineAnalyzerResults:function(j){var k=[];j.forEach(function(p){k.push(Promise.all(p.elementPromises).then(function(l){return{aggregation:p.aggregation,elements:b.getFilteredItemsList(l)};}));});return Promise.all(k).then(function(E){return E.filter(function(o){var l=o&&o.elements;return l.length>0;});});},
clearCachedElements:function(){this._oCachedElements=undefined;},
setCachedElements:function(E,o){this._oCachedElements=this._oCachedElements||{};this._oCachedElements[o?"asSibling":"asChild"]=E;},
getCachedElements:function(o){if(this._oCachedElements){return this._oCachedElements[o?"asSibling":"asChild"];}return undefined;},
clearExtensibilityInfo:function(o){if(this._oExtensibilityInfo){this._oExtensibilityInfo[o?"asSibling":"asChild"]=undefined;}},
setExtensibilityInfo:function(o,E){this._oExtensibilityInfo=this._oExtensibilityInfo||{};this._oExtensibilityInfo[o?"asSibling":"asChild"]=E;},
getExtensibilityInfo:function(o){if(this._oExtensibilityInfo){return this._oExtensibilityInfo[o?"asSibling":"asChild"];}return undefined;},
exit:function(){this.getDialog().destroy();if(P.prototype.exit){P.prototype.exit.apply(this,arguments);}}
});
return g;});
sap.ui.predefine('sap/ui/rta/plugin/additionalElements/AdditionalElementsUtils',["sap/ui/dt/OverlayRegistry"],function(O){"use strict";var A={};
function g(a){return(a["addViaDelegate"]&&a["addViaDelegate"].designTimeMetadata)||(a["addViaCustom"]&&a["addViaCustom"].designTimeMetadata);}
A.getParents=function(s,o,p){var P;var r=o;var R=["add.delegate","reveal","add.custom"].some(function(v){return p.isResponsibleElementActionAvailable(o,v);});if(R){r=p.getResponsibleElementOverlay(o);}var a=r.getRelevantContainer(!s);var b=O.getOverlay(a);if(s){P=r.getParentElementOverlay();}else{P=r;}return{responsibleElementOverlay:r,relevantContainerOverlay:b,parentOverlay:P,relevantContainer:a,parent:P&&P.getElement()};};
A.getText=function(r,a,p,s,c){var n=[];var C;var b;var d=a.aggregation;if(a.addViaCustom||a.addViaDelegate){var D=g(a);C=D.getAggregationDescription(d,p);if(C){b=s?C.singular:C.plural;n.push(b);}}if(a.reveal){a.reveal.controlTypeNames.forEach(function(C){b=s?C.singular:C.plural;n.push(b);});}var N=n.reduce(function(_,e){if(_.indexOf(e)===-1){_.push(e);}return _;},[]);var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");if(N.length===1){b=N[0];}else if(c){b=c;}else{b=t.getText("MULTIPLE_CONTROL_NAME");}return t.getText(r,[b]);};
return A;});
sap.ui.predefine('sap/ui/rta/plugin/additionalElements/CommandBuilder',["sap/base/Log","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/rta/Utils"],function(L,E,O,D,F,U){"use strict";var C={};
function g(A,r){var R;A.reveal.elements.some(function(m){if(m.element.getId()===r.getId()){R=m;return false;}return undefined;});return R;}
function c(p){var o=p.compositeCommand;var s=p.selectedElement;var P=p.parents;var S=p.siblingElement;var A=p.actions;var I=p.index;var t=p.targetAggregation;var j=p.plugin;return a(s,A,P,j).then(function(r){o.addCommand(r);return b(s,P,S,I,t,j);}).then(function(m){if(m){o.addCommand(m);}else{L.warning("No move action configured for "+P.parent.getMetadata().getName()+", aggregation: "+s.aggregation,"sap.ui.rta");}return o;});}
function a(s,A,p,P){var r=E.getElementInstance(s.elementId);var R=O.getOverlay(r);var m=g(A,r);var o=m.designTimeMetadata;var j=m.action;var v;if(R){v=P.getVariantManagementReference(R);}if(j.changeOnRelevantContainer){return P.getCommandFactory().getCommandFor(r,"reveal",{revealedElementId:r.getId(),directParent:p.parent},o,v);}return P.getCommandFactory().getCommandFor(r,"reveal",{},o,v);}
function b(s,p,S,I,t,P){var r=E.getElementInstance(s.elementId);var R=O.getOverlay(r);var j=s.sourceAggregation;var o=R.getParentElementOverlay().getElement()||p.parent;var T=p.parent;var k=U.getIndex(p.parent,S,t);var l=U.getIndex(o,r,j)-1;k=I!==undefined?I:E.adjustIndexForMove(o,T,l,k);if(k!==l||p.parent!==r.getParent()||j!==t){var m=O.getOverlay(r)?O.getOverlay(r).getParentAggregationOverlay():p.relevantContainerOverlay;var n=m.getDesignTimeMetadata();var v=P.getVariantManagementReference(R);return P.getCommandFactory().getCommandFor(p.relevantContainer,"move",{movedElements:[{element:r,sourceIndex:l,targetIndex:k}],source:{parent:o,aggregation:j},target:{parent:T,aggregation:t}},n,v);}return Promise.resolve();}
function d(o,r){var A=o.getManifestEntry("/sap.ui5/dependencies/libs");return Object.keys(r).some(function(R){return!A[R];});}
function e(p,r,P,o){if(r){var j=F.getAppComponentForControl(p.relevantContainer);var l=d(j,r);if(l){var m=j.getManifest();var R=m["sap.app"].id;return o.getCommandFactory().getCommandFor(p.publicParent,"addLibrary",{reference:R,parameters:{libraries:r},appComponent:j},P);}}return Promise.resolve();}
function f(p){var o=p.compositeCommand;var s=p.selectedElement;var P=p.parents;var S=p.siblingElement;var A=p.actions;var I=p.index;var j=p.plugin;var k=P.parent;var l=P.parentOverlay.getAggregationOverlay(A.aggregation).getDesignTimeMetadata();var m=Object.assign({changeOnRelevantContainer:s.changeSpecificData.changeOnRelevantContainer,aggregationName:A.aggregation,changeType:s.changeSpecificData.changeType,addElementInfo:s.changeSpecificData.content,index:I||U.getIndex(P.parent,S,A.aggregation)},s.itemId&&{customItemId:s.itemId});var v;if(P.relevantContainerOverlay){v=j.getVariantManagementReference(P.relevantContainerOverlay);}return j.getCommandFactory().getCommandFor(k,"customAdd",m,l,v).then(function(n){if(n){o.addCommand(n);}return o;});}
function h(p){var o=p.compositeCommand;var A=p.actions.addViaDelegate.action;var r=A.delegateInfo.requiredLibraries;var P=p.parents.parentOverlay.getAggregationOverlay(p.actions.aggregation);var j=P.getDesignTimeMetadata();return e(p.parents,r,j,p.plugin).then(function(k){if(k){o.addCommand(k);}return i(p,j);}).then(function(k){if(k){o.addCommand(k);}return o;});}
function i(p,P){var s=p.selectedElement;var m=p.parents;var S=p.siblingElement;var A=p.actions;var I=p.index;var o=p.plugin;var j=A.addViaDelegate.action;var k=j.changeOnRelevantContainer?m.relevantContainer:m.parent;var l=j.changeOnRelevantContainer?m.relevantContainerOverlay:m.parentOverlay;var v=o.getVariantManagementReference(l);var n=U.getIndex(m.parent,S,A.aggregation,P.getData().getIndex);var q="addDelegateProperty";var M=F.getAppComponentForControl(m.parent).getManifest();var r=F.getODataServiceUriFromManifest(M);return o.getCommandFactory().getCommandFor(m.parent,q,{newControlId:U.createFieldLabelId(k,s.entityType,s.bindingPath),index:I!==undefined?I:n,bindingString:s.bindingPath,entityType:s.entityType,parentId:m.parent.getId(),propertyName:s.name,oDataServiceVersion:s.oDataServiceVersion,oDataServiceUri:r,modelType:j.delegateInfo.modelType,relevantContainerId:m.relevantContainer.getId()},P,v);}
C.createCommands=function(p,s,A,I,S,t,P){S.sort(function(o,j){if(o.label>j.label){return-1;}if(o.label<j.label){return 1;}return 0;});if(S.length>0){return P.getCommandFactory().getCommandFor(p.parent,"composite").then(function(o){var j=Promise.resolve();S.forEach(function(k){var m={compositeCommand:o,selectedElement:k,parents:p,siblingElement:s,actions:A,index:I,targetAggregation:t,plugin:P};switch(k.type){case"invisible":j=j.then(c.bind(this,m));break;case"delegate":j=j.then(h.bind(this,m));break;case"custom":j=j.then(f.bind(this,m));break;default:L.error("Can't create command for untreated element.type "+k.type);}},this);return j.then(function(){return o;});}.bind(this)).then(function(o){P.fireElementModified({command:o});}).catch(function(m){throw D.propagateError(m,"AdditionalElementsPlugin#_createCommands","Error occured during _createCommands execution","sap.ui.rta.plugin");});}return Promise.resolve();};
return C;});
sap.ui.predefine('sap/ui/rta/plugin/iframe/AddIFrame',["sap/ui/rta/plugin/BaseCreate","sap/ui/fl/Utils","sap/ui/dt/Util","sap/base/util/uid","sap/ui/core/IconPool","sap/ui/rta/plugin/iframe/AddIFrameDialog"],function(B,F,D,u,I,A){"use strict";
function g(s,t,T,o){var S=!s;var c=this.getCreateAction(S,o,s);return T.getText(t,c.text);}
function a(m,s,d,v){var V=F.getViewForControl(m);var c=V.createId(u());var w;var H;if(s.frameWidth){w=s.frameWidth+s.frameWidthUnit;}else{w="100%";}if(s.frameHeight){H=s.frameHeight+s.frameHeightUnit;}else{H="100%";}return this.getCommandFactory().getCommandFor(m,"addIFrame",{targetAggregation:s.aggregation,baseId:c,index:s.index,url:s.frameUrl,width:w,height:H},d,v);}
function h(s,e){var r=e[0];var i=!s;var o=this.getCreateAction(i,r,s);var p=this._getParentOverlay(i,r);var P=p.getElement();var d=p.getDesignTimeMetadata();var c=0;if(i){var S=r.getElement();var G=d.getAggregation(o.aggregation).getIndex;c=this._determineIndex(P,S,o.aggregation,G);}var v=this.getVariantManagementReference(p);var f=new A();A.buildUrlBuilderParametersFor(P).then(function(U){var m={parameters:U};return f.open(m);}).then(function(m){if(!m){return Promise.reject();}m.index=c;m.aggregation=o.aggregation;return a.call(this,P,m,d,v);}.bind(this)).then(function(C){this.fireElementModified({command:C,newControlId:C.getBaseId(),action:o.getCreatedContainerId?o:undefined});}.bind(this)).catch(function(E){if(E){throw D.createError("AddIFrame#handler",E,"sap.ui.rta");}});}
var b=B.extend("sap.ui.rta.plugin.AddIFrame",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
b.prototype.isEnabled=function(s,e){var E=e[0];var S=!s;var o=this.getCreateAction(S,E,s);return this.isActionEnabled(o,S,E);};
b.prototype.getMenuItems=function(e){function c(f){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var j=t.getText("CTX_ADDIFRAME_GROUP");return{text:g.bind(this,f,"CTX_ADDIFRAME",t),handler:h.bind(this,f),enabled:this.isEnabled.bind(this,f),isSibling:!f,icon:"sap-icon://tnt/content-enricher",group:j};}I.registerFont({collectionName:"tnt",fontFamily:"SAP-icons-TNT",fontURI:sap.ui.require.toUrl("sap/tnt/themes/base/fonts"),lazy:true});var i=140;var m=[];var d=true;if(this.isAvailable(d,e)){var o=this.getCreateAction(d,e[0]);if(o){var s=Object.assign({id:"CTX_CREATE_SIBLING_IFRAME",rank:i,action:o},c.call(this));m.push(this.enhanceItemWithResponsibleElement(s,e));i+=10;}}d=false;if(this.isAvailable(d,e)){m=m.concat(this.getCreateActions(d,e[0]).map(function(o,f){var p=Object.assign({action:o,id:"CTX_CREATE_CHILD_IFRAME_"+o.aggregation.toUpperCase(),rank:i+10*f},c.call(this,o.aggregation));return this.enhanceItemWithResponsibleElement(p,e);},this));}return m;};
b.prototype.getActionName=function(){return"addIFrame";};
return b;});
sap.ui.predefine('sap/ui/rta/plugin/iframe/AddIFrameDialog',["sap/base/Log","sap/ui/base/ManagedObject","sap/ui/core/Fragment","sap/ui/core/library","sap/ui/model/json/JSONModel","sap/ui/rta/Utils","sap/ui/rta/plugin/iframe/AddIFrameDialogController","sap/ui/fl/util/getContainerUserInfo"],function(L,M,F,c,J,R,A,g){"use strict";var V=c.ValueState;var _=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var a="https://help.sap.com/viewer/4fc8d03390c342da8a60f8ee387bca1a/latest/en-US/8db25610e91342919fcf63d4e5868ae9.html";var b=_.getText("IFRAME_ADDIFRAME_DIALOG_URL_WARNING_TEXT")+" ("+"<a href="+a+">"+_.getText("IFRAME_ADDIFRAME_DIALOG_URL_WARNING_LINKTEXT")+"</a>"+")";var d={dialogTitle:_.getText("IFRAME_ADDIFRAME_DIALOG_TITLE"),dialogCreateTitle:_.getText("IFRAME_ADDIFRAME_DIALOG_TITLE"),dialogUpdateTitle:_.getText("IFRAME_ADDIFRAME_DIALOG_UPDATE_TITLE"),sizeTitle:_.getText("IFRAME_ADDIFRAME_DIALOG_SIZE_TITLE"),widthLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_WIDTH_LABEL"),widthUnitLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_WIDTH_UNITLABEL"),heightLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_HEIGHT_LABEL"),heightUnitLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_HEIGHT_UNITLABEL"),percentUseLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_PERCENT_USED"),saveText:_.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_SAVE"),cancelText:_.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_CANCEL"),previewUrlLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_PREVIEW_URL_LABEL"),previewUrlMessage:_.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_PREVIEW_MESSAGE"),previewButtonText:_.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_SHOW_PREVIEW"),showPreviewButton:_.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_SHOW_PREVIEW"),updatePreviewButton:_.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_UPDATE_PREVIEW"),previewFrameLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_PREVIEW_FRAME_LABEL"),parameterSearchLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_PARAMETER_SEARCH_LABEL"),editUrlLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_EDIT_URL_LABEL"),parametersLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_PARAMETERS_LABEL"),columnParameterLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_TABLE_PARAMETER_LABEL"),columnUiValueLabel:_.getText("IFRAME_ADDIFRAME_DIALOG_TABLE_UI_VALUE_LABEL")};
function e(s){if(s){d.dialogTitle=d.dialogUpdateTitle;}else{d.dialogTitle=d.dialogCreateTitle;}return new J({text:d,section:{visible:false},asNewSection:{value:false},sectionName:{value:"",valueState:V.None},frameWidth:{value:100,valueState:V.None,id:"sapUiRtaAddIFrameDialog_WidthInput"},frameWidthUnit:{value:"%"},frameHeight:{value:100,valueState:V.None,id:"sapUiRtaAddIFrameDialog_HeightInput"},frameHeightUnit:{value:"%"},frameUrl:{value:"",valueState:V.None},previewUrl:{value:""},documentationLink:{HTML:b},parameters:{value:[]},unitsOfMeasure:[{name:"%"},{name:"px"},{name:"rem"}]});}
var f=M.extend("sap.ui.rta.plugin.iframe.AddIFrameDialog",{metadata:{library:"sap.ui.rta",events:{opened:{}}}});
f.prototype.open=function(s){return new Promise(function(r){this._fnResolve=r;this._createDialog(s);}.bind(this));};
f.prototype._createDialog=function(s){var S=false;if(s){S=s.updateMode?s.updateMode:false;}this._oJSONModel=e(S);this._oController=new A(this._oJSONModel,s);F.load({name:"sap.ui.rta.plugin.iframe.AddIFrameDialog",controller:this._oController}).then(function(o){this._oDialog=o;this._oDialog.addStyleClass(R.getRtaStyleClassName());this._oDialog.setModel(this._oJSONModel);this._openDialog();}.bind(this)).catch(function(E){L.error("Error loading fragment sap.ui.rta.plugin.iframe.AddIFrameDialog: ",E);});};
f.prototype._openDialog=function(){this._oDialog.attachAfterOpen(function(){this._disablePanelExpand();this.fireOpened();}.bind(this));this._oDialog.attachAfterClose(function(){this._oDialog.destroy();this._oDialog=null;this._fnResolve(this._oController.getSettings());this._oController=null;}.bind(this));this._oDialog.open();};
f.prototype._disablePanelExpand=function(){var p=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog_PreviewLinkPanel").getDependents()[0];if(p){p.setEnabled(false);}};
f.buildUrlBuilderParametersFor=function(o){return g().then(function(u){var U=Object.keys(u).map(function(s){return{label:s,key:"{$user>/"+s+"}",value:u[s]};});var B=o.getBindingContext();var D;if(B){var h=B.getObject();D=Object.keys(h).filter(function(p){return typeof h[p]!=="object";}).map(function(p){return{label:p,key:"{"+p+"}",value:h[p]};});}else{D=[];}return U.concat(D);});};
return f;});
sap.ui.predefine('sap/ui/rta/plugin/iframe/AddIFrameDialogController',["sap/base/Log","sap/ui/core/mvc/Controller","sap/ui/core/library","sap/ui/rta/Utils","sap/ui/fl/util/IFrame","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/rta/plugin/iframe/urlCleaner"],function(L,C,c,U,I,F,a,u){"use strict";var V=c.ValueState;var _=["frameUrl"];var b=["frameWidth","frameHeight"];var d=["asNewSection","frameWidthUnit","frameHeightUnit"];
function i(s){return I.isValidUrl(encodeURI(s));}
return C.extend("sap.ui.rta.plugin.iframe.AddIFrameDialogController",{constructor:function(j,s){this._oJSONModel=j;this._importSettings(s);this._mParameterHashMap=this._buildParameterHashMap(s);},onValidationSuccess:function(e){e.getSource().setValueState(V.None);this._oJSONModel.setProperty("/areAllFieldsValid",this._areAllTextFieldsValid()&&this._areAllValueStateNones());},onValidationError:function(e){e.getSource().setValueState(V.Error);this._oJSONModel.setProperty("/areAllFieldsValid",false);this._setFocusOnInvalidInput();},onSizeUnitChange:function(){var w=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog_WidthUnit").getSelectedKey();var h=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog_HeightUnit").getSelectedKey();var o=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog_PercentText");if(w!=="%"&&h!=="%"){o.addStyleClass("sapUiRtaAddIFrameDialogPercentText-invisible");}else{o.removeStyleClass("sapUiRtaAddIFrameDialogPercentText-invisible");}},onSavePress:function(){var s=this._buildPreviewURL(this._buildReturnedURL());if(i(s)&&this._areAllTextFieldsValid()&&this._areAllValueStateNones()){this._close(this._buildReturnedSettings());}else{this._setFocusOnInvalidInput();}},onShowPreview:function(){var s=this._buildPreviewURL(this._buildReturnedURL());if(!i(s)){return;}var o=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog_PreviewFrame");o.setUrl("");var p=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog_PreviewLinkPanel");var P=p.getDependents()[0];if(s){P.setEnabled(true);}else{p.setExpanded(false);P.setEnabled(false);}try{this._oJSONModel.setProperty("/previewUrl/value",s);o.setUrl(s);}catch(e){L.error("Error previewing the URL: ",e);}},onParameterPress:function(e){var k=e.getSource().getBindingContext().getObject().key;this._oJSONModel.setProperty("/frameUrl/value",this._addURLParameter(k));this.onUrlChange();},onSearch:function(e){var f=new F("label",a.Contains,e.getParameter("query"));var B=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog_ParameterTable").getBinding("items");B.filter([f]);},_buildPreviewURL:function(e){return e.replace(/{(.*?)}/g,function(m){return this._mParameterHashMap[m];}.bind(this));},_addURLParameter:function(p){return this._buildReturnedURL()+p;},_buildReturnedURL:function(){return u(this._oJSONModel.getProperty("/frameUrl/value"));},onUrlChange:function(){var s=this._buildPreviewURL(this._buildReturnedURL());var o=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog_EditUrlTA");if(i(s)){o.setValueState("None");}else{o.setValueState("Error");}},_buildParameterHashMap:function(p){if(p&&p.parameters){return U.buildHashMapFromArray(p.parameters,"key","value");}return{};},onCancelPress:function(){this._close();},_close:function(s){var A=sap.ui.getCore().byId("sapUiRtaAddIFrameDialog");this._mSettings=s;A.close();},getSettings:function(){return this._mSettings;},_areAllValueStateNones:function(){var D=this._oJSONModel.getData();return _.concat(b).every(function(f){return D[f]["valueState"]===V.None;},this);},_areAllTextFieldsValid:function(){var j=this._oJSONModel;return _.reduce(function(A,f){var v="/"+f+"/value";var s;if(j.getProperty(v).trim()===""){s=V.Error;}else{s=V.None;}j.setProperty(v+"State",s);return A&&s===V.None;},true);},_buildReturnedSettings:function(){var s={};var D=this._oJSONModel.getData();_.concat(b,d).forEach(function(f){var v=D[f].value;if(f==="frameUrl"){v=u(v);}s[f]=v;});return s;},_importSettings:function(s){if(s){Object.keys(s).forEach(function(f){if(f==="frameWidth"||f==="frameHeight"){this._importIFrameSize(f,s[f]);}else{this._oJSONModel.setProperty("/"+f+"/value",s[f]);}},this);}},_importIFrameSize:function(f,s){var r=s.split(/(px|rem|%)/);if(r.length>=2){this._oJSONModel.setProperty("/"+f+"/value",parseFloat(r[0]));this._oJSONModel.setProperty("/"+f+"Unit/value",r[1]);}},_setFocusOnInvalidInput:function(){var D=this._oJSONModel.getData();return b.some(function(f){if(D[f]["valueState"]===V.Error){var e=sap.ui.getCore().byId(D[f]["id"]);e.focus();return true;}},this);}});});
sap.ui.predefine('sap/ui/rta/plugin/iframe/urlCleaner',[],function(){"use strict";return function(u){return u.replace(/\t|\r|\n/g,"");};});
sap.ui.predefine('sap/ui/rta/service/Action',["sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/base/util/restricted/_castArray","sap/base/util/restricted/_pick"],function(O,D,_,a){"use strict";return function(r){function i(v,o){return typeof v==='function'?v(o):v;}function g(E){var m=r._oDesignTime.getPlugins().map(function(p){return p.getMenuItems(E);});return Promise.all(m).then(function(M){return M.reduce(function(R,M){return M?R.concat(M):R;},[]).map(function(c){return Object.assign({},c,{enabled:i(c.enabled,E),text:i(c.text,E[0])});});});}function b(c){var C=_(c);var E=C.map(function(s){var o=O.getOverlay(s);if(!o){throw new Error(D.printf('Control with id="{0}" is not under the one of root elements or ignored.',s));}return o;});return g(E).then(function(m){return m.map(function(M){return a(M,['id','icon','rank','group','enabled','text']);});});}function e(c,A){var C=_(c);var E=C.map(function(s){var o=O.getOverlay(s);if(!o){throw new Error(D.printf('Control with id="{0}" is not under the one of root elements or ignored.',s));}return o;});return g(E).then(function(d){var m=d.filter(function(m){return m.id===A;}).pop();if(!m){throw new Error('No action found by specified ID');}else{return m.handler(E,{});}});}return{exports:{get:b,execute:e}};};});
sap.ui.predefine('sap/ui/rta/service/ControllerExtension',["sap/ui/dt/Util","sap/ui/dt/OverlayRegistry","sap/ui/fl/Utils","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/thirdparty/jquery"],function(D,O,F,C,P,q){"use strict";return function(r){function m(p){return new Promise(function(a,b){var u;q.ajax({url:u=sap.ui.require.toUrl(p)+".js",async:true,success:function(d){a(d);},error:function(x,t,e){var E=new Error("resource "+p+" could not be loaded from "+u+". Check for 'file not found' or parse errors. Reason: "+e);E.status=t;E.error=e;E.statusCode=x.status;b(e);},dataType:"text"});});}return{exports:{add:function(c,v){var f=r.getFlexSettings();if(!f.developerMode){throw D.createError("service.ControllerExtension#add","code extensions can only be created in developer mode","sap.ui.rta");}if(!c){throw D.createError("service.ControllerExtension#add","can't create controller extension without codeRef","sap.ui.rta");}if(!c.endsWith(".js")){throw D.createError("service.ControllerExtension#add","codeRef has to end with 'js'");}var V=sap.ui.getCore().byId(v);var a=F.getAppComponentForControl(V);var s=V.getControllerName&&V.getControllerName()||V.getController()&&V.getController().getMetadata().getName();var R=F.getComponentClassName(a);var M=R.replace(/\.Component/g,"").replace(/\./g,"/");M+="/changes/";M+=c.replace(/\.js/g,"");var o={content:{codeRef:c},selector:{controllerName:s},changeType:"codeExt",namespace:f.namespace,developerMode:f.developerMode,scenario:f.scenario,moduleName:M};var p=C.create({changeSpecificData:o,selector:a});P.add({change:p,selector:a});return p.getDefinition();},getTemplate:function(v){var V=O.getOverlay(v);if(!V){throw D.createError("service.ControllerExtension#getTemplate","no overlay found for the given view ID","sap.ui.rta");}var c=V.getDesignTimeMetadata().getControllerExtensionTemplate();return m(c+"-dbg").catch(function(){return m(c);});}}};};});
sap.ui.predefine('sap/ui/rta/service/Outline',["sap/ui/dt/OverlayRegistry","sap/ui/dt/ElementOverlay","sap/ui/dt/AggregationOverlay","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/write/api/ExtensionPointRegistryAPI","sap/base/util/deepEqual","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/util/restricted/_omit","sap/ui/core/mvc/View","sap/base/Log"],function(O,E,A,D,F,a,d,i,m,_,V,L){"use strict";
function g(v,C){var e=a.getExtensionPointInfoByViewId({viewId:v});return _(e,C);}
function c(o){return _(o,["bIsView"]);}
return function(r,p){var o={};o.mExtensionPointMetadata={palette:{icons:{svg:"sap/ui/core/designtime/Icon.icon.svg"}}};o._aConsideredExtensionPoints=[];o._attachNotConsideredExtensionPoints=function(l,n){var v=F.getViewForControl(l.getElement()).getId();var q=g(v,this._aConsideredExtensionPoints);Object.keys(q).forEach(function(s,I){var t=q[s];var u=this._getExtensionPointData(t);u.id=v;n.elements.splice(I,0,u);this._aConsideredExtensionPoints.push(u.name);}.bind(this));};o._getOutline=function(I,l){var R;if(!l&&D.isInteger(I)){l=I;I=undefined;}var n=[];if(!I){n=r._oDesignTime.getRootElements().map(function(s){return O.getOverlay(s);});}else{var P=O.getOverlay(I);if(!P){throw D.createError("services.Outline#get","Cannot find element with id= "+I+". A valid or empty value for the initial element id should be provided.","sap.ui.rta");}n.push(P);}R=n.map(function(q){return this._getChildrenNodes(q,l);},this);this._aConsideredExtensionPoints=[];return R;};o._getExtensionPoints=function(l){var P=l.id;var s=l.technicalName;return a.getExtensionPointInfoByParentId({parentId:P}).filter(function(n){return n.aggregationName===s;});};o._getExtensionPointData=function(l){return{id:l.targetControl.getId(),name:l.name,technicalName:"sap.ui.extensionpoint",type:"extensionPoint",icon:this.mExtensionPointMetadata.palette.icons.svg,extensionPointInfo:{defaultContent:l.defaultContent.map(function(C){return C.getId();})}};};o._enrichExtensionPointData=function(l,n){var I=sap.ui.getCore().getConfiguration().getDesignMode();if(!I){return undefined;}if(l.type==="aggregation"){var q=this._getExtensionPoints(l).sort(function(s,t){return t.index-s.index;});q.forEach(function(s){var t=this._getExtensionPointData(s);l.elements.splice(s.index,0,t);this._aConsideredExtensionPoints.push(t.name);}.bind(this));}else if(l.bIsView){return this._attachNotConsideredExtensionPoints(n,l);}};o._getChildrenNodes=function(l,n,P){var v=D.isInteger(n);if(l.getShouldBeDestroyed()){return{};}var q=this._getNodeProperties(l,P)||{};var C=l.getChildren();var s=(l.getAggregationBindingTemplateOverlays&&l.getAggregationBindingTemplateOverlays())||[];if(s.length>0){var t=[];C=s.reduce(function(u,w){t.push(w.getAggregationName());return w.getChildren().concat(u);},C).filter(function(u){if(u.getAggregationName&&t.indexOf(u.getAggregationName())>-1){return false;}return true;});}if((!v||(v&&n>0))&&C.length>0&&!i(q)){n=v?n-1:n;q.elements=C.map(function(u){return this._getChildrenNodes(u,n,u.getParent());},this).filter(function(u){return!i(u);});this._enrichExtensionPointData(q,l);}return c(q);};function b(l,P,s){var n=l.getParentElementOverlay();return n&&s&&n.getAggregationOverlay(s,"AggregationBindingTemplateOverlays")===P;}function e(P,s){return P.getParent().getAggregationOverlay(s).getChildren().length;}function f(l,n,q){var s={editable:l.getEditable(),bIsView:l.getElement()instanceof V};if(typeof l.isVisible()==="boolean"){s.visible=l.isVisible();}var P=l.getParent()&&l.getParentAggregationOverlay();var t=(P&&P.getAggregationName())||"";var u="";if(b(l,P,t)){var N=e(P,t);u=" ["+N+"]";s.type="aggregationBindingTemplate";s.icon="sap-icon://attachment-text-file";}else{s.type="element";}var v=q.getName(n);if(v&&v.singular){s.name=(v&&v.singular)+u;}return s;}function h(l,P,n){var s=l.getAggregationName();var q={technicalName:l.getAggregationName(),editable:false,type:"aggregation",bIsView:l.getElement()instanceof V};if(P.getAggregation(s)){var t=P.getDesignTimeMetadata().getAggregationDescription(s,n);if(t.singular){q.name=t.singular;}}if(P.getAggregationBindingTemplateOverlays().length){q.icon="sap-icon://card";}return q;}function j(l,n){var q={id:l.getId(),technicalName:l.getMetadata().getName(),editable:false,type:null};var s=k(n);if(s){q.icon=s;}var I=n.getLabel(l);if(I&&I!==q.id){q.instanceName=I;}return q;}function k(l){var n=l.getData();return n.palette&&n.palette.icons&&n.palette.icons.svg||undefined;}o._getNodeProperties=function(l,P){var n=l.getElement();var q=l.getDesignTimeMetadata();var s=j(n,q);if(l instanceof E){return Object.assign(s,f(l,n,q));}return Object.assign(s,h(l,P,n));};o._removeDuplicate=function(R,l){return R.filter(function(u){return!d(l,u,Infinity);});};o._updatesHandler=function(l){var P=l.getParameters();if(this.sStatus==="initial"){this.aUpdates=[];}var R=m({},P);var s=R.id?O.getOverlay(R.id).getElement().getId():undefined;var t=R.targetId?O.getOverlay(R.targetId).getElement().getId():undefined;switch(l.getId()){case"elementOverlayCreated":if(P.elementOverlay.isRoot()){var n=P.elementOverlay.getElement().getId();R.element=o._getOutline(n)[0];R.type="new";break;}return;case"elementOverlayAdded":R.element=o._getOutline(s)[0];R.targetId=t;R.type="new";break;case"elementOverlayMoved":R.element=o._getOutline(s,0)[0];R.targetId=t;R.type="move";break;case"elementOverlayDestroyed":var q=R.elementOverlay.getParentAggregationOverlay();if((q instanceof A&&!q._bIsBeingDestroyed)||R.elementOverlay.isRoot()){R.element={};R.element.id=R.elementOverlay.getElement()?R.elementOverlay.getElement().getId():R.elementOverlay.getAssociation("element");R.type="destroy";break;}return;case"elementOverlayEditableChanged":R.element={id:s,editable:R.editable};R.type="editableChange";break;case"elementPropertyChanged":R.element=o._getOutline(s,0)[0];R.type="elementPropertyChange";break;default:L.error("Event type is not 'expected' by handler");}R=_(R,["elementOverlay","editable","target","id","elementId"]);this.aUpdates=o._removeDuplicate(this.aUpdates,R);this.aUpdates.push(R);if(this.sStatus==="initial"){setTimeout(function(){if(Array.isArray(this.aUpdates)&&this.aUpdates.length>0){this.sStatus="initial";p("update",this.aUpdates);}}.bind(o),200);}this.sStatus="processing";};o.destroy=function(){r._oDesignTime.detachEvent("elementOverlayCreated",this._updatesHandler,this);r._oDesignTime.detachEvent("elementOverlayAdded",this._updatesHandler,this);r._oDesignTime.detachEvent("elementOverlayMoved",this._updatesHandler,this);r._oDesignTime.detachEvent("elementOverlayDestroyed",this._updatesHandler,this);r._oDesignTime.detachEvent("elementPropertyChanged",this._updatesHandler,this);r._oDesignTime.detachEvent("elementOverlayEditableChanged",this._updatesHandler,this);delete this.aUpdates;delete this.sStatus;};o.aUpdates=[];o.sStatus="initial";r._oDesignTime.attachEvent("elementOverlayCreated",o._updatesHandler,o);r._oDesignTime.attachEvent("elementOverlayAdded",o._updatesHandler,o);r._oDesignTime.attachEvent("elementOverlayMoved",o._updatesHandler,o);r._oDesignTime.attachEvent("elementOverlayDestroyed",o._updatesHandler,o);r._oDesignTime.attachEvent("elementPropertyChanged",o._updatesHandler,o);r._oDesignTime.attachEvent("elementOverlayEditableChanged",o._updatesHandler,o);return{events:["update"],exports:{get:o._getOutline.bind(o)},destroy:o.destroy.bind(o)};};});
sap.ui.predefine('sap/ui/rta/service/Property',["sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/util/restricted/_omit"],function(O,D,i,m,_){"use strict";var a="[NOT SERIALIZABLE]";
function b(p,I,P){if(Object(p)!==p){return true;}if(typeof p==="function"){return false;}if(typeof p==="object"){if(Array.isArray(p)){return p.every(b);}else if(p instanceof Map){var M={};p.forEach(function(V,k){M[k]=V;});if(P){P[I]=M;}p=M;}return Object.keys(p).every(function(k){return b(p[k],k,p);});}return false;}
function v(p){return b(p)?p:a;}
return function(){var p={};p._getDesignTimeProperties=function(c){var o=O.getOverlay(c);if(!o){return D.createError("service.Property#get","A valid control id was not passed","sap.ui.rta");}var e=o.getElement();var M=e.getMetadata().getAllProperties();var d=o.getDesignTimeMetadata();var f=m({},d.getData());var g=f.properties||{};var h=f.annotations||{};var l=f.getLabel;return Promise.all([p._getConsolidatedAnnotations(h,e),p._getConsolidatedProperties(g||{},M,e),p._getResolvedFunction(l,e),p._getResolvedLinks(f.links,e)]).then(function(P){return Object.assign({},P[0]&&!i(P[0])&&{annotations:P[0]},P[1]&&{properties:P[1]},P[2]&&{label:v(P[2])},f.name&&{name:d.getName(e)},!i(P[3])&&{links:P[3]});});};p._getConsolidatedProperties=function(d,M,e){var f=Object.keys(M).reduce(function(F,k){F[k]={value:v(e.getProperty(k)),virtual:false,type:M[k].type,name:M[k].name,ignore:false,group:M[k].group,deprecated:M[k].deprecated,defaultValue:M[k].defaultValue,visibility:M[k].visibility};var B=p._getBindingInfo(k,e);Object.assign(F[k],B&&{binding:B});return F;},{});return p._getResolvedFunction(d,e).then(function(c){return Promise.all(Object.keys(c).map(function(k){return p._getResolvedFunction(c[k].ignore,e).then(function(I){if(typeof I!=="boolean"){throw D.createError("services.Property#get","Invalid ignore property value found in designtime for element with id "+e.getId()+" .","sap.ui.rta");}var r={};if(!f[k]){if(c[k].virtual===true){r=p._getEvaluatedVirtualProperty(c,k,e,I);}else{r[k]={value:v(_(c[k],"ignore")),virtual:false,ignore:I};}}else{r[k]={ignore:I};}return r;});}));}).then(function(F){return F.reduce(function(c,o){return m(c,o);},f);});};p._getEvaluatedVirtualProperty=function(d,P,e,I){var E={};E[P]={value:v(d[P].get(e)),virtual:true,type:d[P].type,name:d[P].name,group:d[P].group,ignore:I};var B=p._getBindingInfo(P,e);return p._getResolvedFunction(d[P].possibleValues,e).then(function(c){Object.assign(E[P],B&&{binding:B},c&&{possibleValues:v(c)},typeof d[P].nullable==="boolean"&&{nullable:d[P].nullable});return E;});};p._getConsolidatedAnnotations=function(d,e){return Promise.all(Object.keys(d).map(function(k){return p._getResolvedFunction(d[k].ignore,e).then(function(I){var f={};if(typeof I!=="boolean"&&typeof I!=="undefined"){throw D.createError("services.Property#get","Invalid ignore property value found in designtime for element with id "+e.getId()+" .","sap.ui.rta");}d[k].ignore=I;if(!I){f[k]=Object.assign({},d[k]);return p._getResolvedLinks(f[k].links,e).then(function(l){if(!i(l)){f[k].links=l;}return f;});}});})).then(function(f){return f.reduce(function(c,F){return Object.assign(c,F);},{});});};p._getResolvedLinks=function(l,e){var t=[];var r=Object.assign({},l);Object.keys(r).forEach(function(L){if(Array.isArray(r[L])){r[L].forEach(function(o){t.push(D.wrapIntoPromise(function(){if(typeof o.text==="function"){return o.text(e);}})(o).then(function(s){o.text=v(s||o.text);}));});}});return Promise.all(t).then(function(){return r;});};p._getBindingInfo=function(k,e){var P=e.getBindingInfo(k);if(!P){return;}return m({},P.parts&&{parts:P.parts},P.binding&&{bindingValues:{values:P.binding.getValue()}},P.binding&&P.binding.getOriginalValue&&{bindingValues:{originalValues:P.binding.getOriginalValue()}},P.bindingString&&{bindingString:P.bindingString});};p._getResolvedFunction=function(P,e){return D.wrapIntoPromise(function(){return typeof P==="function"?(P(e)||false):(P||false);})(P,e);};return{exports:{get:p._getDesignTimeProperties.bind(p)}};};});
sap.ui.predefine('sap/ui/rta/service/Receiver',["sap/ui/core/postmessage/Bus","sap/ui/dt/Util","sap/base/util/uid"],function(P,D,u){"use strict";var C='sap.ui.rta.service.receiver';var p;return function(r){var e={};var R=function(E){var d=E.data;var m=d.body;switch(E.eventId){case"getService":var s=m.arguments[0];r.getService(s).then(function(S){var a={};var M=[];Object.keys(S).forEach(function(k){if(typeof S[k]==='function'){if(!/^(at|de)tach/.test(k)){M.push(k);}}else{a[k]=S[k];}});p.publish({target:E.source,origin:E.origin,channelId:C,eventId:"getService",data:{id:d.id,type:"response",body:{methods:M,properties:a,events:r._mServices[s].service.events}}});});break;case'callMethod':r.getService(m.service).then(function(S){S[m.method].apply(null,m.arguments).then(function(v){p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'callMethod',data:{type:'response',status:'success',id:d.id,body:v}});});}).catch(function(v){var o=D.propagateError(v,"service.Receiver",D.printf("Can't execute method {0} of service {1} due unexpected error.",m.method,m.service),"sap.ui.rta");p.publish({target:E.source,origin:E.origin,channelId:C,eventId:"callMethod",data:{type:"response",status:"error",id:d.id,body:o.toString()}});});break;case'subscribe':r.getService(m.service).then(function(S){var h=function(v){p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'event',data:{body:{service:m.service,event:m.event,data:v}}});};var H=u();e[H]=h;S.attachEvent(m.event,h);p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'subscribe',data:{type:'response',status:'success',id:d.id,body:{id:H}}});});break;case'unsubscribe':r.getService(m.service).then(function(S){S.detachEvent(m.event,e[m.id]);delete e[m.id];p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'unsubscribe',data:{type:'response',status:'success',id:d.id}});});break;}};p=P.getInstance();p.publish({channelId:C,eventId:P.event.READY});p.subscribe(C,"getService",R);p.subscribe(C,"callMethod",R);p.subscribe(C,"subscribe",R);p.subscribe(C,"unsubscribe",R);return{destroy:function(){if(p){p.unsubscribe(C,"getService",R);p.unsubscribe(C,"callMethod",R);p.unsubscribe(C,"subscribe",R);p.unsubscribe(C,"unsubscribe",R);}}};};});
sap.ui.predefine('sap/ui/rta/service/Selection',function(){"use strict";return function(r,p){var s=r._oDesignTime.getSelectionManager();function g(e){return e.map(function(E){return E.getElement().getId();});}s.attachEvent("change",function(e){p("change",g(e.getParameter("selection")));});return{events:["change"],exports:{get:function(){return g(s.get());},set:s.set.bind(s),add:s.add.bind(s),remove:s.remove.bind(s),reset:s.reset.bind(s)}};};});
sap.ui.predefine('sap/ui/rta/service/index',function(){"use strict";return Object.freeze({selection:'sap.ui.rta.service.Selection',receiver:'sap.ui.rta.service.Receiver',controllerExtension:'sap.ui.rta.service.ControllerExtension',outline:'sap.ui.rta.service.Outline',action:'sap.ui.rta.service.Action',property:'sap.ui.rta.service.Property'});});
sap.ui.predefine('sap/ui/rta/toolbar/Adaptation',["sap/ui/core/format/DateFormat","sap/ui/core/Fragment","sap/ui/core/library","sap/ui/fl/library","sap/ui/rta/Utils","sap/ui/rta/toolbar/translation/Translation","sap/ui/rta/appVariant/Feature","sap/ui/rta/toolbar/Base","sap/ui/Device"],function(D,F,c,f,U,T,A,B,a){"use strict";var M=c.MessageType;var V=f.Versions;
var b=B.extend("sap.ui.rta.toolbar.Adaptation",{
renderer:"sap.ui.rta.toolbar.AdaptationRenderer",
animation:true,
metadata:{library:"sap.ui.rta",events:{undo:{},redo:{},exit:{},restore:{},transport:{},modeChange:{},activate:{},discardDraft:{},switchVersion:{},onCommandCategorySelection:{}}}
});
b.modes={MOBILE:"sapUiRtaToolbarMobile",TABLET:"sapUiRtaToolbarTablet",DESKTOP:"sapUiRtaToolbarDesktop"};var d="sapUiRtaToolbar";var e="sapUiRtaDraftVersionAccent";var g="sapUiRtaActiveVersionAccent";
b.prototype.init=function(){a.media.attachHandler(this._onSizeChanged,this,d);this._pFragmentLoaded=B.prototype.init.apply(this,arguments);};
b.prototype.onBeforeRendering=function(){if(!a.media.hasRangeSet(d)){a.media.initRangeSet(d,[900,1200],"px",[b.modes.MOBILE,b.modes.TABLET,b.modes.DESKTOP]);}this._onSizeChanged(a.media.getCurrentRange(d));B.prototype.onBeforeRendering.apply(this,arguments);};
b.prototype.onFragmentLoaded=function(){return this._pFragmentLoaded;};
b.prototype.exit=function(){a.media.detachHandler(this._onSizeChanged,this,d);B.prototype.exit.apply(this,arguments);};
function s(l,I,t,m){var n=this.getControl(l);var p=t?this.getTextResources().getText(t):"";var q=m?this.getTextResources().getText(m):"";n.setText(p||"");n.setTooltip(q||"");n.setIcon(I||"");}
b.prototype.formatDiscardDraftVisible=function(n,v){return n===sap.ui.fl.Versions.Draft&&v;};
b.prototype.formatVersionButtonText=function(v,n){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var l="";var m="Active";v=v||[];if(n===undefined||n===V.Original){l=t.getText("TIT_ORIGINAL_APP");m="inactive";if(v.length===0||(v.length===1&&v[0].type==="draft")){m="active";}}else{var p=v.find(function(q){return q.version===n;});if(p){m=p.type;if(n===V.Draft){l=t.getText("TIT_DRAFT");}else{l=p.title||t.getText("TIT_VERSION_1");}}}this.setVersionButtonAccentColor(m);return l;};
b.prototype.formatVersionTableVisibility=function(n){return n>0;};
b.prototype.formatVersionTitle=function(t,l){var m=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");if(l==="draft"){return m.getText("TIT_DRAFT");}return t||m.getText("TIT_VERSION_1");};
b.prototype.formatVersionTimeStamp=function(t){if(!t){return"";}return D.getInstance({format:"yMMMdjm"}).format(new Date(t));};
b.prototype.formatHighlight=function(t){switch(t){case"draft":return M.Warning;case"active":return M.Success;default:return M.None;}};
b.prototype.formatHighlightText=function(t){var l=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");switch(t){case"draft":return l.getText("TIT_DRAFT");case"active":return l.getText("LBL_ACTIVE");default:return l.getText("LBL_INACTIVE");}};
function h(v){return v.some(function(l){return l.type==="active";});}
b.prototype.formatOriginalAppHighlight=function(v){return h(v)?M.None:M.Success;};
b.prototype.formatOriginalAppHighlightText=function(v){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");return h(v)?t.getText("LBL_INACTIVE"):t.getText("LBL_ACTIVE");};
b.prototype.versionSelected=function(E){var v=E.getSource().getBindingContext("versions");var n=V.Original;if(v){n=v.getProperty("version");}this.fireEvent("switchVersion",{version:n});};
b.prototype.showVersionHistory=function(E){var v=E.getSource();if(!this.oVersionDialogPromise){this.oVersionDialogPromise=F.load({name:"sap.ui.rta.toolbar.VersionHistory",id:this.getId()+"_versionHistoryDialog",controller:{formatVersionTitle:this.formatVersionTitle.bind(this),formatVersionTimeStamp:this.formatVersionTimeStamp.bind(this),formatVersionTableVisibility:this.formatVersionTableVisibility.bind(this),formatHighlight:this.formatHighlight.bind(this),formatHighlightText:this.formatHighlightText.bind(this),formatOriginalAppHighlight:this.formatOriginalAppHighlight.bind(this),formatOriginalAppHighlightText:this.formatOriginalAppHighlightText.bind(this),versionSelected:this.versionSelected.bind(this)}}).then(function(l){v.addDependent(l);return l;});}return this.oVersionDialogPromise.then(function(l){if(!l.isOpen()){l.openBy(v);}else{l.close();}});};
b.prototype.showTranslationPopover=function(E){var t=this.addExtension("translation",T);return t.showTranslationPopover(E,this);};
b.prototype.showRestore=function(v){return!v;};
b.prototype._showButtonIcon=function(l,I,t){s.call(this,l,I,"",t);};
b.prototype._showButtonText=function(l,t){s.call(this,l,"",t,"");};
b.prototype._switchToIcons=function(){var I=this.getControl("iconBox");var l=this.getControl("iconSpacer");I.setVisible(false);l.setVisible(false);this._showButtonIcon("adaptationSwitcherButton","sap-icon://wrench","BTN_ADAPTATION");this._showButtonIcon("navigationSwitcherButton","sap-icon://explorer","BTN_NAVIGATION");this._showButtonIcon("visualizationSwitcherButton","sap-icon://show","BTN_VISUALIZATION");this._showButtonIcon("exit","sap-icon://decline","BTN_EXIT");};
b.prototype._switchToTexts=function(){var I=this.getControl("iconBox");var l=this.getControl("iconSpacer");I.setVisible(true);l.setVisible(true);this._showButtonText("adaptationSwitcherButton","BTN_ADAPTATION");this._showButtonText("navigationSwitcherButton","BTN_NAVIGATION");this._showButtonText("visualizationSwitcherButton","BTN_VISUALIZATION");this._showButtonText("exit","BTN_EXIT");};
b.prototype._onSizeChanged=function(p){if(!p){return Promise.resolve();}return this.onFragmentLoaded().then(function(){var m=p.name;this.sMode=m;switch(m){case b.modes.MOBILE:this._switchToIcons();break;case b.modes.TABLET:case b.modes.DESKTOP:this._switchToTexts();break;default:}}.bind(this));};
b.prototype.buildControls=function(){return F.load({name:"sap.ui.rta.toolbar.Adaptation",id:this.getId()+"_fragment",controller:{activate:this._openVersionTitleDialog.bind(this),discardDraft:this.eventHandler.bind(this,"DiscardDraft"),formatDiscardDraftVisible:this.formatDiscardDraftVisible.bind(this),modeChange:this.eventHandler.bind(this,"ModeChange"),showTranslationPopover:this.showTranslationPopover.bind(this),undo:this.eventHandler.bind(this,"Undo"),redo:this.eventHandler.bind(this,"Redo"),onCommandCategorySelection:this.eventHandler.bind(this,"OnCommandCategorySelection"),manageApps:j.bind(this),appVariantOverview:i.bind(this),saveAs:o.bind(this),restore:this.eventHandler.bind(this,"Restore"),publish:this.eventHandler.bind(this,"Transport"),exit:this.eventHandler.bind(this,"Exit"),formatVersionButtonText:this.formatVersionButtonText.bind(this),showVersionHistory:this.showVersionHistory.bind(this),showRestore:this.showRestore.bind(this)}});};
function o(){A.onSaveAs(true,true,this.getRtaInformation().flexSettings.layer,null);}
function i(E){var I=E.getParameter("item");var t=I.getId().endsWith("keyUser");return A.onGetOverview(t,this.getRtaInformation().flexSettings.layer);}
function j(){A.onGetOverview(true,this.getRtaInformation().flexSettings.layer);}
function r(){this.getControl("versionTitleInput").setValue("");this.getControl("confirmVersionTitleButton").setEnabled(false);return Promise.resolve(this._oDialog);}
function k(){return F.load({name:"sap.ui.rta.toolbar.VersionTitleDialog",id:this.getId()+"_fragment",controller:{onConfirmVersioningDialog:function(){var v=this.getControl("versionTitleInput").getValue();this.fireEvent("activate",{versionTitle:v});this._oDialog.close();}.bind(this),onCancelVersioningDialog:function(){this._oDialog.close();}.bind(this),onVersionTitleLiveChange:function(E){var v=E.getParameter("value");this.getControl("confirmVersionTitleButton").setEnabled(!!v);}.bind(this)}}).then(function(l){this._oDialog=l;l.addStyleClass(U.getRtaStyleClassName());this.addDependent(this._oDialog);}.bind(this));}
b.prototype.getControl=function(n){return sap.ui.getCore().byId(this.getId()+"_fragment--sapUiRta_"+n);};
b.prototype._openVersionTitleDialog=function(n){var l;if(this._oDialog){l=r.call(this);}else{l=k.call(this);}return l.then(function(){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var m=t.getText("TIT_VERSION_TITLE_DIALOG");if(n!==V.Draft){m=t.getText("TIT_REACTIVATE_VERSION_TITLE_DIALOG");}this._oDialog.setTitle(m);return this._oDialog.open();}.bind(this));};
b.prototype.setVersionButtonAccentColor=function(t){var v=this.getControl("versionButton");switch(t){case"draft":v.addStyleClass(e);v.removeStyleClass(g);break;case"active":v.addStyleClass(g);v.removeStyleClass(e);break;default:v.removeStyleClass(g);v.removeStyleClass(e);}};
return b;});
sap.ui.predefine('sap/ui/rta/toolbar/AdaptationRenderer',["sap/ui/rta/toolbar/BaseRenderer"],function(B){"use strict";
var A=B.extend("sap.ui.rta.toolbar.AdaptationRenderer");
A.render=function(r,c){r.addClass("sapUiRtaToolbarAdaptation");B.render(r,c);};
return A;});
sap.ui.predefine('sap/ui/rta/toolbar/Base',["sap/m/HBox","sap/ui/dt/util/ZIndexManager","sap/ui/model/resource/ResourceModel","sap/ui/rta/util/Animation"],function(H,Z,R,A){"use strict";
var B=H.extend("sap.ui.rta.toolbar.Base",{
metadata:{library:"sap.ui.rta",properties:{color:{type:"string",defaultValue:"default"},zIndex:{type:"int"},rtaInformation:{type:"object",defaultValue:{flexSettings:{}}},textResources:"object"}},
constructor:function(){H.apply(this,arguments);this._oExtensions={};this.setAlignItems("Center");this.setVisible(false);this.placeToContainer();},
type:null,
animation:false
});
B.prototype.init=function(){this._oResourceModel=new R({bundle:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta")});H.prototype.init.apply(this,arguments);this.setModel(this._oResourceModel,"i18n");return this.buildContent();};
B.prototype.exit=function(){Object.values(this._oExtensions).forEach(function(e){e.destroy();});this._oExtensions={};H.prototype.exit.apply(this,arguments);};
B.prototype.addExtension=function(n,E){if(!Object.keys(this._oExtensions).includes(n)){this._oExtensions[n]=new E({context:this});}return this._oExtensions[n];};
B.prototype.getExtension=function(n){return this._oExtensions[n];};
B.prototype.setTextResources=function(t){this.setProperty("textResources",t);this._oResourceModel=new R({bundle:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta")});};
B.prototype.onFragmentLoaded=function(){return Promise.resolve();};
B.prototype.eventHandler=function(e,E){this["fire"+e](E.getParameters());};
B.prototype.buildControls=function(){return Promise.resolve([]);};
B.prototype.placeToContainer=function(){this.placeAt(sap.ui.getCore().getStaticAreaRef());};
B.prototype.buildContent=function(){return this.buildControls().then(function(c){c.forEach(this.addItem,this);}.bind(this));};
B.prototype.show=function(){return new Promise(function(r){var d={onAfterRendering:function(){this.removeEventDelegate(d);r();}};this.addEventDelegate(d,this);this.bringToFront();this.setVisible(true);}.bind(this)).then(function(){return this.animation?A.waitTransition(this.$(),this.addStyleClass.bind(this,"is_visible")):Promise.resolve();}.bind(this)).then(function(){this.focus();}.bind(this));};
B.prototype.hide=function(s){var p=Promise.resolve();if(this.animation){if(s){this.removeStyleClass("is_visible");}else{p=A.waitTransition(this.$(),this.removeStyleClass.bind(this,"is_visible"));}}return p.then(function(){this.setVisible(false);}.bind(this));};
B.prototype.getControl=function(n){return sap.ui.getCore().byId("sapUiRta_"+n);};
B.prototype.bringToFront=function(){this.setZIndex(Z.getNextZIndex());};
return B;});
sap.ui.predefine('sap/ui/rta/toolbar/BaseRenderer',["sap/ui/core/Renderer","sap/m/HBoxRenderer"],function(R,H){"use strict";var B=R.extend.call(H,"sap.ui.rta.toolbar.BaseRenderer");
B.render=function(r,c){r.addClass("sapUiRtaToolbar");r.addClass("color_"+c.getColor());c.type&&r.addClass("type_"+c.type);var z=c.getZIndex();z&&r.addStyle("z-index",z);H.render(r,c);};
return B;});
sap.ui.predefine('sap/ui/rta/toolbar/Fiori',["sap/m/Image","./Adaptation","../Utils","sap/base/Log"],function(I,A,U,L){"use strict";var F="sapUiRtaFioriHeaderInvisible";
var a=A.extend("sap.ui.rta.toolbar.Fiori",{
metadata:{library:"sap.ui.rta"},
renderer:"sap.ui.rta.toolbar.AdaptationRenderer",
type:"fiori"
});
a.prototype.init=function(){this._oRenderer=U.getFiori2Renderer();this._oFioriHeader=this._oRenderer.getRootControl().getOUnifiedShell().getHeader();A.prototype.init.apply(this,arguments);};
a.prototype.show=function(){this._oFioriHeader.addStyleClass(F);return A.prototype.show.apply(this,arguments);};
a.prototype.buildControls=function(){return A.prototype.buildControls.apply(this,arguments).then(function(c){var l=this._oFioriHeader.getLogo();if(this._oFioriHeader.getShowLogo()&&l){var $=this._oFioriHeader.$().find("#shell-header-icon");var w;var h;if($.length){w=$.width();h=$.height();this._checkLogoSize($,w,h);}this.getControl("iconSpacer").setWidth("10%");this.getControl("iconBox").addItem(new I(this.getId()+"_fragment--sapUiRta_icon",{src:l,width:w?w+"px":w,height:h?h+"px":h}));}return c;}.bind(this));};
a.prototype.hide=function(){return A.prototype.hide.apply(this,arguments).then(function(){this._oFioriHeader.removeStyleClass(F);}.bind(this));};
a.prototype._checkLogoSize=function($,w,h){var n=$.get(0).naturalWidth;var N=$.get(0).naturalHeight;if(w!==n||h!==N){L.error(["sap.ui.rta: please check Fiori Launchpad logo, expected size is",w+"x"+h+",","but actual is "+n+"x"+N].join(" "));}};
a.prototype.destroy=function(){this._oFioriHeader.removeStyleClass(F);delete this._oRenderer;delete this._oFioriHeader;A.prototype.destroy.apply(this,arguments);};
return a;});
sap.ui.predefine('sap/ui/rta/toolbar/FioriLike',["./Adaptation"],function(A){"use strict";
var F=A.extend("sap.ui.rta.toolbar.FioriLike",{
metadata:{library:"sap.ui.rta"},
renderer:"sap.ui.rta.toolbar.AdaptationRenderer",
type:"fiori"
});
return F;});
sap.ui.predefine('sap/ui/rta/toolbar/OverflowToolbarButton',["sap/m/OverflowToolbarButton","sap/m/ButtonRenderer","sap/m/Button"],function(S,B,a){"use strict";
var O=S.extend("sap.ui.rta.toolbar.OverflowToolbarButton",{
metadata:{library:"sap.ui.rta",interfaces:["sap.m.IOverflowToolbarContent"],properties:{visibleIcon:{type:"string",defaultValue:""}}},
renderer:B
});
O.prototype._onBeforeEnterOverflow=function(){S.prototype._onBeforeEnterOverflow.apply(this,arguments);this.setVisibleIcon(this.getIcon());this.setIcon("");};
O.prototype._onAfterExitOverflow=function(){S.prototype._onAfterExitOverflow.apply(this,arguments);this.setIcon(this.getVisibleIcon());};
O.prototype._getText=function(){if((this.getIcon()===""&&this.getVisibleIcon()==="")||this._bInOverflow){return a.prototype._getText.call(this);}return"";};
O.prototype.getOverflowToolbarConfig=function(){return{canOverflow:true,onBeforeEnterOverflow:this._onBeforeEnterOverflow.bind(this),onAfterExitOverflow:this._onAfterExitOverflow.bind(this)};};
return O;},false);
sap.ui.predefine('sap/ui/rta/toolbar/Personalization',["./Base","sap/m/Button"],function(B,a){"use strict";
var P=B.extend("sap.ui.rta.toolbar.Personalization",{
renderer:"sap.ui.rta.toolbar.BaseRenderer",
type:"personalization",
metadata:{library:"sap.ui.rta",events:{exit:{},restore:{}}},
constructor:function(){B.apply(this,arguments);this.setJustifyContent("End");}
});
P.prototype.buildContent=function(){[new a("sapUiRta_restore",{type:"Transparent",text:"{i18n>BTN_RESTORE}",visible:true,press:this.eventHandler.bind(this,"Restore")}).data("name","restore"),new a("sapUiRta_exit",{type:"Emphasized",text:"{i18n>BTN_DONE}",press:this.eventHandler.bind(this,"Exit")}).data("name","exit")].forEach(function(c){this.addItem(c);}.bind(this));return Promise.resolve();};
return P;});
sap.ui.predefine('sap/ui/rta/toolbar/Standalone',["./Adaptation"],function(A){"use strict";
var S=A.extend("sap.ui.rta.toolbar.Standalone",{
metadata:{library:"sap.ui.rta"},
renderer:"sap.ui.rta.toolbar.AdaptationRenderer",
type:"standalone"
});
return S;});
sap.ui.predefine('sap/ui/rta/toolbar/translation/Translation',["sap/ui/base/ManagedObject","sap/ui/core/Fragment","sap/ui/rta/Utils","sap/ui/model/json/JSONModel"],function(M,F,U,J){"use strict";var d;var p;
function r(){this._oTranslationModel.setProperty("/sourceLanguage","");this._oTranslationModel.setProperty("/downloadChangedTexts",false);return Promise.resolve(d);}
function c(){return F.load({name:"sap.ui.rta.toolbar.translation.DownloadTranslationDialog",id:this.getContext().getId()+"_download_translation_fragment",controller:{onDownloadFile:function(){d.close();},onCancelDownloadDialog:function(){d.close();}}}).then(function(t){d=t;d.setModel(this._oTranslationModel,"translation");d.addStyleClass(U.getRtaStyleClassName());this.getContext().addDependent(d);}.bind(this));}
var T=M.extend("sap.ui.rta.toolbar.translation.Translation",{
metadata:{properties:{context:{type:"sap.ui.rta.toolbar.Base"}}},
constructor:function(){M.prototype.constructor.apply(this,arguments);this._oTranslationModel=new J({sourceLanguage:"",downloadChangedTexts:false});}
});
T.prototype.exit=function(){if(this._oDialogPromise){this._oDialogPromise.then(d.destroy.bind(d));}if(this._oPopoverPromise){this._oPopoverPromise.then(p.destroy.bind(p));}};
T.prototype.showTranslationPopover=function(e){var t=e.getSource();if(!this._oPopoverPromise){this._oPopoverPromise=F.load({name:"sap.ui.rta.toolbar.translation.TranslationPopover",id:this.getContext().getId()+"_translationPopoverDialog",controller:{openDownloadTranslationDialog:this.openDownloadTranslationDialog.bind(this)}}).then(function(o){p=o;t.addDependent(o);return o;});}return this._oPopoverPromise.then(function(o){if(!o.isOpen()){o.openBy(t);}else{o.close();}});};
T.prototype.openDownloadTranslationDialog=function(){if(d){this._oDialogPromise=r.call(this);}else{this._oDialogPromise=c.call(this);}return this._oDialogPromise.then(function(){this.getContext().addDependent(d);return d.open();}.bind(this));};
return T;});
sap.ui.predefine('sap/ui/rta/util/Animation',["sap/ui/thirdparty/jquery"],function(q){"use strict";var m={};
m.waitTransition=function($,c){if(!($ instanceof q)){throw new Error('$element should be wrapped into jQuery object');}if(typeof c!=="function"){throw new Error('fnCallback should be a function');}return new Promise(function(r){$.one('transitionend',r);var t;var a=function(T){if(!t){t=T;}if(T!==t){c();}else{window.requestAnimationFrame(a);}};window.requestAnimationFrame(a);});};
return m;},true);
sap.ui.predefine('sap/ui/rta/util/BindingsExtractor',["sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/base/util/isPlainObject"],function(E,O,a){"use strict";var B={};
B.collectBindingPaths=function(e,m,r){var d={bindingPaths:[],bindingContextPaths:[]};var A=e.sParentAggregationName;var p=e.getParent();var h=B.getBindings(e,m,undefined,undefined,r);if(p){var D=p.getMetadata().getAggregation();if(D){var P=E.getAggregation(p,A).indexOf(e);var s=D.name;var o=p.getBindingInfo(s);var t=o&&o.template;if(t){var T=t.getMetadata().getAggregation();if(T){var j=T.name;var k=E.getAggregation(t,j)[P];h=h.concat(B.getBindings(k,null,true,undefined,r));}}}}for(var i=0,l=h.length;i<l;i++){if(h[i].getPath){var n=h[i].getPath();if(n&&d.bindingPaths.indexOf(n)===-1){d.bindingPaths.push(n);}}if(h[i].getContext&&h[i].getContext()&&h[i].getContext().getPath){var q=h[i].getContext().getPath();if(q&&d.bindingContextPaths.indexOf(q)===-1){d.bindingContextPaths.push(q);}}if(a(h[i])){var C=h[i].parts[0]&&h[i].parts[0].path;if(C&&d.bindingPaths.indexOf(C)===-1){d.bindingPaths.push(C);}}}return d;};
function b(e,r){if(r&&e!==r){var o=O.getOverlay(e);var R=o&&(o.getRelevantContainer()||o.getElement());return R?R.getId()===r.getId():true;}return true;}
B.getBindings=function(e,p,t,A,r){var d=[];if(b(e,r)){d=(t?c(e):B.getBindingsFromProperties(e,p));}var h=A?[A]:Object.keys(e.getMetadata().getAllAggregations());h.forEach(function(s){d=d.concat(g(e,p,t,s,r));});return d;};
function g(e,p,t,A,r){var d=[];var T;var h;var o=e.getBindingInfo(A);if(t!==false){T=o&&o.template;h=!!t;}var i=T?[T]:E.getAggregation(e,A);i.forEach(function(C){if(C.getMetadata){if(b(e,r)){d=d.concat(T||h?c(C,r):B.getBindingsFromProperties(C,p));}d=d.concat(B.getBindings(C,p,false,undefined,r));}});return d;}
B.flattenBindings=function(o,p){var d=[];var m=o.getMetadata().getName();if(m==="sap.ui.model.CompositeBinding"){o.getBindings().forEach(function(o){d=d.concat(B.flattenBindings(o,p));});}else if((m==="sap.ui.model.odata.ODataPropertyBinding"||m==="sap.ui.model.odata.v2.ODataPropertyBinding"||m==="sap.ui.model.odata.v4.ODataPropertyBinding"||m==="sap.ui.model.json.JSONPropertyBinding"||m==="sap.ui.model.json.XMLPropertyBinding"||m==="sap.ui.model.resource.ResourcePropertyBinding")&&o.getModel()===p&&o.isRelative()&&typeof o.getPath==="function"&&o.getPath()){d.push(o);}return d;};
function f(m){var d=[];var p=m.parts;p.forEach(function(P){d.push({parts:[P]});});return d;}
B.getBindingsFromProperties=function(e,p){var P=Object.keys(e.getMetadata().getAllProperties());return P.filter(e.getBinding.bind(e)).reduce(function(d,s){return d.concat(B.flattenBindings(e.getBinding(s),p));},[]);};
function c(e){var p=Object.keys(e.getMetadata().getAllProperties());return p.filter(function(P){return P in e.mBindingInfos;}).reduce(function(d,P){return d.concat(f(e.mBindingInfos[P]));},[]);}
B.getBindingContextPath=function(e){if(e.getBindingContext()&&e.getBindingContext().getPath){return e.getBindingContext().getPath();}return undefined;};
return B;},true);
sap.ui.predefine('sap/ui/rta/util/PluginManager',["sap/base/util/isEmptyObject","sap/base/util/values","sap/ui/base/ManagedObject","sap/ui/dt/plugin/ContextMenu","sap/ui/dt/plugin/TabHandling","sap/ui/dt/plugin/ToolHooks","sap/ui/fl/Layer","sap/ui/fl/registry/Settings","sap/ui/rta/command/CommandFactory","sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/rta/plugin/additionalElements/AddElementsDialog","sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer","sap/ui/rta/plugin/iframe/AddIFrame","sap/ui/rta/plugin/Combine","sap/ui/rta/plugin/CompVariant","sap/ui/rta/plugin/ControlVariant","sap/ui/rta/plugin/CreateContainer","sap/ui/rta/plugin/CutPaste","sap/ui/rta/plugin/DragDrop","sap/ui/rta/plugin/Remove","sap/ui/rta/plugin/Rename","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/Selection","sap/ui/rta/plugin/Settings","sap/ui/rta/plugin/Split","sap/ui/rta/plugin/Stretch","sap/ui/rta/plugin/LocalReset"],function(i,v,M,C,T,a,L,S,b,A,c,d,e,f,g,h,j,k,R,l,m,n,o,p,q,r,s){"use strict";
var P=M.extend("sap.ui.rta.util.PluginManager",{metadata:{properties:{plugins:{type:"any",defaultValue:{}}}}});
P.prototype.init=function(){this.iEditableOverlaysCount=0;};
P.prototype.getEditableOverlaysCount=function(){return this.iEditableOverlaysCount;};
P.prototype.getDefaultPlugins=function(F){if(!this._mDefaultPlugins){this._oCommandFactory=new b({flexSettings:F});this._mDefaultPlugins={};this._mDefaultPlugins["selection"]=new o({commandFactory:this._oCommandFactory,multiSelectionRequiredPlugins:[f.getMetadata().getName(),l.getMetadata().getName()],elementEditableChange:this.onElementEditableChange.bind(this)});this._oRTAElementMover=new n({commandFactory:this._oCommandFactory});this._mDefaultPlugins["dragDrop"]=new R({elementMover:this._oRTAElementMover,commandFactory:this._oCommandFactory,dragStarted:this.handleStopCutPaste.bind(this)});this._mDefaultPlugins["rename"]=new m({commandFactory:this._oCommandFactory,editable:this.handleStopCutPaste.bind(this)});this._mDefaultPlugins["additionalElements"]=new A({commandFactory:this._oCommandFactory});this._mDefaultPlugins["createContainer"]=new j({commandFactory:this._oCommandFactory});this._mDefaultPlugins["remove"]=new l({commandFactory:this._oCommandFactory});this._mDefaultPlugins["cutPaste"]=new k({elementMover:this._oRTAElementMover,commandFactory:this._oCommandFactory});this._mDefaultPlugins["settings"]=new p({commandFactory:this._oCommandFactory});this._mDefaultPlugins["combine"]=new f({commandFactory:this._oCommandFactory});this._mDefaultPlugins["split"]=new q({commandFactory:this._oCommandFactory});this._mDefaultPlugins["contextMenu"]=new C();this._mDefaultPlugins["tabHandling"]=new T();this._mDefaultPlugins["stretch"]=new r();var t=S.getInstanceOrUndef();if(t&&t.isVariantAdaptationEnabled()){this._mDefaultPlugins["compVariant"]=new g({commandFactory:this._oCommandFactory});}this._mDefaultPlugins["controlVariant"]=new h({commandFactory:this._oCommandFactory});this._mDefaultPlugins["addIFrame"]=new e({commandFactory:this._oCommandFactory});this._mDefaultPlugins["toolHooks"]=new a();if(F.layer===L.CUSTOMER&&t&&!t.isVersioningEnabled(F.layer)){this._mDefaultPlugins["localReset"]=new s({commandFactory:this._oCommandFactory});}}return Object.assign({},this._mDefaultPlugins);};
P.prototype.preparePlugins=function(F,H,t){if(i(this.getPlugins())){this.setPlugins(this.getDefaultPlugins(F));}else{this._destroyDefaultPlugins(this.getPlugins());}Object.keys(this.getPlugins()).forEach(function(u){if(this.getPlugin(u).attachElementModified){this.getPlugin(u).attachElementModified(H);}}.bind(this));this.provideCommandStack("settings",t);};
P.prototype.getPluginList=function(){return v(this.getPlugins());};
P.prototype.getPlugin=function(t){return this.getPlugins()[t];};
P.prototype.provideCommandStack=function(t,u){if(this.getPlugin(t)){this.getPlugin(t).setCommandStack(u);}};
P.prototype.onElementEditableChange=function(E){var t=E.getParameter("editable");if(t){this.iEditableOverlaysCount+=1;}else{this.iEditableOverlaysCount-=1;}};
P.prototype.handleStopCutPaste=function(){var t=this.getPlugin("cutPaste");if(t){t.stopCutAndPaste();}};
P.prototype._destroyDefaultPlugins=function(t){for(var D in this._mDefaultPlugins){var u=this._mDefaultPlugins[D];if(u&&!u.bIsDestroyed){if(!t||t[D]!==u){u.destroy();}}}};
return P;});
sap.ui.predefine('sap/ui/rta/util/PopupManager',["sap/ui/base/ManagedObject","sap/m/InstanceManager","sap/ui/dt/Overlay","sap/ui/fl/Utils","sap/ui/core/Component","sap/ui/core/ComponentContainer","sap/ui/core/Element","sap/ui/dt/util/ZIndexManager","sap/m/Dialog","sap/m/Popover","sap/base/util/restricted/_curry"],function(M,I,O,f,C,a,E,Z,D,P,_){"use strict";var F={add:"_activateFocusHandle",remove:"_deactivateFocusHandle"};
var b=M.extend("sap.ui.rta.util.PopupManager",{metadata:{properties:{rta:"any"},associations:{autoCloseAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"autoCloseArea"}},events:{open:{parameters:{oControl:{type:"sap.ui.core.Control"}}},close:{parameters:{oControl:{type:"sap.ui.core.Control"}}}},library:"sap.ui.rta"}});
b.prototype.init=function(){this._oModalState=new Map();this._aPopupFilters=[this._isSupportedPopup.bind(this),this._isPopupAdaptable.bind(this)];this._aPopupFilters.forEach(function(d){Z.addPopupFilter(d);});};
b.prototype._overrideInstanceFunctions=function(){this._applyPopupAttributes({method:this._createPopupOverlays,setModal:true,bringToTop:true});this._overrideAddPopupInstance();this._overrideRemovePopupInstance();};
b.prototype.getCategorizedOpenPopups=function(){var o;var d;o=I.getOpenDialogs();var e=this._getValidatedPopups(o);d=I.getOpenPopovers();var g=this._getValidatedPopups(d);var h={aDialogs:e.relevant,aPopovers:g.relevant,aAllSupportedPopups:e.allSupported.concat(g.allSupported)};return h;};
b.prototype._getValidatedPopups=function(o){var A=[];o=o.filter(function(p){if(this._isPopupAdaptable(p)){A.push(p);return true;}else if(p instanceof D){A.push(p);}}.bind(this));return{relevant:o,allSupported:A};};
b.prototype._isComponentInsidePopup=function(p){return Array.isArray(p.getContent())?p.getContent().some(function(o){if(o instanceof a){return this.oRtaRootAppComponent===this._getAppComponentForControl(C.get(o.getComponent()));}}.bind(this)):false;};
b.prototype._isSupportedPopup=function(p){return(p instanceof D||p instanceof P);};
b.prototype.setRta=function(r){if(r&&r._oDesignTime){this.setProperty("rta",r);var R=r.getRootControlInstance();this.oRtaRootAppComponent=this._getAppComponentForControl(R);var m=this._onModeChange.bind(this);r.attachModeChanged(m);this._overrideInstanceFunctions();}};
b.prototype._onModeChange=function(e){var n=e.getParameters().mode;var A=function(m,p){if(m==='navigation'){p.oPopup[this._getFocusEventName("add")]();}else{p.oPopup[this._getFocusEventName("remove")]();if(this.getRta().getShowToolbars()){this.getRta().getToolbar().bringToFront();}}};n==='navigation'?this._applyPatchesToOpenPopups(_(A)(n)):this._removePatchesToOpenPopups(_(A)(n));};
b.prototype._applyPatchesToOpenPopups=function(e){this._applyPopupAttributes({method:e,focus:true,setModal:false});};
b.prototype._removePatchesToOpenPopups=function(e){this._applyPopupAttributes({method:e,setModal:true});};
b.prototype._getFocusEventName=function(o){return F[o];};
b.prototype._overrideAddPopupInstance=function(){this._fnOriginalAddDialogInstance=I.addDialogInstance;I.addDialogInstance=this._overrideAddFunctions(this._fnOriginalAddDialogInstance);this._fnOriginalAddPopoverInstance=I.addPopoverInstance;I.addPopoverInstance=this._overrideAddFunctions(this._fnOriginalAddPopoverInstance);};
b.prototype._overrideAddFunctions=function(o){return function(p){var v=o.apply(I,arguments);if(this._isSupportedPopup(p)){if(this._isPopupAdaptable(p)&&this.getRta()._oDesignTime){p.attachEventOnce("afterOpen",this._createPopupOverlays,this);p.attachEventOnce("afterOpen",this.fireOpen,this);this._setModal(true,p);}else if(!(p instanceof P)){this._setModal(true,p);}}return v;}.bind(this);};
b.prototype._setModal=function(s,p){var o=this._oModalState.get(p.oPopup);if(typeof o!=="boolean"&&s&&this.getRta().getMode()==='adaptation'){this._oModalState.set(p.oPopup,p.oPopup.getModal());p.oPopup.setModal(true);}else if(typeof o==="boolean"&&s===false){p.oPopup.setModal(o);this._oModalState.delete(p.oPopup);}};
b.prototype._applyPopupAttributes=function(p){var r=this.getCategorizedOpenPopups();["aDialogs","aPopovers"].forEach(function(k){if(r[k].length>0){if(p.focus){if(r[k][0].oPopup.oContent){r[k][0].oPopup.oContent.focus();}}r[k].forEach(function(o){p.method.call(this,o);}.bind(this));}}.bind(this));r.aAllSupportedPopups.forEach(this._setModal.bind(this,p.setModal));};
b.prototype._applyPopupPatch=function(p){var o=O.getOverlayContainer();var d=p.oPopup;var A=[d.oContent.getDomRef(),o.get(0)].concat(this.getAutoCloseAreas());if(this.getRta().getShowToolbars()){var r=this.getRta().getToolbar();var v=!!r.getVisible();if(!v){this.getRta().attachEventOnce("start",function(){A.push(r.getDomRef());});}else{A.push(r.getDomRef());}}d.setExtraContent(A);if(!this.fnOriginalPopupOnAfterRendering){this.fnOriginalPopupOnAfterRendering=d.onAfterRendering;}d.onAfterRendering=function(){var e=this.fnOriginalPopupOnAfterRendering.apply(d,arguments);d[this._getFocusEventName("remove")]();return e;}.bind(this);if(this.getRta().getMode()==='adaptation'){d[this._getFocusEventName("remove")]();}};
b.prototype._overrideRemovePopupInstance=function(){this._fnOriginalRemoveDialogInstance=I.removeDialogInstance;I.removeDialogInstance=this._overrideRemoveFunctions(this._fnOriginalRemoveDialogInstance);this._fnOriginalRemovePopoverInstance=I.removePopoverInstance;I.removePopoverInstance=this._overrideRemoveFunctions(this._fnOriginalRemovePopoverInstance);};
b.prototype._overrideRemoveFunctions=function(o){return function(p){var v=o.apply(I,arguments);if(this._isSupportedPopup(p)){if(this._isPopupAdaptable(p,false)&&this.getRta()._oDesignTime){this.getRta()._oDesignTime.removeRootElement(p);}this._oModalState.delete(p.oPopup);this.fireClose(p);}return v;}.bind(this);};
b.prototype._getAppComponentForControl=function(o){var d;var A;if(o instanceof C){d=o;}else{d=this._getComponentForControl(o);}if(d){A=f.getAppComponentForControl(d);}return A;};
b.prototype._getComponentForControl=function(o){var d;var r;var p;if(o){d=C.getOwnerComponentFor(o);if(!d&&typeof o.getParent==="function"&&o.getParent()instanceof E){p=o.getParent();}else if(d){p=d;}if(p){r=this._getComponentForControl(p);}}return r||d;};
b.prototype._createPopupOverlays=function(e){if(!e){return;}var p=(e instanceof E)?e:e.getSource();if(this.getRta()._oDesignTime.getRootElements().indexOf(p.getId())===-1&&!this._isComponentInsidePopup(p)){this.getRta()._oDesignTime.addRootElement(p);}p.detachAfterOpen(this._createPopupOverlays,this);this._applyPopupPatch(p);};
b.prototype._restoreInstanceFunctions=function(){if(this._fnOriginalAddDialogInstance){I.addDialogInstance=this._fnOriginalAddDialogInstance;}if(this._fnOriginalRemoveDialogInstance){I.removeDialogInstance=this._fnOriginalRemoveDialogInstance;}if(this._fnOriginalAddPopoverInstance){I.addPopoverInstance=this._fnOriginalAddPopoverInstance;}if(this._fnOriginalRemovePopoverInstance){I.removePopoverInstance=this._fnOriginalRemovePopoverInstance;}this._applyPatchesToOpenPopups(this._removePopupPatch);};
b.prototype._removePopupPatch=function(p){var o=p.oPopup;o[this._getFocusEventName("add")]();if(this.fnOriginalPopupOnAfterRendering){o.onAfterRendering=this.fnOriginalPopupOnAfterRendering;}};
function c(p){if(!p||p instanceof C){return true;}if(!p.isPopupAdaptationAllowed||p.isPopupAdaptationAllowed()){return c(p.getParent());}return false;}
b.prototype._isPopupAdaptable=function(p){if(p.isPopupAdaptationAllowed&&!p.isPopupAdaptationAllowed()){return false;}var o=this._getAppComponentForControl(p);if(this.oRtaRootAppComponent===o||this._isComponentInsidePopup(p)){return c(p.getParent());}return false;};
b.prototype.exit=function(){this._restoreInstanceFunctions();delete this._oModalState;this._aPopupFilters.forEach(function(d){Z.removePopupFilter(d);});};
return b;});
sap.ui.predefine('sap/ui/rta/util/ServiceEventBus',["sap/ui/core/EventBus"],function(E){"use strict";
var S=E.extend("sap.ui.rta.util.ServiceEventBus");
S.prototype._callListener=function(c,l,C,e,d){c.call(l,d);};
S.prototype.getChannel=function(c){return this._mChannels[c];};
return S;});
sap.ui.predefine('sap/ui/rta/util/StylesLoader',["sap/ui/thirdparty/jquery"],function(q){"use strict";var m={};
m.loadStyles=function(f){return q.get(sap.ui.require.toUrl(('sap.ui.rta.assets.'+f).replace(/\./g,"/"))+'.css').then(function(d){if(sap.ui.getCore().getConfiguration().getRTL()){return d.replace(/right/g,'left');}return d;});};
return m;},true);
sap.ui.predefine('sap/ui/rta/util/UrlParser',[],function(){"use strict";var m={};
m.getParam=function(p){return m.getParams()[p];};
m.getParams=function(){return document.location.search.replace(/^\?/,'').split('&').reduce(function(p,P){var a=P.split('=');var v=a[1];switch(v){case'true':v=true;break;case'false':v=false;break;}p[a[0]]=v;return p;},{});};
return m;},true);
sap.ui.predefine('sap/ui/rta/util/changeVisualization/ChangeIndicator',["sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/core/Control","sap/m/Text","sap/ui/core/format/DateFormat","sap/ui/core/Icon","sap/ui/events/KeyCodes","sap/base/strings/capitalize","sap/ui/rta/util/changeVisualization/categories/getVisualizationCategory","sap/ui/fl/Utils","sap/ui/fl/util/resolveBinding"],function(F,J,C,T,D,I,K,c,g,a,r){"use strict";
var b=C.extend("sap.ui.rta.util.changeVisualization.ChangeIndicator",{
metadata:{library:"sap.ui.rta",properties:{changes:{type:"array",defaultValue:[]},mode:{type:"string",defaultValue:"change"},posX:{type:"int"},posY:{type:"int"},overlayId:{type:"string"},selectorId:{type:"string"}},aggregations:{_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{selectChange:{parameters:{changeId:{type:"string"}}},keyPress:{parameters:{originalEvent:{type:"object"}}}}},
renderer:{apiVersion:2,render:function(R,o){R.openStart("div",o);R.class("sapUiRtaChangeIndicator");R.class("sapUiRtaChangeIndicator"+c(o.getMode()));if(o.getMode()==="change"&&o.getModel()&&o.getModel().getData().selectedChange){R.class("sapUiRtaChangeIndicatorChangeSolid");}R.style("width",o._getSize()+"px");R.style("height",o._getSize()+"px");R.openEnd();R.openStart("div");R.openEnd();R.renderControl(o.getAggregation("_icon"));R.renderControl(o.getAggregation("_text"));R.close("div");R.close("div");}},
constructor:function(){this._oDetailModel=new J();this._oDetailModel.setDefaultBindingMode("OneWay");C.prototype.constructor.apply(this,arguments);}
});
b.prototype.init=function(){this.setAggregation("_text",new T({text:"{= (${changes} || []).length}",visible:"{= (${changes} || []).length > 1}"}).addStyleClass("sapUiRtaChangeIndicatorText"));this.setAggregation("_icon",new I({src:"sap-icon://display",visible:{path:"/selectedChange",formatter:function(s){return!!(s&&this.getChanges().some(function(o){return(o.id===s&&o.dependent===false);}));}.bind(this)}}).addStyleClass("sapUiRtaChangeIndicatorIcon"));this.attachBrowserEvent("click",this._onSelect,this);this.attachBrowserEvent("keydown",this._onKeyDown,this);this.attachBrowserEvent("mouseleave",function(){this._toggleHoverStyleClasses(false);},this);this.attachBrowserEvent("focusout",function(){this._toggleHoverStyleClasses(false);},this);this.attachBrowserEvent("mouseover",function(){this._toggleHoverStyleClasses(true);},this);this.attachBrowserEvent("focusin",function(){this._toggleHoverStyleClasses(true);},this);};
b.prototype.focus=function(){if(this.getDomRef()){C.prototype.focus.apply(this,arguments);this._bScheduledForFocus=false;}this._bScheduledForFocus=true;};
b.prototype._getSize=function(){var o=document.getElementById(this.getOverlayId());var s=o.offsetHeight;return(s>50?50:s)-2;};
b.prototype.onAfterRendering=function(){var o=document.getElementById(this.getOverlayId());o.appendChild(this.getDomRef());this.getDomRef().tabIndex=0;if(this._bScheduledForFocus){this.focus();this._toggleHoverStyleClasses(true);}};
b.prototype.exit=function(){var d=this.getDomRef();if(d){d.parentNode.removeChild(d);}this.detachBrowserEvent("click",this._onSelect,this);this.detachBrowserEvent("keydown",this._onKeyDown,this);};
b.prototype.setChanges=function(d){this.setProperty("changes",d);this._oDetailModel.setData((d||[]).map(this._formatChangesModelItem.bind(this)));};
b.prototype.setMode=function(m){this.setProperty("mode",m);this._oDetailModel.setData((this.getChanges()||[]).map(this._formatChangesModelItem.bind(this)));};
b.prototype._onSelect=function(e){this.focus();e.stopPropagation();if(this.getModel().getData().selectedChange&&!this.getChanges().some(function(o){return o.dependent;})){this.fireSelectChange({changeId:undefined});}else{this._openDetailPopover();}};
b.prototype._onKeyDown=function(e){if(e.keyCode===K.ENTER){this._onSelect(e);}this.fireKeyPress({originalEvent:e});};
b.prototype._toggleHoverStyleClasses=function(A){var o=sap.ui.getCore().byId(this.getOverlayId());if(o.getMetadata().getName()!=="sap.ui.dt.ElementOverlay"){return;}var f=A?"addStyleClass":"removeStyleClass";o[f]("sapUiRtaOverlayHover");o[f]("sapUiRtaChangeIndicatorHovered");};
b.prototype._formatChangesModelItem=function(m){var A=sap.ui.getCore().byId(m.affectedElementId);var p=Object.keys(m.payload||{}).reduce(function(p,k){var O=m.payload[k];var j=a.isBinding(O);var V=j?r(O,A):O;p[k]=V;return p;},{});var o=sap.ui.getCore().byId(this.getOverlayId());var e=o.getDesignTimeMetadata().getLabel(A);var v=g(m.commandCategory);var d=v&&v.getDescription(p,e);var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var M=this.getMode();var s=m.commandName.charAt(0).toUpperCase()+m.commandName.slice(1);e=e&&"'"+e+"'";var f=("TXT_CHANGEVISUALIZATION_"+M.toUpperCase()+"_"+m.commandName.toUpperCase());var h=d||R.getText(f,e);var i=D.getDateTimeInstance().format(new Date(m.change.getCreation()));var E=(M==="change"&&(m.commandName==="move"||m.commandName==="split"));return{id:m.id,change:m,changeTitle:s,description:h,date:i,enableDetailButton:E};};
b.prototype._openDetailPopover=function(){if(!this.getAggregation("_popover")){F.load({name:"sap.ui.rta.util.changeVisualization.ChangeIndicatorPopover",controller:this}).then(function(p){p._bOpenedByChangeIndicator=true;this.setAggregation("_popover",p);p.setModel(this._oDetailModel,"details");p.openBy(this);}.bind(this));}else{if(this.getAggregation("_popover").isOpen()){return this.getAggregation("_popover").close();}this.getAggregation("_popover").openBy(this);}};
b.prototype._showDependentElements=function(e){this.getAggregation("_popover").close();var s=this.getChanges().length>1?e.getSource().getBindingContext("details").getObject().id:this.getChanges()[0].id;this.fireSelectChange({changeId:s});};
return b;});
sap.ui.predefine('sap/ui/rta/util/changeVisualization/ChangeIndicatorRegistry',["sap/ui/base/ManagedObject","sap/base/util/includes","sap/base/util/values","sap/base/util/restricted/_omit"],function(M,i,v,_){"use strict";
var C=M.extend("sap.ui.rta.util.changeVisualization.ChangeIndicatorRegistry",{
metadata:{properties:{commandCategories:{type:"object",defaultValue:[]}}},
constructor:function(){M.prototype.constructor.apply(this,arguments);this._oChanges={};this._oChangeIndicators={};}
});
C.prototype.exit=function(){this.reset();};
C.prototype.getChanges=function(){return v(this._oChanges||{}).map(function(c){return Object.assign({},c);});};
C.prototype.getChangeIds=function(){return Object.keys(this._oChanges||{});};
C.prototype.getChange=function(c){return this._oChanges[c]&&Object.assign({},this._oChanges[c]);};
C.prototype.getChangeIndicatorData=function(){var c={};function a(s,A,o,d){if(c[s]===undefined){c[s]=[];}c[s].push(Object.assign({id:o.change.getId(),dependent:d,affectedElementId:A,payload:o.visualizationInfo.payload||{}},_(o,["visualizationInfo"])));}v(this._oChanges).forEach(function(o){o.visualizationInfo.displayElementIds.forEach(function(s,I){a(s,o.visualizationInfo.affectedElementIds[I],o,false);});o.visualizationInfo.dependentElementIds.forEach(function(s){a(s,s,o,true);});});return c;};
C.prototype.hasChangeIndicator=function(s){return!!this._oChangeIndicators[s];};
C.prototype.getChangeIndicator=function(s){return this._oChangeIndicators[s];};
C.prototype.getChangeIndicators=function(){return v(this._oChangeIndicators||{});};
C.prototype.registerChange=function(c,s){var a=this.getCommandCategories();var n={change:c,commandName:s,commandCategory:Object.keys(a).find(function(b){return i(a[b],s);}),visualizationInfo:{affectedElementIds:[],displayElementIds:[],dependentElementIds:[]}};if(n.commandCategory===undefined){return;}this._oChanges[c.getId()]=n;};
C.prototype.registerChangeIndicator=function(s,c){this._oChangeIndicators[s]=c;};
C.prototype.addVisualizationInfo=function(c,V){var o=this._oChanges[c];if(o===undefined){throw new Error("Change id is not registered");}o.visualizationInfo=Object.assign({},o.visualizationInfo,V);};
C.prototype.reset=function(){Object.keys(this._oChanges).forEach(function(k){this.removeChange(k);}.bind(this));v(this._oChangeIndicators).forEach(function(I){I.destroy();});this._oChangeIndicators={};};
C.prototype.removeChange=function(c){delete this._oChanges[c];};
return C;});
sap.ui.predefine('sap/ui/rta/util/changeVisualization/ChangeVisualization',["sap/base/util/restricted/_difference","sap/base/util/deepEqual","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Control","sap/ui/dt/OverlayRegistry","sap/ui/dt/ElementUtil","sap/ui/events/KeyCodes","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/model/resource/ResourceModel","sap/ui/model/json/JSONModel","sap/ui/rta/util/changeVisualization/ChangeIndicator","sap/ui/rta/util/changeVisualization/ChangeIndicatorRegistry"],function(d,a,J,C,O,E,K,b,c,P,L,F,R,e,f,g){"use strict";var V={add:["createContainer","addDelegateProperty","reveal","addIFrame"],move:["move"],rename:["rename"],combinesplit:["combine","split"],remove:["remove"]};var h="all";var i={all:"sap-icon://show",add:"sap-icon://add",move:"sap-icon://move",rename:"sap-icon://edit",combinesplit:"sap-icon://combine",remove:"sap-icon://less"};
var j=C.extend("sap.ui.rta.util.changeVisualization.ChangeVisualization",{
metadata:{library:"sap.ui.rta",properties:{rootControlId:{type:"string"},isActive:{type:"boolean",defaultValue:false}}},
constructor:function(){C.prototype.constructor.apply(this,arguments);this._oChangeIndicatorRegistry=new g({commandCategories:V});this._oTextBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");this.setModel(new R({bundle:this._oTextBundle}),"i18n");this._oChangeVisualizationModel=new e({active:this.getIsActive()});this._oChangeVisualizationModel.setDefaultBindingMode("OneWay");this._sSelectedCommandCategory="all";this._bSetModeChanged=false;}
});
j.prototype.setRootControlId=function(r){if(this.getRootControlId()&&this.getRootControlId()!==r){this._reset();}this.setProperty("rootControlId",r);};
j.prototype._getComponent=function(){return F.getAppComponentForControl(E.getElementInstance(this.getRootControlId()));};
j.prototype.setIsActive=function(A){if(A===this.getIsActive()){return;}this.setProperty("isActive",A);if(this._oChangeVisualizationModel){this._updateVisualizationModel({active:A});}};
j.prototype.exit=function(){this._oChangeIndicatorRegistry.destroy();};
j.prototype._reset=function(){this._oChangeIndicatorRegistry.reset();};
j.prototype._updateVisualizationModelMenuData=function(){var k=Object.keys(V).map(function(s){var t=this._getCommandCategoryLabel(s,this._getChangesForCommandCategory(s).length);return{key:s,count:this._getChangesForCommandCategory(s).length,title:t,icon:i[s]};}.bind(this));k.unshift({key:h,count:this._getChangesForCommandCategory(h).length,title:this._getCommandCategoryLabel(h,this._getChangesForCommandCategory(h).length),icon:i[h]});this._updateVisualizationModel({commandCategories:k});};
j.prototype._getChangesForCommandCategory=function(s){var r=this._oChangeIndicatorRegistry.getChanges();return r.filter(function(o){return s===h?o.commandCategory!==undefined:s===o.commandCategory;});};
j.prototype._getCommandCategoryLabel=function(s,k){var l="TXT_CHANGEVISUALIZATION_OVERVIEW_"+s.toUpperCase();return this._oTextBundle.getText(l,[k]);};
j.prototype._getCommandCategoryButton=function(s){var B="BTN_CHANGEVISUALIZATION_OVERVIEW_"+s.toUpperCase();return this._oTextBundle.getText(B);};
j.prototype.onCommandCategorySelection=function(o){var s=o.getParameter("item").getKey();return this._selectCommandCategory(s);};
j.prototype._selectCommandCategory=function(s){this._sSelectedCommandCategory=s;var r=this._getChangesForCommandCategory(s);var k=this._getCommandCategoryButton(s);this._updateVisualizationModel({selectedChange:undefined,commandCategory:s,commandCategoryText:k});return Promise.all(r.map(function(o){return this._getVisualizationInfo(o).then(function(v){this._oChangeIndicatorRegistry.addVisualizationInfo(o.change.getId(),v);}.bind(this));}.bind(this))).then(function(){this._updateChangeIndicators();this._setFocusedIndicator();}.bind(this));};
j.prototype._getVisualizationInfo=function(m){var o=this._getComponent();function k(s){if(!s){return undefined;}return s.map(function(S){var l=typeof S.getId==="function"?S:J.bySelector(S,o);return l&&l.getId();}).filter(Boolean);}return this._getInfoFromChangeHandler(o,m.change).then(function(I){var v=I||{};var A=(k(v.affectedControls||[m.change.getSelector()]));return{affectedElementIds:A,dependentElementIds:k(v.dependentControls)||[],displayElementIds:k(v.displayControls)||A,payload:v.payload};});};
j.prototype._getCommandForChange=function(o){var s=o.getDefinition().support.command;if(s){return s;}var k=this._getComponent();var S=J.bySelector(o.getSelector(),k);var l=o.getDependentSelectorList().slice(-1)[0];var m=J.bySelector(l,k);function n(p,A){var q=p.getElement();var s=p.getDesignTimeMetadata().getCommandName(o.getChangeType(),q,A);if(s){return s;}var r=p.getParentElementOverlay();var t=p.getParentAggregationOverlay();if(p.getElement().getId()===S.getId()||!r){return undefined;}return n(r,t&&t.getAggregationName());}return S&&m&&n(O.getOverlay(m));};
j.prototype._getInfoFromChangeHandler=function(A,o){var k=J.bySelector(o.getSelector(),A);if(k){var p={modifier:J,appComponent:A,view:F.getViewForControl(k)};var m=b.getControlIfTemplateAffected(o,k,p);return c.getChangeHandler({changeType:o.getChangeType(),element:m.control,modifier:J,layer:o.getLayer()}).then(function(l){if(l&&typeof l.getChangeVisualizationInfo==="function"){return l.getChangeVisualizationInfo(o,A);}return undefined;});}return Promise.resolve();};
j.prototype._collectChanges=function(){var o=this._getComponent();var p={oComponent:o,selector:o,invalidateCache:false,includeVariants:true,currentLayer:L.CUSTOMER};return P._getUIChanges(p);};
j.prototype._updateChangeRegistry=function(){return this._collectChanges().then(function(k){var r=this._oChangeIndicatorRegistry.getChangeIds();var o=k.reduce(function(m,n){m[n.getId()]=n;return m;},{});var l=Object.keys(o);d(r,l).forEach(function(s){this._oChangeIndicatorRegistry.removeChange(s);}.bind(this));d(l,r).forEach(function(s){var m=o[s];var n=this._getCommandForChange(m);this._oChangeIndicatorRegistry.registerChange(m,n);}.bind(this));}.bind(this));};
j.prototype.selectChange=function(o){var s=o.getParameter("changeId");this._selectChange(s);};
j.prototype._selectChange=function(s){this._updateVisualizationModel({selectedChange:s});this._updateChangeIndicators();};
j.prototype._updateVisualizationModel=function(D){this._oChangeVisualizationModel.setData(Object.assign({},this._oChangeVisualizationModel.getData(),D));};
j.prototype._updateChangeIndicators=function(){var s=this._oChangeIndicatorRegistry.getChangeIndicatorData();var I={};Object.keys(s).forEach(function(S){var k=s[S];var o=O.getOverlay(S);if(!o||!o.getDomRef()){return undefined;}var l=o.getDomRef().getClientRects()[0]||{left:0,top:0};I[S]={posX:parseInt(l.left),posY:parseInt(l.top),changes:this._filterRelevantChanges(k)};if(!this._oChangeIndicatorRegistry.hasChangeIndicator(S)){this._createChangeIndicator(o,S);}return undefined;}.bind(this));if(!a(I,this._oChangeVisualizationModel.getData().content)){this._updateVisualizationModel({content:I});}};
j.prototype._filterRelevantChanges=function(k){if(!Array.isArray(k)){return k;}var r=this._oChangeVisualizationModel.getData();return k.filter(function(o){return((!r.selectedChange&&!o.dependent&&(r.commandCategory==='all'||r.commandCategory===o.commandCategory))||(!!r.selectedChange&&o.id===r.selectedChange));});};
j.prototype._createChangeIndicator=function(o,s){var k=new f({changes:"{changes}",mode:{path:"changes",formatter:function(l){var S=this.getModel().getData().selectedChange;return(S&&(l||[]).some(function(m){return m.dependent;}))?"dependent":"change";}},posX:"{posX}",posY:"{posY}",visible:"{= ${/active} && (${changes} || []).length > 0}",overlayId:o.getId(),selectorId:s,selectChange:this.selectChange.bind(this),keyPress:this._onIndicatorKeyPress.bind(this)});k.setModel(this._oChangeVisualizationModel);k.bindElement("/content/"+s);k.setModel(this.getModel("i18n"),"i18n");k.placeAt(sap.ui.getCore().getStaticAreaRef());this._oChangeIndicatorRegistry.registerChangeIndicator(s,k);};
j.prototype._onIndicatorKeyPress=function(o){var k=o.getParameter("originalEvent");var l=k.keyCode;var I=o.getSource();if(l===K.ARROW_UP||l===K.ARROW_LEFT||(l===K.TAB&&k.shiftKey)){k.stopPropagation();k.preventDefault();this._setFocusedIndicator(I,-1);}else if(l===K.ARROW_DOWN||l===K.ARROW_RIGHT||l===K.TAB){k.stopPropagation();k.preventDefault();this._setFocusedIndicator(I,1);}};
j.prototype._setFocusedIndicator=function(s,D){var v=this._oChangeIndicatorRegistry.getChangeIndicators().filter(function(o){return o.getVisible();}).sort(function(o,k){var l=o.getPosY()-k.getPosY();var m=o.getPosX()-k.getPosX();return l||m;});if(v.length===0){return;}var I=s?(v.length+v.indexOf(s)+D)%v.length:0;v[I].focus();};
j.prototype.triggerModeChange=function(r,t){if(this.getIsActive()){this.setIsActive(false);return;}if(!this.getRootControlId()){this.setRootControlId(r);}this.setIsActive(true);this._updateChangeRegistry().then(this._selectCommandCategory.bind(this,this._sSelectedCommandCategory)).then(function(){this._updateVisualizationModelMenuData();t.setModel(this._oChangeVisualizationModel,"visualizationModel");}.bind(this));};
return j;});
sap.ui.predefine('sap/ui/rta/util/hasStableId',["sap/ui/fl/Utils","sap/ui/dt/ElementUtil","sap/base/util/isPlainObject"],function(F,E,i){"use strict";
function a(c){var p=c.sParentAggregationName;var P=c.getParent();if(P&&p){var b=P.getBindingInfo(p);if(b){if(b.template&&c instanceof b.template.getMetadata().getClass()){return b.template;}return false;}return a(P);}return false;}
return function h(e){if(!e||e._bIsBeingDestroyed){return false;}if(typeof e.data("hasStableId")!=="boolean"){var s=e.getDesignTimeMetadata().getStableElements(e);var u=false;if(s.length>0){if(a(e.getElement())){u=s.some(function(S){var c;var A;var u=false;if(i(S)){c=S.id;A=S.appComponent;}else{c=S;}u=!F.checkControlId(c,A);if(u){var C=E.getElementInstance(c);if(E.getElementInstance(c)){var l=E.getAggregationInformation(C);u=!F.checkControlId(E.extractTemplateId(l),A);}}return u;});}else{u=s.some(function(S){var c=S.id||S;return!F.checkControlId(c,S.appComponent);});}}e.data("hasStableId",!u);}return e.data("hasStableId");};});
sap.ui.predefine('sap/ui/rta/util/showMessageBox',["sap/m/MessageBox","sap/ui/layout/HorizontalLayout","sap/m/Link","sap/m/Text"],function(M,H,L,T){"use strict";var l="\\[(.*?)\\]\\((.*?)\\)";
function h(m){var r=g(m);return Array.isArray(r)&&r.length>0;}
function a(t){var r=new RegExp("^"+l+"$");return Array.isArray(r.exec(t));}
function e(s){var m=new RegExp(l).exec(s);return{text:m[1],href:m[2]};}
function g(m){var r=new RegExp(l,"g");return m.match(r);}
function c(s){var o=new H({allowWrapping:true,content:s.map(function(S){if(a(S)){var m=e(S);return new L({text:m.text,href:m.href,target:"_blank",emphasized:true,wrapping:true});}return new T({text:S,renderWhitespace:true});})});o.addStyleClass("sapUiRtaMessageBox");return o;}
function b(m){var s=[m];var d=g(m);d.forEach(function(f){var i=0;while(i<s.length){var S=s[i];if(a(S)){i++;}else{var p=S.split(f);var I=[];p.forEach(function(P,j,o){I.push(P);if(j!==o.length-1){I.push(f);}});s.splice.apply(s,[i,1].concat(I));i+=I.length;}}});return s;}
return function d(m,o){var v;if(h(m)){var s=b(m);v=c(s);}else{v=m;}M.show(v,o);};});
sap.ui.predefine('sap/ui/rta/util/validateFlexEnabled',["sap/ui/fl/Utils","sap/m/MessageBox","sap/base/util/ObjectPath","sap/ui/rta/util/validateStableIds","sap/ui/rta/util/showMessageBox","sap/base/Log","sap/ui/rta/Utils","sap/ui/dt/Util"],function(F,M,O,v,s,L,U,D){"use strict";return function(r){function _(r,C,t,i,T){var j=C.getId();if(!m[j]){s(r._getTextResources().getText(t),{icon:M.Icon[i],title:r._getTextResources().getText(T),styleClass:U.getRtaStyleClassName()});a(j,true);}}function a(i,V){m[i]=V;}function b(C){var o=C.getManifest();return(O.get(["sap.app","id"],o)!=="sap.ui.documentation.sdk"&&!(O.get(["sap.app","id"],o)||"").startsWith("sap.ui.rta")&&!O.get(["sap.ovp"],o));}function c(){return("QUnit"in window||(window.frameElement&&(window.frameElement.getAttribute("id")||"").toLowerCase()==="opaframe"));}function d(i){return i&&!i._bIsBeingDestroyed;}function e(E){var n=E.getParameters().mode;if(n==="adaptation"){var r=E.getSource();var C=F.getAppComponentForControl(r.getRootControlInstance());p=p.filter(d);g(r,C,p);p=[];}}function f(E,r){var i=E.getParameters().elementOverlay;if(r.getMode()==="adaptation"){var C=F.getAppComponentForControl(r.getRootControlInstance());D.waitForSynced(r._oDesignTime,function(j){if(d(j)){g(r,C,[j]);}})(i);}else{p.push(i);}}function g(r,C,E){var u=v(E,C);if(u.length){u.forEach(function(i){L.error("Control ID was generated dynamically by SAPUI5. To support SAPUI5 flexibility, a stable control ID is needed to assign the changes to.",i.getElement().getId());});_(r,C,"MSG_UNSTABLE_ID_FOUND","ERROR","HEADER_ERROR");}}var m={};var p=[];var C=F.getAppComponentForControl(r.getRootControlInstance());r.attachEventOnce("stop",function(){a(C.getId(),false);});if(C&&b(C)){var o=C.getManifest();var h=O.get(["sap.ui5","flexEnabled"],o);if(typeof h!=="boolean"){if(!c()){_(r,C,"MSG_NO_FLEX_ENABLED_FLAG","WARNING","HEADER_WARNING");}}else{r.attachEvent("modeChanged",e);r._oDesignTime.attachEvent("elementOverlayCreated",r,f);g(r,C,r._oDesignTime.getElementOverlays());}}};});
sap.ui.predefine('sap/ui/rta/util/validateStableIds',["sap/base/util/ObjectPath","sap/ui/rta/util/hasStableId","sap/ui/core/mvc/View","sap/ui/core/Fragment","sap/ui/dt/OverlayUtil","sap/base/util/isPlainObject"],function(O,h,V,F,a,b){"use strict";
function c(C){var m=C.getManifest();return O.get(["sap.ui.generic.app"],m);}
function g(C){var m=C.getManifest();var v=O.get(["sap.ui5","extends","extensions","sap.ui.viewExtensions"],m);var e=[];if(b(v)){Object.keys(v).forEach(function(s){if(s.startsWith("sap.suite.ui.generic.template")){var f=v[s];Object.keys(f).forEach(function(i){e.push(f[i]);});}});}return e;}
function d(e,E){var f=[];for(var i=0,l=E.length;i<l;i++){var o=E[i];var j=o.getElement();var I=e.some(function(v){var C=O.get(v.className);var s;var k;if(j instanceof V){k=j.getViewName();s=v.viewName;}else if(j instanceof F){k=j.getFragmentName();}else{return false;}return(j instanceof C&&k===s);});if(I){f.push(o);if(f.length===e.length){break;}}}var r=[];f.forEach(function(o){a.iterateOverlayElementTree(o,function(o){r.push(o);});});return r;}
return function(e,C){var r=[];var R=e.slice(0);if(c(C)){var E=g(C);R=(E.length?d(E,R):[]);}r=R.filter(function(o){return(!o.getDesignTimeMetadata().markedAsNotAdaptable()&&!h(o));});return r;};});
sap.ui.require.preload({
	"sap/ui/rta/appVariant/manageApps/webapp/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.rta.appVariant.manageApps","type":"application","i18n":{"bundleUrl":"i18n/i18n.properties","supportedLocales":["","ar","bg","ca","cs","da","de","el","en","en_US_sappsd","en_US_saptrc","es","et","fi","fr","hi","hr","hu","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh_CN","zh_TW"],"fallbackLocale":"en"},"applicationVersion":{"version":"1.0.0"},"title":"{{appTitle}}","description":"{{appDescription}}","resources":"resources.json","ach":"ach","sourceTemplate":{"id":"ui5template.basicSAPUI5ApplicationProject","version":"1.40.12"}},"sap.ui":{"technology":"UI5","icons":{"icon":"","favIcon":"","phone":"","phone@2":"","tablet":"","tablet@2":""},"deviceTypes":{"desktop":true,"tablet":true,"phone":true}},"sap.ui5":{"rootView":{"viewName":"sap.ui.rta.appVariant.manageApps.webapp.view.ManageApps","type":"XML","async":true},"dependencies":{"minUI5Version":"1.30.0","libs":{"sap.ui.core":{},"sap.m":{},"sap.ui.layout":{},"sap.ui.rta":{}}},"contentDensities":{"compact":true,"cozy":true},"models":{"i18n":{"type":"sap.ui.model.resource.ResourceModel","settings":{"bundleName":"sap.ui.rta.appVariant.manageApps.webapp.i18n.i18n","supportedLocales":["","ar","bg","ca","cs","da","de","el","en","en_US_sappsd","en_US_saptrc","es","et","fi","fr","hi","hr","hu","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh_CN","zh_TW"],"fallbackLocale":"en"}}},"resources":{"css":[{"uri":"css/style.css"}]}}}',
	"sap/ui/rta/appVariant/manageApps/webapp/view/ManageApps.view.xml":'<mvc:View controllerName="sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core" xmlns="sap.m"><Table id="Table1" showNoData="false" inset="false" growing="true" growingThreshold="500" sticky="ColumnHeaders" items="{/appVariants}"><columns><Column width="8rem" hAlign="Left"><Text text="{i18n&gt;MAA_DIALOG_APP_TYPE}"/></Column><Column width="4rem" minScreenWidth="tablet" demandPopin="true" popinDisplay="Inline" hAlign="Left"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_ICON}"/></Column><Column minScreenWidth="tablet" demandPopin="true" popinDisplay="Inline" hAlign="Left"><Text text="{i18n&gt;MAA_DIALOG_TITLE}"/></Column><Column minScreenWidth="tablet" demandPopin="true" popinDisplay="Inline" hAlign="Left"><Text text="{i18n&gt;MAA_DIALOG_DESCRIPTION}"/></Column><Column width="8rem" minScreenWidth="Desktop" demandPopin="true" popinDisplay="Inline" hAlign="End"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_ACTIONS_HEADER}"/></Column></columns><items><ColumnListItem highlight="{path:\'currentStatus\',formatter:\'.formatRowHighlight\'}"><cells><ObjectIdentifier title="{typeOfApp}" text="{currentStatus}"/><core:Icon src="{icon}" tooltip="{iconText}" class="sapUiListTableIconSize"/><ObjectIdentifier title="{title}" text="{subTitle}"/><Text text="{description}"/><MenuButton text="{i18n&gt;MAA_DIALOG_ACTIONS}"><menu><Menu itemSelected="onMenuAction"><items><MenuItem text="{i18n&gt;MAA_DIALOG_ADAPT_UI}" visible="{parts:[{path:\'adaptUIButtonVisibility\'},{path:\'isKeyUser\'}],formatter:\'.formatAdaptUIButtonVisibility\'}" enabled="{adaptUIButtonEnabled}" tooltip="{parts:[{path:\'adaptUIButtonEnabled\'},{path:\'appVarStatus\'}],formatter:\'.formatAdaptUIButtonTooltip\'}" icon="sap-icon://wrench"/><MenuItem text="{i18n&gt;MAA_DIALOG_COPY_ID}" tooltip="{i18n&gt;TOOLTIP_MAA_DIALOG_COPY_ID}" icon="sap-icon://copy"/><MenuItem text="{i18n&gt;MAA_DIALOG_DELETE_APPVAR}" enabled="{delAppVarButtonEnabled}" visible="{delAppVarButtonVisibility}" tooltip="{parts:[{path:\'delAppVarButtonEnabled\'},{path:\'isS4HanaCloud\'}],formatter:\'.formatDelButtonTooltip\'}" icon="sap-icon://delete"/><MenuItem text="{i18n&gt;MAA_DIALOG_SAVE_AS_APP}" enabled="{saveAsButtonEnabled}" tooltip="{i18n&gt;TOOLTIP_MAA_DIALOG_SAVE_AS_APP}" icon="sap-icon://save" visible="{isKeyUser}"/></items></Menu></menu></MenuButton></cells></ColumnListItem></items></Table></mvc:View>',
	"sap/ui/rta/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.rta","type":"library","embeds":["appVariant/manageApps/webapp"],"applicationVersion":{"version":"1.96.3"},"title":"SAPUI5 library with RTA controls.","description":"SAPUI5 library with RTA controls.","ach":"CA-UI5-FL-RTA","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.96","libs":{"sap.ui.core":{"minVersion":"1.96.3"},"sap.ui.layout":{"minVersion":"1.96.3"},"sap.m":{"minVersion":"1.96.3"},"sap.ui.fl":{"minVersion":"1.96.3"},"sap.ui.dt":{"minVersion":"1.96.3"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":[],"elements":[],"types":[],"interfaces":[]}}}}',
	"sap/ui/rta/plugin/additionalElements/AddElementsDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core" xmlns:layout="sap.ui.layout"><Dialog class="sapUIRtaFieldRepositoryDialog sapUiNoContentPadding" horizontalScrolling="false"><buttons><Button id="rta_addDialogOkButton" text="{i18n&gt;BTN_FREP_OK}" press="._submitDialog" type="Emphasized"/><Button text="{i18n&gt;BTN_FREP_CANCEL}" press="._cancelDialog"/></buttons><content><Toolbar><SearchField width="100%" liveChange="._updateModelFilter"/><Button text="" icon="sap-icon://sort" press="._resortList"/><Button id="rta_customFieldButton" text="" icon="sap-icon://add" tooltip="{/customFieldButtonTooltip}" enabled="{/customFieldEnabled}" visible="{/customFieldVisible}" press="._redirectToCustomFieldCreation"/></Toolbar><layout:VerticalLayout id="rta_businessContextContainer" class="sapUIRtaBusinessContextContainer" visible="{/businessContextVisible}" content="{/businessContextTexts}"><Text text="{text}"/></layout:VerticalLayout><ScrollContainer class="sapUIRtaCCDialogScrollContainer" vertical="true" horizontal="false"><List id="rta_addElementsDialogList" mode="MultiSelect" includeItemInSelection="true" growing="true" growingScrollToLoad="true" items="{path:\'/elements\',sorter:{path:\'label\',descending:false},templateShareable:false}" noDataText="{i18n&gt;MSG_NO_FIELDS}"><CustomListItem class="sapUIRtaListItem" type="Active" selected="{selected}" tooltip="{tooltip}"><VBox><Label design="Standard" text="{= ${parentPropertyName} &amp;&amp; ${duplicateName} ? ${label} + \' (\' + ${parentPropertyName} + \')\' : ${label} }"/><Label text="{= ${originalLabel} ? ${i18n&gt;LBL_FREP}.replace(\'{0}\', ${originalLabel}) : \'\'}" visible="{= !!${originalLabel} }"/></VBox></CustomListItem></List></ScrollContainer></content></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/plugin/iframe/AddIFrameDialog.fragment.xml":'<core:FragmentDefinition xmlns:core="sap.ui.core" xmlns="sap.m" xmlns:form="sap.ui.layout.form" xmlns:util="sap.ui.fl.util" xmlns:layout="sap.ui.layout"><Dialog id="sapUiRtaAddIFrameDialog" title="{/text/dialogTitle}" verticalScrolling="true" resizable="false" class="sapUiRtaAddIFrameDialog" draggable="true" validationSuccess="onValidationSuccess" validationError="onValidationError" parseError="onValidationError" contentWidth="50rem" contentHeight="44rem"><content><layout:VerticalLayout id="sapUiRtaAddIFrameDialog_VL" width="100%" class="sapUiRtaAddIFrameDialogVlWrapper"><Label id="sapUiRtaAddIFrameDialog_SizeTitle" text="{/text/sizeTitle}" class="sapUiRtaAddIFrameDialogSizeTitle" design="Bold"/><layout:Grid id="sapUiRtaAddIFrameDialog_SizeGrid" containerQuery="true" position="Center" class="sapUiRtaAddIFrameDialogSizeGrid" defaultSpan="XL6 L6 M6 S12"><form:SimpleForm id="sapUiRtaAddIFrameDialog_WidthForm" editable="true" layout="ResponsiveGridLayout" class="sapUiRtaAddIFrameDialogWidthForm" adjustLabelSpan="false" singleContainerFullSize="false" ariaLabelledBy="sapUiRtaAddIFrameDialog_WidthLabel" labelSpanXL="2" labelSpanL="2" labelSpanM="2" labelSpanS="4" emptySpanXL="2" emptySpanL="2" emptySpanM="2" emptySpanS="0"><form:content><Label id="sapUiRtaAddIFrameDialog_WidthLabel" class="sapUiRtaAddIFrameDialogWidthLabel" labelFor="sapUiRtaAddIFrameDialog_WidthInput" text="{/text/widthLabel}"/><Input id="sapUiRtaAddIFrameDialog_WidthInput" class="sapUiRtaAddIFrameDialogWidthInput" value="{path:\'/frameWidth/value\',type:\'sap.ui.model.type.Float\',constraints:{minimum:1}}" valueState="{/frameWidth/valueState}"/><Select id="sapUiRtaAddIFrameDialog_WidthUnit" class="sapUiRtaAddIFrameDialogWidthUnit" ariaLabelledBy="sapUiRtaAddIFrameDialog_WidthUnitLabel" change="onSizeUnitChange" selectedKey="{/frameWidthUnit/value}" items="{/unitsOfMeasure}"><core:Item key="{name}" text="{name}"/></Select></form:content></form:SimpleForm><form:SimpleForm id="sapUiRtaAddIFrameDialog_HeightForm" editable="true" layout="ResponsiveGridLayout" class="sapUiRtaAddIFrameDialogHeightForm" adjustLabelSpan="false" singleContainerFullSize="false" ariaLabelledBy="sapUiRtaAddIFrameDialog_HeightLabel" labelSpanXL="2" labelSpanL="2" labelSpanM="2" labelSpanS="4" emptySpanXL="2" emptySpanL="2" emptySpanM="2" emptySpanS="0"><form:content><Label id="sapUiRtaAddIFrameDialog_HeightLabel" class="sapUiRtaAddIFrameDialogHeightLabel" labelFor="sapUiRtaAddIFrameDialog_HeightInput" text="{/text/heightLabel}"/><Input id="sapUiRtaAddIFrameDialog_HeightInput" class="sapUiRtaAddIFrameDialogHeightInput" value="{path:\'/frameHeight/value\',type:\'sap.ui.model.type.Float\',constraints:{minimum:1}}" valueState="{/frameHeight/valueState}"/><Select id="sapUiRtaAddIFrameDialog_HeightUnit" class="sapUiRtaAddIFrameDialogHeightUnit" ariaLabelledBy="sapUiRtaAddIFrameDialog_HeightUnitLabel" change="onSizeUnitChange" selectedKey="{/frameHeightUnit/value}" items="{/unitsOfMeasure}"><core:Item key="{name}" text="{name}"/></Select></form:content></form:SimpleForm></layout:Grid><layout:Grid id="sapUiRtaAddIFrameDialog_PercentGrid" class="sapUiRtaAddIFrameDialogPercentGrid" containerQuery="true" position="Right" defaultSpan="XL12 L12 M12 S12"><Text id="sapUiRtaAddIFrameDialog_PercentText" text="{/text/percentUseLabel}" class="sapUiRtaAddIFrameDialogPercentText"/></layout:Grid><layout:Grid id="sapUiRtaAddIFrameDialog_EditGrid" class="sapUiRtaAddIFrameDialogEditGrid" containerQuery="true" defaultSpan="XL6 L6 M6 S12"><VBox id="sapUiRtaAddIFrameDialog_Parameters" class="sapUiRtaAddIFrameDialogParameters" renderType="Bare"><items><Label id="sapUiRtaAddIFrameDialog_ParametersLabel" text="{/text/parametersLabel}" labelFor="sapUiRtaAddIFrameDialog_ParameterTable" class="sapUiRtaAddIFrameDialogParametersLabel" design="Bold"/><SearchField id="sapUiRtaAddIFrameDialog_ParametersSearch" ariaLabelledBy="sapUiRtaAddIFrameDialog_ParameterSearchLabel" class="sapUiRtaAddIFrameDialogParametersSearch" search="onSearch"/><ScrollContainer height="12rem" vertical="true"><Table id="sapUiRtaAddIFrameDialog_ParameterTable" items="{/parameters/value}" ariaLabelledBy="sapUiRtaAddIFrameDialog_ParametersLabel" class="sapUiSizeCompact sapUiRtaAddIFrameDialogParameterTable" sticky="ColumnHeaders"><columns><Column><header><Label id="sapUiRtaAddIFrameDialog_ParameterLabel" class="sapUiRtaAddIFrameDialogParameterLabel" text="{/text/columnParameterLabel}"/></header></Column><Column><header><Label id="sapUiRtaAddIFrameDialog_ValueLabel" class="sapUiRtaAddIFrameDialog_ValueLabel" text="{/text/columnUiValueLabel}"/></header></Column></columns><items><ColumnListItem type="Active" press="onParameterPress"><cells><Text text="{label}"/><Text text="{value}" wrapping="false"/></cells></ColumnListItem></items></Table></ScrollContainer></items></VBox><VBox id="sapUiRtaAddIFrameDialog_EditUrl" class="sapUiRtaAddIFrameDialogEditUrl" renderType="Bare"><items><Label id="sapUiRtaAddIFrameDialog_EditUrlLabel" labelFor="sapUiRtaAddIFrameDialog_EditUrlTA" class="sapUiRtaAddIFrameDialogEditUrlLabel" text="{/text/editUrlLabel}" design="Bold"/><TextArea id="sapUiRtaAddIFrameDialog_EditUrlTA" ariaLabelledBy="sapUiRtaAddIFrameDialog_EditUrlLabel" class="sapUiRtaAddIFrameDialog_EditUrlTA" valueLiveUpdate="true" value="{/frameUrl/value}" liveChange="onUrlChange" rows="11" width="100%"/></items></VBox></layout:Grid><layout:Grid id="sapUiRtaAddIFrameDialog_UrlWarningGrid" class="sapUiRtaAddIFrameDialogUrlWarningGrid" containerQuery="true" defaultSpan="XL12 L12 M12 S12"><FormattedText id="sapUiRtaAddIFrameDialog_DocumentationLink" htmlText="{/documentationLink/HTML}" class="sapUiRtaAddIFrameDialogDocumentationLink"/></layout:Grid><layout:Grid id="sapUiRtaAddIFrameDialog_PreviewLinkGrid" class="sapUiRtaAddIFrameDialogPreviewLinkGrid" containerQuery="true" defaultSpan="XL12 L12 M12 S12"><Panel id="sapUiRtaAddIFrameDialog_PreviewLinkPanel" expandable="true" width="auto" expanded="false" class="sapUiResponsiveMargin sapUiRtaAddIFrameDialogPreviewLinkPanel"><headerToolbar><OverflowToolbar id="sapUiRtaAddIFrameDialog_PreviewLinkToolbar" class="sapUiRtaAddIFrameDialogPreviewLinkToolbar" height="3rem" style="Clear"><Title id="sapUiRtaAddIFrameDialog_PreviewLinkTitle" class="sapUiRtaAddIFrameDialogPreviewLinkTitle" text="{/text/previewUrlLabel}"/><ToolbarSpacer/><Button id="sapUiRtaAddIFrameDialog_PreviewButton" enabled="{=${/previewUrl/value} !== ${/frameUrl/value} }" text="{=${/previewUrl/value} === \'\' ? ${/text/showPreviewButton} : ${/text/updatePreviewButton} }" press="onShowPreview" class="sapUiTinyMarginTop sapUiRtaAddIFrameDialogPreviewButton"/></OverflowToolbar></headerToolbar><content><Link id="sapUiRtaAddIFrameDialog_PreviewLink" class="sapUiRtaAddIFrameDialogPreviewLink" href="{/previewUrl/value}" text="{/previewUrl/value}" wrapping="true" visible="{= !!${/previewUrl/value} }"/></content></Panel></layout:Grid><layout:Grid id="sapUiRtaAddIFrameDialog_PreviewGrid" class="sapUiRtaAddIFrameDialogPreviewGrid" containerQuery="true" defaultSpan="XL12 L12 M12 S12"><VBox id="sapUiRtaAddIFrameDialog_PreviewGridVB" class="sapUiRtaAddIFrameDialogPreviewGridVB" renderType="Bare"><layoutData><FlexItemData growFactor="1"/></layoutData><items><Label id="sapUiRtaAddIFrameDialog_NoPreviewLabel" class="sapUiRtaAddIFrameDialogNoPreviewLabel" wrapping="true" text="{/text/previewUrlMessage}" textAlign="Center" visible="{= !${/previewUrl/value} }"/><util:IFrame id="sapUiRtaAddIFrameDialog_PreviewFrame" title="{/text/previewFrameLabel}" class="sapUiRtaAddIFrameDialogPreviewFrame" visible="{= !!${/previewUrl/value} }"/></items></VBox></layout:Grid></layout:VerticalLayout><core:InvisibleText id="sapUiRtaAddIFrameDialog_WidthUnitLabel" text="{/text/widthUnitLabel}"/><core:InvisibleText id="sapUiRtaAddIFrameDialog_HeightUnitLabel" text="{/text/heightUnitLabel}"/><core:InvisibleText id="sapUiRtaAddIFrameDialog_ParameterSearchLabel" text="{/text/parameterSearchLabel}"/></content><beginButton><Button id="sapUiRtaAddIFrameDialogSaveButton" class="sapUiRtaAddIFrameDialogSaveButton" type="Emphasized" text="{/text/saveText}" press="onSavePress" enabled="{= !!${/frameUrl/value} }"/></beginButton><endButton><Button id="sapUiRtaAddIFrameDialogCancelButton" class="sapUiRtaAddIFrameDialogCancelButton" type="Transparent" text="{/text/cancelText}" press="onCancelPress"/></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/Adaptation.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core" xmlns:toolbar="sap.ui.rta.toolbar"><HBox id="sapUiRta_toolbarIconAndDraftSection" class="sapUiRtaToolbarIconAndDraftSection"><OverflowToolbar class="sapUiRta_iconAndDraftBar"><content><HBox id="sapUiRta_iconBox"/><ToolbarSpacer id="sapUiRta_iconSpacer" width="0%" visible="true"/><Button id="sapUiRta_versionButton" type="Transparent" class="sapUiRtaVersionButton" icon="sap-icon://megamenu" iconFirst="false" visible="{= (${versions&gt;/versioningEnabled} &amp;&amp; ${controls&gt;/modeSwitcher} === \'adaptation\')}" text="{parts:[{path:\'versions&gt;/versions\'},{path:\'versions&gt;/displayedVersion\'}],formatter:\'.formatVersionButtonText\'}" tooltip="{parts:[{path:\'versions&gt;/versions\'},{path:\'versions&gt;/displayedVersion\'}],formatter:\'.formatVersionButtonText\'}" press=".showVersionHistory"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></Button><toolbar:OverflowToolbarButton id="sapUiRta_activate" icon="sap-icon://activate" press=".activate(${versions&gt;/displayedVersion})" visible="{= (${versions&gt;/versioningEnabled} &amp;&amp; ${controls&gt;/modeSwitcher} === \'adaptation\')}" enabled="{versions&gt;/activateEnabled}" type="Transparent" text="{i18n&gt;TOL_ACTIVATE}" tooltip="{i18n&gt;TOL_ACTIVATE}"/><toolbar:OverflowToolbarButton id="sapUiRta_discardDraft" icon="sap-icon://delete" press=".discardDraft" visible="{= ((${parts: [\'versions&gt;/displayedVersion\', \'versions&gt;/versioningEnabled\' ], formatter: \'.formatDiscardDraftVisible\'})  &amp;&amp; (${controls&gt;/modeSwitcher} === \'adaptation\'))}" type="Transparent" text="{i18n&gt;TOL_DISCARD_DRAFT}" tooltip="{i18n&gt;TOL_DISCARD_DRAFT}"/></content></OverflowToolbar></HBox><HBox id="sapUiRta_switcherSection" class="sapUiRtaToolbarSwitcherSection"><OverflowToolbar><content><ToolbarSpacer/><SegmentedButton id="sapUiRta_modeSwitcher" selectionChange=".modeChange" selectedKey="{controls&gt;/modeSwitcher}" width="auto"><items><SegmentedButtonItem id="sapUiRta_adaptationSwitcherButton" text="{i18n&gt;BTN_ADAPTATION}" width="auto" key="adaptation"/><SegmentedButtonItem id="sapUiRta_navigationSwitcherButton" text="{i18n&gt;BTN_NAVIGATION}" width="auto" key="navigation"/><SegmentedButtonItem id="sapUiRta_visualizationSwitcherButton" text="{i18n&gt;BTN_VISUALIZATION}" width="auto" key="visualization"/></items></SegmentedButton><ToolbarSpacer/></content></OverflowToolbar></HBox><HBox id="sapUiRta_toolbarActionsSection" class="sapUiRtaToolbarActionsSection" justifyContent="End"><OverflowToolbar id="sapUiRta_actionsToolbar"><content><ToolbarSpacer/><toolbar:OverflowToolbarButton id="sapUiRta_translate" icon="sap-icon://translate" press=".showTranslationPopover" visible="{controls&gt;/translationVisible}" enabled="{controls&gt;/translationEnabled}" type="Transparent" text="{i18n&gt;BTN_TRANSLATE}" tooltip="{i18n&gt;BTN_TRANSLATE}"><toolbar:layoutData><OverflowToolbarLayoutData priority="Low"/></toolbar:layoutData></toolbar:OverflowToolbarButton><MenuButton id="sapUiRta_toggleChangeVisualizationMenuButton" visible="{= ${controls&gt;/modeSwitcher} === \'visualization\'}" text="{visualizationModel&gt;/commandCategoryText}" type="Transparent" tooltip="{i18n&gt;BUT_CHANGEVISUALIZATION_SELECTCHANGES}"><menu><Menu id="sapUiRta_changesList" items="{visualizationModel&gt;/commandCategories/}" itemSelected=".onCommandCategorySelection" class="sapUiRtaToolbarVisualizationSelection"><MenuItem id="sapUiRta_changesListItem" text="{visualizationModel&gt;title}" key="{visualizationModel&gt;key}" icon="{visualizationModel&gt;icon}" enabled="{= ${visualizationModel&gt;count} &gt; 0}"/></Menu></menu><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></MenuButton><Button id="sapUiRta_undo" icon="sap-icon://undo" press=".undo" enabled="{controls&gt;/undoEnabled}" visible="{= ${controls&gt;/modeSwitcher} === \'adaptation\'}" type="Transparent" tooltip="{i18n&gt;BTN_UNDO}"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></Button><Button id="sapUiRta_redo" icon="sap-icon://redo" press=".redo" enabled="{controls&gt;/redoEnabled}" visible="{= ${controls&gt;/modeSwitcher} === \'adaptation\'}" type="Transparent" tooltip="{i18n&gt;BTN_REDO}"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></Button><toolbar:OverflowToolbarButton id="sapUiRta_publish" enabled="{controls&gt;/publishEnabled}" visible="{= (${controls&gt;/publishVisible} &amp;&amp; ${controls&gt;/modeSwitcher} === \'adaptation\')}" press=".publish" type="Transparent" text="{i18n&gt;BTN_PUBLISH}"><toolbar:layoutData><OverflowToolbarLayoutData priority="High"/></toolbar:layoutData></toolbar:OverflowToolbarButton><toolbar:OverflowToolbarButton id="sapUiRta_restore" enabled="{controls&gt;/restoreEnabled}" visible="{= ((${path: \'versions&gt;/versioningEnabled\', formatter: \'.showRestore\'}) &amp;&amp; ((${controls&gt;/modeSwitcher} === \'visualization\') || (${controls&gt;/modeSwitcher} === \'adaptation\')))}" press=".restore" type="Transparent" text="{i18n&gt;BTN_RESTORE}"><toolbar:layoutData><OverflowToolbarLayoutData priority="High"/></toolbar:layoutData></toolbar:OverflowToolbarButton><toolbar:OverflowToolbarButton id="sapUiRta_manageApps" press=".manageApps" enabled="{controls&gt;/manageAppsEnabled}" visible="{= (${controls&gt;/manageAppsVisible} &amp;&amp; ${controls&gt;/modeSwitcher} === \'adaptation\')}" type="Transparent" text="{i18n&gt;BTN_MANAGE_APPS_TXT}"><toolbar:layoutData><OverflowToolbarLayoutData priority="Low"/></toolbar:layoutData></toolbar:OverflowToolbarButton><MenuButton id="sapUiRta_appVariantOverview" enabled="{controls&gt;/appVariantsOverviewEnabled}" visible="{= (${controls&gt;/appVariantsOverviewVisible} &amp;&amp; ${controls&gt;/modeSwitcher} === \'adaptation\')}" type="Transparent" text="{i18n&gt;BTN_MANAGE_APPS_TXT}"><menu><Menu itemSelected=".appVariantOverview" id="sapUiRta_appVariantMenu"><MenuItem id="sapUiRta_keyUser" text="{i18n&gt;MENU_ITEM_KEY_USER}"/><MenuItem id="sapUiRta_developer" text="{i18n&gt;MENU_ITEM_SAP_DEVELOPER}"/></Menu></menu><layoutData><OverflowToolbarLayoutData priority="Low"/></layoutData></MenuButton><toolbar:OverflowToolbarButton id="sapUiRta_saveAs" visible="{= (${controls&gt;/saveAsVisible} &amp;&amp; ${controls&gt;/modeSwitcher} === \'adaptation\')}" enabled="{controls&gt;/saveAsEnabled}" press=".saveAs" type="Transparent" text="{i18n&gt;BTN_SAVE_AS}"><toolbar:layoutData><OverflowToolbarLayoutData priority="Low"/></toolbar:layoutData></toolbar:OverflowToolbarButton></content></OverflowToolbar><Button id="sapUiRta_exit" type="Transparent" press=".exit" text="{i18n&gt;BTN_EXIT}"/><layoutData><FlexItemData growFactor="0"/></layoutData></HBox></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/VersionHistory.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core"><Popover class="sapUiRtaVersionHistory" showHeader="false" placement="Bottom"><List class="sapUiRtaVersionsList" visible="{path:\'versions&gt;/versions/length\',formatter:\'.formatVersionTableVisibility\'}" items="{versions&gt;/versions}"><FeedListItem text="{parts:[{path:\'versions&gt;title\'},{path:\'versions&gt;type\'}],formatter:\'.formatVersionTitle\'}" info="{versions&gt;activatedBy}" timestamp="{path:\'versions&gt;activatedAt\',formatter:\'.formatVersionTimeStamp\'}" type="Active" press=".versionSelected" highlight="{path:\'versions&gt;type\',formatter:\'.formatHighlight\'}" highlightText="{path:\'versions&gt;type\',formatter:\'.formatHighlightText\'}" showIcon="false"/></List><List><FeedListItem text="{i18n&gt;TIT_ORIGINAL_APP}" type="Active" press=".versionSelected" highlight="{path:\'versions&gt;/versions\',formatter:\'.formatOriginalAppHighlight\'}" highlightText="{path:\'versions&gt;/versions\',formatter:\'.formatOriginalAppHighlightText\'}" showIcon="false"/></List></Popover></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/VersionTitleDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core"><Dialog title="{i18n&gt;TIT_VERSION_TITLE_DIALOG}" type="Message"><content><Input id="sapUiRta_versionTitleInput" type="Text" maxLength="200" liveChange=".onVersionTitleLiveChange" submit=".onConfirmVersioningDialog" placeholder="{i18n&gt;TXT_VERSION_TITLE_INPUT_PLACEHOLDER}"/></content><beginButton><Button id="sapUiRta_confirmVersionTitleButton" text="{i18n&gt;BUT_VERSION_TITLE_DIALOG_CONFIRM}" type="Emphasized" enabled="false" press=".onConfirmVersioningDialog"/></beginButton><endButton><Button text="{i18n&gt;BUT_VERSION_TITLE_DIALOG_CANCEL}" press=".onCancelVersioningDialog"/></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/translation/DownloadTranslationDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core"><Dialog title="{i18n&gt;TIT_DOWNLOAD_CHANGED_TEXTS}" type="Message" contentWidth="33%"><Label wrappingType="Hyphenated" wrapping="true" width="auto" text="{i18n&gt;MSG_DOWNLOAD_CHANGED_TEXTS}"/><VBox width="100%"><ComboBox width="100%" value="{translation&gt;/sourceLanguage}" id="sapUiRta_selectSourceLanguage" placeholder="{i18n&gt;TXT_SOURCE_LANGUAGE}"/><ComboBox width="100%" id="sapUiRta_selectTargetLanguage" placeholder="{i18n&gt;TXT_TARGET_LANGUAGE}"/></VBox><beginButton><Button id="sapUiRta_downloadChangedTextsButton" text="{i18n&gt;BTN_DOWNLOAD_CHANGED_TEXTS}" type="Emphasized" enabled="{= ${translation&gt;/downloadChangedTexts}}" press=".onDownloadFile"/></beginButton><endButton><Button text="{i18n&gt;BUT_DOWNLOAD_CHANGED_TEXTS_CANCEL}" press=".onCancelDownloadDialog"/></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/translation/TranslationPopover.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core"><Popover showHeader="false" placement="Bottom"><List visible="true"><ActionListItem text="{i18n&gt;TXT_DOWNLOAD_CHANGED_TEXTS}" type="Active" press=".openDownloadTranslationDialog"/><ActionListItem text="{i18n&gt;TXT_UPLOAD_TRANSLATIONS}" type="Active" press=".openDownloadTranslationDialog"/></List></Popover></core:FragmentDefinition>',
	"sap/ui/rta/util/changeVisualization/ChangeIndicatorPopover.fragment.xml":'<core:FragmentDefinition xmlns:core="sap.ui.core" xmlns="sap.m" xmlns:l="sap.ui.layout"><Popover title="{= ${details&gt;/}.length &gt; 1 ? ${i18n&gt;TIT_CHANGEVISUALIZATION_CHANGES} : ${details&gt;/0/changeTitle}}" placement="PreferredTopOrFlip" class="sapUiRtaPopover"><Table items="{details&gt;/}" inset="false" fixedLayout="false" width="auto" visible="{= ${details&gt;/}.length &gt; 1}"><columns><Column width="auto"><Text text="{i18n&gt;TIT_CHANGEVISUALIZATION_CHANGE}"/></Column><Column width="auto"><Text text="{i18n&gt;TIT_CHANGEVISUALIZATION_DESCRIPTION}"/></Column><Column width="auto"><Text text="{i18n&gt;TIT_CHANGEVISUALIZATION_DATE}"/></Column><Column width="auto"><Text text="{i18n&gt;TIT_CHANGEVISUALIZATION_DETAILS}"/></Column></columns><items><ColumnListItem><cells><Text text="{details&gt;changeTitle}"/><Text text="{details&gt;description}"/><Text text="{details&gt;date}"/><Button visible="{details&gt;enableDetailButton}" icon="sap-icon://display" press="._showDependentElements"/></cells></ColumnListItem></items></Table><l:VerticalLayout visible="{= ${details&gt;/}.length === 1}"><Text text="{details&gt;/0/description}" class="sapUiTinyMargin"/><Text text="{details&gt;/0/date}" class="sapUiTinyMargin"/></l:VerticalLayout><footer><FlexBox direction="RowReverse" visible="{= ${details&gt;/}.length === 1}"><items><Button visible="{details&gt;/0/enableDetailButton}" text="{i18n&gt;TIT_CHANGEVISUALIZATION_DETAILS}" icon="sap-icon://display" press="._showDependentElements" class="sapUiTinyMargin"/></items></FlexBox></footer></Popover></core:FragmentDefinition>',
	"sap/ui/rta/view/RemoveElementDialog.fragment.xml":'<core:FragmentDefinition xmlns:core="sap.ui.core" xmlns:commons="sap.ui.commons" xmlns:layout="sap.ui.layout" xmlns:sap.m="sap.m"><sap.m:Dialog class="sapUiRtaConfirmationDialog" verticalScrolling="false" title="{/titleText}" icon="{/icon}"><layout:VerticalLayout width="100%"><commons:TextView class="sapUiRtaConfirmationDialogText" text="{/messageText}"/></layout:VerticalLayout><sap.m:beginButton><sap.m:Button class="sapUiRtaConfirmationDialogRemoveButton" text="{/removeText}" press="removeField"/></sap.m:beginButton><sap.m:endButton><sap.m:Button class="sapUiRtaConfirmationDialogCancelButton" text="{/cancelText}" press="closeDialog"/></sap.m:endButton></sap.m:Dialog></core:FragmentDefinition>',
	"sap/ui/rta/appVariant/manageApps/webapp/index.js":function(){sap.ui.require(["sap/m/Shell","sap/ui/core/ComponentContainer"],function(S,C){"use strict";sap.ui.getCore().attachInit(function(){new S({app:new C({height:"100%",name:"sap.ui.rta.appVariant.manageApps",settings:{id:"sap.ui.rta.appVariant.manageApps"}})}).placeAt("content");});});
}
},"sap/ui/rta/library-preload"
);
//# sourceMappingURL=library-preload.js.map