/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/restricted/_difference","sap/base/util/deepEqual","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Control","sap/ui/dt/OverlayRegistry","sap/ui/dt/ElementUtil","sap/ui/events/KeyCodes","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/model/resource/ResourceModel","sap/ui/model/json/JSONModel","sap/ui/rta/util/changeVisualization/ChangeIndicator","sap/ui/rta/util/changeVisualization/ChangeIndicatorRegistry"],function(d,a,J,C,O,E,K,b,c,P,L,F,R,e,f,g){"use strict";var V={add:["createContainer","addDelegateProperty","reveal","addIFrame"],move:["move"],rename:["rename"],combinesplit:["combine","split"],remove:["remove"]};var h="all";var i={all:"sap-icon://show",add:"sap-icon://add",move:"sap-icon://move",rename:"sap-icon://edit",combinesplit:"sap-icon://combine",remove:"sap-icon://less"};var j=C.extend("sap.ui.rta.util.changeVisualization.ChangeVisualization",{metadata:{library:"sap.ui.rta",properties:{rootControlId:{type:"string"},isActive:{type:"boolean",defaultValue:false}}},constructor:function(){C.prototype.constructor.apply(this,arguments);this._oChangeIndicatorRegistry=new g({commandCategories:V});this._oTextBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");this.setModel(new R({bundle:this._oTextBundle}),"i18n");this._oChangeVisualizationModel=new e({active:this.getIsActive()});this._oChangeVisualizationModel.setDefaultBindingMode("OneWay");this._sSelectedCommandCategory="all";this._bSetModeChanged=false;}});j.prototype.setRootControlId=function(r){if(this.getRootControlId()&&this.getRootControlId()!==r){this._reset();}this.setProperty("rootControlId",r);};j.prototype._getComponent=function(){return F.getAppComponentForControl(E.getElementInstance(this.getRootControlId()));};j.prototype.setIsActive=function(A){if(A===this.getIsActive()){return;}this.setProperty("isActive",A);if(this._oChangeVisualizationModel){this._updateVisualizationModel({active:A});}};j.prototype.exit=function(){this._oChangeIndicatorRegistry.destroy();};j.prototype._reset=function(){this._oChangeIndicatorRegistry.reset();};j.prototype._updateVisualizationModelMenuData=function(){var k=Object.keys(V).map(function(s){var t=this._getCommandCategoryLabel(s,this._getChangesForCommandCategory(s).length);return{key:s,count:this._getChangesForCommandCategory(s).length,title:t,icon:i[s]};}.bind(this));k.unshift({key:h,count:this._getChangesForCommandCategory(h).length,title:this._getCommandCategoryLabel(h,this._getChangesForCommandCategory(h).length),icon:i[h]});this._updateVisualizationModel({commandCategories:k});};j.prototype._getChangesForCommandCategory=function(s){var r=this._oChangeIndicatorRegistry.getChanges();return r.filter(function(o){return s===h?o.commandCategory!==undefined:s===o.commandCategory;});};j.prototype._getCommandCategoryLabel=function(s,k){var l="TXT_CHANGEVISUALIZATION_OVERVIEW_"+s.toUpperCase();return this._oTextBundle.getText(l,[k]);};j.prototype._getCommandCategoryButton=function(s){var B="BTN_CHANGEVISUALIZATION_OVERVIEW_"+s.toUpperCase();return this._oTextBundle.getText(B);};j.prototype.onCommandCategorySelection=function(o){var s=o.getParameter("item").getKey();return this._selectCommandCategory(s);};j.prototype._selectCommandCategory=function(s){this._sSelectedCommandCategory=s;var r=this._getChangesForCommandCategory(s);var k=this._getCommandCategoryButton(s);this._updateVisualizationModel({selectedChange:undefined,commandCategory:s,commandCategoryText:k});return Promise.all(r.map(function(o){return this._getVisualizationInfo(o).then(function(v){this._oChangeIndicatorRegistry.addVisualizationInfo(o.change.getId(),v);}.bind(this));}.bind(this))).then(function(){this._updateChangeIndicators();this._setFocusedIndicator();}.bind(this));};j.prototype._getVisualizationInfo=function(m){var o=this._getComponent();function k(s){if(!s){return undefined;}return s.map(function(S){var l=typeof S.getId==="function"?S:J.bySelector(S,o);return l&&l.getId();}).filter(Boolean);}return this._getInfoFromChangeHandler(o,m.change).then(function(I){var v=I||{};var A=(k(v.affectedControls||[m.change.getSelector()]));return{affectedElementIds:A,dependentElementIds:k(v.dependentControls)||[],displayElementIds:k(v.displayControls)||A,payload:v.payload};});};j.prototype._getCommandForChange=function(o){var s=o.getDefinition().support.command;if(s){return s;}var k=this._getComponent();var S=J.bySelector(o.getSelector(),k);var l=o.getDependentSelectorList().slice(-1)[0];var m=J.bySelector(l,k);function n(p,A){var q=p.getElement();var s=p.getDesignTimeMetadata().getCommandName(o.getChangeType(),q,A);if(s){return s;}var r=p.getParentElementOverlay();var t=p.getParentAggregationOverlay();if(p.getElement().getId()===S.getId()||!r){return undefined;}return n(r,t&&t.getAggregationName());}return S&&m&&n(O.getOverlay(m));};j.prototype._getInfoFromChangeHandler=function(A,o){var k=J.bySelector(o.getSelector(),A);if(k){var p={modifier:J,appComponent:A,view:F.getViewForControl(k)};var m=b.getControlIfTemplateAffected(o,k,p);return c.getChangeHandler({changeType:o.getChangeType(),element:m.control,modifier:J,layer:o.getLayer()}).then(function(l){if(l&&typeof l.getChangeVisualizationInfo==="function"){return l.getChangeVisualizationInfo(o,A);}return undefined;});}return Promise.resolve();};j.prototype._collectChanges=function(){var o=this._getComponent();var p={oComponent:o,selector:o,invalidateCache:false,includeVariants:true,currentLayer:L.CUSTOMER};return P._getUIChanges(p);};j.prototype._updateChangeRegistry=function(){return this._collectChanges().then(function(k){var r=this._oChangeIndicatorRegistry.getChangeIds();var o=k.reduce(function(m,n){m[n.getId()]=n;return m;},{});var l=Object.keys(o);d(r,l).forEach(function(s){this._oChangeIndicatorRegistry.removeChange(s);}.bind(this));d(l,r).forEach(function(s){var m=o[s];var n=this._getCommandForChange(m);this._oChangeIndicatorRegistry.registerChange(m,n);}.bind(this));}.bind(this));};j.prototype.selectChange=function(o){var s=o.getParameter("changeId");this._selectChange(s);};j.prototype._selectChange=function(s){this._updateVisualizationModel({selectedChange:s});this._updateChangeIndicators();};j.prototype._updateVisualizationModel=function(D){this._oChangeVisualizationModel.setData(Object.assign({},this._oChangeVisualizationModel.getData(),D));};j.prototype._updateChangeIndicators=function(){var s=this._oChangeIndicatorRegistry.getChangeIndicatorData();var I={};Object.keys(s).forEach(function(S){var k=s[S];var o=O.getOverlay(S);if(!o||!o.getDomRef()){return undefined;}var l=o.getDomRef().getClientRects()[0]||{left:0,top:0};I[S]={posX:parseInt(l.left),posY:parseInt(l.top),changes:this._filterRelevantChanges(k)};if(!this._oChangeIndicatorRegistry.hasChangeIndicator(S)){this._createChangeIndicator(o,S);}return undefined;}.bind(this));if(!a(I,this._oChangeVisualizationModel.getData().content)){this._updateVisualizationModel({content:I});}};j.prototype._filterRelevantChanges=function(k){if(!Array.isArray(k)){return k;}var r=this._oChangeVisualizationModel.getData();return k.filter(function(o){return((!r.selectedChange&&!o.dependent&&(r.commandCategory==='all'||r.commandCategory===o.commandCategory))||(!!r.selectedChange&&o.id===r.selectedChange));});};j.prototype._createChangeIndicator=function(o,s){var k=new f({changes:"{changes}",mode:{path:"changes",formatter:function(l){var S=this.getModel().getData().selectedChange;return(S&&(l||[]).some(function(m){return m.dependent;}))?"dependent":"change";}},posX:"{posX}",posY:"{posY}",visible:"{= ${/active} && (${changes} || []).length > 0}",overlayId:o.getId(),selectorId:s,selectChange:this.selectChange.bind(this),keyPress:this._onIndicatorKeyPress.bind(this)});k.setModel(this._oChangeVisualizationModel);k.bindElement("/content/"+s);k.setModel(this.getModel("i18n"),"i18n");k.placeAt(sap.ui.getCore().getStaticAreaRef());this._oChangeIndicatorRegistry.registerChangeIndicator(s,k);};j.prototype._onIndicatorKeyPress=function(o){var k=o.getParameter("originalEvent");var l=k.keyCode;var I=o.getSource();if(l===K.ARROW_UP||l===K.ARROW_LEFT||(l===K.TAB&&k.shiftKey)){k.stopPropagation();k.preventDefault();this._setFocusedIndicator(I,-1);}else if(l===K.ARROW_DOWN||l===K.ARROW_RIGHT||l===K.TAB){k.stopPropagation();k.preventDefault();this._setFocusedIndicator(I,1);}};j.prototype._setFocusedIndicator=function(s,D){var v=this._oChangeIndicatorRegistry.getChangeIndicators().filter(function(o){return o.getVisible();}).sort(function(o,k){var l=o.getPosY()-k.getPosY();var m=o.getPosX()-k.getPosX();return l||m;});if(v.length===0){return;}var I=s?(v.length+v.indexOf(s)+D)%v.length:0;v[I].focus();};j.prototype.triggerModeChange=function(r,t){if(this.getIsActive()){this.setIsActive(false);return;}if(!this.getRootControlId()){this.setRootControlId(r);}this.setIsActive(true);this._updateChangeRegistry().then(this._selectCommandCategory.bind(this,this._sSelectedCommandCategory)).then(function(){this._updateVisualizationModelMenuData();t.setModel(this._oChangeVisualizationModel,"visualizationModel");}.bind(this));};return j;});
