/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/Device','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/util/PasteHelper','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/Sorter','sap/ui/model/BindingMode','./Column','./Row','./library','./utils/TableUtils','./extensions/ExtensionBase','./extensions/Accessibility','./extensions/Keyboard','./extensions/Pointer','./extensions/Scrolling','./extensions/DragAndDrop',"./TableRenderer","./rowmodes/FixedRowMode","./rowmodes/InteractiveRowMode","./rowmodes/AutoRowMode","./plugins/SelectionModelSelection","sap/ui/thirdparty/jquery","sap/base/Log"],function(D,C,I,P,a,F,S,B,b,R,c,T,E,A,K,d,e,f,g,h,j,k,m,q,L){"use strict";var G=c.GroupEventType;var N=c.NavigationMode;var n=c.SelectionMode;var o=c.SelectionBehavior;var p=c.SortOrder;var V=c.VisibleRowCountMode;var H=T.Hook.Keys.Table;var _=T.createWeakMapFacade();var r=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",dnd:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:n.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:o.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1,deprecated:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar,deprecated:true},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false},rowActionCount:{type:"int",group:"Appearance",defaultValue:0},alternateRowColors:{type:"boolean",group:"Appearance",defaultValue:false},rowCountConstraints:{type:"object",visibility:"hidden"}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false,deprecated:true},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable",dnd:{layout:"Horizontal"}},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable",selector:"#{id}-tableCCnt",dnd:true},rowMode:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},creationRow:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},rowActionTemplate:{type:"sap.ui.table.RowAction",multiple:false},rowSettingsTemplate:{type:"sap.ui.table.RowSettings",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false},plugins:{type:"sap.ui.table.plugins.SelectionPlugin",multiple:true,singularName:"plugin"},_messageStrip:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_hiddenDependents:{type:"sap.ui.core.Element",multiple:true,visibility:"hidden"}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newVisible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}},deprecated:true},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{rowIndex:{type:"int"},columnIndex:{type:"int"},contextMenu:{type:"sap.ui.core.IContextMenu"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}},paste:{allowPreventDefault:true,parameters:{data:{type:"string[][]"}}},rowsUpdated:{}},designtime:"sap/ui/table/designtime/Table.designtime"}});I.insertFontFaceStyle();r.prototype.init=function(){this.mSkipPropagation={rowActionTemplate:true,rowSettingsTemplate:true};_(this).iCachedBindingLength=0;_(this).iFirstRenderedRowIndex=0;_(this).iComputedFixedColumnCount=null;this._attachExtensions();this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._bRowsBeingBound=false;this._bContextsAvailable=false;this._aRowClones=[];this._bRowAggregationInvalid=true;this._mTimeouts={};this._mAnimationFrames={};this._bHideStandardTooltips=false;this._aRowHeights=[];this._aSortedColumns=[];this._aTableHeaders=[];this._bAllowColumnHeaderTextSelection=false;_(this).iPendingRequests=0;this._iBindingLength=null;this._bFirstRendering=true;this._nDevicePixelRatio=window.devicePixelRatio;if(sap.ui.getCore().isThemeApplied()){T.readThemeParameters();}this._bInvalid=true;};r.prototype.applySettings=function(l,X){if(l){var Y=["rowMode","plugins"];var Z={};for(var i=0;i<Y.length;i++){var $=Y[i];if($ in l){Z[$]=l[$];delete l[$];}}if(Object.keys(Z).length>0){C.prototype.applySettings.call(this,Z,X);}}this._initLegacyRowMode();this._initLegacySelectionPlugin();C.prototype.applySettings.call(this,l,X);};r.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}E.enrich(this,d);E.enrich(this,e);E.enrich(this,K);E.enrich(this,A);E.enrich(this,f);if(D.os.ios){sap.ui.require(["sap/ui/table/extensions/ScrollingIOS"],function(i){if(!this.bIsDestroyed){E.enrich(this,i);}}.bind(this));}this._bExtensionsInitialized=true;};r.prototype.exit=function(){this.invalidateRowsAggregation();this._detachExtensions();this._cleanUpTimers();this._detachEvents();T.Menu.cleanupDefaultContentCellContextMenu(this);Q(this);delete this._aTableHeaders;};r.prototype._detachExtensions=function(){E.cleanup(this);};r.prototype.onpaste=function(i){if(i.isMarked()||/^(input|textarea)$/i.test(i.target.tagName)||!this.getDomRef("sapUiTableCnt").contains(i.target)){return;}var l=P.getPastedDataAs2DArray(i.originalEvent);if(l.length===0||l[0].length===0){return;}this.firePaste({data:l});};r.prototype.onThemeChanged=function(){T.readThemeParameters();if(this.getDomRef()){this.invalidate();}};r.prototype.onlocalizationChanged=function(i){var l=i.changes||{};var X=l.hasOwnProperty("rtl");var Y=l.hasOwnProperty("language");this._adaptLocalization(X,Y).then(function(){this.invalidate();}.bind(this)).catch(function(){});};r.prototype._adaptLocalization=function(i,l){if(!i&&!l){return Promise.reject();}var X=Promise.resolve();if(i){this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();}if(l){X=T.getResourceBundle({async:true,reload:true});}return X.then(function(){if(l){T.Menu.cleanupDefaultContentCellContextMenu(this);this._invalidateColumnMenus();}}.bind(this));};r.prototype._collectRowHeights=function(l){var X=this.getDomRef();if(!X){return[];}var Y=this._getBaseRowHeight();var Z=l?".sapUiTableColHdrTr":".sapUiTableTr";var $=X.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+Z);var a1=X.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+Z);var b1=l?T.getHeaderRowCount(this):this.getRows().length;var c1=[];var d1=D.browser.chrome&&window.devicePixelRatio!=1;if(l){if(this.getColumnHeaderHeight()>0){Y=this.getColumnHeaderHeight();}else if(this.getRowMode()){Y=this._getDefaultRowHeight();}}for(var i=0;i<b1;i++){var e1=$[i]?$[i].getBoundingClientRect().height:0;var f1=a1[i]?a1[i].getBoundingClientRect().height:0;var g1=Math.max(e1,f1);if(d1){var h1=Y-g1;if(h1>0&&h1<1){c1.push(Math.max(g1,Y-1));continue;}}c1.push(Math.max(g1,Y));}if(c1.length>0&&!l){T.dynamicCall(this._getSyncExtension,function(i1){var j1=i1.syncRowHeights(c1.slice());if(j1&&j1.length===c1.length){c1=j1.slice();}});}return c1;};r.prototype._resetRowHeights=function(){var l=this._getBaseRowHeight();var X="";if(l){X=l+"px";}var Y=this.getDomRef("tableCCnt");if(Y){var Z=Y.querySelectorAll(".sapUiTableTr");for(var i=0;i<Z.length;i++){Z[i].style.height=X;}}};r.prototype._resetColumnHeaderHeights=function(){var l=this.getDomRef();if(l){var X=l.querySelectorAll(".sapUiTableColHdrTr");for(var i=0;i<X.length;i++){X[i].style.height=null;}}};r.prototype._collectTableSizes=function(){var l={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0};var X=this.getDomRef();if(!X){return l;}var Y=X.querySelector(".sapUiTableCnt");if(Y){l.tableCntHeight=Y.clientHeight;l.tableCntWidth=Y.clientWidth;}var Z=X.querySelector(".sapUiTableCtrlScroll:not(.sapUiTableCHT)");if(Z){l.tableCtrlScrollWidth=Z.clientWidth;}var $=X.querySelector(".sapUiTableRowHdrScr");if($){l.tableRowHdrScrWidth=$.clientWidth;}var a1=X.querySelector(".sapUiTableCtrlScr:not(.sapUiTableCHA)");if(a1){l.tableCtrlScrWidth=a1.clientWidth;}var b1=X.querySelector(".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed");if(b1){l.tableCtrlFixedWidth=b1.clientWidth;}var c1=this._getSpanBasedComputedFixedColumnCount();var d1=0;if(c1){var e1=this.getColumns();var f1=X.querySelectorAll(".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th");for(var i=0;i<f1.length;i++){var g1=parseInt(f1[i].getAttribute("data-sap-ui-headcolindex"));if(!isNaN(g1)&&(g1<c1)){var h1=e1[g1];var i1;if(h1._iFixWidth!=null){i1=h1._iFixWidth;}else{i1=f1[i].getBoundingClientRect().width;}d1+=i1;}}}if(d1>0){var j1=this._getScrollExtension();var k1=l.tableRowHdrScrWidth;var l1=j1.getVerticalScrollbar();if(l1&&!j1.isVerticalScrollbarExternal()){k1+=l1.offsetWidth;}if(T.hasRowActions(this)){var m1=this.getDomRef("sapUiTableRowActionScr");if(m1){k1+=m1.offsetWidth;}}k1+=T.Column.getMinColumnWidth();var n1=l.tableCntWidth-k1;var o1=n1>d1;var p1=!o1;if(this._bIgnoreFixedColumnCount!==p1){this._bIgnoreFixedColumnCount=p1;if(this.getEnableColumnFreeze()){this._invalidateColumnMenus();}this.invalidate();}}return l;};r.prototype._updateRowHeights=function(i,l){var X=this.getDomRef();if(!X){return;}function Y(d1,e1){var f1=i[e1];if(f1){d1.style.height=f1+"px";}}var Z=l?".sapUiTableColHdrTr":".sapUiTableTr";var $=l?[]:X.querySelectorAll(".sapUiTableRowSelectionCell");var a1=l?[]:X.querySelectorAll(".sapUiTableRowActionCell");var b1=X.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+Z);var c1=X.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+Z);Array.prototype.forEach.call($,Y);Array.prototype.forEach.call(a1,Y);Array.prototype.forEach.call(b1,Y);Array.prototype.forEach.call(c1,Y);};r.prototype.onBeforeRendering=function(i){this._bInvalid=true;this._detachEvents();if(i&&i.isMarked("renderRows")){return;}this._cleanUpTimers();this.getBinding();this._aTableHeaders=[];};r.prototype.onAfterRendering=function(i){var l=i&&i.isMarked("renderRows");this._bInvalid=false;this._attachEvents();this._initRowDomRefs();if(!this._bAllowColumnHeaderTextSelection&&!l){this._disableTextSelection(this.$().find(".sapUiTableCHA"));}this.getDomRef().classList.remove("sapUiTableRActFlexible");if(!l){this._aTableHeaders=this.$().find(".sapUiTableColHdrCnt th");}this._updateTableSizes(T.RowsUpdateReason.Render,true);T.registerResizeHandler(this,"Table",this._onTableResize.bind(this));this._bFirstRendering=false;};r.prototype.invalidate=function(){this._bInvalid=true;T.Column.invalidateColumnUtils(this);return C.prototype.invalidate.call(this);};r.prototype._initRowDomRefs=function(){var l=this.getRows();for(var i=0;i<l.length;i++){l[i].initDomRefs();}};r.prototype._updateTableSizes=function(l,X){X=X===true;var Y=this.getDomRef();if(this._bInvalid||!Y||!sap.ui.getCore().isThemeApplied()||Y.offsetWidth===0){return;}if(!X){this._resetRowHeights();this._resetColumnHeaderHeights();}this._aRowHeights=this._collectRowHeights(false);var Z=this._collectRowHeights(true);function $(k1){var l1=k1.getDomRef();var m1=T.Column.getMinColumnWidth();var n1=[];var o1=k1.getColumnHeaderVisible();function p1(s1,t1){if(s1<=t1){return Math.max(s1,t1-5,m1)+"px";}return-1;}function q1(t1){var u1=Math.max(t1._minWidth||0,m1,t1.getMinWidth());var v1=t1.getWidth();var w1;var x1;var y1;if(T.isVariableWidth(v1)&&!T.isFixedColumn(k1,t1.getIndex())){w1=l1.querySelectorAll('th[data-sap-ui-colid="'+t1.getId()+'"]');x1=w1[o1?0:1];y1=x1?x1.offsetWidth:null;if(y1!==null){if(y1<=u1){return{headers:w1,newWidth:p1(y1,u1)};}else if(x1&&x1.style.width!=v1){n1.push({col:t1,header:x1,minWidth:u1,headers:w1});return{headers:w1,newWidth:v1};}n1.push({col:t1,header:x1,minWidth:u1,headers:w1});}}return null;}function r1(t1){if(t1){Array.prototype.forEach.call(t1.headers,function(u1){u1.style.width=t1.newWidth;});}}k1._getVisibleColumns().map(q1).forEach(r1);if(n1.length){var s1;for(var i=0;i<n1.length;i++){s1=n1[i].header&&n1[i].header.offsetWidth;n1[i].newWidth=p1(s1,n1[i].minWidth);if(parseInt(n1[i].newWidth)>=0){r1(n1[i]);}}}}$(this);var a1=this._collectTableSizes();this._updateRowHeights(this._aRowHeights,false);this._updateRowHeights(Z,true);T.dynamicCall(this._getSyncExtension,function(i){i.syncLayout({top:this.getDomRef("sapUiTableCnt").offsetTop,headerHeight:this.getDomRef().querySelector(".sapUiTableColHdrCnt").getBoundingClientRect().height,contentHeight:this.getDomRef("tableCCnt").getBoundingClientRect().height});},this);var b1=this.$();if(T.hasRowActions(this)||T.hasRowNavigationIndicators(this)){var c1=b1.hasClass("sapUiTableRActFlexible");var d1=this.getDomRef("dummycolhdr");if(d1){var e1=this.getDomRef("header");var f1=e1.clientWidth;var g1=this.getColumns().reduce(function(g1,i){if(i.getDomRef()&&i.getIndex()>=this.getComputedFixedColumnCount()){return g1+T.convertCSSSizeToPixel(i.getWidth());}return g1;}.bind(this),0);var h1=f1>g1+1;if(!c1&&h1){var i1=g1+a1.tableRowHdrScrWidth+a1.tableCtrlFixedWidth;var j1={};if(!T.hasRowActions(this)){i1=i1-T.ThemeParameters.navIndicatorWidth+T.BaseBorderWidth;}j1[this._bRtlMode?"right":"left"]=i1;this.$("sapUiTableRowActionScr").css(j1);this.$("rowacthdr").css(j1);b1.toggleClass("sapUiTableRActFlexible",true);}else if(c1&&!h1){this.$("sapUiTableRowActionScr").removeAttr("style");this.$("rowacthdr").removeAttr("style");b1.toggleClass("sapUiTableRActFlexible",false);}}}b1.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");T.Hook.call(this,H.UpdateSizes,l);};r.prototype.setShowOverlay=function(i){this.setProperty("showOverlay",i,true);if(this.getDomRef()){this.$().toggleClass("sapUiTableOverlay",this.getShowOverlay());this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus();}return this;};r.prototype._updateFixedBottomRows=function(){var i=this.getDomRef();if(!i||this._getRowCounts().fixedBottom===0){return;}var l=T.getFirstFixedBottomRowIndex(this);var X=this.getRows();var $;q(i).find(".sapUiTableRowLastScrollable").removeClass("sapUiTableRowLastScrollable");q(i).find(".sapUiTableRowFirstFixedBottom").removeClass("sapUiTableRowFirstFixedBottom");if(l>=0&&l<X.length){$=X[l].getDomRefs(true);$.row.addClass("sapUiTableRowFirstFixedBottom",true);}if(l>=1&&l<X.length){$=X[l-1].getDomRefs(true);$.row.addClass("sapUiTableRowLastScrollable",true);}};r.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return C.prototype.getFocusInfo.apply(this,arguments);}};r.prototype.applyFocusInfo=function(i){if(i&&i.customId){q(document.getElementById(i.customId)).trigger("focus");}else{C.prototype.applyFocusInfo.apply(this,arguments);}return this;};r.prototype.setTitle=function(i){var l=i;if(typeof(i)==="string"||i instanceof String){l=c.TableHelper.createTextView({text:i});l.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",l);return this;};r.prototype.setFooter=function(i){var l=i;if(typeof(i)==="string"||i instanceof String){l=c.TableHelper.createTextView({text:i});}this.setAggregation("footer",l);return this;};r.prototype.setSelectionMode=function(i){if(i===n.Multi){i=n.MultiToggle;L.warning("The selection mode 'Multi' is deprecated and must not be used anymore."+" Your setting was defaulted to selection mode 'MultiToggle'",this);}if(this._hasSelectionPlugin()){L.error("If a selection plugin is applied to the table, the selection mode is controlled by the plugin.",this);}else{this.setProperty("selectionMode",i);this._oLegacySelectionPlugin.setSelectionMode(i);}return this;};r.prototype.setFirstVisibleRow=function(i){if(i==null){i=0;}else if(i<0){L.error("The index of the first visible row must be greater than or equal to 0. The value has been set to 0.",this);i=0;}else if(this._bContextsAvailable){var l=this._getMaxFirstVisibleRowIndex();if(l<i){L.warning("The index of the first visible row is too high. The value has been set to "+l+".",this);i=l;}}this._setFirstVisibleRowIndex(i);return this;};r.prototype._setFirstVisibleRowIndex=function(i,l){l=Object.assign({onScroll:false,suppressScrolling:false,suppressEvent:false,forceEvent:false,suppressRendering:false,onlySetProperty:false},l);if(this._bContextsAvailable){i=Math.min(i,this._getMaxFirstVisibleRowIndex());}i=Math.max(0,i);var X=this.getFirstVisibleRow()!==i;var Y=this._getFirstRenderedRowIndex();var Z=this._bContextsAvailable?Math.min(i,this._getMaxFirstRenderedRowIndex()):i;var $=this._getScrollExtension();this.setProperty("firstVisibleRow",i,true);if(!l.suppressRendering){_(this).iFirstRenderedRowIndex=Z;}if(l.onlySetProperty){return false;}if((X||l.forceEvent)&&!l.suppressEvent){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}if(!this.getBinding()){$.updateVerticalScrollPosition();return false;}var a1=false;var b1=this.getBinding()!=null&&Z!==Y;if(b1){if(!l.suppressRendering){y(this,l.onScroll?T.RowsUpdateReason.VerticalScroll:T.RowsUpdateReason.FirstVisibleRowChange);a1=true;}if(!l.onScroll&&!l.suppressScrolling){$.updateVerticalScrollPosition(a1);}}else if(!l.onScroll&&!l.suppressScrolling){$.updateVerticalScrollPosition(!this._bContextsAvailable);}return a1;};r.prototype._setFocus=function(i,l){return new Promise(function(X){if(i===-1){i=this._getTotalRowCount()-1;}if(typeof i!=='number'||i<-1){i=0;}var Y=this.getFirstVisibleRow();var Z=this._getRowCounts().count;if(i>Y&&i<Y+Z){this.getRows()[i-Y]._setFocus(l);return X();}if(this._setFirstVisibleRowIndex(i)){this.attachEventOnce("rowsUpdated",function(){s(this,i,l);return X();});}else{s(this,i,l);return X();}}.bind(this));};function s(i,l,X){var Y=i._getTotalRowCount();var Z=i._getFirstRenderedRowIndex();i.getRows()[Math.min(l,Y-1)-Z]._setFocus(X);}r.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;r.prototype.bindAggregation=function(i,l){if(i==="rows"){this._bindRows(u(Array.prototype.slice.call(arguments,1)));return this;}return C.prototype.bindAggregation.apply(this,arguments);};r.prototype.bindRows=function(i){this._bindRows(u(arguments));return this;};r.prototype._bindRows=function(i){t(this);this._bRowsBeingBound=true;x(this);O(this);r._addBindingListener(i,"change",function(){this._onBindingChange.apply(this,arguments);}.bind(this));r._addBindingListener(i,"dataRequested",function(){this._onBindingDataRequested.apply(this,arguments);}.bind(this));r._addBindingListener(i,"dataReceived",function(){this._onBindingDataReceived.apply(this,arguments);}.bind(this));T.Hook.call(this,H.BindRows,i);C.prototype.bindAggregation.call(this,"rows",i);this._bRowsBeingBound=false;};r.prototype._bindAggregation=function(i,l){if(i==="rows"){t(this);this._bRowsBeingBound=true;}C.prototype._bindAggregation.call(this,i,l);if(i==="rows"){T.Grouping.setupExperimentalGrouping(this);var X=this.getBinding();var Y=X?X.getModel():null;this._bRowsBeingBound=false;T.Hook.call(this,H.RowsBound,X);if(Y&&Y.getDefaultBindingMode()===B.OneTime){L.error("The binding mode of the model is set to \"OneTime\"."+" This binding mode is not supported for the \"rows\" aggregation!"+" Scrolling can not be performed.",this);}}};r.prototype.unbindAggregation=function(i,l){if(i==="rows"){this._unbindRows();return this;}return C.prototype.unbindAggregation.apply(this,arguments);};r.prototype.unbindRows=function(){this._unbindRows();return this;};r.prototype._unbindRows=function(){var i=this.getBindingInfo("rows");if(i){T.Hook.call(this,H.UnbindRows,i);}C.prototype.unbindAggregation.call(this,"rows",true);if(this._bRowsBeingBound||this.bIsDestroyed||this._bIsBeingDestroyed){return;}this._adjustToTotalRowCount();if(i){T.Hook.call(this,H.RowsUnbound);}t(this);O(this);};function t(i){i._bRowsBeingBound=false;i._bContextsAvailable=false;_(i).iPendingRequests=0;i._iBindingLength=null;}function u(i){var l;if(i==null||i[0]==null){l={};}else if(typeof i[0]==="string"){var X=i[0];var Y=i[1];var Z=i[2];var $=i[3];if(Y instanceof S||Array.isArray(Z)&&Z[0]instanceof F){$=Z;Z=Y;Y=undefined;}l={path:X,sorter:Z,filters:$,template:Y};}else{l=i[0];}return l;}r._addBindingListener=function(i,l,X,Y){if(!i.events){i.events={};}var Z=i.events[l];i.events[l]=function(){X.apply(Y,arguments);if(Z){Z.apply(this,arguments);}};};r.prototype._onBindingChange=function(i){var l=i.getParameter("reason");if(l===a.Sort||l===a.Filter){this.setFirstVisibleRow(0);}};r.prototype.setRowMode=function(i){this._destroyLegacyRowMode();this.setAggregation("rowMode",i);this._initLegacyRowMode();};r.prototype.getRowMode=function(){return this.getAggregation("rowMode");};r.prototype._getRowMode=function(){var i=this.getRowMode()||this._oLegacyRowMode;if(!i){this._initLegacyRowMode();i=this._oLegacyRowMode;}return i;};r.prototype._initLegacyRowMode=function(){if(this._oLegacyRowMode||this.getRowMode()){return;}this._oLegacyRowMode=v(this);this.addAggregation("_hiddenDependents",this._oLegacyRowMode);};r.prototype._destroyLegacyRowMode=function(){if(this._oLegacyRowMode){this._oLegacyRowMode.destroy();delete this._oLegacyRowMode;}};function v(i){var l;switch(i.getVisibleRowCountMode()){case V.Fixed:l=new h(true);break;case V.Interactive:l=new j(true);break;case V.Auto:l=new k(true);break;default:}return l;}r.prototype._getRowCounts=function(){var i=this._getRowMode().getComputedRowCounts();var l=this._bVariableRowHeightEnabled&&!i.fixedTop&&!i.fixedBottom;i._fullsize=i.count;i._scrollSize=i.scrollable;if(i.count>0&&l){i.count++;i.scrollable++;}return i;};r.prototype.setVisibleRowCountMode=function(i){if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"visibleRowCountMode\" has no effect");return this.setProperty("visibleRowCountMode",i,true);}var l=this.getVisibleRowCountMode();this.setProperty("visibleRowCountMode",i);var X=this.getVisibleRowCountMode();if(X!==l){this._destroyLegacyRowMode();this._initLegacyRowMode();}return this;};r.prototype.setVisibleRowCount=function(i){var l=this.getVisibleRowCountMode();if(l==V.Auto){L.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}if(i!=null&&!isFinite(i)){return this;}var X=this.getFixedRowCount()+this.getFixedBottomRowCount();if(i<=X&&X>0){L.error("Table: "+this.getId()+" visibleRowCount('"+i+"') must be bigger than number of"+" fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"visibleRowCount\" has no effect");return this.setProperty("visibleRowCount",i,true);}i=this.validateProperty("visibleRowCount",i);this.setProperty("visibleRowCount",i);T.dynamicCall(this._getSyncExtension,function(Y){Y.syncRowCount(i);});return this;};r.prototype.setMinAutoRowCount=function(i){if(parseInt(i)<1){L.error("The minAutoRowCount property must be greater than 0. The value has been set to 1.",this);i=1;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"minAutoRowCount\" has no effect");return this.setProperty("minAutoRowCount",i,true);}return this.setProperty("minAutoRowCount",i);};r.prototype.setTooltip=function(i){L.warning("The aggregation tooltip is not supported for sap.ui.table.Table",this);return this.setAggregation("tooltip",i,true);};r.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);L.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);return this;};r.prototype._getFixedBottomRowContexts=function(){var i=this._getRowCounts();var l=M(this,true);if(i.fixedBottom>0&&i.count-i.fixedBottom<l){return this._getContexts(l-i.fixedBottom,i.fixedBottom,0,true);}else{return[];}};r.prototype._getFixedRowContexts=function(){var i=this._getRowCounts();if(i.fixedTop>0){return this._getContexts(0,i.fixedTop,0,true);}else{return[];}};r.prototype._getContexts=function(i,l,X,Y){var Z=this.getBinding();if(Z){return Z.getContexts(i,l,X,Y);}else{return[];}};r.prototype._getRowContexts=function(l,X,Y){var Z=this.getBinding();var $=this.getRows().length;var a1=this.getThreshold();l=l==null?$:l;a1=a1>0?Math.max(l,a1):0;l=Math.max(l,this._getRowMode().getMinRequestLength());if(!Z||l<=0){return[];}X=X===true;Y=Y===true;var b1=this._getFirstRenderedRowIndex();var c1=this._getRowCounts();var d1=[];var e1;var f1=l-c1.fixedBottom;var g1=0;var h1=f1;var i1=b1;var j1=function(m1,n1,i1){for(var i=0;i<n1.length;i++){m1[i1+i]=n1[i];}};if(c1.fixedTop>0&&b1>0){i1=b1+c1.fixedTop;f1-=c1.fixedTop;g1=c1.fixedTop;e1=this._getFixedRowContexts();d1=d1.concat(e1);}e1=this._getContexts(i1,f1,a1);if(!X){this._adjustToTotalRowCount();}var k1=this._getTotalRowCount();j1(d1,e1,g1);h1=Math.min(h1,Math.max(k1-c1.fixedBottom,0));if(c1.fixedBottom>0){e1=this._getFixedBottomRowContexts();j1(d1,e1,h1);}var l1=this._getMaxFirstRenderedRowIndex();if(l1<b1&&this._bContextsAvailable&&!Y){this._setFirstVisibleRowIndex(this.getFirstVisibleRow(),{onlySetProperty:true});d1=this._getRowContexts(l,X,true);}return d1;};r.prototype._adjustToTotalRowCount=function(){var i=this._getTotalRowCount();if(this._iBindingLength!==i){this._iBindingLength=i;this._updateFixedBottomRows();T.Hook.call(this,H.TotalRowCountChanged);}};r.prototype.refreshRows=function(i){this._bContextsAvailable=false;if(i===a.Sort||i===a.Filter){this.setFirstVisibleRow(0);}T.Hook.call(this,H.RefreshRows,i||T.RowsUpdateReason.Unknown);};r.prototype.updateRows=function(i,l){if(this.bIsDestroyed||this._bIsBeingDestroyed){return;}if(l.detailedReason==="AddVirtualContext"){w(this);return;}else if(l.detailedReason==="RemoveVirtualContext"){x(this);return;}this._bContextsAvailable=true;y(this,i);};function w(i){var l=i._getRowContexts(null,true)[0];x(i);i._oVirtualRow=i._getRowClone("virtual");i._oVirtualRow.setBindingContext(l,i.getBindingInfo("rows").model);i.addAggregation("_hiddenDependents",i._oVirtualRow);}function x(i){if(i._oVirtualRow){i._oVirtualRow.destroy();delete i._oVirtualRow;}}function y(i,l){if(i._bContextsAvailable){T.Hook.call(i,H.UpdateRows,l||T.RowsUpdateReason.Unknown);}}r.prototype.insertRow=function(){L.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);return this;};r.prototype.addRow=function(){L.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);return this;};r.prototype.removeRow=function(){L.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);return null;};r.prototype.removeAllRows=function(){L.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);return[];};r.prototype.destroyRows=function(){L.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);return this;};r.prototype.setCreationRow=function(i){if(!T.isA(i,"sap.ui.table.CreationRow")){i=null;}return this.setAggregation("creationRow",i);};r.prototype.getCreationRow=function(){return this.getAggregation("creationRow");};r.prototype.autoResizeColumn=function(i){this._getPointerExtension().doAutoResizeColumn(i);};r.prototype._attachEvents=function(){var $=this.$();var i=this.getId();if(sap.ui.getCore().getConfiguration().getAnimation()){q(document.body).on("webkitTransitionEnd."+i+" transitionend."+i,function(l){if(q(l.target).has($).length>0){this._updateTableSizes(T.RowsUpdateReason.Animation);}}.bind(this));}D.resize.attachHandler(this._onWindowResize,this);E.attachEvents(this);};r.prototype._detachEvents=function(){var i=this.getId();q(document.body).off('webkitTransitionEnd.'+i+' transitionend.'+i);T.deregisterResizeHandler(this,"Table");D.resize.detachHandler(this._onWindowResize,this);E.detachEvents(this);};r.prototype._cleanUpTimers=function(){var i;for(i in this._mTimeouts){if(this._mTimeouts[i]){window.clearTimeout(this._mTimeouts[i]);delete this._mTimeouts[i];}}for(i in this._mAnimationFrames){if(this._mAnimationFrames[i]){window.cancelAnimationFrame(this._mAnimationFrames[i]);delete this._mAnimationFrames[i];}}};function z(i){var l=i.getDomRef();if(l){i.getDomRef().classList.toggle("sapUiTableEmpty",T.isNoDataVisible(i));i._getAccExtension().updateAriaStateForOverlayAndNoData();i._getKeyboardExtension().updateNoDataAndOverlayFocus();}}r.prototype.removeColumn=function(i){i=this.removeAggregation("columns",i);if(i===null){return i;}if(!this._bReorderInProcess){var l=this._aSortedColumns.indexOf(i);if(l>=0){this._aSortedColumns.splice(l,1);}}J(this);return i;};r.prototype.removeAllColumns=function(){var i=this.removeAllAggregation("columns");this._aSortedColumns=[];J(this);return i;};r.prototype.destroyColumns=function(){var i=this.destroyAggregation("columns");this._aSortedColumns=[];J(this);return i;};r.prototype.addColumn=function(i){this.addAggregation("columns",i);J(this);return this;};r.prototype.insertColumn=function(i,l){this.insertAggregation("columns",i,l);J(this);return this;};function J(i){i.invalidateRowsAggregation();i._invalidateComputedFixedColumnCount();var l=i.getCreationRow();if(l){l._update();}}r.prototype._getTotalRowCount=function(){return M(this);};function M(i,l){var X=i.getBinding();var Y=i.getBindingInfo("rows");if(!X){return 0;}if(Y.length!=null){return Y.length;}if(l===true){return X.getLength();}if(!i._bContextsAvailable){return _(i).iCachedBindingLength;}_(i).iCachedBindingLength=X.getLength();return _(i).iCachedBindingLength;}r.prototype._getMaxFirstVisibleRowIndex=function(){var i;if(T.isVariableRowHeightEnabled(this)){i=this._getTotalRowCount()-1;}else{i=this._getTotalRowCount()-this._getRowCounts().count;}return Math.max(0,i);};r.prototype._getMaxFirstRenderedRowIndex=function(){var i=this._getTotalRowCount()-this._getRowCounts().count;return Math.max(0,i);};r.prototype._getFirstRenderedRowIndex=function(){return _(this).iFirstRenderedRowIndex;};r.prototype._getVisibleColumns=function(){var X=[];var Y=this.getColumns();for(var i=0,l=Y.length;i<l;i++){if(Y[i].shouldRender()){X.push(Y[i]);}}return X;};r.prototype._getColumnsWidth=function(X,Y){var Z=this.getColumns();var $=0;if(X!==0&&!X){X=0;}if(Y!==0&&!Y){Y=Z.length;}for(var i=X,l=Y;i<l;i++){if(Z[i]&&Z[i].shouldRender()){var a1=T.convertCSSSizeToPixel(Z[i].getWidth());if(a1==null){a1=T.Column.getMinColumnWidth();}$+=a1;}}return $;};r.prototype._onTableResize=function(i){var l=i.oldSize.width;var X=i.size.width;if(this._bInvalid||!this.getDomRef()||l===X){return;}this._updateTableSizes(T.RowsUpdateReason.Resize);};r.prototype._onWindowResize=function(){if(this._bInvalid||!this.getDomRef()){return;}if(D.browser.chrome&&window.devicePixelRatio!==this._nDevicePixelRatio){this._nDevicePixelRatio=window.devicePixelRatio;this._updateTableSizes(T.RowsUpdateReason.Zoom);this._adjustOutlineOffset();}};r.prototype._adjustOutlineOffset=function(){if(window.devicePixelRatio<1){this.addStyleClass("sapUiTableZoomout");}else{this.removeStyleClass("sapUiTableZoomout");}};r.prototype._disableTextSelection=function(i){q(i||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).on("selectstart",function(l){l.preventDefault();return false;});};r.prototype._enableTextSelection=function(i){q(i||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).off("selectstart");};r.prototype._findAndfireCellEvent=function(i,l,X){var $=q(l.target);var Y=$.closest(".sapUiTableDataCell");var Z=Y.attr("id");var a1=/.*-row(\d*)-col(\d*)/i.exec(Z);var b1=false;if(a1){var c1=a1[1];var d1=a1[2];var e1=this.getRows()[c1];var f1=e1&&e1.getCells()[d1];var g1=e1&&e1.getIndex();var h1=b.ofCell(f1).getId();var i1=e1.getRowBindingContext();var j1={rowIndex:g1,columnIndex:d1,columnId:h1,cellControl:f1,rowBindingContext:i1,cellDomRef:Y.get(0)};b1=!i.call(this,j1);if(!b1&&typeof X==="function"){j1.cellDomRef=Y[0];b1=X.call(this,j1);}}return b1;};r.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();if(this.getShowOverlay()){return this.getDomRef("overlay");}if(T.isNoDataVisible(this)){return this.getDomRef("noDataCnt");}var i=T.getFocusedItemInfo(this);if(i&&i.domRef){return i.domRef;}return C.prototype.getFocusDomRef.apply(this,arguments);};r.prototype.pushSortedColumn=function(i,l){if(!l){this._aSortedColumns=[];}if(this._aSortedColumns.indexOf(i)===-1){this._aSortedColumns.push(i);}};r.prototype.getSortedColumns=function(){return this._aSortedColumns.slice();};r.prototype.sort=function(l,X,Y){if(!l){for(var i=0;i<this._aSortedColumns.length;i++){this._aSortedColumns[i].setSorted(false);}var Z=this.getBinding();if(Z){Z.sort();}this._aSortedColumns=[];}if(this.getColumns().indexOf(l)>=0){l.sort(X===p.Descending,Y);}};r.prototype.filter=function(i,l){if(this.getColumns().indexOf(i)>=0){if(l==null){l="";}else if(typeof l!=="string"){throw new Error("The filter value is not a string");}i.filter(l);}};r.prototype._updateSelection=function(){var l=this.getSelectionMode();if(l===n.None){return;}var X=this._getSelectionPlugin().getRenderConfig();var Y;var Z;var $=this.$("selall");var a1=this.getRows();for(var i=0;i<a1.length;i++){var b1=a1[i];b1._updateSelection();}if(!X.headerSelector.visible){return;}if(X.headerSelector.type==="toggle"){var c1=T.areAllRowsSelected(this);$.toggleClass("sapUiTableSelAll",!c1);this._getAccExtension().setSelectAllState(c1);Y=c1?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";}else if(X.headerSelector.type==="clear"){$.toggleClass("sapUiTableSelAllDisabled",!X.headerSelector.enabled);Y="TBL_DESELECT_ALL";if(X.headerSelector.enabled){$.removeAttr("aria-disabled");}else{$.attr("aria-disabled","true");}}if(Y){Z=T.getResourceText(Y);if(this._getShowStandardTooltips()){$.attr('title',Z);}else if(X.headerSelector.type==="toggle"){this.getDomRef("ariaselectall").innerText=Z;}}};r.prototype._getShowStandardTooltips=function(){return!this._bHideStandardTooltips;};r.prototype._onSelectionChanged=function(i){var l=this._getSelectionPlugin();var X=i.getParameter("rowIndices");var Y=i.getParameter("selectAll");var Z=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:l.getSelectedIndex();this._updateSelection();if(!this._hasSelectionPlugin()){this.setProperty("selectedIndex",l.getSelectedIndex(),true);this.fireRowSelectionChange({rowIndex:Z,rowContext:this.getContextByIndex(Z),rowIndices:X,selectAll:Y,userInteraction:this._iSourceRowIndex!==undefined});}};r.prototype.getContextByIndex=function(i){var l=this.getBinding();return i>=0&&l?l.getContexts(i,1,0,true)[0]:null;};r.prototype.getSelectedIndex=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndex must not be called if a selection plugin is applied.");}return this._getSelectionPlugin().getSelectedIndex();};r.prototype.setSelectedIndex=function(i){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectedIndex must not be called if a selection plugin is applied.");}this._getSelectionPlugin().setSelectedIndex(i);return this;};r.prototype.clearSelection=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#clearSelection must not be called if a selection plugin is applied.");}this._getSelectionPlugin().clearSelection();return this;};r.prototype.selectAll=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#selectAll must not be called if a selection plugin is applied.");}if(T.hasSelectAll(this)){this._getSelectionPlugin().selectAll();}return this;};r.prototype.getSelectedIndices=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndices must not be called if a selection plugin is applied.");}return this._getSelectionPlugin().getSelectedIndices();};r.prototype.addSelectionInterval=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#addSelectionInterval must not be called if a selection plugin is applied.");}this._getSelectionPlugin().addSelectionInterval(i,l);return this;};r.prototype.setSelectionInterval=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectionInterval must not be called if a selection plugin is applied.");}this._getSelectionPlugin().setSelectionInterval(i,l);return this;};r.prototype.removeSelectionInterval=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#removeSelectionInterval must not be called if a selection plugin is applied.");}this._getSelectionPlugin().removeSelectionInterval(i,l);return this;};r.prototype.isIndexSelected=function(i){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#isIndexSelected must not be called if a selection plugin is applied.");}return this._getSelectionPlugin().isIndexSelected(i);};r.prototype.setGroupBy=function(i){var l=i;var X=sap.ui.getCore().byId(this.getGroupBy());if(typeof l==="string"){l=sap.ui.getCore().byId(l);}var Y=false;if(l instanceof b&&l!==X){if(this.getColumns().indexOf(l)===-1){throw new Error("Column has to be part of the columns aggregation!");}var Z=this.fireGroup({column:l,groupedColumns:[l.getId()],type:G.group});if(X){X.setGrouped(false);Y=true;}if(Z&&this.getEnableGrouping()){l.setGrouped(true);}}if(!l||Y){if(X){X.setGrouped(false);}T.Grouping.resetExperimentalGrouping(this);}this.setAssociation("groupBy",l);T.Grouping.setupExperimentalGrouping(this);return this;};r.prototype.getBinding=function(i){return C.prototype.getBinding.call(this,i==null?"rows":i);};r.prototype.setEnableGrouping=function(i){var l=sap.ui.getCore().byId(this.getGroupBy());this.setProperty("enableGrouping",i);if(l){l.setGrouped(i);}if(i){T.Grouping.setupExperimentalGrouping(this);}else{T.Grouping.resetExperimentalGrouping(this);}this._invalidateColumnMenus();return this;};r.prototype.setEnableCustomFilter=function(i){this.setProperty("enableCustomFilter",i);this._invalidateColumnMenus();return this;};r.prototype.setEnableColumnFreeze=function(i){this.setProperty("enableColumnFreeze",i);this._invalidateColumnMenus();return this;};r.prototype.setShowColumnVisibilityMenu=function(i){this.setProperty("showColumnVisibilityMenu",i);this._invalidateColumnMenus();return this;};r.prototype.getComputedFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}return this._getSpanBasedComputedFixedColumnCount();};r.prototype._getSpanBasedComputedFixedColumnCount=function(){if(_(this).iComputedFixedColumnCount===null){var l=this.getColumns();var X;var Y=this.getFixedColumnCount();for(var i=Y-1;i>=0;i--){X=l[i];if(X){Y=Math.max(Y,X.getIndex()+T.Column.getHeaderSpan(X));break;}}_(this).iComputedFixedColumnCount=Math.min(Y,l.length);}return _(this).iComputedFixedColumnCount;};r.prototype.setFixedColumnCount=function(l){this.setProperty("fixedColumnCount",l);this._invalidateComputedFixedColumnCount();var X=this.getColumns();var Y;var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(var i=this._getSpanBasedComputedFixedColumnCount()-1;i>=0;i--){Y=X[i];if(Y&&T.isVariableWidth(Y.getWidth())){Y._iFixWidth=$.filter("[data-sap-ui-headcolindex='"+Y.getIndex()+"']").width();}}this._collectTableSizes();if(this.getEnableColumnFreeze()){this._invalidateColumnMenus();}return this;};r.prototype.setFixedRowCount=function(i){if(!(parseInt(i)>=0)){L.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())>=this.getVisibleRowCount()){L.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"fixedRowCount\" has no effect");return this.setProperty("fixedRowCount",i,true);}return this.setProperty("fixedRowCount",i);};r.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i)>=0)){L.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())>=this.getVisibleRowCount()){L.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"iFixedBottomRowCount\" has no effect");return this.setProperty("fixedBottomRowCount",i,true);}return this.setProperty("fixedBottomRowCount",i);};r.prototype.setThreshold=function(i){this.setProperty("threshold",i,true);return this;};r.prototype._invalidateColumnMenus=function(){var X=this.getColumns();for(var i=0,l=X.length;i<l;i++){X[i].invalidateMenu();}};r.prototype._isTouchEvent=function(i){return!!(i&&i.originalEvent&&i.originalEvent.touches);};r.prototype._getRowClone=function(X){var Y=typeof X==="number";var Z=Y;var $=Z?this._aRowClones[X]:null;if($&&!$.bIsDestroyed){return $;}$=new R(this.getId()+"-rows"+"-row"+(Y?X:"-"+X));if(Z){this._aRowClones[X]=$;}var a1=this.getColumns();for(var i=0,l=a1.length;i<l;i++){if(a1[i].getVisible()){var b1=a1[i].getTemplateClone(i);if(b1){$.addCell(b1);}}}if(T.hasRowActions(this)){var c1=this.getRowActionTemplate().clone();$.setAggregation("_rowAction",c1,true);}var d1=this.getRowSettingsTemplate();if(d1){var e1=d1.clone();$.setAggregation("_settings",e1,true);}return $;};r.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=true;};r.prototype._invalidateComputedFixedColumnCount=function(){_(this).iComputedFixedColumnCount=null;};r.prototype._getBaseRowHeight=function(){var i=this._getRowMode().getBaseRowContentHeight();if(i>0){return i+T.RowHorizontalFrameSize;}else{return this._getDefaultRowHeight();}};r.prototype._getDefaultRowHeight=function(){var i=T.getContentDensity(this);return T.DefaultRowHeight[i];};r.prototype._getDefaultRowContentHeight=function(){var i=T.getContentDensity(this);return T.BaseSize[i];};r.prototype.setNoData=function(i){var l=T.getNoDataText(this);this.setAggregation("noData",i,true);var X=T.getNoDataText(this);if(l!=null&&X!=null){if(l!==X){this.$("noDataMsg").text(X);}}else{this.invalidate();}return this;};r.prototype.exportData=function(X){var Y=sap.ui.requireSync("sap/ui/core/util/Export");X=X||{};if(!X.rows){var Z=this.getBinding(),$=this.getBindingInfo("rows");var a1=Z.aFilters.concat(Z.aApplicationFilters);X.rows={path:$.path,model:$.model,sorter:Z.aSorters,filters:a1,parameters:$.parameters};}if(!X.exportType){var b1=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");X.exportType=new b1();}var c1=X.rows.model;if(!c1){var d1=X.rows.path;var e1=d1.indexOf(">");if(e1>0){c1=d1.substr(0,e1);}}if(!X.columns){X.columns=[];var f1=this.getColumns();for(var i=0,l=f1.length;i<l;i++){var g1=f1[i];if(g1.getSortProperty()){X.columns.push({name:g1.getLabel().getText(),template:{content:{path:g1.getSortProperty(),model:c1}}});}}}var h1=new Y(X);this.addDependent(h1);return h1;};r.prototype._onPersoApplied=function(){var X=this.getColumns();var Y=[];for(var i=0,l=X.length;i<l;i++){var Z=X[i];if(Z.getSorted()){Y.push(new S(Z.getSortProperty(),Z.getSortOrder()===p.Descending));}}var $=this.getBinding();if($){if(Y.length>0){$.sort(Y);}}};r.prototype._toggleSelectAll=function(){if(!T.hasData(this)||this.getSelectionMode()!==n.MultiToggle){return;}var i=this._getSelectionPlugin();if(T.areAllRowsSelected(this)){this._iSourceRowIndex=-1;i.clearSelection();}else{this._iSourceRowIndex=0;i.selectAll();}this._iSourceRowIndex=undefined;};r.prototype.setBusy=function(i){var l=this.getBusy();var X=C.prototype.setBusy.call(this,i,"sapUiTableGridCnt");var Y=this.getBusy();if(l!==Y){this.fireBusyStateChanged({busy:Y});}return X;};r.prototype.setEnableBusyIndicator=function(i){this.setProperty("enableBusyIndicator",i,true);if(this.getEnableBusyIndicator()){O(this);}else{this.setBusy(false);Q(this);}return this;};r.prototype._onBindingDataRequested=function(){_(this).iPendingRequests++;O(this);};r.prototype._onBindingDataReceived=function(){_(this).iPendingRequests--;O(this);};r.prototype._hasPendingRequests=function(){return _(this).iPendingRequests>0;};function O(i){if(!i.getEnableBusyIndicator()){return;}Q(i);if(i._hasPendingRequests()){i.setBusy(true);}else{_(i).hideBusyIndicatorTimeoutId=setTimeout(function(){i.setBusy(false);Q(i);},0);}}function Q(i){clearTimeout(_(i).hideBusyIndicatorTimeoutId);delete _(i).hideBusyIndicatorTimeoutId;}r.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};r.prototype.setRowActionTemplate=function(i){this.setAggregation("rowActionTemplate",i);this.invalidateRowsAggregation();return this;};r.prototype.setRowActionCount=function(i){if(typeof i==="number"){i=Math.max(0,Math.min(i,2));}return this.setProperty("rowActionCount",i);};r.prototype.setRowSettingsTemplate=function(i){this.setAggregation("rowSettingsTemplate",i);this.invalidateRowsAggregation();return this;};r.prototype.addPlugin=function(i){this.addAggregation("plugins",i);if(T.isA(i,"sap.ui.table.plugins.SelectionPlugin")){this._initSelectionPlugin();}return this;};r.prototype.insertPlugin=function(i,l){this.insertAggregation("plugins",i,l);if(T.isA(i,"sap.ui.table.plugins.SelectionPlugin")){this._initSelectionPlugin();}return this;};r.prototype.removePlugin=function(i){var l=this.removeAggregation("plugins",i);if(T.isA(l,"sap.ui.table.plugins.SelectionPlugin")){this._initSelectionPlugin();}return l;};r.prototype.removeAllPlugins=function(){var i=this.removeAllAggregation("plugins");this._initSelectionPlugin();return i;};r.prototype.destroyPlugins=function(){this.destroyAggregation('plugins');this._initSelectionPlugin();return this;};r.prototype.getPlugin=function(l){if(typeof l!=="string"){return null;}var X=this.getPlugins();for(var i=0;i<X.length;i++){if(X[i].isA(l)){return X[i];}}return null;};r.prototype._getSelectionPlugin=function(){var i=this._oSelectionPlugin||this._oLegacySelectionPlugin;if(!i){this._initLegacySelectionPlugin();i=this._oLegacySelectionPlugin;}if(typeof this._getSelectedIndicesCount==="function"&&i.getSelectedCount!==this._getSelectedIndicesCount){i.getSelectedCount=this._getSelectedIndicesCount;["isIndexSelected","setSelectedIndex","getSelectedIndex","getSelectedIndices","setSelectionInterval","addSelectionInterval","removeSelectionInterval","selectAll","clearSelection"].forEach(function(l){i[l]=this[l];}.bind(this));}return i;};r.prototype._hasSelectionPlugin=function(){return this._oSelectionPlugin!=null;};r.prototype._initSelectionPlugin=function(){var i=this.getPlugin("sap.ui.table.plugins.SelectionPlugin");if(i){this._destroyLegacySelectionPlugin();if(i!==this._oSelectionPlugin){W(this,this._oSelectionPlugin);U(this,i);this._oSelectionPlugin=i;}}else{this._initLegacySelectionPlugin();W(this,this._oSelectionPlugin);delete this._oSelectionPlugin;}};r.prototype._initLegacySelectionPlugin=function(){if(this._oLegacySelectionPlugin||this.getPlugin("sap.ui.table.plugins.SelectionPlugin")){return;}this._oLegacySelectionPlugin=this._createLegacySelectionPlugin();this.addAggregation("_hiddenDependents",this._oLegacySelectionPlugin);U(this,this._oLegacySelectionPlugin);};r.prototype._destroyLegacySelectionPlugin=function(){if(this._oLegacySelectionPlugin){this._oLegacySelectionPlugin.destroy();delete this._oLegacySelectionPlugin;}};r.prototype._createLegacySelectionPlugin=function(){return new m();};function U(i,l){if(l&&l.getMetadata().hasEvent("selectionChange")){l.attachSelectionChange(i._onSelectionChanged,i);}}function W(i,l){if(l&&l.getMetadata().hasEvent("selectionChange")){l.detachSelectionChange(i._onSelectionChanged,i);}}r.prototype.insertAggregation=function(i,l,X,Y){if(i==="_hiddenDependents"){return C.prototype.insertAggregation.call(this,i,l,X,true);}return C.prototype.insertAggregation.apply(this,arguments);};r.prototype.addAggregation=function(i,l,X){if(i==="_hiddenDependents"){return C.prototype.addAggregation.call(this,i,l,true);}return C.prototype.addAggregation.apply(this,arguments);};r.prototype.removeAggregation=function(i,l,X){if(i==="_hiddenDependents"){return C.prototype.removeAggregation.call(this,i,l,true);}return C.prototype.removeAggregation.apply(this,arguments);};r.prototype.removeAllAggregation=function(i,l){if(i==="_hiddenDependents"){return C.prototype.removeAllAggregation.call(this,i,true);}return C.prototype.removeAllAggregation.apply(this,arguments);};r.prototype.destroyAggregation=function(i,l){if(i==="_hiddenDependents"){return C.prototype.destroyAggregation.call(this,i,true);}C.prototype.destroyAggregation.apply(this,arguments);if(i==="rows"){this._aRowClones.forEach(function(X){X.destroy();});this._aRowClones=[];}return this;};r.prototype.getCellControl=function(i,l,X){var Y=T.getRowColCell(this,i,l,!X);return Y.cell;};r.prototype._fireRowsUpdated=function(i){var l={reason:i||T.RowsUpdateReason.Unknown};this.onRowsUpdated(l);clearTimeout(this._mTimeouts.fireRowsUpdated);this._mTimeouts.fireRowsUpdated=setTimeout(function(){this.onRowsContentUpdated(l);this.fireEvent("_rowsUpdated",l);this.fireRowsUpdated();}.bind(this),0);};r.prototype.onRowsUpdated=function(i){T.Grouping.updateGroups(this);this._getAccExtension()._updateAriaRowIndices();this._updateSelection();z(this);this.getRows().forEach(function(l){l.getCells().forEach(function(X){var Y=b.ofCell(X);var Z=Y._getCellContentVisibilitySettings();var $=l.getDomRefs(true).row.find("td[data-sap-ui-colid=\""+Y.getId()+"\"]");var a1=true;if(!$){return;}if(l.isGroupHeader()){if(!l.isExpandable()){a1=Z.groupHeader.nonExpandable;}else if(l.isExpanded()){a1=Z.groupHeader.expanded;}else{a1=Z.groupHeader.collapsed;}}else if(l.isTotalSummary()){a1=Z.summary.total;}else if(l.isGroupSummary()){a1=Z.summary.group;}else{a1=Z.standard;}$.toggleClass("sapUiTableCellHidden",!a1);});});};r.prototype.onRowsContentUpdated=function(i){if(this.getRows().length>0){this._resetRowHeights();this._aRowHeights=this._collectRowHeights(false);this._updateRowHeights(this._aRowHeights,false);this._getAccExtension().updateAccForCurrentCell(i.reason);}};r.prototype._enableSynchronization=function(){var i=this;return new Promise(function(l,X){sap.ui.require(["sap/ui/table/extensions/Synchronization"],function(Y){l(E.enrich(i,Y).getInterface());},function(Y){X(Y);});});};r.prototype._enableLegacyMultiSelection=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#_enableLegacyMultiSelection must not be called"+" if a selection plugin is applied.");}this._legacyMultiSelection=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: The legacy multi selection is not supported if a selection plugin is applied");}var X=!!(l.metaKey||l.ctrlKey);if(!this.isIndexSelected(i)){if(X){this.addSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}else if(X||this._getSelectionPlugin().getSelectedCount()===1){this.removeSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}.bind(this);};r.prototype._setRowCountConstraints=function(i){this.setProperty("rowCountConstraints",i);};return r;});
