/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/Device","../library","sap/base/Log"],function(D,l,L){"use strict";var C={TableUtils:null,initColumnUtils:function(t){if(!t._oColumnInfo){C.updateColumnInfo(t,C.collectColumnInfo(t));}},invalidateColumnUtils:function(t){t._oColumnInfo=null;},updateColumnInfo:function(t,c){t._oColumnInfo=c;},collectColumnInfo:function(t){return{columnCount:t.getColumns().length,visibleColumnCount:C.TableUtils.getVisibleColumnCount(t),columnMap:C.getColumnMap(t)};},getColumnMap:function(t){var i;var c;var o={};var a={};var b=t.getColumns();var m=C.TableUtils.getHeaderRowCount(t);var p={};for(var d=0;d<b.length;d++){c=b[d];o={};o.id=c.getId();o.column=c;o.levelInfo=[];o.parents=[];for(var e=0;e<m;e++){o.levelInfo[e]={};o.levelInfo[e].spannedColumns=[];var h=C.getHeaderSpan(c,e);for(i=1;i<h;i++){var s=b[d+i];if(s){var P=s.getId();o.levelInfo[e].spannedColumns.push(b[d+i]);if(!p[P]){p[P]=[];}p[P].push({column:c,level:e});}}}a[o.id]=o;}var f=Object.keys(p);for(i=0;i<f.length;i++){var g=f[i];a[g].parents=p[g];}return a;},getColumnMapItem:function(t,c){C.initColumnUtils(t);var s=t._oColumnInfo.columnMap[c];if(!s){L.error("Column with ID '"+c+"' not found",t);}else{return s;}},getParentSpannedColumns:function(t,c,a){var o=C.getColumnMapItem(t,c);if(!o){return undefined;}var p=[];for(var i=0;i<o.parents.length;i++){var P=o.parents[i];if(a===undefined||P.level===a){p.push(P);}}return p;},getChildrenSpannedColumns:function(t,c,a){var o=C.getColumnMapItem(t,c);if(!o){return undefined;}var b=[];var e;if(a===undefined){e=o.levelInfo.length;}else{e=a+1;}for(var i=a||0;i<e;i++){var d=o.levelInfo[i];for(var j=0;j<d.spannedColumns.length;j++){b.push({column:d.spannedColumns[j],level:i});}}return b;},getHeaderSpan:function(c,i){var h=c.getHeaderSpan();var H;if(!h){return 1;}if(!Array.isArray(h)){h=(h+"").split(",");}function g(s){var r=parseInt(s);return isNaN(r)?1:r;}if(isNaN(i)){H=Math.max.apply(null,h.map(g));}else{H=g(h[i]);}return Math.max(H,1);},getMaxHeaderSpan:function(c){return C.getHeaderSpan(c);},hasHeaderSpan:function(c){return C.getHeaderSpan(c)>1;},getColumnBoundaries:function(t,c){var o=C.getColumnMapItem(t,c);if(!o){return undefined;}var m={};if(c){m[c]=o.column;}var T=function(m,n){var e;var i;var f=[];n=n||[];for(i=0;i<n.length;i++){e=m[n[i]];f=f.concat(C.getParentSpannedColumns(t,e.getId()));f=f.concat(C.getChildrenSpannedColumns(t,e.getId()));}n=[];for(i=0;i<f.length;i++){e=f[i].column;var c=e.getId();if(!m[c]){n.push(c);m[c]=e;}}if(n.length>0){return T(m,n);}else{return m;}};m=T(m,[c]);var a=t.indexOfColumn(o.column);var b={startColumn:o.column,startIndex:a,endColumn:o.column,endIndex:-1};var d=t.getColumns();var k=Object.getOwnPropertyNames(m);for(var i=0;i<k.length;i++){var e=m[k[i]];a=t.indexOfColumn(e);var h=C.getMaxHeaderSpan(e);if(a<b.startIndex){b.startIndex=a;b.startColumn=e;}var E=a+h-1;if(E>b.endIndex){b.endIndex=E;b.endColumn=d[E];}}return b;},isColumnMovable:function(c){var t=c.getParent();if(!t||!t.getEnableColumnReordering()){return false;}var i=t.indexOfColumn(c);if(i<t.getComputedFixedColumnCount()||i<t._iFirstReorderableIndex){return false;}if(C.hasHeaderSpan(c)||C.getParentSpannedColumns(t,c.getId()).length!=0){return false;}return true;},normalizeColumnMoveTargetIndex:function(c,n){var t=c.getParent(),i=t.indexOfColumn(c),a=t.getColumns();if(n>i){n--;}if(n<0){n=0;}else if(n>a.length){n=a.length;}return n;},isColumnMovableTo:function(c,n){var t=c.getParent();if(!t||n===undefined||!C.isColumnMovable(c)){return false;}n=C.normalizeColumnMoveTargetIndex(c,n);if(n<t.getComputedFixedColumnCount()||n<t._iFirstReorderableIndex){return false;}var i=t.indexOfColumn(c),a=t.getColumns();if(n>i){var b=a[n>=a.length?a.length-1:n];var T=C.getColumnBoundaries(t,b.getId());if(C.hasHeaderSpan(b)||T.endIndex>n){return false;}}else{var A=a[n];if(C.getParentSpannedColumns(t,A.getId()).length!=0){return false;}}return true;},moveColumnTo:function(c,n){if(!C.isColumnMovableTo(c,n)){return false;}var t=c.getParent(),i=t.indexOfColumn(c);if(n===i){return false;}n=C.normalizeColumnMoveTargetIndex(c,n);var e=t.fireColumnMove({column:c,newPos:n});if(!e){return false;}t._bReorderInProcess=true;t.removeColumn(c,true);t.insertColumn(c,n);t._bReorderInProcess=false;return true;},getMinColumnWidth:function(){if(this._iColMinWidth){return this._iColMinWidth;}this._iColMinWidth=48;if(!D.system.desktop){this._iColMinWidth=88;}return this._iColMinWidth;},resizeColumn:function(t,c,w,f,a){if(!t||c==null||c<0||w==null||w<=0){return false;}if(a==null||a<=0){a=1;}if(f==null){f=true;}var b=t.getColumns();if(c>=b.length||!b[c].getVisible()){return false;}var v=[];for(var i=c;i<b.length;i++){var o=b[i];if(o.getVisible()){v.push(o);if(v.length===a){break;}}}var r=[];for(var i=0;i<v.length;i++){var V=v[i];if(V.getResizable()){r.push(V);}}if(r.length===0){return false;}var s=0;for(var i=0;i<v.length;i++){var V=v[i];s+=C.getColumnWidth(t,V.getIndex());}var p=w-s;var S=Math.round(p/r.length);var R=false;var T=t.getDomRef();if(!C.TableUtils.isFixedColumn(t,c)){t._getVisibleColumns().forEach(function(k){var m=k.getWidth(),q;if(T&&r.indexOf(k)<0&&C.TableUtils.isVariableWidth(m)){q=T.querySelector("th[data-sap-ui-colid=\""+k.getId()+"\"]");if(q){k._minWidth=Math.max(q.offsetWidth,C.getMinColumnWidth());}}});}for(var i=0;i<r.length;i++){var d=r[i];var e=C.getColumnWidth(t,d.getIndex());var n=e+S;var g=C.getMinColumnWidth();if(n<g){n=g;}var W=n-e;if(Math.abs(W)<Math.abs(S)){var h=r.length-(i+1);p-=W;S=Math.round(p/h);}if(W!==0){var E=true;var j=n+"px";if(f){E=t.fireColumnResize({column:d,width:j});}if(E){d.setWidth(j);R=true;}}}return R;},getColumnWidth:function(t,c){if(!t||c==null||c<0){return null;}var a=t.getColumns();if(c>=a.length){return null;}var o=a[c];var s=o.getWidth();if(s===""||s==="auto"||s.match(/%$/)){if(o.getVisible()){var b=o.getDomRef();return b?b.offsetWidth:0;}else{return 0;}}else{return C.TableUtils.convertCSSSizeToPixel(s);}},getHeaderText:function(t,c){if(!t||c==null||c<0){return null;}var a=t.getColumns();if(c>=a.length){return null;}function g(b){return b&&b.getText&&b.getText()||"";}var o=a[c];var T=o.getName();if(!T){var m=o.getMultiLabels();for(var i=m.length-1;i>=0;i--){var s=g(m[i]);if(C.getHeaderSpan(o,i)===1&&s){T=s;break;}}}if(!T){T=g(o.getLabel());}return T;}};return C;},true);
