/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/Popover","sap/ui/core/Core",'sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/TimesRow','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library','sap/ui/core/format/DateFormat','sap/ui/Device','sap/ui/core/Locale','sap/ui/core/library',"./CalendarTimeIntervalRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/ui/core/Popup","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/unified/DateRange","sap/ui/unified/Calendar"],function(P,C,a,L,b,H,T,D,M,Y,U,l,c,d,e,f,g,h,i,j,k,q,m,n){"use strict";var o=a.extend("sap.ui.unified.CalendarTimeInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},_currentPicker:{type:"string",group:"Appearance",defaultValue:"timesRow",visibility:"hidden"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},timesRow:{type:"sap.ui.unified.calendar.TimesRow",multiple:false,visibility:"hidden"},datesRow:{type:"sap.ui.unified.calendar.Month",multiple:false,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});var p={TIMES_ROW:"timesRow",DATES_ROW:"datesRow",MONTH_PICKER:"monthPicker",YEAR_PICKER:"yearPicker"};o.prototype.init=function(){this._iMode=0;this._oYearFormat=c.getDateInstance({format:"y"});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new U(new Date(Date.UTC(1,0,1)));this._oMinDate.getJSDate().setUTCFullYear(1);this._oMaxDate=new U(new Date(Date.UTC(9999,11,31,23,59,59)));this._initializeHeader();this._initializeTimesRow();this._initializeMonthPicker();this._initializeYearPicker();this.setPickerPopup(false);this._iItemsHead=15;};o.prototype._initializeHeader=function(){var c1=new H(this.getId()+"--Head");c1.attachEvent("pressPrevious",this._handlePrevious,this);c1.attachEvent("pressNext",this._handleNext,this);this.setAggregation("header",c1);};o.prototype._initializeTimesRow=function(){var c1=new T(this.getId()+"--TimesRow");c1.attachEvent("focus",N,this);c1.attachEvent("select",K,this);c1._bNoThemeChange=true;this.setAggregation("timesRow",c1);};o.prototype._initializeMonthPicker=function(){var c1=this._createMonthPicker();this.setAggregation("monthPicker",c1);c1._setSelectedDatesControlOrigin(this);};o.prototype._initializeYearPicker=function(){var c1=this._createYearPicker();this.setAggregation("yearPicker",c1);c1._setSelectedDatesControlOrigin(this);};o.prototype._createDatesRow=function(){var c1=new D(this.getId()+"--DatesRow",{days:18,selectedDates:[new m(this.getId()+"--Range")]});c1.attachEvent("focus",R,this);c1.attachEvent("select",Q,this);c1._bNoThemeChange=true;c1.getIntervalSelection=function(){return this.getProperty("intervalSelection");};c1.getSingleSelection=function(){return this.getProperty("singleSelection");};c1.getSelectedDates=function(){return this.getAggregation("selectedDates",[]);};c1.getSpecialDates=function(){return this.getAggregation("specialDates",[]);};c1.getAriaLabelledBy=function(){return this.getAssociation("ariaLabelledBy",[]);};return c1;};o.prototype._createMonthPicker=function(){var c1=new M(this.getId()+"--MP",{columns:0,months:6});c1.attachEvent("select",S,this);c1._bNoThemeChange=true;c1.attachEvent("pageChange",a1,this);return c1;};o.prototype._createYearPicker=function(){var c1=new Y(this.getId()+"--YP",{columns:0,years:6});c1.attachEvent("select",V,this);c1.attachEvent("pageChange",b1,this);c1._oMinDate.setYear(this._oMinDate.getUTCFullYear());c1._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());return c1;};o.prototype.exit=function(){if(this._oPopup){this._oPopup.destroy();this._oPopup=null;}if(this._oCalendar){this._oCalendar.removeDelegate(this._oFocusCalendarDelegate);this._oCalendar.destroy();this._oCalendar=null;}if(this._sInvalidateContent){clearTimeout(this._sInvalidateContent);}};o.prototype.onBeforeRendering=function(){var c1=this.getAggregation("timesRow");var d1=this._getFocusedDate();y.call(this);c1.displayDate(b._createLocalDate(d1,true));};o.prototype._setAriaRole=function(c1){var d1=this.getAggregation("timesRow");d1._setAriaRole(c1);d1.invalidate();return this;};o.prototype._getCalendar=function(){var c1;if(!this._oCalendar){c1=new n(this.getId()+"--Cal",{});c1.setPopupMode(true);c1.attachEvent("select",O,this);c1.attachEvent("cancel",function(d1){this._oPopup.close();var e1=this.getAggregation("header").getDomRef("B1");if(e1){e1.focus();}},this);this._oFocusCalendarDelegate={onAfterRendering:function(){this.focus();}};c1.addDelegate(this._oFocusCalendarDelegate,c1);this._oCalendar=c1;}return this._oCalendar;};o.prototype._getMonthPicker=function(){return this.getAggregation("monthPicker");};o.prototype._getYearPicker=function(){return this.getAggregation("yearPicker");};o.prototype.setStartDate=function(c1){b._checkJSDateObject(c1);if(i(this.getStartDate(),c1)){return this;}var d1=c1.getFullYear();b._checkYearInValidRange(d1);var e1=this.getMinDate();if(e1&&c1.getTime()<e1.getTime()){k.warning("startDate < minDate -> minDate as startDate set",this);c1=new Date(e1);}var f1=this.getMaxDate();if(f1&&c1.getTime()>f1.getTime()){k.warning("startDate > maxDate -> maxDate as startDate set",this);c1=new Date(f1);}this.setProperty("startDate",c1);var g1=this.getAggregation("timesRow");g1.setStartDate(c1);this._oUTCStartDate=new U(g1._getStartDate().getTime());y.call(this);var h1=b._createLocalDate(this._getFocusedDate(),true);if(!g1.checkDateFocusable(h1)){this._setFocusedDate(this._oUTCStartDate);g1.displayDate(c1);}return this;};o.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var c1=this.removeAllAggregation("selectedDates");return c1;};o.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var c1=this.destroyAggregation("selectedDates");return c1;};o.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var c1=this.removeAllAggregation("specialDates");return c1;};o.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var c1=this.destroyAggregation("specialDates");return c1;};o.prototype.setIntervalMinutes=function(c1){if(c1>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%c1>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",c1);var d1=this.getAggregation("timesRow");var e1=b._createLocalDate(this._getFocusedDate(),true);if(!d1.checkDateFocusable(e1)){var f1=r.call(this);this._setFocusedDate(f1);d1.setDate(b._createLocalDate(f1,true));}return this;};o.prototype.setLocale=function(c1){if(this._sLocale!=c1){this._sLocale=c1;this._oLocaleData=undefined;this.invalidate();}return this;};o.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=C.getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};o.prototype._getFocusedDate=function(){if(!this._oFocusedDate){t.call(this);}return this._oFocusedDate;};o.prototype._setFocusedDate=function(c1){if(!(c1 instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}this._oFocusedDate=new U(c1.getTime());};o.prototype.focusDate=function(c1){var d1=false;var e1=this.getAggregation("timesRow");if(!e1.checkDateFocusable(c1)){var f1=b._createUniversalUTCDate(c1,undefined,true);W.call(this,f1);d1=true;}F.call(this,c1,false);if(d1){this.fireStartDateChange();}return this;};o.prototype.displayDate=function(c1){F.call(this,c1,true);return this;};o.prototype.setItems=function(c1){this.setProperty("items",c1);c1=this._getItems();var d1=this.getAggregation("timesRow");d1.setItems(c1);var e1=b._createLocalDate(this._getFocusedDate(),true);if(!d1.checkDateFocusable(e1)){var f1=r.call(this);this._setFocusedDate(f1);d1.setDate(b._createLocalDate(f1,true));}if(!this.getPickerPopup()){var g1=this.getAggregation("datesRow");var h1=Math.floor(c1*1.5);if(h1>31){h1=31;}g1.setDays(h1);var i1=this._getMonthPicker();var j1=Math.floor(c1/2);if(j1>12){j1=12;}i1.setMonths(j1);var k1=this._getYearPicker();var l1=Math.floor(c1/2);if(l1>20){l1=20;}k1.setYears(l1);}y.call(this);return this;};o.prototype._getItems=function(){var c1=this.getItems();if(d.system.phone&&c1>6){return 6;}else{return c1;}};o.prototype._getLocaleData=function(){if(!this._oLocaleData){var c1=this.getLocale();var d1=new e(c1);this._oLocaleData=L.getInstance(d1);}return this._oLocaleData;};o.prototype.setPickerPopup=function(c1){var d1=this.getAggregation("header"),e1,f1,g1;this.setProperty("pickerPopup",c1);if(e1){e1.destroy();}if(c1){d1.setVisibleButton0(false);d1.setVisibleButton1(true);d1.setVisibleButton2(false);d1.detachEvent("pressButton1",I,this);d1.attachEvent("pressButton1",I,this);if(this.getAggregation("datesRow")){this.getAggregation("datesRow").destroy();}if(this._getMonthPicker()){this._getMonthPicker().destroy();}if(this._getYearPicker()){this._getYearPicker().destroy();}}else{d1.setVisibleButton0(true);d1.setVisibleButton1(true);d1.setVisibleButton2(true);d1.detachEvent("pressButton0",G,this);d1.attachEvent("pressButton0",G,this);d1.detachEvent("pressButton1",I,this);d1.attachEvent("pressButton1",I,this);d1.detachEvent("pressButton2",J,this);d1.attachEvent("pressButton2",J,this);if(!this.getAggregation("datesRow")){this.setAggregation("datesRow",this._createDatesRow());}if(!this._getYearPicker()){this.setAggregation("yearPicker",this._createYearPicker());}if(!this._getMonthPicker()){this.setAggregation("monthPicker",this._createMonthPicker());}f1=this._getMonthPicker();g1=this._getYearPicker();f1.setColumns(0);f1.setMonths(6);g1.setColumns(0);g1.setYears(6);}return this;};o.prototype.setMinDate=function(c1){var d1,e1,f1,g1;if(i(c1,this.getMinDate())){return this;}if(!c1){b._updateUTCDate(this._oMinDate.getJSDate(),1,0,1,0,0,0,0);}else{b._checkJSDateObject(c1);this._oMinDate=b._createUniversalUTCDate(c1,undefined,true);d1=this.getAggregation("timesRow");this._oMinDate=d1._getIntervalStart(this._oMinDate);e1=this._oMinDate.getUTCFullYear();b._checkYearInValidRange(e1);if(this._oMaxDate.getTime()<this._oMinDate.getTime()){k.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=b._createUniversalUTCDate(c1,undefined,true);b._updateUTCDate(this._oMaxDate,null,this._oMaxDate.getUTCMonth()+1,0,23,59,59,0);this.setProperty("maxDate",b._createLocalDate(this._oMaxDate,true));}if(this._oFocusedDate){if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){k.warning("focused date < minDate -> minDate focused",this);this.focusDate(c1);}}if(this._oUTCStartDate&&this._oUTCStartDate.getTime()<this._oMinDate.getTime()){k.warning("start date < minDate -> minDate set as start date",this);_.call(this,new U(this._oMinDate.getTime()),true,true);}}this.setProperty("minDate",c1);if(this.getPickerPopup()){g1=this._getCalendar();g1.setMinDate(c1);}else{f1=this._getYearPicker();f1._oMinDate.setYear(this._oMinDate.getUTCFullYear());}return this;};o.prototype.setMaxDate=function(c1){var d1,e1,f1,g1,h1,i1;if(i(c1,this.getMaxDate())){return this;}if(!c1){b._updateUTCDate(this._oMaxDate.getJSDate(),9999,11,31,23,59,59,0);}else{b._checkJSDateObject(c1);this._oMaxDate=b._createUniversalUTCDate(c1,undefined,true);d1=this.getAggregation("timesRow");this._oMaxDate=d1._getIntervalStart(this._oMaxDate);this._oMaxDate.setUTCMinutes(this._oMaxDate.getUTCMinutes()+this.getIntervalMinutes());this._oMaxDate.setUTCMilliseconds(-1);e1=this._oMaxDate.getUTCFullYear();b._checkYearInValidRange(e1);if(this._oMinDate.getTime()>this._oMaxDate.getTime()){k.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=b._createUniversalUTCDate(c1,undefined,true);b._updateUTCDate(this._oMinDate,null,null,1,0,0,0,0);this.setProperty("minDate",b._createLocalDate(this._oMinDate,true));}if(this._oFocusedDate){if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){k.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(c1);}}if(this._oUTCStartDate){f1=new U(this._oUTCStartDate.getTime());f1.setUTCMinutes(f1.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));if(f1.getTime()>this._oMaxDate.getTime()){g1=new U(this._oMaxDate.getTime());g1.setUTCMinutes(g1.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(g1.getTime()>=this._oMinDate.getTime()){k.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,g1,true,true);}}}}this.setProperty("maxDate",c1);if(this.getPickerPopup()){i1=this._getCalendar();i1.setMaxDate(c1);}else{h1=this._getYearPicker();h1._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());}return this;};o.prototype.onclick=function(c1){if(c1.isMarked("delayedMouseEvent")){return;}if(c1.target.id==this.getId()+"-cancel"){this.onsapescape(c1);}};o.prototype.onmousedown=function(c1){c1.preventDefault();c1.setMark("cancelAutoClose");};o.prototype.onsapescape=function(c1){if(this.getPickerPopup()){u.call(this);this.fireCancel();}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:case 2:case 3:this.setProperty("_currentPicker",p.TIMES_ROW);break;}}};o.prototype.onsaptabnext=function(c1){var d1=this.getAggregation("header"),e1,f1,g1;if(h(this.getDomRef("content"),c1.target)){if(this.getPickerPopup()&&d1.getDomRef("B1")){d1.getDomRef("B1").focus();}else if(!this.getPickerPopup()&&d1.getDomRef("B0")){d1.getDomRef("B0").focus();}if(!this._bPoupupMode){g1=this.getAggregation("timesRow");q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){e1=this._getMonthPicker();f1=this._getYearPicker();if(e1.getDomRef()){q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(f1.getDomRef()){q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}c1.preventDefault();}else if(c1.target.id==d1.getId()+"-B0"){if(d1.getDomRef("B1")){d1.getDomRef("B1").focus();}c1.preventDefault();}else if(!this.getPickerPopup()&&(c1.target.id==d1.getId()+"-B1")){if(d1.getDomRef("B2")){d1.getDomRef("B2").focus();}c1.preventDefault();}};o.prototype.onsaptabprevious=function(c1){var d1=this.getAggregation("header"),e1,f1,g1;if(h(this.getDomRef("content"),c1.target)){if(this._bPoupupMode){if(d1.getDomRef("B2")){d1.getDomRef("B2").focus();}c1.preventDefault();}}else if(c1.target.id==d1.getId()+"-B0"){g1=this.getAggregation("timesRow");switch(this._iMode){case 0:g1._oItemNavigation.focusItem(g1._oItemNavigation.getFocusedIndex());break;case 2:if(!this.getPickerPopup()){e1=this._getMonthPicker();e1._oItemNavigation.focusItem(e1._oItemNavigation.getFocusedIndex());}break;case 3:if(!this.getPickerPopup()){f1=this._getYearPicker();f1._oItemNavigation.focusItem(f1._oItemNavigation.getFocusedIndex());}break;}c1.preventDefault();}else if(c1.target.id==d1.getId()+"-B2"){if(d1.getDomRef("B1")){d1.getDomRef("B1").focus();}c1.preventDefault();}else if(c1.target.id==d1.getId()+"-B1"){if(!this.getPickerPopup()){if(d1.getDomRef("B0")){d1.getDomRef("B0").focus();}}else{g1=this.getAggregation("timesRow");g1._oItemNavigation.focusItem(g1._oItemNavigation.getFocusedIndex());}c1.preventDefault();}};o.prototype.onfocusin=function(c1){if(c1.target.id==this.getId()+"-end"){var d1=this.getAggregation("header"),e1,f1,g1;if(this.getPickerPopup()&&d1.getDomRef("B1")){d1.getDomRef("B1").focus();}else if(!this.getPickerPopup()&&d1.getDomRef("B2")){d1.getDomRef("B2").focus();}if(!this._bPoupupMode){e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){f1=this._getMonthPicker();g1=this._getYearPicker();if(f1.getDomRef()){q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(g1.getDomRef()){q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};o.prototype.onsapfocusleave=function(c1){if(!c1.relatedControlId||!h(this.getDomRef(),sap.ui.getCore().byId(c1.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var d1,e1,f1;switch(this._iMode){case 0:d1=this.getAggregation("timesRow");q(d1._oItemNavigation.getItemDomRefs()[d1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 2:if(!this.getPickerPopup()){e1=this._getMonthPicker();q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 3:if(!this.getPickerPopup()){f1=this._getYearPicker();q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};o.prototype.setProperty=function(){var c1=arguments[0],d1=arguments[1];a.prototype.setProperty.apply(this,arguments);if(c1==="_currentPicker"){switch(d1){case"timesRow":this._iMode=0;break;case"datesRow":this._iMode=1;break;case"monthPicker":this._iMode=2;break;case"yearPicker":this._iMode=3;break;default:return;}}return this;};o.prototype._handlePrevious=function(c1){var d1=this._getFocusedDate(),e1,f1,g1,h1,i1,j1,k1,l1;switch(this._iMode){case 0:e1=this._getItems();f1=new U(r.call(this).getTime());g1=this.getIntervalMinutes();f1.setUTCMinutes(f1.getUTCMinutes()-e1*g1);d1.setUTCMinutes(d1.getUTCMinutes()-e1*g1);this._setFocusedDate(d1);_.call(this,f1,true);break;case 1:if(!this.getPickerPopup()){h1=this.getAggregation("datesRow");i1=b._createUniversalUTCDate(h1.getDate());j1=h1.getDays();if(i1.getUTCDate()<=j1){i1.setUTCDate(1);}else{i1.setUTCDate(i1.getUTCDate()-j1);}X.call(this,i1);}break;case 2:if(!this.getPickerPopup()){k1=this._getMonthPicker();if(k1.getMonths()<12){k1.previousPage();z.call(this);}else{d1.setUTCFullYear(d1.getUTCFullYear()-1);W.call(this,d1);this._setFocusedDate(d1);y.call(this);$.call(this,d1.getUTCFullYear(),k1);this.fireStartDateChange();}}break;case 3:if(!this.getPickerPopup()){l1=this._getYearPicker();l1.previousPage();A.call(this);}break;}};o.prototype._handleNext=function(c1){var d1=this._getFocusedDate();switch(this._iMode){case 0:var e1=this._getItems();var f1=new U(r.call(this).getTime());var g1=this.getIntervalMinutes();f1.setUTCMinutes(f1.getUTCMinutes()+e1*g1);d1.setUTCMinutes(d1.getUTCMinutes()+e1*g1);this._setFocusedDate(d1);_.call(this,f1,true);break;case 1:if(!this.getPickerPopup()){var h1=this.getAggregation("datesRow");var i1=b._createUniversalUTCDate(h1.getDate());var j1=new U(i1.getTime());j1.setUTCDate(1);j1.setUTCMonth(j1.getUTCMonth()+1);j1.setUTCDate(0);var k1=h1.getDays();if(i1.getUTCDate()+k1>j1.getUTCDate()){i1.setUTCDate(j1.getUTCDate());}else{i1.setUTCDate(i1.getUTCDate()+k1);}X.call(this,i1);}break;case 2:if(!this.getPickerPopup()){var l1=this._getMonthPicker();if(l1.getMonths()<12){l1.nextPage();z.call(this);}else{d1.setUTCFullYear(d1.getUTCFullYear()+1);W.call(this,d1);this._setFocusedDate(d1);y.call(this);$.call(this,d1.getUTCFullYear(),l1);this.fireStartDateChange();}}break;case 3:if(!this.getPickerPopup()){var m1=this._getYearPicker();m1.nextPage();A.call(this);}break;}};o.prototype._getShowItemHeader=function(){var c1=this.getItems();if(c1>this._iItemsHead){return true;}else{return false;}};function _(c1,d1,e1){var f1=new U(this._oMaxDate.getTime());f1.setUTCMinutes(f1.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(f1.getTime()<this._oMinDate.getTime()){f1=new U(this._oMinDate.getTime());f1.setUTCMinutes(f1.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));}if(c1.getTime()<this._oMinDate.getTime()){c1=new U(this._oMinDate.getTime());}else if(c1.getTime()>f1.getTime()){c1=f1;}var g1=this.getAggregation("timesRow");var h1=b._createLocalDate(c1,true);g1.setStartDate(h1);this._oUTCStartDate=new U(g1._getStartDate().getTime());h1=b._createLocalDate(this._oUTCStartDate,true);this.setProperty("startDate",h1);y.call(this);if(d1){var i1=b._createLocalDate(this._getFocusedDate(),true);if(!g1.checkDateFocusable(i1)){this._setFocusedDate(c1);g1.setDate(h1);}else{g1.setDate(i1);}}if(!e1){this.fireStartDateChange();}}function r(){if(!this._oUTCStartDate){var c1=this.getAggregation("timesRow");c1.setStartDate(b._createLocalDate(this._getFocusedDate(),true));this._oUTCStartDate=new U(c1._getStartDate().getTime());this._setFocusedDate(this._oUTCStartDate);}return this._oUTCStartDate;}function s(c1){var d1=this._getFocusedDate();var e1=this.getAggregation("timesRow");if(!c1){e1.setDate(b._createLocalDate(d1,true));}else{e1.displayDate(b._createLocalDate(d1,true));}y.call(this);}function t(){var c1=this.getSelectedDates();if(c1&&c1[0]&&c1[0].getStartDate()){this._oFocusedDate=b._createUniversalUTCDate(c1[0].getStartDate(),undefined,true);}else{var d1=new Date();this._oFocusedDate=b._createUniversalUTCDate(d1,undefined,true);}if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){this._oFocusedDate=new U(this._oMinDate.getTime());}else if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){this._oFocusedDate=new U(this._oMaxDate.getTime());}}o.prototype._showCalendarPicker=function(){var c1=b._createLocalDate(this._getFocusedDate(),true);var d1=this._getCalendar();var e1=new m({startDate:c1});d1.displayDate(c1,false);d1.removeAllSelectedDates();d1.addSelectedDate(e1);d1.setMinDate(this.getMinDate());d1.setMaxDate(this.getMaxDate());Z.call(this,d1);this._showOverlay();};o.prototype._showOverlay=function(){this.$("contentOver").css("display","");};o.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};function u(c1){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!c1){s.call(this);var d1=this.getAggregation("timesRow");q(d1._oItemNavigation.getItemDomRefs()[d1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}this._getCalendar()._closePickers();}function v(){var c1=this._getFocusedDate();var d1=this._getItems();var e1=this.getAggregation("datesRow");var f1=e1.getSelectedDates()[0];f1.setStartDate(b._createLocalDate(c1,true));var g1=new U(c1.getTime());g1.setUTCDate(1);g1.setUTCMonth(g1.getUTCMonth()+1);g1.setUTCDate(0);var h1=g1.getUTCDate();var i1=Math.floor(d1*1.5);if(i1>h1){i1=h1;}e1.setDays(i1);this.setProperty("_currentPicker",p.DATES_ROW);this._showOverlay();X.call(this,c1);if(this._iMode==0){var j1=this.getAggregation("timesRow");q(j1._oItemNavigation.getItemDomRefs()[j1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=1;}function w(){var c1=this._getFocusedDate();var d1=this._getMonthPicker();this.setProperty("_currentPicker",p.MONTH_PICKER);this._showOverlay();d1.setMonth(c1.getUTCMonth());$.call(this,c1.getUTCFullYear(),d1);if(this._iMode==0){var e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=2;z.call(this);}function x(){var c1=this._getFocusedDate();var d1=this._getYearPicker();this.setProperty("_currentPicker",p.YEAR_PICKER);this._showOverlay();d1.setDate(c1.getJSDate());if(this._iMode==0){var e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}A.call(this);this._iMode=3;}function y(){B.call(this);z.call(this);}function z(c1){var d1=new U(r.call(this).getTime());var e1=this._getItems();var f1=d1.getJSDate().getUTCFullYear();var g1=this._oMaxDate.getJSDate().getUTCFullYear();var h1=this._oMinDate.getJSDate().getUTCFullYear();var i1=d1.getJSDate().getUTCMonth();var j1=this._oMaxDate.getJSDate().getUTCMonth();var k1=this._oMinDate.getJSDate().getUTCMonth();var l1=d1.getJSDate().getUTCDate();var m1=this._oMaxDate.getJSDate().getUTCDate();var n1=this._oMinDate.getJSDate().getUTCDate();var o1=d1.getJSDate().getUTCHours();var p1=this._oMaxDate.getJSDate().getUTCHours();var q1=this._oMinDate.getJSDate().getUTCHours();var r1=d1.getJSDate().getUTCMinutes();var s1=this._oMaxDate.getJSDate().getUTCMinutes();var t1=this._oMinDate.getJSDate().getUTCMinutes();var u1=this.getAggregation("header");if(this._iMode==2&&!c1){var v1=this._getMonthPicker();var w1=v1.getMonths();var x1=v1.getStartMonth();var y1=x1+w1-1;if(x1==0||(f1==h1&&x1<=k1)){u1.setEnabledPrevious(false);}else{u1.setEnabledPrevious(true);}if(y1>10||(f1==g1&&y1>=j1)){u1.setEnabledNext(false);}else{u1.setEnabledNext(true);}return;}if((f1<h1||(f1==h1&&(c1||(i1<k1||(i1==k1&&(l1<n1||(l1==n1&&(o1<q1||(o1==q1&&r1<=t1)))))))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){u1.setEnabledPrevious(false);}else{u1.setEnabledPrevious(true);}d1.setUTCMinutes(d1.getUTCMinutes()+(e1)*this.getIntervalMinutes()-1);f1=d1.getJSDate().getUTCFullYear();i1=d1.getJSDate().getUTCMonth();l1=d1.getJSDate().getUTCDate();o1=d1.getJSDate().getUTCHours();r1=d1.getJSDate().getUTCMinutes();if((f1>g1||(f1==g1&&(!c1||(i1>j1||(i1==j1&&(l1>m1||(l1==m1&&(o1>p1||(o1==p1&&r1>=s1)))))))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){u1.setEnabledNext(false);}else{u1.setEnabledNext(true);}if(this._iMode===1){var z1=new U(d1.getTime());z1.setUTCDate(1);z1.setUTCMonth(z1.getUTCMonth()+1);z1.setUTCDate(0);var A1=this.getAggregation("datesRow").getDays();d1.setUTCDate(1+(Math.ceil(d1.getUTCDate()/A1)-1)*A1);if(z1.getUTCDate()-d1.getUTCDate()<A1){d1.setUTCDate(z1.getUTCDate()-A1+1);}l1=d1.getUTCDate();if(l1<=1||(f1==h1&&i1==k1&&l1<=n1)){u1.setEnabledPrevious(false);}else{u1.setEnabledPrevious(true);}if((l1+A1)>=z1.getUTCDate()||(f1==g1&&i1==j1&&l1>=m1)){u1.setEnabledNext(false);}else{u1.setEnabledNext(true);}}}function A(){var c1=this._getYearPicker();var d1=c1.getYears();var e1=b._createUniversalUTCDate(c1.getProperty("_middleDate").toLocalJSDate());e1.setUTCFullYear(e1.getUTCFullYear()+Math.floor(d1/2));var f1=this.getAggregation("header");var g1=new U(this._oMaxDate);g1.setUTCFullYear(g1.getUTCFullYear()-Math.ceil(d1/2));g1.setUTCMonth(11,31);var h1=new U(this._oMinDate);h1.setUTCFullYear(h1.getUTCFullYear()+Math.floor(d1/2)+1);h1.setUTCMonth(0,1);if(e1.getTime()>g1.getTime()){f1.setEnabledNext(false);}else{f1.setEnabledNext(true);}if(e1.getTime()<h1.getTime()){f1.setEnabledPrevious(false);}else{f1.setEnabledPrevious(true);}}function B(){var c1=this.getAggregation("header");var d1;var e1=r.call(this);var f1;var g1=this._getLocaleData();var h1=[];var i1=[];var j1;var k1=false;var l1;var m1=false;if(g1.oLocale.sLanguage.toLowerCase()==="ja"||g1.oLocale.sLanguage.toLowerCase()==="zh"){l1=c.getDateInstance({format:"d"}).format(e1,true);}else{l1=(e1.getUTCDate()).toString();}if(this._bLongMonth||!this._bNamesLengthChecked){h1=g1.getMonthsStandAlone("wide");}else{k1=true;h1=g1.getMonthsStandAlone("abbreviated");i1=g1.getMonthsStandAlone("wide");}var n1=e1.getUTCMonth();d1=h1[n1];if(k1){j1=i1[h1[n1]];}if(!this.getPickerPopup()){c1.setTextButton0(l1);c1.setTextButton1(d1);c1.setTextButton2(this._oYearFormat.format(e1,true));}else{f1=c.getInstance({style:"long",strictParsing:true,relative:m1},g1.oLocale);j1=l1=f1.format(b._createLocalDate(e1,true));c1.setTextButton1(l1);}if(k1){c1.setAriaLabelButton1(j1);}}function E(c1,d1){var e1;var f1=false;if(c1.getTime()<this._oMinDate.getTime()){e1=this._oMinDate;f1=true;}else if(c1.getTime()>this._oMaxDate.getTime()){e1=this._oMaxDate;f1=true;}else{e1=c1;}this._setFocusedDate(e1);if(f1||d1){W.call(this,e1);s.call(this,false);this.fireStartDateChange();}}function F(c1,d1){if(c1&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=c1.getTime())){b._checkJSDateObject(c1);c1=b._createUniversalUTCDate(c1,undefined,true);var e1=c1.getUTCFullYear();b._checkYearInValidRange(e1);if(c1.getTime()<this._oMinDate.getTime()||c1.getTime()>this._oMaxDate.getTime()){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(c1);if(this.getDomRef()&&this._iMode==0){s.call(this,d1);}}}function G(c1){if(this._iMode!=1){v.call(this);}else{this.setProperty("_currentPicker",p.TIMES_ROW);}}function I(c1){var d1;if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=2){d1=function(){var e1=this._getMonthPicker();e1._oItemNavigation.focusItem(e1.getProperty("_focusedMonth"));e1.removeDelegate(d1);};w.call(this);this._getMonthPicker().addDelegate({onAfterRendering:d1},this);}else{this.setProperty("_currentPicker",p.TIMES_ROW);}}}function J(c1){var d1;if(this._iMode!=3){d1=function(){var e1=this._getYearPicker();e1.focus();e1.removeDelegate(d1);};x.call(this);this._getYearPicker().addDelegate({onAfterRendering:d1},this);}else{this.setProperty("_currentPicker",p.TIMES_ROW);}}function K(c1){this.fireSelect();}function N(c1){var d1=b._createUniversalUTCDate(c1.getParameter("date"),undefined,true);var e1=c1.getParameter("notVisible");E.call(this,d1,e1);}function O(c1){var d1=c1.getSource(),e1=d1.getSelectedDates()[0].getStartDate();var f1=new U(this._getFocusedDate().getTime());var g1=b._createUniversalUTCDate(e1);f1.setUTCFullYear(g1.getUTCFullYear());f1.setUTCMonth(g1.getUTCMonth(),g1.getUTCDate());E.call(this,f1,true);u.call(this);}function Q(c1){var d1=new U(this._getFocusedDate().getTime());var e1=c1.oSource;var f1=e1.getSelectedDates()[0];var g1=b._createUniversalUTCDate(f1.getStartDate());if(!this.getPickerPopup()||g1.getUTCMonth()==d1.getUTCMonth()){d1.setUTCDate(g1.getUTCDate());d1.setUTCMonth(g1.getUTCMonth());d1.setUTCFullYear(g1.getUTCFullYear());E.call(this,d1,true);this.setProperty("_currentPicker",p.TIMES_ROW);}this._addTimesRowFocusDelegate();}function R(c1){var d1=new U(this._getFocusedDate().getTime());var e1=b._createUniversalUTCDate(c1.getParameter("date"),undefined,true);var f1=c1.getParameter("otherMonth");if(f1&&e1.getUTCMonth()==d1.getUTCMonth()&&e1.getUTCFullYear()==d1.getUTCFullYear()){X.call(this,e1);}}function S(c1){var d1=new U(this._getFocusedDate().getTime());var e1=this._getMonthPicker();var f1=e1.getMonth();d1.setUTCMonth(f1);if(f1!=d1.getUTCMonth()){d1.setUTCDate(0);}E.call(this,d1,true);this.setProperty("_currentPicker",p.TIMES_ROW);this._addTimesRowFocusDelegate();}function V(c1){var d1=new U(this._getFocusedDate().getTime());var e1=this._getYearPicker();var f1=b._createUniversalUTCDate(e1.getDate());var g1=d1.getUTCMonth();f1.setUTCMonth(d1.getUTCMonth(),d1.getUTCDate());f1.setUTCHours(d1.getUTCHours());f1.setUTCMinutes(d1.getUTCMinutes());d1=f1;if(g1!=d1.getUTCMonth()){d1.setUTCDate(0);}E.call(this,d1,true);this.setProperty("_currentPicker",p.TIMES_ROW);this._addTimesRowFocusDelegate();}o.prototype._addTimesRowFocusDelegate=function(){var c1={onAfterRendering:function(){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());this.removeDelegate(c1);}},d1=this.getAggregation("timesRow");d1.addDelegate(c1,d1);};function W(c1){var d1=this.getAggregation("timesRow");var e1=r.call(this);var f1=d1._oItemNavigation.getFocusedIndex();e1=new U(c1.getTime());e1.setUTCMinutes(e1.getUTCMinutes()-f1*this.getIntervalMinutes());_.call(this,e1,false,true);}function X(c1){var d1=this.getAggregation("datesRow");var e1=this.getAggregation("header");if(!this.getPickerPopup()){var f1=new U(c1.getTime());f1.setUTCDate(1);f1.setUTCMonth(f1.getUTCMonth()+1);f1.setUTCDate(0);var g1=d1.getDays();var h1=new U(c1.getTime());h1.setUTCDate(1+(Math.ceil(c1.getUTCDate()/g1)-1)*g1);if(f1.getUTCDate()-h1.getUTCDate()<g1){h1.setUTCDate(f1.getUTCDate()-g1+1);}d1.setStartDate(b._createLocalDate(h1,true));var i1=h1.getJSDate().getUTCFullYear();var j1=this._oMaxDate.getJSDate().getUTCFullYear();var k1=this._oMinDate.getJSDate().getUTCFullYear();var l1=h1.getJSDate().getUTCMonth();var m1=this._oMaxDate.getJSDate().getUTCMonth();var n1=this._oMinDate.getJSDate().getUTCMonth();var o1=h1.getJSDate().getUTCDate();var p1=this._oMaxDate.getJSDate().getUTCDate();var q1=this._oMinDate.getJSDate().getUTCDate();if(o1<=1||(i1==k1&&l1==n1&&o1<=q1)){e1.setEnabledPrevious(false);}else{e1.setEnabledPrevious(true);}if((o1+g1)>=f1.getUTCDate()||(i1==j1&&l1==m1&&o1>=p1)){e1.setEnabledNext(false);}else{e1.setEnabledNext(true);}if(!this._oFocusDatesRowDelegate){this._oFocusDatesRowDelegate={onAfterRendering:function(){this.focus();}};d1.addDelegate(this._oFocusDatesRowDelegate,d1);}}else{e1.setEnabledPrevious(false);e1.setEnabledNext(false);}d1.setDate(b._createLocalDate(c1,true));}function Z(c1){if(!this._oPopup){var d1=new P({placement:"VerticalPreferredBottom",showHeader:false,showArrow:false,verticalScrolling:false});d1.oPopup.setDurations(0,0);d1.addEventDelegate({onsapescape:this._oCalendar.onsapescape},this._oCalendar);this._oPopup=d1;}this._oPopup.addContent(c1);this._oPopup.attachAfterClose(function(){this._hideOverlay();this._addTimesRowFocusDelegate();},this);this._oPopup.attachAfterOpen(function(){var f1=e1.$("B1");var g1=this._oPopup.$();var h1=Math.floor((g1.width()-f1.width())/2);this._oPopup.setOffsetX(C.getConfiguration().getRTL()?h1:-h1);var i1=f1.height();this._oPopup.setOffsetY(this._oPopup._getCalculatedPlacement()==="Top"?i1:-i1);},this);var e1=this.getAggregation("header");this._oPopup.openBy(e1.getDomRef("B1"));}function $(c1,d1){var e1=0;var f1=11;if(c1==this._oMinDate.getUTCFullYear()){e1=this._oMinDate.getUTCMonth();}if(c1==this._oMaxDate.getUTCFullYear()){f1=this._oMaxDate.getUTCMonth();}d1.setMinMax(e1,f1);}function a1(c1){z.call(this);}function b1(c1){A.call(this);}return o;});
