/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Popup','./library','sap/ui/core/theming/Parameters','./ShellOverlayRenderer',"sap/ui/thirdparty/jquery",'sap/ui/dom/jquery/rect','sap/ui/dom/jquery/Selectors'],function(D,C,P,l,a,S,q){"use strict";var b=C.extend("sap.ui.unified.ShellOverlay",{metadata:{library:"sap.ui.unified",deprecated:true,defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},search:{type:"sap.ui.core.Control",multiple:false}},associations:{shell:{type:"sap.ui.unified.ShellLayout",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{closed:{}}}});b.prototype.open=function(){if(this._getPopup().isOpen()){return;}this._opening=true;this._forceShellHeaderVisible();this._getPopup().setModal(true,P.blStack.length==0&&this._getAnimActive()?"sapUiUfdShellOvrlyBly sapUiUfdShellOvrlyBlyTp":"");this._getPopup().open(0,P.Dock.BeginTop,P.Dock.BeginTop,window,"0 0","none");var s=this.getSearch();if(s){s.focus();}this._opening=false;if(this._getAnimActive()){setTimeout(function(){q(document.getElementById("sap-ui-blocklayer-popup")).toggleClass("sapUiUfdShellOvrlyBlyTp",false);},50);}setTimeout(function(){this.$().toggleClass("sapUiUfdShellOvrlyOpening",false);}.bind(this),this._getAnimDuration(true));};b.prototype.close=function(){if(!this._getPopup().isOpen()){return;}this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden",true).toggleClass("sapUiUfdShellOvrlyClosing",true);this._setSearchWidth();setTimeout(function(){var B=q(document.getElementById("sap-ui-blocklayer-popup"));if(P.blStack.length==1&&this._getAnimActive()&&B.hasClass("sapUiUfdShellOvrlyBly")){B.toggleClass("sapUiUfdShellOvrlyBlyTp",true);}}.bind(this),Math.max(this._getAnimDuration(false)-this._getBLAnimDuration(),0));setTimeout(function(){this._getPopup().close(0);this.$().remove();this._forceShellHeaderVisible();this.fireClosed();}.bind(this),this._getAnimDuration(false));};b.prototype.setShell=function(s){return this.setAssociation("shell",s,true);};b.prototype.setSearch=function(s){this.setAggregation("search",s,true);if(this.getDomRef()){this._headRenderer.render();}return this;};b.prototype.insertContent=function(c,i){var r=this.insertAggregation("content",c,i,true);if(this.getDomRef()){this._contentRenderer.render();}return r;};b.prototype.addContent=function(c){var r=this.addAggregation("content",c,true);if(this.getDomRef()){this._contentRenderer.render();}return r;};b.prototype.removeContent=function(i){var r=this.removeAggregation("content",i,true);if(this.getDomRef()){this._contentRenderer.render();}return r;};b.prototype.removeAllContent=function(){var r=this.removeAllAggregation("content",true);if(this.getDomRef()){this._contentRenderer.render();}return r;};b.prototype.destroyContent=function(){var r=this.destroyAggregation("content",true);if(this.getDomRef()){this._contentRenderer.render();}return r;};b.prototype.init=function(){this._animOpenDuration=-1;this._animCloseDuration=-1;this._animBlockLayerDuration=-1;this._animation=sap.ui.getCore().getConfiguration().getAnimation();this._opening=false;var t=this;this._headRenderer=new l._ContentRenderer(this,this.getId()+"-hdr-center",function(r){S.renderSearch(r,t);});this._contentRenderer=new l._ContentRenderer(this,this.getId()+"-cntnt",function(r){S.renderContent(r,t);});};b.prototype.exit=function(){if(this._popup){this._popup.close(0);this._popup.destroy();this._popup=null;}this._getPopup=function(){return null;};this._headRenderer.destroy();delete this._headRenderer;this._contentRenderer.destroy();delete this._contentRenderer;};b.prototype.onAfterRendering=function(){if(this._opening){this._setSearchWidth();}setTimeout(function(){this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden",false);this.$("search").css("width","");}.bind(this),10);};b.prototype.onclick=function(e){if(q(e.target).attr("id")===this.getId()+"-close"){this.close();e.preventDefault();}};b.prototype.onsapspace=b.prototype.onclick;b.prototype.onThemeChanged=function(){this._animOpenDuration=-1;this._animCloseDuration=-1;this._animBlockLayerDuration=-1;};b.prototype.onfocusin=function(e){var f,d;if(e.target.id==this.getId()+"-focfirst"){f=q(":sapTabbable",this.$("inner"));d=f.get(f.length-1);}else if(e.target.id==this.getId()+"-foclast"){f=q(":sapTabbable",this.$("inner"));d=f.get(0);}if(d){d.focus();}};b.prototype._getAnimDurationThemeParam=function(p,c){var v=parseInt(a.get(p));if(!this._getAnimActive()&&c){v=0;}return v;};b.prototype._getAnimDuration=function(o){if((o&&this._animOpenDuration==-1)||(!o&&this._animCloseDuration==-1)){var t=o?"Open":"Close";this["_anim"+t+"Duration"]=this._getAnimDurationThemeParam("_sap_ui_unified_ShellOverlay_"+t+"AnimOverAll",true);}return o?this._animOpenDuration:this._animCloseDuration;};b.prototype._getBLAnimDuration=function(){if(this._animBlockLayerDuration==-1){this._animBlockLayerDuration=this._getAnimDurationThemeParam("_sap_ui_unified_ShellOverlay_BlockLayerAnimDuration",true);}return this._animBlockLayerDuration;};b.prototype._getAnimActive=function(){if(!this._animation){return false;}return true;};b.prototype._getPopup=function(){if(!this._popup){this._popup=new P(this,true,false,false);this._popup._applyPosition=function(p){this._$().css("left","0").css("top","0");this._oLastPosition=p;this._oLastOfRect=q(window).rect();};this._popup.attachOpened(function(){l._iNumberOfOpenedShellOverlays++;});this._popup.attachClosed(function(){l._iNumberOfOpenedShellOverlays--;});}return this._popup;};b.prototype._getShell=function(){var i=this.getShell();if(!i){return;}var s=sap.ui.getCore().byId(i);if(!s||!(s instanceof sap.ui.unified.ShellLayout)){return;}return s;};b.prototype._forceShellHeaderVisible=function(){var s=this._getShell();if(s){s._doShowHeader(true);}};b.prototype._getSearchWidth=function(){var s=this._getShell();return s?s._getSearchWidth():-1;};b.prototype._setSearchWidth=function(){var w=this._getSearchWidth();if(w<=0){return;}var W=w+"px";if(D.browser.safari){var t=this.$("hdr-center").width();if(t>w){W=Math.round((w*100)/t)+"%";}else{W="100%";}}this.$("search").css("width",W);};return b;});
