/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/Device','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/core/date/UniversalDate',"sap/ui/unified/DateRange",'sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library',"./YearPickerRenderer","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(C,D,I,a,b,U,c,l,d,e,Y,K,q){"use strict";var f=e.CalendarType;var g=C.extend("sap.ui.unified.calendar.YearPicker",{metadata:{library:"sap.ui.unified",properties:{year:{type:"int",group:"Data",defaultValue:2000,deprecated:true},years:{type:"int",group:"Appearance",defaultValue:20},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},columns:{type:"int",group:"Appearance",defaultValue:4},date:{type:"object",group:"Data"},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},_middleDate:{type:"object",group:"Data",visibility:"hidden"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"}},events:{select:{},pageChange:{}}}});g.prototype.init=function(){var s=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",s);this._oYearFormat=d.getDateInstance({format:"y",calendarType:s});this._oFormatYyyymmdd=d.getInstance({pattern:"yyyyMMdd",calendarType:f.Gregorian});this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());};g.prototype.onAfterRendering=function(){_.call(this);this.focus();};g.prototype.exit=function(){if(this._aMPSelectedDates&&this._aMPSelectedDates.length){this._aMPSelectedDates.forEach(function(o){o.destroy();});this._aMPSelectedDates=undefined;}};g.prototype.getFocusDomRef=function(){return this.getDomRef()&&this._oItemNavigation.getItemDomRefs()[this._iSelectedIndex];};g.prototype.setYear=function(y){this.setProperty("year",y);y=this.getProperty("year");var o=new b(y,0,1,this.getPrimaryCalendarType()),s=this._getSelectedDates()[0],i=this.getAggregation("selectedDates");if(!s||this.getIntervalSelection()){return this;}if(!this._oSelectedDatesControlOrigin){if(!i||!i.length){this.addAggregation("selectedDates",s);}!this.getIntervalSelection()&&s.setStartDate(o.toLocalJSDate());}this.setDate(o.toLocalJSDate());return this;};g.prototype.setDate=function(o){var i,y,m,H;o&&a._checkJSDateObject(o);y=o.getFullYear();a._checkYearInValidRange(y);i=b.fromLocalJSDate(o,this.getPrimaryCalendarType());i.setMonth(0,1);this.setProperty("date",o);this.setProperty("year",i.getYear());this._oDate=i;m=this.getYears();H=Math.floor(m/2);this._iSelectedIndex=H;this.setProperty("_middleDate",i);return this;};g.prototype._getDate=function(){if(!this._oDate){var y=this.getYear();this._oDate=new b(y,0,1,this.getPrimaryCalendarType());}return this._oDate;};g.prototype._setSelectedDatesControlOrigin=function(o){this._oSelectedDatesControlOrigin=o;};g.prototype.getSelectedDates=function(){if(this._oSelectedDatesControlOrigin){return this._oSelectedDatesControlOrigin.getSelectedDates();}return this.getAggregation("selectedDates");};g.prototype._getSelectedDates=function(){var s=this.getSelectedDates();if(s){return s;}else if(!this._aMPSelectedDates||!this._aMPSelectedDates.length){this._aMPSelectedDates=[new c()];this._aMPSelectedDates[0].setStartDate(this._getDate().toLocalJSDate());return this._aMPSelectedDates;}else{return this._aMPSelectedDates;}};g.prototype.setPrimaryCalendarType=function(s){this.setProperty("primaryCalendarType",s);this._oYearFormat=d.getDateInstance({format:"y",calendarType:s});if(this._oDate){this._oDate=new b(this._oDate,s);this._oDate.setMonth(0,1);}this._oMinDate=new b(this._oMinDate,s);this._oMaxDate=new b(this._oMaxDate,s);return this;};g.prototype.nextPage=function(){this._updatePage(true,this._oItemNavigation.getFocusedIndex());return this;};g.prototype.previousPage=function(){this._updatePage(false,this._oItemNavigation.getFocusedIndex());return this;};g.prototype.onsapspace=function(E){E.preventDefault();};g.prototype.onsapselect=function(E){var i=this._oItemNavigation.getFocusedIndex();var s=this._selectYear(i);if(s){this.fireSelect();}};g.prototype.onmouseover=function(E){var t=E.target,s=this._getSelectedDates()[0],S,F,y;if(!s){return;}if(s.getStartDate()){S=b.fromLocalJSDate(s.getStartDate(),this.getPrimaryCalendarType());S.setMonth(0,1);}if(t.classList.contains("sapUiCalItem")){y=t.getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y),this.getPrimaryCalendarType());if(this._isSelectionInProgress()){this._markInterval(S,F);}}};g.prototype.onmousedown=function(E){this._oMousedownPosition={clientX:E.clientX,clientY:E.clientY};};g.prototype.onmouseup=function(E){var t=E.target,s=this._getSelectedDates()[0],i,y,S,F,$=this._oItemNavigation.getItemDomRefs();if(this._bMousedownChange){this._bMousedownChange=false;if(this.getIntervalSelection()&&t.classList.contains("sapUiCalItem")&&s){y=t.getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y),this.getPrimaryCalendarType());S=b.fromLocalJSDate(s.getStartDate(),this.getPrimaryCalendarType());S.setMonth(0,1);if(!F.isSame(S)&&!s.getEndDate()){i=$.index(t);this._selectYear.call(this,i);this._oItemNavigation.focusItem(i);}}this.fireSelect();}else if(D.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,E.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,E.clientY,10)){i=this._oItemNavigation.getFocusedIndex();if(!$[i].classList.contains("sapUiCalItemDsbl")){this._selectYear(i);this.fireSelect();}}};g.prototype._markInterval=function(s,E){var m=this._oItemNavigation.getItemDomRefs(),F,y,i;if(s.isAfter(E)){E=[s,s=E][0];}for(i=0;i<m.length;++i){y=m[i].getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y),this.getPrimaryCalendarType());if(this._bMousedownChange){if(F.isSame(s)||F.isSame(E)){q(m[i]).addClass("sapUiCalItemSel");}else{q(m[i]).removeClass("sapUiCalItemSel");}}if(a._isBetween(F,s,E)){q(m[i]).addClass("sapUiCalItemSelBetween");}else{q(m[i]).removeClass("sapUiCalItemSelBetween");}}};g.prototype.getFirstRenderedDate=function(){var F;if(this.getDomRef()){var i=this._oItemNavigation.getItemDomRefs();F=this._oFormatYyyymmdd.parse(q(i[0]).attr("data-sap-year-start"));}return F;};g.prototype._isValueInThreshold=function(r,v,t){var L=r-t,u=r+t;return v>=L&&v<=u;};g.prototype._checkFirstDate=function(o){var y=this.getYears(),m=new b(this._oMaxDate,this.getPrimaryCalendarType());if(!m.isSame(a._maxDate(this.getPrimaryCalendarType()))){return o;}m.setYear(m.getYear()-y+1);if(o.isAfter(m)&&o.getYear()!=m.getYear()){o=new b(m,this.getPrimaryCalendarType());o.setMonth(0,1);}else if(o.isBefore(this._oMinDate)&&o.getYear()!=this._oMinDate.getYear()){o=new b(this._oMinDate,this.getPrimaryCalendarType());o.setMonth(0,1);}return o;};g.prototype._checkDateEnabled=function(o){var E=true;if((o.isAfter(this._oMaxDate)&&o.getYear()!=this._oMaxDate.getYear())||(o.isBefore(this._oMinDate)&&o.getYear()!=this._oMinDate.getYear())){E=false;}return E;};g.prototype._updatePage=function(F,s,i){var m=this._oItemNavigation.getItemDomRefs();var o=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(q(m[0]).attr("data-sap-year-start")),this.getPrimaryCalendarType());var y=this.getYears();if(F){var M=new b(this._oMaxDate,this.getPrimaryCalendarType());M.setYear(M.getYear()-y+1);if(o.isBefore(M)){o.setYear(o.getYear()+y);if(o.isAfter(M)){s=s+(o.getYear()-M.getYear());if(s>y-1){s=y-1;}o=new b(this._oMaxDate,this.getPrimaryCalendarType());this._oDate.setMonth(0,1);}}else{return;}}else{if(o.isAfter(this._oMinDate)){o.setYear(o.getYear()-y);if(o.isBefore(this._oMinDate)){s=s-(this._oMinDate.getYear()-o.getYear());if(s<0){s=0;}o=new b(this._oMinDate,this.getPrimaryCalendarType());}}else{return;}}o.setYear(o.getYear()+Math.floor(y/2));this._iSelectedIndex=s;this.setProperty("_middleDate",o);if(i){this.firePageChange();}};g.prototype._selectYear=function(m){var n=this._oItemNavigation.getItemDomRefs(),$=q(n[m]),y=$.attr("data-sap-year-start"),F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y),this.getPrimaryCalendarType()),s=this._getSelectedDates()[0],o=this.getAggregation("selectedDates"),S;if($.hasClass("sapUiCalItemDsbl")){return false;}if(!this._isSelectionInProgress()){var p=true;}this.setProperty("year",F.getYear(),p);this.setProperty("date",F.toLocalJSDate(),p);if(!s){return true;}if(!this._oSelectedDatesControlOrigin){if(!o||!o.length){this.addAggregation("selectedDates",s);}!this.getIntervalSelection()&&s.setStartDate(F.toLocalJSDate(),p);}if(this.getIntervalSelection()){if(!s.getStartDate()){s.setStartDate(F.toLocalJSDate(),p);}else if(!s.getEndDate()){S=b.fromLocalJSDate(s.getStartDate(),this.getPrimaryCalendarType());if(F.isBefore(S)){s.setEndDate(S.toLocalJSDate(),p);s.setStartDate(F.toLocalJSDate(),p);}else{s.setEndDate(F.toLocalJSDate(),p);}}else{s.setStartDate(F.toLocalJSDate(),p);s.setEndDate(undefined,p);}}if(p){for(var i=0;i<n.length;i++){$=q(n[i]);y=$.attr("data-sap-year-start");var r=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y),this.getPrimaryCalendarType());var A=this._fnShouldApplySelection(r);var t=this._fnShouldApplySelectionBetween(r);if(A){$.addClass("sapUiCalItemSel");$.removeClass("sapUiCalItemSelBetween");$.attr("aria-selected","true");}if(t){$.addClass("sapUiCalItemSelBetween");$.attr("aria-selected","true");}if(!A&&!t){$.removeClass("sapUiCalItemSel");$.removeClass("sapUiCalItemSelBetween");$.attr("aria-selected","false");}}}return true;};g.prototype._isSelectionInProgress=function(){var s=this._getSelectedDates()[0];if(!s){return false;}return this.getIntervalSelection()&&s.getStartDate()&&!s.getEndDate();};function _(){var F=this.getDate()?b.fromLocalJSDate(this.getDate(),this.getPrimaryCalendarType()):this._getDate(),r=this.getDomRef(),m=this.$().find(".sapUiCalItem"),n,y,o,i;for(i=0;i<m.length;++i){y=m[i].getAttribute("data-sap-year-start");o=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y),this.getPrimaryCalendarType());if(o.isSame(F)){n=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,h,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,j,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,k,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setHomeEndColumnMode(true,true);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"],saphome:["alt","meta"],sapend:["meta"]});}this._oItemNavigation.setRootDomRef(r);this._oItemNavigation.setItemDomRefs(m);this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(this.getColumns(),true);if(a._isBetween(F,this._oMinDate,this._oMaxDate,true)){this._oItemNavigation.setFocusedIndex(n);}this._oItemNavigation.setPageSize(m.length);}function h(o){var i=o.getParameter("index"),E=o.getParameter("event"),t=this._oItemNavigation.aItemDomRefs[i],s=this._getSelectedDates()[0],S,F,y;if(!E){return;}if(E.type==="mousedown"){this._handleMousedown(E,i);}else if(E.type==="sapnext"||E.type==="sapprevious"){if(!s){return;}if(s.getStartDate()){S=b.fromLocalJSDate(s.getStartDate(),this.getPrimaryCalendarType());S.setMonth(0,1);}y=t.getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y),this.getPrimaryCalendarType());if(this._isSelectionInProgress()){this._markInterval(S,F);}}}function j(o){h.call(this,o);}g.prototype._handleMousedown=function(E,i){if(E.button||D.support.touch&&!D.system.combi){return;}var s=this._selectYear(i);if(s){this._bMousedownChange=true;}E.preventDefault();E.setMark("cancelAutoClose");};function k(o){var E=o.getParameter("event"),i=this._oItemNavigation.getFocusedIndex(),y=this.getYears(),m=this.getColumns(),s=this._getSelectedDates()[0],n=this._oItemNavigation.getItemDomRefs(),S,F,p;if(s&&s.getStartDate()){S=b.fromLocalJSDate(s.getStartDate(),this.getPrimaryCalendarType());S.setMonth(0,1);}if(E.type){if(m===0){m=y;}switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode===K.ARROW_DOWN&&m<y){p=n[i-y+m].getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(p),this.getPrimaryCalendarType());this._updatePage(true,i-y+m,true);this._iSelectedIndex=i-y+m;}else{p=n[0].getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(p),this.getPrimaryCalendarType());this._updatePage(true,0,true);}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode===K.ARROW_UP&&m<y){p=n[y-m+i].getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(p),this.getPrimaryCalendarType());this._updatePage(false,y-m+i,true);this._iSelectedIndex=y-m+i;}else{p=n[y-1].getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(p),this.getPrimaryCalendarType());this._updatePage(false,y-1,true);}break;case"sappagedown":p=n[i].getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(p),this.getPrimaryCalendarType());this._updatePage(true,i,true);break;case"sappageup":p=n[i].getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(p),this.getPrimaryCalendarType());this._updatePage(false,i,true);break;default:break;}}this._isSelectionInProgress()&&this._markInterval(S,F);}g.prototype._fnShouldApplySelection=function(o){var s=this._getSelectedDates()[0],S,E;if(!s){return false;}S=s.getStartDate();E=s.getEndDate();if(S){S=b.fromLocalJSDate(S,this.getPrimaryCalendarType());S.setMonth(0,1);}if(this.getIntervalSelection()&&S&&E){E=b.fromLocalJSDate(E,this.getPrimaryCalendarType());E.setMonth(0,1);if(o.isSame(S)||o.isSame(E)){return true;}}else if(S&&o.isSame(S)){return true;}return false;};g.prototype._fnShouldApplySelectionBetween=function(o){var s=this._getSelectedDates()[0],S,E;if(!s){return false;}S=s.getStartDate();E=s.getEndDate();if(this.getIntervalSelection()&&S&&E){S=b.fromLocalJSDate(S,this.getPrimaryCalendarType());S.setMonth(0,1);E=b.fromLocalJSDate(E,this.getPrimaryCalendarType());E.setMonth(0,1);if(a._isBetween(o,S,E)){return true;}}return false;};return g;});
