/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/commons/MenuButton','sap/ui/core/Control','sap/ui/core/theming/Parameters','./Feeder','./library','./FeedChunkRenderer','sap/ui/commons/Menu','sap/ui/commons/MenuItem'],function(q,M,C,P,F,l,a,b,c){"use strict";var d=l.FeederType;var e=C.extend("sap.ui.ux3.FeedChunk",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{thumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},sender:{type:"string",group:"Data",defaultValue:null},timestamp:{type:"string",group:"Data",defaultValue:null},deletionAllowed:{type:"boolean",group:"Behavior",defaultValue:false},commentChunk:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},feederThumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},feederSender:{type:"string",group:"Data",defaultValue:null},flagged:{type:"boolean",group:"Data",defaultValue:false},favorite:{type:"boolean",group:"Data",defaultValue:null},shared:{type:"boolean",group:"Data",defaultValue:false},enableFlag:{type:"boolean",group:"Appearance",defaultValue:true},enableShare:{type:"boolean",group:"Appearance",defaultValue:true},enableComment:{type:"boolean",group:"Appearance",defaultValue:true},enableInspect:{type:"boolean",group:"Appearance",defaultValue:true},enableFavorite:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{comments:{type:"sap.ui.ux3.FeedChunk",multiple:true,singularName:"comment",bindable:"bindable"},actionMenuItems:{type:"sap.ui.commons.MenuItem",multiple:true,singularName:"actionMenuItem",bindable:"bindable"}},events:{deleted:{},commentAdded:{parameters:{comment:{type:"sap.ui.ux3.FeedChunk"}}},toggleFlagged:{parameters:{flagged:{type:"boolean"}}},senderClicked:{},referenceClicked:{parameters:{text:{type:"string"}}},toggleFavorite:{parameters:{favorite:{type:"boolean"}}},inspect:{},toggleShared:{parameters:{shareed:{type:"boolean"}}},actionItemSelected:{parameters:{itemId:{type:"string"},item:{type:"sap.ui.unified.MenuItemBase"}}}}}});e.prototype.init=function(){this.maxComments=2;this.allComments=false;this.rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this.expanded=false;};e.prototype.initCommentFeeder=function(){if(!this.oCommentFeeder){this.oCommentFeeder=new F(this.getId()+'-CommentFeeder',{type:d.Comment}).setParent(this);this.oCommentFeeder.attachEvent('submit',this.handleCommentFeederSubmit,this);this.showCommentFeeder=true;}};e.prototype.initToolsButton=function(){if(!this.oToolsButton){this.oToolsButton=new M(this.getId()+'-toolsButton',{tooltip:this.rb.getText('FEED_TOOLS'),lite:true,menu:new b(this.getId()+'-toolsMenu')}).setParent(this);this.oToolsButton.attachEvent('itemSelected',this.handleToolsButtonSelected,this);var i=P._getThemeImage('_sap_ui_ux3_Feed_ToolsIconUrl');var I=P._getThemeImage('_sap_ui_ux3_Feed_ToolsIconHoverUrl');if(i){this.oToolsButton.setProperty('icon',i,true);}if(I){this.oToolsButton.setProperty('iconHovered',I,true);}}};e.prototype.exit=function(){if(this.oCommentFeeder){this.oCommentFeeder.destroy();delete this.oCommentFeeder;}if(this.oToolsButton){this.oToolsButton.destroy();delete this.oToolsButton;}this.rb=undefined;this.showCommentFeeder=undefined;this.expanded=undefined;this.oText=undefined;if(this.oHCMMenuButton){this.oHCMMenuButton.destroy();delete this.oHCMMenuButton;}};e.prototype.onAfterRendering=function(){this.oText=this.$().children(".sapUiFeedChunkText").get(0);if(this.oText.clientHeight<this.oText.scrollHeight){var f=this.$().children(".sapUiFeedChunkByline").get(0);q(f).append(a.renderExpander(this));if(this.expanded){q(this.oText).css('height','auto');}}};e.prototype.onclick=function(E){var t=E.target.getAttribute('ID');if(t){switch(t){case(this.getId()+'-delete'):this.fireDeleted();break;case(this.getId()+'-sender'):this.fireSenderClicked();break;case(this.getId()+'-thumb'):this.fireSenderClicked();break;case(this.getId()+'-exp'):var n='';if(this.expanded){q(this.oText).css('height','');n=this.rb.getText("FEED_EXPAND");this.expanded=false;}else{q(this.oText).css('height','auto');n=this.rb.getText("FEED_COLLAPSE");this.expanded=true;}q(document.getElementById(t)).attr('title',n).toggleClass('sapUiFeedChunkExpand sapUiFeedChunkCollapse');break;case(this.getId()+'-all'):this.showAllComments();break;case(this.getId()+'-ActComment'):if(!this.showCommentFeeder){this.initCommentFeeder();this.rerender();}break;case(this.getId()+'-ActFlag'):this.setFlagged(!this.getFlagged());this.fireToggleFlagged({flagged:this.getFlagged()});break;case(this.getId()+'-ActFavorite'):this.setFavorite(!this.getFavorite());this.fireToggleFavorite({favorite:this.getFavorite()});break;case(this.getId()+'-ActInspect'):this.fireInspect();break;case(this.getId()+'-ActShare'):this.setShared(!this.getShared());this.fireToggleShared({shared:this.getShared()});break;default:if(t.search(this.getId()+'-Ref')!=-1){this.fireReferenceClicked({text:q(E.target).text()});}break;}}E.preventDefault();E.stopPropagation();};e.prototype.showAllComments=function(){this.allComments=!this.allComments;var $=this.$().children("section");if($.length>0){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderComments(r,this);r.flush($[0]);r.destroy();}};e.prototype.handleCommentFeederSubmit=function(E){var D=new Date();var s=String(D);var n=new e(this.getId()+'-new-'+this.getComments().length,{text:E.getParameter('text'),commentChunk:true,deletionAllowed:true,timestamp:s,sender:this.getFeederSender(),thumbnailSrc:this.getFeederThumbnailSrc()});this.addComment(n);this.fireCommentAdded({comment:n});};e.prototype.handleToolsButtonSelected=function(E){if(E.getParameter('itemId')==this.getId()+'-actDelete'){this.fireDeleted();}else{this.fireActionItemSelected(E.mParameters);}};e.prototype.insertComment=function(o,i){this.insertAggregation("comments",o,i);this.initCommentFeeder();return this;};e.prototype.addComment=function(o){this.addAggregation("comments",o);this.initCommentFeeder();return this;};e.prototype.setDeletionAllowed=function(D){if(D==this.getDeletionAllowed()){return this;}this.setProperty("deletionAllowed",D);if(D){this.initToolsButton();this.oToolsButton.getMenu().insertItem(new c(this.getId()+'-actDelete',{text:this.rb.getText('FEED_DELETE')}),0);}else{if(this.oToolsButton){this.oToolsButton.getMenu().removeItem(this.getId()+'-actDelete');}}return this;};e.prototype.getActionMenuItems=function(){if(this.oToolsButton){var i=this.oToolsButton.getMenu().getItems();if(i.length>0&&i[0].getId()==(this.getId()+'-actDelete')){i.shift();}return i;}};e.prototype.insertActionMenuItem=function(A,i){this.initToolsButton();var I=this.oToolsButton.getMenu().getItems();if(I.length>0&&I[0].getId()==(this.getId()+'-actDelete')){i++;}this.oToolsButton.getMenu().insertItem(A,i);return this;};e.prototype.addActionMenuItem=function(A){this.initToolsButton();this.oToolsButton.getMenu().addItem(A);return this;};e.prototype.removeActionMenuItem=function(A){if(this.oToolsButton){return this.oToolsButton.getMenu().removeItem(A);}};e.prototype.removeAllActionMenuItems=function(){if(this.oToolsButton){var I=this.oToolsButton.getMenu().getItems();if(I.length>0&&I[0].getId()==(this.getId()+'-actDelete')){I.shift();for(var i=0;i<I.length;i++){this.oToolsButton.getMenu().removeItem(I[i]);}return I;}else{return this.oToolsButton.getMenu().removeAllItems();}}};e.prototype.indexOfActionMenuItem=function(A){if(this.oToolsButton){var i=this.oToolsButton.getMenu().indexOfItem(A);var I=this.oToolsButton.getMenu().getItems();if(I.length>0&&I[0].getId()==(this.getId()+'-actDelete')){i--;}return i;}};e.prototype.destroyActionMenuItems=function(){if(this.oToolsButton){var i=this.oToolsButton.getMenu().getItems();if(i.length>0&&i[0].getId()==(this.getId()+'-actDelete')){this.removeAllActionMenuItems();}else{this.oToolsButton.getMenu().destroyItems();}}return this;};e.prototype.bindActionMenuItems=function(p,t,s,f){this.initToolsButton();this.oToolsButton.getMenu().bindItems(p,t,s,f);return this;};e.prototype.unbindActionMenuItems=function(){if(this.oToolsButton){this.oToolsButton.getMenu().unbindItems();}return this;};e.prototype.getFeederThumbnailSrc=function(){var t=this.getProperty("feederThumbnailSrc");if(!t||t==""){var p=this.getParent();if(p&&(p instanceof sap.ui.ux3.Feed||p instanceof e)){t=p.getFeederThumbnailSrc();}}return t;};e.prototype.getFeederSender=function(){var s=this.getProperty("feederSender");if(!s||s==""){var p=this.getParent();if(p&&(p instanceof sap.ui.ux3.Feed||p instanceof e)){s=p.getFeederSender();}}return s;};e.prototype.initHCMMenuButton=function(){if(!this.oHCMMenuButton){this.oHCMMenuButton=new M(this.getId()+"-HCMMenu",{lite:true}).setParent(this);this.oHCMMenuButton.attachEvent('itemSelected',this.handleHCMMenuButtonSelected,this);}};e.prototype.setHCMMenu=function(m){this.initHCMMenuButton();this.oHCMMenuButton.setMenu(m);return this;};e.prototype.handleHCMMenuButtonSelected=function(E){this.fireEvent("HCMMenuItemSelected",E.mParameters);};return e;});
