/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/IntervalTrigger','./Overlay','./library','./OverlayDialogRenderer','sap/base/Log','sap/ui/dom/jquery/Focusable'],function(I,O,l,a,L){"use strict";var b=O.extend("sap.ui.ux3.OverlayDialog",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});b.prototype.init=function(){O.prototype.init.apply(this);this.setProperty("openButtonVisible",false);b.Trigger=new I(300);};b.prototype._setFocusLast=function(){var f=this.$("content").lastFocusableDomRef();if(!f&&this.getCloseButtonVisible()){f=this.getDomRef("close");}if(f){f.focus();}};b.prototype._setFocusFirst=function(){var f;if(this.getCloseButtonVisible()){f=this.getDomRef("close");}else{f=this.$("content").firstFocusableDomRef();}if(f){f.focus();}};b.prototype.setOpenButtonVisible=function(v){L.warning("OverlayDialog does not support an openButton.");return this;};b.prototype.setWidth=function(w){if(w=="auto"||w=="inherit"){w="auto";}return this.setProperty("width",w);};b.prototype.setHeight=function(h){if(h=="auto"||h=="inherit"){h="auto";}return this.setProperty("height",h);};b.prototype.onBeforeRendering=function(){O.prototype.onBeforeRendering.apply(this,arguments);this._cleanup();};b.prototype.onAfterRendering=function(){O.prototype.onAfterRendering.apply(this,arguments);b.Trigger.addListener(this._checkChange,this);};b.prototype._cleanup=function(){b.Trigger.removeListener(this._checkChange,this);this.contentWidth=null;this.contentHeight=null;this.overlayWidth=null;this.overlayHeight=null;};b.prototype.exit=function(){this._cleanup();O.prototype.exit.apply(this,arguments);};b.prototype._checkChange=function(){if(!this.getDomRef()){return;}var $=this.$("content"),c=this.$(),A=this.getWidth()==="auto",d=this.getHeight()==="auto";var e=A?Math.round(c.width()/2):$.width(),f=d?Math.round(c.height()/2):$.height(),o=c.width(),g=c.height();if(e!=this.contentWidth||f!=this.contentHeight||o!=this.overlayWidth||g!=this.overlayHeight){$.css("left","0").css("right","auto").css("top","0").css("bottom","auto").css("width",this.getWidth()).css("height",this.getHeight());this.contentWidth=e;this.contentHeight=f;this.overlayWidth=o;this.overlayHeight=g;var h=this.$("close");if(this.contentWidth<this.overlayWidth){$.css("left","50%");$.css("right","auto");$.css("margin-left",Math.round((-1)*this.contentWidth/2)+"px");$.css("width",d?this.contentWidth:this.getWidth());h.css("right","50%");h.css("margin-right",Math.round((-1)*this.contentWidth/2-10)+"px");}else{$.css("left","0");$.css("right","10px");$.css("margin-left","0");$.css("width","auto");h.css("right","0");h.css("margin-right","0");}if(this.contentHeight<this.overlayHeight-30){$.css("top","50%");$.css("bottom","auto");$.css("margin-top",Math.round((-1)*this.contentHeight/2)+"px");$.css("height",d?this.contentHeight:this.getHeight());h.css("top","50%");h.css("margin-top",Math.round((-1)*this.contentHeight/2-10)+"px");}else{$.css("top","10px");$.css("bottom","30px");$.css("margin-top","0");$.css("height","auto");h.css("top","0");h.css("margin-top","0");}}};return b;});
