sap.ui.define(['sap/ui/webc/common/thirdparty/base/renderer/LitRenderer'], function (litRender) { 'use strict';

	const block0 = (context, tags, suffix) => litRender.html`<li class="ui5-nli-group-root ui5-nli-focusable" @focusin="${context._onfocusin}" @focusout="${context._onfocusout}" @keydown="${context._onkeydown}" role="listitem" tabindex="${litRender.ifDefined(context._tabIndex)}" dir="${litRender.ifDefined(context.effectiveDir)}" aria-expanded="${litRender.ifDefined(context.ariaExpanded)}" aria-labelledby="${litRender.ifDefined(context.ariaLabelledBy)}" style="list-style-type: none;"><div class="ui5-nli-group-header"><${litRender.scopeTag("ui5-button", tags, suffix)} icon="navigation-right-arrow" design="Transparent" @click="${context._onBtnToggleClick}" class="ui5-nli-group-toggle-btn" title="${litRender.ifDefined(context.toggleBtnAccessibleName)}" aria-label="${litRender.ifDefined(context.toggleBtnAccessibleName)}"></${litRender.scopeTag("ui5-button", tags, suffix)}>${ context.hasPriority ? block1(context, tags, suffix) : undefined }<div id="${litRender.ifDefined(context._id)}-title-text" class="ui5-nli-group-title-text" part="title-text">${litRender.ifDefined(context.titleText)}</div>${ context.showCounter ? block2(context) : undefined }<div class="ui5-nli-group-divider"></div>${ !context.collapsed ? block3(context, tags, suffix) : undefined }${ context.showClose ? block7(context, tags, suffix) : undefined }<span id="${litRender.ifDefined(context._id)}-invisibleText" class="ui5-hidden-text">${litRender.ifDefined(context.accInvisibleText)}</span></div><${litRender.scopeTag("ui5-list", tags, suffix)} class="ui5-nli-group-items" accessible-role="list"><slot></slot></${litRender.scopeTag("ui5-list", tags, suffix)}>${ context.busy ? block8(context, tags, suffix) : undefined }</li>`;
	const block1 = (context, tags, suffix) => litRender.html`<${litRender.scopeTag("ui5-icon", tags, suffix)} class="ui5-prio-icon ui5-prio-icon--${litRender.ifDefined(context.priorityIcon)}" name="${litRender.ifDefined(context.priorityIcon)}"></${litRender.scopeTag("ui5-icon", tags, suffix)}>`;
	const block2 = (context, tags, suffix) => litRender.html`<span class="ui5-nli-group-counter">(${litRender.ifDefined(context.itemsCount)})</span>`;
	const block3 = (context, tags, suffix) => litRender.html`${ context.showOverflow ? block4(context, tags, suffix) : block5(context, tags, suffix) }`;
	const block4 = (context, tags, suffix) => litRender.html`<${litRender.scopeTag("ui5-button", tags, suffix)} icon="overflow" design="Transparent" @click="${context._onBtnOverflowClick}" class="ui5-nli-overflow-btn" title="${litRender.ifDefined(context.overflowBtnAccessibleName)}" aria-label="${litRender.ifDefined(context.overflowBtnAccessibleName)}"></${litRender.scopeTag("ui5-button", tags, suffix)}>`;
	const block5 = (context, tags, suffix) => litRender.html`${ litRender.repeat(context.standardActions, (item, index) => item._id || index, (item, index) => block6(item, index, context, tags, suffix)) }`;
	const block6 = (item, index, context, tags, suffix) => litRender.html`<${litRender.scopeTag("ui5-button", tags, suffix)} icon="${litRender.ifDefined(item.icon)}" class="ui5-nli-action" ?disabled="${item.disabled}" design="${litRender.ifDefined(item.design)}" @click="${item.press}" data-ui5-external-action-item-id="${litRender.ifDefined(item.refItemid)}">${litRender.ifDefined(item.text)}</${litRender.scopeTag("ui5-button", tags, suffix)}>`;
	const block7 = (context, tags, suffix) => litRender.html`<${litRender.scopeTag("ui5-button", tags, suffix)} icon="decline" design="Transparent" @click="${context._onBtnCloseClick}" title="${litRender.ifDefined(context.closeBtnAccessibleName)}" aria-label="${litRender.ifDefined(context.closeBtnAccessibleName)}" close-btn></${litRender.scopeTag("ui5-button", tags, suffix)}>`;
	const block8 = (context, tags, suffix) => litRender.html`<${litRender.scopeTag("ui5-busy-indicator", tags, suffix)} delay="${litRender.ifDefined(context.busyDelay)}" active size="Medium" class="ui5-nli-busy"></${litRender.scopeTag("ui5-busy-indicator", tags, suffix)}>`;

	return block0;

});
