sap.ui.define(["sap/ui/webc/common/thirdparty/base/UI5Element","sap/ui/webc/common/thirdparty/base/Keys","sap/ui/webc/common/thirdparty/base/i18nBundle","sap/ui/webc/common/thirdparty/base/types/ValueState","sap/ui/webc/common/thirdparty/base/util/AriaLabelHelper","sap/ui/webc/common/thirdparty/base/FeaturesRegistry","sap/ui/webc/common/thirdparty/base/types/Float","sap/ui/webc/common/thirdparty/base/types/Integer","sap/ui/webc/common/thirdparty/base/renderer/LitRenderer","./generated/templates/StepInputTemplate.lit","./generated/i18n/i18n-defaults","sap/ui/webc/common/thirdparty/icons/less","sap/ui/webc/common/thirdparty/icons/add","./Icon","./Input","./types/InputType","./generated/themes/StepInput.css"],function(e,t,i,s,n,u,a,r,o,h,l,p,d,c,_,f,m){"use strict";function v(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var b=v(e);var y=v(s);var g=v(a);var I=v(r);var S=v(o);const V={tag:"ui5-step-input",managedSlots:true,properties:{value:{type:g,defaultValue:0},min:{type:g},max:{type:g},step:{type:g,defaultValue:1},valueState:{type:y,defaultValue:y.None},required:{type:Boolean},disabled:{type:Boolean},readonly:{type:Boolean},placeholder:{type:String,defaultValue:undefined},name:{type:String},valuePrecision:{type:I,defaultValue:0},accessibleName:{type:String},accessibleNameRef:{type:String,defaultValue:""},_decIconDisabled:{type:Boolean,noAttribute:true},_incIconDisabled:{type:Boolean,noAttribute:true},_focused:{type:Boolean,noAttribute:true},_inputFocused:{type:Boolean,noAttribute:true},_previousValue:{type:g,noAttribute:true},_previousValueState:{type:String,noAttribute:true,defaultValue:""},_waitTimeout:{type:g,noAttribute:true},_speed:{type:g,noAttribute:true},_btnDown:{type:Boolean,noAttribute:true},_spinTimeoutId:{type:I,noAttribute:true},_spinStarted:{type:Boolean,noAttribute:true}},slots:{valueStateMessage:{type:HTMLElement},formSupport:{type:HTMLElement}},events:{change:{}}};const w=500;const T=.8;const D=50;const B=120;class C extends b{constructor(){super();this.i18nBundle=i.getI18nBundle("@ui5/webcomponents")}static get metadata(){return V}static get render(){return S}static get styles(){return m}static get template(){return h}static get dependencies(){return[c,_]}static async onDefine(){await i.fetchI18nBundle("@ui5/webcomponents")}get type(){return f.Number}get decIconTitle(){return this.i18nBundle.getText(l.STEPINPUT_DEC_ICON_TITLE)}get decIconName(){return"less"}get incIconTitle(){return this.i18nBundle.getText(l.STEPINPUT_INC_ICON_TITLE)}get incIconName(){return"add"}get _decIconClickable(){return!this._decIconDisabled&&!this.readonly&&!this.disabled}get _incIconClickable(){return!this._incIconDisabled&&!this.readonly&&!this.disabled}get _isFocused(){return this._focused}get _valuePrecisioned(){return this.value.toFixed(this.valuePrecision)}get accInfo(){return{ariaRequired:this.required,ariaLabel:n.getEffectiveAriaLabelText(this)}}get inputAttributes(){return{min:this.min===undefined?undefined:this.min,max:this.max===undefined?undefined:this.max,step:this.step}}onBeforeRendering(){this._setButtonState();if(this._previousValue===undefined){this._previousValue=this.value}const e=u.getFeature("FormSupport");if(e){e.syncNativeHiddenInput(this)}else if(this.name){console.warn(`In order for the "name" property to have effect, you should also: import "@ui5/webcomponents/dist/features/InputElementsFormSupport.js";`)}}get input(){return this.shadowRoot.querySelector("[ui5-input]")}get inputOuter(){return this.shadowRoot.querySelector(".ui5-step-input-input")}_onButtonFocusOut(){setTimeout(()=>{if(!this._inputFocused){this.inputOuter.removeAttribute("focused")}},0)}_onInputFocusIn(){this._inputFocused=true}_onInputFocusOut(){this._inputFocused=false;this._onInputChange()}_setButtonState(){this._decIconDisabled=this.min!==undefined&&this.value<=this.min;this._incIconDisabled=this.max!==undefined&&this.value>=this.max}_validate(){if(this._previousValueState===""){this._previousValueState=this.valueState!==""?this.valueState:y.None}this.valueState=this.min!==undefined&&this.value<this.min||this.max!==undefined&&this.value>this.max?y.Error:this._previousValueState}_preciseValue(e){const t=10**this.valuePrecision;return Math.round(e*t)/t}_fireChangeEvent(){if(this._previousValue!==this.value){this._previousValue=this.value;this.fireEvent("change",{value:this.value})}}_modifyValue(e,t){let i;this.value=this._preciseValue(parseFloat(this.input.value));i=this.value+e;if(this.min!==undefined&&i<this.min){i=this.min}if(this.max!==undefined&&i>this.max){i=this.max}i=this._preciseValue(i);if(i!==this.value){this.value=i;this._validate();this._setButtonState();this._focused=true;this.inputOuter.setAttribute("focused","");if(t){this._fireChangeEvent()}else{this.input.focus()}}}_incValue(e){if(this._incIconClickable&&e.isTrusted&&!this.disabled&&!this.readonly){this._modifyValue(this.step,true);this._previousValue=this.value}}_decValue(e){if(this._decIconClickable&&e.isTrusted&&!this.disabled&&!this.readonly){this._modifyValue(-this.step,true);this._previousValue=this.value}}_onInputChange(e){if(this.input.value===""){this.input.value=this.min||0}const t=this._preciseValue(parseFloat(this.input.value));if(this.value!==this._previousValue||this.value!==t){this.value=t;this._validate();this._setButtonState();this._fireChangeEvent()}}_onfocusin(){this._focused=true}_onfocusout(){this._focused=false}_onkeydown(e){let i=true;if(this.disabled||this.readonly){return}if(t.isEnter(e)){this._onInputChange();return}if(t.isUp(e)){this._modifyValue(this.step)}else if(t.isDown(e)){this._modifyValue(-this.step)}else if(t.isEscape(e)){this.value=this._previousValue;this.input.value=this.value.toFixed(this.valuePrecision)}else if(this.max!==undefined&&(t.isPageUpShift(e)||t.isUpShiftCtrl(e))){this._modifyValue(this.max-this.value)}else if(this.min!==undefined&&(t.isPageDownShift(e)||t.isDownShiftCtrl(e))){this._modifyValue(this.min-this.value)}else if(!t.isUpCtrl(e)&&!t.isDownCtrl(e)&&!t.isUpShift(e)&&!t.isDownShift(e)){i=false}if(i){e.preventDefault()}}_decSpin(){if(!this._decIconDisabled){this._spinValue(false,true)}}_incSpin(){if(!this._incIconDisabled){this._spinValue(true,true)}}_calcWaitTimeout(){this._speed*=T;this._waitTimeout=this._waitTimeout-this._speed<D?D:this._waitTimeout-this._speed;return this._waitTimeout}_spinValue(e,t){if(t){this._waitTimeout=w;this._speed=B;this._btnDown=true}this._spinTimeoutId=setTimeout(()=>{if(this._btnDown){this._spinStarted=true;this._modifyValue(e?this.step:-this.step);this._setButtonState();if(!this._incIconDisabled&&e||!this._decIconDisabled&&!e){this._spinValue(e)}else{this._resetSpin();this._fireChangeEvent()}}},this._calcWaitTimeout())}_resetSpin(){clearTimeout(this._spinTimeoutId);this._btnDown=false;this._spinStarted=false}_resetSpinOut(){if(this._btnDown){this._resetSpin();this._fireChangeEvent()}}}C.define();return C});