/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/core/Configuration","sap/ui/core/Control","sap/ui/Device","sap/ui/base/ManagedObject","sap/ui/core/delegate/ScrollEnablement","./ObjectPageSectionBase","./ObjectPageSection","./ObjectPageSubSection","./ObjectPageHeaderContent","./LazyLoading","./ObjectPageLayoutABHelper","./ThrottledTaskHelper","sap/m/ScrollBar","sap/ui/core/library","./library","./ObjectPageLayoutRenderer","sap/base/Log","sap/base/util/array/diff","sap/ui/dom/getScrollbarSize","sap/base/assert","sap/base/util/isEmptyObject","sap/base/util/merge","sap/ui/events/KeyCodes","sap/ui/events/F6Navigation","sap/ui/dom/getFirstEditableInput","sap/ui/core/theming/Parameters",'sap/ui/dom/units/Rem'],function(q,M,R,C,a,D,b,S,O,c,d,e,L,A,T,f,g,l,h,i,j,k,m,n,o,K,F,p,P,r){"use strict";var s=g.TitleLevel;var t=g.AccessibleLandmarkRole;var u=l.ObjectPageSubSectionLayout;var v=["toggleAnchorBar","_moveHeader"];var w=a.extend("sap.uxap.ObjectPageLayout",{metadata:{library:"sap.uxap",properties:{showAnchorBar:{type:"boolean",defaultValue:true},showAnchorBarPopover:{type:"boolean",defaultValue:true},upperCaseAnchorBar:{type:"boolean",defaultValue:true},backgroundDesignAnchorBar:{type:"sap.m.BackgroundDesign",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},enableLazyLoading:{type:"boolean",defaultValue:false},subSectionLayout:{type:"sap.uxap.ObjectPageSubSectionLayout",defaultValue:u.TitleOnTop},sectionTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:s.Auto},useIconTabBar:{type:"boolean",group:"Misc",defaultValue:false},showHeaderContent:{type:"boolean",group:"Misc",defaultValue:true},useTwoColumnsForLargeScreen:{type:"boolean",group:"Appearance",defaultValue:false},showTitleInHeaderContent:{type:"boolean",group:"Appearance",defaultValue:false},showOnlyHighImportance:{type:"boolean",group:"Behavior",defaultValue:false},isChildPage:{type:"boolean",group:"Appearance",defaultValue:false},alwaysShowContentHeader:{type:"boolean",group:"Behavior",defaultValue:false},headerContentPinnable:{type:"boolean",group:"Behavior",defaultValue:true},headerContentPinned:{type:"boolean",group:"Behavior",defaultValue:false},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},showEditHeaderButton:{type:"boolean",group:"Behavior",defaultValue:false},flexEnabled:{type:"boolean",group:"Misc",defaultValue:false},showFooter:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{selectedSection:{type:"sap.uxap.ObjectPageSection",multiple:false}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.uxap.ObjectPageSection",multiple:true,singularName:"section"},headerTitle:{type:"sap.uxap.IHeaderTitle",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},footer:{type:"sap.m.IBar",multiple:false},landmarkInfo:{type:"sap.uxap.ObjectPageAccessibleLandmarkInfo",multiple:false},_anchorBar:{type:"sap.uxap.AnchorBar",multiple:false,visibility:"hidden"},_iconTabBar:{type:"sap.m.IconTabBar",multiple:false,visibility:"hidden"},_headerContent:{type:"sap.uxap.IHeaderContent",multiple:false,visibility:"hidden"},_customScrollBar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{headerContentPinnedStateChange:{parameters:{pinned:{type:"boolean"}}},toggleAnchorBar:{parameters:{fixed:{type:"boolean"}}},sectionChange:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},editHeaderButtonPress:{},navigate:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},subSectionVisibilityChange:{parameters:{visibleSubSections:{type:"object"}}}},dnd:{draggable:false,droppable:true},designtime:"sap/uxap/designtime/ObjectPageLayout.designtime"}});w.HEADER_CALC_DELAY=350;w.DOM_CALC_DELAY=200;w.MAX_SNAP_POSITION_OFFSET=20;w.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;w.TITLE_LEVEL_AS_ARRAY=Object.keys(s);w.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};w.BREAK_POINTS={DESKTOP:1439,TABLET:1024,PHONE:600};w.MEDIA={PHONE:"sapUxAPObjectPageLayout-Std-Phone",TABLET:"sapUxAPObjectPageLayout-Std-Tablet",DESKTOP:"sapUxAPObjectPageLayout-Std-Desktop",DESKTOP_XL:"sapUxAPObjectPageLayout-Std-Desktop-XL"};w.DYNAMIC_HEADERS_MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop",DESKTOP_XL:"sapFDynamicPage-Std-Desktop-XL"};w.DIV="div";w.HEADER="header";w.FOOTER="section";w.FOOTER="section";w.HEADER_CONTENT_PADDING_BOTTOM=r.toPx("1rem");w.SHOW_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterShow";w.HIDE_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterHide";w.NO_NAVIGATION_CLASS_NAME="sapUxAPObjectPageNoNavigation";w.prototype._getFirstEditableInput=function(y){var z=this.getDomRef(y);return p(z);};w.prototype._focusFirstEditableInput=function(y){this._getFirstEditableInput(y).focus();};w._getNextTitleLevelEntry=function(y){var z=w.TITLE_LEVEL_AS_ARRAY.indexOf(y),B=z!==-1,H=B&&(z!==w.TITLE_LEVEL_AS_ARRAY.length-1);if(!B){return s.Auto;}return w.TITLE_LEVEL_AS_ARRAY[H?z+1:z];};w._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap");};w.prototype.init=function(){this.oCore=sap.ui.getCore();this._bFirstRendering=true;this._bDomReady=false;this._bPinned=false;this._bStickyAnchorBar=false;this._bHeaderInTitleArea=false;this._bHeaderExpanded=true;this._bHeaderBiggerThanAllowedHeight=false;this._bDelayDOMBasedCalculations=true;this._iStoredScrollTop=0;this._oStoredScrolledSubSectionInfo={};this._bAllContentFitsContainer=false;this._bIsFooterAanimationGoing=false;this._bInternalAnchorBarVisible=true;this._oVisibleSubSections=0;this._$footerWrapper=[];this._$opWrapper=[];this._$anchorBar=[];this._$titleArea=[];this._$stickyAnchorBar=[];this._$headerContent=[];this._$stickyHeaderContent=[];this._bMobileScenario=false;this._oSectionInfo={};this._aSectionBases=[];this._sScrolledSectionId="";this._iScrollToSectionDuration=600;this._$spacer=[];this.iHeaderContentHeight=0;this.iStickyHeaderContentHeight=0;this.iHeaderTitleHeight=0;this.iHeaderTitleHeightStickied=0;this.iAnchorBarHeight=0;this.iFooterHeight=0;this.iTotalHeaderSize=0;this._iHeaderContentPaddingBottom=0;this._oScrollContainerLastState={};this._iREMSize=parseInt(q("body").css("font-size"));this._iOffset=parseInt(0.25*this._iREMSize);this._iResizeId=null;this._iAfterRenderingDomReadyTimeout=null;this._oABHelper=new A(this);this._initializeScroller();this._attachSnapListeners();};w.prototype.onBeforeRendering=function(){var H,y;this._deregisterScreenSizeListener();if(this._oLazyLoading){this._oLazyLoading.destroy();}this._oLazyLoading=new L(this);this._deregisterCustomEvents();if(!this.getVisible()){return;}if(!this.getSelectedSection()){this._bHeaderExpanded=true;}this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._checkAlwaysShowContentHeader()){this._bHeaderExpanded=true;}this._bHeaderInTitleArea=this._shouldPreserveHeaderInTitleArea();this._createHeaderContent();this._getHeaderContent().setContentDesign(this._getHeaderDesign());this._oABHelper._getAnchorBar().setProperty("upperCase",this.getUpperCaseAnchorBar(),true);this._storeScrollLocation();this._applyUxRules();if(!n(this._oSectionInfo)&&this._bFirstRendering){this._preloadSectionsOnBeforeFirstRendering();this._bFirstRendering=false;}this._bStickyAnchorBar=this._shouldPreserveHeaderInTitleArea();this._handleExpandButtonPressEventLifeCycle(false);this._attachTitlePressHandler();H=this._getHeaderContent();if(H&&H.supportsPinUnpin()){y=this.getHeaderContentPinnable()&&!this.getPreserveHeaderStateOnScroll();this._getHeaderContent().setPinnable(y);if(y){this._attachPinPressHandler();}}this._attachVisualIndicatorsPressHandlers(this._handleDynamicTitlePress,this);if(D.system.desktop){this._attachVisualIndicatorMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);this._attachTitleMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);}if(this.getFooter()&&this._bIsFooterAanimationGoing){this._onToggleFooterAnimationEnd(this.getFooter());}this._$titleArea=[];};w.prototype.setBackgroundDesignAnchorBar=function(B){var y=this.getBackgroundDesignAnchorBar();if(y===B){return this;}this.setProperty("backgroundDesignAnchorBar",B);this._oABHelper._getAnchorBar().setBackgroundDesign(B);return this;};w.prototype.setToggleHeaderOnTitleClick=function(y){var z=this.getHeaderTitle(),B=this.setProperty("toggleHeaderOnTitleClick",y,true);if(!z||!z.supportsToggleHeaderOnTitleClick()){i.warning("Setting toggleHeaderOnTitleClick will not take effect as it is not supported in the ObjectPageHeader, read the API Doc for more information",this);return B;}y=this.getProperty("toggleHeaderOnTitleClick");this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();return B;};w.prototype._attachTitlePressHandler=function(){var y=this.getHeaderTitle();if(x(y)&&!this._bAlreadyAttachedTitlePressHandler){y.attachEvent(w.EVENTS.TITLE_PRESS,this._handleDynamicTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};w.prototype._attachSnapListeners=function(){v.forEach(function(E){this.attachEvent(E,function(){this.fireEvent("_snapChange");});},this);};w.prototype._toggleHeaderVisibility=function(y){var H=this._getHeaderContent();if(x(H)){H.$().toggleClass("sapUxAPObjectPageHeaderContentHidden",!y);}};w.prototype._snapHeader=function(y,U){var I,H=this._getHeaderContent();if(H&&H.supportsPinUnpin()&&this._bPinned){this._unPin(U);H.getAggregation("_pinButton").setPressed(false);y=true;}this._toggleHeaderTitle(false,true);this._toggleHeaderVisibility(y);this._moveAnchorBarToTitleArea();if(y){this._moveHeaderToContentArea();this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout(true);I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));if(I){this._scrollTo(this._getSnapPosition()+1);}return;}this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();};w.prototype._expandHeader=function(y){this._toggleHeaderTitle(true,true);this._toggleHeaderVisibility(true);if(y){this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();return;}this._moveAnchorBarToContentArea();this._moveHeaderToContentArea();this._scrollTo(0,0,0);this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();if(this._isHeaderPinnable()){this._getHeaderContent()._getPinButton().setVisible(!this._headerBiggerThanAllowedToBeExpandedInTitleArea());}};w.prototype._handleDynamicTitlePress=function(){if(!this.getToggleHeaderOnTitleClick()||!this._hasVisibleDynamicTitleAndHeader()){return;}var E=!this._bHeaderExpanded,I,y,z;if(E){I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));y=!this._headerBiggerThanAllowedToBeExpandedInTitleArea()&&(this._shouldPreserveHeaderInTitleArea()||!I);this._expandHeader(y);if(!y){this._scrollTo(0,0);}}else{z=!this._shouldPreserveHeaderInTitleArea()&&(!this._bAllContentFitsContainer||this._headerBiggerThanAllowedToBeExpandedInTitleArea());this._snapHeader(z,true);}this.getHeaderTitle()._getFocusSpan().trigger("focus");};w.prototype._attachPinPressHandler=function(){var H=this._getHeaderContent();if(x(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(w.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};w.prototype._handleExpandButtonPressEventLifeCycle=function(y){var H=this.getHeaderTitle(),z=this._hasDynamicTitle(),E;if(H&&!z){E=H.getAggregation("_expandButton");if(E){E[y?"attachPress":"detachPress"](this._handleExpandButtonPress,this);}}};w.prototype._adjustSelectedSectionByUXRules=function(){var y=this.oCore.byId(this.getSelectedSection()),V=y&&this._sectionCanBeRenderedByUXRules(y);if(!V){if(this._oFirstVisibleSection){y=this._oFirstVisibleSection;this.setAssociation("selectedSection",y.getId(),true);}else{this.setAssociation("selectedSection",null,true);return;}}};w.prototype._sectionCanBeRenderedByUXRules=function(y){if(!(y instanceof O)){return false;}var z=y.getBindingInfo("subSections");if(!z&&(!y.getVisible()||!y._getInternalVisible())){return false;}var B=this._aSectionBases.map(function(E){return E.getId();});return(B.indexOf(y.getId())>-1);};w.prototype._getSectionsToRender=function(){this._adjustSelectedSectionByUXRules();var y=this.oCore.byId(this.getSelectedSection());if(this.getUseIconTabBar()&&y){return[y];}else{return this.getSections();}};w.prototype._preloadSectionsOnBeforeFirstRendering=function(){var y=this._getSectionsToPreloadOnBeforeFirstRendering();this._connectModelsForSections(y);if(this.getEnableLazyLoading()){y.forEach(function(z){this.fireEvent("subSectionPreload",{subSection:z});},this);}};w.prototype._getSectionsToPreloadOnBeforeFirstRendering=function(){var y,z,I;if(!this.getEnableLazyLoading()){return this._getSectionsToRender();}if(this.getUseIconTabBar()){return this._oLazyLoading.getSubsectionsToPreload(this._grepCurrentTabSectionBases());}this._adjustSelectedSectionByUXRules();z=this.oCore.byId(this.getSelectedSection());if(!z||(z===this._oFirstVisibleSection)){return this._oLazyLoading.getSubsectionsToPreload(this._aSectionBases);}I=this.indexOfSection(z);var B=function(E){var G=E.isA("sap.uxap.ObjectPageSection")?E:E.getParent();return this.indexOfSection(G)>=I;}.bind(this);y=this._aSectionBases.filter(B);return this._oLazyLoading.getSubsectionsToPreload(y);};w.prototype._grepCurrentTabSectionBases=function(){var y=[],z,B,E,G;this._adjustSelectedSectionByUXRules();z=this.oCore.byId(this.getSelectedSection());if(z){B=z.getId();this._aSectionBases.forEach(function(H){E=H.getParent();G=E&&E.getId();if(H.getId()===B||G===B){y.push(H);}});}return y;};w.prototype.onAfterRendering=function(){var H=this._getHeaderContent(),y=this.getFooter(),z,W=this._getWidth(this);this._bInvalidatedAndNotRerendered=false;this._iResizeId=R.register(this,this._onUpdateScreenSize.bind(this));this._ensureCorrectParentHeight();if(this._$sectionsContainer){this._$sectionsContainer.off("focusout");this._$sectionsContainer.off("focusin");}this._cacheDomElements();if(this._$sectionsContainer){this._$sectionsContainer.on("focusin",function(){this._skipToNextFastGroup=true;}.bind(this));this._$sectionsContainer.on("focusout",function(){this._skipToNextFastGroup=false;}.bind(this));}if(this._hasDynamicTitle()){this.addStyleClass("sapUxAPObjectPageHasDynamicTitle");}if(W>0){this._updateMedia(W,w.MEDIA);}this._$opWrapper.on("scroll.OPL",this._onScroll.bind(this));if(this._bDomReady&&this.$().parents(":hidden").length===0){this._onAfterRenderingDomReady();}else{if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}this._iAfterRenderingDomReadyTimeout=setTimeout(this._onAfterRenderingDomReady.bind(this),this._getDOMCalculationDelay());}if(H&&H.supportsPinUnpin()){this._updatePinButtonState();}if(y){z=w._getLibraryResourceBundle().getText("FOOTER_ARIA_LABEL");y.$().attr("aria-label",z);}this._handleExpandButtonPressEventLifeCycle(true);};w.prototype._onAfterRenderingDomReady=function(){var y,z,B,W=this._getWidth(this);if(this._bIsBeingDestroyed){return;}this._adjustSelectedSectionByUXRules();y=this.getSelectedSection();z=this.oCore.byId(y);this._iAfterRenderingDomReadyTimeout=null;this._bDomReady=true;this._adjustHeaderHeights();this._initAnchorBarScroll();if(y){if(this.getUseIconTabBar()){this._setSelectedSectionId(y);this._setCurrentTabSection(z);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(z);this._checkSubSectionVisibilityChange();}else{this.scrollToSection(y,0);}}this._toggleScrolling(!this._bAllContentFitsContainer);if(D.system.desktop){this._$opWrapper.on("scroll.OPL",this.onWrapperScroll.bind(this));}this._registerOnContentResize();this.getHeaderTitle()&&this._shiftHeaderTitle();this.getFooter()&&this._shiftFooter();this._setSectionsFocusValues();if(this.getPreserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(!this._bHeaderExpanded){B=!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer;this._snapHeader(B);}this._restoreScrollPosition();this.oCore.getEventBus().publish("sap.ui","ControlForPersonalizationRendered",this);this._updateMedia(W,w.MEDIA);if(this._hasDynamicTitle()){this._updateMedia(W,w.DYNAMIC_HEADERS_MEDIA);}this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();this.fireEvent("onAfterRenderingDOMReady");};w.prototype._toggleScrolling=function(E){if(this._$opWrapper.length){this._$opWrapper.get(0).style.overflowY=E?"auto":"hidden";}};w.prototype._shiftFooter=function(){var $=this.$("footerWrapper"),y=this._calculateShiftOffset();$.css(y.sStyleAttribute,y.iMarginalsOffset+"px");};w.prototype._calculateShiftOffset=function(){var H=0,y=this.oCore.getConfiguration().getRTL()?"left":"right",z=this._hasVerticalScrollBar(),B=this._iOffset,E;if(D.system.desktop){E=k().width;H=E;if(!z){H=0;B+=E;}}return{"sStyleAttribute":y,"iActionsOffset":B,"iMarginalsOffset":H};};w.prototype._getDOMCalculationDelay=function(){return this._bDelayDOMBasedCalculations?w.HEADER_CALC_DELAY:0;};w.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._oLazyLoading){this._oLazyLoading.destroy();this._oLazyLoading=null;}this._deregisterScreenSizeListener();if(this._iContentResizeId){R.deregister(this._iContentResizeId);}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}this._deregisterCustomEvents();this._oFirstVisibleSection=null;this._oFirstVisibleSubSection=null;};w.prototype._getCustomScrollBar=function(){if(!this.getAggregation("_customScrollBar")){var V=new f(this.getId()+"-vertSB",{scrollPosition:0,scroll:this.onCustomScrollerScroll.bind(this),visible:false});this.setAggregation("_customScrollBar",V,true);}return this.getAggregation("_customScrollBar");};w.prototype.onWrapperScroll=function(E){var y=Math.max(E.target.scrollTop,0);if(this._getCustomScrollBar()){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getCustomScrollBar().setScrollPosition(y);}};w.prototype.onCustomScrollerScroll=function(E){var y=Math.max(this._getCustomScrollBar().getScrollPosition(),0);if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;q(this._$opWrapper).scrollTop(y);};w.prototype.setShowOnlyHighImportance=function(V){var y=this.getShowOnlyHighImportance();if(y!==V){this.setProperty("showOnlyHighImportance",V,true);this.getSections().forEach(function(z){z._updateImportance();});}return this;};w.prototype.setIsHeaderContentAlwaysExpanded=function(V){var y=this.getAlwaysShowContentHeader();var z=(D.system.phone||D.system.tablet);if(y!==V){this.setProperty("alwaysShowContentHeader",V,z);}return this;};w.prototype.setShowEditHeaderButton=function(V){var y=this.getShowEditHeaderButton(),H=this.getAggregation("_headerContent");if(y!==V){this.setProperty("showEditHeaderButton",V,true);H&&H.invalidate();}return this;};w.prototype._initializeScroller=function(){if(this._oScroller){return;}this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:false,vertical:true});this._oScroller.setOnAfterScrollToElement(this._onAfterScrollToElement.bind(this));};w.prototype._onAfterScrollToElement=function(){var y=this._$opWrapper.scrollTop(),z=this._bStickyAnchorBar;this._onScroll({target:{scrollTop:y}});if(this._bStickyAnchorBar&&!z&&this._$opWrapper.scrollTop()===y){this._$opWrapper.scrollTop(y-this.iAnchorBarHeight);}};w.prototype.setSelectedSection=function(I){var y,z;if(I instanceof O){I=I.getId();}else if(I!=null&&typeof I!=="string"){m(false,"setSelectedSection(): sId must be a string, an instance of sap.uxap.ObjectPageSection or null");return this;}if(I===this.getSelectedSection()){return this;}if(I===null){this.setAssociation("selectedSection",null,true);this._expandHeader(this._bHeaderInTitleArea);this._selectFirstVisibleSection();return this;}this.scrollToSection(I);y=c._getClosestSection(I);z=(y instanceof c)?y.getId():y;return this.setAssociation("selectedSection",z,true);};w.prototype._selectFirstVisibleSection=function(){if(this.getUseIconTabBar()&&this._oFirstVisibleSection){this._adjustSelectedSectionByUXRules();this._setCurrentTabSection(this._oFirstVisibleSection);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(this._oFirstVisibleSection);this._preloadSectionsOnBeforeScroll(this._oFirstVisibleSection);this._updateSelectionOnScroll(0);this._checkSubSectionVisibilityChange();}else if(this.$().is(":visible")){this._scrollTo(0,0);if(!this._bInvalidatedAndNotRerendered){this._sScrolledSectionId=null;this._updateSelectionOnScroll(0);}}};w.prototype._ensureCorrectParentHeight=function(){if(this._bCorrectParentHeightIsSet){return;}if(this.getParent().getHeight&&["","auto"].indexOf(this.getParent().getHeight())!==-1){this.$().parent().css("height","100%");}this._bCorrectParentHeightIsSet=true;};w.prototype._cacheDomElements=function(){this._$footerWrapper=this.$("footerWrapper");this._$titleArea=this.$("headerTitle");this._$anchorBar=this.$("anchorBar");this._$stickyAnchorBar=this.$("stickyAnchorBar");this._$opWrapper=this.$("opwrapper");this._$spacer=this.$("spacer");this._$headerContent=this.$("headerContent");this._$stickyHeaderContent=this.$("stickyHeaderContent");this._$contentContainer=this.$("scroll");this._$sectionsContainer=this.$("sectionsContainer");this._$skipFastGroupAnchor=this.$("skipFastGroupAnchor");this._oScroller._$Container=this._$opWrapper;this._bDomElementsCached=true;};w.prototype._handleExpandButtonPress=function(E){this._expandHeader(true);};w.prototype._toggleHeaderTitle=function(E,U){var H=this.getHeaderTitle();if(this._$titleArea.length){this._$titleArea.toggleClass("sapUxAPObjectPageHeaderStickied",!E);this._$titleArea.toggleClass("sapUxAPObjectPageHeaderSnappedTitleOnMobile",this._hasDynamicTitleWithSnappedTitleOnMobile()&&!E);}if(E){H&&H.unSnap(U);}else{H&&H.snap(U);}};w.prototype._moveHeaderToTitleArea=function(){this._$headerContent.children().appendTo(this._$stickyHeaderContent);this._bHeaderInTitleArea=true;this.fireEvent("_moveHeader",{fixed:true});this._bSupressModifyOnScrollOnce=true;};w.prototype._moveHeaderToContentArea=function(){if(this._bHeaderInTitleArea){this._$headerContent.append(this._$stickyHeaderContent.children());this._$stickyHeaderContent.children().remove();this._bHeaderInTitleArea=false;this.fireEvent("_moveHeader",{fixed:false});}};w.prototype._updateNavigation=function(){if(this.getShowAnchorBar()){this._oABHelper._buildAnchorBar();}};w.prototype._applyUxRules=function(I){var y,z,V,B,E,G,U,H,J,N,Q,W,X={};y=this.getSections()||[];B=0;G=this.getShowAnchorBar();U=this.getUseIconTabBar();H=null;this._cleanMemory();y.forEach(function(Y){if(!Y.getVisible()){return true;}this._registerSectionBaseInfo(Y);z=Y.getSubSections()||[];V=0;J=null;z.forEach(function(Z){if(!Z.getVisible()){return true;}this._registerSectionBaseInfo(Z);E=Z.getVisibleBlocksCount();if(E===0){Z._setInternalVisible(false,I);i.info("ObjectPageLayout :: noVisibleBlock UX rule matched","subSection "+Z.getTitle()+" forced to hidden");}else{Z._setInternalVisible(true,I);X[Z.getId()]=true;V++;if(!J){J=Z;}if(this._shouldApplySectionTitleLevel(Z)){Z._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(Z),I);}}},this);if(V==0){Y._setInternalVisible(false,I);i.info("ObjectPageLayout :: noVisibleSubSection UX rule matched","section "+Y.getTitle()+" forced to hidden");}else{Y._setInternalVisible(true,I);X[Y.getId()]=true;if(!H){H=Y;W=V;}if(this.getSubSectionLayout()===u.TitleOnTop&&V===1&&J.getTitle().trim()!==""){i.info("ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched","section "+Y.getTitle()+" is taking its single subsection title "+J.getTitle());Y._setInternalTitle(J.getTitle(),I);X[J.getId()]=false;J._setBorrowedTitleDomId(Y.getId()+"-title");}else{Y._setInternalTitle("",I);}if(V===1&&!J.getTitle().trim()){J._setBorrowedTitleDomId(Y.getId()+"-title");}if(this._shouldApplySectionTitleLevel(Y)){Y._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(Y),I);}B++;}if(U){X[Y.getId()]=false;}},this);if(B<=1){G=false;i.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched","anchorBar forced to hidden");if(U&&H){X[H.getId()]=true;}}else if(H&&G){N=true;X[H.getId()]=false;i.info("ObjectPageLayout :: firstSectionTitleHidden UX rule matched","section "+H.getTitle()+" title forced to hidden");}this.toggleStyleClass(w.NO_NAVIGATION_CLASS_NAME,B<=1);Object.keys(X).forEach(function(Y){this.oCore.byId(Y)._setInternalTitleVisible(X[Y],I);}.bind(this));if(G){this._oABHelper._buildAnchorBar();}this._setInternalAnchorBarVisible(G,I);this._oFirstVisibleSection=H;this._oFirstVisibleSubSection=this._getFirstVisibleSubSection(H);this._bAllContentFitsContainer=(B===1)&&(V===1)&&this._oFirstVisibleSubSection.hasStyleClass(d.FIT_CONTAINER_CLASS);if(N&&(W===1)){Q=this.getAggregation("_anchorBar").getContent();if(Q.length){this._oFirstVisibleSubSection._setBorrowedTitleDomId(Q[0].getId()+"-content");}}this._checkSubSectionVisibilityChange();};w.prototype._checkSubSectionVisibilityChange=function(){var U=this.getUseIconTabBar(),y=U&&sap.ui.getCore().byId(this.getSelectedSection()),z=y?[y]:this._getVisibleSections(),V={},I;z.forEach(function(B){B.getSubSections().forEach(function(E){I=E.getVisible()&&E._getInternalVisible();if(I){V[E.getId()]=E;}});});if(j(Object.keys((this._oVisibleSubSections)),Object.keys(V)).length){this._oVisibleSubSections=V;this.fireEvent("subSectionVisibilityChange",{visibleSubSections:V});}};w.prototype.setUseIconTabBar=function(V){var y=this.getUseIconTabBar();if(V!=y){this._applyUxRules();}this.setProperty("useIconTabBar",V);return this;};w.prototype.onsapskipforward=function(E){if(this._skipToNextFastGroup){this._handleGroupNavigation(E,true);}};w.prototype.onsapskipback=function(E){if(this._skipToNextFastGroup){this._handleGroupNavigation(E,false);}};w.prototype._handleGroupNavigation=function(E,y){var z={target:y?this._$skipFastGroupAnchor[0]:this._$sectionsContainer[0]};E.type="keydown";F.handleF6GroupNavigation(E,z);};w.prototype._setCurrentTabSection=function(y,I){if(!y){return;}var z;if(y instanceof sap.uxap.ObjectPageSubSection){z=y;y=y.getParent();}else{z=this._getFirstVisibleSubSection(y);}if(this._oCurrentTabSection!==y){this._renderSection(y);this._oCurrentTabSection=y;}this._oCurrentTabSubSection=z;};w.prototype._renderSection=function(y){var $=this.$().find(".sapUxAPObjectPageContainer"),z;if(y&&$.length){z=this.oCore.createRenderManager();this.getSections().forEach(function(B){if((B.getId()===y.getId())){z.renderControl(y);}else{z.cleanupControlWithoutRendering(B);}});z.flush($[0]);z.destroy();}};w.prototype.setShowAnchorBarPopover=function(V,y){var z=this.getProperty("showAnchorBarPopover"),V=this.validateProperty("showAnchorBarPopover",V),B=this.getSelectedSection();if(V===z){return this;}this._oABHelper._getAnchorBar().setShowPopover(V);this._oABHelper._buildAnchorBar();this._setSelectedSectionId(B);return this.setProperty("showAnchorBarPopover",V,true);};w.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible;};w.prototype._setInternalAnchorBarVisible=function(V,I){if(V!=this._bInternalAnchorBarVisible){this._bInternalAnchorBarVisible=V;if(I===true){this.invalidate();}}};w.prototype.setUpperCaseAnchorBar=function(V){this._oABHelper._getAnchorBar().setProperty("upperCase",V);return this.setProperty("upperCaseAnchorBar",V,true);};w.prototype._requestAdjustLayout=function(I){if(!this._oLayoutTask){this._oLayoutTask=new T(this._updateScreenHeightSectionBasesAndSpacer,w.DOM_CALC_DELAY,this);}if(!I){i.debug("ObjectPageLayout :: _requestAdjustLayout","delayed by "+w.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oLayoutTask.reSchedule(I,{}).catch(function(y){});};w.prototype._requestAdjustLayoutAndUxRules=function(I){this._setSectionInfoIsDirty(true);if(!this._oUxRulesTask){this._oUxRulesTask=new T(this._adjustLayoutAndUxRules,w.DOM_CALC_DELAY,this);}if(!I){i.debug("ObjectPageLayout :: _requestAdjustLayoutAndUxRules","delayed by "+w.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oUxRulesTask.reSchedule(I,{}).catch(function(y){});};w.prototype._adjustLayoutAndUxRules=function(){var y,z;i.debug("ObjectPageLayout :: _requestAdjustLayout","refreshing ux rules");this._applyUxRules(true);this._adjustSelectedSectionByUXRules();y=this.getSelectedSection();z=this.oCore.byId(y);if(z){this._setSelectedSectionId(y);if(this.getUseIconTabBar()){this._setCurrentTabSection(z);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(z);}this._requestAdjustLayout(true).then(function(B){if(B){this._oLazyLoading.doLazyLoading();}this._adjustSelectedSectionByUXRules();y=this.getSelectedSection();if(!this._isClosestScrolledSection(y)||this._oScroller._$Container.is(":animated")){this.scrollToSection(y,null,0,false,true);}}.bind(this));}};w.prototype._isClosestScrolledSection=function(y){var z=this._$opWrapper.length>0?this._$opWrapper.scrollTop():0,B=this.iScreenHeight,E=this._getClosestScrolledSectionId(z,B);return E&&(y===E);};w.prototype._setSelectedSectionId=function(y){var z=this.getAggregation("_anchorBar"),B=y&&this._oSectionInfo[y];if(!B){return;}if(z&&B.buttonId){z.setSelectedButton(B.buttonId);this.setAssociation("selectedSection",y,true);}};w.prototype.isFirstRendering=function(){return this._bFirstRendering;};w.prototype._cleanMemory=function(){var y=this.getAggregation("_anchorBar");if(y){y._resetControl();}this._oSectionInfo={};this._aSectionBases=[];};w.prototype._registerSectionBaseInfo=function(y){this._oSectionInfo[y.getId()]={$dom:[],positionTop:0,buttonId:"",isSection:(y instanceof c),sectionReference:y};this._aSectionBases.push(y);};w.prototype._triggerVisibleSubSectionsEvents=function(){this._bDelayDOMBasedCalculations=false;if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading._triggerVisibleSubSectionsEvents();}};w.prototype.scrollToSection=function(I,y,z,B,E){var G=this.oCore.byId(I),H,J,N=(sap.ui.getCore().getConfiguration().getAnimationMode()!==C.AnimationMode.none),Q;if(!this.getDomRef()){i.warning("scrollToSection can only be used after the ObjectPage is rendered",this);return;}if(!G){i.warning("scrollToSection aborted: unknown section",I,this);return;}if(!this._oSectionInfo[I]||!G._getInternalVisible()){i.warning("scrollToSection aborted: section is hidden by UX rules",I,this);return;}if(this.bIsDestroyed){i.debug("ObjectPageLayout :: scrollToSection","scrolling canceled as page is being destroyed");return;}if(this.getUseIconTabBar()){var U=c._getClosestSection(G);var W=this._bAllContentFitsContainer,V;this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(U);this._toggleScrolling(!this._bAllContentFitsContainer);V=this._bAllContentFitsContainer!==W;if(V&&!this._bHeaderExpanded){this._snapHeader(!this._bAllContentFitsContainer);this._bSupressModifyOnScrollOnce=true;}if(this._oCurrentTabSection){this._oCurrentTabSection._allowPropagationToLoadedViews(false);}U._allowPropagationToLoadedViews(true);this._setCurrentTabSection(G);this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[U.getId()].buttonId);this.setAssociation("selectedSection",U.getId(),true);this._checkSubSectionVisibilityChange();}J=G instanceof d?G:this._getFirstVisibleSubSection(G);if(B){this.fireNavigate({section:c._getClosestSection(G),subSection:J});}if(this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();}z=z||0;G._expandSection();this._requestAdjustLayout(true);y=this._computeScrollDuration(y,G);var X=this._computeScrollPosition(G);if(this._sCurrentScrollId!=I||E){this._sCurrentScrollId=I;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);if(this._$contentContainer){this._$contentContainer.parent().stop(true,false);}}if(this._bDomElementsCached){this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;}.bind(this),y);}this._preloadSectionsOnBeforeScroll(G);this.getHeaderTitle()&&this._shiftHeaderTitle();X+=z;if(!this._bStickyAnchorBar&&this._shouldSnapHeaderOnScroll(X)){H=this._getSnapPosition();this._scrollTo(H,0);if(H===0){this._toggleHeader(true);}}Q=N&&y&&this.getEnableLazyLoading();this._scrollTo(X,y,Q);}};w.prototype.onAnchorBarTabPress=function(E){var y=sap.ui.getCore().byId(E.getParameter("sectionBaseId")),I=y instanceof l.ObjectPageSubSection,z,B;if(!y){return;}z=I?y.getParent():y;B=I?y:this._getFirstVisibleSubSection(y);this.setDirectScrollingToSection(z.getId());this.scrollToSection(y.getId(),null,0,true);z.setAssociation("selectedSubSection",B,true);this.setAssociation("selectedSection",z,true);};w.prototype._hasSingleVisibleFullscreenSubSection=function(y){var V=y.getSubSections().filter(function(z){return z.getVisible()&&z._getInternalVisible()&&(z.getBlocks().length>0);});return(V.length===1)&&V[0].hasStyleClass(d.FIT_CONTAINER_CLASS);};w.prototype._computeScrollDuration=function(y,z){var B=parseInt(y);B=B>=0?B:this._iScrollToSectionDuration;if(this.getUseIconTabBar()&&((z instanceof c)||this._isFirstVisibleSectionBase(z))&&this._bStickyAnchorBar){B=0;}return B;};w.prototype._computeScrollPosition=function(y){var z=this._oSectionInfo[y.getId()].positionTop,E=!this._bStickyAnchorBar;if(E&&this._isFirstVisibleSectionBase(y)){z=0;}return z;};w.prototype._preloadSectionsOnBeforeScroll=function(y){var I=y.getId(),z;if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()){z=(y instanceof c)?y:y.getParent();this._connectModelsForSections([z]);}if(this.getEnableLazyLoading()){var B=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;z=this._oLazyLoading.getSubsectionsToPreload(B,I);if(D.system.desktop){setTimeout(function(){this._connectModelsForSections(z);}.bind(this),50);}else{this._connectModelsForSections(z);}z.forEach(function(E){this.fireEvent("subSectionEnteredViewPort",{subSection:E});},this);}};w.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId;};w.prototype.setDirectScrollingToSection=function(y){this.sDirectSectionId=y;};w.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId;};w.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null;};w.prototype._scrollTo=function(y,z,B){if(this._oScroller&&this._bDomReady&&!this._bSuppressScroll){i.debug("ObjectPageLayout :: scrolling to "+y);if((z===0)&&this._shouldSnapHeaderOnScroll(y)){this._toggleHeader(true);}if(B&&this._oLazyLoading){this._oLazyLoading.suppress();this._oScroller.scrollTo(0,y,z,this._resumeLazyLoading.bind(this));}else{this._oScroller.scrollTo(0,y,z);}}return this;};w.prototype._resumeLazyLoading=function(){if(this._oLazyLoading){this._oLazyLoading.resume();this._oLazyLoading.lazyLoadDuringScroll(true);}};w.prototype._scrollBelowCollapseVisualIndicator=function(){var H=this._getHeaderContent(),$,y,V,z;if(!x(H)||!x(this._$opWrapper)){return;}$=H._getCollapseButton().getDomRef();y=$.getBoundingClientRect().height;V=this._$opWrapper[0].getBoundingClientRect().height;z=$.offsetTop+y-V;this._scrollTo(z);};w.prototype._updateMedia=function(W,y){if(!W){return;}var U=function(z){Object.keys(y).forEach(function(E){var G=y[E],H=z===G;this.toggleStyleClass(G,H);},this);}.bind(this),B=w.BREAK_POINTS;if(W<=B.PHONE){U(y.PHONE);}else if(W<=B.TABLET){U(y.TABLET);}else if(W<=B.DESKTOP){U(y.DESKTOP);}else{U(y.DESKTOP_XL);}};w.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var y,z,B,E,G,H,I=this._bHeaderInTitleArea||!this._bHeaderExpanded,J,N,Q,U=this.getDomRef(),V=this.getUseIconTabBar();if(!U||!this._bDomReady){return false;}i.debug("ObjectPageLayout :: _updateScreenHeightSectionBasesAndSpacer","re-evaluating dom positions");this.iScreenHeight=this._getDOMRefHeight(U);if(this.iScreenHeight===0){return;}this.iFooterHeight=this._getFooterHeight();var W=-1,X=this._$sectionsContainer.position().top;this._aSectionBases.forEach(function(Y){var Z=this._oSectionInfo[Y.getId()],$=Y.$(),_,a1=false;if(!Z||!$.length){return;}if(!Z.isSection){W++;}Z.$dom=$;var b1=$.position().top;Z.positionTop=Math.ceil(b1);if(!Z.isSection&&(_=Y.getParent())){a1=Y._getTitleDomId()===_.getId()+"-title";if(a1){var c1=_.$().position().top;Z.positionTop=Math.ceil(c1);}}if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){Z.positionTop-=this.iAnchorBarHeight;}Z.sectionReference.toggleStyleClass("sapUxAPObjectPageSubSectionPromoted",a1);if(this._bMobileScenario){var d1=this.oCore.byId(Y.getId()).getParent();if(d1 instanceof c&&d1._getIsHidden()){return;}if(G){this._oSectionInfo[G].positionBottom=Z.positionTop;}G=Y.getId();z=Y;}else{if(Z.isSection){if(G){this._oSectionInfo[G].positionBottom=Z.positionTop;if(E){this._oSectionInfo[E].positionBottom=Z.positionTop;}}G=Y.getId();E=null;}else{if(E){this._oSectionInfo[E].positionBottom=Z.positionTop;}E=Y.getId();z=Y;}}if(!Z.isSection){N=V||(Y.getParent()===this._oFirstVisibleSection);J=N&&(W===0);Q=Y.hasStyleClass(d.FIT_CONTAINER_CLASS);Y._setHeight(this._computeSubSectionHeight(J,Q,Math.ceil(b1),X));}},this);if(z){y=this._computeLastVisibleHeight(z);if(this._bMobileScenario&&G){this._oSectionInfo[G].positionBottom=this._oSectionInfo[G].positionTop+y;}else{if(E){this._oSectionInfo[E].positionBottom=this._oSectionInfo[E].positionTop+y;}if(G&&E){this._oSectionInfo[G].positionBottom=this._oSectionInfo[E].positionTop+y;}}H=this._bStickyAnchorBar||(W>0)||this._checkContentBottomRequiresSnap(z);if(this._bAllContentFitsContainer){H=false;}if(H&&!this._shouldPreserveHeaderInTitleArea()){I=true;}B=this._computeSpacerHeight(z,y,H,I);this._$spacer.height(B+"px");i.debug("ObjectPageLayout :: bottom spacer is now "+B+"px");o(this._oScrollContainerLastState,{iScrollableContentLength:Math.round(this._getScrollableContentLength()),iSpacerHeight:B});}this._updateCustomScrollerHeight(I);this._setSectionInfoIsDirty(false);return true;};w.prototype._computeSubSectionHeight=function(y,z,B,E){var G,H;if(!z){return"";}var I=(this._bAllContentFitsContainer)?this._bHeaderExpanded:y;G=this._getSectionsContainerHeight(I);if(this._bAllContentFitsContainer){H=(B-E)+this.iFooterHeight;G-=H;}return G+"px";};w.prototype._updateCustomScrollerHeight=function(y){if(D.system.desktop&&this.getAggregation("_customScrollBar")){var z=this._computeScrollableContentSize(y);z+=this._getStickyAreaHeight(y);this._getCustomScrollBar().setContentSize(z+"px");var B=(z>Math.ceil(this.iScreenHeight)),V=(B!==this._getCustomScrollBar().getVisible());if(V){this._getCustomScrollBar().setVisible(B);this.getHeaderTitle()&&this._shiftHeaderTitle();}}};w.prototype._computeScrollableContentSize=function(y){var z=0;if(this._$contentContainer&&this._$contentContainer.length){z=this._$contentContainer[0].scrollHeight;}if(!this._bStickyAnchorBar&&y){z-=this.iAnchorBarHeight;}if(this._bStickyAnchorBar&&!y){z+=this.iAnchorBarHeight;}return z;};w.prototype._computeLastVisibleHeight=function(y){var I=this._bStickyAnchorBar||this._bHeaderInTitleArea;var z=this._getSectionPositionTop(y,I);return this._$spacer.position().top-z;};w.prototype._getStickyAreaHeight=function(I){if(I){return this.iHeaderTitleHeightStickied+this.iAnchorBarHeight;}return this.iHeaderTitleHeight;};w.prototype._getScrollableViewportHeight=function(I){return this.getDomRef().getBoundingClientRect().height-this._getStickyAreaHeight(I);};w.prototype._getSectionsContainerHeight=function(I){var y=!I,z=this._getScrollableViewportHeight(y);if(!y&&!this._bHeaderInTitleArea){z-=(this.iHeaderContentHeight+this.iAnchorBarHeight);}return z;};w.prototype._getSectionPositionTop=function(y,z){var B=this._oSectionInfo[y.getId()].positionTop;if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){B+=this.iAnchorBarHeight;}return B;};w.prototype._getSectionPositionBottom=function(y,z){var B=this._oSectionInfo[y.getId()].positionBottom;if(!z){B+=this.iAnchorBarHeight;}return B;};w.prototype._determineSectionBaseInternalTitleLevel=function(y){var z=this.getSectionTitleLevel(),I=y instanceof c;if(z===s.Auto){return I?s.H3:s.H4;}return I?z:w._getNextTitleLevelEntry(z);};w.prototype._shouldApplySectionTitleLevel=function(y){return y.getTitleLevel()===s.Auto;};w.prototype._checkContentBottomRequiresSnap=function(y){var z=false;return this._getSectionPositionBottom(y,z)>(this._getScrollableViewportHeight(z)+this._getSnapPosition());};w.prototype._computeSpacerHeight=function(y,z,B,E){var G,H;if(Object.keys(this._oVisibleSubSections).length===1&&this._bHeaderExpanded){G=0;}else{H=this._getScrollableViewportHeight(E);if(B){H=Math.ceil(H);z=Math.floor(z);}else{z=this._$spacer.position().top;}if(z<H){G=H-z;}else{G=0;}}if((this.iFooterHeight>G)){G+=this.iFooterHeight;}return G;};w.prototype._isFirstVisibleSectionBase=function(y){var z,B,E,G=this.getSelectedSection(),U=this.getUseIconTabBar();if(!y||!y.getParent()){return;}z=y.getId();if(U&&(z===G)){return true;}if(U&&(y.getParent().getId()===G)){B=sap.ui.getCore().byId(G);E=this._getFirstVisibleSubSection(B);return E&&(E.getId()===z);}if(this._oFirstVisibleSection&&this._oFirstVisibleSubSection){return z===this._oFirstVisibleSection.getId()||z===this._oFirstVisibleSubSection.getId();}return false;};w.prototype._getFirstVisibleSubSection=function(y){if(!y){return;}var z;this._aSectionBases.every(function(B){if(B.getParent()&&(B.getParent().getId()===y.getId())){z=B;return false;}return true;});return z;};w.prototype._initAnchorBarScroll=function(){var y=this.oCore.byId(this.getSelectedSection()),z;this._requestAdjustLayout(true);z=y?this._computeScrollPosition(y):0;this._sScrolledSectionId="";this._sCurrentScrollId="";this._onScroll({target:{scrollTop:z}},true);};w.prototype._setAsCurrentSection=function(y){var z,B,E;if(this._sScrolledSectionId===y){return;}i.debug("ObjectPageLayout :: current section is "+y);this._sScrolledSectionId=y;z=this.getAggregation("_anchorBar");if(z&&this._getInternalAnchorBarVisible()){B=this.oCore.byId(y);E=B&&B instanceof d&&(B.getTitle().trim()===""||!B._getInternalTitleVisible()||B.getParent()._getIsHidden());if(E){y=B.getParent().getId();i.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent "+y);}if(B&&this._oSectionInfo[y]){z.setSelectedButton(this._oSectionInfo[y].buttonId);this.setAssociation("selectedSection",c._getClosestSection(y).getId(),true);this._setSectionsFocusValues(y);}}};w.prototype._registerOnContentResize=function(){var $=this._$contentContainer.length&&this._$contentContainer[0];if(!$){return;}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}this._iContentResizeId=R.register($,this._onUpdateContentSize.bind(this));};w.prototype._onUpdateContentSize=function(E){var y,z=E.size,B=E.oldSize;if(z.height===0||z.width===0){i.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(this.getPreserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}this._adjustHeaderHeights();this._requestAdjustLayout(true);if(B.height>0||B.width>0){y=this._$opWrapper.scrollTop();this._updateSelectionOnScroll(y);}};w.prototype._onUpdateScreenSize=function(E){var y=this.getHeaderTitle(),H=this._getHeaderContent(),z=E.size.width,B=E.size.height,G=E.oldSize.height,I=(B!==G),J,N=H&&H.supportsAlwaysExpanded()&&this.getAlwaysShowContentHeader();if(E.size.height===0||E.size.width===0){i.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(!this._bDomReady){i.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");return;}this._oLazyLoading.setLazyLoadingParameters();setTimeout(function(){if(N&&(this._bHeaderInTitleArea!=this._checkAlwaysShowContentHeader())){this.invalidate();}if(this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){if(this._isHeaderPinnable()){this._updatePinButtonState();}this._expandHeader(false);this._scrollTo(0,0);}else if(this._isHeaderPinnable()&&!this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._updatePinButtonState();}if(y&&y.isDynamic()){y._onResize(z);this._updateMedia(z,w.DYNAMIC_HEADERS_MEDIA);}this._updateMedia(z,w.MEDIA);this._adjustHeaderHeights();this._requestAdjustLayout(true);if(this.getFooter()&&this.getShowFooter()){this._shiftFooter();}J=this.getSelectedSection();if((G===0)&&I&&!this._isClosestScrolledSection(J)){J!==null?this.scrollToSection(J,0):this._selectFirstVisibleSection();}this._scrollTo(this._$opWrapper.scrollTop(),0);if((G===0)&&I&&this.getEnableLazyLoading()&&this._oLazyLoading&&!this._bDelayDOMBasedCalculations){this._oLazyLoading.doLazyLoading();}}.bind(this),this._getDOMCalculationDelay());};w.prototype._onUpdateHeaderTitleSize=function(E){if(E.size.height===0||E.size.width===0){i.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){i.info("ObjectPageLayout :: cannot _onUpdateTitleSize before dom is ready");return;}this._adjustHeaderHeights();this._requestAdjustLayout();};w.prototype._applyContextualSettings=function(y){var z=y.contextualWidth;if(this._hasDynamicTitle()){this._updateMedia(z,w.DYNAMIC_HEADERS_MEDIA);}this._updateMedia(z,w.MEDIA);return b.prototype._applyContextualSettings.call(this,y);};w.prototype._shouldSnapHeaderOnScroll=function(y){return(y>0)&&(y>=this._getSnapPosition())&&!this._shouldPreserveHeaderInTitleArea();};w.prototype._getScrollableContentLength=function(){return this._$contentContainer.length?this._getDOMRefHeight(this._$contentContainer[0]):0;};w.prototype._isContentScrolledToBottom=function(){return this._oScrollContainerLastState.iScrollableContentLength<=(this._oScrollContainerLastState.iScrollTop+this._oScrollContainerLastState.iScrollableViewportHeight);};w.prototype._isContentLengthDecreased=function(y){if(y){return((y.iScrollableContentLength>this._oScrollContainerLastState.iScrollableContentLength)&&(y.iSpacerHeight===this._oScrollContainerLastState.iSpacerHeight));}};w.prototype._canReachScrollTop=function(y,E){var z;E=E||0;z=this._oScrollContainerLastState.iScrollableContentLength+E-this._oScrollContainerLastState.iScrollableViewportHeight;return z>=y;};w.prototype._deregisterCustomEvents=function(){if(this._$opWrapper.length){this._$opWrapper.off(".OPL");}};w.prototype._deregisterScreenSizeListener=function(){if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}};w.prototype._onScroll=function(E,I){var y=Math.max(Math.ceil(E.target.scrollTop),0),$=this._$opWrapper.length&&this._$opWrapper[0],z=this._$spacer.length&&this._$spacer[0],B=z.offsetHeight,G,H=this.getHeaderTitle(),J=this._shouldSnapHeaderOnScroll(y),N=this._shouldPreserveHeaderInTitleArea(),Q=false,U=this._oScrollContainerLastState;this._oScrollContainerLastState={iScrollTop:y,iScrollableContentLength:Math.round(this._getScrollableContentLength()),iScrollableViewportHeight:$.offsetHeight,iSpacerHeight:B};if(this._bSupressModifyOnScrollOnce){this._bSupressModifyOnScrollOnce=false;return;}if(!$||!z){return;}G=this.iScreenHeight;if(G===0){return;}if(this._getSectionInfoIsDirty()){return;}if(U&&this._isContentScrolledToBottom()&&this._isContentLengthDecreased(U)){var V=U.iScrollableContentLength-this._oScrollContainerLastState.iScrollableContentLength;if(!this._canReachScrollTop(U.iScrollTop)&&this._canReachScrollTop(U.iScrollTop,V)){var W=U.iScrollTop+this._oScrollContainerLastState.iScrollableViewportHeight,X=this._oScrollContainerLastState.iScrollableContentLength,Y=W-X,Z;if(Y>0){Z=B+Y;this._$spacer.height(Z+"px");this._scrollTo(U.iScrollTop);return;}}}if(J&&!N){G-=(this.iAnchorBarHeight+this.iHeaderTitleHeightStickied);}if(this._bHeaderInTitleArea&&!N){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._requestAdjustLayout();}if(!N&&((H&&this.getShowHeaderContent())||this.getShowAnchorBar())){this._toggleHeader(J,!!(E&&E.type==="scroll"));}if(!N){this._adjustHeaderTitleBackgroundPosition(y);}i.debug("ObjectPageLayout :: lazy loading : Scrolling at "+y,"----------------------------------------");this._updateSelectionOnScroll(y);if(this.getEnableLazyLoading()){this._oLazyLoading.lazyLoadDuringScroll(I,y,E.timeStamp,G);}if(H&&H.supportsTitleInHeaderContent()&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&H.getShowTitleSelector()){if(y===0){this.$("scroll").css("z-index","1000");Q=false;}else if(!Q){Q=true;this.$("scroll").css("z-index","0");}}};w.prototype._updateSelectionOnScroll=function(y){var z=this.iScreenHeight,B,E;if(z===0){return;}B=this._getClosestScrolledSectionId(y,z);E=this._getClosestScrolledSectionId(y,z,true);if(B){var G=this.getDirectScrollingToSection();if(B!==this._sScrolledSectionId){i.debug("ObjectPageLayout :: closest id "+B,"----------------------------------------");var G=this.getDirectScrollingToSection();if(G&&G!==B){return;}this.clearDirectScrollingToSection();this._setAsCurrentSection(B);}else if(B===this.getDirectScrollingToSection()){this.clearDirectScrollingToSection();}if(E!==this._sScrolledSubSectionId){var H=c._getClosestSection(B),I=this.oCore.byId(E);this._sScrolledSubSectionId=E;this.fireEvent("_sectionChange",{section:H,subSection:I});this.fireEvent("sectionChange",{section:H,subSection:I});}}};w.prototype._getSnapPosition=function(){var y=this.iHeaderContentHeight,z=this._getTitleHeightDelta();y-=Math.max(z,this._iHeaderContentPaddingBottom);return y;};w.prototype._getTitleHeightDelta=function(){var y=this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight;y=Math.max(y,0);y=Math.min(y,w.MAX_SNAP_POSITION_OFFSET);return y;};w.prototype._getClosestScrolledSectionId=function(y,z,B){B=!!B;y=Math.ceil(y);var E=y+z,G,H=B||this._bMobileScenario;q.each(this._oSectionInfo,function(I,J){var N,Q,U,V,W,X=this.getSelectedSection();N=this.oCore.byId(I);if(!N){return;}Q=N.getParent();U=Q instanceof c&&Q._getIsHidden();if(this.getUseIconTabBar()&&X){W=this.oCore.byId(X);if(!W){return;}if(J.isSection&&J.sectionReference!=W){return true;}if(!J.isSection&&W.indexOfSubSection(J.sectionReference)<0){return true;}}if(J.isSection||(H&&!U)){if(!G&&(J.sectionReference._getInternalVisible()===true)){V=this._getFirstVisibleSubSection(J.sectionReference);if(J.isSection&&B&&V){G=V.getId();}else{G=I;}}if(J.isSection&&B){return true;}if(J.positionTop<=E&&y<=J.positionBottom){if(J.positionTop<=y&&J.positionBottom>y){G=I;return false;}}}}.bind(this));return G;};w.prototype._toggleHeader=function(y,U){var H;if(y===this._bStickyAnchorBar){return;}H=this.getHeaderTitle();if(!this._shouldPreserveHeaderInTitleArea()&&!this._bHeaderInTitleArea){this._toggleHeaderTitle(!y,U);}if(!this._bStickyAnchorBar&&y){this._restoreFocusAfter(this._moveAnchorBarToTitleArea);H&&H.snap();this._bHeaderExpanded=false;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();}else if(this._bStickyAnchorBar&&!y){this._restoreFocusAfter(this._moveAnchorBarToContentArea);H&&H.unSnap();this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();if(this._isHeaderPinnable()){this._getHeaderContent()._getPinButton().setVisible(!this._headerBiggerThanAllowedToBeExpandedInTitleArea());}}};w.prototype._restoreFocusAfter=function(y){var z=this.oCore.byId(this.oCore.getCurrentFocusedControlId());y.call(this);if(D.system.phone!==true){if(!this.oCore.byId(this.oCore.getCurrentFocusedControlId())){z&&z.$().trigger("focus");}}return this;};w.prototype._moveAnchorBarToTitleArea=function(){this._$anchorBar.children().appendTo(this._$stickyAnchorBar);this._toggleHeaderStyleRules(true);if(this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied){this._adjustHeaderBackgroundSize();}return this;};w.prototype._moveAnchorBarToContentArea=function(){if(!this._shouldPreserveHeaderInTitleArea()){var y=this._$opWrapper.scrollTop();this._$anchorBar.css("height","auto").append(this._$stickyAnchorBar.children());this._$opWrapper.scrollTop(y);this._toggleHeaderStyleRules(false);}return this;};w.prototype._toggleHeaderStyleRules=function(y){y=!!y;var V=y?"hidden":"inherit";this._bStickyAnchorBar=y;this._$headerContent.css("overflow",V);this._$headerContent.toggleClass("sapContrastPlus",!y);this._$headerContent.toggleClass("sapUxAPObjectPageHeaderDetailsHidden",y);this._$anchorBar.css("visibility",V);if(x(this._$stickyAnchorBar)){this._$stickyAnchorBar.attr("aria-hidden",!y);}this.fireToggleAnchorBar({fixed:y});if(!y&&!this.iAnchorBarHeight){this._requestAdjustLayout();}};w.prototype.getScrollDelegate=function(){return this._oScroller;};w.prototype.setHeaderTitle=function(H,y){if(H&&typeof H.addEventDelegate==="function"){H.addEventDelegate({onAfterRendering:this._onAfterHeaderTitleRendering.bind(this)});}this.setAggregation("headerTitle",H,y);this._oObserver&&this._oObserver.disconnect();this._oObserver=new M(this._onModifyHeaderTitle.bind(this));this._oObserver.observe(H,{aggregations:["headerTitle"],properties:["backgroundDesign"]});if(H){this._createHeaderContent();}if(this._hasDynamicTitle()){this._iHeaderContentPaddingBottom=w.HEADER_CONTENT_PADDING_BOTTOM;}return this;};w.prototype._onAfterHeaderTitleRendering=function(){var H=this.getHeaderTitle(),$=H&&H.$(),y;if(!H||!$.length){return;}y=$.height();if(y!==this._iCachedHeaderTitleHeight){this._adjustHeaderHeights();this._iCachedHeaderTitleHeight=y;}};w.prototype._onModifyHeaderTitle=function(y){var H=this.getAggregation("_headerContent");H&&y.current&&H.setBackgroundDesign(y.current);};w.prototype.invalidate=function(y){this._bInvalidatedAndNotRerendered=true;if(this.getUseIconTabBar()&&y&&(y instanceof c)&&!y.isActive()&&this._oSectionInfo[y.getId()]){return;}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);this._iAfterRenderingDomReadyTimeout=null;}a.prototype.invalidate.apply(this,arguments);};w.prototype._createHeaderContent=function(){var H=this.getHeaderTitle(),y=H&&H.supportsBackgroundDesign()&&H.getBackgroundDesign(),z=this.getAggregation("_headerContent"),B,N;var E=H?H.getCompatibleHeaderContentClass():e;if(!(z instanceof E)){B=this.getAggregation("_headerContent");if(B){B.destroy();}N=E.createInstance(this.getAggregation("headerContent"),this.getShowHeaderContent(),this._getHeaderDesign(),this.getHeaderContentPinnable(),this.getId()+"-OPHeaderContent");y&&N.setBackgroundDesign(y);this.setAggregation("_headerContent",N,true);}};w.prototype._adjustHeaderBackgroundSize=function(){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(!this._shouldPreserveHeaderInTitleArea()){this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight;this._$headerContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}else{this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height();this._$stickyHeaderContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}H.$().css("background-size","100% "+this.iTotalHeaderSize+"px");this._adjustHeaderTitleBackgroundPosition(0);}};w.prototype._adjustHeaderTitleBackgroundPosition=function(y){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(this._bStickyAnchorBar){H.$().css("background-position","0px "+((this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)*-1)+"px");}else{if(this._shouldPreserveHeaderInTitleArea()){H.$().css("background-position","0px 0px");}else{H.$().css("background-position","0px "+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-y)+"px");}}}};w.prototype._adjustHeaderHeights=function(){var y=this.getHeaderTitle(),z=true;if(y&&!y.supportsAdaptLayoutForDomElement()){z=false;}if(this._$titleArea.length>0){this.iHeaderContentHeight=this._$headerContent.length?Math.round(this._getDOMRefHeight(this._$headerContent[0])):0;this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height();this.iAnchorBarHeight=this._bStickyAnchorBar?this._$stickyAnchorBar.outerHeight():this._$anchorBar.outerHeight();if(!this._bHeaderExpanded){this.iHeaderTitleHeightStickied=this._$titleArea.height()-this.iAnchorBarHeight;this.iHeaderTitleHeight=this._obtainExpandedTitleHeight(z);}else{this.iHeaderTitleHeight=this._$titleArea.is(":visible")?this._$titleArea.height():0;this.iHeaderTitleHeightStickied=this._obtainSnappedTitleHeight(z);}this._adjustHeaderBackgroundSize();i.info("ObjectPageLayout :: adjustHeaderHeight","headerTitleHeight: "+this.iHeaderTitleHeight+" - headerTitleStickiedHeight: "+this.iHeaderTitleHeightStickied+" - headerContentHeight: "+this.iHeaderContentHeight);}else{i.debug("ObjectPageLayout :: adjustHeaderHeight","skipped as the objectPageLayout is being rendered");}};w.prototype._appendTitleCloneToDOM=function(E){var $=this.getHeaderTitle().$(),y=$.clone();y.css({left:"-10000px",top:"-10000px",width:$.width()+"px",position:"absolute"});y.toggleClass("sapUxAPObjectPageHeaderStickied",E);y.appendTo(this._$titleArea.parent());if(E){this.getHeaderTitle()&&this.getHeaderTitle()._adaptObjectPageHeaderIndentifierLine(y);}return y;};w.prototype._obtainSnappedTitleHeight=function(V){var y=this.getHeaderTitle(),$,H;if(!y){return 0;}if(V){$=this._appendTitleCloneToDOM(true);H=$.height();$.remove();}else if(y.snap){H=this._obtainTitleHeightViaStateChange(true);}return H;};w.prototype._obtainExpandedTitleHeight=function(V){var y=this.getHeaderTitle(),$,H;if(!y){return 0;}if(V){$=this._appendTitleCloneToDOM(false);H=$.is(":visible")?$.height()-this.iAnchorBarHeight:0;$.remove();}else if(y.unSnap){H=this._obtainTitleHeightViaStateChange(false);}return H;};w.prototype._obtainTitleHeightViaStateChange=function(y){var z=this.getHeaderTitle(),H,B=this._$sectionsContainer.height(),E,G=(y)?z.snap:z.unSnap,I=(y)?z.unSnap:z.snap;G.call(z,false);H=z.$().outerHeight();I.call(z,false);E=this._$sectionsContainer.height();this._adjustSpacerHeightUponUnsnapping(B,E);return H;};w.prototype._adjustSpacerHeightUponUnsnapping=function(y,z){var B;if(y!=z){B=this._$spacer.height()-(z-y);this._$spacer.height(B);}};w.prototype._getHeaderDesign=function(){var H=this.getHeaderTitle(),y=l.ObjectPageHeaderDesign.Light;if(H!=null){y=H.getHeaderDesign();}return y;};w.prototype._getVisibleSections=function(){return this.getSections().filter(function(y){return y.getVisible()&&y._getInternalVisible();});};w.prototype._setSectionsFocusValues=function(y){var z=this._getVisibleSections()||[],$,B='0',N='-1',E="tabindex",G,H=z[0];z.forEach(function(I){$=I.$();if(y===I.getId()){$.attr(E,B);G=I;I._setSubSectionsFocusValues();}else{$.attr(E,N);I._disableSubSectionsFocus();}});if(!G&&z.length>0){H.$().attr(E,B);H._setSubSectionsFocusValues();G=H;}return G;};w.prototype.setShowHeaderContent=function(y){var z=this.getShowHeaderContent(),H;if(z!==y){if(z&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);}this.setProperty("showHeaderContent",y,true);this._updateTitleVisualState();H=this._getHeaderContent();this.$().toggleClass("sapUxAPObjectPageLayoutNoHeaderContent",!y||!H);if(H){H.setProperty("visible",y);}}return this;};w.prototype._headerTitleChangeHandler=function(I){var y;if(!this.getShowTitleInHeaderContent()){return;}if(I){this._getHeaderContent()._destroyObjectImage(true);}y=this.oCore.createRenderManager();this.getRenderer()._rerenderHeaderContentArea(y,this);this._getHeaderContent().invalidate();y.destroy();};w.prototype.getHeaderContent=function(){if(!this._getHeaderContent()){return this.getAggregation("headerContent",[]);}return this._getHeaderContent().getAggregation("content",[]);};w.prototype.insertHeaderContent=function(y,I,z){if(!this._getHeaderContent()){return this.insertAggregation("headerContent",y,I,z);}return this._getHeaderContent().insertAggregation("content",y,I,z);};w.prototype.addHeaderContent=function(y,z){if(!this._getHeaderContent()){return this.addAggregation("headerContent",y,z);}return this._getHeaderContent().addAggregation("content",y,z);};w.prototype.removeAllHeaderContent=function(y){if(!this._getHeaderContent()){return this.removeAllAggregation("headerContent",y);}return this._getHeaderContent().removeAllAggregation("content",y);};w.prototype.removeHeaderContent=function(y,z){if(!this._getHeaderContent()){return this.removeAggregation("headerContent",y,z);}return this._getHeaderContent().removeAggregation("content",y,z);};w.prototype.destroyHeaderContent=function(y){if(!this._getHeaderContent()){return this.destroyAggregation("headerContent",y);}return this._getHeaderContent().destroyAggregation("content",y);};w.prototype.indexOfHeaderContent=function(y){if(!this._getHeaderContent()){return this.indexOfAggregation("headerContent",y);}return this._getHeaderContent().indexOfAggregation("content",y);};w.prototype._getHeaderContent=function(){return this.getAggregation("_headerContent");};w.prototype._getHeaderContentDomRef=function(){var H=this._getHeaderContent();if(!H||!this.getShowHeaderContent()){return null;}if(this._bStickyAnchorBar&&!this._bHeaderInTitleArea){return this.$().find(".sapUxAPObjectPageHeaderTitle .sapUxAPObjectPageHeaderDetails").get(0);}return H.getDomRef();};w.prototype._connectModelsForSections=function(y){y=y||[];y.forEach(function(z){z.connectToModels();});};w.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()};};w.prototype._hasVerticalScrollBar=function(){return(this._getCustomScrollBar().getVisible()===true);};w.prototype._shiftHeaderTitle=function(){var y=this._calculateShiftOffset(),z=y.sStyleAttribute,B=y.iMarginalsOffset;this.$().find(".sapUxAPObjectPageHeaderTitle").css("padding-"+z,B+"px");};w.prototype._isFirstSection=function(y){var z=this._getVisibleSections();if(y===z[0]){return true;}return false;};w.prototype._isValidStoredSubSectionInfo=function(){var y=this.getSelectedSection(),z=this.oCore.byId(y),B;if(!z||!this._oStoredScrolledSubSectionInfo){return false;}B=this.oCore.byId(this._oStoredScrolledSubSectionInfo.sSubSectionId);return B&&this._sectionCanBeRenderedByUXRules(B)&&(z.indexOfSubSection(B)>=0);};w.prototype._restoreScrollPosition=function(){var V=this._isValidStoredSubSectionInfo(),y;if(V){y=this._computeScrollPosition(this.oCore.byId(this._oStoredScrolledSubSectionInfo.sSubSectionId))+this._oStoredScrolledSubSectionInfo.iOffset;this._scrollTo(y,0);}else{this.scrollToSection(this.getSelectedSection(),0);}};w.prototype._storeScrollLocation=function(){if(!this.getDomRef()||!this._bDomReady||!this._oScroller){return;}var y=this._oScroller.getScrollTop(),z=this._getClosestScrolledSectionId(this._oScroller.getScrollTop(),this.iScreenHeight,true),B;if(z){B=y-this._computeScrollPosition(this.oCore.byId(z));}this._iStoredScrollTop=y;this._oStoredScrolledSubSectionInfo={sSubSectionId:z,iOffset:B};this._oCurrentTabSection=null;};w.prototype.onkeyup=function(E){var y,z;if(E.which===K.TAB){y=this.oCore.getCurrentFocusedControlId();z=y&&this.oCore.byId(y);if(z&&this._isFirstSection(z)){this._scrollTo(0,0);}}};w.prototype.setShowFooter=function(y){var z=this.setProperty("showFooter",y,true);this._toggleFooter(y);return z;};w.prototype._toggleFooter=function(y){var U,z=this.getFooter();if(!x(z)||!x(this._$footerWrapper)){return;}U=this.oCore.getConfiguration().getAnimationMode()!==C.AnimationMode.none;if(U){this._toggleFooterAnimation(y,z);}else{this._$footerWrapper.toggleClass("sapUiHidden",!y);}this._requestAdjustLayout();};w.prototype._toggleFooterAnimation=function(y,z){this._$footerWrapper.on("webkitAnimationEnd animationend",this._onToggleFooterAnimationEnd.bind(this,z));this._bIsFooterAanimationGoing=true;if(y){this._$footerWrapper.removeClass("sapUiHidden");}z.toggleStyleClass(w.SHOW_FOOTER_CLASS_NAME,y);z.toggleStyleClass(w.HIDE_FOOTER_CLASS_NAME,!y);};w.prototype._onToggleFooterAnimationEnd=function(y){this._$footerWrapper.off("webkitAnimationEnd animationend");if(y.hasStyleClass(w.HIDE_FOOTER_CLASS_NAME)){this._$footerWrapper.addClass("sapUiHidden");y.removeStyleClass(w.HIDE_FOOTER_CLASS_NAME);}else{y.removeStyleClass(w.SHOW_FOOTER_CLASS_NAME);}this._bIsFooterAanimationGoing=false;};w.prototype.clone=function(){var y,H,z;Object.keys(this.mAggregations).forEach(this._cloneProxiedAggregations,this);y=a.prototype.clone.apply(this,arguments);H=this._getHeaderContent();z=y._getHeaderContent();if(z){z.destroy();}if(H){y.setAggregation("_headerContent",H.clone(),true);}return y;};w.prototype._cloneProxiedAggregations=function(y){var z=this.mAggregations[y];if(Array.isArray(z)&&z.length===0){z=this["get"+y.charAt(0).toUpperCase()+y.slice(1)]();}this.mAggregations[y]=z;};w.prototype._shouldPreserveHeaderInTitleArea=function(){return this._bPinned||this._preserveHeaderStateOnScroll()||this._checkAlwaysShowContentHeader();};w.prototype._checkAlwaysShowContentHeader=function(){return!this._hasDynamicTitle()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader();};w.prototype._headerBiggerThanAllowedToBeFixed=function(){var y=this._getOwnHeight();return this._getEntireHeaderHeight()>w.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*y;};w.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){return this._getEntireHeaderHeight()>=this._getOwnHeight();};w.prototype._getOwnHeight=function(){return this._getHeight(this);};w.prototype._getHeight=function(y){return!(y instanceof a)?0:y.$().outerHeight()||0;};w.prototype._getEntireHeaderHeight=function(){var y=0,H=0,z=this.getHeaderTitle(),B=this._getHeaderContent();if(x(z)){y=z.$().outerHeight();}if(x(B)){H=B.$().outerHeight();}return y+H;};w.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin(true);}else{this._pin(true);this._restorePinButtonFocus();}};w.prototype._restorePinButtonFocus=function(){var H=this._getHeaderContent();if(x(H)&&H.supportsPinUnpin()){H._focusPinButton();}};w.prototype._pin=function(U){if(this._bPinned){return;}this._bPinned=true;if(U){this.setProperty("headerContentPinned",true,true);this.fireEvent("headerContentPinnedStateChange",{pinned:true});}this._toggleHeaderTitle(true);this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._adjustHeaderHeights();this._requestAdjustLayout();this._updateToggleHeaderVisualIndicators();this.addStyleClass("sapUxAPObjectPageLayoutHeaderPinned");};w.prototype._unPin=function(U){if(!this._bPinned){return;}this._bPinned=false;if(U){this.setProperty("headerContentPinned",false,true);this.fireEvent("headerContentPinnedStateChange",{pinned:false});}this._updateToggleHeaderVisualIndicators();this.removeStyleClass("sapUxAPObjectPageLayoutHeaderPinned");};w.prototype._isHeaderPinnable=function(){var H=this._getHeaderContent();return H&&H.supportsPinUnpin()&&H.getPinnable();};w.prototype._shouldPinUnpinHeader=function(){return this._bHeaderExpanded&&!this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedToBeExpandedInTitleArea();};w.prototype._updatePinButtonState=function(){var I=this._isHeaderPinnable(),y=I&&this.getHeaderContentPinned()&&this._shouldPinUnpinHeader(),H=this._getHeaderContent();H._togglePinButton(y);this.$().toggleClass("sapUxAPObjectPageLayoutHeaderPinnable",I);H._getPinButton().setVisible(!this._headerBiggerThanAllowedToBeExpandedInTitleArea());if(y){this._pin();}else{this._unPin();}};w.prototype._preserveHeaderStateOnScroll=function(){return this._hasDynamicTitle()&&this.getPreserveHeaderStateOnScroll()&&!this._bHeaderBiggerThanAllowedHeight;};w.prototype._overridePreserveHeaderStateOnScroll=function(){var y=this._bHeaderBiggerThanAllowedHeight,z;this._bHeaderBiggerThanAllowedHeight=this._headerBiggerThanAllowedToBeFixed();z=y!==this._bHeaderBiggerThanAllowedHeight;if(!this._bHeaderBiggerThanAllowedHeight||!z){return;}if(this._bHeaderExpanded){this._moveAnchorBarToContentArea();this._moveHeaderToContentArea(true);}else{this._snapHeader(true);}this._adjustHeaderHeights();this._requestAdjustLayout();};w.prototype._hasDynamicTitle=function(){var y=this.getHeaderTitle();return y&&y.isDynamic();};w.prototype._attachVisualIndicatorsPressHandlers=function(y,z){var B=this.getHeaderTitle(),H=this._getHeaderContent();if(x(B)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){B.attachEvent(w.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,function(){y.call(z);if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBelowCollapseVisualIndicator();}this._focusCollapseVisualIndicator();},this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(x(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(w.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,function(){y.call(z);this._focusExpandVisualIndicator();},this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};w.prototype._hasVisibleDynamicTitleAndHeader=function(){var y=this.getHeaderTitle(),H=this.getHeaderContent();return this._hasVisibleDynamicTitle(y)&&this._hasVisibleHeaderContent(H);};w.prototype._hasVisibleDynamicTitle=function(y){return x(y)&&y.isDynamic()&&y.getVisible();};w.prototype._hasVisibleHeaderContent=function(H){return x(H)&&H.length>0&&this.getShowHeaderContent();};w.prototype._hasDynamicTitleWithSnappedTitleOnMobile=function(){var y=this.getHeaderTitle();return x(y)&&y.isDynamic()&&!!y.getSnappedTitleOnMobile()&&D.system.phone;};w.prototype._updateToggleHeaderVisualIndicators=function(){var H,y,E,z=this._hasVisibleDynamicTitleAndHeader();if(!this.getToggleHeaderOnTitleClick()||!z){y=false;E=false;}else{H=this._bHeaderExpanded;y=H;E=!H&&!this._hasDynamicTitleWithSnappedTitleOnMobile();}this._toggleCollapseVisualIndicator(y);this._toggleExpandVisualIndicator(E);};w.prototype._updateTitleVisualState=function(){var y=this.getHeaderTitle(),z=this._hasVisibleDynamicTitleAndHeader()&&this.getToggleHeaderOnTitleClick()&&!this._hasDynamicTitleWithSnappedTitleOnMobile();this.$().toggleClass("sapUxAPObjectPageLayoutTitleClickEnabled",z);if(x(y)){y._toggleFocusableState(z);}};w.prototype._focusCollapseVisualIndicator=function(){var y=this._getHeaderContent();if(x(y)){y._focusCollapseButton();}};w.prototype._focusExpandVisualIndicator=function(){var y=this.getHeaderTitle();if(x(y)){y._focusExpandButton();}};w.prototype._toggleExpandVisualIndicator=function(y){var z=this.getHeaderTitle();if(x(z)){z._toggleExpandButton(y);}};w.prototype._toggleCollapseVisualIndicator=function(y){var z=this._getHeaderContent();if(x(z)){z._toggleCollapseButton(y);}};w.prototype._attachVisualIndicatorMouseOverHandlers=function(y,z,B){var H=this._getHeaderContent();if(x(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(w.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,y,B);H.attachEvent(w.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,z,B);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};w.prototype._attachTitleMouseOverHandlers=function(y,z,B){var E=this.getHeaderTitle();if(x(E)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){E.attachEvent(w.EVENTS.TITLE_MOUSE_OVER,y,B);E.attachEvent(w.EVENTS.TITLE_MOUSE_OUT,z,B);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};w.prototype._suppressScroll=function(){this._bSuppressScroll=true;};w.prototype._resumeScroll=function(){this._bSuppressScroll=false;if(this._iStoredScrollTop){this._scrollTo(this._iStoredScrollTop,0);}else{this._onScroll({target:{scrollTop:this._$opWrapper.scrollTop()}});}};w.prototype._addHoverClass=function(){var $=this.$();if($){$.addClass("sapUxAPObjectPageLayoutTitleForceHovered");}};w.prototype._removeHoverClass=function(){var $=this.$();if($){$.removeClass("sapUxAPObjectPageLayoutTitleForceHovered");}};w.prototype._getHeight=function(y){return!(y instanceof a)?0:y.$().outerHeight()||0;};w.prototype._getWidth=function(y){var z=y.getDomRef();return!(y instanceof a)?0:(z&&z.offsetWidth)||0;};w.prototype._getSectionInfoIsDirty=function(){return this.bSectionInfoIsDirty;};w.prototype._setSectionInfoIsDirty=function(y){this.bSectionInfoIsDirty=y;};w.prototype._getAriaLabelText=function(E,y){var H=this.getHeaderTitle(),z=H?H.getTitleText():null,B;if(H&&z){B=z;if(y){B+=" "+w._getLibraryResourceBundle().getText(E+"_ARIA_LABEL_WITH_TITLE");}}else{B=w._getLibraryResourceBundle().getText(E+"_ARIA_LABEL_WITHOUT_TITLE");}return B;};w.prototype._getFooterHeight=function(){if(this.getFooter()&&this.getShowFooter()){return this._getDOMRefHeight(this.$("footerWrapper").get(0));}return 0;};w.prototype._getDOMRefHeight=function(y){return y.parentElement?y.getBoundingClientRect().height:0;};w.prototype._updateAriaLabels=function(){var y=this.getLandmarkInfo(),z=this._getAriaLabelText("ROOT",true),H=this._getAriaLabelText("HEADER",true),N=this._getAriaLabelText("NAVIGATION",false),B=this._getAriaLabelText("NAVTOOLBAR",true),E=y&&y.getHeaderLabel(),G=y&&y.getRootLabel(),I=y&&y.getNavigationLabel();if(!G){this.$().attr("aria-label",z);}if(!E){this.$("headerTitle").attr("aria-label",H);}if(!I){this.$("anchorBar").attr("aria-label",N);this.$("stickyAnchorBar").attr("aria-label",N);}this.$("anchBar").attr("aria-label",B);};w.prototype._formatLandmarkInfo=function(y,z){if(y){var B=y["get"+z+"Role"]()||"",E=y["get"+z+"Label"]()||"";if(B===t.None){B='';}return{role:B.toLowerCase(),label:E};}return{};};w.prototype._getHeaderTag=function(y){if(y&&y.getHeaderRole()!==t.None){return w.DIV;}return w.HEADER;};w.prototype._getFooterTag=function(y){if(y&&y.getFooterRole()!==t.None){return w.DIV;}return w.FOOTER;};function x(y){if(arguments.length===1){return Array.isArray(y)?y.length>0:!!y;}return Array.prototype.slice.call(arguments).every(function(z){return x(z);});}return w;});
