//@ui5-bundle sap/uxap/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/uxap/AnchorBar',["sap/ui/thirdparty/jquery","sap/m/Button","sap/m/MenuButton","sap/m/library","sap/m/Toolbar","sap/ui/core/IconPool","sap/ui/core/Item","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/layout/HorizontalLayout","sap/ui/Device","sap/ui/core/CustomData","sap/ui/core/Control","./HierarchicalSelect","./library","sap/uxap/AnchorBarRenderer","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/dom/jquery/scrollLeftRTL"],function(q,B,M,m,T,I,a,R,S,H,D,C,b,c,l,A,L,K){"use strict";var d=m.SelectType;
var e=T.extend("sap.uxap.AnchorBar",{metadata:{library:"sap.uxap",properties:{showPopover:{type:"boolean",defaultValue:true},upperCase:{type:"boolean",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"}},associations:{selectedButton:{type:"sap.m.Button",multiple:false}},aggregations:{_select:{type:"sap.uxap.HierarchicalSelect",multiple:false,visibility:"hidden"},_scrollArrowLeft:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_scrollArrowRight:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});
e.ButtonDelegate={onAfterRendering:function(){var o=this.isA("sap.m.MenuButton")?this._getButtonControl():this,s=this.hasStyleClass("sapUxAPAnchorBarButtonSelected");if(this.data("bHasSubMenu")){o.$().attr("aria-haspopup","menu");o.$().find(".sapMBtn").attr("role","none").removeAttr('aria-haspopup');}o.$().attr("aria-controls",this.data("sectionId")).attr("aria-selected",s);}};
e.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.addStyleClass("sapUxAPAnchorBar");this._oPressHandlers={};this._oSectionInfo={};this._oScroller=null;this._sSelectedKey=null;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._bHasButtonsBar=D.system.tablet||D.system.desktop;this.oLibraryResourceBundleOP=sap.ui.getCore().getLibraryResourceBundle("sap.uxap");this._oSelect=this._getHierarchicalSelect();if(this._bHasButtonsBar){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:true,vertical:false,nonTouchScrolling:true});this._iREMSize=0;this._iTolerance=0;this._iOffset=0;this._sResizeListenerId=undefined;}this.setDesign("Transparent");};
e.SCROLL_STEP=250;e.SCROLL_DURATION=500;e.DOM_CALC_DELAY=200;
e.prototype.setSelectedButton=function(o){var p=this.getSelectedButton(),P,s=this._oSelect.getItems(),h=s.length>0;if(typeof o==="string"){o=sap.ui.getCore().byId(o);}if(o){if(o.getId()===p){return this;}var f=o.data("sectionId");this._sSelectedKey=f;if(f&&h){this._oSelect.setSelectedKey(f);}if(this._bHasButtonsBar&&o.data("secondLevel")!==true){P=sap.ui.getCore().byId(p);this._toggleSelectionStyleClass(P,false);this._toggleSelectionStyleClass(o,true);if(f){this.scrollToSection(f,e.SCROLL_DURATION);}this._setAnchorButtonsTabFocusValues(o);}this.setAssociation("selectedButton",o,true);}return this;};
e.prototype.setShowPopover=function(v,s){if(this.getShowPopover()===v){return this;}return this.setProperty("showPopover",v,true);};
e.prototype.getSelectedSection=function(){var s=this.getSelectedButton();if(s&&(typeof(s)==="string")){s=sap.ui.getCore().byId(s);}if(s&&(s instanceof B)&&s.data("sectionId")){return sap.ui.getCore().byId(s.data("sectionId"));}return null;};
e.prototype.onBeforeRendering=function(){if(this._bHasButtonsBar){this._iREMSize=parseInt(q("body").css("font-size"));this._iTolerance=this._iREMSize*1;this._iOffset=this._iREMSize*3;}if(T.prototype.onBeforeRendering){T.prototype.onBeforeRendering.call(this);}var f=this.getContent()||[],u=this.getUpperCase();this._oSelect.setUpperCase(u);this.toggleStyleClass("sapUxAPAnchorBarUpperCase",u);if(f.length>0&&this._sSelectedKey){this._oSelect.setSelectedKey(this._sSelectedKey);}};
e.prototype.addContent=function(o,i){var f=o.data("secondLevel")===true||o.data("secondLevel")==="true";o.addStyleClass("sapUxAPAnchorBarButton");o.removeAllAriaDescribedBy();this._createSelectItem(o,f);if(f){o.destroy();}else{o.addEventDelegate(e.ButtonDelegate,o);this.addAggregation("content",o,i);}return this;};
e.prototype._removeButtonsDelegate=function(){var f=this.getContent();f.forEach(function(o){o.removeEventDelegate(e.ButtonDelegate);});};
e.prototype._createSelectItem=function(o,i){var f=o.getBindingInfo("text"),g=o.getText().trim()!=""||f;if(g&&(!i||o.data("bTitleVisible")===true)){var p=new a({key:o.data("sectionId"),text:o.getText(),customData:[new C({key:"secondLevel",value:o.data("secondLevel")})]});if(f){p.bindProperty("text",Object.assign({},f));}this._oSelect.addItem(p);}};
e.prototype._decorateSubMenuButtons=function(E){var f=E.getSource().getContent();f.forEach(function(o){o.$().attr("aria-controls",o.data("sectionId"));});};
e.prototype._toggleSelectionStyleClass=function(o,f){if(o&&o.toggleStyleClass){o.toggleStyleClass("sapUxAPAnchorBarButtonSelected",f);if(o instanceof M){o._getButtonControl().$().attr("aria-selected",f);}else{o.$().attr("aria-selected",f);}}};
e.prototype.onButtonPress=function(E){this.fireEvent("_anchorPress",{sectionBaseId:E.getSource().data("sectionId")});};
e.prototype._onSelectChange=function(E){var s=E.getParameter("selectedItem"),o;if(!s){L.warning("AnchorBar :: no selected hierarchicalSelect item");return;}o=sap.ui.getCore().byId(s.getKey());if(o){this.fireEvent("_anchorPress",{sectionBaseId:o.getId()});}else{L.error("AnchorBar :: cannot find corresponding section",s.getKey());}};
e.prototype._getHierarchicalSelect=function(){if(!this.getAggregation('_select')){this.setAggregation('_select',new c({width:"100%",icon:"sap-icon://slim-arrow-down",tooltip:this.oLibraryResourceBundleOP.getText("ANCHOR_BAR_OVERFLOW"),change:q.proxy(this._onSelectChange,this)}));}return this.getAggregation('_select');};
e.prototype._createScrollArrow=function(f){var s,i,g,h,o,t=this,j=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_LEFT_ARROW"),k=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_RIGHT_ARROW");if(f){s=this.getId()+"-arrowScrollLeft";i="slim-arrow-left";g="anchorBarArrowLeft";h=this._bRtl?k:j;}else{s=this.getId()+"-arrowScrollRight";i="slim-arrow-right";g="anchorBarArrowRight";h=this._bRtl?j:k;}o=new B(s,{icon:I.getIconURI(i),type:"Transparent",press:function(E){E.preventDefault();t._handleScrollButtonTap(f);},tooltip:h});o.addEventDelegate({onAfterRendering:function(){if(sap.ui.getCore().getConfiguration().getTheme()!="sap_hcb"){this.$().attr("tabindex",-1);}},onThemeChanged:function(){if(sap.ui.getCore().getConfiguration().getTheme()=="sap_hcb"){this.$().removeAttr("tabindex");}else{this.$().attr("tabindex",-1);}}},o);return new H({content:[o]}).addStyleClass("anchorBarArrow").addStyleClass(g);};
e.prototype._getScrollArrowLeft=function(){var s=this.getAggregation("_scrollArrowLeft");if(s){return s;}else{s=this._createScrollArrow(true);this.setAggregation("_scrollArrowLeft",s);return s;}};
e.prototype._getScrollArrowRight=function(){var s=this.getAggregation("_scrollArrowRight");if(s){return s;}else{s=this._createScrollArrow(false);this.setAggregation("_scrollArrowRight",s);return s;}};
e.prototype._applyHierarchicalSelectMode=function(){if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){this._bHideScrollContainer=false;this._oSelect.setWidth("auto");this._oSelect.setAutoAdjustWidth(true);this._oSelect.setType(d.IconOnly);this._computeBarSectionsInfo();}else{this._bHideScrollContainer=true;this._oSelect.setWidth("100%");this._oSelect.setAutoAdjustWidth(false);this._oSelect.setType(d.Default);}this.$().toggleClass("sapUxAPAnchorBarOverflow",this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon);this.invalidate();};
e.prototype._adjustSize=function(E){var o=D.media.getCurrentRange(D.media.RANGESETS.SAP_STANDARD,this._getWidth(this)),w=E&&E.size&&(E.size.width!==E.oldSize.width),n=l.Utilities.isPhoneScenario(o)?A._AnchorBarHierarchicalSelectMode.Text:A._AnchorBarHierarchicalSelectMode.Icon;if(n!==this._sHierarchicalSelectMode){this._sHierarchicalSelectMode=n;this._applyHierarchicalSelectMode();}if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){if(this._iMaxPosition<0){return;}var $=this.$(),f=$.find(".sapUxAPAnchorBarScrollContainer"),N,g,i,s,h=function j(){var v=N;N=g;g=v;};if(w){this.scrollToSection(this._sSelectedKey);}i=f.width();s=this._bRtl?f.scrollLeftRTL():f.scrollLeft();N=s>=this._iTolerance;g=s+i<(this._iMaxPosition-this._iTolerance);if(this._bRtl){h();}L.debug("AnchorBar :: scrolled at "+s,"scrollBegin ["+(N?"true":"false")+"] scrollEnd ["+(g?"true":"false")+"]");$.toggleClass("sapUxAPAnchorBarScrollLeft",N);$.toggleClass("sapUxAPAnchorBarScrollRight",g);}};
e.prototype._handleScrollButtonTap=function(s){var i=((!this._bRtl&&s)||(this._bRtl&&!s))?-1:1;this._oScroller.scrollTo(this._iMaxPosition*i,0,e.SCROLL_DURATION*3);};
e.prototype.scrollToSection=function(i,f){if(this._bHasButtonsBar){var o=D.media.getCurrentRange(D.media.RANGESETS.SAP_STANDARD,this._getWidth(this)),f=f||e.SCROLL_DURATION,s;if(!l.Utilities.isPhoneScenario(o)&&this._oSectionInfo[i]){if(this._bRtl&&D.browser.firefox){s=this._oSectionInfo[i].scrollLeft+this._iOffset;}else{s=this._oSectionInfo[i].scrollLeft-this._iOffset;if(s<0){s=0;}}L.debug("AnchorBar :: scrolling to section "+i+" of "+s);if(this._sCurrentScrollId!=i){this._sCurrentScrollId=i;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);this.$("scroll").parent().stop(true,false);}this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;}.bind(this),f);this._oScroller.scrollTo(s,0,f);}}else{L.debug("AnchorBar :: no need to scroll to "+i);}}};
e.prototype.getScrollDelegate=function(){return this._oScroller;};
e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
e.prototype.onsapright=function(E){E.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(E.target.id.indexOf(o.getId())>-1){n=i+1;return;}});if(n&&f[n]){f[n].focus();}else if(f[f.length-1]){f[f.length-1].focus();}};
e.prototype.onsapleft=function(E){E.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(E.target.id.indexOf(o.getId())>-1){n=i-1;return;}});if(n&&f[n]){f[n].focus();}else if(f[0]){f[0].focus();}};
e.prototype.onsapdown=function(E){E.preventDefault();};
e.prototype.onsapup=function(E){E.preventDefault();};
e.prototype.onsaphome=function(E){E.preventDefault();var f=this.getContent();f[0].focus();};
e.prototype.onsapend=function(E){E.preventDefault();var f=this.getContent();f[f.length-1].focus();};
e.prototype.onsappageup=function(E){this._handlePageUp(E);};
e.prototype.onsappagedown=function(E){this._handlePageDown(E);};
e.prototype._handlePageUp=function(E){E.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(E.target.id.indexOf(o.getId())>-1){n=i-(e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return;}});if(n&&f[n]){f[n].focus();}else if(f[0]){f[0].focus();}};
e.prototype._handlePageDown=function(E){E.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(E.target.id.indexOf(o.getId())>-1){n=i+e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return;}});if(n&&f[n]){f[n].focus();}else if(f[f.length-1]){f[f.length-1].focus();}};
e.prototype._setAnchorButtonsTabFocusValues=function(s){var f=this.getContent()||[],$,F='0',n='-1',t="tabIndex";f.forEach(function(o){$=o.getAggregation("_button")?o.getAggregation("_button").$():o.$();if(o===s){$.attr(t,F);}else{$.attr(t,n);}});};
e.prototype.onAfterRendering=function(){var s;if(T.prototype.onAfterRendering){T.prototype.onAfterRendering.call(this);}s=sap.ui.getCore().byId(this.getSelectedButton());this._setAnchorButtonsTabFocusValues(s);this._iMaxPosition=-1;this._sResizeListenerId=R.register(this,q.proxy(this._adjustSize,this));this.$().find(".sapUxAPAnchorBarScrollContainer").on("scroll",q.proxy(this._onScroll,this));if(s){this.setSelectedButton(s);}if(this._bHasButtonsBar){this._iComputeContentSizeTimeout=setTimeout(function(){if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){this._computeBarSectionsInfo();}this._adjustSize();this._iComputeContentSizeTimeout=null;}.bind(this),e.DOM_CALC_DELAY);}};
e.prototype.onThemeChanged=function(){if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){this._computeBarSectionsInfo();}};
e.prototype._onScroll=function(){if(!this._iCurrentSizeCheckTimeout){this._iCurrentSizeCheckTimeout=setTimeout(function(){this._iCurrentSizeCheckTimeout=undefined;this._adjustSize();}.bind(this),e.SCROLL_DURATION);}};
e.prototype._computeBarSectionsInfo=function(){this._iMaxPosition=0;var f=this.getContent()||[];f.forEach(this._computeNextSectionInfo,this);if(this._bRtl&&(D.browser.webkit||D.browser.firefox)){f.forEach(this._adjustNextSectionInfo,this);this._oScroller&&this._oScroller.scrollTo(this._iMaxPosition,0,0);}};
e.prototype._computeNextSectionInfo=function(o){var w=o.$().outerWidth(true);this._oSectionInfo[o.data("sectionId")]={scrollLeft:this._iMaxPosition,width:w};this._iMaxPosition+=w;};
e.prototype._adjustNextSectionInfo=function(o){var s=this._oSectionInfo[o.data("sectionId")];if(D.browser.firefox){s.scrollLeft=-s.scrollLeft;}else{s.scrollLeft=this._iMaxPosition-s.scrollLeft-s.width;}};
e.prototype._resetControl=function(){this._removeButtonsDelegate();this.destroyAggregation('content');this._oSelect.destroyAggregation("items",true);return this;};
e.prototype._getAccessibilityRole=function(){return'none';};
e.prototype.enhanceAccessibilityState=function(E,f){var o=this.getContent(),i=o.indexOf(E);if(i!==-1){f.role="option";f.setsize=o.length;f.posinset=i+1;}};
e.prototype.exit=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=null;}if(this._iComputeContentSizeTimeout){clearTimeout(this._iComputeContentSizeTimeout);this._iComputeContentSizeTimeout=null;}this._removeButtonsDelegate();};
e.prototype._getWidth=function(o){var f=o.getDomRef();return!(o instanceof b)?0:(f&&f.offsetWidth)||0;};
e.prototype.setVisible=function(v){this.getParent()&&this.getParent().toggleStyleClass("sapUxAPObjectPageLayoutNoAnchorBar",!v);return this.setProperty("visible",v);};
return e;});
sap.ui.predefine('sap/uxap/AnchorBarRenderer',["sap/m/ToolbarRenderer","sap/ui/core/Renderer","sap/m/BarInPageEnabler","./library"],function(T,R,B,l){"use strict";var A=R.extend(T);A.apiVersion=2;var _=A._AnchorBarHierarchicalSelectMode={Icon:"icon",Text:"text"};
A.renderBarContent=function(r,t){if(t._bHasButtonsBar){r.renderControl(t._getScrollArrowLeft());r.openStart("div",t.getId()+"-scrollContainer");if(t._bHideScrollContainer){r.style("display","none");}r.class("sapUxAPAnchorBarScrollContainer").openEnd();r.openStart("div",t.getId()+"-scroll").attr("role","listbox").attr("aria-describedby",t.getId()+"-desc").attr("aria-label",sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("ANCHOR_BAR_ARIA_LABEL")).openEnd();if(!t._bHideScrollContainer){A.renderBarItems(r,t);}r.close("div");r.openStart("span",t.getId()+"-desc").class("sapUiPseudoInvisibleText").openEnd();r.text(sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("ANCHOR_BAR_ARIA_LABEL_DESC"));r.close("span");r.close("div");r.renderControl(t._getScrollArrowRight());}B.addChildClassTo(t._oSelect,t);r.renderControl(t._oSelect);};
A.renderBarItems=function(r,t){var s=t.getSelectedButton();t.getContent().forEach(function(c){B.addChildClassTo(c,t);if(c.getId()===s){c.addStyleClass("sapUxAPAnchorBarButtonSelected");}r.renderControl(c);});};
A.decorateRootElement=function(r,t){T.decorateRootElement.apply(this,arguments);if(t._sHierarchicalSelectMode===_.Icon){r.class("sapUxAPAnchorBarOverflow");}if(t.getBackgroundDesign()){r.class("sapUxAPAnchorBar"+t.getBackgroundDesign());}};
return A;},true);
sap.ui.predefine('sap/uxap/BlockBase',["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/CustomData","sap/ui/core/mvc/View","sap/ui/base/ManagedObjectObserver","./BlockBaseMetadata","sap/ui/model/Context","sap/ui/Device","sap/ui/layout/form/ColumnLayout","./library","sap/ui/core/Component","sap/ui/layout/library","sap/base/Log"],function(q,C,a,b,M,B,c,D,d,l,e,f,L){"use strict";var S=f.form.SimpleFormLayout;var g=l.BlockBaseFormAdjustment;
var h=C.extend("sap.uxap.BlockBase",{
metadata:{designtime:"sap/uxap/designtime/BlockBase.designtime",library:"sap.uxap",properties:{"mode":{type:"string",group:"Appearance"},"visible":{type:"boolean",group:"Appearance",defaultValue:true},"columnLayout":{type:"sap.uxap.BlockBaseColumnLayout",group:"Behavior",defaultValue:"auto"},"formAdjustment":{type:"sap.uxap.BlockBaseFormAdjustment",group:"Behavior",defaultValue:g.BlockColumns},"showSubSectionMore":{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"mappings",aggregations:{"mappings":{type:"sap.uxap.ModelMapping",multiple:true,singularName:"mapping"},"_views":{type:"sap.ui.core.Control",multiple:true,singularName:"view",visibility:"hidden"}},associations:{"selectedView":{type:"sap.ui.core.Control",multiple:false}},events:{"viewInit":{parameters:{view:{type:"sap.ui.core.mvc.View"}}}},views:{}},
renderer:"sap.uxap.BlockBaseRenderer"
},B);
h.prototype.init=function(){if(!this.getMetadata().hasViews()){this.getMetadata().setView("defaultXML",{viewName:this.getMetadata().getName(),type:"XML"});}this._oMappingApplied={};this._bLazyLoading=false;this._bConnected=false;this._oUpdatedModels={};this._oParentObjectPageSubSection=null;this._oPromisedViews={};this._oViewDestroyObserver=new M(this._onViewDestroy.bind(this));};
h.prototype.onBeforeRendering=function(){var p;this._applyMapping();if(!this.getMode()||this.getMode()===""){if(this.getMetadata().getView("defaultXML")){this.setMode("defaultXML");}else{L.error("BlockBase ::: there is no mode defined for rendering "+this.getMetadata().getName()+". You can either set a default mode on the block metadata or set the mode property before rendering the block.");}}this._applyFormAdjustment();p=this._getObjectPageLayout();this._bLazyLoading=p&&(p.getEnableLazyLoading()||p.getUseIconTabBar());};
h.prototype.onAfterRendering=function(){var p=this._getObjectPageLayout();if(p){p._requestAdjustLayout();}};
h.prototype.setParent=function(p,A,s){if(p instanceof l.ObjectPageSubSection){this._bLazyLoading=true;this._oParentObjectPageSubSection=p;}else{C.prototype.setParent.call(this,p,A,s);}};
h.prototype.setModel=function(m,n){this._applyMapping(n);return C.prototype.setModel.call(this,m,n);};
h.prototype._applyMapping=function(){if(this._shouldLazyLoad()){L.debug("BlockBase ::: Ignoring the _applyMapping as the block is not connected");}else{this.getMappings().forEach(function(m,i){var o,j,I=m.getInternalModelName(),E=m.getExternalPath(),s=m.getExternalModelName(),p;if(E){if(I==""||E==""){throw new Error("BlockBase :: incorrect mapping, one of the modelMapping property is empty");}o=this.getModel(s);if(!o){return;}p=o.resolve(E,this.getBindingContext(s));j=this.getBindingContext(I);if(!this._isMappingApplied(I)||(this.getModel(I)!==this.getModel(s))||(j&&(j.getPath()!==p))){L.info("BlockBase :: mapping external model "+s+" to "+I);this._oMappingApplied[I]=true;C.prototype.setModel.call(this,o,I);this.setBindingContext(new c(o,p),I);}}},this);}};
h.prototype._isMappingApplied=function(i){return this.getModel(i)&&this._oMappingApplied[i];};
h.prototype.propagateProperties=function(n){if(this._shouldLazyLoad()&&!this._oUpdatedModels.hasOwnProperty(n)){this._oUpdatedModels[n]=true;}else{this._applyMapping(n);}return C.prototype.propagateProperties.call(this,n);};
h.prototype.getSupportedModes=function(){var s=q.extend({},this.getMetadata().getViews());for(var k in s){s[k]=k;}return s;};
h.prototype.setMode=function(m){m=this._validateMode(m);if(this.getMode()!==m){this.setProperty("mode",m,false);if(!this._shouldLazyLoad()){this._selectView(m);}}return this;};
h.prototype.setColumnLayout=function(s){if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.invalidate();}this.setProperty("columnLayout",s);};
h.prototype.clone=function(){var A=-1,s=this.getAssociation("selectedView"),v=this.getAggregation("_views")||[];if(s){v.forEach(function(V,i){if(V.getId()===s){A=i;}return A<0;});}var n=C.prototype.clone.call(this);if(A>=0){n.setAssociation("selectedView",n.getAggregation("_views")[A]);}return n;};
h.prototype._validateMode=function(m){this.validateProperty("mode",m);if(!this.getMetadata().getView(m)){var s=this.getMetadata()._sClassName||this.getId();if(this.getMetadata().getView("defaultXML")){L.warning("BlockBase :: no view defined for block "+s+" for mode "+m+", loading defaultXML instead");m="defaultXML";}else{throw new Error("BlockBase :: no view defined for block "+s+" for mode "+m);}}return m;};
h.prototype._getSelectedViewContent=function(){var v=null,s,V;s=this.getAssociation("selectedView");V=this.getAggregation("_views");if(V){for(var i=0;!v&&i<V.length;i++){if(V[i].getId()===s){v=V[i];}}}return v;};
h.prototype.createView=function(p,m){if(!this._oPromisedViews[p.id]){this._oPromisedViews[p.id]=new Promise(function(r,i){var o=e.getOwnerComponentFor(this),j=function(){var k=function(){return b.create(p);};if(o){return o.runAsOwner(k);}else{return k();}};j().then(function(v){this._afterViewInstantiated(v,m);r(v);}.bind(this));}.bind(this));}return this._oPromisedViews[p.id];};
h.prototype._afterViewInstantiated=function(v,m){var o=v.getController();if(v){if(o){o.oParentBlock=this;}v.addCustomData(new a({"key":"layoutMode","value":m}));this.addAggregation("_views",v);this._oViewDestroyObserver.observe(v,{destroy:true});this.fireEvent("viewInit",{view:v});}else{throw new Error("BlockBase :: no view defined in metadata.views for mode "+m);}};
h.prototype._notifyForLoadingInMode=function(o,v,m){if(o&&typeof o.onParentBlockModeChange==="function"){o.onParentBlockModeChange(m);}else{L.info("BlockBase ::: could not notify "+v.sViewName+" of loading in mode "+m+": missing controller onParentBlockModeChange method");}};
h.prototype._selectView=function(m){var v,V=this.getId()+"-"+m,s,i;i=function(v){if(v&&this.getAssociation("selectedView")!==V){this.setAssociation("selectedView",v);this._notifyForLoadingInMode(v.getController(),v,m);}}.bind(this);v=this._findView(m);if(v){i(v);return;}s=this.getMetadata().getView(m);s.id=V;this.createView(s,m).then(function(v){i(v);});};
h.prototype._findView=function(m){var v=this.getAggregation("_views")||[],V,F;F=v.filter(function(o){return o.data("layoutMode")===m;});if(F.length){return F[0];}V=this.getMetadata().getView(m);F=v.filter(function(o){return V.viewName===o.getViewName();});if(F.length){return F[0];}};
h.FORM_ADUSTMENT_OFFSET=16;h._FORM_ADJUSTMENT_CONST={labelSpan:{L:12},emptySpan:{L:0},columns:{XL:1,L:1,M:1}};h._PARENT_GRID_SIZE=12;
h.prototype._computeFormAdjustmentFields=function(F,p){if(F&&p){return F===g.BlockColumns?q.extend({},h._FORM_ADJUSTMENT_CONST,{columns:p}):h._FORM_ADJUSTMENT_CONST;}};
h.prototype._applyFormAdjustment=function(){var F=this.getFormAdjustment(),v=this._getSelectedViewContent(),p=this._oParentObjectPageSubSection,o;if((F!==g.None)&&v&&p){o=this._computeFormAdjustmentFields(F,p._oLayoutConfig);v.getContent().forEach(function(i){this._adjustForm(i,o);}.bind(this));}};
h.prototype._adjustForm=function(F,o){var i,j;if(F.getMetadata().getName()==="sap.ui.layout.form.SimpleForm"){F.setLayout(S.ColumnLayout);j=F.getAggregation("form").getLayout();j._iBreakPointTablet-=h.FORM_ADUSTMENT_OFFSET;j._iBreakPointDesktop-=h.FORM_ADUSTMENT_OFFSET;j._iBreakPointLargeDesktop-=h.FORM_ADUSTMENT_OFFSET;F.setLabelSpanL(o.labelSpan.L);F.setEmptySpanL(o.emptySpan.L);this._applyFormAdjustmentFields(o,F);F.setWidth("100%");}else if(F.getMetadata().getName()==="sap.ui.layout.form.Form"){j=F.getLayout();if(j&&j.getMetadata().getName()==="sap.ui.layout.form.ColumnLayout"){i=j;}else{i=new d();F.setLayout(i);}i._iBreakPointTablet-=h.FORM_ADUSTMENT_OFFSET;i._iBreakPointDesktop-=h.FORM_ADUSTMENT_OFFSET;i._iBreakPointLargeDesktop-=h.FORM_ADUSTMENT_OFFSET;i.setLabelCellsLarge(o.labelSpan.L);i.setEmptyCellsLarge(o.emptySpan.L);this._applyFormAdjustmentFields(o,i);F.setWidth("100%");}};
h.prototype._applyFormAdjustmentFields=function(F,o){o.setColumnsXL(F.columns.XL);o.setColumnsL(F.columns.L);o.setColumnsM(F.columns.M);};
h.prototype._getObjectPageLayout=function(){return l.Utilities.getClosestOPL(this);};
h.prototype.setVisible=function(v,s){var p=this._getObjectPageLayout();if(v===this.getVisible()){return this;}this.setProperty("visible",v,s);p&&p._requestAdjustLayoutAndUxRules();return this;};
h.prototype.setShowSubSectionMore=function(v,i){if(v!=this.getShowSubSectionMore()){this.setProperty("showSubSectionMore",v,true);if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.refreshSeeMoreVisibility();}}return this;};
h.prototype.connectToModels=function(){if(!this._bConnected){L.debug("BlockBase :: Connecting block to the UI5 model tree");this._bConnected=true;if(this._bLazyLoading){var m=this.getMode();m&&this._selectView(m);this.updateBindings(true,null);}this.invalidate();}};
h.prototype._allowPropagationToLoadedViews=function(A){if(!this._bConnected){return;}this.mSkipPropagation._views=!A;};
h.prototype.updateBindingContext=function(s,i,m,u){if(!this._shouldLazyLoad()){return C.prototype.updateBindingContext.call(this,s,i,m,u);}else{L.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout");}};
h.prototype.updateBindings=function(u,m){if(!this._shouldLazyLoad()){return C.prototype.updateBindings.call(this,u,m);}else{L.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout");}};
h.prototype.exit=function(){if(this._oViewDestroyObserver){this._oViewDestroyObserver.disconnect();}};
h.prototype._shouldLazyLoad=function(){return!!this._oParentObjectPageSubSection&&this._bLazyLoading&&!this._bConnected;};
h.prototype._onViewDestroy=function(E){delete this._oPromisedViews[E.object.getId()];};
return h;});
sap.ui.predefine('sap/uxap/BlockBaseMetadata',["sap/ui/core/ElementMetadata","sap/base/Log","sap/base/util/isEmptyObject"],function(E,L,i){"use strict";var B=function(c,C){E.apply(this,arguments);this._mViews=C.metadata.views||{};};B.prototype=Object.create(E.prototype);B.prototype.constructor=B;
B.prototype.applySettings=function(c){var r=c.hasOwnProperty("renderer")?(c.renderer||""):undefined;E.prototype.applySettings.call(this,c);if(r==null){this._sRendererName=null;}};
B.prototype.getRendererName=function(){if(!this._sBlockRenderer){this._sBlockRenderer=this._resolveRendererName();L.debug("BlockBaseMetadata :: "+this.getName()+" is renderer with "+this._sBlockRenderer);}return this._sBlockRenderer;};
B.prototype._resolveRendererName=function(){var c=E.prototype.getRendererName.call(this);if(c==null){var p=this.getParent();if(p){c=B.prototype._resolveRendererName.apply(p);}else{throw new Error("BlockBaseMetadata :: no renderer found for "+this.getName());}}return c;};
B.prototype.getView=function(v){return this._mViews[v];};
B.prototype.getViews=function(){return this._mViews;};
B.prototype.setView=function(v,V){this._mViews[v]=V;return this;};
B.prototype.hasViews=function(){return!i(this._mViews);};
return B;},true);
sap.ui.predefine('sap/uxap/BlockBaseRenderer',function(){"use strict";var B={apiVersion:2};
B.render=function(r,c){if(!c.getVisible()){return;}r.openStart("div",c);if(c._getSelectedViewContent()){r.class('sapUxAPBlockBase').class("sapUxAPBlockBase"+c.getMode());}else{var C=c.getMetadata().getName().split(".").pop();r.class(C+c.getMode());}r.openEnd();if(c._getSelectedViewContent()){r.renderControl(c._getSelectedViewContent());}r.close("div");};
return B;},true);
sap.ui.predefine('sap/uxap/BreadCrumbs',["sap/m/Link","sap/m/Select","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ItemNavigation","sap/ui/core/Item","sap/ui/core/Icon","sap/ui/Device","./library","sap/ui/core/InvisibleText","sap/ui/util/openWindow","./BreadCrumbsRenderer","sap/ui/thirdparty/jquery"],function(L,S,C,R,I,a,b,D,l,c,o,B,q){"use strict";
var d=C.extend("sap.uxap.BreadCrumbs",{metadata:{library:"sap.uxap",properties:{showCurrentLocation:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"links",aggregations:{links:{type:"sap.m.Link",multiple:true,singularName:"link"},currentLocation:{type:"sap.m.Text",multiple:false},_tubeIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowSelect:{type:"sap.m.Select",multiple:false,visibility:"hidden"}}}});
d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
d.prototype.init=function(){this._iREMSize=parseInt(q("body").css("font-size"));this._iContainerMaxHeight=this._iREMSize*2;};
d.prototype.onBeforeRendering=function(){this._bOnPhone=D.system.phone;this._resetControl();};
d.prototype.onAfterRendering=function(){this._handleInitialModeSelection();};
d.prototype._handleInitialModeSelection=function(){if(this._bOnPhone){this._setSelectVisible(true);return this;}this._configureKeyboardHandling();if(!this._iContainerHeight){this._iContainerHeight=this.$().outerHeight();}if(this._iContainerHeight>this._iContainerMaxHeight){this._toggleOverflowMode(true);return this;}this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));return this;};
d.prototype._toggleOverflowMode=function(u){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);}this._setSelectVisible(u);this._setBreadcrumbsVisible(!u);this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));return this;};
d.prototype._getTubeIcon=function(){if(!this.getAggregation("_tubeIcon")){this.setAggregation("_tubeIcon",new b({"src":"sap-icon://slim-arrow-right","color":"#bfbfbf","size":"1rem","useIconTooltip":false}).addStyleClass("sapUxAPTubeIcon"));}return this.getAggregation("_tubeIcon");};
d.prototype._getOverflowSelect=function(){var O,s;if(!this.getAggregation("_overflowSelect")){s=this.getLinks().reverse()||[];s.unshift(this.getCurrentLocation());O=new S({items:s.map(this._createSelectItem),autoAdjustWidth:true});O.attachChange(this._overflowSelectChangeHandler);this.setAggregation("_overflowSelect",O);}return this.getAggregation("_overflowSelect");};
d.prototype._createSelectItem=function(i){return new a({key:i.getId(),text:i.getText()});};
d.prototype._overflowSelectChangeHandler=function(e){var s=e.getParameter("selectedItem").getKey(),f=sap.ui.getCore().byId(s),g,h;if(f instanceof L){g=f.getHref();f.firePress();if(g){h=f.getTarget();if(h){o(g,h);}else{window.location.href=g;}}}return this;};
d.prototype._handleScreenResize=function(e){var s=this._shouldOverflow(),u=this._getUsingOverflowSelect();if(s&&!u){this._toggleOverflowMode(true);}else if(!s&&u){this._toggleOverflowMode(false);}return this;};
d.prototype._shouldOverflow=function(){var $=this._getBreadcrumbsAsJQueryObject(),s,u=this._getUsingOverflowSelect();if(u){this._setBreadcrumbsVisible(true);}$.addClass("sapUxAPInvisible");s=$.outerHeight()>this._iContainerMaxHeight;$.removeClass("sapUxAPInvisible");if(u){this._setBreadcrumbsVisible(false);}return s;};
d.prototype._getBreadcrumbsAsJQueryObject=function(){if(!this._$breadcrumbs){this._$breadcurmbs=this.$("breadcrumbs");}return this._$breadcurmbs;};
d.prototype._getOverflowSelectAsJQueryObject=function(){if(!this._$select){this._$select=this.$("select");}return this._$select;};
d.prototype._setBreadcrumbsVisible=function(v){var $=this.$(),e=this._getBreadcrumbsAsJQueryObject(),f="sapUxAPFullWidth",s="sapUiHidden";if(v){e.removeClass(s);$.removeClass(f);}else{e.addClass(s);$.addClass(f);}return $;};
d.prototype._setSelectVisible=function(v){var $=this._getOverflowSelectAsJQueryObject(),s="sapUiHidden";if(v){$.removeClass(s);}else{$.addClass(s);}return this;};
d.prototype._resetControl=function(){this._iContainerHeight=null;this._$select=null;this._$breadcrumbs=null;this.setAggregation("_overflowSelect",null,true);if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);}return this;};
d.prototype._getAriaLabelledBy=function(){if(!this._oAriaLabelledBy){d.prototype._oAriaLabelledBy=new c({text:sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("BREADCRUMB_TRAIL_LABEL")}).toStatic();}return this._oAriaLabelledBy;};
d.prototype._getItemNavigation=function(){if(!this._ItemNavigation){this._ItemNavigation=new I();}return this._ItemNavigation;};
d.prototype._getItemsToNavigate=function(){var i=this.getLinks(),e=this.getCurrentLocation(),s=this.getShowCurrentLocation();if(s&&e){i.push(e);}return i;};
d.prototype._configureKeyboardHandling=function(){var i=this._getItemNavigation(),h=this._getBreadcrumbsAsJQueryObject()[0],s=-1,e=this._getItemsToNavigate(),n=[];e.forEach(function(f){f.$().attr("tabindex","-1");n.push(f.getDomRef());});this.addDelegate(i);i.setCycling(false);i.setRootDomRef(h);i.setItemDomRefs(n);i.setSelectedIndex(s);this._getBreadcrumbsAsJQueryObject().attr("tabindex","-1");e[0].$().attr("tabindex","0");return this;};
d.prototype.onsappageup=function(e){this._handlePageKeys(e,false);};
d.prototype.onsappagedown=function(e){this._handlePageKeys(e,true);};
d.prototype._handlePageKeys=function(e,m){var n,f=this._getItemsToNavigate(),E=0,i=m?f.length-1:0;e.preventDefault();f.some(function(g,h){if(g.getId()===e.target.id){E=h;return true;}});if(m){n=E+d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE;}else{n=E-d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE;}if(n&&f[n]){f[n].focus();}else if(f[i]){f[i].focus();}};
d.prototype._getUsingOverflowSelect=function(){return!this._getOverflowSelectAsJQueryObject().hasClass("sapUiHidden");};
d.prototype.exit=function(){if(this._ItemNavigation){this.removeDelegate(this._ItemNavigation);this._ItemNavigation.destroy();this._ItemNavigation=null;}this._resetControl();};
return d;});
sap.ui.predefine('sap/uxap/BreadCrumbsRenderer',function(){"use strict";var B={apiVersion:2};
B.render=function(r,c){r.openStart("div",c).class("sapUxAPBreadCrumbs").attr("role","navigation").attr("aria-labelledby",c._getAriaLabelledBy().getId()).openEnd();this._renderOverflowSelect(r,c);if(!c._bOnPhone){this._renderBreadcrumbTrail(r,c);}r.close("div");};
B._renderBreadcrumbTrail=function(r,c){var l=c.getLinks(),C=c.getCurrentLocation(),t=c._getTubeIcon(),s=c.getShowCurrentLocation();r.openStart("ul",c.getId()+"-breadcrumbs").openEnd();l.forEach(function(L){r.openStart("li").openEnd();r.renderControl(L);r.renderControl(t);r.close("li");});if(s){r.openStart("li").openEnd();r.renderControl(C);r.close("li");}r.close("ul");};
B._renderOverflowSelect=function(r,c){var t=c._getTubeIcon();r.openStart("div",c.getId()+"-select");r.class("sapUiHidden");r.openEnd();r.openStart("span").class("sapUxAPBreadCrumbsDots").openEnd().text("...").close("span");r.renderControl(t);r.renderControl(c._getOverflowSelect());r.close("div");};
return B;},true);
sap.ui.predefine('sap/uxap/HierarchicalSelect',["sap/m/Select","sap/ui/Device","sap/ui/thirdparty/jquery","./library","./HierarchicalSelectRenderer","sap/ui/thirdparty/jqueryui/jquery-ui-position"],function(S,D,q,l,H){"use strict";
var a=S.extend("sap.uxap.HierarchicalSelect",{metadata:{library:"sap.uxap",properties:{upperCase:{type:"boolean",group:"Appearance",defaultValue:false}}}});
a.POPOVER_MIN_WIDTH_REM=11;
a.prototype.onAfterRendering=function(){S.prototype.onAfterRendering.apply(this,arguments);};
a.prototype.onAfterRenderingPicker=function(){S.prototype.onAfterRenderingPicker.call(this);var i=this.getItems()||[];i.forEach(function(I){var c=(I.data("secondLevel")===true)?"sapUxAPHierarchicalSelectSecondLevel":"sapUxAPHierarchicalSelectFirstLevel";I.$().addClass(c);},this);};
a.prototype.setUpperCase=function(v,s){this.setProperty("upperCase",v,s);this.toggleStyleClass("sapUxAPHierarchicalSelectUpperCase",v);var p=this.getAggregation("picker");if(p){p.toggleStyleClass("sapMSltPickerFirstLevelUpperCase",v);if(!s){p.invalidate();}}return this;};
a.prototype.onsapenter=S.prototype.onsapspace;["onsapup","onsappageup","onsappagedown","onsaphome","onsapend"].forEach(function(n){a.prototype[n]=function(e){S.prototype[n].call(this,e);e.stopPropagation();};});
a.prototype._createDialog=function(){var d=S.prototype._createDialog.call(this),c=d.getCustomHeader();if(c){c.addStyleClass("sapUxAPHierarchicalSelect");}return d;};
a.prototype._decoratePopover=function(p){S.prototype._decoratePopover.call(this,p);p._adaptPositionParams=function(){this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["end bottom","end center","end top","begin center"];this._atPositions=["end top","end center","end bottom","begin center"];};if(D.system.tablet||D.system.desktop){var r=q.position.scrollbarWidth();if(r>0){p.setOffsetX(r);}}};
a.prototype._onAfterRenderingPopover=function(){var p=this.getPicker(),P=p.getDomRef("cont"),m=P.style.minWidth;if(m.endsWith("rem")){m=m.substring(0,m.length-3);var M=parseFloat(m);if(M<a.POPOVER_MIN_WIDTH_REM&&P){P.style.minWidth=a.POPOVER_MIN_WIDTH_REM+"rem";}}};
return a;});
sap.ui.predefine('sap/uxap/HierarchicalSelectRenderer',["sap/m/SelectRenderer","sap/ui/core/Renderer"],function(S,R){"use strict";var H=R.extend(S);H.apiVersion=2;
H.addClass=function(r){r.class("sapUxAPHierarchicalSelect");};
return H;},true);
sap.ui.predefine('sap/uxap/LazyLoading',["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/base/Object","./ObjectPageSubSection","./library","sap/base/Log","sap/base/util/isEmptyObject"],function(q,D,B,O,l,L,i){"use strict";
var a=B.extend("sap.uxap._helpers.LazyLoading",{
constructor:function(o){this._oObjectPageLayout=o;this._$html=q("html");this._iPreviousScrollTop=0;this._iScrollProgress=0;this._iPreviousScrollTimestamp=0;this._sLazyLoadingTimer=null;this._bSuppressed=false;this._oPrevSubSectionsInView={};this.setLazyLoadingParameters();},
getInterface:function(){return this;}
});
a.prototype.setLazyLoadingParameters=function(){this.LAZY_LOADING_DELAY=200;this.LAZY_LOADING_EXTRA_PAGE_SIZE=0.5;this.LAZY_LOADING_EXTRA_SUBSECTION=this.LAZY_LOADING_DELAY*5;if(this._isPhone()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":1,"ScrollToSection":1};}else if(this._isTablet()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":2,"ScrollToSection":1};}else if(this._isTabletSize()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":2,"ScrollToSection":2};}else{this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":3,"ScrollToSection":3};}this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD=5;};
a.prototype.suppress=function(){this._bSuppressed=true;};
a.prototype.resume=function(){this._bSuppressed=false;};
a.prototype._triggerVisibleSubSectionsEvents=function(){this._oPrevSubSectionsInView={};this._oObjectPageLayout._requestAdjustLayout(true);this.doLazyLoading();};
a.prototype.lazyLoadDuringScroll=function(I,s,t,p){var P,d,f=false;if(this._bSuppressed){return;}if(I){if(this._sLazyLoadingTimer){clearTimeout(this._sLazyLoadingTimer);}this._sLazyLoadingTimer=null;this.doLazyLoading();return;}this._iScrollProgress=s-this._iPreviousScrollTop;P=Math.round(Math.abs(this._iScrollProgress)/p*100);if(P>=this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD){f=true;}this._iPreviousScrollTop=s;this._iPreviousScrollTimestamp=t||0;d=(s===0)?0:this.LAZY_LOADING_DELAY;if(f&&this._sLazyLoadingTimer){L.debug("ObjectPageLayout :: lazyLoading","delayed by "+d+" ms because of fast scroll");clearTimeout(this._sLazyLoadingTimer);this._sLazyLoadingTimer=null;}if(!this._sLazyLoadingTimer){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),d);}};
a.prototype.doLazyLoading=function(){var h=this._oObjectPageLayout._getHeightRelatedParameters(),I=this._oObjectPageLayout.getUseIconTabBar(),s=sap.ui.getCore().byId(this._oObjectPageLayout.getSelectedSection()),S=this._oObjectPageLayout._oSectionInfo,b,c,p,d=this._iPreviousScrollTop>=(h.iHeaderContentHeight),e,E=-1,o={},f={},t,g,j;if(this._bSuppressed){return;}p=(h.iScreenHeight-(d?h.iAnchorBarHeight:0)-(d?h.iHeaderTitleHeightStickied:0));b=h.iScrollTop;t=Date.now()-this._iPreviousScrollTimestamp;g=(t<(this.LAZY_LOADING_DELAY/2))&&(Math.abs(this._iScrollProgress)>5);if(g){if(this._iScrollProgress>=0){j=Math.round(Math.min(this._iScrollProgress*20,p/2));}else{j=-1*Math.round(Math.min(Math.abs(this._iScrollProgress)*20,p/2));}b+=j;L.debug("ObjectPageLayout :: lazyLoading","Visible page shifted from : "+j);}c=b+p;b+=16;q.each(S,q.proxy(function(k,m){if(!m.isSection&&m.sectionReference.getParent()&&m.sectionReference.getParent().getVisible()){if(I&&s&&s.indexOfSubSection(m.sectionReference)<0){return;}if(m.positionTop<=c&&b<m.positionBottom-1){f[k]=k;if(!m.loaded){o[k]=k;}}else if(!m.loaded&&m.positionTop>c&&m.positionTop<c+p*this.LAZY_LOADING_EXTRA_PAGE_SIZE&&(E==-1||m.positionTop<E)){E=m.positionTop;e=k;}}},this));if(E!=-1&&i(o)){L.debug("ObjectPageLayout :: lazyLoading","extra section added : "+e);o[e]=e;}q.each(o,q.proxy(function(k,m){L.debug("ObjectPageLayout :: lazyLoading","connecting "+m);sap.ui.getCore().byId(m).connectToModels();S[m].loaded=true;},this));q.each(f,q.proxy(function(k,m){if(!this._oPrevSubSectionsInView[k]){L.debug("ObjectPageLayout :: lazyLoading","subSectionEnteredViewPort "+m);this._oObjectPageLayout.fireEvent("subSectionEnteredViewPort",{subSection:sap.ui.getCore().byId(m)});}},this));this._oPrevSubSectionsInView=f;if(g){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),this.LAZY_LOADING_DELAY);}else{if(E){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),this.LAZY_LOADING_EXTRA_SUBSECTION);}else{this._sLazyLoadingTimer=null;}}};
a.prototype.getSubsectionsToPreload=function(A,I){var s,t;if(I){s=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.ScrollToSection;t=false;}else{s=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.FirstRendering;t=true;}var S=[];A.some(function(o){if(!t&&I){t=o.getId()==I;}if(t&&o instanceof O){if(o.getVisible()&&o._getInternalVisible()){S.push(o);s--;}}return s<=0;});return S;};
a.prototype.destroy=function(){if(this._sLazyLoadingTimer){clearTimeout(this._sLazyLoadingTimer);}};
a.prototype._isPhone=function(){return l.Utilities.isPhoneScenario(this._oObjectPageLayout._getCurrentMediaContainerRange());};
a.prototype._isTablet=function(){return D.system.tablet;};
a.prototype._isTabletSize=function(){return l.Utilities.isTabletScenario(this._oObjectPageLayout._getCurrentMediaContainerRange());};
return a;});
sap.ui.predefine('sap/uxap/ModelMapping',["sap/ui/core/Element","./library"],function(E,l){"use strict";
var M=E.extend("sap.uxap.ModelMapping",{metadata:{library:"sap.uxap",properties:{externalModelName:{type:"string",group:"Misc",defaultValue:null},internalModelName:{type:"string",group:"Misc",defaultValue:"Model"},externalPath:{type:"string",group:"Misc",defaultValue:null}}}});
return M;});
sap.ui.predefine('sap/uxap/ObjectImageHelper',["sap/ui/base/ManagedObject","sap/ui/core/IconPool","sap/m/Avatar","sap/m/Image"],function(M,I,A,a){"use strict";var O=function(){};
O.createObjectImage=function(h){var o,s=h.getObjectImageURI();if(s.indexOf("sap-icon://")===0){o=O.instantiateAvatar(s);o.addStyleClass("sapUxAPObjectPageHeaderObjectImageIcon");}else{o=new a({densityAware:h.getObjectImageDensityAware(),alt:M.escapeSettingsValue(h.getObjectImageAlt()),decorative:false,mode:"Background",backgroundSize:"contain",backgroundPosition:"center"});o.addStyleClass("sapUxAPObjectPageHeaderObjectImage");o.setSrc(s);}if(h.getObjectImageAlt()){o.setTooltip(h.getObjectImageAlt());}return o;};
O.instantiateAvatar=function(u){return new A({displaySize:"L",fallbackIcon:u});};
O.createPlaceholder=function(){return O.instantiateAvatar(I.getIconURI("picture"));};
O.updateAvatarInstance=function(o,s,c){o.setDisplayShape(s);o.setBackgroundColor(c);};
O._renderImageAndPlaceholder=function(r,o){var h=o.oHeader,b=o.oObjectImage,p=o.oPlaceholder,i=o.bIsObjectIconAlwaysVisible,c=o.bAddSubContainer,B=o.sBaseClass,s=h.getObjectImageShape(),d=h.getObjectImageBackgroundColor(),S=h.getShowPlaceholder()&&!h.getObjectImageURI(),e=b.isA("sap.m.Avatar");if(h.getShowPlaceholder()){O.updateAvatarInstance(p,s,d);}if(h.getObjectImageURI()||h.getShowPlaceholder()){r.openStart("span").class(B).class('sapUxAPObjectPageHeaderObjectImage-'+s);if(i){r.class('sapUxAPObjectPageHeaderObjectImageForce');}r.openEnd();if(c){r.openStart("span").class("sapUxAPObjectPageHeaderObjectImageContainerSub").openEnd();}if(e){O.updateAvatarInstance(b,s,d);r.openStart("div").class("sapUxAPObjectPageHeaderObjectImage").class("sapUxAPObjectPageHeaderPlaceholder").openEnd();}if(h.getObjectImageURI()){r.renderControl(b);}O._renderPlaceholder(r,p,S);if(e){r.close("div");}if(c){r.close("span");}r.close("span");}};
O._renderPlaceholder=function(r,p,v){r.openStart("div").class('sapUxAPObjectPageHeaderPlaceholder').class('sapUxAPObjectPageHeaderObjectImage');if(!v){r.class('sapUxAPHidePlaceholder');}r.openEnd();r.renderControl(p);r.close("div");};
return O;});
sap.ui.predefine('sap/uxap/ObjectPageAccessibleLandmarkInfo',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var O=E.extend("sap.uxap.ObjectPageAccessibleLandmarkInfo",{metadata:{library:"sap.uxap",properties:{rootRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Main"},rootLabel:{type:"string",defaultValue:null},contentRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"None"},contentLabel:{type:"string",defaultValue:null},navigationRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Navigation"},navigationLabel:{type:"string",defaultValue:null},headerRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Banner"},headerLabel:{type:"string",defaultValue:null},footerRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Region"},footerLabel:{type:"string",defaultValue:null}}}});
return O;});
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderContent',['./library',"./ObjectPageDynamicHeaderContentRenderer","sap/base/Log","sap/f/DynamicPageHeader"],function(l,O,L,D){"use strict";
var a=D.extend("sap.uxap.ObjectPageDynamicHeaderContent",{metadata:{interfaces:["sap.uxap.IHeaderContent"],library:"sap.uxap"}});
a.createInstance=function(c,v,C,p,s){return new a({content:c,visible:v,pinnable:p,id:s});};
a.prototype.supportsPinUnpin=function(){return true;};
a.prototype.supportsChildPageDesign=function(){return false;};
a.prototype.supportsAlwaysExpanded=function(){return false;};
a.prototype.setContentDesign=function(d){};
a.prototype.setVisible=function(v){this.getParent()&&this.getParent().toggleStyleClass("sapUxAPObjectPageLayoutNoHeaderContent",!v);return this.setProperty("visible",v);};
return a;});
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderContentRenderer',['sap/ui/core/Renderer','sap/f/DynamicPageHeaderRenderer'],function(R,D){"use strict";var O=R.extend(D);O.apiVersion=2;return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderTitle',['./library','sap/uxap/ObjectPageDynamicHeaderContent',"./ObjectPageDynamicHeaderTitleRenderer","sap/base/Log","sap/f/DynamicPageTitle"],function(l,O,a,L,D){"use strict";
var b=D.extend("sap.uxap.ObjectPageDynamicHeaderTitle",{metadata:{interfaces:["sap.uxap.IHeaderTitle"],library:"sap.uxap"}});
b.prototype.isDynamic=function(){return true;};
b.prototype.getCompatibleHeaderContentClass=function(){return O;};
b.prototype.supportsToggleHeaderOnTitleClick=function(){return true;};
b.prototype.supportsTitleInHeaderContent=function(){return false;};
b.prototype.supportsAdaptLayoutForDomElement=function(){return false;};
b.prototype.supportsBackgroundDesign=function(){return true;};
b.KNOWN_HEADING_CONTROL_CLASS_NAMES=["sap.m.Title","sap.m.Text","sap.m.FormattedText","sap.m.Label"];
b.prototype.getTitleText=function(){var h=this.getHeading(),c=h&&h.getMetadata().getName();if(b.KNOWN_HEADING_CONTROL_CLASS_NAMES.indexOf(c)>-1){return h.getText();}};
b.prototype.getHeaderDesign=function(){return l.ObjectPageHeaderDesign.Light;};
b.prototype.snap=function(u){this._toggleState(false,u);this._updateARIAState(false);};
b.prototype.unSnap=function(u){this._toggleState(true,u);this._updateARIAState(true);};
b.prototype._adaptObjectPageHeaderIndentifierLine=function($,e){};
return b;});
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderTitleRenderer',['sap/ui/core/Renderer','sap/f/DynamicPageTitleRenderer'],function(R,D){"use strict";var O=R.extend(D);O.apiVersion=2;return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageHeader',["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/CustomData","sap/ui/Device","sap/m/Breadcrumbs","./ObjectPageHeaderActionButton","sap/ui/core/ResizeHandler","sap/m/Button","sap/m/ActionSheet","./ObjectImageHelper","./ObjectPageHeaderContent","./library","sap/m/library","./ObjectPageHeaderRenderer"],function(q,C,I,a,D,B,O,R,b,A,c,d,l,m,e){"use strict";var f=l.Importance;var g=m.ButtonType;var P=m.PlacementType;var h=l.ObjectPageHeaderDesign;var j=m.AvatarShape;var k=m.AvatarColor;
function n(i){return typeof i==="function";}
var o=C.extend("sap.uxap.ObjectPageHeader",{metadata:{library:"sap.uxap",interfaces:["sap.uxap.IHeaderTitle"],properties:{objectImageURI:{type:"string",defaultValue:null},objectImageAlt:{type:"string",defaultValue:''},objectImageDensityAware:{type:"boolean",defaultValue:false},objectTitle:{type:"string",defaultValue:null},objectSubtitle:{type:"string",defaultValue:null},objectImageShape:{type:"sap.m.AvatarShape",group:"Appearance",defaultValue:j.Square},objectImageBackgroundColor:{type:"sap.m.AvatarColor",group:"Appearance",defaultValue:k.Accent6},isObjectIconAlwaysVisible:{type:"boolean",defaultValue:false},isObjectTitleAlwaysVisible:{type:"boolean",defaultValue:true},isObjectSubtitleAlwaysVisible:{type:"boolean",defaultValue:true},isActionAreaAlwaysVisible:{type:"boolean",defaultValue:true},headerDesign:{type:"sap.uxap.ObjectPageHeaderDesign",defaultValue:h.Light,deprecated:true},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},markFavorite:{type:"boolean",group:"Misc",defaultValue:false},markFlagged:{type:"boolean",group:"Misc",defaultValue:false},showMarkers:{type:"boolean",group:"Misc",defaultValue:false},markLocked:{type:"boolean",group:"Misc",defaultValue:false},showPlaceholder:{type:"boolean",group:"Misc",defaultValue:false},markChanges:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"actions",aggregations:{_breadCrumbs:{type:"sap.m.Breadcrumbs",multiple:false,visibility:"hidden"},breadcrumbs:{type:"sap.m.Breadcrumbs",multiple:false,singularName:"breadcrumb"},breadCrumbsLinks:{type:"sap.m.Link",multiple:true,singularName:"breadCrumbLink",deprecated:true},_overflowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_placeholder:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"},_lockIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_lockIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_favIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_flagIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowActionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_changesIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_changesIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_sideContentBtn:{type:"sap.m.Button",multiple:false,visibility:"hidden"},navigationBar:{type:"sap.m.Bar",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},sideContentButton:{type:"sap.m.Button",multiple:false},titleSelectorTooltip:{type:"sap.ui.core.TooltipBase",altTypes:["string"],multiple:false}},events:{titleSelectorPress:{parameters:{domRef:{type:"string"}}},markLockedPress:{parameters:{domRef:{type:"string"}}},markChangesPress:{parameters:{domRef:{type:"string"}}}},designtime:"sap/uxap/designtime/ObjectPageHeader.designtime"}});
o.prototype._iAvailablePercentageForActions=0.3;
o.prototype.init=function(){this._bFirstRendering=true;if(!this.oLibraryResourceBundle){this.oLibraryResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");}if(!this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=sap.ui.getCore().getLibraryResourceBundle("sap.uxap");}this._oOverflowActionSheet=this._lazyLoadInternalAggregation("_overflowActionSheet",true);this._oOverflowButton=this._lazyLoadInternalAggregation("_overflowButton",true).attachPress(this._handleOverflowButtonPress,this);this._oExpandButton=this._lazyLoadInternalAggregation("_expandButton",true);this._oActionSheetButtonMap={};this._oFlagIcon=this._lazyLoadInternalAggregation("_flagIcon",true);this._oFavIcon=this._lazyLoadInternalAggregation("_favIcon",true);this._oTitleArrowIcon=this._lazyLoadInternalAggregation("_titleArrowIcon",true).attachPress(this._handleArrowPress,this);this._oTitleArrowIconCont=this._lazyLoadInternalAggregation("_titleArrowIconCont",true).attachPress(this._handleArrowPress,this);this._oLockIcon=this._lazyLoadInternalAggregation("_lockIcon",true).attachPress(this._handleLockPress,this);this._oLockIconCont=this._lazyLoadInternalAggregation("_lockIconCont",true).attachPress(this._handleLockPress,this);this._oChangesIcon=this._lazyLoadInternalAggregation("_changesIcon",true).attachPress(this._handleChangesPress,this);this._oChangesIconCont=this._lazyLoadInternalAggregation("_changesIconCont",true).attachPress(this._handleChangesPress,this);};
o.getMetadata().forwardAggregation("breadCrumbsLinks",{getter:function(){return this._lazyLoadInternalAggregation("_breadCrumbs");},aggregation:"links"});
o.prototype._handleOverflowButtonPress=function(E){this._oOverflowActionSheet.openBy(this._oOverflowButton);};
o.prototype._handleArrowPress=function(E){this.fireTitleSelectorPress({domRef:E.getSource().getDomRef()});};
o.prototype._handleLockPress=function(E){this.fireMarkLockedPress({domRef:E.getSource().getDomRef()});};
o.prototype._handleChangesPress=function(E){this.fireMarkChangesPress({domRef:E.getSource().getDomRef()});};
o._internalAggregationFactory={"_objectImage":c.createObjectImage,"_placeholder":c.createPlaceholder,"_overflowActionSheet":function(){return new A({placement:P.Bottom});},"_lockIconCont":function(i){return this._getButton(i,"sap-icon://private","lock-cont",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_breadCrumbs":function(i){return new B({links:i.getAggregation("breadCrumbLinks")});},"_lockIcon":function(i){return this._getButton(i,"sap-icon://private","lock",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_titleArrowIconCont":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","titleArrow-cont",i.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_titleArrowIcon":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","titleArrow",i.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_favIcon":function(i){return this._getIcon(i,"favorite",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FAVORITE_MARK_VALUE"));},"_flagIcon":function(i){return this._getIcon(i,"flag",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FLAG_MARK_VALUE"));},"_overflowButton":function(i){return this._getButton(i,"sap-icon://overflow","overflow",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_OVERFLOW_BTN"));},"_expandButton":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","expand",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_EXPAND_HEADER_BTN"));},"_changesIconCont":function(i){return this._getButton(i,"sap-icon://user-edit","changes-cont",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},"_changesIcon":function(i){return this._getButton(i,"sap-icon://user-edit","changes",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},_getIcon:function(i,u,T){return I.createControlByURI({id:this._getParentAugmentedId(i,u),tooltip:T,src:I.getIconURI(u),visible:false});},_getButton:function(i,u,v,T){return new b({id:this._getParentAugmentedId(i,v),tooltip:T,icon:u,type:g.Transparent});},_getParentAugmentedId:function(i,u){return i.getId()+"-"+u;}};
o.prototype._lazyLoadInternalAggregation=function(i,S){if(!this.getAggregation(i)){this.setAggregation(i,o._internalAggregationFactory[i](this),S);}return this.getAggregation(i);};
o.prototype._applyActionProperty=function(i,u){var v=u[0];if(this.getProperty(i)!==v){u.unshift(i);this.setProperty.apply(this,u);if(!this._bFirstRendering){this._notifyParentOfChanges();}}return this;};
o.prototype._applyObjectImageProperty=function(i,u){var v=u[0];if(this.getProperty(i)!==v){u.unshift(i);this.setProperty.apply(this,u);this._destroyObjectImage();if(!this._bFirstRendering){this._notifyParentOfChanges(true);}}return this;};
o.prototype._setAggregationTooltip=function(i,T){var u=this.getAggregation(i);if(u){u.setTooltip(T);}return this;};
o.prototype._setTitleSelectorTooltip=function(T){if(T===null||T===undefined){T=this.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP");}this._setAggregationTooltip("_titleArrowIcon",T);this._setAggregationTooltip("_titleArrowIconCont",T);return this;};
o.prototype.setHeaderDesign=function(H){this.setProperty("headerDesign",H);if(this.getParent()){this.getParent().invalidate();}return this;};
o.prototype.setObjectTitle=function(N){var i=this.getParent(),u=this.getProperty("objectTitle"),v=u!==N;this._applyActionProperty("objectTitle",Array.prototype.slice.call(arguments));i&&n(i._updateAriaLabels)&&i._updateAriaLabels();if(v&&this.mEventRegistry["_titleChange"]){this.fireEvent("_titleChange",{"id":this.getId(),"name":"objectTitle","oldValue":u,"newValue":N});}return this;};
var p=["objectSubtitle","showTitleSelector","markLocked","markFavorite","markFlagged","showMarkers","showPlaceholder","markChanges"],r=["objectImageURI","objectImageAlt","objectImageDensityAware","objectImageShape","objectImageBackgroundColor"];var G=function(i){var u="set"+i.charAt(0).toUpperCase()+i.slice(1);o.prototype[u]=function(){var v=Array.prototype.slice.call(arguments);this._applyActionProperty.call(this,i,v);return this;};};var s=function(i){var u="set"+i.charAt(0).toUpperCase()+i.slice(1);o.prototype[u]=function(){var v=Array.prototype.slice.call(arguments);this._applyObjectImageProperty.call(this,i,v);return this;};};var t=function(i,S,T){var u="set"+i.charAt(0).toUpperCase()+i.slice(1);S[u]=function(){var v=Array.prototype.slice.call(arguments);v.unshift(i);T.setProperty.apply(T,v);return this.setProperty.apply(this,v);};};p.forEach(G);r.forEach(s);
o.prototype._destroyObjectImage=function(){var i="_objectImage",u=this.getAggregation(i);if(u){u.destroy();this.setAggregation(i,null);}};
o.prototype.onBeforeRendering=function(){var S=this.getSideContentButton(),i=this;if(S&&!S.getTooltip()){S.setTooltip(this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SHOW_SIDE_CONTENT"));}var u=this.getActions()||[];this._oOverflowActionSheet.removeAllButtons();this._resetActionSheetMap();if(u.length>1||this._hasOneButtonShowText(u)){u.forEach(function(v){if(v instanceof b&&!(v instanceof O)){v._bInternalVisible=v.getVisible();v._getInternalVisible=function(){return this._bInternalVisible;};v._setInternalVisible=function(V,x){this.$().toggle(V);if(V!=this._bInternalVisible){this._bInternalVisible=V;if(x){this.invalidate();}}};v.setVisible=function(V){v._setInternalVisible(V,true);b.prototype.setVisible.call(this,V);};v.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide();}i._resizeIdentifierLineContainer(i.$());};}if(v instanceof b&&v.getVisible()){var w=this._createActionSheetButton(v);this._oActionSheetButtonMap[v.getId()]=w;this._oOverflowActionSheet.addButton(w);t("text",v,w);t("icon",v,w);t("enabled",v,w);t("type",v,w);}},this);}this._oTitleArrowIcon.setVisible(this.getShowTitleSelector());this._oFavIcon.setVisible(this.getMarkFavorite());this._oFlagIcon.setVisible(this.getMarkFlagged());this._attachDetachActionButtonsHandler(false);if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}this._bFirstRendering=false;};
o.prototype._resetActionSheetMap=function(){Object.keys(this._oActionSheetButtonMap).forEach(function(i){this._oActionSheetButtonMap[i].destroy();}.bind(this));this._oActionSheetButtonMap={};};
o.prototype._createActionSheetButton=function(i){return new b({press:q.proxy(this._onSeeMoreContentSelect,this),enabled:i.getEnabled(),text:i.getText(),icon:i.getIcon(),type:i.getType(),tooltip:i.getTooltip(),customData:new a({key:"originalId",value:i.getId()})});};
o.prototype._handleImageNotFoundError=function(){var i=this._lazyLoadInternalAggregation("_objectImage"),u=this.getParent(),$=u?u.$():this.$();if(this.getShowPlaceholder()){$.find(".sapMImg.sapUxAPObjectPageHeaderObjectImage").hide();$.find(".sapUxAPObjectPageHeaderPlaceholder").removeClass("sapUxAPHidePlaceholder");}else{i.addStyleClass("sapMNoImg");}};
o.prototype._clearImageNotFoundHandler=function(){this._lazyLoadInternalAggregation("_objectImage").$().off("error");};
o.prototype.onAfterRendering=function(){var $=this._lazyLoadInternalAggregation("_objectImage").$();if(this._adaptLayoutTimeout){clearTimeout(this._adaptLayoutTimeout);}this._adaptLayout();this._clearImageNotFoundHandler();$.on("error",this._handleImageNotFoundError.bind(this));if(!this.getObjectImageURI()){this._handleImageNotFoundError();}if(!this._iResizeId){this._iResizeId=R.register(this,this._onHeaderResize.bind(this));}this._attachDetachActionButtonsHandler(true);};
o.prototype._onHeaderResize=function(E){this._adaptLayout();if(this.getParent()&&typeof this.getParent()._onUpdateHeaderTitleSize==="function"){this.getParent()._onUpdateHeaderTitleSize(E);}};
o.prototype._attachDetachActionButtonsHandler=function(i){var u=this.getActions()||[];if(u.length<1){return;}u.forEach(function(v){if(v instanceof b){var w=this._oActionSheetButtonMap[v.getId()];if(i){v.attachEvent("_change",this._adaptLayoutDelayed,this);if(w){w.attachEvent("_change",this._adaptOverflow,this);}}else{v.detachEvent("_change",this._adaptLayoutDelayed,this);if(w){w.detachEvent("_change",this._adaptOverflow,this);}}}},this);};
o.prototype._onSeeMoreContentSelect=function(E){var i=E.getSource(),u=sap.ui.getCore().byId(i.data("originalId"));if(u.firePress){u.firePress({overflowButtonId:this._oOverflowButton.getId(),bInOverflow:true});}this._oOverflowActionSheet.close();};
o._actionImportanceMap={"Low":3,"Medium":2,"High":1};
o._sortActionsByImportance=function(i,u){var v=(i instanceof O)?i.getImportance():f.High,w=(u instanceof O)?u.getImportance():f.High,x=o._actionImportanceMap[v]-o._actionImportanceMap[w];if(x===0){return i.position-u.position;}return x;};
o.prototype._hasOneButtonShowText=function(i){var u=false;if(i.length!==1){return u;}if(i[0]instanceof O){u=(!i[0].getHideText()&&i[0].getText()!="");}else if(i[0]instanceof b){u=(i[0].getText()!="");}return u;};
o.prototype._adaptLayout=function(E){var $=this.$("identifierLine"),i=$.width(),u=this._getActionsWidth(),v=u/i,w=this._iAvailablePercentageForActions*i,x=this._oOverflowButton.$();if(i===0){return;}if(v>this._iAvailablePercentageForActions){this._adaptActions(w);}else if(E&&E.getSource()instanceof O){E.getSource()._setInternalVisible(true);}if(D.system.phone){this.getActions().forEach(function(F){if(F instanceof b){F.$().css("visibility","visible");}});}var y=this.$("actions");var z=y.find(".sapMBtn").not(".sapUxAPObjectPageHeaderExpandButton");if(z.filter(":visible").length===z.length){x.hide();}this._adaptObjectPageHeaderIndentifierLine(this.$());};
o.prototype._adaptLayoutDelayed=function(){if(this._adaptLayoutTimeout){clearTimeout(this._adaptLayoutTimeout);}this._adaptLayoutTimeout=setTimeout(function(){this._adaptLayoutTimeout=null;this._adaptLayout();}.bind(this),0);};
o.prototype._adaptObjectPageHeaderIndentifierLine=function($){var i=this._findById($,"identifierLine"),u=i.find(".sapUxAPObjectPageHeaderIdentifierTitle");this._adaptObjectPageHeaderTitle(u);this._resizeIdentifierLineContainer($);};
o.prototype._resizeIdentifierLineContainer=function($){var i=this._findById($,"identifierLineContainer"),u=this._findById($,"actions"),v=this._findById($,"identifierLine"),w=v.width(),x=$?$.find(".sapUxAPObjectPageHeaderObjectImageContainer"):this.$().find(".sapUxAPObjectPageHeaderObjectImageContainer"),y=u.width()+x.width();i.width((0.95-(y/w))*100+"%");};
o.prototype._adaptObjectPageHeaderTitle=function($){var T=$.width(),u=$.find(".sapUxAPObjectPageHeaderTitleText"),v=u.length,w;for(var i=0;i<v;i++){w=q(u.get(i));w.toggleClass("sapUxAPObjectPageHeaderTitleTextRestrictedWidth",false);if(w.width()>T){w.toggleClass("sapUxAPObjectPageHeaderTitleTextRestrictedWidth",true);}}};
o.prototype._adaptActions=function(u){var M=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())||D.system.phone,$=this._oOverflowButton.$(),v=$.show().width(),w=this.getActions(),x=w.length,y;for(var i=0;i<x;i++){w[i].position=i;}w.sort(o._sortActionsByImportance);w.forEach(function(z){y=this._oActionSheetButtonMap[z.getId()];if(y){v+=z.$().width();if(u>v&&!M){this._setActionButtonVisibility(z,true);$.hide();}else{this._setActionButtonVisibility(z,false);$.show();}}},this);};
o.prototype._adaptOverflow=function(){var i=this._oOverflowActionSheet.getButtons();var H=i.some(function(u){return u.getVisible();});this._oOverflowButton.$().toggle(H);};
o.prototype._setActionButtonVisibility=function(i,v){var u=this._oActionSheetButtonMap[i.getId()];if(u){if(i.getVisible()){i._setInternalVisible(v);u.setVisible(!v);}else{u.setVisible(false);}}};
o.prototype._getActionsWidth=function(){var w=0;this.getActions().forEach(function(i){if(i instanceof b){i.$().show();if(D.system.phone){i.$().css("visibility","hidden");}w+=i.$().outerWidth(true);}});return w;};
o.prototype._findById=function($,i){var E;if(!i||!$){return null;}i=this.getId()+'-'+i;E="#"+i.replace(/(:|\.)/g,'\\$1');return $.find(E);};
o.prototype._getBreadcrumbsAggregation=function(){var i=this.getBreadcrumbs(),u=this._lazyLoadInternalAggregation('_breadCrumbs',true);return i||((u&&u.getLinks().length)?u:null);};
o.prototype._notifyParentOfChanges=function(i){var u=this.getParent();if(u&&typeof u._headerTitleChangeHandler==="function"){u._headerTitleChangeHandler(i);}};
o.prototype.setTitleSelectorTooltip=function(T){this._setTitleSelectorTooltip(T);this.setAggregation("titleSelectorTooltip",T,true);return this;};
o.prototype.destroyTitleSelectorTooltip=function(){this._setTitleSelectorTooltip(null);this.destroyAggregation("titleSelectorTooltip",true);return this;};
o.prototype.exit=function(){this._clearImageNotFoundHandler();if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}this._resetActionSheetMap();};
o.prototype.setNavigationBar=function(i){this.setAggregation("navigationBar",i);if(i&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":i});}return this;};
o.prototype._getAdaptableContent=function(){return this.getNavigationBar();};
o.prototype.isDynamic=function(){return false;};
o.prototype.getCompatibleHeaderContentClass=function(){return d;};
o.prototype.supportsToggleHeaderOnTitleClick=function(){return false;};
o.prototype.supportsTitleInHeaderContent=function(){return true;};
o.prototype.supportsAdaptLayoutForDomElement=function(){return true;};
o.prototype.supportsBackgroundDesign=function(){return false;};
o.prototype.getTitleText=function(){return this.getObjectTitle();};
o.prototype.snap=function(){this._adaptLayout();};
o.prototype.unSnap=function(){this._adaptLayout();};
o.prototype._toggleExpandButton=function(T){};
o.prototype._setShowExpandButton=function(v){};
o.prototype._focusExpandButton=function(){};
o.prototype._toggleFocusableState=function(F){};
return o;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderActionButton',["sap/m/Button","./library","./ObjectPageHeaderActionButtonRenderer"],function(B,l,O){"use strict";
var a=B.extend("sap.uxap.ObjectPageHeaderActionButton",{metadata:{interfaces:["sap.m.IOverflowToolbarContent"],library:"sap.uxap",properties:{hideText:{type:"boolean",defaultValue:true},hideIcon:{type:"boolean",defaultValue:false},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:l.Importance.High}},designtime:"sap/uxap/designtime/ObjectPageHeaderActionButton.designtime"}});
a.prototype.init=function(){B.prototype.init.call(this);this._bInternalVisible=this.getVisible();this._bInternalHiddenText=this.getHideText();};
a.prototype.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide();}};
a.prototype._getText=function(){if(this._bInternalHiddenText&&this.getHideText()){return"";}return this.getText();};
a.prototype.setHideText=function(v,i){this.setProperty("hideText",v,i);this._bInternalHiddenText=v;return this;};
a.prototype.setHideIcon=function(v,i){this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",v);return this.setProperty("hideIcon",v,i);};
a.prototype._setInternalVisible=function(v,i){this.$().toggle(v);if(v!=this._bInternalVisible){this._bInternalVisible=v;if(i){this.invalidate();}}};
a.prototype.setVisible=function(v){var r=B.prototype.setVisible.apply(this,arguments);this.getParent()&&this.getParent().invalidate();return r;};
a.prototype._getInternalVisible=function(){return this._bInternalVisible;};
a.prototype.getOverflowToolbarConfig=function(){var c={canOverflow:true,propsUnrelatedToSize:["importance"],getCustomImportance:function(){return this.getImportance();}.bind(this)};c.onBeforeEnterOverflow=function(A){A._bInternalHiddenText=false;A.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",false,true);};c.onAfterExitOverflow=function(A){A._bInternalHiddenText=A.getHideText();A.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",A.getHideIcon(),true);};return c;};
return a;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderActionButtonRenderer',["sap/m/ButtonRenderer","sap/ui/core/Renderer"],function(B,R){"use strict";var O=R.extend(B);O.apiVersion=2;return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageHeaderContent',["sap/ui/core/Control","./library","sap/m/Button","./ObjectImageHelper","./ObjectPageHeaderContentRenderer"],function(C,l,B,O,a){"use strict";var b=l.ObjectPageHeaderDesign;
var c=C.extend("sap.uxap.ObjectPageHeaderContent",{metadata:{library:"sap.uxap",interfaces:["sap.uxap.IHeaderContent"],properties:{contentDesign:{type:"sap.uxap.ObjectPageHeaderDesign",group:"Misc",defaultValue:b.Light,deprecated:true}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_editHeaderButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_placeholder:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"}}}});
c.prototype.onBeforeRendering=function(){var p=this.getParent(),e=this.getAggregation("_editHeaderButton");if(e){return;}if(p&&(p instanceof l.ObjectPageLayout)&&p.getShowEditHeaderButton()){e=this._getInternalBtnAggregation("_editHeaderButton","EDIT_HEADER","-editHeaderBtn","Transparent");e.attachPress(this._handleEditHeaderButtonPress,this);}};
c.prototype.exit=function(){var e=this.getAggregation("_editHeaderButton");if(e){e.detachPress(this._handleEditHeaderButtonPress,this);}};
c.prototype._handleEditHeaderButtonPress=function(e){this.getParent().fireEditHeaderButtonPress();};
c.prototype._getInternalBtnAggregation=function(A,s,d,e){if(!this.getAggregation(A)){var o=new B({text:sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText(s),type:e,id:this.getId()+d});this.setAggregation(A,o);}return this.getAggregation(A);};
c.prototype._getObjectImage=function(){if(!this.getAggregation("_objectImage")){var p=this.getParent(),h=p&&p.getHeaderTitle&&p.getHeaderTitle(),o=h&&O.createObjectImage(h);if(o){this.setAggregation("_objectImage",o,true);}}return this.getAggregation("_objectImage");};
c.prototype._destroyObjectImage=function(s){var o=this.getAggregation("_objectImage");if(o){o.destroy();this.getAggregation("_objectImage",null,s);}};
c.prototype._getPlaceholder=function(){if(!this.getAggregation("_placeholder")){var p=this.getParent(),h=p&&p.getHeaderTitle&&p.getHeaderTitle(),s=h.getShowPlaceholder();var P=s&&O.createPlaceholder();if(P){this.setAggregation("_placeholder",P,true);}}return this.getAggregation("_placeholder");};
c.prototype._getLayoutDataForControl=function(o){var L=o.getLayoutData();if(!L){return;}else if(L instanceof l.ObjectPageHeaderLayoutData){return L;}else if(L.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var d=L.getMultipleLayoutData();for(var i=0;i<d.length;i++){var e=d[i];if(e instanceof l.ObjectPageHeaderLayoutData){return e;}}}};
c.prototype.setVisible=function(v){this.getParent()&&this.getParent().toggleStyleClass("sapUxAPObjectPageLayoutNoHeaderContent",!v);return this.setProperty("visible",v);};
c.createInstance=function(d,v,s,p,S){return new c({content:d,visible:v,contentDesign:s,id:S});};
c.prototype.supportsPinUnpin=function(){return false;};
c.prototype.supportsChildPageDesign=function(){return true;};
c.prototype.supportsAlwaysExpanded=function(){return true;};
c.prototype._toggleCollapseButton=function(t){};
c.prototype._setShowCollapseButton=function(v){};
c.prototype._focusCollapseButton=function(){};
c.prototype._focusPinButton=function(){};
return c;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderContentRenderer',["./ObjectPageHeaderRenderer","./ObjectImageHelper"],function(O,a){"use strict";var b={apiVersion:2};
b.render=function(r,c){var p=c.getParent(),P=p&&p.isA("sap.uxap.ObjectPageLayout"),h=(p&&P)?p.getHeaderTitle():undefined,R=(p&&P)?(p.isA("sap.uxap.ObjectPageLayout")&&p.getShowTitleInHeaderContent()):false,d=P&&p.getShowEditHeaderButton()&&c.getContent()&&c.getContent().length>0;if(d){r.openStart("div",c).class("sapUxAPObjectPageHeaderContentFlexBox").class("sapUxAPObjectPageHeaderContentDesign-"+c.getContentDesign());if(h){r.class('sapUxAPObjectPageContentObjectImage-'+h.getObjectImageShape());}r.openEnd();}r.openStart("div",d?undefined:c);if(d){r.class("sapUxAPObjectPageHeaderContentCellLeft");}else{r.class("sapUxAPObjectPageHeaderContentDesign-"+c.getContentDesign());if(h){r.class('sapUxAPObjectPageContentObjectImage-'+h.getObjectImageShape());}}r.class("sapContrastPlus").class("ui-helper-clearfix").class("sapUxAPObjectPageHeaderContent");if(!c.getVisible()){r.class("sapUxAPObjectPageHeaderContentHidden");}r.openEnd();if(P&&p.getIsChildPage()){r.openStart("div").class("sapUxAPObjectChildPage").openEnd().close("div");}if(R){this._renderTitleImage(r,c,h);if(c.getContent().length==0){r.openStart("span").class("sapUxAPObjectPageHeaderContentItem").openEnd();this._renderTitle(r,h);r.close("span");}}c.getContent().forEach(function(i,I){this._renderHeaderContentItem(i,I,r,R,h,c);},this);r.close("div");if(d){this._renderEditButton(r,c);r.close("div");}};
b._renderHeaderContentItem=function(h,i,r,R,t,c){var H=false,d=false,l=c._getLayoutDataForControl(h),I=i===0;if(l){H=l.getShowSeparatorBefore();d=l.getShowSeparatorAfter();r.openStart("span").class("sapUxAPObjectPageHeaderWidthContainer").class("sapUxAPObjectPageHeaderContentItem").style("width",l.getWidth());if(d||H){r.class("sapUxAPObjectPageHeaderSeparatorContainer");}if(!l.getVisibleL()){r.class("sapUxAPObjectPageHeaderLayoutHiddenL");}if(!l.getVisibleM()){r.class("sapUxAPObjectPageHeaderLayoutHiddenM");}if(!l.getVisibleS()){r.class("sapUxAPObjectPageHeaderLayoutHiddenS");}r.openEnd();if(H){r.openStart("span").class("sapUxAPObjectPageHeaderSeparatorBefore").openEnd().close("span");}if(I&&R){this._renderTitle(r,t);}}else{if(I&&R){r.openStart("span").class("sapUxAPObjectPageHeaderContentItem").openEnd();this._renderTitle(r,t);}else{h.addStyleClass("sapUxAPObjectPageHeaderContentItem");}}r.renderControl(h);if(d){r.openStart("span").class("sapUxAPObjectPageHeaderSeparatorAfter").openEnd().close("span");}if(l||(I&&R)){r.close("span");}};
b._renderTitleImage=function(r,c,h){a._renderImageAndPlaceholder(r,{oHeader:h,oObjectImage:c._getObjectImage(),oPlaceholder:c._getPlaceholder(),bIsObjectIconAlwaysVisible:false,bAddSubContainer:false,sBaseClass:'sapUxAPObjectPageHeaderContentImageContainer'});};
b._renderTitle=function(r,h){O._renderObjectPageTitle(r,h,true);};
b._renderEditButton=function(r,h){r.openStart("div").class("sapUxAPObjectPageHeaderContentCellRight").openEnd();r.renderControl(h.getAggregation("_editHeaderButton"));r.close("div");};
return b;},true);
sap.ui.predefine('sap/uxap/ObjectPageHeaderLayoutData',["sap/ui/core/LayoutData","./library"],function(L,l){"use strict";
var O=L.extend("sap.uxap.ObjectPageHeaderLayoutData",{metadata:{library:"sap.uxap",properties:{visibleS:{type:"boolean",group:"Misc",defaultValue:true},visibleM:{type:"boolean",group:"Misc",defaultValue:true},visibleL:{type:"boolean",group:"Misc",defaultValue:true},showSeparatorBefore:{type:"boolean",group:"Misc",defaultValue:false},showSeparatorAfter:{type:"boolean",group:"Misc",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'auto'}}}});
return O;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderRenderer',["./ObjectImageHelper","sap/ui/Device"],function(O,D){"use strict";var a={apiVersion:2};
a.render=function(r,c){var n=c.getNavigationBar(),t=(c.getIsObjectIconAlwaysVisible()||c.getIsObjectTitleAlwaysVisible()||c.getIsObjectSubtitleAlwaysVisible()||c.getIsActionAreaAlwaysVisible()),p=c.getParent(),e=c.getAggregation("_expandButton"),o=c._lazyLoadInternalAggregation("_objectImage",true),P,I=D.system.desktop,b=p&&p.isA("sap.uxap.ObjectPageLayout")&&((p.getHeaderContent()&&p.getHeaderContent().length>0&&p.getShowHeaderContent())||(p.getShowHeaderContent()&&p.getShowTitleInHeaderContent()));r.openStart("div",c).class('sapUxAPObjectPageHeader').class('sapUxAPObjectPageHeaderDesign-'+c.getHeaderDesign()).openEnd();if(n){r.openStart("div").class("sapUxAPObjectPageHeaderNavigation").openEnd();r.renderControl(n);r.close("div");}r.openStart("div",c.getId()+"-identifierLine").class('sapUxAPObjectPageHeaderIdentifier');if(t){r.class('sapUxAPObjectPageHeaderIdentifierForce');}r.openEnd();if(p&&p.isA("sap.uxap.ObjectPageLayout")&&p.getIsChildPage()){r.openStart("div").class("sapUxAPObjectChildPage").openEnd().close("div");}if(c.getShowPlaceholder()){P=c._lazyLoadInternalAggregation("_placeholder",true);}O._renderImageAndPlaceholder(r,{oHeader:c,oObjectImage:o,oPlaceholder:P,bIsObjectIconAlwaysVisible:c.getIsObjectIconAlwaysVisible(),bAddSubContainer:true,sBaseClass:'sapUxAPObjectPageHeaderObjectImageContainer'});r.openStart("span",c.getId()+"-identifierLineContainer").class('sapUxAPObjectPageHeaderIdentifierContainer').openEnd();this._renderObjectPageTitle(r,c);r.close("span");r.openStart("span",c.getId()+"-actions").class('sapUxAPObjectPageHeaderIdentifierActions');if(c.getIsActionAreaAlwaysVisible()){r.class('sapUxAPObjectPageHeaderIdentifierActionsForce');}r.openEnd();if(I&&b){e.addStyleClass("sapUxAPObjectPageHeaderExpandButton");r.renderControl(e);}var A=c.getActions();for(var i=0;i<A.length;i++){var d=A[i];r.renderControl(d);}var f=c.getAggregation("_overflowButton");r.renderControl(f);this._renderSideContentBtn(r,c);r.close("span");r.close("div");r.close("div");};
a._renderObjectPageTitle=function(r,c,t){var o=c.getObjectTitle(),m=(c.getShowMarkers()&&(c.getMarkFavorite()||c.getMarkFlagged())),b=c._getBreadcrumbsAggregation(),T=c.getTooltip_Text(),i=t?"-content":"";if(!t&&b){r.renderControl(b);}r.openStart("h2",c.getId()+"-title"+i).class('sapUxAPObjectPageHeaderIdentifierTitle');if(c.getIsObjectTitleAlwaysVisible()){r.class('sapUxAPObjectPageHeaderIdentifierTitleForce');}if(t){r.class('sapUxAPObjectPageHeaderIdentifierTitleInContent');}if(c.getShowTitleSelector()){r.class('sapUxAPObjectPageHeaderTitleFollowArrow');}r.openEnd();r.openStart("span",c.getId()+"-innerTitle"+i).class("sapUxAPObjectPageHeaderTitleText").class("sapUxAPObjectPageHeaderTitleTextWrappable");if(T){r.attr("title",T);}r.openEnd();if(m||c.getShowTitleSelector()||c.getMarkLocked()||c.getMarkChanges()){var s=o.substr(o.lastIndexOf(" ")+1);var d=o.substr(0,o.lastIndexOf(" ")+1);if(s.length===1){s=o;d='';}r.text(d);r.close("span");r.openStart("span").class('sapUxAPObjectPageHeaderNowrapMarkers');if(c.getMarkLocked()||c.getMarkChanges()){r.class('sapUxAPObjectPageHeaderMarks');}r.openEnd();r.openStart("span").class("sapUxAPObjectPageHeaderTitleText").openEnd().text(s).close("span");this._renderMarkers(r,c);if(c.getMarkLocked()){this._renderLock(r,c,t);}else if(c.getMarkChanges()){this._renderMarkChanges(r,c,t);}this._renderSelectTitleArrow(r,c,t);r.close("span");}else{r.text(o);r.close("span");}r.close("h2");if(c.getObjectSubtitle()){r.openStart("div",c.getId()+"-subtitle"+i).class('sapUxAPObjectPageHeaderIdentifierDescription');if(c.getIsObjectSubtitleAlwaysVisible()){r.class('sapUxAPObjectPageHeaderIdentifierDescriptionForce');}if(t){r.class('sapUxAPObjectPageHeaderIdentifierSubTitleInContent');}r.openEnd();r.text(c.getObjectSubtitle());r.close("div");}};
a._renderSelectTitleArrow=function(r,c,t){if(c.getShowTitleSelector()){r.openStart("span").class("sapUxAPObjectPageHeaderTitleArrow").openEnd();if(t){r.renderControl(c._oTitleArrowIconCont);}else{r.renderControl(c._oTitleArrowIcon);}r.close("span");}};
a._renderSideContentBtn=function(r,c){var s=c.getSideContentButton();if(s){r.openStart("span");r.class("sapUxAPObjectPageHeaderSideContentBtn");r.openEnd();r.openStart("span").class("sapUxAPObjectPageHeaderSeparator").openEnd().close("span");r.renderControl(s);r.close("span");}};
a._renderMarkChanges=function(r,c,t){r.openStart("span").class("sapUxAPObjectPageHeaderChangesBtn").class("sapUiSizeCompact").openEnd();if(t){r.renderControl(c._oChangesIconCont);}else{r.renderControl(c._oChangesIcon);}r.close("span");};
a._renderLock=function(r,c,t){r.openStart("span").class("sapUxAPObjectPageHeaderLockBtn").class("sapUiSizeCompact").openEnd();if(t){r.renderControl(c._oLockIconCont);}else{r.renderControl(c._oLockIcon);}r.close("span");};
a._renderMarkers=function(r,c){var I=[];if(c.getShowMarkers()){I.push(c._oFavIcon);I.push(c._oFlagIcon);this._renderMarkersAria(r,c);r.openStart("span",c.getId()+"-markers").class("sapMObjStatusMarker").attr("aria-describedby",c.getId()+"-markers-aria").openEnd();for(var i=0;i<I.length;i++){r.renderControl(I[i]);}r.close("span");}};
a._renderMarkersAria=function(r,c){var A="";if(c.getMarkFlagged()){A+=(c.oLibraryResourceBundle.getText("ARIA_FLAG_MARK_VALUE")+" ");}if(c.getMarkFavorite()){A+=(c.oLibraryResourceBundle.getText("ARIA_FAVORITE_MARK_VALUE")+" ");}if(A!==""){r.openStart("div",c.getId()+"-markers-aria").attr("aria-hidden","false").class("sapUiHidden").openEnd().text(A).close("div");}};
return a;},true);
sap.ui.predefine('sap/uxap/ObjectPageLayout',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/core/Configuration","sap/ui/core/Control","sap/ui/Device","sap/ui/base/ManagedObject","sap/ui/core/delegate/ScrollEnablement","./ObjectPageSectionBase","./ObjectPageSection","./ObjectPageSubSection","./ObjectPageHeaderContent","./LazyLoading","./ObjectPageLayoutABHelper","./ThrottledTaskHelper","sap/m/ScrollBar","sap/ui/core/library","./library","./ObjectPageLayoutRenderer","sap/base/Log","sap/base/util/array/diff","sap/ui/dom/getScrollbarSize","sap/base/assert","sap/base/util/isEmptyObject","sap/base/util/merge","sap/ui/events/KeyCodes","sap/ui/events/F6Navigation","sap/ui/dom/getFirstEditableInput","sap/ui/core/theming/Parameters",'sap/ui/dom/units/Rem'],function(q,M,R,C,a,D,b,S,O,c,d,e,L,A,T,f,g,l,h,i,j,k,m,n,o,K,F,p,P,r){"use strict";var s=g.TitleLevel;var t=g.AccessibleLandmarkRole;var u=l.ObjectPageSubSectionLayout;var v=["toggleAnchorBar","_moveHeader"];
var w=a.extend("sap.uxap.ObjectPageLayout",{metadata:{library:"sap.uxap",properties:{showAnchorBar:{type:"boolean",defaultValue:true},showAnchorBarPopover:{type:"boolean",defaultValue:true},upperCaseAnchorBar:{type:"boolean",defaultValue:true},backgroundDesignAnchorBar:{type:"sap.m.BackgroundDesign",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},enableLazyLoading:{type:"boolean",defaultValue:false},subSectionLayout:{type:"sap.uxap.ObjectPageSubSectionLayout",defaultValue:u.TitleOnTop},sectionTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:s.Auto},useIconTabBar:{type:"boolean",group:"Misc",defaultValue:false},showHeaderContent:{type:"boolean",group:"Misc",defaultValue:true},useTwoColumnsForLargeScreen:{type:"boolean",group:"Appearance",defaultValue:false},showTitleInHeaderContent:{type:"boolean",group:"Appearance",defaultValue:false},showOnlyHighImportance:{type:"boolean",group:"Behavior",defaultValue:false},isChildPage:{type:"boolean",group:"Appearance",defaultValue:false},alwaysShowContentHeader:{type:"boolean",group:"Behavior",defaultValue:false},headerContentPinnable:{type:"boolean",group:"Behavior",defaultValue:true},headerContentPinned:{type:"boolean",group:"Behavior",defaultValue:false},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},showEditHeaderButton:{type:"boolean",group:"Behavior",defaultValue:false},flexEnabled:{type:"boolean",group:"Misc",defaultValue:false},showFooter:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{selectedSection:{type:"sap.uxap.ObjectPageSection",multiple:false}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.uxap.ObjectPageSection",multiple:true,singularName:"section"},headerTitle:{type:"sap.uxap.IHeaderTitle",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},footer:{type:"sap.m.IBar",multiple:false},landmarkInfo:{type:"sap.uxap.ObjectPageAccessibleLandmarkInfo",multiple:false},_anchorBar:{type:"sap.uxap.AnchorBar",multiple:false,visibility:"hidden"},_iconTabBar:{type:"sap.m.IconTabBar",multiple:false,visibility:"hidden"},_headerContent:{type:"sap.uxap.IHeaderContent",multiple:false,visibility:"hidden"},_customScrollBar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{headerContentPinnedStateChange:{parameters:{pinned:{type:"boolean"}}},toggleAnchorBar:{parameters:{fixed:{type:"boolean"}}},sectionChange:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},editHeaderButtonPress:{},navigate:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},subSectionVisibilityChange:{parameters:{visibleSubSections:{type:"object"}}}},dnd:{draggable:false,droppable:true},designtime:"sap/uxap/designtime/ObjectPageLayout.designtime"}});
w.HEADER_CALC_DELAY=350;w.DOM_CALC_DELAY=200;w.MAX_SNAP_POSITION_OFFSET=20;w.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;w.TITLE_LEVEL_AS_ARRAY=Object.keys(s);w.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};w.BREAK_POINTS={DESKTOP:1439,TABLET:1024,PHONE:600};w.MEDIA={PHONE:"sapUxAPObjectPageLayout-Std-Phone",TABLET:"sapUxAPObjectPageLayout-Std-Tablet",DESKTOP:"sapUxAPObjectPageLayout-Std-Desktop",DESKTOP_XL:"sapUxAPObjectPageLayout-Std-Desktop-XL"};w.DYNAMIC_HEADERS_MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop",DESKTOP_XL:"sapFDynamicPage-Std-Desktop-XL"};w.DIV="div";w.HEADER="header";w.FOOTER="section";w.FOOTER="section";w.HEADER_CONTENT_PADDING_BOTTOM=r.toPx("1rem");w.SHOW_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterShow";w.HIDE_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterHide";w.NO_NAVIGATION_CLASS_NAME="sapUxAPObjectPageNoNavigation";
w.prototype._getFirstEditableInput=function(y){var z=this.getDomRef(y);return p(z);};
w.prototype._focusFirstEditableInput=function(y){this._getFirstEditableInput(y).focus();};
w._getNextTitleLevelEntry=function(y){var z=w.TITLE_LEVEL_AS_ARRAY.indexOf(y),B=z!==-1,H=B&&(z!==w.TITLE_LEVEL_AS_ARRAY.length-1);if(!B){return s.Auto;}return w.TITLE_LEVEL_AS_ARRAY[H?z+1:z];};
w._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap");};
w.prototype.init=function(){this.oCore=sap.ui.getCore();this._bFirstRendering=true;this._bDomReady=false;this._bPinned=false;this._bStickyAnchorBar=false;this._bHeaderInTitleArea=false;this._bHeaderExpanded=true;this._bHeaderBiggerThanAllowedHeight=false;this._bDelayDOMBasedCalculations=true;this._iStoredScrollTop=0;this._oStoredScrolledSubSectionInfo={};this._bAllContentFitsContainer=false;this._bIsFooterAanimationGoing=false;this._bInternalAnchorBarVisible=true;this._oVisibleSubSections=0;this._$footerWrapper=[];this._$opWrapper=[];this._$anchorBar=[];this._$titleArea=[];this._$stickyAnchorBar=[];this._$headerContent=[];this._$stickyHeaderContent=[];this._bMobileScenario=false;this._oSectionInfo={};this._aSectionBases=[];this._sScrolledSectionId="";this._iScrollToSectionDuration=600;this._$spacer=[];this.iHeaderContentHeight=0;this.iStickyHeaderContentHeight=0;this.iHeaderTitleHeight=0;this.iHeaderTitleHeightStickied=0;this.iAnchorBarHeight=0;this.iFooterHeight=0;this.iTotalHeaderSize=0;this._iHeaderContentPaddingBottom=0;this._oScrollContainerLastState={};this._iREMSize=parseInt(q("body").css("font-size"));this._iOffset=parseInt(0.25*this._iREMSize);this._iResizeId=null;this._iAfterRenderingDomReadyTimeout=null;this._oABHelper=new A(this);this._initializeScroller();this._attachSnapListeners();};
w.prototype.onBeforeRendering=function(){var H,y;this._deregisterScreenSizeListener();if(this._oLazyLoading){this._oLazyLoading.destroy();}this._oLazyLoading=new L(this);this._deregisterCustomEvents();if(!this.getVisible()){return;}if(!this.getSelectedSection()){this._bHeaderExpanded=true;}this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._checkAlwaysShowContentHeader()){this._bHeaderExpanded=true;}this._bHeaderInTitleArea=this._shouldPreserveHeaderInTitleArea();this._createHeaderContent();this._getHeaderContent().setContentDesign(this._getHeaderDesign());this._oABHelper._getAnchorBar().setProperty("upperCase",this.getUpperCaseAnchorBar(),true);this._storeScrollLocation();this._applyUxRules();if(!n(this._oSectionInfo)&&this._bFirstRendering){this._preloadSectionsOnBeforeFirstRendering();this._bFirstRendering=false;}this._bStickyAnchorBar=this._shouldPreserveHeaderInTitleArea();this._handleExpandButtonPressEventLifeCycle(false);this._attachTitlePressHandler();H=this._getHeaderContent();if(H&&H.supportsPinUnpin()){y=this.getHeaderContentPinnable()&&!this.getPreserveHeaderStateOnScroll();this._getHeaderContent().setPinnable(y);if(y){this._attachPinPressHandler();}}this._attachVisualIndicatorsPressHandlers(this._handleDynamicTitlePress,this);if(D.system.desktop){this._attachVisualIndicatorMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);this._attachTitleMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);}if(this.getFooter()&&this._bIsFooterAanimationGoing){this._onToggleFooterAnimationEnd(this.getFooter());}this._$titleArea=[];};
w.prototype.setBackgroundDesignAnchorBar=function(B){var y=this.getBackgroundDesignAnchorBar();if(y===B){return this;}this.setProperty("backgroundDesignAnchorBar",B);this._oABHelper._getAnchorBar().setBackgroundDesign(B);return this;};
w.prototype.setToggleHeaderOnTitleClick=function(y){var z=this.getHeaderTitle(),B=this.setProperty("toggleHeaderOnTitleClick",y,true);if(!z||!z.supportsToggleHeaderOnTitleClick()){i.warning("Setting toggleHeaderOnTitleClick will not take effect as it is not supported in the ObjectPageHeader, read the API Doc for more information",this);return B;}y=this.getProperty("toggleHeaderOnTitleClick");this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();return B;};
w.prototype._attachTitlePressHandler=function(){var y=this.getHeaderTitle();if(x(y)&&!this._bAlreadyAttachedTitlePressHandler){y.attachEvent(w.EVENTS.TITLE_PRESS,this._handleDynamicTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};
w.prototype._attachSnapListeners=function(){v.forEach(function(E){this.attachEvent(E,function(){this.fireEvent("_snapChange");});},this);};
w.prototype._toggleHeaderVisibility=function(y){var H=this._getHeaderContent();if(x(H)){H.$().toggleClass("sapUxAPObjectPageHeaderContentHidden",!y);}};
w.prototype._snapHeader=function(y,U){var I,H=this._getHeaderContent();if(H&&H.supportsPinUnpin()&&this._bPinned){this._unPin(U);H.getAggregation("_pinButton").setPressed(false);y=true;}this._toggleHeaderTitle(false,true);this._toggleHeaderVisibility(y);this._moveAnchorBarToTitleArea();if(y){this._moveHeaderToContentArea();this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout(true);I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));if(I){this._scrollTo(this._getSnapPosition()+1);}return;}this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();};
w.prototype._expandHeader=function(y){this._toggleHeaderTitle(true,true);this._toggleHeaderVisibility(true);if(y){this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();return;}this._moveAnchorBarToContentArea();this._moveHeaderToContentArea();this._scrollTo(0,0,0);this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();if(this._isHeaderPinnable()){this._getHeaderContent()._getPinButton().setVisible(!this._headerBiggerThanAllowedToBeExpandedInTitleArea());}};
w.prototype._handleDynamicTitlePress=function(){if(!this.getToggleHeaderOnTitleClick()||!this._hasVisibleDynamicTitleAndHeader()){return;}var E=!this._bHeaderExpanded,I,y,z;if(E){I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));y=!this._headerBiggerThanAllowedToBeExpandedInTitleArea()&&(this._shouldPreserveHeaderInTitleArea()||!I);this._expandHeader(y);if(!y){this._scrollTo(0,0);}}else{z=!this._shouldPreserveHeaderInTitleArea()&&(!this._bAllContentFitsContainer||this._headerBiggerThanAllowedToBeExpandedInTitleArea());this._snapHeader(z,true);}this.getHeaderTitle()._getFocusSpan().trigger("focus");};
w.prototype._attachPinPressHandler=function(){var H=this._getHeaderContent();if(x(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(w.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};
w.prototype._handleExpandButtonPressEventLifeCycle=function(y){var H=this.getHeaderTitle(),z=this._hasDynamicTitle(),E;if(H&&!z){E=H.getAggregation("_expandButton");if(E){E[y?"attachPress":"detachPress"](this._handleExpandButtonPress,this);}}};
w.prototype._adjustSelectedSectionByUXRules=function(){var y=this.oCore.byId(this.getSelectedSection()),V=y&&this._sectionCanBeRenderedByUXRules(y);if(!V){if(this._oFirstVisibleSection){y=this._oFirstVisibleSection;this.setAssociation("selectedSection",y.getId(),true);}else{this.setAssociation("selectedSection",null,true);return;}}};
w.prototype._sectionCanBeRenderedByUXRules=function(y){if(!(y instanceof O)){return false;}var z=y.getBindingInfo("subSections");if(!z&&(!y.getVisible()||!y._getInternalVisible())){return false;}var B=this._aSectionBases.map(function(E){return E.getId();});return(B.indexOf(y.getId())>-1);};
w.prototype._getSectionsToRender=function(){this._adjustSelectedSectionByUXRules();var y=this.oCore.byId(this.getSelectedSection());if(this.getUseIconTabBar()&&y){return[y];}else{return this.getSections();}};
w.prototype._preloadSectionsOnBeforeFirstRendering=function(){var y=this._getSectionsToPreloadOnBeforeFirstRendering();this._connectModelsForSections(y);if(this.getEnableLazyLoading()){y.forEach(function(z){this.fireEvent("subSectionPreload",{subSection:z});},this);}};
w.prototype._getSectionsToPreloadOnBeforeFirstRendering=function(){var y,z,I;if(!this.getEnableLazyLoading()){return this._getSectionsToRender();}if(this.getUseIconTabBar()){return this._oLazyLoading.getSubsectionsToPreload(this._grepCurrentTabSectionBases());}this._adjustSelectedSectionByUXRules();z=this.oCore.byId(this.getSelectedSection());if(!z||(z===this._oFirstVisibleSection)){return this._oLazyLoading.getSubsectionsToPreload(this._aSectionBases);}I=this.indexOfSection(z);var B=function(E){var G=E.isA("sap.uxap.ObjectPageSection")?E:E.getParent();return this.indexOfSection(G)>=I;}.bind(this);y=this._aSectionBases.filter(B);return this._oLazyLoading.getSubsectionsToPreload(y);};
w.prototype._grepCurrentTabSectionBases=function(){var y=[],z,B,E,G;this._adjustSelectedSectionByUXRules();z=this.oCore.byId(this.getSelectedSection());if(z){B=z.getId();this._aSectionBases.forEach(function(H){E=H.getParent();G=E&&E.getId();if(H.getId()===B||G===B){y.push(H);}});}return y;};
w.prototype.onAfterRendering=function(){var H=this._getHeaderContent(),y=this.getFooter(),z,W=this._getWidth(this);this._bInvalidatedAndNotRerendered=false;this._iResizeId=R.register(this,this._onUpdateScreenSize.bind(this));this._ensureCorrectParentHeight();if(this._$sectionsContainer){this._$sectionsContainer.off("focusout");this._$sectionsContainer.off("focusin");}this._cacheDomElements();if(this._$sectionsContainer){this._$sectionsContainer.on("focusin",function(){this._skipToNextFastGroup=true;}.bind(this));this._$sectionsContainer.on("focusout",function(){this._skipToNextFastGroup=false;}.bind(this));}if(this._hasDynamicTitle()){this.addStyleClass("sapUxAPObjectPageHasDynamicTitle");}if(W>0){this._updateMedia(W,w.MEDIA);}this._$opWrapper.on("scroll.OPL",this._onScroll.bind(this));if(this._bDomReady&&this.$().parents(":hidden").length===0){this._onAfterRenderingDomReady();}else{if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}this._iAfterRenderingDomReadyTimeout=setTimeout(this._onAfterRenderingDomReady.bind(this),this._getDOMCalculationDelay());}if(H&&H.supportsPinUnpin()){this._updatePinButtonState();}if(y){z=w._getLibraryResourceBundle().getText("FOOTER_ARIA_LABEL");y.$().attr("aria-label",z);}this._handleExpandButtonPressEventLifeCycle(true);};
w.prototype._onAfterRenderingDomReady=function(){var y,z,B,W=this._getWidth(this);if(this._bIsBeingDestroyed){return;}this._adjustSelectedSectionByUXRules();y=this.getSelectedSection();z=this.oCore.byId(y);this._iAfterRenderingDomReadyTimeout=null;this._bDomReady=true;this._adjustHeaderHeights();this._initAnchorBarScroll();if(y){if(this.getUseIconTabBar()){this._setSelectedSectionId(y);this._setCurrentTabSection(z);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(z);this._checkSubSectionVisibilityChange();}else{this.scrollToSection(y,0);}}this._toggleScrolling(!this._bAllContentFitsContainer);if(D.system.desktop){this._$opWrapper.on("scroll.OPL",this.onWrapperScroll.bind(this));}this._registerOnContentResize();this.getHeaderTitle()&&this._shiftHeaderTitle();this.getFooter()&&this._shiftFooter();this._setSectionsFocusValues();if(this.getPreserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(!this._bHeaderExpanded){B=!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer;this._snapHeader(B);}this._restoreScrollPosition();this.oCore.getEventBus().publish("sap.ui","ControlForPersonalizationRendered",this);this._updateMedia(W,w.MEDIA);if(this._hasDynamicTitle()){this._updateMedia(W,w.DYNAMIC_HEADERS_MEDIA);}this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();this.fireEvent("onAfterRenderingDOMReady");};
w.prototype._toggleScrolling=function(E){if(this._$opWrapper.length){this._$opWrapper.get(0).style.overflowY=E?"auto":"hidden";}};
w.prototype._shiftFooter=function(){var $=this.$("footerWrapper"),y=this._calculateShiftOffset();$.css(y.sStyleAttribute,y.iMarginalsOffset+"px");};
w.prototype._calculateShiftOffset=function(){var H=0,y=this.oCore.getConfiguration().getRTL()?"left":"right",z=this._hasVerticalScrollBar(),B=this._iOffset,E;if(D.system.desktop){E=k().width;H=E;if(!z){H=0;B+=E;}}return{"sStyleAttribute":y,"iActionsOffset":B,"iMarginalsOffset":H};};
w.prototype._getDOMCalculationDelay=function(){return this._bDelayDOMBasedCalculations?w.HEADER_CALC_DELAY:0;};
w.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._oLazyLoading){this._oLazyLoading.destroy();this._oLazyLoading=null;}this._deregisterScreenSizeListener();if(this._iContentResizeId){R.deregister(this._iContentResizeId);}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}this._deregisterCustomEvents();this._oFirstVisibleSection=null;this._oFirstVisibleSubSection=null;};
w.prototype._getCustomScrollBar=function(){if(!this.getAggregation("_customScrollBar")){var V=new f(this.getId()+"-vertSB",{scrollPosition:0,scroll:this.onCustomScrollerScroll.bind(this),visible:false});this.setAggregation("_customScrollBar",V,true);}return this.getAggregation("_customScrollBar");};
w.prototype.onWrapperScroll=function(E){var y=Math.max(E.target.scrollTop,0);if(this._getCustomScrollBar()){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getCustomScrollBar().setScrollPosition(y);}};
w.prototype.onCustomScrollerScroll=function(E){var y=Math.max(this._getCustomScrollBar().getScrollPosition(),0);if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;q(this._$opWrapper).scrollTop(y);};
w.prototype.setShowOnlyHighImportance=function(V){var y=this.getShowOnlyHighImportance();if(y!==V){this.setProperty("showOnlyHighImportance",V,true);this.getSections().forEach(function(z){z._updateImportance();});}return this;};
w.prototype.setIsHeaderContentAlwaysExpanded=function(V){var y=this.getAlwaysShowContentHeader();var z=(D.system.phone||D.system.tablet);if(y!==V){this.setProperty("alwaysShowContentHeader",V,z);}return this;};
w.prototype.setShowEditHeaderButton=function(V){var y=this.getShowEditHeaderButton(),H=this.getAggregation("_headerContent");if(y!==V){this.setProperty("showEditHeaderButton",V,true);H&&H.invalidate();}return this;};
w.prototype._initializeScroller=function(){if(this._oScroller){return;}this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:false,vertical:true});this._oScroller.setOnAfterScrollToElement(this._onAfterScrollToElement.bind(this));};
w.prototype._onAfterScrollToElement=function(){var y=this._$opWrapper.scrollTop(),z=this._bStickyAnchorBar;this._onScroll({target:{scrollTop:y}});if(this._bStickyAnchorBar&&!z&&this._$opWrapper.scrollTop()===y){this._$opWrapper.scrollTop(y-this.iAnchorBarHeight);}};
w.prototype.setSelectedSection=function(I){var y,z;if(I instanceof O){I=I.getId();}else if(I!=null&&typeof I!=="string"){m(false,"setSelectedSection(): sId must be a string, an instance of sap.uxap.ObjectPageSection or null");return this;}if(I===this.getSelectedSection()){return this;}if(I===null){this.setAssociation("selectedSection",null,true);this._expandHeader(this._bHeaderInTitleArea);this._selectFirstVisibleSection();return this;}this.scrollToSection(I);y=c._getClosestSection(I);z=(y instanceof c)?y.getId():y;return this.setAssociation("selectedSection",z,true);};
w.prototype._selectFirstVisibleSection=function(){if(this.getUseIconTabBar()&&this._oFirstVisibleSection){this._adjustSelectedSectionByUXRules();this._setCurrentTabSection(this._oFirstVisibleSection);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(this._oFirstVisibleSection);this._preloadSectionsOnBeforeScroll(this._oFirstVisibleSection);this._updateSelectionOnScroll(0);this._checkSubSectionVisibilityChange();}else if(this.$().is(":visible")){this._scrollTo(0,0);if(!this._bInvalidatedAndNotRerendered){this._sScrolledSectionId=null;this._updateSelectionOnScroll(0);}}};
w.prototype._ensureCorrectParentHeight=function(){if(this._bCorrectParentHeightIsSet){return;}if(this.getParent().getHeight&&["","auto"].indexOf(this.getParent().getHeight())!==-1){this.$().parent().css("height","100%");}this._bCorrectParentHeightIsSet=true;};
w.prototype._cacheDomElements=function(){this._$footerWrapper=this.$("footerWrapper");this._$titleArea=this.$("headerTitle");this._$anchorBar=this.$("anchorBar");this._$stickyAnchorBar=this.$("stickyAnchorBar");this._$opWrapper=this.$("opwrapper");this._$spacer=this.$("spacer");this._$headerContent=this.$("headerContent");this._$stickyHeaderContent=this.$("stickyHeaderContent");this._$contentContainer=this.$("scroll");this._$sectionsContainer=this.$("sectionsContainer");this._$skipFastGroupAnchor=this.$("skipFastGroupAnchor");this._oScroller._$Container=this._$opWrapper;this._bDomElementsCached=true;};
w.prototype._handleExpandButtonPress=function(E){this._expandHeader(true);};
w.prototype._toggleHeaderTitle=function(E,U){var H=this.getHeaderTitle();if(this._$titleArea.length){this._$titleArea.toggleClass("sapUxAPObjectPageHeaderStickied",!E);this._$titleArea.toggleClass("sapUxAPObjectPageHeaderSnappedTitleOnMobile",this._hasDynamicTitleWithSnappedTitleOnMobile()&&!E);}if(E){H&&H.unSnap(U);}else{H&&H.snap(U);}};
w.prototype._moveHeaderToTitleArea=function(){this._$headerContent.children().appendTo(this._$stickyHeaderContent);this._bHeaderInTitleArea=true;this.fireEvent("_moveHeader",{fixed:true});this._bSupressModifyOnScrollOnce=true;};
w.prototype._moveHeaderToContentArea=function(){if(this._bHeaderInTitleArea){this._$headerContent.append(this._$stickyHeaderContent.children());this._$stickyHeaderContent.children().remove();this._bHeaderInTitleArea=false;this.fireEvent("_moveHeader",{fixed:false});}};
w.prototype._updateNavigation=function(){if(this.getShowAnchorBar()){this._oABHelper._buildAnchorBar();}};
w.prototype._applyUxRules=function(I){var y,z,V,B,E,G,U,H,J,N,Q,W,X={};y=this.getSections()||[];B=0;G=this.getShowAnchorBar();U=this.getUseIconTabBar();H=null;this._cleanMemory();y.forEach(function(Y){if(!Y.getVisible()){return true;}this._registerSectionBaseInfo(Y);z=Y.getSubSections()||[];V=0;J=null;z.forEach(function(Z){if(!Z.getVisible()){return true;}this._registerSectionBaseInfo(Z);E=Z.getVisibleBlocksCount();if(E===0){Z._setInternalVisible(false,I);i.info("ObjectPageLayout :: noVisibleBlock UX rule matched","subSection "+Z.getTitle()+" forced to hidden");}else{Z._setInternalVisible(true,I);X[Z.getId()]=true;V++;if(!J){J=Z;}if(this._shouldApplySectionTitleLevel(Z)){Z._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(Z),I);}}},this);if(V==0){Y._setInternalVisible(false,I);i.info("ObjectPageLayout :: noVisibleSubSection UX rule matched","section "+Y.getTitle()+" forced to hidden");}else{Y._setInternalVisible(true,I);X[Y.getId()]=true;if(!H){H=Y;W=V;}if(this.getSubSectionLayout()===u.TitleOnTop&&V===1&&J.getTitle().trim()!==""){i.info("ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched","section "+Y.getTitle()+" is taking its single subsection title "+J.getTitle());Y._setInternalTitle(J.getTitle(),I);X[J.getId()]=false;J._setBorrowedTitleDomId(Y.getId()+"-title");}else{Y._setInternalTitle("",I);}if(V===1&&!J.getTitle().trim()){J._setBorrowedTitleDomId(Y.getId()+"-title");}if(this._shouldApplySectionTitleLevel(Y)){Y._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(Y),I);}B++;}if(U){X[Y.getId()]=false;}},this);if(B<=1){G=false;i.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched","anchorBar forced to hidden");if(U&&H){X[H.getId()]=true;}}else if(H&&G){N=true;X[H.getId()]=false;i.info("ObjectPageLayout :: firstSectionTitleHidden UX rule matched","section "+H.getTitle()+" title forced to hidden");}this.toggleStyleClass(w.NO_NAVIGATION_CLASS_NAME,B<=1);Object.keys(X).forEach(function(Y){this.oCore.byId(Y)._setInternalTitleVisible(X[Y],I);}.bind(this));if(G){this._oABHelper._buildAnchorBar();}this._setInternalAnchorBarVisible(G,I);this._oFirstVisibleSection=H;this._oFirstVisibleSubSection=this._getFirstVisibleSubSection(H);this._bAllContentFitsContainer=(B===1)&&(V===1)&&this._oFirstVisibleSubSection.hasStyleClass(d.FIT_CONTAINER_CLASS);if(N&&(W===1)){Q=this.getAggregation("_anchorBar").getContent();if(Q.length){this._oFirstVisibleSubSection._setBorrowedTitleDomId(Q[0].getId()+"-content");}}this._checkSubSectionVisibilityChange();};
w.prototype._checkSubSectionVisibilityChange=function(){var U=this.getUseIconTabBar(),y=U&&sap.ui.getCore().byId(this.getSelectedSection()),z=y?[y]:this._getVisibleSections(),V={},I;z.forEach(function(B){B.getSubSections().forEach(function(E){I=E.getVisible()&&E._getInternalVisible();if(I){V[E.getId()]=E;}});});if(j(Object.keys((this._oVisibleSubSections)),Object.keys(V)).length){this._oVisibleSubSections=V;this.fireEvent("subSectionVisibilityChange",{visibleSubSections:V});}};
w.prototype.setUseIconTabBar=function(V){var y=this.getUseIconTabBar();if(V!=y){this._applyUxRules();}this.setProperty("useIconTabBar",V);return this;};
w.prototype.onsapskipforward=function(E){if(this._skipToNextFastGroup){this._handleGroupNavigation(E,true);}};
w.prototype.onsapskipback=function(E){if(this._skipToNextFastGroup){this._handleGroupNavigation(E,false);}};
w.prototype._handleGroupNavigation=function(E,y){var z={target:y?this._$skipFastGroupAnchor[0]:this._$sectionsContainer[0]};E.type="keydown";F.handleF6GroupNavigation(E,z);};
w.prototype._setCurrentTabSection=function(y,I){if(!y){return;}var z;if(y instanceof sap.uxap.ObjectPageSubSection){z=y;y=y.getParent();}else{z=this._getFirstVisibleSubSection(y);}if(this._oCurrentTabSection!==y){this._renderSection(y);this._oCurrentTabSection=y;}this._oCurrentTabSubSection=z;};
w.prototype._renderSection=function(y){var $=this.$().find(".sapUxAPObjectPageContainer"),z;if(y&&$.length){z=this.oCore.createRenderManager();this.getSections().forEach(function(B){if((B.getId()===y.getId())){z.renderControl(y);}else{z.cleanupControlWithoutRendering(B);}});z.flush($[0]);z.destroy();}};
w.prototype.setShowAnchorBarPopover=function(V,y){var z=this.getProperty("showAnchorBarPopover"),V=this.validateProperty("showAnchorBarPopover",V),B=this.getSelectedSection();if(V===z){return this;}this._oABHelper._getAnchorBar().setShowPopover(V);this._oABHelper._buildAnchorBar();this._setSelectedSectionId(B);return this.setProperty("showAnchorBarPopover",V,true);};
w.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible;};
w.prototype._setInternalAnchorBarVisible=function(V,I){if(V!=this._bInternalAnchorBarVisible){this._bInternalAnchorBarVisible=V;if(I===true){this.invalidate();}}};
w.prototype.setUpperCaseAnchorBar=function(V){this._oABHelper._getAnchorBar().setProperty("upperCase",V);return this.setProperty("upperCaseAnchorBar",V,true);};
w.prototype._requestAdjustLayout=function(I){if(!this._oLayoutTask){this._oLayoutTask=new T(this._updateScreenHeightSectionBasesAndSpacer,w.DOM_CALC_DELAY,this);}if(!I){i.debug("ObjectPageLayout :: _requestAdjustLayout","delayed by "+w.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oLayoutTask.reSchedule(I,{}).catch(function(y){});};
w.prototype._requestAdjustLayoutAndUxRules=function(I){this._setSectionInfoIsDirty(true);if(!this._oUxRulesTask){this._oUxRulesTask=new T(this._adjustLayoutAndUxRules,w.DOM_CALC_DELAY,this);}if(!I){i.debug("ObjectPageLayout :: _requestAdjustLayoutAndUxRules","delayed by "+w.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oUxRulesTask.reSchedule(I,{}).catch(function(y){});};
w.prototype._adjustLayoutAndUxRules=function(){var y,z;i.debug("ObjectPageLayout :: _requestAdjustLayout","refreshing ux rules");this._applyUxRules(true);this._adjustSelectedSectionByUXRules();y=this.getSelectedSection();z=this.oCore.byId(y);if(z){this._setSelectedSectionId(y);if(this.getUseIconTabBar()){this._setCurrentTabSection(z);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(z);}this._requestAdjustLayout(true).then(function(B){if(B){this._oLazyLoading.doLazyLoading();}this._adjustSelectedSectionByUXRules();y=this.getSelectedSection();if(!this._isClosestScrolledSection(y)||this._oScroller._$Container.is(":animated")){this.scrollToSection(y,null,0,false,true);}}.bind(this));}};
w.prototype._isClosestScrolledSection=function(y){var z=this._$opWrapper.length>0?this._$opWrapper.scrollTop():0,B=this.iScreenHeight,E=this._getClosestScrolledSectionId(z,B);return E&&(y===E);};
w.prototype._setSelectedSectionId=function(y){var z=this.getAggregation("_anchorBar"),B=y&&this._oSectionInfo[y];if(!B){return;}if(z&&B.buttonId){z.setSelectedButton(B.buttonId);this.setAssociation("selectedSection",y,true);}};
w.prototype.isFirstRendering=function(){return this._bFirstRendering;};
w.prototype._cleanMemory=function(){var y=this.getAggregation("_anchorBar");if(y){y._resetControl();}this._oSectionInfo={};this._aSectionBases=[];};
w.prototype._registerSectionBaseInfo=function(y){this._oSectionInfo[y.getId()]={$dom:[],positionTop:0,buttonId:"",isSection:(y instanceof c),sectionReference:y};this._aSectionBases.push(y);};
w.prototype._triggerVisibleSubSectionsEvents=function(){this._bDelayDOMBasedCalculations=false;if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading._triggerVisibleSubSectionsEvents();}};
w.prototype.scrollToSection=function(I,y,z,B,E){var G=this.oCore.byId(I),H,J,N=(sap.ui.getCore().getConfiguration().getAnimationMode()!==C.AnimationMode.none),Q;if(!this.getDomRef()){i.warning("scrollToSection can only be used after the ObjectPage is rendered",this);return;}if(!G){i.warning("scrollToSection aborted: unknown section",I,this);return;}if(!this._oSectionInfo[I]||!G._getInternalVisible()){i.warning("scrollToSection aborted: section is hidden by UX rules",I,this);return;}if(this.bIsDestroyed){i.debug("ObjectPageLayout :: scrollToSection","scrolling canceled as page is being destroyed");return;}if(this.getUseIconTabBar()){var U=c._getClosestSection(G);var W=this._bAllContentFitsContainer,V;this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(U);this._toggleScrolling(!this._bAllContentFitsContainer);V=this._bAllContentFitsContainer!==W;if(V&&!this._bHeaderExpanded){this._snapHeader(!this._bAllContentFitsContainer);this._bSupressModifyOnScrollOnce=true;}if(this._oCurrentTabSection){this._oCurrentTabSection._allowPropagationToLoadedViews(false);}U._allowPropagationToLoadedViews(true);this._setCurrentTabSection(G);this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[U.getId()].buttonId);this.setAssociation("selectedSection",U.getId(),true);this._checkSubSectionVisibilityChange();}J=G instanceof d?G:this._getFirstVisibleSubSection(G);if(B){this.fireNavigate({section:c._getClosestSection(G),subSection:J});}if(this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();}z=z||0;G._expandSection();this._requestAdjustLayout(true);y=this._computeScrollDuration(y,G);var X=this._computeScrollPosition(G);if(this._sCurrentScrollId!=I||E){this._sCurrentScrollId=I;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);if(this._$contentContainer){this._$contentContainer.parent().stop(true,false);}}if(this._bDomElementsCached){this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;}.bind(this),y);}this._preloadSectionsOnBeforeScroll(G);this.getHeaderTitle()&&this._shiftHeaderTitle();X+=z;if(!this._bStickyAnchorBar&&this._shouldSnapHeaderOnScroll(X)){H=this._getSnapPosition();this._scrollTo(H,0);if(H===0){this._toggleHeader(true);}}Q=N&&y&&this.getEnableLazyLoading();this._scrollTo(X,y,Q);}};
w.prototype.onAnchorBarTabPress=function(E){var y=sap.ui.getCore().byId(E.getParameter("sectionBaseId")),I=y instanceof l.ObjectPageSubSection,z,B;if(!y){return;}z=I?y.getParent():y;B=I?y:this._getFirstVisibleSubSection(y);this.setDirectScrollingToSection(z.getId());this.scrollToSection(y.getId(),null,0,true);z.setAssociation("selectedSubSection",B,true);this.setAssociation("selectedSection",z,true);};
w.prototype._hasSingleVisibleFullscreenSubSection=function(y){var V=y.getSubSections().filter(function(z){return z.getVisible()&&z._getInternalVisible()&&(z.getBlocks().length>0);});return(V.length===1)&&V[0].hasStyleClass(d.FIT_CONTAINER_CLASS);};
w.prototype._computeScrollDuration=function(y,z){var B=parseInt(y);B=B>=0?B:this._iScrollToSectionDuration;if(this.getUseIconTabBar()&&((z instanceof c)||this._isFirstVisibleSectionBase(z))&&this._bStickyAnchorBar){B=0;}return B;};
w.prototype._computeScrollPosition=function(y){var z=this._oSectionInfo[y.getId()].positionTop,E=!this._bStickyAnchorBar;if(E&&this._isFirstVisibleSectionBase(y)){z=0;}return z;};
w.prototype._preloadSectionsOnBeforeScroll=function(y){var I=y.getId(),z;if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()){z=(y instanceof c)?y:y.getParent();this._connectModelsForSections([z]);}if(this.getEnableLazyLoading()){var B=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;z=this._oLazyLoading.getSubsectionsToPreload(B,I);if(D.system.desktop){setTimeout(function(){this._connectModelsForSections(z);}.bind(this),50);}else{this._connectModelsForSections(z);}z.forEach(function(E){this.fireEvent("subSectionEnteredViewPort",{subSection:E});},this);}};
w.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId;};
w.prototype.setDirectScrollingToSection=function(y){this.sDirectSectionId=y;};
w.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId;};
w.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null;};
w.prototype._scrollTo=function(y,z,B){if(this._oScroller&&this._bDomReady&&!this._bSuppressScroll){i.debug("ObjectPageLayout :: scrolling to "+y);if((z===0)&&this._shouldSnapHeaderOnScroll(y)){this._toggleHeader(true);}if(B&&this._oLazyLoading){this._oLazyLoading.suppress();this._oScroller.scrollTo(0,y,z,this._resumeLazyLoading.bind(this));}else{this._oScroller.scrollTo(0,y,z);}}return this;};
w.prototype._resumeLazyLoading=function(){if(this._oLazyLoading){this._oLazyLoading.resume();this._oLazyLoading.lazyLoadDuringScroll(true);}};
w.prototype._scrollBelowCollapseVisualIndicator=function(){var H=this._getHeaderContent(),$,y,V,z;if(!x(H)||!x(this._$opWrapper)){return;}$=H._getCollapseButton().getDomRef();y=$.getBoundingClientRect().height;V=this._$opWrapper[0].getBoundingClientRect().height;z=$.offsetTop+y-V;this._scrollTo(z);};
w.prototype._updateMedia=function(W,y){if(!W){return;}var U=function(z){Object.keys(y).forEach(function(E){var G=y[E],H=z===G;this.toggleStyleClass(G,H);},this);}.bind(this),B=w.BREAK_POINTS;if(W<=B.PHONE){U(y.PHONE);}else if(W<=B.TABLET){U(y.TABLET);}else if(W<=B.DESKTOP){U(y.DESKTOP);}else{U(y.DESKTOP_XL);}};
w.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var y,z,B,E,G,H,I=this._bHeaderInTitleArea||!this._bHeaderExpanded,J,N,Q,U=this.getDomRef(),V=this.getUseIconTabBar();if(!U||!this._bDomReady){return false;}i.debug("ObjectPageLayout :: _updateScreenHeightSectionBasesAndSpacer","re-evaluating dom positions");this.iScreenHeight=this._getDOMRefHeight(U);if(this.iScreenHeight===0){return;}this.iFooterHeight=this._getFooterHeight();var W=-1,X=this._$sectionsContainer.position().top;this._aSectionBases.forEach(function(Y){var Z=this._oSectionInfo[Y.getId()],$=Y.$(),_,a1=false;if(!Z||!$.length){return;}if(!Z.isSection){W++;}Z.$dom=$;var b1=$.position().top;Z.positionTop=Math.ceil(b1);if(!Z.isSection&&(_=Y.getParent())){a1=Y._getTitleDomId()===_.getId()+"-title";if(a1){var c1=_.$().position().top;Z.positionTop=Math.ceil(c1);}}if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){Z.positionTop-=this.iAnchorBarHeight;}Z.sectionReference.toggleStyleClass("sapUxAPObjectPageSubSectionPromoted",a1);if(this._bMobileScenario){var d1=this.oCore.byId(Y.getId()).getParent();if(d1 instanceof c&&d1._getIsHidden()){return;}if(G){this._oSectionInfo[G].positionBottom=Z.positionTop;}G=Y.getId();z=Y;}else{if(Z.isSection){if(G){this._oSectionInfo[G].positionBottom=Z.positionTop;if(E){this._oSectionInfo[E].positionBottom=Z.positionTop;}}G=Y.getId();E=null;}else{if(E){this._oSectionInfo[E].positionBottom=Z.positionTop;}E=Y.getId();z=Y;}}if(!Z.isSection){N=V||(Y.getParent()===this._oFirstVisibleSection);J=N&&(W===0);Q=Y.hasStyleClass(d.FIT_CONTAINER_CLASS);Y._setHeight(this._computeSubSectionHeight(J,Q,Math.ceil(b1),X));}},this);if(z){y=this._computeLastVisibleHeight(z);if(this._bMobileScenario&&G){this._oSectionInfo[G].positionBottom=this._oSectionInfo[G].positionTop+y;}else{if(E){this._oSectionInfo[E].positionBottom=this._oSectionInfo[E].positionTop+y;}if(G&&E){this._oSectionInfo[G].positionBottom=this._oSectionInfo[E].positionTop+y;}}H=this._bStickyAnchorBar||(W>0)||this._checkContentBottomRequiresSnap(z);if(this._bAllContentFitsContainer){H=false;}if(H&&!this._shouldPreserveHeaderInTitleArea()){I=true;}B=this._computeSpacerHeight(z,y,H,I);this._$spacer.height(B+"px");i.debug("ObjectPageLayout :: bottom spacer is now "+B+"px");o(this._oScrollContainerLastState,{iScrollableContentLength:Math.round(this._getScrollableContentLength()),iSpacerHeight:B});}this._updateCustomScrollerHeight(I);this._setSectionInfoIsDirty(false);return true;};
w.prototype._computeSubSectionHeight=function(y,z,B,E){var G,H;if(!z){return"";}var I=(this._bAllContentFitsContainer)?this._bHeaderExpanded:y;G=this._getSectionsContainerHeight(I);if(this._bAllContentFitsContainer){H=(B-E)+this.iFooterHeight;G-=H;}return G+"px";};
w.prototype._updateCustomScrollerHeight=function(y){if(D.system.desktop&&this.getAggregation("_customScrollBar")){var z=this._computeScrollableContentSize(y);z+=this._getStickyAreaHeight(y);this._getCustomScrollBar().setContentSize(z+"px");var B=(z>Math.ceil(this.iScreenHeight)),V=(B!==this._getCustomScrollBar().getVisible());if(V){this._getCustomScrollBar().setVisible(B);this.getHeaderTitle()&&this._shiftHeaderTitle();}}};
w.prototype._computeScrollableContentSize=function(y){var z=0;if(this._$contentContainer&&this._$contentContainer.length){z=this._$contentContainer[0].scrollHeight;}if(!this._bStickyAnchorBar&&y){z-=this.iAnchorBarHeight;}if(this._bStickyAnchorBar&&!y){z+=this.iAnchorBarHeight;}return z;};
w.prototype._computeLastVisibleHeight=function(y){var I=this._bStickyAnchorBar||this._bHeaderInTitleArea;var z=this._getSectionPositionTop(y,I);return this._$spacer.position().top-z;};
w.prototype._getStickyAreaHeight=function(I){if(I){return this.iHeaderTitleHeightStickied+this.iAnchorBarHeight;}return this.iHeaderTitleHeight;};
w.prototype._getScrollableViewportHeight=function(I){return this.getDomRef().getBoundingClientRect().height-this._getStickyAreaHeight(I);};
w.prototype._getSectionsContainerHeight=function(I){var y=!I,z=this._getScrollableViewportHeight(y);if(!y&&!this._bHeaderInTitleArea){z-=(this.iHeaderContentHeight+this.iAnchorBarHeight);}return z;};
w.prototype._getSectionPositionTop=function(y,z){var B=this._oSectionInfo[y.getId()].positionTop;if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){B+=this.iAnchorBarHeight;}return B;};
w.prototype._getSectionPositionBottom=function(y,z){var B=this._oSectionInfo[y.getId()].positionBottom;if(!z){B+=this.iAnchorBarHeight;}return B;};
w.prototype._determineSectionBaseInternalTitleLevel=function(y){var z=this.getSectionTitleLevel(),I=y instanceof c;if(z===s.Auto){return I?s.H3:s.H4;}return I?z:w._getNextTitleLevelEntry(z);};
w.prototype._shouldApplySectionTitleLevel=function(y){return y.getTitleLevel()===s.Auto;};
w.prototype._checkContentBottomRequiresSnap=function(y){var z=false;return this._getSectionPositionBottom(y,z)>(this._getScrollableViewportHeight(z)+this._getSnapPosition());};
w.prototype._computeSpacerHeight=function(y,z,B,E){var G,H;if(Object.keys(this._oVisibleSubSections).length===1&&this._bHeaderExpanded){G=0;}else{H=this._getScrollableViewportHeight(E);if(B){H=Math.ceil(H);z=Math.floor(z);}else{z=this._$spacer.position().top;}if(z<H){G=H-z;}else{G=0;}}if((this.iFooterHeight>G)){G+=this.iFooterHeight;}return G;};
w.prototype._isFirstVisibleSectionBase=function(y){var z,B,E,G=this.getSelectedSection(),U=this.getUseIconTabBar();if(!y||!y.getParent()){return;}z=y.getId();if(U&&(z===G)){return true;}if(U&&(y.getParent().getId()===G)){B=sap.ui.getCore().byId(G);E=this._getFirstVisibleSubSection(B);return E&&(E.getId()===z);}if(this._oFirstVisibleSection&&this._oFirstVisibleSubSection){return z===this._oFirstVisibleSection.getId()||z===this._oFirstVisibleSubSection.getId();}return false;};
w.prototype._getFirstVisibleSubSection=function(y){if(!y){return;}var z;this._aSectionBases.every(function(B){if(B.getParent()&&(B.getParent().getId()===y.getId())){z=B;return false;}return true;});return z;};
w.prototype._initAnchorBarScroll=function(){var y=this.oCore.byId(this.getSelectedSection()),z;this._requestAdjustLayout(true);z=y?this._computeScrollPosition(y):0;this._sScrolledSectionId="";this._sCurrentScrollId="";this._onScroll({target:{scrollTop:z}},true);};
w.prototype._setAsCurrentSection=function(y){var z,B,E;if(this._sScrolledSectionId===y){return;}i.debug("ObjectPageLayout :: current section is "+y);this._sScrolledSectionId=y;z=this.getAggregation("_anchorBar");if(z&&this._getInternalAnchorBarVisible()){B=this.oCore.byId(y);E=B&&B instanceof d&&(B.getTitle().trim()===""||!B._getInternalTitleVisible()||B.getParent()._getIsHidden());if(E){y=B.getParent().getId();i.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent "+y);}if(B&&this._oSectionInfo[y]){z.setSelectedButton(this._oSectionInfo[y].buttonId);this.setAssociation("selectedSection",c._getClosestSection(y).getId(),true);this._setSectionsFocusValues(y);}}};
w.prototype._registerOnContentResize=function(){var $=this._$contentContainer.length&&this._$contentContainer[0];if(!$){return;}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}this._iContentResizeId=R.register($,this._onUpdateContentSize.bind(this));};
w.prototype._onUpdateContentSize=function(E){var y,z=E.size,B=E.oldSize;if(z.height===0||z.width===0){i.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(this.getPreserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}this._adjustHeaderHeights();this._requestAdjustLayout(true);if(B.height>0||B.width>0){y=this._$opWrapper.scrollTop();this._updateSelectionOnScroll(y);}};
w.prototype._onUpdateScreenSize=function(E){var y=this.getHeaderTitle(),H=this._getHeaderContent(),z=E.size.width,B=E.size.height,G=E.oldSize.height,I=(B!==G),J,N=H&&H.supportsAlwaysExpanded()&&this.getAlwaysShowContentHeader();if(E.size.height===0||E.size.width===0){i.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(!this._bDomReady){i.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");return;}this._oLazyLoading.setLazyLoadingParameters();setTimeout(function(){if(N&&(this._bHeaderInTitleArea!=this._checkAlwaysShowContentHeader())){this.invalidate();}if(this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){if(this._isHeaderPinnable()){this._updatePinButtonState();}this._expandHeader(false);this._scrollTo(0,0);}else if(this._isHeaderPinnable()&&!this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._updatePinButtonState();}if(y&&y.isDynamic()){y._onResize(z);this._updateMedia(z,w.DYNAMIC_HEADERS_MEDIA);}this._updateMedia(z,w.MEDIA);this._adjustHeaderHeights();this._requestAdjustLayout(true);if(this.getFooter()&&this.getShowFooter()){this._shiftFooter();}J=this.getSelectedSection();if((G===0)&&I&&!this._isClosestScrolledSection(J)){J!==null?this.scrollToSection(J,0):this._selectFirstVisibleSection();}this._scrollTo(this._$opWrapper.scrollTop(),0);if((G===0)&&I&&this.getEnableLazyLoading()&&this._oLazyLoading&&!this._bDelayDOMBasedCalculations){this._oLazyLoading.doLazyLoading();}}.bind(this),this._getDOMCalculationDelay());};
w.prototype._onUpdateHeaderTitleSize=function(E){if(E.size.height===0||E.size.width===0){i.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){i.info("ObjectPageLayout :: cannot _onUpdateTitleSize before dom is ready");return;}this._adjustHeaderHeights();this._requestAdjustLayout();};
w.prototype._applyContextualSettings=function(y){var z=y.contextualWidth;if(this._hasDynamicTitle()){this._updateMedia(z,w.DYNAMIC_HEADERS_MEDIA);}this._updateMedia(z,w.MEDIA);return b.prototype._applyContextualSettings.call(this,y);};
w.prototype._shouldSnapHeaderOnScroll=function(y){return(y>0)&&(y>=this._getSnapPosition())&&!this._shouldPreserveHeaderInTitleArea();};
w.prototype._getScrollableContentLength=function(){return this._$contentContainer.length?this._getDOMRefHeight(this._$contentContainer[0]):0;};
w.prototype._isContentScrolledToBottom=function(){return this._oScrollContainerLastState.iScrollableContentLength<=(this._oScrollContainerLastState.iScrollTop+this._oScrollContainerLastState.iScrollableViewportHeight);};
w.prototype._isContentLengthDecreased=function(y){if(y){return((y.iScrollableContentLength>this._oScrollContainerLastState.iScrollableContentLength)&&(y.iSpacerHeight===this._oScrollContainerLastState.iSpacerHeight));}};
w.prototype._canReachScrollTop=function(y,E){var z;E=E||0;z=this._oScrollContainerLastState.iScrollableContentLength+E-this._oScrollContainerLastState.iScrollableViewportHeight;return z>=y;};
w.prototype._deregisterCustomEvents=function(){if(this._$opWrapper.length){this._$opWrapper.off(".OPL");}};
w.prototype._deregisterScreenSizeListener=function(){if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}};
w.prototype._onScroll=function(E,I){var y=Math.max(Math.ceil(E.target.scrollTop),0),$=this._$opWrapper.length&&this._$opWrapper[0],z=this._$spacer.length&&this._$spacer[0],B=z.offsetHeight,G,H=this.getHeaderTitle(),J=this._shouldSnapHeaderOnScroll(y),N=this._shouldPreserveHeaderInTitleArea(),Q=false,U=this._oScrollContainerLastState;this._oScrollContainerLastState={iScrollTop:y,iScrollableContentLength:Math.round(this._getScrollableContentLength()),iScrollableViewportHeight:$.offsetHeight,iSpacerHeight:B};if(this._bSupressModifyOnScrollOnce){this._bSupressModifyOnScrollOnce=false;return;}if(!$||!z){return;}G=this.iScreenHeight;if(G===0){return;}if(this._getSectionInfoIsDirty()){return;}if(U&&this._isContentScrolledToBottom()&&this._isContentLengthDecreased(U)){var V=U.iScrollableContentLength-this._oScrollContainerLastState.iScrollableContentLength;if(!this._canReachScrollTop(U.iScrollTop)&&this._canReachScrollTop(U.iScrollTop,V)){var W=U.iScrollTop+this._oScrollContainerLastState.iScrollableViewportHeight,X=this._oScrollContainerLastState.iScrollableContentLength,Y=W-X,Z;if(Y>0){Z=B+Y;this._$spacer.height(Z+"px");this._scrollTo(U.iScrollTop);return;}}}if(J&&!N){G-=(this.iAnchorBarHeight+this.iHeaderTitleHeightStickied);}if(this._bHeaderInTitleArea&&!N){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._requestAdjustLayout();}if(!N&&((H&&this.getShowHeaderContent())||this.getShowAnchorBar())){this._toggleHeader(J,!!(E&&E.type==="scroll"));}if(!N){this._adjustHeaderTitleBackgroundPosition(y);}i.debug("ObjectPageLayout :: lazy loading : Scrolling at "+y,"----------------------------------------");this._updateSelectionOnScroll(y);if(this.getEnableLazyLoading()){this._oLazyLoading.lazyLoadDuringScroll(I,y,E.timeStamp,G);}if(H&&H.supportsTitleInHeaderContent()&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&H.getShowTitleSelector()){if(y===0){this.$("scroll").css("z-index","1000");Q=false;}else if(!Q){Q=true;this.$("scroll").css("z-index","0");}}};
w.prototype._updateSelectionOnScroll=function(y){var z=this.iScreenHeight,B,E;if(z===0){return;}B=this._getClosestScrolledSectionId(y,z);E=this._getClosestScrolledSectionId(y,z,true);if(B){var G=this.getDirectScrollingToSection();if(B!==this._sScrolledSectionId){i.debug("ObjectPageLayout :: closest id "+B,"----------------------------------------");var G=this.getDirectScrollingToSection();if(G&&G!==B){return;}this.clearDirectScrollingToSection();this._setAsCurrentSection(B);}else if(B===this.getDirectScrollingToSection()){this.clearDirectScrollingToSection();}if(E!==this._sScrolledSubSectionId){var H=c._getClosestSection(B),I=this.oCore.byId(E);this._sScrolledSubSectionId=E;this.fireEvent("_sectionChange",{section:H,subSection:I});this.fireEvent("sectionChange",{section:H,subSection:I});}}};
w.prototype._getSnapPosition=function(){var y=this.iHeaderContentHeight,z=this._getTitleHeightDelta();y-=Math.max(z,this._iHeaderContentPaddingBottom);return y;};
w.prototype._getTitleHeightDelta=function(){var y=this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight;y=Math.max(y,0);y=Math.min(y,w.MAX_SNAP_POSITION_OFFSET);return y;};
w.prototype._getClosestScrolledSectionId=function(y,z,B){B=!!B;y=Math.ceil(y);var E=y+z,G,H=B||this._bMobileScenario;q.each(this._oSectionInfo,function(I,J){var N,Q,U,V,W,X=this.getSelectedSection();N=this.oCore.byId(I);if(!N){return;}Q=N.getParent();U=Q instanceof c&&Q._getIsHidden();if(this.getUseIconTabBar()&&X){W=this.oCore.byId(X);if(!W){return;}if(J.isSection&&J.sectionReference!=W){return true;}if(!J.isSection&&W.indexOfSubSection(J.sectionReference)<0){return true;}}if(J.isSection||(H&&!U)){if(!G&&(J.sectionReference._getInternalVisible()===true)){V=this._getFirstVisibleSubSection(J.sectionReference);if(J.isSection&&B&&V){G=V.getId();}else{G=I;}}if(J.isSection&&B){return true;}if(J.positionTop<=E&&y<=J.positionBottom){if(J.positionTop<=y&&J.positionBottom>y){G=I;return false;}}}}.bind(this));return G;};
w.prototype._toggleHeader=function(y,U){var H;if(y===this._bStickyAnchorBar){return;}H=this.getHeaderTitle();if(!this._shouldPreserveHeaderInTitleArea()&&!this._bHeaderInTitleArea){this._toggleHeaderTitle(!y,U);}if(!this._bStickyAnchorBar&&y){this._restoreFocusAfter(this._moveAnchorBarToTitleArea);H&&H.snap();this._bHeaderExpanded=false;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();}else if(this._bStickyAnchorBar&&!y){this._restoreFocusAfter(this._moveAnchorBarToContentArea);H&&H.unSnap();this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();if(this._isHeaderPinnable()){this._getHeaderContent()._getPinButton().setVisible(!this._headerBiggerThanAllowedToBeExpandedInTitleArea());}}};
w.prototype._restoreFocusAfter=function(y){var z=this.oCore.byId(this.oCore.getCurrentFocusedControlId());y.call(this);if(D.system.phone!==true){if(!this.oCore.byId(this.oCore.getCurrentFocusedControlId())){z&&z.$().trigger("focus");}}return this;};
w.prototype._moveAnchorBarToTitleArea=function(){this._$anchorBar.children().appendTo(this._$stickyAnchorBar);this._toggleHeaderStyleRules(true);if(this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied){this._adjustHeaderBackgroundSize();}return this;};
w.prototype._moveAnchorBarToContentArea=function(){if(!this._shouldPreserveHeaderInTitleArea()){var y=this._$opWrapper.scrollTop();this._$anchorBar.css("height","auto").append(this._$stickyAnchorBar.children());this._$opWrapper.scrollTop(y);this._toggleHeaderStyleRules(false);}return this;};
w.prototype._toggleHeaderStyleRules=function(y){y=!!y;var V=y?"hidden":"inherit";this._bStickyAnchorBar=y;this._$headerContent.css("overflow",V);this._$headerContent.toggleClass("sapContrastPlus",!y);this._$headerContent.toggleClass("sapUxAPObjectPageHeaderDetailsHidden",y);this._$anchorBar.css("visibility",V);if(x(this._$stickyAnchorBar)){this._$stickyAnchorBar.attr("aria-hidden",!y);}this.fireToggleAnchorBar({fixed:y});if(!y&&!this.iAnchorBarHeight){this._requestAdjustLayout();}};
w.prototype.getScrollDelegate=function(){return this._oScroller;};
w.prototype.setHeaderTitle=function(H,y){if(H&&typeof H.addEventDelegate==="function"){H.addEventDelegate({onAfterRendering:this._onAfterHeaderTitleRendering.bind(this)});}this.setAggregation("headerTitle",H,y);this._oObserver&&this._oObserver.disconnect();this._oObserver=new M(this._onModifyHeaderTitle.bind(this));this._oObserver.observe(H,{aggregations:["headerTitle"],properties:["backgroundDesign"]});if(H){this._createHeaderContent();}if(this._hasDynamicTitle()){this._iHeaderContentPaddingBottom=w.HEADER_CONTENT_PADDING_BOTTOM;}return this;};
w.prototype._onAfterHeaderTitleRendering=function(){var H=this.getHeaderTitle(),$=H&&H.$(),y;if(!H||!$.length){return;}y=$.height();if(y!==this._iCachedHeaderTitleHeight){this._adjustHeaderHeights();this._iCachedHeaderTitleHeight=y;}};
w.prototype._onModifyHeaderTitle=function(y){var H=this.getAggregation("_headerContent");H&&y.current&&H.setBackgroundDesign(y.current);};
w.prototype.invalidate=function(y){this._bInvalidatedAndNotRerendered=true;if(this.getUseIconTabBar()&&y&&(y instanceof c)&&!y.isActive()&&this._oSectionInfo[y.getId()]){return;}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);this._iAfterRenderingDomReadyTimeout=null;}a.prototype.invalidate.apply(this,arguments);};
w.prototype._createHeaderContent=function(){var H=this.getHeaderTitle(),y=H&&H.supportsBackgroundDesign()&&H.getBackgroundDesign(),z=this.getAggregation("_headerContent"),B,N;var E=H?H.getCompatibleHeaderContentClass():e;if(!(z instanceof E)){B=this.getAggregation("_headerContent");if(B){B.destroy();}N=E.createInstance(this.getAggregation("headerContent"),this.getShowHeaderContent(),this._getHeaderDesign(),this.getHeaderContentPinnable(),this.getId()+"-OPHeaderContent");y&&N.setBackgroundDesign(y);this.setAggregation("_headerContent",N,true);}};
w.prototype._adjustHeaderBackgroundSize=function(){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(!this._shouldPreserveHeaderInTitleArea()){this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight;this._$headerContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}else{this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height();this._$stickyHeaderContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}H.$().css("background-size","100% "+this.iTotalHeaderSize+"px");this._adjustHeaderTitleBackgroundPosition(0);}};
w.prototype._adjustHeaderTitleBackgroundPosition=function(y){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(this._bStickyAnchorBar){H.$().css("background-position","0px "+((this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)*-1)+"px");}else{if(this._shouldPreserveHeaderInTitleArea()){H.$().css("background-position","0px 0px");}else{H.$().css("background-position","0px "+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-y)+"px");}}}};
w.prototype._adjustHeaderHeights=function(){var y=this.getHeaderTitle(),z=true;if(y&&!y.supportsAdaptLayoutForDomElement()){z=false;}if(this._$titleArea.length>0){this.iHeaderContentHeight=this._$headerContent.length?Math.round(this._getDOMRefHeight(this._$headerContent[0])):0;this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height();this.iAnchorBarHeight=this._bStickyAnchorBar?this._$stickyAnchorBar.outerHeight():this._$anchorBar.outerHeight();if(!this._bHeaderExpanded){this.iHeaderTitleHeightStickied=this._$titleArea.height()-this.iAnchorBarHeight;this.iHeaderTitleHeight=this._obtainExpandedTitleHeight(z);}else{this.iHeaderTitleHeight=this._$titleArea.is(":visible")?this._$titleArea.height():0;this.iHeaderTitleHeightStickied=this._obtainSnappedTitleHeight(z);}this._adjustHeaderBackgroundSize();i.info("ObjectPageLayout :: adjustHeaderHeight","headerTitleHeight: "+this.iHeaderTitleHeight+" - headerTitleStickiedHeight: "+this.iHeaderTitleHeightStickied+" - headerContentHeight: "+this.iHeaderContentHeight);}else{i.debug("ObjectPageLayout :: adjustHeaderHeight","skipped as the objectPageLayout is being rendered");}};
w.prototype._appendTitleCloneToDOM=function(E){var $=this.getHeaderTitle().$(),y=$.clone();y.css({left:"-10000px",top:"-10000px",width:$.width()+"px",position:"absolute"});y.toggleClass("sapUxAPObjectPageHeaderStickied",E);y.appendTo(this._$titleArea.parent());if(E){this.getHeaderTitle()&&this.getHeaderTitle()._adaptObjectPageHeaderIndentifierLine(y);}return y;};
w.prototype._obtainSnappedTitleHeight=function(V){var y=this.getHeaderTitle(),$,H;if(!y){return 0;}if(V){$=this._appendTitleCloneToDOM(true);H=$.height();$.remove();}else if(y.snap){H=this._obtainTitleHeightViaStateChange(true);}return H;};
w.prototype._obtainExpandedTitleHeight=function(V){var y=this.getHeaderTitle(),$,H;if(!y){return 0;}if(V){$=this._appendTitleCloneToDOM(false);H=$.is(":visible")?$.height()-this.iAnchorBarHeight:0;$.remove();}else if(y.unSnap){H=this._obtainTitleHeightViaStateChange(false);}return H;};
w.prototype._obtainTitleHeightViaStateChange=function(y){var z=this.getHeaderTitle(),H,B=this._$sectionsContainer.height(),E,G=(y)?z.snap:z.unSnap,I=(y)?z.unSnap:z.snap;G.call(z,false);H=z.$().outerHeight();I.call(z,false);E=this._$sectionsContainer.height();this._adjustSpacerHeightUponUnsnapping(B,E);return H;};
w.prototype._adjustSpacerHeightUponUnsnapping=function(y,z){var B;if(y!=z){B=this._$spacer.height()-(z-y);this._$spacer.height(B);}};
w.prototype._getHeaderDesign=function(){var H=this.getHeaderTitle(),y=l.ObjectPageHeaderDesign.Light;if(H!=null){y=H.getHeaderDesign();}return y;};
w.prototype._getVisibleSections=function(){return this.getSections().filter(function(y){return y.getVisible()&&y._getInternalVisible();});};
w.prototype._setSectionsFocusValues=function(y){var z=this._getVisibleSections()||[],$,B='0',N='-1',E="tabindex",G,H=z[0];z.forEach(function(I){$=I.$();if(y===I.getId()){$.attr(E,B);G=I;I._setSubSectionsFocusValues();}else{$.attr(E,N);I._disableSubSectionsFocus();}});if(!G&&z.length>0){H.$().attr(E,B);H._setSubSectionsFocusValues();G=H;}return G;};
w.prototype.setShowHeaderContent=function(y){var z=this.getShowHeaderContent(),H;if(z!==y){if(z&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);}this.setProperty("showHeaderContent",y,true);this._updateTitleVisualState();H=this._getHeaderContent();this.$().toggleClass("sapUxAPObjectPageLayoutNoHeaderContent",!y||!H);if(H){H.setProperty("visible",y);}}return this;};
w.prototype._headerTitleChangeHandler=function(I){var y;if(!this.getShowTitleInHeaderContent()){return;}if(I){this._getHeaderContent()._destroyObjectImage(true);}y=this.oCore.createRenderManager();this.getRenderer()._rerenderHeaderContentArea(y,this);this._getHeaderContent().invalidate();y.destroy();};
w.prototype.getHeaderContent=function(){if(!this._getHeaderContent()){return this.getAggregation("headerContent",[]);}return this._getHeaderContent().getAggregation("content",[]);};
w.prototype.insertHeaderContent=function(y,I,z){if(!this._getHeaderContent()){return this.insertAggregation("headerContent",y,I,z);}return this._getHeaderContent().insertAggregation("content",y,I,z);};
w.prototype.addHeaderContent=function(y,z){if(!this._getHeaderContent()){return this.addAggregation("headerContent",y,z);}return this._getHeaderContent().addAggregation("content",y,z);};
w.prototype.removeAllHeaderContent=function(y){if(!this._getHeaderContent()){return this.removeAllAggregation("headerContent",y);}return this._getHeaderContent().removeAllAggregation("content",y);};
w.prototype.removeHeaderContent=function(y,z){if(!this._getHeaderContent()){return this.removeAggregation("headerContent",y,z);}return this._getHeaderContent().removeAggregation("content",y,z);};
w.prototype.destroyHeaderContent=function(y){if(!this._getHeaderContent()){return this.destroyAggregation("headerContent",y);}return this._getHeaderContent().destroyAggregation("content",y);};
w.prototype.indexOfHeaderContent=function(y){if(!this._getHeaderContent()){return this.indexOfAggregation("headerContent",y);}return this._getHeaderContent().indexOfAggregation("content",y);};
w.prototype._getHeaderContent=function(){return this.getAggregation("_headerContent");};
w.prototype._getHeaderContentDomRef=function(){var H=this._getHeaderContent();if(!H||!this.getShowHeaderContent()){return null;}if(this._bStickyAnchorBar&&!this._bHeaderInTitleArea){return this.$().find(".sapUxAPObjectPageHeaderTitle .sapUxAPObjectPageHeaderDetails").get(0);}return H.getDomRef();};
w.prototype._connectModelsForSections=function(y){y=y||[];y.forEach(function(z){z.connectToModels();});};
w.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()};};
w.prototype._hasVerticalScrollBar=function(){return(this._getCustomScrollBar().getVisible()===true);};
w.prototype._shiftHeaderTitle=function(){var y=this._calculateShiftOffset(),z=y.sStyleAttribute,B=y.iMarginalsOffset;this.$().find(".sapUxAPObjectPageHeaderTitle").css("padding-"+z,B+"px");};
w.prototype._isFirstSection=function(y){var z=this._getVisibleSections();if(y===z[0]){return true;}return false;};
w.prototype._isValidStoredSubSectionInfo=function(){var y=this.getSelectedSection(),z=this.oCore.byId(y),B;if(!z||!this._oStoredScrolledSubSectionInfo){return false;}B=this.oCore.byId(this._oStoredScrolledSubSectionInfo.sSubSectionId);return B&&this._sectionCanBeRenderedByUXRules(B)&&(z.indexOfSubSection(B)>=0);};
w.prototype._restoreScrollPosition=function(){var V=this._isValidStoredSubSectionInfo(),y;if(V){y=this._computeScrollPosition(this.oCore.byId(this._oStoredScrolledSubSectionInfo.sSubSectionId))+this._oStoredScrolledSubSectionInfo.iOffset;this._scrollTo(y,0);}else{this.scrollToSection(this.getSelectedSection(),0);}};
w.prototype._storeScrollLocation=function(){if(!this.getDomRef()||!this._bDomReady||!this._oScroller){return;}var y=this._oScroller.getScrollTop(),z=this._getClosestScrolledSectionId(this._oScroller.getScrollTop(),this.iScreenHeight,true),B;if(z){B=y-this._computeScrollPosition(this.oCore.byId(z));}this._iStoredScrollTop=y;this._oStoredScrolledSubSectionInfo={sSubSectionId:z,iOffset:B};this._oCurrentTabSection=null;};
w.prototype.onkeyup=function(E){var y,z;if(E.which===K.TAB){y=this.oCore.getCurrentFocusedControlId();z=y&&this.oCore.byId(y);if(z&&this._isFirstSection(z)){this._scrollTo(0,0);}}};
w.prototype.setShowFooter=function(y){var z=this.setProperty("showFooter",y,true);this._toggleFooter(y);return z;};
w.prototype._toggleFooter=function(y){var U,z=this.getFooter();if(!x(z)||!x(this._$footerWrapper)){return;}U=this.oCore.getConfiguration().getAnimationMode()!==C.AnimationMode.none;if(U){this._toggleFooterAnimation(y,z);}else{this._$footerWrapper.toggleClass("sapUiHidden",!y);}this._requestAdjustLayout();};
w.prototype._toggleFooterAnimation=function(y,z){this._$footerWrapper.on("webkitAnimationEnd animationend",this._onToggleFooterAnimationEnd.bind(this,z));this._bIsFooterAanimationGoing=true;if(y){this._$footerWrapper.removeClass("sapUiHidden");}z.toggleStyleClass(w.SHOW_FOOTER_CLASS_NAME,y);z.toggleStyleClass(w.HIDE_FOOTER_CLASS_NAME,!y);};
w.prototype._onToggleFooterAnimationEnd=function(y){this._$footerWrapper.off("webkitAnimationEnd animationend");if(y.hasStyleClass(w.HIDE_FOOTER_CLASS_NAME)){this._$footerWrapper.addClass("sapUiHidden");y.removeStyleClass(w.HIDE_FOOTER_CLASS_NAME);}else{y.removeStyleClass(w.SHOW_FOOTER_CLASS_NAME);}this._bIsFooterAanimationGoing=false;};
w.prototype.clone=function(){var y,H,z;Object.keys(this.mAggregations).forEach(this._cloneProxiedAggregations,this);y=a.prototype.clone.apply(this,arguments);H=this._getHeaderContent();z=y._getHeaderContent();if(z){z.destroy();}if(H){y.setAggregation("_headerContent",H.clone(),true);}return y;};
w.prototype._cloneProxiedAggregations=function(y){var z=this.mAggregations[y];if(Array.isArray(z)&&z.length===0){z=this["get"+y.charAt(0).toUpperCase()+y.slice(1)]();}this.mAggregations[y]=z;};
w.prototype._shouldPreserveHeaderInTitleArea=function(){return this._bPinned||this._preserveHeaderStateOnScroll()||this._checkAlwaysShowContentHeader();};
w.prototype._checkAlwaysShowContentHeader=function(){return!this._hasDynamicTitle()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader();};
w.prototype._headerBiggerThanAllowedToBeFixed=function(){var y=this._getOwnHeight();return this._getEntireHeaderHeight()>w.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*y;};
w.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){return this._getEntireHeaderHeight()>=this._getOwnHeight();};
w.prototype._getOwnHeight=function(){return this._getHeight(this);};
w.prototype._getHeight=function(y){return!(y instanceof a)?0:y.$().outerHeight()||0;};
w.prototype._getEntireHeaderHeight=function(){var y=0,H=0,z=this.getHeaderTitle(),B=this._getHeaderContent();if(x(z)){y=z.$().outerHeight();}if(x(B)){H=B.$().outerHeight();}return y+H;};
w.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin(true);}else{this._pin(true);this._restorePinButtonFocus();}};
w.prototype._restorePinButtonFocus=function(){var H=this._getHeaderContent();if(x(H)&&H.supportsPinUnpin()){H._focusPinButton();}};
w.prototype._pin=function(U){if(this._bPinned){return;}this._bPinned=true;if(U){this.setProperty("headerContentPinned",true,true);this.fireEvent("headerContentPinnedStateChange",{pinned:true});}this._toggleHeaderTitle(true);this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._adjustHeaderHeights();this._requestAdjustLayout();this._updateToggleHeaderVisualIndicators();this.addStyleClass("sapUxAPObjectPageLayoutHeaderPinned");};
w.prototype._unPin=function(U){if(!this._bPinned){return;}this._bPinned=false;if(U){this.setProperty("headerContentPinned",false,true);this.fireEvent("headerContentPinnedStateChange",{pinned:false});}this._updateToggleHeaderVisualIndicators();this.removeStyleClass("sapUxAPObjectPageLayoutHeaderPinned");};
w.prototype._isHeaderPinnable=function(){var H=this._getHeaderContent();return H&&H.supportsPinUnpin()&&H.getPinnable();};
w.prototype._shouldPinUnpinHeader=function(){return this._bHeaderExpanded&&!this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedToBeExpandedInTitleArea();};
w.prototype._updatePinButtonState=function(){var I=this._isHeaderPinnable(),y=I&&this.getHeaderContentPinned()&&this._shouldPinUnpinHeader(),H=this._getHeaderContent();H._togglePinButton(y);this.$().toggleClass("sapUxAPObjectPageLayoutHeaderPinnable",I);H._getPinButton().setVisible(!this._headerBiggerThanAllowedToBeExpandedInTitleArea());if(y){this._pin();}else{this._unPin();}};
w.prototype._preserveHeaderStateOnScroll=function(){return this._hasDynamicTitle()&&this.getPreserveHeaderStateOnScroll()&&!this._bHeaderBiggerThanAllowedHeight;};
w.prototype._overridePreserveHeaderStateOnScroll=function(){var y=this._bHeaderBiggerThanAllowedHeight,z;this._bHeaderBiggerThanAllowedHeight=this._headerBiggerThanAllowedToBeFixed();z=y!==this._bHeaderBiggerThanAllowedHeight;if(!this._bHeaderBiggerThanAllowedHeight||!z){return;}if(this._bHeaderExpanded){this._moveAnchorBarToContentArea();this._moveHeaderToContentArea(true);}else{this._snapHeader(true);}this._adjustHeaderHeights();this._requestAdjustLayout();};
w.prototype._hasDynamicTitle=function(){var y=this.getHeaderTitle();return y&&y.isDynamic();};
w.prototype._attachVisualIndicatorsPressHandlers=function(y,z){var B=this.getHeaderTitle(),H=this._getHeaderContent();if(x(B)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){B.attachEvent(w.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,function(){y.call(z);if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBelowCollapseVisualIndicator();}this._focusCollapseVisualIndicator();},this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(x(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(w.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,function(){y.call(z);this._focusExpandVisualIndicator();},this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};
w.prototype._hasVisibleDynamicTitleAndHeader=function(){var y=this.getHeaderTitle(),H=this.getHeaderContent();return this._hasVisibleDynamicTitle(y)&&this._hasVisibleHeaderContent(H);};
w.prototype._hasVisibleDynamicTitle=function(y){return x(y)&&y.isDynamic()&&y.getVisible();};
w.prototype._hasVisibleHeaderContent=function(H){return x(H)&&H.length>0&&this.getShowHeaderContent();};
w.prototype._hasDynamicTitleWithSnappedTitleOnMobile=function(){var y=this.getHeaderTitle();return x(y)&&y.isDynamic()&&!!y.getSnappedTitleOnMobile()&&D.system.phone;};
w.prototype._updateToggleHeaderVisualIndicators=function(){var H,y,E,z=this._hasVisibleDynamicTitleAndHeader();if(!this.getToggleHeaderOnTitleClick()||!z){y=false;E=false;}else{H=this._bHeaderExpanded;y=H;E=!H&&!this._hasDynamicTitleWithSnappedTitleOnMobile();}this._toggleCollapseVisualIndicator(y);this._toggleExpandVisualIndicator(E);};
w.prototype._updateTitleVisualState=function(){var y=this.getHeaderTitle(),z=this._hasVisibleDynamicTitleAndHeader()&&this.getToggleHeaderOnTitleClick()&&!this._hasDynamicTitleWithSnappedTitleOnMobile();this.$().toggleClass("sapUxAPObjectPageLayoutTitleClickEnabled",z);if(x(y)){y._toggleFocusableState(z);}};
w.prototype._focusCollapseVisualIndicator=function(){var y=this._getHeaderContent();if(x(y)){y._focusCollapseButton();}};
w.prototype._focusExpandVisualIndicator=function(){var y=this.getHeaderTitle();if(x(y)){y._focusExpandButton();}};
w.prototype._toggleExpandVisualIndicator=function(y){var z=this.getHeaderTitle();if(x(z)){z._toggleExpandButton(y);}};
w.prototype._toggleCollapseVisualIndicator=function(y){var z=this._getHeaderContent();if(x(z)){z._toggleCollapseButton(y);}};
w.prototype._attachVisualIndicatorMouseOverHandlers=function(y,z,B){var H=this._getHeaderContent();if(x(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(w.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,y,B);H.attachEvent(w.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,z,B);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};
w.prototype._attachTitleMouseOverHandlers=function(y,z,B){var E=this.getHeaderTitle();if(x(E)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){E.attachEvent(w.EVENTS.TITLE_MOUSE_OVER,y,B);E.attachEvent(w.EVENTS.TITLE_MOUSE_OUT,z,B);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};
w.prototype._suppressScroll=function(){this._bSuppressScroll=true;};
w.prototype._resumeScroll=function(){this._bSuppressScroll=false;if(this._iStoredScrollTop){this._scrollTo(this._iStoredScrollTop,0);}else{this._onScroll({target:{scrollTop:this._$opWrapper.scrollTop()}});}};
w.prototype._addHoverClass=function(){var $=this.$();if($){$.addClass("sapUxAPObjectPageLayoutTitleForceHovered");}};
w.prototype._removeHoverClass=function(){var $=this.$();if($){$.removeClass("sapUxAPObjectPageLayoutTitleForceHovered");}};
w.prototype._getHeight=function(y){return!(y instanceof a)?0:y.$().outerHeight()||0;};
w.prototype._getWidth=function(y){var z=y.getDomRef();return!(y instanceof a)?0:(z&&z.offsetWidth)||0;};
w.prototype._getSectionInfoIsDirty=function(){return this.bSectionInfoIsDirty;};
w.prototype._setSectionInfoIsDirty=function(y){this.bSectionInfoIsDirty=y;};
w.prototype._getAriaLabelText=function(E,y){var H=this.getHeaderTitle(),z=H?H.getTitleText():null,B;if(H&&z){B=z;if(y){B+=" "+w._getLibraryResourceBundle().getText(E+"_ARIA_LABEL_WITH_TITLE");}}else{B=w._getLibraryResourceBundle().getText(E+"_ARIA_LABEL_WITHOUT_TITLE");}return B;};
w.prototype._getFooterHeight=function(){if(this.getFooter()&&this.getShowFooter()){return this._getDOMRefHeight(this.$("footerWrapper").get(0));}return 0;};
w.prototype._getDOMRefHeight=function(y){return y.parentElement?y.getBoundingClientRect().height:0;};
w.prototype._updateAriaLabels=function(){var y=this.getLandmarkInfo(),z=this._getAriaLabelText("ROOT",true),H=this._getAriaLabelText("HEADER",true),N=this._getAriaLabelText("NAVIGATION",false),B=this._getAriaLabelText("NAVTOOLBAR",true),E=y&&y.getHeaderLabel(),G=y&&y.getRootLabel(),I=y&&y.getNavigationLabel();if(!G){this.$().attr("aria-label",z);}if(!E){this.$("headerTitle").attr("aria-label",H);}if(!I){this.$("anchorBar").attr("aria-label",N);this.$("stickyAnchorBar").attr("aria-label",N);}this.$("anchBar").attr("aria-label",B);};
w.prototype._formatLandmarkInfo=function(y,z){if(y){var B=y["get"+z+"Role"]()||"",E=y["get"+z+"Label"]()||"";if(B===t.None){B='';}return{role:B.toLowerCase(),label:E};}return{};};
w.prototype._getHeaderTag=function(y){if(y&&y.getHeaderRole()!==t.None){return w.DIV;}return w.HEADER;};
w.prototype._getFooterTag=function(y){if(y&&y.getFooterRole()!==t.None){return w.DIV;}return w.FOOTER;};
function x(y){if(arguments.length===1){return Array.isArray(y)?y.length>0:!!y;}return Array.prototype.slice.call(arguments).every(function(z){return x(z);});}
return w;});
sap.ui.predefine('sap/uxap/ObjectPageLayoutABHelper',["sap/ui/thirdparty/jquery","sap/ui/base/Object","sap/ui/core/Core","sap/ui/core/CustomData","sap/ui/core/Configuration","sap/ui/base/ManagedObjectObserver","./AnchorBar","sap/m/Button","sap/m/MenuButton","sap/m/Menu","sap/m/MenuItem","sap/ui/core/IconPool","sap/ui/core/InvisibleText"],function(q,B,C,a,b,M,A,c,d,e,f,I,g){"use strict";
var h=B.extend("sap.uxap._helpers.AB",{
constructor:function(o){this._oObjectPageLayout=o;this._oObserver=new M(this._proxyStateChanges.bind(this));this._aMenusWithAttachPressHandler=[];},
getInterface:function(){return this;}
});
h._focusSection=function(s,p){var S=s.getDomRef();if(S){S.focus(p);}};
h.prototype.getObjectPageLayout=function(){return this._oObjectPageLayout;};
h.prototype._proxyStateChanges=function(o){var O=o.object,j=this._findExistingClone(O),p=o.name,v=o.current,s="set"+i(p);if(j){j[s].call(j,v);}};
h.prototype._findExistingClone=function(o){var j,s=o.getId()+"-__clone",k=this._getAnchorBar(),l=k.getContent();l.some(function(m){if(m.getId().indexOf(s)===0){j=m;return true;}});return j;};
h.prototype._getAnchorBar=function(){var o=this.getObjectPageLayout(),j=o.getAggregation("_anchorBar");if(!j){j=new A({id:o.getId()+"-anchBar",showPopover:o.getShowAnchorBarPopover(),backgroundDesign:o.getBackgroundDesignAnchorBar()});j.attachEvent("_anchorPress",o.onAnchorBarTabPress,o);this.getObjectPageLayout().setAggregation("_anchorBar",j,true);}return j;};
h.prototype._setCustomData=function(o,s,O,j){O._oSectionInfo[s.getId()].buttonId=o.getId();o.addCustomData(new a({key:"sectionId",value:s.getId()}));o.addCustomData(new a({key:"bTitleVisible",value:s._getInternalTitleVisible()}));if(!j){o.addCustomData(new a({key:"secondLevel",value:true}));}};
h.prototype._buildAnchorBar=function(){var o=this.getObjectPageLayout(),s=o.getSections()||[],j=this._getAnchorBar(),p=q.proxy(j.onButtonPress,j),k,l,m,n,S=g.getStaticId("sap.m","SPLIT_BUTTON_DESCRIPTION");if(j&&this.getObjectPageLayout().getShowAnchorBar()){j._resetControl();this._oObserver.disconnect();s.forEach(function(r){if(!r.getVisible()||!r._getInternalVisible()){return;}var t,u=r.getSubSections()||[];t=this._buildAnchorBarButton(r,true);if(t){j.addContent(t);if(t instanceof d){var v=new e({});t.enhanceAccessibilityState=function(E,w){var x=j.getContent(),y=x.indexOf(E.getParent());if(y!==-1){w.role="option";w.setsize=x.length;w.posinset=y+1;w.labelledby=w.labelledby.split(" ").filter(function(z){return z!==S;}).join(" ");}};v._setCustomEnhanceAccStateFunction(function(E,w){w.controls=E.data("sectionId");});t.setMenu(v);}u.forEach(function(w){if(!w.getVisible()||!w._getInternalVisible()){return;}var x=this._buildAnchorBarButton(w,false),y=j.getId()+"-"+w.getId()+"-anchor";if(x){j.addContent(x);}if(t instanceof d){n=w.getCustomAnchorBarButton();if(n){k=n.getText();l=n.getIcon();}else{k=w._getInternalTitle()||w.getTitle();l='';}m=new f(y,{"text":k,"icon":l});m.addCustomData(new a({key:"sectionId",value:w.getId()}));m.attachPress(p);this._setCustomData(m,w,o,false);t.getMenu().addItem(m);}},this);}},this);}};
h.prototype._moveFocusOnSection=function(s){var S=s.data(),o=sap.ui.getCore().byId(S.sectionId),F={preventScroll:true},D;if(o){if(o.isActive()){h._focusSection(o,F);}else{D={"onAfterRendering":function(){o.removeEventDelegate(D);h._focusSection(o,F);}};o.addEventDelegate(D);}}};
h.prototype._instantiateAnchorBarButton=function(j,s,k){var l,S;if(j){l=d;S={type:"Transparent",buttonMode:"Split",useDefaultActionOnly:true,ariaDescribedBy:s};}else{l=c;S={ariaDescribedBy:s};}if(k){S.id=k;}return new l(S);};
h.prototype._buildAnchorBarButton=function(s,j){var o=null,O=this.getObjectPageLayout(),k,l=this._getAnchorBar(),m,S,H,v,n=s.getAggregation("subSections"),p=q.proxy(l.onButtonPress,l);if(s.getVisible()&&s._getInternalVisible()){k=s.getCustomAnchorBarButton();if(!k){m=l.getId()+"-"+s.getId()+"-anchor";if(j){if(n&&n.length>1){v=n.filter(function(r){return r.getVisible()&&r._getInternalVisible();}).length;}}H=j&&v>1&&l.getShowPopover();if(H){o=this._instantiateAnchorBarButton(true,s,m);o.attachDefaultAction(p);o._getButtonControl().attachPress(function(){this.getParent().focus();});o._getButtonControl().attachArrowPress(function(){var r=o._getButtonControl();if(this._aMenusWithAttachPressHandler[r.getId()]){return;}o.getMenu().attachItemSelected(function(E){this._moveFocusOnSection(E.getParameter("item"));},this);this._aMenusWithAttachPressHandler[r.getId()]=true;},this);o.addCustomData(new a({key:"bHasSubMenu",value:true}));}else if(j){o=this._instantiateAnchorBarButton(false,s,m);o.attachPress(function(E){this._moveFocusOnSection(E.getSource());},this);o.attachPress(p);}else{S=l.getId()+"-"+s.getId()+"-sub-anchor";o=this._instantiateAnchorBarButton(false,s,S);}var t=(s._getInternalTitle()!="")?s._getInternalTitle():s.getTitle();o.setText(t);}else{o=k.clone();o.attachPress(function(E){this._moveFocusOnSection(E.getSource());},this);o.attachPress(p);this._oObserver.observe(k,{properties:true});}this._setCustomData(o,s,O,j);}return o;};
function i(n){return n.substring(0,1).toUpperCase()+n.substring(1);}
return h;});
sap.ui.predefine('sap/uxap/ObjectPageLayoutRenderer',["sap/ui/Device"],function(D){"use strict";var O={apiVersion:2};
O.render=function(r,c){var s,h=c.getHeaderTitle(),a=null,R=sap.uxap.ObjectPageLayout._getLibraryResourceBundle(),i=c.getHeaderContent()&&c.getHeaderContent().length>0&&c.getShowHeaderContent(),I=c.getShowTitleInHeaderContent()&&c.getShowHeaderContent(),b=i||I,u=c.getUseIconTabBar(),t=c.getToggleHeaderOnTitleClick()&&c.getHeaderTitle()&&c.getHeaderTitle().supportsToggleHeaderOnTitleClick(),d=c._getAriaLabelText("ROOT",true),H=c._getAriaLabelText("HEADER",true),B=c.getBackgroundDesignAnchorBar(),l=c.getLandmarkInfo(),e=c._getHeaderTag(l),f=c._getFooterTag(l),g=l&&l.getHeaderRole(),j=l&&l.getHeaderLabel(),k=l&&l.getRootRole(),m=l&&l.getRootLabel(),n=l&&l.getNavigationRole();if(c.getShowAnchorBar()&&c._getInternalAnchorBarVisible()){a=c.getAggregation("_anchorBar");}r.openStart("div",c);if(!k){r.attr("role","main");}r.attr("aria-roledescription",R.getText("ROOT_ROLE_DESCRIPTION"));if(!m){r.attr("aria-label",d);}r.class("sapUxAPObjectPageLayout");if(t){r.class("sapUxAPObjectPageLayoutTitleClickEnabled");}if(!b){r.class("sapUxAPObjectPageLayoutNoHeaderContent");}if(!a||!a.getVisible()){r.class("sapUxAPObjectPageLayoutNoAnchorBar");}r.style("height",c.getHeight());r.accessibilityState(c,c._formatLandmarkInfo(l,"Root"));r.openEnd();if(D.system.desktop){r.renderControl(c._getCustomScrollBar());}r.openStart(e,c.getId()+"-headerTitle");if(!g){r.attr("role","banner");}r.attr("aria-roledescription",R.getText("HEADER_ROLE_DESCRIPTION"));if(!j){r.attr("aria-label",H);}r.attr("data-sap-ui-customfastnavgroup",true).class("sapUxAPObjectPageHeaderTitle").class("sapContrastPlus").accessibilityState(c,c._formatLandmarkInfo(l,"Header")).openEnd();if(h){r.renderControl(h);}this._renderHeaderContentDOM(r,c,c._bHeaderInTitleArea,"-stickyHeaderContent");r.openStart("div",c.getId()+"-stickyAnchorBar");r.attr("data-sap-ui-customfastnavgroup",true);if(!n){r.attr("role","navigation");}r.attr("aria-roledescription",R.getText("NAVIGATION_ROLE_DESCRIPTION"));if(!c._bHeaderInTitleArea){r.attr("aria-hidden","true");}r.class("sapUxAPObjectPageStickyAnchorBar").class("sapUxAPObjectPageNavigation").class("ui-helper-clearfix");if(B){r.class("sapUxAPObjectPageNavigation"+B);}r.accessibilityState(c,c._formatLandmarkInfo(l,"Navigation"));r.openEnd();this._renderAnchorBar(r,c,a,c._bHeaderInTitleArea);r.close("div");r.close(e);r.openStart("div",c.getId()+"-opwrapper").class("sapUxAPObjectPageWrapper");if(h&&(!h.supportsTitleInHeaderContent()||!(c.getShowTitleInHeaderContent()&&h.getShowTitleSelector()))){r.class("sapUxAPObjectPageWrapperTransform");}r.openEnd();r.openStart("div",c.getId()+"-scroll").class("sapUxAPObjectPageScroll").openEnd();this._renderHeaderContentDOM(r,c,!c._bHeaderInTitleArea,"-headerContent",true);r.openStart("section",c.getId()+"-anchorBar");r.attr("data-sap-ui-customfastnavgroup",true);if(!n){r.attr("role","navigation");}r.attr("aria-roledescription",R.getText("NAVIGATION_ROLE_DESCRIPTION"));r.class("sapUxAPObjectPageNavigation").class("ui-helper-clearfix").class("sapContrastPlus");if(B){r.class("sapUxAPObjectPageNavigation"+B);}r.accessibilityState(c,c._formatLandmarkInfo(l,"Navigation"));r.openEnd();this._renderAnchorBar(r,c,a,!c._bHeaderInTitleArea);r.close("section");r.openStart("section",c.getId()+"-sectionsContainer");r.class("sapUxAPObjectPageContainer");r.class("ui-helper-clearfix");if(!a){r.class("sapUxAPObjectPageContainerNoBar");}r.accessibilityState(c,c._formatLandmarkInfo(l,"Content"));r.openEnd();s=c._getSectionsToRender();if(Array.isArray(s)){s.forEach(function(S){r.renderControl(S);if(u){c._oCurrentTabSection=S;}});}r.close("section");this.renderFooterContent(r,c);r.openStart("div",c.getId()+"-spacer").openEnd().close("div");r.openStart("span",c.getId()+"-skipFastGroupAnchor").class("sapUiPseudoInvisibleText").openEnd().close("span");r.close("div");r.close("div");this._renderFooterContentInternal(r,c,f,l,R);r.close("div");};
O._renderAnchorBar=function(r,c,a,R){var s=c.getAggregation("sections"),h;if(R){h=c._getHeaderContent();if(c.getIsChildPage()&&h&&h.supportsChildPageDesign()){r.openStart("div",c.getId()+"-childPageBar");if(Array.isArray(s)&&s.length>1){r.class('sapUxAPObjectChildPage');}r.openEnd();r.close("div");}if(a){r.renderControl(a);}}};
O._renderHeaderContentDOM=function(r,c,R,i,a){r.openStart("header",c.getId()+i).class("ui-helper-clearfix").class("sapUxAPObjectPageHeaderDetails").class("sapUxAPObjectPageHeaderDetailsDesign-"+c._getHeaderDesign());if(a){r.class("sapContrastPlus");}r.attr("data-sap-ui-customfastnavgroup",true).openEnd();if(R){this.renderHeaderContent(r,c);}r.close("header");};
O.renderHeaderContent=function(r,c){r.renderControl(c._getHeaderContent());};
O.renderFooterContent=function(r,c){};
O._renderFooterContentInternal=function(r,o,f,l,R){var F=o.getFooter(),b=l&&l.getFooterRole();if(!F){return;}r.openStart(f,o.getId()+"-footerWrapper");r.class("sapUxAPObjectPageFooter").class("sapMFooter-CTX").class("sapContrast").class("sapContrastPlus");if(!o.getShowFooter()){r.class("sapUiHidden");}if(!b){r.attr("role","region");}r.attr("aria-roledescription",R.getText("FOOTER_ROLE_DESCRIPTION"));r.accessibilityState(o,o._formatLandmarkInfo(l,"Footer"));r.openEnd();F.addStyleClass("sapUxAPObjectPageFloatingFooter");r.renderControl(F);r.close(f);};
O._rerenderHeaderContentArea=function(r,c){var h=c._bHeaderInTitleArea?"stickyHeaderContent":"headerContent",$;this.renderHeaderContent(r,c);$=c.$(h)[0];if($){r.flush($);}};
return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageLazyLoader',['./library','sap/ui/core/Element','sap/ui/core/StashedControlSupport',"sap/base/assert"],function(l,E,S,a){"use strict";
var L=E.extend("sap.uxap.ObjectPageLazyLoader",{metadata:{library:"sap.uxap",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},defaultAggregation:"content"}});
S.mixInto(L);
L.prototype.setParent=function(p){if(!(p===null||p instanceof sap.uxap.ObjectPageSubSection)){a(false,"setParent(): oParent must be an instance of sap.uxap.ObjectPageSubSection or null");}return E.prototype.setParent.apply(this,arguments);};
return L;});
sap.ui.predefine('sap/uxap/ObjectPageSection',["./ObjectPageSectionBase","sap/ui/Device","sap/m/Button","sap/ui/core/StashedControlSupport","./ObjectPageSubSection","./library","sap/m/library","./ObjectPageSectionRenderer"],function(O,D,B,S,a,l,m,b){"use strict";var c=m.ButtonType;
var d=O.extend("sap.uxap.ObjectPageSection",{metadata:{library:"sap.uxap",properties:{showTitle:{type:"boolean",group:"Appearance",defaultValue:true},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"subSections",aggregations:{subSections:{type:"sap.uxap.ObjectPageSubSection",multiple:true,singularName:"subSection"},_showHideAllButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_showHideButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{selectedSubSection:{type:"sap.uxap.ObjectPageSubSection",multiple:false}},designtime:"sap/uxap/designtime/ObjectPageSection.designtime"}});
d.MEDIA_RANGE=D.media.RANGESETS.SAP_STANDARD;
d._getClosestSection=function(s){var o=(typeof s==="string"&&sap.ui.getCore().byId(s))||s;return(o instanceof a)?o.getParent():o;};
d._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap");};
d.prototype.getSectionText=function(v){return d._getLibraryResourceBundle().getText("SECTION_CONTROL_NAME");};
d.prototype._expandSection=function(){O.prototype._expandSection.call(this)._updateShowHideAllButton(!this._thereAreHiddenSubSections());};
d.prototype.init=function(){O.prototype.init.call(this);this._sContainerSelector=".sapUxAPObjectPageSectionContainer";};
d.prototype.exit=function(){this._detachMediaContainerWidthChange(this._updateImportance,this);};
d.prototype._getImportanceLevelToHide=function(C){var o=this._getObjectPageLayout(),M=C||this._getCurrentMediaContainerRange(),s=o&&o.getShowOnlyHighImportance();return this._determineTheLowestLevelOfImportanceToShow(M.name,s);};
d.prototype._updateImportance=function(C){var o=this._getObjectPageLayout(),i=this._getImportanceLevelToHide(C),h=this.bOutput&&this.getDomRef("header");this.getSubSections().forEach(function(s){s._applyImportanceRules(i);});this._applyImportanceRules(i);this._updateShowHideAllButton(false);h&&h.classList.toggle("sapUxAPObjectPageSectionHeaderHidden",!this._isTitleVisible());if(o&&this.getDomRef()){o._requestAdjustLayout();}};
d.prototype._determineTheLowestLevelOfImportanceToShow=function(M,s){if(s||M==="Phone"){return l.Importance.High;}if(M==="Tablet"){return l.Importance.Medium;}return l.Importance.Low;};
d.prototype.connectToModels=function(){this.getSubSections().forEach(function(s){s.connectToModels();});};
d.prototype._allowPropagationToLoadedViews=function(A){this.getSubSections().forEach(function(s){s._allowPropagationToLoadedViews(A);});};
d.prototype.onBeforeRendering=function(){O.prototype.onBeforeRendering.call(this);this._detachMediaContainerWidthChange(this._updateImportance,this);this._updateImportance();};
d.prototype.onAfterRendering=function(){this._attachMediaContainerWidthChange(this._updateImportance,this);};
d.prototype._isTitleVisible=function(){return(this.getShowTitle()&&this._getInternalTitleVisible())||this._getShouldDisplayExpandCollapseButton()||this._getShouldDisplayShowHideAllButton();};
d.prototype._setSubSectionsFocusValues=function(){var s=this._getVisibleSubSections()||[],L=this.getSelectedSubSection(),p;if(s.length===0){return this;}if(s.length===1){s[0]._setToFocusable(false);return this;}s.forEach(function(o){if(L===o.getId()){o._setToFocusable(true);p=true;}else{o._setToFocusable(false);}});if(!p){s[0]._setToFocusable(true);}return this;};
d.prototype._disableSubSectionsFocus=function(){var s=this.getSubSections()||[];s.forEach(function(o){o._setToFocusable(false);});return this;};
d.prototype._thereAreHiddenSubSections=function(){return this.getSubSections().some(function(s){return s._getIsHidden();});};
d.prototype._updateShowHideSubSections=function(h){this.getSubSections().forEach(function(s){if(h&&s._shouldBeHidden()){s._updateShowHideState(true);}else if(!h){s._updateShowHideState(false);}});};
d.prototype._getShouldDisplayShowHideAllButton=function(){return this.getSubSections().some(function(s){return s._shouldBeHidden();});};
d.prototype._getShouldDisplayExpandCollapseButton=function(){return this._getIsHidden();};
d.prototype._showHideContentAllContent=function(){var s=this._thereAreHiddenSubSections();if(this._getIsHidden()&&s){this._updateShowHideState(false);}this._updateShowHideSubSections(!s);this._updateShowHideAllButton(s);};
d.prototype._updateShowHideState=function(h){if(this._getIsHidden()===h){return this;}this._updateShowHideButton(h);this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton());return O.prototype._updateShowHideState.call(this,h);};
d.prototype._updateShowHideAllButton=function(h){this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton()).setText(this._getShowHideAllButtonText(h));};
d.prototype._getVisibleSubSections=function(){return this.getSubSections().filter(function(s){return s.getVisible()&&s._getInternalVisible();});};
d.prototype._getShowHideAllButton=function(){if(!this.getAggregation("_showHideAllButton")){this.setAggregation("_showHideAllButton",new B({visible:this._getShouldDisplayShowHideAllButton(),text:this._getShowHideAllButtonText(!this._thereAreHiddenSubSections()),press:this._showHideContentAllContent.bind(this),type:c.Transparent}).addStyleClass("sapUxAPSectionShowHideButton"),true);}return this.getAggregation("_showHideAllButton");};
d.prototype._getShowHideButtonText=function(h){return d._getLibraryResourceBundle().getText(h?"HIDE":"SHOW");};
d.prototype._getShowHideAllButtonText=function(h){return d._getLibraryResourceBundle().getText(h?"HIDE_ALL":"SHOW_ALL");};
d.prototype._updateShowHideButton=function(h){this._getShowHideButton().setVisible(this._shouldBeHidden()).setText(this._getShowHideButtonText(!h));};
d.prototype._getShowHideButton=function(){if(!this.getAggregation("_showHideButton")){this.setAggregation("_showHideButton",new B({visible:this._shouldBeHidden(),text:this._getShowHideButtonText(!this._getIsHidden()),press:this._showHideContent.bind(this),type:c.Transparent}).addStyleClass("sapUxAPSectionShowHideButton"),true);}return this.getAggregation("_showHideButton");};
S.mixInto(d);return d;});
sap.ui.predefine('sap/uxap/ObjectPageSectionBase',["sap/ui/core/InvisibleText","sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/library","./library","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/dom/jquery/Focusable"],function(I,q,C,c,l,L,K){"use strict";var T=c.TitleLevel;
var O=C.extend("sap.uxap.ObjectPageSectionBase",{
metadata:{"abstract":true,library:"sap.uxap",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:T.Auto},visible:{type:"boolean",group:"Appearance",defaultValue:true},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:l.Importance.High}},aggregations:{ariaLabelledBy:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},customAnchorBarButton:{type:"sap.m.Button",multiple:false}}},
renderer:null
});
O.prototype.init=function(){this._bInternalVisible=true;this._bInternalTitleVisible=true;this._sInternalTitle="";this._sInternalTitleLevel=T.Auto;this._isHidden=false;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();};
O.prototype.onAfterRendering=function(){if(this._getObjectPageLayout()){this._getObjectPageLayout()._requestAdjustLayout().catch(function(){L.debug("ObjectPageSectionBase :: cannot adjustLayout",this);});this._getObjectPageLayout()._setSectionsFocusValues();}};
O.prototype.onBeforeRendering=function(){var a="ariaLabelledBy";this.setInvisibleTextLabelValue(this._getTitle());if(!this.getAggregation(a)){this.setAggregation(a,this._getAriaLabelledBy(),true);}};
O.prototype.setCustomAnchorBarButton=function(b){var r=this.setAggregation("customAnchorBarButton",b,true);if(this._getObjectPageLayout()){this._getObjectPageLayout()._updateNavigation();}return r;};
O.prototype.getSectionText=function(){return"";};
O.prototype.setInvisibleTextLabelValue=function(v){var a=this.getAggregation("ariaLabelledBy"),s=this.getSectionText(),b="";if(v){b=v+" ";}if(a){sap.ui.getCore().byId(a.getId()).setText(b+s);}return this;};
O.prototype._getAriaLabelledBy=function(){var s="",t=this._getTitle();if(t){s+=t+" ";}s+=this.getSectionText();return new I({text:s}).toStatic();};
O.prototype._setInternalVisible=function(v,i){if(v!=this._bInternalVisible){this._bInternalVisible=v;if(i){this.invalidate();}}};
O.prototype._getInternalVisible=function(){return this._bInternalVisible;};
O.prototype._setInternalTitleVisible=function(v,i){if(v!=this._bInternalTitleVisible){this._bInternalTitleVisible=v;if(i){this.invalidate();}}};
O.prototype._getInternalTitleVisible=function(){return this._bInternalTitleVisible;};
O.prototype._setInternalTitle=function(v,i){if(v!=this._sInternalTitle){this._sInternalTitle=v;if(i){this.invalidate();}}};
O.prototype._getTitle=function(){return this._getInternalTitle()||this.getTitle();};
O.prototype._getInternalTitle=function(){return this._sInternalTitle;};
O.prototype._getARIALevel=function(){var t=this._getTitleLevel();if(t===T.Auto){t=T.H2;}return t.slice(-1);};
O.prototype._getTitleLevel=function(){var t=this.getTitleLevel();return(t===T.Auto)?this._getInternalTitleLevel():t;};
O.prototype._setInternalTitleLevel=function(t,i){if(t!==this._sInternalTitleLevel){this._sInternalTitleLevel=t;if(i){this.invalidate();}}};
O.prototype._getInternalTitleLevel=function(){return this._sInternalTitleLevel;};
O.prototype._getObjectPageLayout=function(){return l.Utilities.getClosestOPL(this);};
O.prototype._notifyObjectPageLayout=function(){if(this._getObjectPageLayout()&&this._getObjectPageLayout().$().length){this._getObjectPageLayout()._requestAdjustLayoutAndUxRules();}};
["addAggregation","insertAggregation","removeAllAggregation","removeAggregation","destroyAggregation"].forEach(function(m){O.prototype[m]=function(a,o,i,s){if(["addAggregation","removeAggregation"].indexOf(m)>-1){s=i;}if(["removeAllAggregation","destroyAggregation"].indexOf(m)>-1){s=o;}var r=C.prototype[m].apply(this,arguments);if(s!==true){this._notifyObjectPageLayout();}return r;};});
O.prototype.setVisible=function(v,s){if(this.getVisible()===v){return this;}if(!this._getObjectPageLayout()){return this.setProperty("visible",v,s);}this.setProperty("visible",v,true);this._notifyObjectPageLayout();this.invalidate();return this;};
O.prototype.setTitle=function(v,s){this.setProperty("title",v,s);this._notifyObjectPageLayout();this.setInvisibleTextLabelValue(v);return this;};
O.prototype._shouldBeHidden=function(){return O._importanceMap[this.getImportance()]>O._importanceMap[this._sCurrentLowestImportanceLevelToShow];};
O._importanceMap={"Low":3,"Medium":2,"High":1};
O.prototype._updateShowHideState=function(h){var o=this._getObjectPageLayout();this._isHidden=h;this.$().children(this._sContainerSelector).toggle(!h);if(o){o._requestAdjustLayout();}return this;};
O.prototype._getIsHidden=function(){return this._isHidden;};
O.prototype._expandSection=function(){return this._updateShowHideState(false);};
O.prototype._showHideContent=function(){return this._updateShowHideState(!this._getIsHidden());};
O.prototype._applyImportanceRules=function(s){this._sCurrentLowestImportanceLevelToShow=s;if(this.getDomRef()){this._updateShowHideState(this._shouldBeHidden());}else{this._isHidden=this._shouldBeHidden();}};
O.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
O.prototype.onkeydown=function(e){if(e.keyCode===K.SPACE&&e.srcControl.isA("sap.uxap.ObjectPageSection")){e.preventDefault();}if(e.keyCode===K.F7){var s=this.getSubSections(),f=s[0],o;if(s.length===1){o=f._oLastFocusedControlF7;if(o){o.$().trigger("focus");}else{f.$().firstFocusableDomRef().focus();}}else{if(f.getActions().length){f.getActions()[0].$().trigger("focus");}}}};
O.prototype.onsapdown=function(e){this._handleFocusing(e,e.currentTarget.nextSibling);};
O.prototype._handleFocusing=function(e,E){var s;if(this._targetIsCorrect(e)&&E){s=q(e.currentTarget).parent().children();e.preventDefault();E.focus();if(s.length>1){this._scrollParent(q(E).attr("id"));}}};
O.prototype._targetIsCorrect=function(e){return e.srcControl===this;};
O.prototype.onsapright=function(e){var m=this._bRtl?"onsapup":"onsapdown";this[m](e);};
O.prototype.onsapup=function(e){this._handleFocusing(e,e.currentTarget.previousSibling);};
O.prototype.onsapleft=function(e){var m=this._bRtl?"onsapdown":"onsapup";this[m](e);};
O.prototype.onsaphome=function(e){this._handleFocusing(e,e.currentTarget.parentElement.firstChild);};
O.prototype.onsapend=function(e){this._handleFocusing(e,e.currentTarget.parentElement.lastChild);};
O.prototype.onsappageup=function(e){if(!this._targetIsCorrect(e)){return;}e.preventDefault();var n;var s=q(e.currentTarget).parent().children();var f;s.each(function(S,o){if(q(o).attr("id")===e.currentTarget.id){n=S-(O.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return;}});if(n&&s[n]){s[n].focus();f=q(s[n]).attr("id");}else if(s[0]){s[0].focus();f=q(s[0]).attr("id");}if(s.length>1){this._scrollParent(f);}};
O.prototype.onsappagedown=function(e){if(!this._targetIsCorrect(e)){return;}e.preventDefault();var n;var s=q(e.currentTarget).parent().children();var f;s.each(function(S,o){if(q(o).attr("id")===e.currentTarget.id){n=S+O.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return;}});if(n&&s[n]){s[n].focus();f=q(s[n]).attr("id");}else if(s[s.length-1]){s[s.length-1].focus();f=q(s[s.length-1]).attr("id");}if(s.length>1){this._scrollParent(f);}};
O.prototype._scrollParent=function(i){if(this._getObjectPageLayout()){this._getObjectPageLayout().scrollToSection(i,0,10);}};
return O;});
sap.ui.predefine('sap/uxap/ObjectPageSectionRenderer',function(){"use strict";var O={apiVersion:2};
O.render=function(r,c){var t,T,a=sap.ui.getCore().getConfiguration().getAccessibility(),l=c.getAggregation("ariaLabelledBy");if(!c.getVisible()||!c._getInternalVisible()){return;}t=c._getTitle();T=c._isTitleVisible();r.openStart("section",c).class("sapUxAPObjectPageSection");if(!T){r.class("sapUxAPObjectPageSectionNoTitle");}r.attr("role","region");if(a&&l){r.attr("aria-labelledby",l.getId());}r.openEnd();r.openStart("div",c.getId()+"-header").attr("role","heading").attr("aria-level",c._getARIALevel()).class("sapUxAPObjectPageSectionHeader").class(T?"":"sapUxAPObjectPageSectionHeaderHidden").openEnd();r.openStart("div",c.getId()+"-title").class("sapUxAPObjectPageSectionTitle");if(c.getTitleUppercase()){r.class("sapUxAPObjectPageSectionTitleUppercase");}r.openEnd();r.text(t);r.close("div");if(T){r.renderControl(c._getShowHideAllButton());r.renderControl(c._getShowHideButton());}r.close("div");r.openStart("div").class("sapUxAPObjectPageSectionContainer");if(c._isHidden){r.style("display","none");}r.openEnd();c.getSubSections().forEach(r.renderControl,r);r.close("div");r.close("section");};
return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageSubSection',["sap/ui/thirdparty/jquery","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/ui/core/Core","./ObjectPageSectionBase","./ObjectPageLazyLoader","./BlockBase","sap/m/Button","sap/ui/Device","sap/ui/core/StashedControlSupport","sap/ui/base/ManagedObjectObserver","sap/m/TitlePropagationSupport","./library","sap/m/library","./ObjectPageSubSectionRenderer","sap/base/Log","sap/ui/base/DataType","sap/ui/events/KeyCodes","sap/ui/dom/jquery/Focusable"],function(q,G,a,C,O,b,B,c,D,S,d,T,l,m,e,f,g,K){"use strict";var h=m.ButtonType;var i=l.ObjectPageSubSectionMode;var j=l.ObjectPageSubSectionLayout;
var k=O.extend("sap.uxap.ObjectPageSubSection",{metadata:{library:"sap.uxap",properties:{showTitle:{type:"boolean",group:"Appearance",defaultValue:true},mode:{type:"sap.uxap.ObjectPageSubSectionMode",group:"Appearance",defaultValue:i.Collapsed},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"blocks",aggregations:{_grid:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},blocks:{type:"sap.ui.core.Control",multiple:true,singularName:"block"},moreBlocks:{type:"sap.ui.core.Control",multiple:true,singularName:"moreBlock"},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"}},designtime:"sap/uxap/designtime/ObjectPageSubSection.designtime"}});
T.call(k.prototype,"blocks",function(){return this._getTitleDomId();});k.FIT_CONTAINER_CLASS="sapUxAPObjectPageSubSectionFitContainer";
k._getLibraryResourceBundle=function(){return C.getLibraryResourceBundle("sap.uxap");};
k.prototype.init=function(){O.prototype.init.call(this);this._aStashedControls=[];this._bRenderedFirstTime=false;this._aAggregationProxy={blocks:[],moreBlocks:[]};this._$spacer=[];this._sContainerSelector=".sapUxAPBlockContainer";this._sMoreContainerSelector=".sapUxAPSubSectionSeeMoreContainer";this._oObserver=new d(k.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["actions"]});this._oBlocksObserver=new d(this._onBlocksChange.bind(this));this._switchSubSectionMode(this.getMode());this._initTitlePropagationSupport();this._sBorrowedTitleDomId=false;this._height="";};
k.prototype._getHeight=function(){return this._height;};
k.prototype._setHeight=function(v){var t,o;if(this._height===v){return;}t=g.getType("sap.ui.core.CSSSize");if(!t.isValid(v)){throw new Error("\""+v+"\" is of type "+typeof v+", expected "+t.getName()+" for property \"_height\" of "+this);}this._height=v;o=this.getDomRef();if(o){o.style.height=v;}};
k.prototype.getSectionText=function(v){return k._getLibraryResourceBundle().getText("SUBSECTION_CONTROL_NAME");};
k.prototype._getTitleDomId=function(){if(this._sBorrowedTitleDomId){return this._sBorrowedTitleDomId;}if(!this.getTitle().trim()){return false;}if(this._getInternalTitleVisible()){return this.getId()+"-headerTitle";}return false;};
k.prototype._setBorrowedTitleDomId=function(I){this._sBorrowedTitleDomId=I;};
k.prototype._expandSection=function(){O.prototype._expandSection.call(this);var p=this.getParent();p&&typeof p._expandSection==="function"&&p._expandSection();return this;};
k.prototype._getGrid=function(){if(!this.getAggregation("_grid")){this.setAggregation("_grid",new G({id:this.getId()+"-innerGrid",defaultSpan:"XL12 L12 M12 S12",hSpacing:1,vSpacing:1,width:"100%",containerQuery:true}),true);}return this.getAggregation("_grid");};
k.prototype._hasVisibleActions=function(){var A=this.getActions()||[];if(A.length===0){return false;}return A.filter(function(o){return o.getVisible();}).length>0;};
k.prototype._observeChanges=function(o){var n=o.object,s=o.name,M=o.mutation,p=o.child,H;if(n===this){if(s==="actions"){if(M==="insert"){this._observeAction(p);}else if(M==="remove"){this._unobserveAction(p);}}}else if(s==="visible"){H=this._getInternalTitleVisible()&&this.getTitle().trim()!=="";if(!H){this.$("header").toggleClass("sapUiHidden",!this._hasVisibleActions());}}};
k.prototype._onBlocksChange=function(){var o=this._getObjectPageLayout();if(!this._bRenderedFirstTime){return;}this._applyLayout(o);};
k.prototype._observeAction=function(o){this._oObserver.observe(o,{properties:["visible"]});};
k.prototype._unobserveAction=function(o){this._oObserver.unobserve(o,{properties:["visible"]});};
["addStyleClass","toggleStyleClass","removeStyleClass"].forEach(function(M){k.prototype[M]=function(s,n){if(s===k.FIT_CONTAINER_CLASS){this._notifyObjectPageLayout();}return O.prototype[M].apply(this,arguments);};});
k.prototype._unStashControls=function(){var u;this._aStashedControls.forEach(function(o){o.control.unstash();u=C.byId(o.control.getId());this.addAggregation(o.aggregationName,u,true);}.bind(this));this._aStashedControls=[];};
k.prototype.connectToModels=function(){var n=this.getBlocks()||[],M=this.getMoreBlocks()||[],s=this.getMode();this._unStashControls();n.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(s);}o.connectToModels();}});if(M.length>0&&s===i.Expanded){M.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(s);}o.connectToModels();}});}};
k.prototype._allowPropagationToLoadedViews=function(A){var n=this.getBlocks()||[],M=this.getMoreBlocks()||[];n.forEach(function(o){if(o instanceof B){o._allowPropagationToLoadedViews(A);}});M.forEach(function(o){if(o instanceof B){o._allowPropagationToLoadedViews(A);}});};
k.prototype.clone=function(){Object.keys(this._aAggregationProxy).forEach(function(A){var o=this.mAggregations[A];if(!o||o.length===0){this.mAggregations[A]=this._aAggregationProxy[A];}},this);return O.prototype.clone.apply(this,arguments);};
k.prototype._cleanProxiedAggregations=function(){var p=this._aAggregationProxy;Object.keys(p).forEach(function(s){p[s].forEach(function(o){o.destroy();});});};
k.prototype._unobserveBlocks=function(){this.getBlocks().forEach(function(o){o&&this._oBlocksObserver.unobserve(o,{properties:["visible"]});},this);};
k.prototype.exit=function(){if(this._oSeeMoreButton){this._oSeeMoreButton.destroy();this._oSeeMoreButton=null;}if(this._oSeeLessButton){this._oSeeLessButton.destroy();this._oSeeLessButton=null;}this._unobserveBlocks();this._oCurrentlyVisibleSeeMoreLessButton=null;this._cleanProxiedAggregations();if(O.prototype.exit){O.prototype.exit.call(this);}};
k.prototype.onAfterRendering=function(){var o=this._getObjectPageLayout();if(O.prototype.onAfterRendering){O.prototype.onAfterRendering.call(this);}if(!o){return;}this._$spacer=o.$("spacer");if(this._bShouldFocusSeeMoreLessButton&&document.activeElement===document.body){this._oCurrentlyVisibleSeeMoreLessButton.focus();}this._bShouldFocusSeeMoreLessButton=false;};
k.prototype.onBeforeRendering=function(){var o=this._getObjectPageLayout();if(!o){return;}if(O.prototype.onBeforeRendering){O.prototype.onBeforeRendering.call(this);}this._setAggregationProxy();this._getGrid().removeAllContent();this._applyLayout(o);this.refreshSeeMoreVisibility();};
k.prototype._applyLayout=function(L){var v,o=this._getGrid(),n=o.getAggregation("content"),s=this.getMode(),p=L.getSubSectionLayout(),r=this._calculateLayoutConfiguration(p,L),t=this.getBlocks(),A=t.concat(this.getMoreBlocks());this._oLayoutConfig=r;this._resetLayoutData(A);if(s===i.Expanded){v=A;}else{v=t;}this._calcBlockColumnLayout(v,this._oLayoutConfig);try{v.forEach(function(u){this._setBlockMode(u,s);if(!n||(n&&n.indexOf(u)<0)){o.addAggregation("content",u,true);}},this);}catch(E){f.error("ObjectPageSubSection :: error while building layout "+p+": "+E);}return this;};
k.prototype._calculateLayoutConfiguration=function(L,o){var n={M:2,L:3,XL:4},p=n.L,E=n.XL,t=(L===j.TitleOnLeft),u=o.getUseTwoColumnsForLargeScreen();if(t){p-=1;E-=1;}if(u){p-=1;}n.L=p;n.XL=E;return n;};
k.prototype.refreshSeeMoreVisibility=function(){var s=this._getSeeMoreButton(),o=this._getSeeLessButton();this._bBlockHasMore=!!this.getMoreBlocks().length;if(!this._bBlockHasMore){this._bBlockHasMore=this.getBlocks().some(function(n){if(n instanceof B&&n.getVisible()&&n.getShowSubSectionMore()){return true;}});}this.toggleStyleClass("sapUxAPObjectPageSubSectionWithSeeMore",this._bBlockHasMore);s.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",this._bBlockHasMore);o.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",this._bBlockHasMore);return this._bBlockHasMore;};
k.prototype.setMode=function(M){if(this.getMode()!==M){this._switchSubSectionMode(M);if(this._bRenderedFirstTime){this.rerender();}}return this;};
k.prototype.onkeydown=function(E){if(E.keyCode===K.SPACE&&E.srcControl.isA("sap.uxap.ObjectPageSubSection")){E.preventDefault();}if(E.keyCode===K.F7){E.stopPropagation();var t=C.byId(E.target.id);if(t instanceof k){this._handleSubSectionF7();}else{this._handleInteractiveElF7();this._oLastFocusedControlF7=t;}}};
k.prototype._handleInteractiveElF7=function(){if(this.getParent().getSubSections().length>1){this.$().trigger("focus");}else{this.getParent().$().trigger("focus");}};
k.prototype._handleSubSectionF7=function(E){if(this._oLastFocusedControlF7){this._oLastFocusedControlF7.$().trigger("focus");}else{this.$().firstFocusableDomRef().focus();}};
k.prototype._calcBlockColumnLayout=function(n,o){var p=12,v,M,L,X,r;M={iRemaining:o.M,iColumnConfig:o.M};L={iRemaining:o.L,iColumnConfig:o.L};X={iRemaining:o.XL,iColumnConfig:o.XL};r=[X,L,M];v=n.filter(function(s){return s.getVisible&&s.getVisible();});v.forEach(function(s,I){r.forEach(function(t){t.iCalculatedSize=this._calculateBlockSize(s,t.iRemaining,v,I,t.iColumnConfig);},this);s.setLayoutData(new a(s.getId()+"-layoutData",{spanS:p,spanM:M.iCalculatedSize*(p/M.iColumnConfig),spanL:L.iCalculatedSize*(p/L.iColumnConfig),spanXL:X.iCalculatedSize*(p/X.iColumnConfig),linebreakM:(I>0&&M.iRemaining===M.iColumnConfig),linebreakL:(I>0&&L.iRemaining===L.iColumnConfig),linebreakXL:(I>0&&X.iRemaining===X.iColumnConfig)}));r.forEach(function(t){t.iRemaining-=t.iCalculatedSize;if(t.iRemaining<1){t.iRemaining=t.iColumnConfig;}});},this);return v;};
k.prototype._calculateBlockSize=function(o,r,v,n,M){var p,F=M,s;if(!this._hasAutoLayout(o)){return Math.min(M,parseInt(o.getColumnLayout()));}for(s=1;s<=F;s++){p=this._calcLayout(v[n+s]);if(p<r){r-=p;}else{break;}}return r;};
k.prototype._calcLayout=function(o){var L=1;if(!o){L=0;}else if(o instanceof B&&o.getColumnLayout()!="auto"){L=parseInt(o.getColumnLayout());}return L;};
k.prototype._hasAutoLayout=function(o){return!(o instanceof B)||o.getColumnLayout()=="auto";};
k.prototype._setAggregationProxy=function(){if(this._bRenderedFirstTime){return;}q.each(this._aAggregationProxy,q.proxy(function(A,v){this._setAggregation(A,this.removeAllAggregation(A,true),true);},this));this._bRenderedFirstTime=true;};
k.prototype.hasProxy=function(A){return this._bRenderedFirstTime&&this._aAggregationProxy.hasOwnProperty(A);};
k.prototype._getAggregation=function(A){return this._aAggregationProxy[A];};
k.prototype._setAggregation=function(A,v,s){this._aAggregationProxy[A]=v;if(s!==true){this._notifyObjectPageLayout();this.invalidate();}return this._aAggregationProxy[A];};
k.prototype.addAggregation=function(A,o,s){var n;if(o instanceof b){if(o.isStashed()){this._aStashedControls.push({aggregationName:A,control:o});}else{o.getContent().forEach(function(p){this.addAggregation(A,p,true);},this);o.removeAllContent();o.destroy();this.invalidate();}}else if(this.hasProxy(A)){n=this._getAggregation(A);n.push(o);this._setAggregation(A,n,s);if(o instanceof B||o instanceof b){o.setParent(this);}}else{O.prototype.addAggregation.apply(this,arguments);}return this;};
k.prototype.insertBlock=function(o,I){f.warning("ObjectPageSubSection :: usage of insertBlock is not supported - addBlock is performed instead.");return this.addAggregation("blocks",o);};
k.prototype.addBlock=function(o){o&&this._oBlocksObserver.observe(o,{properties:["visible"]});return this.addAggregation("blocks",o);};
k.prototype.removeBlock=function(o){o&&this._oBlocksObserver.unobserve(o,{properties:["visible"]});return this.removeAggregation("blocks",o);};
k.prototype.removeAllBlocks=function(){this._unobserveBlocks();return this.removeAllAggregation("blocks");};
k.prototype.insertMoreBlock=function(o,I){f.warning("ObjectPageSubSection :: usage of insertMoreBlock is not supported - addMoreBlock is performed instead.");return this.addAggregation("moreBlocks",o);};
k.prototype.removeAllAggregation=function(A,s){var I;if(this.hasProxy(A)){I=this._getAggregation(A);this._setAggregation(A,[],s);return I.slice();}return O.prototype.removeAllAggregation.apply(this,arguments);};
k.prototype.removeAggregation=function(A,o){var r=false,I;if(this.hasProxy(A)){I=this._getAggregation(A);I.forEach(function(n,p){if(n.getId()===o.getId()){I.splice(p,1);this._setAggregation(A,I);r=true;}return!r;},this);return(r?o:null);}return O.prototype.removeAggregation.apply(this,arguments);};
k.prototype.indexOfAggregation=function(A,o){var I=-1;if(this.hasProxy(A)){this._getAggregation(A).some(function(n,p){if(n.getId()===o.getId()){I=p;return true;}},this);return I;}return O.prototype.indexOfAggregation.apply(this,arguments);};
k.prototype.getAggregation=function(A){if(this.hasProxy(A)){return this._getAggregation(A);}return O.prototype.getAggregation.apply(this,arguments);};
k.prototype.destroyAggregation=function(A){if(this.hasProxy(A)){this._getAggregation(A).forEach(function(o){o.destroy();});this._setAggregation(A,[]);return this;}return O.prototype.destroyAggregation.apply(this,arguments);};
k.prototype.destroy=function(){this._aStashedControls.forEach(function(o){o.control.destroy();});O.prototype.destroy.apply(this,arguments);};
k.prototype._getSeeMoreButton=function(){if(!this._oSeeMoreButton){this._oSeeMoreButton=new c(this.getId()+"--seeMore",{type:h.Transparent,iconFirst:false,text:k._getLibraryResourceBundle().getText("SHOW_MORE")}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this);}return this._oSeeMoreButton;};
k.prototype._getSeeLessButton=function(){if(!this._oSeeLessButton){this._oSeeLessButton=new c(this.getId()+"--seeLess",{type:h.Transparent,iconFirst:false,text:k._getLibraryResourceBundle().getText("SHOW_LESS")}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this);}return this._oSeeLessButton;};
k.prototype._seeMoreLessControlPressHandler=function(E){var s=this.getMode(),t,M=this.getMoreBlocks()||[];if(s===i.Expanded){t=i.Collapsed;}else{t=i.Expanded;M.forEach(function(o){if(o instanceof B){o.setMode(s);o.connectToModels();}},this);}this._switchSubSectionMode(t);this._bShouldFocusSeeMoreLessButton=true;};
k.prototype._switchSubSectionMode=function(s){s=this.validateProperty("mode",s);if(s===i.Collapsed){this.setProperty("mode",i.Collapsed);this._oCurrentlyVisibleSeeMoreLessButton=this._getSeeMoreButton().setVisible(true);this._getSeeLessButton().setVisible(false);}else{this.setProperty("mode",i.Expanded);this._getSeeMoreButton().setVisible(false);this._oCurrentlyVisibleSeeMoreLessButton=this._getSeeLessButton().setVisible(true);}};
k.prototype._setBlockMode=function(o,M){if(o instanceof B){o.setMode(M);}else{f.debug("ObjectPageSubSection :: cannot propagate mode "+M+" to "+o.getMetadata().getName());}};
k.prototype._setToFocusable=function(F){var s='0',n='-1',t="tabindex";if(F){this.$().attr(t,s);}else{this.$().attr(t,n);}return this;};
k.prototype._getUseTitleOnTheLeft=function(){var o=this._getObjectPageLayout();return o&&(o.getSubSectionLayout()===j.TitleOnLeft);};
k.prototype._resetLayoutData=function(n){n.forEach(function(o){if(o.getLayoutData()){o.destroyLayoutData();}},this);};
k.prototype._updateShowHideState=function(H){if(this._getIsHidden()===H){return this;}this.$().children(this._sMoreContainerSelector).toggle(!H);return O.prototype._updateShowHideState.call(this,H);};
k.prototype.getVisibleBlocksCount=function(){var v=this._aStashedControls.length;(this.getBlocks()||[]).forEach(function(o){if(o.getVisible&&!o.getVisible()){return true;}v++;});(this.getMoreBlocks()||[]).forEach(function(M){if(M.getVisible&&!M.getVisible()){return true;}v++;});return v;};
return k;});
sap.ui.predefine('sap/uxap/ObjectPageSubSectionRenderer',function(){"use strict";var O={apiVersion:2};
O.render=function(r,c){var a,h,s,H,b,u,d,A=sap.ui.getCore().getConfiguration().getAccessibility(),l=c.getAggregation("ariaLabelledBy");if(!c.getVisible()||!c._getInternalVisible()){return;}a=c.getActions()||[];b=a.length>0;s=c.getShowTitle();h=(c._getInternalTitleVisible()&&(c.getTitle().trim()!==""))&&s;H=h||b;d=c._hasVisibleActions();r.openStart("div",c).attr("role","region").style("height",c._getHeight());if(c._bBlockHasMore){r.class("sapUxAPObjectPageSubSectionWithSeeMore");}r.class("sapUxAPObjectPageSubSection").class("ui-helper-clearfix");if(A&&l){r.attr("aria-labelledby",l.getId());}r.openEnd();if(H){r.openStart("div",c.getId()+"-header").class("sapUxAPObjectPageSubSectionHeader");if(!h&&!d){r.class("sapUiHidden");}u=c._getUseTitleOnTheLeft();if(u){r.class("titleOnLeftLayout");}r.openEnd();r.openStart("div",c.getId()+"-headerTitle");if(h){r.attr("role","heading").attr("aria-level",c._getARIALevel());}r.class('sapUxAPObjectPageSubSectionHeaderTitle');if(c.getTitleUppercase()){r.class("sapUxAPObjectPageSubSectionHeaderTitleUppercase");}r.attr("data-sap-ui-customfastnavgroup",true).openEnd();if(h){r.text(c.getTitle());}r.close("div");if(b){r.openStart("div").class('sapUxAPObjectPageSubSectionHeaderActions').attr("data-sap-ui-customfastnavgroup",true).openEnd();a.forEach(r.renderControl,r);r.close("div");}r.close("div");}r.openStart("div").class("ui-helper-clearfix").class("sapUxAPBlockContainer");if(c._isHidden){r.style("display","none");}r.openEnd();r.renderControl(c._getGrid());r.close("div");r.openStart("div").class("sapUxAPSubSectionSeeMoreContainer");if(c._isHidden){r.style("display","none");}r.openEnd();r.renderControl(c._getSeeMoreButton());r.renderControl(c._getSeeLessButton());r.close("div");r.close("div");};
return O;},true);
sap.ui.predefine('sap/uxap/ThrottledTaskHelper',["sap/ui/thirdparty/jquery",'sap/ui/base/Object'],function(q,B){"use strict";
var T=B.extend("sap.uxap.ThrottledTask",{
constructor:function(t,d,c){this._fnTask=t;this._iDelay=d;this._oContext=c;this._oPromise=null;this._fnResolvePromise=null;this._fnRejectPromise=null;this._iTimer=null;this._oTaskOptions=null;},
reSchedule:function(i,t){var r=this._getPromise();if(this._iTimer){clearTimeout(this._iTimer);this._iTimer=null;}this._oTaskOptions=this._mergeOptions(this._oTaskOptions||{},t);if(i){var s=this._fnTask.call(this._oContext,this._oTaskOptions);this._completePromise(s);return r;}this._iTimer=setTimeout(function(){if(this._oPromise){var s=this._fnTask.call(this._oContext,this._oTaskOptions);this._completePromise(s);}}.bind(this),this._iDelay);return r;},
_getPromise:function(){if(!this._oPromise){this._oPromise=new Promise(function(r,a){this._fnResolvePromise=r;this._fnRejectPromise=a;}.bind(this));}return this._oPromise;},
_completePromise:function(s){var c=(s)?this._fnResolvePromise:this._fnRejectPromise;c();this._oPromise=null;this._fnResolvePromise=null;this._fnRejectPromise=null;this._oTaskOptions=null;},
_mergeOptions:function(o,n){var m=q.extend({},o,n);q.each(m,function(k){m[k]=o[k]||n[k];});return m;}
});
return T;});
sap.ui.predefine('sap/uxap/changeHandler/AddIFrameObjectPageLayout',["sap/ui/fl/Utils","sap/base/Log","sap/ui/fl/changeHandler/AddIFrame","sap/ui/fl/changeHandler/common/getTargetAggregationIndex","sap/ui/fl/changeHandler/common/createIFrame"],function(U,L,B,g,c){"use strict";var A=Object.assign({},B);
A.applyChange=function(C,o,p){var m=p.modifier;var a=C.getDefinition();var s=a.content.targetAggregation;if(s!=="sections"){return Promise.resolve().then(B.applyChange.bind(B,C,o,p));}var v=p.view;var b=p.appComponent;var d=a.content.selector;var D=sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("SECTION_TITLE_FOR_IFRAME");var O;var e;return Promise.resolve().then(m.createControl.bind(m,"sap.uxap.ObjectPageSection",b,v,d,{title:D},false)).then(function(f){O=f;var h=Object.create(d);h.id+="-subSection";return m.createControl("sap.uxap.ObjectPageSubSection",b,v,h,{title:D},false);}).then(function(f){e=f;return m.insertAggregation(O,"subSections",e,0,v);}).then(function(){var i=Object.create(d);i.id+="-iframe";return c(C,p,i);}).then(function(i){return m.insertAggregation(e,"blocks",i,0,v);}).then(g.bind(null,C,o,p)).then(function(i){return m.insertAggregation(o,"sections",O,i,v);}).then(function(){C.setRevertData([m.getId(O)]);});};
return A;},true);
sap.ui.predefine('sap/uxap/changeHandler/MoveObjectPageSection',["sap/ui/fl/changeHandler/MoveControls","sap/ui/core/Core","sap/base/util/merge","sap/ui/thirdparty/jquery"],function(M,C,m,q){"use strict";var a=q.extend({},M);
a.applyChange=function(c,o,p){var j=p.modifier.targets==="jsControlTree";if(j){o._suppressScroll();}var r=M.applyChange.call(this,c,o,p);if(j){o.attachEventOnce("onAfterRenderingDOMReady",function(){o._resumeScroll(false);});}return r;};
a.revertChange=function(c,o,p){var j=p.modifier.targets==="jsControlTree";if(j){o._suppressScroll();}var r=M.revertChange.call(this,c,o,p);if(j){o.attachEventOnce("onAfterRenderingDOMReady",function(){o._resumeScroll(false);});}return r;};
a.completeChangeContent=function(c,s,p){var S=C.byId(s.source.id),t=C.byId(s.target.id);var P=Promise.resolve();if(S.isA("sap.uxap.AnchorBar")&&t.isA("sap.uxap.AnchorBar")){P=P.then(this._mapAnchorsToSections.bind(this,s,p));}return P.then(function(){return M.completeChangeContent.apply(this,arguments[0]);}.bind(this,arguments));};
a._mapAnchorsToSections=function(s,p){return Promise.resolve().then(function(){var S,o;var b=p.modifier;var l=b.bySelector(s.selector,p.appComponent,p.view);var A=l._getVisibleSections();function g(c){var d=C.byId(c),e=d.data("sectionId");return C.byId(e);}var P=[];s.movedElements.forEach(function(e){var c=A[e.targetIndex];var d=Promise.resolve().then(function(){return b.findIndexInParentAggregation(c);}).then(function(t){e.targetIndex=t;S=g(e.id);if(!S||!S.getParent()){throw new Error("Cannot map anchor to section");}o={id:S.getParent().getId(),aggregation:S.sParentAggregationName};e.id=S.getId();});P.push(d);});return Promise.all(P).then(function(){m(s.source,o);m(s.target,o);});});};
return a;},true);
sap.ui.predefine('sap/uxap/changeHandler/RenameObjectPageSection',["sap/ui/fl/Utils","sap/base/Log","sap/ui/fl/changeHandler/BaseRename"],function(U,L,B){"use strict";var r={propertyName:"title",changePropertyName:"newText",translationTextType:"XGRP"};var R=B.createRenameChangeHandler(r);
R._getControlForRename=function(c,m){var s;return Promise.resolve().then(function(){return m.getAggregation(c,"subSections");}).then(function(S){s=S;return Promise.all([m.getPropertyBindingOrProperty(s[0],"title"),m.getProperty(m.getParent(c),"subSectionLayout")]);}).then(function(p){if(s&&s.length===1&&p[0]&&p[1]==="TitleOnTop"){return s[0];}return c;});};
R.applyChange=function(c,C,p){var m=p.modifier;var P=r.propertyName;var o=c.getDefinition();var t=o.texts[r.changePropertyName];var v=t.value;return R._getControlForRename(C,m).then(function(a){if(typeof v==="string"&&v.trim()===""){throw new Error("Change cannot be applied as ObjectPageSubSection's title cannot be empty: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}if(o.texts&&t&&typeof(v)==="string"){return Promise.resolve().then(function(){return m.getPropertyBindingOrProperty(a,P);}).then(function(b){c.setRevertData(b);m.setPropertyBindingOrProperty(a,P,v);return true;});}else{L.error("Change does not contain sufficient information to be applied: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}});};
R.revertChange=function(c,C,p){var o=c.getRevertData(),m=p.modifier,P=r.propertyName;return R._getControlForRename(C,m).then(function(a){if(o||o===""){m.setPropertyBindingOrProperty(a,P,o);c.resetRevertData();return true;}else{L.error("Change doesn't contain sufficient information to be reverted. Most Likely the Change didn't go through applyChange.");}});};
return R;},true);
sap.ui.predefine('sap/uxap/component/Component',["sap/uxap/library","sap/ui/core/UIComponent","sap/ui/core/library","sap/base/Log","sap/ui/core/Component"],function(l,U,c,L){"use strict";var V=c.mvc.ViewType;var O=l.ObjectPageConfigurationMode;
var C=U.extend("sap.uxap.component.Component",{
metadata:{},
init:function(){this._oModel=null;this._oViewConfig={viewData:{component:this}};switch(this.oComponentData.mode){case O.JsonURL:this._oModel=new U(this.oComponentData.jsonConfigurationURL);this._oViewConfig.viewName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory";this._oViewConfig.type=V.XML;break;case O.JsonModel:this._oViewConfig.viewName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory";this._oViewConfig.type=V.XML;break;default:L.error("UxAPComponent :: missing bootstrap information. Expecting one of the following: JsonURL, JsonModel and FacetsAnnotation");}U.prototype.init.call(this);},
createContent:function(){var o;this._oView=sap.ui.view(this._oViewConfig);if(this._oModel){o=this._oView.getController();if(o&&o.connectToComponent){o.connectToComponent(this._oModel);}this._oView.setModel(this._oModel,"objectPageLayoutMetadata");}return this._oView;},
propagateProperties:function(n){if(this.oComponentData.mode===O.JsonModel){var o=this._oView.getController();if(o&&o.connectToComponent){o.connectToComponent(this.getModel("objectPageLayoutMetadata"));}}return U.prototype.propagateProperties.apply(this,arguments);},
destroy:function(){if(this._oView){this._oView.destroy();this._oView=null;}if(this._oModel){this._oModel.destroy();this._oModel=null;}if(U.prototype.destroy){U.prototype.destroy.call(this);}}
});
return C;});
sap.ui.predefine('sap/uxap/component/ObjectPageComponentContainer',['sap/ui/core/ComponentContainer',"sap/base/Log",'sap/ui/core/Component'],function(C,L){"use strict";
var O=C.extend("sap.uxap.component.ObjectPageComponentContainer",{
metadata:{library:"sap.uxap",properties:{"jsonConfigurationURL":{type:"string",group:"Behavior"},"mode":{type:"sap.uxap.ObjectPageConfigurationMode",group:"Behavior"}}},
init:function(){this.setPropagateModel(true);this.setName("sap.uxap.component");},
onBeforeRendering:function(){this._oComponent||(this._oComponent=sap.ui.component("sap.uxap"));if(!this._oComponent){this._oComponent=sap.ui.component({name:this.getName(),url:this.getUrl(),componentData:{jsonConfigurationURL:this.getJsonConfigurationURL(),mode:this.getMode()}});this.setComponent(this._oComponent,true);}if(C.prototype.onBeforeRendering){C.prototype.onBeforeRendering.call(this);}},
getObjectPageLayoutInstance:function(){var o=null;if(this._oComponent&&this._oComponent._oView){o=this._oComponent._oView.byId("ObjectPageLayout");}else{L.error("ObjectPageComponentContainer :: cannot find children ObjectPageLayout, has it been rendered already?");}return o;},
renderer:"sap.ui.core.ComponentContainerRenderer"
});
return O;});
sap.ui.predefine('sap/uxap/component/ObjectPageLayoutUXDrivenFactory.controller',["jquery.sap.global","sap/ui/model/BindingMode","sap/ui/model/Context","sap/ui/base/ManagedObject","sap/ui/core/mvc/Controller","sap/base/Log","sap/base/util/ObjectPath","sap/ui/thirdparty/jquery"],function(q,B,C,M,a,L,O,Q){"use strict";return a.extend("sap.uxap.component.ObjectPageLayoutUXDrivenFactory",{connectToComponent:function(m){var h=Q.isEmptyObject(m.getData());m.setDefaultBindingMode(B.OneWay);var H=Q.proxy(function(){if(h){m.detachRequestCompleted(H);}var o=new C(m,"/headerTitle"),b=this.getView().byId("ObjectPageLayout");if(o.getProperty("")){try{this._oHeader=this.controlFactory(b.getId(),o);b.setHeaderTitle(this._oHeader);}catch(e){L.error("ObjectPageLayoutFactory :: error in header creation from config: "+e);}}},this);if(h){m.attachRequestCompleted(H);}else{H();}},controlFactory:function(p,b){var c=b.getProperty(""),o,d,e;try{d=sap.ui.requireSync(c.Type.replace(/\./g,"/"));e=d.getMetadata();Q.each(e._mAllEvents,Q.proxy(function(s,f){if(typeof c[s]=="string"){c[s]=this.convertEventHandler(c[s]);}},this));o=M.create(c);Q.each(e._mAllProperties,Q.proxy(function(P,f){if(c[P]){o.bindProperty(P,"objectPageLayoutMetadata>"+b.getPath()+"/"+P);}},this));}catch(E){L.error("ObjectPageLayoutFactory :: error in control creation from config: "+E);}return o;},convertEventHandler:function(s){var n=window,N=s.split('.');try{Q.each(N,function(i,b){n=n[b];});}catch(e){L.error("ObjectPageLayoutFactory :: undefined event handler: "+s+". Did you forget to require its static class?");n=undefined;}return n;}});});
sap.ui.predefine('sap/uxap/flexibility/ObjectPageDynamicHeaderTitle.flexibility',["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton","sap/f/changeHandler/MoveDynamicPageTitleActions"],function(C,S,M){"use strict";return{"hideControl":"default","unhideControl":"default","combineButtons":{"changeHandler":C,"layers":{"CUSTOMER":false}},"splitMenuButton":{"changeHandler":S,"layers":{"CUSTOMER":false}},"moveActions":{"changeHandler":M},"moveControls":"default"};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageHeader.flexibility',["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton"],function(C,S){"use strict";return{"combineButtons":{"changeHandler":C,"layers":{"CUSTOMER":false}},"moveControls":"default","splitMenuButton":{"changeHandler":S,"layers":{"CUSTOMER":false}}};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageHeaderActionButton.flexibility',["sap/ui/fl/changeHandler/BaseRename"],function(B){"use strict";return{"hideControl":"default","rename":B.createRenameChangeHandler({propertyName:"text",translationTextType:"XBUT"}),"unhideControl":"default"};});
sap.ui.predefine('sap/uxap/flexibility/ObjectPageLayout.flexibility',['sap/uxap/changeHandler/MoveObjectPageSection','sap/uxap/changeHandler/AddIFrameObjectPageLayout'],function(M,A){"use strict";return{"moveControls":{"changeHandler":M,"layers":{"USER":true}},"addIFrame":{"changeHandler":A}};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageSection.flexibility',['sap/uxap/changeHandler/RenameObjectPageSection'],function(R){"use strict";return{"rename":R,"moveControls":"default","hideControl":{"changeHandler":"default","layers":{"USER":true}},"unhideControl":{"changeHandler":"default","layers":{"USER":true}},"stashControl":{"changeHandler":"default","layers":{"USER":true}},"unstashControl":{"changeHandler":"default","layers":{"USER":true}}};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageSubSection.flexibility',["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton","sap/ui/fl/changeHandler/BaseRename"],function(C,S,B){"use strict";return{"hideControl":"default","unhideControl":"default","rename":B.createRenameChangeHandler({propertyName:"title",translationTextType:"XGRP"}),"combineButtons":{"changeHandler":C,"layers":{"CUSTOMER":false}},"moveControls":"default","splitMenuButton":{"changeHandler":S,"layers":{"CUSTOMER":false}}};},true);
sap.ui.predefine('sap/uxap/library',["sap/ui/core/Core","sap/ui/base/DataType","sap/ui/Device","sap/ui/core/library","sap/f/library","sap/m/library","sap/ui/layout/library"],function(C,D,a){"use strict";sap.ui.getCore().initLibrary({name:"sap.uxap",dependencies:["sap.ui.core","sap.f","sap.m","sap.ui.layout"],designtime:"sap/uxap/designtime/library.designtime",types:["sap.uxap.BlockBaseColumnLayout","sap.uxap.BlockBaseFormAdjustment","sap.uxap.Importance","sap.uxap.ObjectPageConfigurationMode","sap.uxap.ObjectPageHeaderDesign","sap.uxap.ObjectPageHeaderPictureShape","sap.uxap.ObjectPageSubSectionLayout","sap.uxap.ObjectPageSubSectionMode"],interfaces:["sap.uxap.IHeaderTitle","sap.uxap.IHeaderContent"],controls:["sap.uxap.AnchorBar","sap.uxap.BlockBase","sap.uxap.BreadCrumbs","sap.uxap.HierarchicalSelect","sap.uxap.ObjectPageHeader","sap.uxap.ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageDynamicHeaderContent","sap.uxap.ObjectPageHeaderActionButton","sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageLayout","sap.uxap.ObjectPageSection","sap.uxap.ObjectPageSectionBase","sap.uxap.ObjectPageSubSection"],elements:["sap.uxap.ModelMapping","sap.uxap.ObjectPageAccessibleLandmarkInfo","sap.uxap.ObjectPageHeaderLayoutData","sap.uxap.ObjectPageLazyLoader"],version:"1.96.3",extensions:{flChangeHandlers:{"sap.uxap.ObjectPageHeader":"sap/uxap/flexibility/ObjectPageHeader","sap.uxap.ObjectPageLayout":"sap/uxap/flexibility/ObjectPageLayout","sap.uxap.ObjectPageSection":"sap/uxap/flexibility/ObjectPageSection","sap.uxap.ObjectPageSubSection":"sap/uxap/flexibility/ObjectPageSubSection","sap.uxap.ObjectPageDynamicHeaderTitle":"sap/uxap/flexibility/ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageHeaderActionButton":"sap/uxap/flexibility/ObjectPageHeaderActionButton","sap.ui.core._StashedControl":{"unstashControl":{"changeHandler":"default","layers":{"USER":true}},"stashControl":{"changeHandler":"default","layers":{"USER":true}}}},"sap.ui.support":{publicRules:true}}});sap.uxap.BlockBaseColumnLayout=D.createType('sap.uxap.BlockBaseColumnLayout',{isValid:function(v){return/^(auto|[1-4]{1})$/.test(v);}},D.getType('string'));sap.uxap.BlockBaseFormAdjustment={BlockColumns:"BlockColumns",OneColumn:"OneColumn",None:"None"};sap.uxap.ObjectPageConfigurationMode={JsonURL:"JsonURL",JsonModel:"JsonModel"};sap.uxap.ObjectPageHeaderDesign={Light:"Light",Dark:"Dark"};sap.uxap.ObjectPageHeaderPictureShape={Circle:"Circle",Square:"Square"};sap.uxap.ObjectPageSubSectionLayout={TitleOnTop:"TitleOnTop",TitleOnLeft:"TitleOnLeft"};sap.uxap.ObjectPageSubSectionMode={Collapsed:"Collapsed",Expanded:"Expanded"};sap.uxap.Importance={Low:"Low",Medium:"Medium",High:"High"};sap.uxap.Utilities={getClosestOPL:function(c){while(c&&!(c instanceof sap.uxap.ObjectPageLayout)){c=c.getParent();}return c;},isPhoneScenario:function(r){if(a.system.phone){return true;}return sap.uxap.Utilities._isCurrentMediaSize("Phone",r);},isTabletScenario:function(r){return sap.uxap.Utilities._isCurrentMediaSize("Tablet",r);},_isCurrentMediaSize:function(m,r){return r&&r.name===m;},getChildPosition:function(e,c){var E=e instanceof jQuery?e:jQuery(e),$=c instanceof jQuery?c:jQuery(c),b=jQuery(document.documentElement),o=E.position(),O=E.offsetParent(),A;while(!O.is($)&&!O.is(b)){A=O.position();o.top+=A.top;o.left+=A.left;O=O.offsetParent();}return o;}};return sap.uxap;});
sap.ui.require.preload({
	"sap/uxap/component/ObjectPageLayoutUXDrivenFactory.view.xml":'<mvc:View xmlns:mvc="sap.ui.core.mvc" xmlns="sap.uxap" height="100%" controllerName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory"><ObjectPageLayout id="ObjectPageLayout" subSectionLayout="{objectPageLayoutMetadata&gt;/subSectionLayout}" showAnchorBar="{objectPageLayoutMetadata&gt;/showAnchorBar}" height="{objectPageLayoutMetadata&gt;/height}" enableLazyLoading="{objectPageLayoutMetadata&gt;/enableLazyLoading}" sections="{objectPageLayoutMetadata&gt;/sections}" headerContent="{path:\'objectPageLayoutMetadata&gt;/headerContent\',factory:\'.controlFactory\'}" showAnchorBarPopover="{objectPageLayoutMetadata&gt;/showAnchorBarPopover}" upperCaseAnchorBar="{objectPageLayoutMetadata&gt;/upperCaseAnchorBar}" useIconTabBar="{objectPageLayoutMetadata&gt;/useIconTabBar}" showHeaderContent="{objectPageLayoutMetadata&gt;/showHeaderContent}" useTwoColumnsForLargeScreen="{objectPageLayoutMetadata&gt;/useTwoColumnsForLargeScreen}" showTitleInHeaderContent="{objectPageLayoutMetadata&gt;/showTitleInHeaderContent}" showOnlyHighImportance="{objectPageLayoutMetadata&gt;/showOnlyHighImportance}" isChildPage="{objectPageLayoutMetadata&gt;/isChildPage}" alwaysShowContentHeader="{objectPageLayoutMetadata&gt;/alwaysShowContentHeader}" showEditHeaderButton="{objectPageLayoutMetadata&gt;/showEditHeaderButton}"><sections><ObjectPageSection id="ObjectPageSection" title="{objectPageLayoutMetadata&gt;title}" importance="{objectPageLayoutMetadata&gt;importance}" showTitle="{objectPageLayoutMetadata&gt;showTitle}" subSections="{objectPageLayoutMetadata&gt;subSections}" visible="{objectPageLayoutMetadata&gt;visible}"><subSections><ObjectPageSubSection id="ObjectPageSubSection" title="{objectPageLayoutMetadata&gt;title}" visible="{objectPageLayoutMetadata&gt;visible}" mode="{objectPageLayoutMetadata&gt;mode}" importance="{objectPageLayoutMetadata&gt;importance}" actions="{path:\'objectPageLayoutMetadata&gt;actions\',factory:\'.controlFactory\'}" blocks="{path:\'objectPageLayoutMetadata&gt;blocks\',factory:\'.controlFactory\'}" moreBlocks="{path:\'objectPageLayoutMetadata&gt;moreBlocks\',factory:\'.controlFactory\'}"/></subSections></ObjectPageSection></sections></ObjectPageLayout></mvc:View>',
	"sap/uxap/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.uxap","type":"library","embeds":[],"applicationVersion":{"version":"1.96.3"},"title":"SAP UxAP","description":"SAP UxAP","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.96","libs":{"sap.ui.core":{"minVersion":"1.96.3"},"sap.m":{"minVersion":"1.96.3"},"sap.ui.layout":{"minVersion":"1.96.3"},"sap.f":{"minVersion":"1.96.3","lazy":true}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.uxap.AnchorBar","sap.uxap.BlockBase","sap.uxap.BreadCrumbs","sap.uxap.HierarchicalSelect","sap.uxap.ObjectPageHeader","sap.uxap.ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageDynamicHeaderContent","sap.uxap.ObjectPageHeaderActionButton","sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageLayout","sap.uxap.ObjectPageSection","sap.uxap.ObjectPageSectionBase","sap.uxap.ObjectPageSubSection"],"elements":["sap.uxap.ModelMapping","sap.uxap.ObjectPageAccessibleLandmarkInfo","sap.uxap.ObjectPageHeaderLayoutData","sap.uxap.ObjectPageLazyLoader"],"types":["sap.uxap.BlockBaseColumnLayout","sap.uxap.BlockBaseFormAdjustment","sap.uxap.Importance","sap.uxap.ObjectPageConfigurationMode","sap.uxap.ObjectPageHeaderDesign","sap.uxap.ObjectPageHeaderPictureShape","sap.uxap.ObjectPageSubSectionLayout","sap.uxap.ObjectPageSubSectionMode"],"interfaces":["sap.uxap.IHeaderTitle","sap.uxap.IHeaderContent"]}}}}'
},"sap/uxap/library-preload"
);
//# sourceMappingURL=library-preload.js.map