/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./GridContainerRenderer","./GridContainerSettings","./GridContainerUtils","./GridNavigationMatrix","./delegate/GridContainerItemNavigation","./library","./dnd/GridKeyboardDragAndDrop","sap/base/strings/capitalize","sap/ui/base/ManagedObjectObserver","sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/ResizeHandler","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(G,a,b,c,d,l,e,f,M,C,g,R,D,K,q){"use strict";var o={"sap.f.Card":function(m){return m.getCardHeader()||m.getCardContent();},"sap.ui.integration.widgets.Card":function(m){return m.getCardHeader()||m.getCardContent();},"sap.m.GenericTile":function(){return true;}};function h(m){var n=m.getLayoutData();return n?n.getColumns():1;}function i(m){var n=m.getLayoutData();return n?n.getActualRows():1;}function j(m){var n=m.getLayoutData();return n?n.hasAutoHeight():true;}var k=C.extend("sap.f.GridContainer",{metadata:{library:"sap.f",interfaces:["sap.f.dnd.IGridDroppable"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:""},minHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"2rem"},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false},snapToRow:{type:"boolean",group:"Appearance",defaultValue:false},allowDenseFill:{type:"boolean",group:"Appearance",defaultValue:false},inlineBlockLayout:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Control",multiple:true,singularName:"item",dnd:true},layout:{type:"sap.f.GridContainerSettings",multiple:false},layoutXS:{type:"sap.f.GridContainerSettings",multiple:false},layoutS:{type:"sap.f.GridContainerSettings",multiple:false},layoutM:{type:"sap.f.GridContainerSettings",multiple:false},layoutL:{type:"sap.f.GridContainerSettings",multiple:false},layoutXL:{type:"sap.f.GridContainerSettings",multiple:false},_defaultLayout:{type:"sap.f.GridContainerSettings",multiple:false,visibility:"hidden"}},events:{layoutChange:{parameters:{layout:{type:"string"}}},columnsChange:{parameters:{columns:{type:"int"}}},borderReached:{parameters:{event:{type:"jQuery.Event"},direction:{type:"sap.f.NavigationDirection"},row:{type:"int"},column:{type:"int"}}}},dnd:{draggable:false,droppable:true}}});k.prototype.bUseExtendedChangeDetection=true;k.prototype.getActiveLayoutSettings=function(){var s=this.getAggregation(this._sActiveLayout);if(!s&&this._sActiveLayout==="layoutXS"){s=this.getAggregation("layoutS");}if(!s){s=this.getAggregation("layout")||this.getAggregation("_defaultLayout");}return s;};k.prototype._onBeforeItemRendering=function(){var m=this.getParent();if(m._resizeListeners[this.getId()]){R.deregister(m._resizeListeners[this.getId()]);delete m._resizeListeners[this.getId()];}m._reflectItemVisibilityToWrapper(this);};k.prototype._onAfterItemRendering=function(){var m=this.getParent();m._checkOwnVisualFocus(this);m._resizeListeners[this.getId()]=R.register(this,m._resizeItemHandler);m._setItemNavigationItems();m._applyItemAutoRows(this);if(this.getAriaRoleDescription){var L=this.getDomRef().parentElement,A=this.getAriaRoleDescription();if(L.classList.contains("sapFGridContainerItemWrapper")){if(A){L.setAttribute("aria-roledescription",A);}else{L.removeAttribute("aria-roledescription");}}}};k.prototype._reflectItemVisibilityToWrapper=function(I){var m=b.getItemWrapper(I),$;if(!m){return;}$=q(m);if(I.getVisible()&&$.hasClass("sapFGridContainerInvisiblePlaceholder")){$.removeClass("sapFGridContainerInvisiblePlaceholder");}else if(!I.getVisible()&&!$.hasClass("sapFGridContainerInvisiblePlaceholder")){$.addClass("sapFGridContainerInvisiblePlaceholder");}};k.prototype._onItemChange=function(m){if(m.name!=="items"||!m.child){return;}if(m.mutation==="insert"){m.child.addEventDelegate(this._itemDelegate,m.child);}else if(m.mutation==="remove"){m.child.removeEventDelegate(this._itemDelegate,m.child);}};k.prototype._deregisterResizeListeners=function(){var m,n;for(m in this._resizeListeners){n=this._resizeListeners[m];R.deregister(n);}delete this._resizeListeners;D.resize.detachHandler(this._resizeDeviceHandler);};k.prototype._setItemNavigationItems=function(){if(!this._isRenderingFinished){return;}var t=this,w=[];if(!t._oItemNavigation){t._oItemNavigation=new d().setCycling(false).setDisabledModifiers({sapnext:["alt","meta","ctrl"],sapprevious:["alt","meta","ctrl"]}).setFocusedIndex(0);t.addDelegate(this._oItemNavigation);}t.$().children().map(function(I,W){if(W.getAttribute("class").indexOf("sapFGridContainerItemWrapper")>-1){w.push(W);}});t._oItemNavigation.setRootDomRef(t.getDomRef());t._oItemNavigation.setItemDomRefs(w);};k.prototype._detectActiveLayout=function(){var w=(this.getContainerQuery()&&this.getDomRef())?this._getComputedWidth():D.resize.width,r=D.media.getCurrentRange("GridContainerRangeSet",w),L="layout"+r.name,O=this.getActiveLayoutSettings(),s=false;if(!w){return false;}if(this._sActiveLayout!==L){this.addStyleClass("sapFGridContainer"+f(L));if(this._sActiveLayout){this.removeStyleClass("sapFGridContainer"+f(this._sActiveLayout));}this._sActiveLayout=L;s=O!==this.getActiveLayoutSettings();this.fireLayoutChange({layout:this._sActiveLayout});}return s;};k.prototype._detectColumnsChange=function(){var s=this.getActiveLayoutSettings(),w=this.$().innerWidth(),m;if(!s){return;}m=s.getComputedColumnsCount(w);if(this._iColumns!==m){this.fireColumnsChange({columns:m});this._iColumns=m;}};k.prototype._getActiveGridStyles=function(){var s=this.getActiveLayoutSettings(),m=s.getColumns()||"auto-fill",n=s.getColumnSize(),p=s.getMinColumnSize(),r=s.getMaxColumnSize(),S={"grid-gap":s.getGap()};if(p&&r){S["grid-template-columns"]="repeat("+m+", minmax("+p+", "+r+"))";}else{S["grid-template-columns"]="repeat("+m+", "+n+")";}if(this.getInlineBlockLayout()){S["grid-auto-rows"]="min-content";}else{S["grid-auto-rows"]=s.getRowSize();}return S;};k.prototype.init=function(){this._oRb=g.getLibraryResourceBundle("sap.f");this.setAggregation("_defaultLayout",new a());this._initRangeSet();this._resizeListeners={};this._oItemNavigation=null;this._itemDelegate={onBeforeRendering:this._onBeforeItemRendering,onAfterRendering:this._onAfterItemRendering};this._itemsObserver=new M(this._onItemChange.bind(this));this._itemsObserver.observe(this,{aggregations:["items"]});this._resizeHandler=this._resize.bind(this);this._resizeDeviceHandler=this._resizeDevice.bind(this);D.resize.attachHandler(this._resizeDeviceHandler);this._resizeItemHandler=this._resizeItem.bind(this);};k.prototype.insertItem=function(I,m){this.insertAggregation("items",I,m,true);if(!this.getDomRef()||!I.getVisible()){this.invalidate();return this;}var r=g.createRenderManager(),w=this._createItemWrapper(I),n=this._getItemAt(m+1),p=this.getDomRef();if(n){p.insertBefore(w,b.getItemWrapper(n));}else{p.insertBefore(w,p.lastChild);}r.render(I,w);r.destroy();return this;};k.prototype.removeItem=function(I){var r=this.removeAggregation("items",I,true),m=this.getDomRef(),n=r.getDomRef();if(!m||!n){this.invalidate();return r;}m.removeChild(n.parentElement);return r;};k.prototype.onBeforeRendering=function(){this._detectActiveLayout();var r=this._resizeListeners[this.getId()];if(r){R.deregister(r);}this._isRenderingFinished=false;this._lastGridWidth=null;this._lastViewportWidth=null;};k.prototype.onAfterRendering=function(){this._resizeListeners[this.getId()]=R.register(this.getDomRef(),this._resizeHandler);this._isRenderingFinished=true;this._setItemNavigationItems();this._applyLayout(true);if(this.getItems().length===1&&this._forceFocus){this.focusItem(0);this._forceFocus=false;}};k.prototype.exit=function(){this._deregisterResizeListeners();if(this._itemsObserver){this._itemsObserver.disconnect();delete this._itemsObserver;}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;this._oItemNavigation=null;}this._forceFocus=null;if(this._checkColumnsTimeout){clearTimeout(this._checkColumnsTimeout);this._checkColumnsTimeout=null;}};k.prototype._initRangeSet=function(){if(!D.media.hasRangeSet("GridContainerRangeSet")){D.media.initRangeSet("GridContainerRangeSet",[375,600,1024,1440],"px",["XS","S","M","L","XL"]);}};k.prototype._resize=function(){if(!this._isWidthChanged()){return;}var s=this._detectActiveLayout();this._applyLayout(s);};k.prototype._resizeDevice=function(){if(!this.getContainerQuery()){this._resize();}};k.prototype._isWidthChanged=function(){var m=this._getComputedWidth(),v=D.resize.width;if(this._lastGridWidth===m&&this._lastViewportWidth===v){return false;}this._lastGridWidth=m;this._lastViewportWidth=v;return true;};k.prototype._getComputedWidth=function(){if(!this.getDomRef()){return null;}return this.getDomRef().getBoundingClientRect().width;};k.prototype._resizeItem=function(E){this._applyItemAutoRows(E.control);};k.prototype._applyLayout=function(s){if(!this._isRenderingFinished){return;}if(s){this.$().css(this._getActiveGridStyles());this.getItems().forEach(this._applyItemAutoRows.bind(this));}this._checkColumns();};k.prototype._checkColumns=function(){if(this._checkColumnsTimeout){clearTimeout(this._checkColumnsTimeout);this._checkColumnsTimeout=null;}this._checkColumnsTimeout=setTimeout(function(){this._detectColumnsChange();this._enforceMaxColumns();}.bind(this),0);};k.prototype._applyItemAutoRows=function(I){if(!this._isRenderingFinished){return;}if(this.getInlineBlockLayout()){return;}if(j(I)){var $=I.$(),s=this.getActiveLayoutSettings(),H=I.getDomRef()?I.getDomRef().getBoundingClientRect().height:0,r=s.calculateRowsForItem(Math.round(H));if(!r){return;}$.parent().css({'grid-row':'span '+Math.max(r,i(I))});}};k.prototype._enforceMaxColumns=function(){var s=this.getActiveLayoutSettings(),m;if(!s){return;}m=s.getComputedColumnsCount(this.$().innerWidth());if(!m){return;}this.getItems().forEach(function(I){I.$().parent().css("grid-column","span "+Math.min(h(I),m));});};k.prototype._getItemAt=function(I){var m=this.getItems(),t;if(I<0){I=0;}if(m.length&&m[I]){t=m[I];}return t;};k.prototype._createItemWrapper=function(I){var s=G.getStylesForItemWrapper(I,this),S=s.styles,m=s.classes,w=document.createElement("div");w.setAttribute("tabindex","0");S.forEach(function(v,n){w.style.setProperty(n,v);});m.forEach(function(v){w.classList.add(v);});return w;};k.prototype.onItemNavigationBorderReached=function(p){this.fireEvent("borderReached",p);};["onkeypress","onkeyup","onkeydown","onsapenter","onsapselect","onsapspace"].forEach(function(n){k.prototype[n]=function(E){if(!this._isItemWrapper(E.target)){return;}if(n==="onsapspace"){E.preventDefault();}var I=q(E.target.firstChild).control()[0];if(I){var F=I.getFocusDomRef(),m=q(F).control()[0];if(m&&m[n]){m[n].call(m,E);}}};});k.prototype._checkOwnVisualFocus=function(m){var n=m.getMetadata().getName(),F;if(o[n]&&o[n](m)){F=m.getFocusDomRef();F.setAttribute("tabindex",-1);F.tabIndex=-1;b.getItemWrapper(m).classList.add("sapFGridContainerItemWrapperNoVisualFocus");}};k.prototype._moveItem=function(E){if(!this._isItemWrapper(E.target)){return;}var I=q(E.target.firstElementChild).control(0),L=this.getItems().length,m=this.indexOfItem(I),n=-1,p,r=[];switch(E.keyCode){case K.ARROW_RIGHT:n=g.getConfiguration().getRTL()?m-1:m+1;if(n>=0&&n<L){p=b.createConfig(this,this.getItems()[n]);p.dropPosition="After";r=[p];}break;case K.ARROW_LEFT:n=g.getConfiguration().getRTL()?m+1:m-1;if(n>=0&&n<L){p=b.createConfig(this,this.getItems()[n]);p.dropPosition="Before";r=[p];}break;case K.ARROW_UP:r=b.findDropTargetsAbove(this,I);r.forEach(function(p){p.dropPosition="Before";});break;case K.ARROW_DOWN:r=b.findDropTargetsBelow(this,I);r.forEach(function(p){p.dropPosition=(this.indexOfItem(p.item)!==-1)?"After":"Before";}.bind(this));break;default:break;}E.stopPropagation();e.fireDnD(I,r,E);this._setItemNavigationItems();};k.prototype.onsapincreasemodifiers=k.prototype._moveItem;k.prototype.onsapdecreasemodifiers=k.prototype._moveItem;k.prototype.focusItem=function(I){var m,n=this._oItemNavigation;this._forceFocus=true;this._setItemNavigationItems();m=n.getItemDomRefs();if(m[I]){n.setFocusedIndex(I);m[I].focus();}};k.prototype.focusItemByDirection=function(s,r,m){this._oItemNavigation.focusItemByDirection(this,s,r,m);};k.prototype.getNavigationMatrix=function(){if(!g.isThemeApplied()){return null;}var m=window.getComputedStyle(this.getDomRef()),n=m.gridTemplateRows.split(/\s+/),p=m.gridTemplateColumns.split(/\s+/),L=this.getActiveLayoutSettings();var I=this.getItems().reduce(function(A,r){if(r.getVisible()){A.push(b.getItemWrapper(r));}return A;},[]);return c.create(this.getDomRef(),I,{gap:L.getGapInPx(),rows:n,columns:p});};k.prototype._isItemWrapper=function(E){return E.classList.contains("sapFGridContainerItemWrapper");};return k;});
