/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/library','sap/m/Image','sap/m/Label',"./BusyIndicatorRenderer"],function(l,C,c,I,L,B){"use strict";var T=c.TextDirection;var a=C.extend("sap.m.BusyIndicator",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Data",defaultValue:""},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},customIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},customIconRotationSpeed:{type:"int",group:"Appearance",defaultValue:1000},customIconDensityAware:{type:"boolean",defaultValue:true},customIconWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},customIconHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},size:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"1rem"},design:{type:"string",group:"Appearance",defaultValue:"auto",deprecated:true}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});a.prototype.init=function(){this.setBusyIndicatorDelay(0);};a.prototype.onBeforeRendering=function(){if(this.getCustomIcon()){this.setBusy(false);}else{this.setBusy(true,"busy-area");}if(this._busyLabel){this._busyLabel.setTextDirection(this.getTextDirection());}if(this._iconImage){this._iconImage.setDensityAware(this.getCustomIconDensityAware());this._iconImage.setSrc(this.getCustomIcon());this._iconImage.setWidth(this.getCustomIconWidth());this._iconImage.setHeight(this.getCustomIconHeight());}else if(!this._iconImage&&this.getCustomIcon()){this._createCustomIcon(this.getCustomIcon()).addStyleClass("sapMBsyIndIcon");}if(this._busyLabel){this._busyLabel.setText(this.getText());this._busyLabel.setTextDirection(this.getTextDirection());}else if(!this._busyLabel&&this.getText()){this._createLabel(this.getText());}};a.prototype.onAfterRendering=function(){this._setRotationSpeed();};a.prototype.exit=function(){if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}if(this._busyLabel){this._busyLabel.destroy();this._busyLabel=null;}};a.prototype._createCustomIcon=function(i){this._iconImage=new I(this.getId()+"-icon",{src:i,width:this.getCustomIconWidth(),height:this.getCustomIconHeight(),densityAware:this.getCustomIconDensityAware()});return this._iconImage;};a.prototype._createLabel=function(t){this._busyLabel=new L(this.getId()+"-label",{labelFor:this.getId(),text:t,textAlign:"Center",textDirection:this.getTextDirection()});return this._busyLabel;};a.prototype._setRotationSpeed=function(){if(!this._iconImage){return;}var i=this.getCustomIconRotationSpeed();if(i===this.getMetadata().getProperty("customIconRotationSpeed").getDefaultValue()){return;}i=Math.max(0,i);var $=this._iconImage.$();var r=i+"ms";$.css("animation-duration",r);$.css("display","none");setTimeout(function(){$.css("display","inline");},0);};return a;});
