/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Core","sap/ui/core/Control","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/library","sap/m/MessagePage","./CarouselRenderer","./CarouselLayout","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/events/F6Navigation","sap/ui/thirdparty/jquery","sap/ui/thirdparty/mobify-carousel","sap/ui/core/IconPool"],function(l,C,a,D,R,c,M,b,d,K,L,F,q){"use strict";var B=c.BusyIndicatorSize;var I=l.ImageHelper;var e=l.CarouselArrowsPlacement;var P=l.PlacementType;var f=a.extend("sap.m.Carousel",{metadata:{library:"sap.m",designtime:"sap/m/designtime/Carousel.designtime",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},loop:{type:"boolean",group:"Misc",defaultValue:false},showPageIndicator:{type:"boolean",group:"Appearance",defaultValue:true},pageIndicatorPlacement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:P.Bottom},showBusyIndicator:{type:"boolean",group:"Appearance",defaultValue:true,deprecated:true},arrowsPlacement:{type:"sap.m.CarouselArrowsPlacement",group:"Appearance",defaultValue:e.Content}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"},customLayout:{type:"sap.m.CarouselLayout",multiple:false}},associations:{activePage:{type:"sap.ui.core.Control",multiple:false}},events:{loadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},unloadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},pageChanged:{parameters:{oldActivePageId:{type:"string"},newActivePageId:{type:"string"},activePages:{type:"array"}}},beforePageChanged:{parameters:{activePages:{type:"array"}}}}}});f._INNER_SELECTOR=".sapMCrslInner";f._PAGE_INDICATOR_SELECTOR=".sapMCrslBulleted";f._PAGE_INDICATOR_ARROWS_SELECTOR=".sapMCrslIndicatorArrow";f._CONTROLS=".sapMCrslControls";f._ITEM_SELECTOR=".sapMCrslItem";f._LEFTMOST_CLASS="sapMCrslLeftmost";f._RIGHTMOST_CLASS="sapMCrslRightmost";f._LATERAL_CLASSES="sapMCrslLeftmost sapMCrslRightmost";f._MODIFIERNUMBERFORKEYBOARDHANDLING=10;f._BULLETS_TO_NUMBERS_THRESHOLD=9;f._PREVIOUS_CLASS_ARROW="sapMCrslPrev";f._NEXT_CLASS_ARROW="sapMCrslNext";f.prototype.init=function(){this._fnAdjustAfterResize=function(){var $=this.$().find(f._INNER_SELECTOR);this._oMobifyCarousel.resize($);if(this.getPages().length>1){this._setWidthOfPages(this._getNumberOfItemsToShow());}}.bind(this);this._aOrderOfFocusedElements=[];this._aAllActivePages=[];this._aAllActivePagesIndexes=[];this._onBeforePageChangedRef=this._onBeforePageChanged.bind(this);this._onAfterPageChangedRef=this._onAfterPageChanged.bind(this);this.data("sap-ui-fastnavgroup","true",true);this._oRb=C.getLibraryResourceBundle("sap.m");};f.prototype.exit=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.destroy();delete this._oMobifyCarousel;}if(this._oArrowLeft){this._oArrowLeft.destroy();delete this._oArrowLeft;}if(this._oArrowRight){this._oArrowRight.destroy();delete this._oArrowRight;}if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this.oMessagePage){this.oMessagePage.destroy();this.oMessagePage=null;}this.$().off('afterSlide');this._fnAdjustAfterResize=null;this._$InnerDiv=null;this._aOrderOfFocusedElements=null;this._aAllActivePages=null;this._aAllActivePagesIndexes=null;};f.prototype.ontouchstart=function(E){if(this._oMobifyCarousel){if(E.target instanceof HTMLImageElement){E.preventDefault();}this._oMobifyCarousel.touchstart(E);}};f.prototype.ontouchmove=function(E){if(this._oMobifyCarousel){this._oMobifyCarousel.touchmove(E);}};f.prototype.ontouchend=function(E){if(this._oMobifyCarousel){if(this._oMobifyCarousel.hasActiveTransition()){this._oMobifyCarousel.onTransitionComplete();}this._oMobifyCarousel.touchend(E);}};f.prototype.onBeforeRendering=function(){var A=this.getActivePage();if(!A&&this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true);}if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.$().off('beforeSlide',this._onBeforePageChangedRef);this.$().off('afterSlide',this._onAfterPageChangedRef);return this;};f.prototype._getNumberOfItemsToShow=function(){var p=this.getPages().length,o=this.getCustomLayout(),n=1;if(o&&o.isA("sap.m.CarouselLayout")){n=Math.max(o.getVisiblePagesCount(),1);}if(n>1&&p<n){return p;}return n;};f.prototype.onAfterRendering=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.unbind();setTimeout(function(){if(this._oMobifyCarousel){this._oMobifyCarousel.onTransitionComplete();}}.bind(this),0);}var n=this._getNumberOfItemsToShow();this.$().carousel(undefined,{numberOfItemsToShow:n});this._oMobifyCarousel=this.getDomRef()._carousel;this._oMobifyCarousel.setLoop(this.getLoop());this._oMobifyCarousel.setRTL(C.getConfiguration().getRTL());if(n>1){this._setWidthOfPages(n);}var A=this.getActivePage();if(A){this._updateActivePages(A);var i=this._getPageNumber(A);if(isNaN(i)||i==0){if(this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true);this._adjustHUDVisibility(1);}}else{if(C.isThemeApplied()){this._moveToPage(i+1);}else{C.attachThemeChanged(this._handleThemeLoad,this);}if(this.getParent()&&this.getParent().isA("sap.zen.commons.layout.PositionContainer")){if(this._isCarouselUsedWithCommonsLayout===undefined){setTimeout(this["invalidate"].bind(this),0);this._isCarouselUsedWithCommonsLayout=true;}}}}this.$().on('beforeSlide',this._onBeforePageChangedRef);this.$().on('afterSlide',this._onAfterPageChangedRef);this._$InnerDiv=this.$().find(f._INNER_SELECTOR)[0];this._sResizeListenerId=R.register(this._$InnerDiv,this._fnAdjustAfterResize);var p=this.getParent();while(p){if(p.isA("sap.m.IconTabBar")){var t=this;p.attachExpand(function(E){var g=E.getParameter('expand');if(g&&i>0){t._moveToPage(i+1);}});break;}p=p.getParent();}};f.prototype._onBeforePageChanged=function(E,p,n){if(E.target!==this.getDomRef()){return;}var N=this.getPages()[n-1].getId();this._updateActivePages(N);this.fireBeforePageChanged({activePages:this._aAllActivePagesIndexes});};f.prototype._onAfterPageChanged=function(E,p,n){var h=this.getPages().length>0;if(E.target!==this.getDomRef()){return;}if(h&&n>0){this._changePage(p,n);}};f.prototype._setWidthOfPages=function(n){var $=this.$().find(".sapMCrslItem"),i;if(!$.length){return;}i=this._calculatePagesWidth(n);$.each(function(g,p){p.style.width=i+"%";});};f.prototype._calculatePagesWidth=function(n){var w=this.$().width(),s=this.getDomRef().querySelector(".sapMCrslFluid .sapMCrslItem"),m=parseFloat(window.getComputedStyle(s).marginRight),i=(w-(m*(n-1)))/n,g=(i/w)*100;return g;};f.prototype._handleThemeLoad=function(){var A=this.getActivePage();if(A){var i=this._getPageNumber(A);if(i>0){this._moveToPage(i+1);}}C.detachThemeChanged(this._handleThemeLoad,this);};f.prototype._moveToPage=function(i){this._oMobifyCarousel.changeAnimation('sapMCrslNoTransition');this._oMobifyCarousel.move(i);this._changePage(undefined,i);};f.prototype._changePage=function(o,n){this._adjustHUDVisibility(n);var O=this.getActivePage();if(o){O=this.getPages()[o-1].getId();}var N=this.getPages()[n-1].getId();this.setAssociation("activePage",N,true);var t=this._getPageIndicatorText(n);L.debug("sap.m.Carousel: firing pageChanged event: old page: "+O+", new page: "+N);if(!D.system.desktop){q(document.activeElement).trigger("blur");}if(this._oMobifyCarousel&&this._oMobifyCarousel.getShouldFireEvent()){this.firePageChanged({oldActivePageId:O,newActivePageId:N,activePages:this._aAllActivePagesIndexes});}this.$('slide-number').text(t);};f.prototype._getPageIndicatorText=function(n){return this._oRb.getText("CAROUSEL_PAGE_INDICATOR_TEXT",[n,this.getPages().length-this._getNumberOfItemsToShow()+1]);};f.prototype._adjustHUDVisibility=function(n){var N=this._getNumberOfItemsToShow();if(D.system.desktop&&!this.getLoop()&&this.getPages().length>1){var h=this.$('hud');h.removeClass(f._LATERAL_CLASSES);if(n===1){h.addClass(f._LEFTMOST_CLASS);this._focusCarouselContainer(h,f._PREVIOUS_CLASS_ARROW);}if((n+N-1)===this.getPages().length){h.addClass(f._RIGHTMOST_CLASS);this._focusCarouselContainer(h,f._NEXT_CLASS_ARROW);}}};f.prototype._focusCarouselContainer=function(h,A){if(h.find('.'+A)[0]===document.activeElement){this.focus();}};f.prototype.setActivePage=function(p){var s=null;if(typeof(p)=='string'){s=p;}else if(p instanceof a){s=p.getId();}if(s){if(s===this.getActivePage()){return this;}var i=this._getPageNumber(s);if(!isNaN(i)){if(this._oMobifyCarousel){this._oMobifyCarousel.setShouldFireEvent(true);this._oMobifyCarousel.move(i+1);}}}this.setAssociation("activePage",s,true);return this;};f.prototype._getNavigationArrow=function(s){if(!this["_oArrow"+s]){this["_oArrow"+s]=I.getImageControl(this.getId()+"-arrowScroll"+s,this["_oArrow"+s],this,{src:"sap-icon://slim-arrow-"+s.toLowerCase(),useIconTooltip:false});}return this["_oArrow"+s];};f.prototype._getErrorPage=function(){if(!this.oMessagePage){this.oMessagePage=new M({text:this._oRb.getText("CAROUSEL_ERROR_MESSAGE"),description:"",icon:"sap-icon://document",showHeader:false});}return this.oMessagePage;};f.prototype.previous=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.setShouldFireEvent(true);this._oMobifyCarousel.prev();}else{L.warning("Unable to execute sap.m.Carousel.previous: carousel must be rendered first.");}return this;};f.prototype.next=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.setShouldFireEvent(true);this._oMobifyCarousel.next();}else{L.warning("Unable to execute sap.m.Carousel.next: carousel must be rendered first.");}return this;};f.prototype._getPageNumber=function(p){var i,r;for(i=0;i<this.getPages().length;i++){if(this.getPages()[i].getId()==p){r=i;break;}}return r;};f.prototype.onsaptabprevious=function(E){this._bDirection=false;this._fnOnTabPress(E);};f.prototype.onsaptabnext=function(E){this._bDirection=true;this._fnOnTabPress(E);};f.prototype.onfocusin=function(E){this.saveLastFocusReference(E);this._bDirection=undefined;};f.prototype.onsapskipforward=function(E){E.preventDefault();this._handleGroupNavigation(E,false);};f.prototype.onsapskipback=function(E){E.preventDefault();this._handleGroupNavigation(E,true);};f.prototype.onkeydown=function(E){if(E.keyCode==K.F7){this._handleF7Key(E);return;}if(E.target!=this.getDomRef()){return;}switch(E.keyCode){case 189:case K.NUMPAD_MINUS:this._fnSkipToIndex(E,-1);break;case K.PLUS:case K.NUMPAD_PLUS:this._fnSkipToIndex(E,1);break;}};f.prototype.onsapescape=function(E){var g;if(E.target===this.$()[0]&&this._lastActivePageNumber){g=this._lastActivePageNumber+1;this._oMobifyCarousel.move(g);this._changePage(undefined,g);}};f.prototype.onsapright=function(E){this._fnSkipToIndex(E,1);};f.prototype.onsapup=function(E){this._fnSkipToIndex(E,-1);};f.prototype.onsapleft=function(E){this._fnSkipToIndex(E,-1);};f.prototype.onsapdown=function(E){this._fnSkipToIndex(E,1);};f.prototype.onsaphome=function(E){this._fnSkipToIndex(E,0);};f.prototype.onsapend=function(E){this._fnSkipToIndex(E,this.getPages().length);};f.prototype.onsaprightmodifiers=function(E){if(E.ctrlKey){this._fnSkipToIndex(E,f._MODIFIERNUMBERFORKEYBOARDHANDLING);}};f.prototype.onsapupmodifiers=function(E){if(E.ctrlKey){this._fnSkipToIndex(E,f._MODIFIERNUMBERFORKEYBOARDHANDLING);}};f.prototype.onsappageup=function(E){this._fnSkipToIndex(E,f._MODIFIERNUMBERFORKEYBOARDHANDLING);};f.prototype.onsapleftmodifiers=function(E){if(E.ctrlKey){this._fnSkipToIndex(E,-f._MODIFIERNUMBERFORKEYBOARDHANDLING);}};f.prototype.onsapdownmodifiers=function(E){if(E.ctrlKey){this._fnSkipToIndex(E,-f._MODIFIERNUMBERFORKEYBOARDHANDLING);}};f.prototype.onsappagedown=function(E){this._fnSkipToIndex(E,-f._MODIFIERNUMBERFORKEYBOARDHANDLING);};f.prototype._fnOnTabPress=function(E){if(E.target===this.$()[0]){this._lastActivePageNumber=this._getPageNumber(this.getActivePage());}};f.prototype._handleGroupNavigation=function(E,s){var o=q.Event("keydown");E.preventDefault();this.$().trigger("focus");o.target=E.target;o.key='F6';o.shiftKey=s;F.handleF6GroupNavigation(o);};f.prototype.saveLastFocusReference=function(E){var o=q(E.target).closest(".sapMCrsPage").control(0),s;if(this._bDirection===undefined){return;}if(this._lastFocusablePageElement===undefined){this._lastFocusablePageElement={};}if(o){s=o.getId();this._lastFocusablePageElement[s]=E.target;this._updateFocusedPagesOrder(s);}};f.prototype._getActivePageLastFocusedElement=function(){if(this._lastFocusablePageElement){return this._lastFocusablePageElement[this._getLastFocusedActivePage()];}};f.prototype._updateFocusedPagesOrder=function(s){var i=this._aOrderOfFocusedElements.indexOf(s);if(i>-1){this._aOrderOfFocusedElements.splice(0,0,this._aOrderOfFocusedElements.splice(i,1)[0]);}else{this._aOrderOfFocusedElements.unshift(s);}};f.prototype._updateActivePages=function(n){var N=this._getPageNumber(n),g=this._getNumberOfItemsToShow(),h=N+g,A=this.getPages();if(h>A.length){h=A.length-g;}this._aAllActivePages=[];this._aAllActivePagesIndexes=[];for(var i=N;i<h;i++){this._aAllActivePages.push(A[i].getId());this._aAllActivePagesIndexes.push(i);}};f.prototype._getLastFocusedActivePage=function(){for(var i=0;i<this._aOrderOfFocusedElements.length;i++){var p=this._aOrderOfFocusedElements[i];if(this._aAllActivePages.indexOf(p)>-1){return p;}}return this.getActivePage();};f.prototype._fnSkipToIndex=function(E,n){var g=n;if(E.target!==this.getDomRef()){return;}E.preventDefault();if(this._oMobifyCarousel.hasActiveTransition()){this._oMobifyCarousel.onTransitionComplete();}this._oMobifyCarousel.setShouldFireEvent(true);if(n!==0){g=this._getPageNumber(this.getActivePage())+1+n;}this._oMobifyCarousel.move(g);};f.prototype._handleF7Key=function(E){var A=this._getActivePageLastFocusedElement();if(E.target===this.$()[0]&&A){A.focus();}else{this.$().trigger("focus");}};f.prototype.setShowBusyIndicator=function(){L.warning("sap.m.Carousel: Deprecated function 'setShowBusyIndicator' called. Does nothing.");return this;};f.prototype.getShowBusyIndicator=function(){L.warning("sap.m.Carousel: Deprecated function 'getShowBusyIndicator' called. Does nothing.");return false;};f.prototype.setBusyIndicatorSize=function(s){if(!(s in B)){s=B.Medium;}return a.prototype.setBusyIndicatorSize.call(this,s);};return f;});
