/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Core','sap/ui/core/Element','sap/ui/Device','./ListItemBase','./Button','./ToolbarSeparator','sap/m/OverflowToolbar','sap/m/OverflowToolbarLayoutData','sap/ui/core/IconPool','sap/ui/core/Icon','sap/ui/core/library'],function(l,C,E,D,L,B,T,O,a,I,b,c){'use strict';var P=c.Priority;var d=l.ButtonType;var e=l.OverflowToolbarPriority;var r=C.getLibraryResourceBundle('sap.m'),f=r.getText('NOTIFICATION_LIST_ITEM_CLOSE'),g=r.getText('NOTIFICATION_LIST_GROUP_CLOSE');var N=L.extend('sap.m.NotificationListBase',{metadata:{library:'sap.m',"abstract":true,properties:{priority:{type:'sap.ui.core.Priority',group:'Appearance',defaultValue:P.None},title:{type:'string',group:'Appearance',defaultValue:''},datetime:{type:'string',group:'Appearance',defaultValue:''},showButtons:{type:'boolean',group:'Behavior',defaultValue:true},showCloseButton:{type:'boolean',group:'Behavior',defaultValue:true},authorName:{type:'string',group:'Appearance',defaultValue:''},authorPicture:{type:'sap.ui.core.URI'}},aggregations:{buttons:{type:'sap.m.Button',multiple:true},_closeButton:{type:'sap.m.Button',multiple:false,visibility:"hidden"},_overflowToolbar:{type:'sap.m.OverflowToolbar',multiple:false,visibility:"hidden"},_priorityIcon:{type:'sap.ui.core.Icon',multiple:false,visibility:"hidden"}},events:{close:{}}},renderer:null});N.prototype._activeHandling=function(){};N.prototype.updateSelectedDOM=function(){};N.prototype.getAccessibilityText=function(){return'';};N.prototype.getButtons=function(){var h=this._getCloseButton(),t=this._getToolbarSeparator();return this._getOverflowToolbar().getContent().filter(function(i){return i!==h&&i!==t;},this);};N.prototype.addButton=function(o){var h=this._getOverflowToolbar(),i=h.getContent().length;if(D.system.phone){i-=2;}h.insertContent(o,i);this.invalidate();return this;};N.prototype.insertButton=function(o,i){this._getOverflowToolbar().insertContent(o,i);this.invalidate();return this;};N.prototype.removeButton=function(o){var h=this._getOverflowToolbar().removeContent(o.getId());this.invalidate();return h;};N.prototype.removeAllButtons=function(){var o=this._getOverflowToolbar(),h=this.getButtons();h.forEach(function(i){o.removeContent(i.getId());});this.invalidate();return this;};N.prototype.destroyButtons=function(){var h=this.getButtons();h.forEach(function(i){i.destroy();});this.invalidate();return this;};N.prototype.clone=function(){var h=L.prototype.clone.apply(this,arguments);h.destroyAggregation('_overflowToolbar');var o=this.getAggregation('_overflowToolbar');if(o){h.setAggregation("_overflowToolbar",o.clone(),true);}return h;};N.prototype._getOverflowToolbar=function(){var o=this.getAggregation('_overflowToolbar'),t,h;if(!o){o=new O(this.getId()+'-overflowToolbar',{});this.setAggregation("_overflowToolbar",o,true);if(D.system.phone){h=this._getCloseButton();h.setLayoutData(new a({priority:e.AlwaysOverflow}));t=new T();t.setLayoutData(new a({priority:e.AlwaysOverflow}));o.addContent(t);o.addContent(h);}}return o;};N.prototype._getCloseButton=function(){var h,o,i,j;if(D.system.phone){o=this._getOverflowToolbar();i=o.getContent();if(o&&i.length){j=i.length-1;h=i[j];}}else{h=this.getAggregation("_closeButton");}if(!h){if(D.system.phone){h=new B(this.getId()+'-closeButtonOverflow',{text:this.isA("sap.m.NotificationListItem")?f:g,type:d.Default,press:function(){this.close();}.bind(this)});}else{h=new B(this.getId()+'-closeButtonX',{icon:I.getIconURI('decline'),type:d.Transparent,tooltip:this.isA("sap.m.NotificationListItem")?f:g,press:function(){this.close();}.bind(this)});this.setAggregation("_closeButton",h);}}return h;};N.prototype._getToolbarSeparator=function(){if(!D.system.phone){return null;}var t,o=this._getOverflowToolbar(),h=o.getContent(),i;if(o&&h.length){i=h.length-2;t=h[i];}return t;};N.prototype.exit=function(){};N.prototype._hasActionButtons=function(){return this.getShowButtons()&&this.getButtons().length;};N.prototype._shouldRenderCloseButton=function(){return!D.system.phone&&this.getShowCloseButton();};N.prototype._shouldRenderOverflowToolbar=function(){var h=this._hasActionButtons();if(D.system.phone){return h||this.getShowCloseButton();}return h;};N.prototype.onBeforeRendering=function(){var h=this.getButtons(),j,k;if(D.system.phone){this._updatePhoneButtons();return;}j=h.length>1?e.AlwaysOverflow:e.NeverOverflow;for(var i=0;i<h.length;i++){k=h[i];k.setLayoutData(new a({priority:i===0?j:e.AlwaysOverflow}));}};N.prototype._updatePhoneButtons=function(){var h=this._getCloseButton(),i=this.isA("sap.m.NotificationListGroup"),j=i?g:f,k=i&&this.getCollapsed(),m=!k&&this._hasActionButtons(),s=this.getShowCloseButton(),t=this._getToolbarSeparator(),p;this.getButtons().forEach(function(n){if(m){p=e.AlwaysOverflow;n.removeStyleClass('sapMNLIBHiddenButton');}else{p=e.NeverOverflow;n.addStyleClass('sapMNLIBHiddenButton');}n.setLayoutData(new a({priority:p}));});if(!s){h.setVisible(false);t.setVisible(false);return;}h.setVisible(true);if(m){h.setText(j);h.setTooltip('');h.setType(d.Default);h.setIcon('');h.setLayoutData(new a({priority:e.AlwaysOverflow}));t.setVisible(true);}else{h.setText('');h.setTooltip(j);h.setType(d.Transparent);h.setIcon(I.getIconURI('decline'));h.setLayoutData(new a({priority:e.NeverOverflow}));t.setVisible(false);}};N.prototype.close=function(){var p=this.getParent();this.fireClose();var h=!!this.getParent();if(!h&&p&&p instanceof E){var i={onAfterRendering:function(){p.focus();p.removeEventDelegate(i);}};p.addEventDelegate(i);}};N.prototype._getPriorityIcon=function(){var p=this.getAggregation('_priorityIcon');if(!p){p=new b({src:'sap-icon://message-error',useIconTooltip:false});this.setAggregation("_priorityIcon",p,true);}return p;};return N;});
