/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/m/delegate/DateNavigation','sap/ui/core/Control','sap/ui/base/ManagedObjectObserver','sap/ui/unified/library','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/calendar/DatesRow','sap/ui/unified/calendar/OneMonthDatesRow','sap/ui/unified/calendar/MonthsRow','sap/ui/unified/calendar/TimesRow','sap/ui/unified/DateRange','sap/ui/unified/DateTypeRange','sap/ui/unified/CalendarAppointment','sap/ui/unified/CalendarRow','sap/ui/unified/CalendarRowRenderer','sap/ui/Device','sap/ui/core/Core','sap/ui/core/Element','sap/ui/core/Renderer','sap/ui/core/ResizeHandler','sap/ui/core/InvisibleText','sap/ui/core/Item','sap/ui/core/dnd/DragInfo','sap/ui/core/dnd/DropInfo','sap/ui/core/dnd/DragDropInfo','sap/ui/core/format/DateFormat','sap/m/Select','sap/m/Button','sap/m/OverflowToolbar','sap/m/Toolbar','sap/m/Table','sap/m/Column','sap/m/ColumnListItem','sap/m/ColumnListItemRenderer','sap/m/SegmentedButtonItem','sap/m/StandardListItem','sap/m/StandardListItemRenderer','sap/m/PlanningCalendarHeader','sap/m/PlanningCalendarRow','sap/m/PlanningCalendarRenderer','sap/m/PlanningCalendarView','sap/m/CheckBox','sap/m/library',"sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(D,C,M,u,a,b,c,O,d,T,e,f,g,h,k,l,m,E,R,n,I,o,p,q,r,s,S,B,t,v,w,y,z,A,F,G,H,P,J,K,L,N,Q,U,V,W){"use strict";var X=Q.Sticky;var Y=u.CalendarDayType;var Z=Q.ListMode;var $=Q.ToolbarDesign;var _=Q.PlanningCalendarBuiltInView;var a1=Q.ScreenSize;var b1=u.CalendarAppointmentVisualization;var c1=u.GroupAppointmentsMode;var d1=u.CalendarIntervalType;var e1=u.CalendarAppointmentHeight;var f1=u.CalendarAppointmentRoundWidth;var g1="DragDropConfig";var h1="ResizeConfig";var i1="CreateConfig";var j1="-CLI";var k1=C.extend("sap.m.PlanningCalendar",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},viewKey:{type:"string",group:"Appearance",defaultValue:d1.Hour},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showRowHeaders:{type:"boolean",group:"Appearance",defaultValue:true},noDataText:{type:"string",group:"Misc",defaultValue:null},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:c1.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentHeight:{type:"sap.ui.unified.CalendarAppointmentHeight",group:"Appearance",defaultValue:e1.Regular},appointmentRoundWidth:{type:"sap.ui.unified.CalendarAppointmentRoundWidth",group:"Appearance",defaultValue:f1.None},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:b1.Standard},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:false},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:false},builtInViews:{type:"string[]",group:"Appearance",defaultValue:[]},stickyHeader:{type:"boolean",group:"Appearance",defaultValue:false},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1}},aggregations:{rows:{type:"sap.m.PlanningCalendarRow",multiple:true,singularName:"row"},views:{type:"sap.m.PlanningCalendarView",multiple:true,singularName:"view"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},toolbarContent:{type:"sap.ui.core.Control",multiple:true,singularName:"toolbarContent",forwarding:{getter:"_getHeader",aggregation:"actions"},forwardBinding:true},table:{type:"sap.m.Table",multiple:false,visibility:"hidden"},header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"},row:{type:"sap.m.PlanningCalendarRow"}}},rowSelectionChange:{parameters:{rows:{type:"sap.m.PlanningCalendarRow[]"}}},startDateChange:{},viewChange:{},rowHeaderClick:{parameters:{headerId:{type:"string"},row:{type:"sap.m.PlanningCalendarRow"}}}},designtime:"sap/m/designtime/PlanningCalendar.designtime"},constructor:function(i,j){C.prototype.constructor.apply(this,arguments);if(typeof i!=="string"){j=i;}if(j&&typeof j.customAppointmentsSorterCallback==="function"){this._fnCustomSortedAppointments=j.customAppointmentsSorterCallback;}}});var l1=["_oTimesRow","_oDatesRow","_oMonthsRow","_oWeeksRow","_oOneMonthsRow"],m1={};m1[d1.Day]={sInstanceName:"_oDatesRow",sIdSuffix:"-DatesRow",oClass:c};m1[d1.Week]={sInstanceName:"_oWeeksRow",sIdSuffix:"-WeeksRow",oClass:c};m1[d1.OneMonth]={sInstanceName:"_oOneMonthsRow",sIdSuffix:"-OneMonthsRow",oClass:O};var n1=a1.Desktop;var o1=[_.Hour,_.Day,_.Month,_.Week,_.OneMonth];var p1={PHONE:"600",TABLET:"1024"};var q1={MONTH:"month",MONTH_PICKER:"monthPicker",YEAR_PICKER:"yearPicker",YEAR_RANGE_PICKER:"yearRangePicker"};var r1={onAfterRendering:function(){this.setProperty("_currentPicker",q1.MONTH);this.removeDelegate(r1);}};var s1={onAfterRendering:function(){this.setProperty("_currentPicker",q1.MONTH_PICKER);this.removeDelegate(s1);}};var t1={onAfterRendering:function(){this.setProperty("_currentPicker",q1.YEAR_PICKER);this.removeDelegate(t1);}};var u1=["sap.ui.unified.calendar.TimesRow","sap.ui.unified.calendar.DatesRow","sap.ui.unified.calendar.MonthsRow","sap.ui.unified.calendar.OneMonthDatesRow"];var v1=C.extend("sap.m._PlanningCalendarInternalHeader",{metadata:{aggregations:{"toolbar":{type:"sap.m.Toolbar",multiple:false},"allCheckBox":{type:"sap.m.CheckBox",multiple:false}}},renderer:{apiVersion:2,render:function(i,j){i.openStart("div",j);i.class("sapMPlanCalHead");i.openEnd();var x=j.getToolbar();if(x){i.renderControl(x);}var W1=j.getAllCheckBox();if(W1){i.renderControl(W1);}i.close("div");}}});k1.prototype.init=function(){this._dateNav=new D();this._iBreakPointTablet=l.media._predefinedRangeSets[l.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=l.media._predefinedRangeSets[l.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=l.media._predefinedRangeSets[l.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];if(l.system.phone||W('html').hasClass("sapUiMedia-Std-Phone")){this._iSize=0;this._iSizeScreen=0;}else if((l.system.tablet||W('html').hasClass("sapUiMedia-Std-Tablet"))&&!(l.system.desktop||W('html').hasClass("sapUiMedia-Std-Desktop"))){this._iSize=1;this._iSizeScreen=1;}else{this._iSize=2;this._iSizeScreen=2;}this.addStyleClass("sapMSize"+this._iSize);this.setAggregation("header",this._createHeader());this._attachHeaderEvents();this._oRB=m.getLibraryResourceBundle("sap.m");var i=this.getId();this._oIntervalTypeSelect=this._getHeader()._getOrCreateViewSwitch();this._oIntervalTypeSelect.attachEvent("selectionChange",w1,this);this._oTodayButton=this._getHeader()._getTodayButton();this._oCalendarHeader=new v1(i+"-CalHead",{});this._oCalendarHeader.isRelative=this.isRelative.bind(this);this._oCalendarHeader._getRelativeInfo=this._getRelativeInfo.bind(this);this._oInfoToolbar=new v(i+"-InfoToolbar",{height:"auto",design:$.Transparent,content:[this._oCalendarHeader,this._oTimesRow],ariaLabelledBy:I.getStaticId("sap.m","PC_INTERVAL_TOOLBAR")});var j=new w(i+"-Table",{sticky:[],infoToolbar:this._oInfoToolbar,mode:Z.SingleSelectMaster,columns:[new y({styleClass:"sapMPlanCalRowHead"}),new y({width:"80%",styleClass:"sapMPlanCalAppRow",minScreenWidth:n1,demandPopin:true})],ariaLabelledBy:i+"-Descr"});j.attachEvent("selectionChange",M1,this);j.addDelegate({onBeforeRendering:function(){if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();}},onAfterRendering:function(){this._rowHeaderClickEvent=j.$().find(".sapMPlanCalRowHead > div.sapMLIB").on("click",function(x){var W1=W(x.currentTarget).control(0),X1=I1(W1.getParent()),Y1=W1.getId();this.fireRowHeaderClick({headerId:Y1,row:X1});}.bind(this));this._adjustColumnHeadersTopOffset();}},false,this);j.getStickyFocusOffset=V1.bind(this);this.setAggregation("table",j,true);this.setStartDate(new Date());this._resizeProxy=A1.bind(this);this._fnCustomSortedAppointments=undefined;this.iWidth=0;};k1.prototype.exit=function(){if(this._sResizeListener){n.deregister(this._sResizeListener);this._sResizeListener=undefined;}l.orientation.detachHandler(this._updateStickyHeader,this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}var i=this.getAggregation("table");i.removeAllItems();l1.forEach(function(x){if(this[x]){this[x]._oPlanningCalendar=undefined;this[x].destroy();this[x]=undefined;}},this);if(this._oViews){for(var j in this._oViews){this._oViews[j].destroy();}}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.destroy();}if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();this._rowHeaderClickEvent=null;}};k1.prototype.onBeforeRendering=function(){this._bBeforeRendering=true;this._adjustViewKey();P1.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._updatePickerSelection();this._updateHeaderButtons();l.orientation.detachHandler(this._updateStickyHeader,this);this._bBeforeRendering=undefined;this._toggleStickyClasses();};k1.prototype.attachEvent=function(i,j,x,W1){C.prototype.attachEvent.call(this,i,j,x,W1);if(this.hasListeners("intervalSelect")){l1.forEach(function(X1){if(this[X1]){this[X1]._setAriaRole("button");}},this);}return this;};k1.prototype.detachEvent=function(i,j,x){C.prototype.detachEvent.call(this,i,j,x);if(!this.hasListeners("intervalSelect")){l1.forEach(function(W1){if(this[W1]){this[W1]._setAriaRole("gridcell");}},this);}return this;};k1.prototype._createHeader=function(){var i=new P(this.getId()+"-Header");i._getRelativeInfo=this._getRelativeInfo.bind(this);i.getAggregation("_actionsToolbar").addAriaLabelledBy(I.getStaticId("sap.m","PC_FUNCTIONS_TOOLBAR"));i.getAggregation("_navigationToolbar").addAriaLabelledBy(I.getStaticId("sap.m","PC_INTERVAL_SELECTION_TOOLBAR"));return i;};k1.prototype._attachHeaderEvents=function(){var i=this._getHeader();i.attachEvent("pressPrevious",this._handlePressArrow,this);i.attachEvent("pressToday",this._handleTodayPress,this);i.attachEvent("pressNext",this._handlePressArrow,this);i.attachEvent("dateSelect",this._handleDateSelect,this);return this;};k1.prototype._handlePressArrow=function(i){this._applyArrowsLogic(i.getId()==="pressPrevious");};k1.prototype._applyArrowsLogic=function(i){if(i){this._dateNav.previous();}else{this._dateNav.next();}if(this.getMinDate()&&this._dateNav.getStart().getTime()<=this.getMinDate().getTime()){this._dateNav.setStart(this.getMinDate());this._dateNav.setCurrent(this.getMinDate());}if(this.getMaxDate()&&this._dateNav.getEnd().getTime()>=this.getMaxDate().getTime()){this._dateNav.setStart(this.getMaxDate());this._dateNav.setCurrent(this.getMaxDate());}var j=this._getRowInstanceByViewKey(this.getViewKey());this.setStartDate(this._dateNav.getStart());j.displayDate(this._dateNav.getCurrent());this._updatePickerSelection();this.fireStartDateChange();};k1.prototype._formatPickerText=function(){var i=this._getFirstAndLastRangeDate(),j=a._createLocalDate(i.oStartDate,true),x=a._createLocalDate(i.oEndDate,true),W1=this.getViewKey(),X1=d1[W1]?d1[W1]:this._getView(W1).getIntervalType(),Y1=m.getConfiguration().getRTL(),Z1,$1,_1,a2;switch(X1){case d1.Hour:Z1=s.getDateInstance({format:"yMMMMd"});_1=Z1.format(j);if(j.getDate()!==x.getDate()){a2=Z1.format(x);}break;case d1.Day:case d1.Week:var b2=this._getView(W1).getIntervalLabelFormatter();if(this.isRelative()){var c2=this.calcIntervalOffset(this.getStartDate());var d2=this.calcIntervalOffset(this.getEndDate())-this.calcIntervalOffset(this.getStartDate());_1=b2?b2(c2):c2;a2=b2?b2(c2+d2-1):c2+d2;}else{Z1=s.getDateInstance({format:"yMMMMd"});_1=Z1.format(j);a2=Z1.format(x);}break;case d1.OneMonth:case"OneMonth":Z1=s.getDateInstance({format:"yMMMM"});_1=Z1.format(j);break;case d1.Month:Z1=s.getDateInstance({format:"y"});_1=Z1.format(j);if(j.getFullYear()!==x.getFullYear()){a2=Z1.format(x);}break;default:throw new Error("Unknown IntervalType: "+W1+"; "+this);}if(!Y1){$1=_1;if(a2){$1+=" - "+a2;}}else{if(a2){$1=a2+" - "+_1;}else{$1=_1;}}return $1;};k1.prototype._getFirstAndLastRangeDate=function(){var i=a._createUniversalUTCDate(this.getStartDate(),"Gregorian",true),j=a._createUniversalUTCDate(this._dateNav.getEnd(),"Gregorian",true);return{oStartDate:i,oEndDate:j};};k1.prototype._getHeader=function(){return this.getAggregation("header");};k1.prototype._toggleStickyClasses=function(){this.toggleStyleClass("sapMPCSticky",this.getStickyHeader());return this;};k1.prototype._adjustColumnHeadersTopOffset=function(){var i=this.getStickyHeader(),j=this.getDomRef().querySelector(".sapMListInfoTBarContainer"),x;switch(i){case true:x=this._getHeader().$().outerHeight()+"px";break;default:x="auto";break;}j.style.top=x;return this;};k1.prototype.getEndDate=function(){return this._dateNav.getEnd();};k1.prototype.getVisibleIntervalsCount=function(){var i=this.getViewKey();if((i===d1.OneMonth||i==="OneMonth")&&this._iSize<2){var j=a.getFirstDateOfWeek(this.getStartDate()),x=a.getFirstDateOfWeek(this._dateNav.getEnd()),W1=new Date(x.getTime());W1.setDate(W1.getDate()+6);return((W1.getTime()-j.getTime())/86400000)+1;}else{return this._getIntervals(this._getView(this.getViewKey()));}};k1.prototype._setAriaRole=function(i){if(this.hasListeners("intervalSelect")){i._setAriaRole("button");}else{i._setAriaRole("gridcell");}};k1.prototype._updateTodayButtonState=function(){if(!this._oTodayButton){return;}if(this.isRelative()){this._oTodayButton.setEnabled(false);return;}this._oTodayButton.setEnabled(!this._dateMatchesVisibleRange(new Date(),this.getViewKey()));};k1.prototype._dateMatchesVisibleRange=function(i,j){var x=this._getView(j,!this._bBeforeRendering);if(!x){return false;}var W1=x.getIntervalType(),X1=m1[W1],Y1=X1?this[X1.sInstanceName]:null,Z1=false;if(Y1&&j==="One Month"){return a._isSameMonthAndYear(b.fromLocalJSDate(this.getStartDate()),b.fromLocalJSDate(i));}else if(Y1&&j==="Week"){var $1=Y1.getDays(),_1=b.fromLocalJSDate(i),a2=b.fromLocalJSDate(this.getStartDate()),b2=b.fromLocalJSDate(this.getStartDate());b2.setDate(b2.getDate()+$1);return _1.isSameOrAfter(a2)&&_1.isBefore(b2);}return Z1;};k1.prototype.onAfterRendering=function(i){i.size={width:this.getDomRef().offsetWidth};A1.call(this,i,true);if(!this._sResizeListener){this._sResizeListener=n.register(this,this._resizeProxy);}if(l.system.phone&&this.getStickyHeader()){l.orientation.attachHandler(this._updateStickyHeader,this);}this._updateCurrentTimeVisualization(false);if(this.getHeight()){var j=this.getDomRef().querySelector("table");if(this.getHeight().indexOf("%")>-1){j.style.height=this.getHeight();return;}var x=this.$().height()-this._oInfoToolbar.$().height()+"px";j.style.height=x;}this._adjustColumnHeadersTopOffset();};k1.prototype.onThemeChanged=function(){if(this.getDomRef()){this._adjustColumnHeadersTopOffset();}};k1.prototype.addToolbarContent=function(i){if(i&&i.isA("sap.m.Title")){this._observeHeaderTitleText(i);this._getHeader().setTitle(i.getText());i.setVisible(false);}this.addAggregation("toolbarContent",i);return this;};k1.prototype.insertToolbarContent=function(i,j){if(i&&i.isA("sap.m.Title")){this._observeHeaderTitleText(i);this._getHeader().setTitle(i.getText());i.setVisible(false);}this.insertAggregation("toolbarContent",i,j);return this;};k1.prototype.removeToolbarContent=function(i){var j;if(i&&i.isA("sap.m.Title")){this._getHeader().setTitle("");this._disconnectAndDestroyHeaderObserver();}else{j=this.removeAggregation("toolbarContent",i);}return j;};k1.prototype.removeAllToolbarContent=function(){var i=this.removeAllAggregation("toolbarContent");this._getHeader().setTitle("");this._disconnectAndDestroyHeaderObserver();return i;};k1.prototype.destroyToolbarContent=function(){var i=this.destroyAggregation("toolbarContent");this._getHeader().setTitle("");this._disconnectAndDestroyHeaderObserver();return i;};k1.prototype._getHeaderObserver=function(){if(!this._oHeaderObserver){this._oHeaderObserver=new M(this._handleTitleTextChange.bind(this));}return this._oHeaderObserver;};k1.prototype._observeHeaderTitleText=function(i){this._getHeaderObserver().observe(i,{properties:["text"]});};k1.prototype._handleTitleTextChange=function(i){this._getHeader().setTitle(i.current);};k1.prototype._disconnectAndDestroyHeaderObserver=function(){if(this._oHeaderObserver){this._oHeaderObserver.disconnect();this._oHeaderObserver.destroy();this._oHeaderObserver=null;}};k1.prototype.setStartDate=function(i){var j;if(!i){j=new Date();}else{a._checkJSDateObject(i);j=new Date(i.getTime());}j=this._shiftStartDate(j);if(U(j,this.getStartDate())){this._updateTodayButtonState();return this;}var x=j.getFullYear();a._checkYearInValidRange(x);var W1=this.getMinDate();if(W1&&W1.getTime()>j.getTime()){V.warning("StartDate < minDate -> StartDate set to minDate",this);j=new Date(W1.getTime());}else{var X1=this.getMaxDate();if(X1&&X1.getTime()<j.getTime()){V.warning("StartDate > maxDate -> StartDate set to minDate",this);if(W1){j=new Date(W1.getTime());}else{j=new Date(1,0,1);j.setFullYear(1);}}}this.setProperty("startDate",j,true);this._dateNav.setStart(j);this._dateNav.setCurrent(j);this._getHeader().setStartDate(j);l1.forEach(function(Y1){if(this[Y1]){this[Y1].setStartDate(new Date(j.getTime()));}},this);if((this.getViewKey()===_.OneMonth||this.getViewKey()==="OneMonth")&&this._oOneMonthsRow.getMode()<2&&this._oOneMonthsRow.getSelectedDates().length){this._setRowsStartDate(this._oOneMonthsRow.getSelectedDates()[0].getStartDate());}else{this._setRowsStartDate(new Date(j.getTime()));}if(this.getViewKey()===_.Week||this.getViewKey()===_.OneMonth||this.getViewKey()==="OneMonth"){this._updateTodayButtonState();}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);this._updatePickerSelection();}this._updateHeaderButtons();return this;};k1.prototype.setMinDate=function(i){if(U(i,this.getMinDate())){return this;}var j=this.getMaxDate(),x=this._getHeader();if(i){a._checkJSDateObject(i);var W1=i.getFullYear();a._checkYearInValidRange(W1);this.setProperty("minDate",i,true);this._bNoStartDateChange=true;x.getAggregation("_calendarPicker").setMinDate(new Date(i.getTime()));x.getAggregation("_monthPicker").setMinDate(new Date(i.getTime()));x.getAggregation("_yearPicker").setMinDate(new Date(i.getTime()));if(j&&j.getTime()<i.getTime()){V.warning("minDate > maxDate -> maxDate set to end of the month",this);j=new Date(i.getTime());j.setMonth(j.getMonth()+1,0);j.setHours(23);j.setMinutes(59);j.setSeconds(59);j.setMilliseconds(0);this.setMaxDate(j);}this._bNoStartDateChange=undefined;var X1=this.getStartDate();if(X1&&X1.getTime()<i.getTime()){V.warning("StartDate < minDate -> StartDate set to minDate",this);X1=new Date(i.getTime());this.setStartDate(X1);x.setPickerText(this._formatPickerText());}}else{this.setProperty("minDate",undefined,true);x.getAggregation("_calendarPicker").setMinDate();x.getAggregation("_monthPicker").setMinDate();x.getAggregation("_yearPicker").setMinDate();}var Y1=new Date();if(i&&Y1.getTime()<i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||Y1.getTime()<j.getTime()){this._oTodayButton.setVisible(true);}return this;};k1.prototype.setMaxDate=function(i){if(U(i,this.getMaxDate())){return this;}var j=this.getMinDate(),x=this._getHeader();if(i){a._checkJSDateObject(i);var W1=i.getFullYear();a._checkYearInValidRange(W1);this.setProperty("maxDate",i,true);this._bNoStartDateChange=true;x.getAggregation("_calendarPicker").setMaxDate(new Date(i.getTime()));x.getAggregation("_monthPicker").setMaxDate(new Date(i.getTime()));x.getAggregation("_yearPicker").setMaxDate(new Date(i.getTime()));if(j&&j.getTime()>i.getTime()){V.warning("maxDate < minDate -> maxDate set to begin of the month",this);j=new Date(i.getTime());j.setDate(1);j.setHours(0);j.setMinutes(0);j.setSeconds(0);j.setMilliseconds(0);this.setMinDate(j);}this._bNoStartDateChange=undefined;var X1=this.getStartDate();if(X1&&X1.getTime()>i.getTime()){V.warning("StartDate > maxDate -> StartDate set to minDate",this);if(j){X1=new Date(j.getTime());}else{X1=new Date(1,0,1);X1.setFullYear(1);}this.setStartDate(X1);x.setPickerText(this._formatPickerText());}}else{this.setProperty("maxDate",undefined,true);x.getAggregation("_calendarPicker").setMaxDate();x.getAggregation("_monthPicker").setMaxDate();x.getAggregation("_yearPicker").setMaxDate();}var Y1=new Date();if(i&&Y1.getTime()>i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||Y1.getTime()>j.getTime()){this._oTodayButton.setVisible(true);}return this;};k1.prototype.removeIntervalInstanceFromInfoToolbar=function(){var i=this._oInfoToolbar.getContent();i.forEach(function(j){if(j.isA(u1)){this._oInfoToolbar.removeContent(j);}}.bind(this));};k1.prototype.isRelative=function(){var i=this._getView(this.getViewKey(),true);if(!i){return false;}return i.getRelative();};k1.prototype.setViewKey=function(j){var x,W1,X1,Y1=this.getViewKey(),Z1=this._getHeader(),$1;this.setProperty("viewKey",j,true);this._oIntervalTypeSelect.setSelectedKey(j);this.removeIntervalInstanceFromInfoToolbar();var _1=this.getStartDate();var a2=this.getMinDate();var b2=this.getMaxDate();var c2=this._getView(j,!this._bBeforeRendering);var d2;if(!c2){this._bCheckView=true;this.invalidate();}else{var e2=c2.getIntervalType();var f2=c2.getIntervalSize();var g2=this._getIntervals(c2);this._bCheckView=false;this._dateNav.setUnit(e2);this._dateNav.setStep(g2*f2);this._dateNav.setCurrent(undefined);switch(e2){case d1.Hour:if(!this._oTimesRow){this._oTimesRow=new T(this.getId()+"-TimesRow",{startDate:new Date(_1.getTime()),items:g2,legend:this.getLegend()});this._setAriaRole(this._oTimesRow);this._oTimesRow._setLegendControlOrigin(this);this._oTimesRow.attachEvent("focus",this._handleFocus,this);this._oTimesRow.attachEvent("select",this._handleCalendarSelect,this);this._oTimesRow._oPlanningCalendar=this;this._oTimesRow._getSpecialDates=function(){return this._oPlanningCalendar._getSpecialDates();};this._oTimesRow.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};}else if(this._oTimesRow.getItems()!==g2){this._oTimesRow.setItems(g2);this._dateNav.setStep(g2*f2);}this._insertInterval(this._oTimesRow);d2=Z1.getAggregation("_calendarPicker")?Z1.getAggregation("_calendarPicker"):Z1._oPopup.getContent()[0];d2.addDelegate(r1,d2);Z1.setAssociation("currentPicker",d2);break;case d1.Day:case d1.Week:case d1.OneMonth:case"OneMonth":X1=m1[e2];x=this[X1.sInstanceName];if(!x){x=new X1.oClass(this.getId()+X1.sIdSuffix,{startDate:new Date(_1.getTime()),days:g2,showDayNamesLine:this.getShowDayNamesLine(),legend:this.getLegend(),showWeekNumbers:this.getShowWeekNumbers()});x.isRelative=this.isRelative.bind(this);x._getRelativeInfo=this._getRelativeInfo.bind(this);this._setAriaRole(x);x.attachEvent("select",this._handleCalendarSelect,this);x.attachEvent("focus",this._handleFocus,this);if(j===_.OneMonth||j==="OneMonth"){x._setRowsStartDate=this._setRowsStartDate.bind(this);}x._oPlanningCalendar=this;x._getSpecialDates=function(){return this._oPlanningCalendar._getSpecialDates();};x.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};}else if(x.getDays()!==g2){x.setDays(g2);this._dateNav.setStep(g2*f2);}this._insertInterval(x);this[X1.sInstanceName]=x;if((e2===d1.OneMonth||e2==="OneMonth")){d2=Z1.getAggregation("_monthPicker")?Z1.getAggregation("_monthPicker"):Z1._oPopup.getContent()[0];Z1.setAssociation("currentPicker",d2);d2.addDelegate(s1,d2);}else if(this.isRelative()){var h2=Z1.getAggregation("_indexPicker");d2=h2?h2:Z1._oPopup.getContent()[0];if(h2){var c2=this._getView(j);var i2=Math.round(this.calcIntervalOffset(_1));h2.setFormatter(this._getRelativeInfo().intervalLabelFormatter);h2.setPeriodSize(x.getDays());h2.setSelectedIndex(i2);}else{var c2=this._getView(j);d2.setFormatter(c2.getIntervalLabelFormatter());d2.setPeriodSize(x.getDays());var i2=Math.round(this.calcIntervalOffset(_1));d2.setSelectedIndex(i2);}Z1.setAssociation("currentPicker",d2);}else{d2=Z1.getAggregation("_calendarPicker")?Z1.getAggregation("_calendarPicker"):Z1._oPopup.getContent()[0];Z1.setAssociation("currentPicker",d2);d2.addDelegate(r1,d2);}break;case d1.Month:if(!this._oMonthsRow){this._oMonthsRow=new d(this.getId()+"-MonthsRow",{startDate:new Date(_1.getTime()),months:g2,legend:this.getLegend()});this._setAriaRole(this._oMonthsRow);this._oMonthsRow._setLegendControlOrigin(this);this._oMonthsRow.attachEvent("focus",this._handleFocus,this);this._oMonthsRow.attachEvent("select",this._handleCalendarSelect,this);this._oMonthsRow._oPlanningCalendar=this;this._oMonthsRow._getSpecialDates=function(){return this._oPlanningCalendar._getSpecialDates();};this._oMonthsRow.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};}else if(this._oMonthsRow.setMonths()!==g2){this._oMonthsRow.setMonths(g2);this._dateNav.setStep(g2*f2);}this._insertInterval(this._oMonthsRow);d2=Z1.getAggregation("_yearPicker")?Z1.getAggregation("_yearPicker"):Z1._oPopup.getContent()[0];Z1.setAssociation("currentPicker",d2);d2.addDelegate(t1,d2);break;default:throw new Error("Unknown IntervalType: "+e2+"; "+this);}var j2=this.getAggregation("table").getInfoToolbar().getContent()[1];if(j2.setFirstDayOfWeek){j2.setFirstDayOfWeek(this.getFirstDayOfWeek());}var k2=this.getRows();for(var i=0;i<k2.length;i++){var l2=k2[i];var m2=L1(l2);m2.setIntervalType(e2);m2.setIntervals(g2);m2.setIntervalSize(f2);m2.setShowSubIntervals(c2.getShowSubIntervals());}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);y1.call(this,this.getShowWeekNumbers(),this._viewAllowsWeekNumbers(j));z1.call(this,this.getShowDayNamesLine(),!!x);}this._updatePickerSelection();}if(j===_.Week||j===_.OneMonth||j===_.Month||j==="OneMonth"){W1=this.getStartDate();this.setStartDate(new Date(W1.getTime()));if(W1.getTime()!==this.getStartDate().getTime()){this.fireStartDateChange();}}if(this._oOneMonthsRow&&(j===_.OneMonth||j==="OneMonth")){this._oOneMonthsRow.setMode(this._iSize);this._oOldStartDate=new Date(this.getStartDate().getTime());this._adjustSelectedDate(b.fromLocalJSDate(W1));if(this._iSize<2){this._setRowsStartDate(W1);}}else if(this._oOneMonthsRow&&(Y1===_.OneMonth||Y1==="OneMonth")&&this._oOneMonthsRow.getSelectedDates().length){$1=this._oOneMonthsRow.getSelectedDates()[0].getStartDate();if($1){$1.setHours(this._oOldStartDate.getHours());$1.setMinutes(this._oOldStartDate.getMinutes());$1.setSeconds(this._oOldStartDate.getSeconds());$1.setMilliseconds(this._oOldStartDate.getMilliseconds());this.setStartDate($1);}}if(a2){Z1.getAggregation("_calendarPicker")&&Z1.getAggregation("_calendarPicker").setMinDate(new Date(a2.getTime()));Z1.getAggregation("_yearPicker")&&Z1.getAggregation("_yearPicker").setMinDate(new Date(a2.getTime()));Z1.getAggregation("_monthPicker")&&Z1.getAggregation("_monthPicker").setMinDate(new Date(a2.getTime()));}if(b2){Z1.getAggregation("_calendarPicker")&&Z1.getAggregation("_calendarPicker").setMaxDate(new Date(b2.getTime()));Z1.getAggregation("_yearPicker")&&Z1.getAggregation("_yearPicker").setMaxDate(new Date(b2.getTime()));Z1.getAggregation("_monthPicker")&&Z1.getAggregation("_monthPicker").setMaxDate(new Date(b2.getTime()));}this._updateTodayButtonState();return this;};k1.prototype.setFirstDayOfWeek=function(i){if(i<-1||i>6){V.error(""+i+" is not a valid value to the property firstDayOfWeek. Valid values are from -1 to 6.");return;}var j=this._getHeader().getAssociation("currentPicker"),x=m.byId(j),W1=this.getViewKey(),X1=this._dateNav,Y1=X1.getStart(),Z1=this.getStartDate().getDay(),$1=W1===_.OneMonth&&this._iSize<2,_1=i,a2,b2,c2;x.setFirstDayOfWeek(i);if(W1===_.Week||$1){a2=this.getAggregation("table").getInfoToolbar().getContent()[1];if(i===-1){b2=a.getFirstDateOfWeek(a._createUniversalUTCDate(Y1,undefined,true));c2=a._createLocalDate(b2,true);_1=c2.getDay();}a2.setFirstDayOfWeek(i);if(!$1){Y1.setDate(Y1.getDate()-Z1+_1);a2.setStartDate(Y1);}this.getRows().forEach(function(a2){this._updateRowTimeline(a2);}.bind(this));}return this.setProperty("firstDayOfWeek",i);};k1.prototype._handleFocus=function(i){var j=i.getParameter("date"),x=i.getParameter("restoreOldDate");if(x){return;}this.shiftToDate(j,i.getParameter("otherMonth"));this._addMonthFocusDelegate(this._getRowInstanceByViewKey(this.getViewKey()));};k1.prototype.shiftToDate=function(i,j){var x=this._getRowInstanceByViewKey(this.getViewKey()),W1,X1;this._dateNav.toDate(i);W1=this._dateNav.getStart();X1=this._dateNav.getCurrent();if(this._dateNav.getCurrent()>this._dateNav.getEnd()){W1=new Date(this._dateNav.getStart());W1.setDate(W1.getDate()+1);}if((this.getMaxDate()&&this.getMaxDate()<i)||(this.getMinDate()&&this.getMinDate()>i)){return;}if(j){this.fireStartDateChange();}if(x&&!(x.getMode&&x.getMode()<2&&!j)){this.setStartDate(W1);x.setStartDate(W1);x.setDate(X1);this._addMonthFocusDelegate(x);}};k1.prototype._addMonthFocusDelegate=function(i){var j={onAfterRendering:function(){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());this.removeDelegate(j);}};i.addDelegate(j,i);};k1.prototype._shiftStartDate=function(i){if(this.getViewKey()===_.Week){var j=a.getFirstDateOfWeek(a._createUniversalUTCDate(i,undefined,true)),x=a._createLocalDate(j,true);if(this.getFirstDayOfWeek()>-1){x.setDate(x.getDate()-x.getDay()+this.getFirstDayOfWeek());}if(x.getTime()>i.getTime()){x.setDate(x.getDate()-7);}i.setTime(x.getTime());}if((this.getViewKey()===_.OneMonth||this.getViewKey()===_.Month||this.getViewKey()==="OneMonth")){var W1=a.getFirstDateOfMonth(a._createUniversalUTCDate(i,undefined,true));i.setTime(a._createLocalDate(W1,true).getTime());}return i;};k1.prototype._updatePickerSelection=function(){var i=this._getFirstAndLastRangeDate(),j=this._getHeader().getAssociation("currentPicker"),x=m.byId(j),W1;W1=new e({startDate:a._createLocalDate(i.oStartDate,true),endDate:a._createLocalDate(i.oEndDate,true)});if(this.isRelative()){x.setStartIndex(this.calcIntervalOffset(i.oStartDate));}else{x.destroySelectedDates();x.addSelectedDate(W1);}this._getHeader().setPickerText(this._formatPickerText());this._updateTodayButtonState();};k1.prototype._adjustSelectedDate=function(i){var j=i.toLocalJSDate();if(this._oOneMonthsRow.getMode&&this._oOneMonthsRow.getMode()<2){this._oOneMonthsRow.removeAllSelectedDates();this._oOneMonthsRow.addSelectedDate(new e({startDate:j}));this._oOneMonthsRow.selectDate(j);}};k1.prototype._insertInterval=function(i){if(this._iSizeScreen>1){this._oInfoToolbar.addContent(i);}else{this._oInfoToolbar.insertContent(i,1);}};k1.prototype._viewAllowsWeekNumbers=function(i){var j=this._getView(i).getIntervalType(),x=m1[j];return!!x&&!!x.oClass.prototype.setShowWeekNumbers;};k1.prototype._viewAllowsDayNamesLine=function(i){var j=this._getView(i).getIntervalType(),x=m1[j];return!!x&&!!x.oClass.prototype.setShowDayNamesLine;};k1.prototype._getRowInstanceByViewKey=function(i){var j=this._getView(i).getIntervalType(),x=m1[j],W1;if(x){W1=this[x.sInstanceName];}if(j===d1.Month){W1=this._oMonthsRow;}if(j===d1.Hour){W1=this._oTimesRow;}return W1;};k1.prototype.setShowWeekNumbers=function(i){this.setProperty("showWeekNumbers",i,true);this._getViews().forEach(function(j){var x=j.getKey(),W1=this._viewAllowsWeekNumbers(x),X1=this._getRowInstanceByViewKey(x);if(X1&&W1){X1.setShowWeekNumbers(i);}if(this.getDomRef()&&this.getViewKey()===x){y1.call(this,i,W1);}},this);return this;};k1.prototype.setShowIntervalHeaders=function(j){this.setProperty("showIntervalHeaders",j,true);var x=this.getRows();for(var i=0;i<x.length;i++){var W1=x[i];L1(W1).setShowIntervalHeaders(j);}return this;};k1.prototype.setShowEmptyIntervalHeaders=function(j){this.setProperty("showEmptyIntervalHeaders",j,true);var x=this.getRows();for(var i=0;i<x.length;i++){var W1=x[i];L1(W1).setShowEmptyIntervalHeaders(j);}return this;};k1.prototype.setGroupAppointmentsMode=function(j){this.setProperty("groupAppointmentsMode",j,true);var x=this.getRows();for(var i=0;i<x.length;i++){var W1=x[i];L1(W1).setGroupAppointmentsMode(j);}return this;};k1.prototype.setAppointmentsReducedHeight=function(j){this.setProperty("appointmentsReducedHeight",j,true);var x=this.getRows();for(var i=0;i<x.length;i++){var W1=x[i];L1(W1).setAppointmentsReducedHeight(j);}return this;};k1.prototype.setAppointmentHeight=function(j){var x=this.getRows(),i;this.setProperty("appointmentHeight",j);for(i=0;i<x.length;i++){var W1=x[i];L1(W1).setAppointmentHeight(j);}return this;};k1.prototype.setAppointmentRoundWidth=function(j){var x=this.getRows(),i;this.setProperty("appointmentRoundWidth",j);for(i=0;i<x.length;i++){var W1=x[i];L1(W1).setAppointmentRoundWidth(j);}return this;};k1.prototype.setAppointmentsVisualization=function(j){this.setProperty("appointmentsVisualization",j,true);var x=this.getRows();for(var i=0;i<x.length;i++){var W1=x[i];L1(W1).setAppointmentsVisualization(j);}return this;};k1.prototype.setShowRowHeaders=function(i){this.setProperty("showRowHeaders",i,true);var j=this.getAggregation("table");j.getColumns()[0].setVisible(i);this._toggleAppointmentsColumnPopinState(i);this.$().toggleClass("sapMPlanCalNoHead",!i);T1.call(this);this._setSelectionMode.call(this);return this;};k1.prototype.setShowDayNamesLine=function(i){var j,x,W1,X1=!!this.getDomRef(),Y1=this.getViewKey();for(j in m1){x=m1[j].sInstanceName;if(this[x]){W1=this[x];W1.setShowDayNamesLine(i);if(X1&&j===Y1){z1.call(this,i,true);}}}return this.setProperty("showDayNamesLine",i,false);};k1.prototype.setStickyHeader=function(i){if(this.getStickyHeader()===i){return this;}this.setProperty("stickyHeader",i,true);if(l.system.phone){if(i){l.orientation.attachHandler(this._updateStickyHeader,this);}else{l.orientation.detachHandler(this._updateStickyHeader,this);}}this._updateStickyHeader();return this;};k1.prototype._updateStickyHeader=function(){var i=[],j=this.getStickyHeader(),x=(this.getViewKey()===_.OneMonth||this.getViewKey()==="OneMonth")&&this._iSize<2,W1=j&&!l.system.phone&&!x,X1=j&&!(l.system.phone&&l.orientation.landscape)&&!x;if(W1){i.push(X.HeaderToolbar);}if(this._oInfoToolbar&&X1){i.push(X.InfoToolbar);}this.getAggregation("table").setSticky(i);};k1.prototype._adjustViewKey=function(){if((!this._oTimesRow&&!this._oDatesRow&&!this._oMonthsRow&&!this._oWeeksRow&&!this._oOneMonthsRow)||this._bCheckView){this.setViewKey(this.getViewKey());this._bCheckView=undefined;}};k1.prototype.addView=function(i){this.addAggregation("views",i);if(i.getKey()===this.getViewKey()){this._adjustViewKey();}return this;};k1.prototype.insertView=function(i,j){this.insertAggregation("views",i,j);if(i.getKey()===this.getViewKey()){this._adjustViewKey();}return this;};k1.prototype.addRow=function(i){this.addAggregation("rows",i);this.getAggregation("table").addItem(this._createPlanningCalendarListItem(i));return this;};k1.prototype.insertRow=function(i,j){this.insertAggregation("rows",i,j);this.getAggregation("table").insertItem(this._createPlanningCalendarListItem(i),j,true);return this;};k1.prototype.removeRow=function(i){var j=this.removeAggregation("rows",i,true),x=this.getAggregation("table");x.removeItem(J1(j),true);this._handleRowRemoval(j);S1.call(this);this._setSelectionMode.call(this);return j;};k1.prototype.removeAllRows=function(){var i=this.removeAllAggregation("rows",true),j=this.getAggregation("table");j.removeAllItems(true);i.forEach(this._handleRowRemoval,this);S1.call(this);this._setSelectionMode.call(this);return i;};k1.prototype.destroyRows=function(){var i;var j=this.getAggregation("table");j.destroyItems(true);i=this.destroyAggregation("rows");S1.call(this);this._setSelectionMode.call(this);return i;};k1.prototype.setSingleSelection=function(i){this.setProperty("singleSelection",i,true);T1.call(this);this._setSelectionMode.call(this);if(i){this.selectAllRows(false);}else{S1.call(this);}this.$().toggleClass("sapMPlanCalMultiSel",!i);return this;};k1.prototype.setNoDataText=function(i){this.setProperty("noDataText",i,true);var j=this.getAggregation("table");j.setNoDataText(i);return this;};k1.prototype.setLegend=function(j){this.setAssociation("legend",j,true);var x=this.getRows(),W1=this.getLegend()&&m.byId(this.getLegend()),X1;for(var i=0;i<x.length;i++){var Y1=x[i];L1(Y1).setLegend(j);}l1.forEach(function(Z1){if(this[Z1]){this[Z1].setLegend(j);}},this);if(W1){X1=new M(function(Z1){this.invalidate();}.bind(this));X1.observe(W1,{destroy:true});}return this;};k1.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.addAriaLabelledBy(i);return this;};k1.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.removeAriaLabelledBy(i);return this;};k1.prototype.removeAllAriaLabelledBy=function(){this.removeAllAssociation("ariaLabelledBy",true);var i=this.getAggregation("table");i.removeAllAriaLabelledBy();i.addAriaLabelledBy(this.getId()+"-Descr");return this;};k1.prototype.invalidate=function(i){var j=i&&i instanceof e;if(!this._bIsBeingDestroyed&&(this._bDateRangeChanged||j)){if(this.getDomRef()){var x=this.getViewKey();var W1=this._getView(x);var X1=W1.getIntervalType();switch(X1){case d1.Hour:if(this._oTimesRow){this._oTimesRow.invalidate(arguments);}break;case d1.Day:if(this._oDatesRow){this._oDatesRow.invalidate(arguments);}break;case d1.Month:if(this._oMonthsRow){this._oMonthsRow.invalidate(arguments);}break;case d1.OneMonth:case"OneMonth":if(this._oOneMonthsRow){this._oOneMonthsRow.invalidate(arguments);}break;case d1.Week:if(this._oWeeksRow){this._oWeeksRow.invalidate(arguments);}break;default:throw new Error("Unknown IntervalType: "+X1+"; "+this);}}this._bDateRangeChanged=undefined;}else{if(i&&i instanceof sap.m.PlanningCalendarView){this._bCheckView=true;}C.prototype.invalidate.apply(this,arguments);}};k1.prototype.addSpecialDate=function(i){this._bDateRangeChanged=true;return C.prototype.addAggregation.call(this,"specialDates",i);};k1.prototype.insertSpecialDate=function(i,j){this._bDateRangeChanged=true;return C.prototype.insertAggregation.call(this,"specialDates",i,j);};k1.prototype.removeSpecialDate=function(i){this._bDateRangeChanged=true;return C.prototype.removeAggregation.call(this,"specialDates",i);};k1.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;return this.removeAllAggregation("specialDates");};k1.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;return this.destroyAggregation("specialDates");};k1.prototype.removeAllViews=function(){this._bCheckView=true;var i=this.removeAllAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(o1[0]);}return i;};k1.prototype.destroyViews=function(){this._bCheckView=true;var i=this.destroyAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(o1[0]);}return i;};k1.prototype.getSelectedRows=function(){return this.getRows().filter(function(i){return i.getSelected();});};k1.prototype.selectAllRows=function(j){var x=this.getRows();if(!(j&&this.getSingleSelection())){for(var i=0;i<x.length;i++){var W1=x[i];W1.setSelected(j);}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.setSelected(j);}}return this;};k1.prototype.onsaphomemodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var x=j[0];var W1=new W.Event("saphome");W1._bPlanningCalendar=true;L1(x).onsaphome(W1);i.preventDefault();i.stopPropagation();}};k1.prototype.onsapendmodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var x=j[j.length-1];var W1=new W.Event("sapend");W1._bPlanningCalendar=true;L1(x).onsapend(W1);i.preventDefault();i.stopPropagation();}};k1.prototype.setBuiltInViews=function(i){this.setProperty("builtInViews",i);this.setViewKey(this._getViews()[0].getKey());return this;};k1.prototype.removeView=function(i){var j=this.removeAggregation("views",i);if(!this.getViews().length){this.setViewKey(this._getViews()[0].getKey());}return j;};k1.prototype._getIntervals=function(i){var j=0;switch(this._iSize){case 0:j=i.getIntervalsS();break;case 1:j=i.getIntervalsM();break;default:j=i.getIntervalsL();break;}return j;};k1.prototype._getView=function(j,x){var W1=this._getViews();var X1;for(var i=0;i<W1.length;i++){X1=W1[i];if(X1.getKey()!=j){X1=undefined;}else{break;}}if(!X1&&!x){throw new Error("PlanningCalendarView with key "+j+" not assigned "+this);}return X1;};k1.prototype._changeStartDate=function(i){if(this._bNoStartDateChange){return;}this.setStartDate(new Date(i.getTime()));this._updatePickerSelection();this.fireStartDateChange();};k1.prototype._updateCurrentTimeVisualization=function(j){if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}if(j){var x=this.getRows();for(var i=0;i<x.length;i++){var W1=x[i];L1(W1).updateCurrentTimeVisualization();}}var X1=new Date();var Y1=this.getStartDate();var Z1=this.getViewKey();var $1=this._getView(Z1);var _1=$1.getIntervalType();var a2=this._getIntervals($1);var b2=0;var c2=0;var d2=0;switch(_1){case d1.Hour:b2=60000;c2=Y1.getTime()-3600000;d2=Y1.getTime()+a2*3600000;break;case d1.Day:case d1.Week:case d1.OneMonth:case"OneMonth":b2=1800000;c2=Y1.getTime()-3600000;d2=Y1.getTime()+a2*86400000;break;default:b2=-1;break;}if(X1.getTime()<=d2&&X1.getTime()>=c2&&b2>0){this._sUpdateCurrentTime=setTimeout(this['_updateCurrentTimeVisualization'].bind(this,true),b2);}};function w1(i){this.setViewKey(i.getParameter("item").getKey());this.fireViewChange();}k1.prototype._handleTodayPress=function(i){var j=new Date(),x,W1=this.getViewKey(),X1={onAfterRendering:function(){this._focusDate(b.fromLocalJSDate(new Date()));this.removeDelegate(X1);}};if(W1===_.OneMonth||W1==="OneMonth"){x=a.getFirstDateOfMonth(a._createUniversalUTCDate(j,undefined,true));this._adjustSelectedDate(b.fromLocalJSDate(j));j=a._createLocalDate(x,true);}if(W1===_.Week){x=this.getStartDate();j.setHours(x.getHours());j.setMinutes(x.getMinutes());j.setSeconds(x.getSeconds());}this.setStartDate(j);this._dateNav.setCurrent(j);if(W1===_.Week){this._oWeeksRow.addDelegate(X1,this._oWeeksRow);}else if(W1===_.OneMonth||W1==="OneMonth"){this._oOneMonthsRow.addDelegate(X1,this._oOneMonthsRow);}this._updatePickerSelection();this.fireStartDateChange();};k1.prototype._handleStartDateChange=function(i){var j=i.oSource.getStartDate();if(this._getView(this.getViewKey()).getIntervalType()!==d1.Hour){var x=this.getStartDate();j.setHours(x.getHours());j.setMinutes(x.getMinutes());j.setSeconds(x.getSeconds());}this._changeStartDate(j);};k1.prototype._handleDateSelect=function(i){var j,x=this.getStartDate();if(this.isRelative()){j=new Date(this.getMinDate().getTime());j.setDate(j.getDate()+i.getSource()._oIndexPicker.getSelectedIndex()*this._getView(this.getViewKey()).getIntervalSize());}else{j=i.getSource().getStartDate();}if(this._getView(this.getViewKey()).getIntervalType()===d1.Hour){j.setHours(x.getHours());j.setMinutes(x.getMinutes());j.setSeconds(x.getSeconds());}if(x.getTime()!==j.getTime()){this._changeStartDate(j);this._dateNav.setCurrent(j);var W1=this.getViewKey(),X1=this._getView(W1),Y1=X1.getIntervalType(),Z1;if(Y1==="Hour"){Y1="Time";}else if(Y1==="Day"){Y1="Date";}else if(Y1==="One Month"){Y1="OneMonth";}Z1="_o"+Y1+"sRow";if(this[Z1]){this[Z1].displayDate(j);}}};k1.prototype._handleCalendarSelect=function(i){var j=i.getSource().getSelectedDates();if(!j.length){return;}var x=new Date(j[0].getStartDate());var W1=a._createUniversalUTCDate(x,undefined,true);var X1=this.getViewKey();var Y1=this._getView(X1);var Z1=Y1.getIntervalType();if((Z1!==d1.OneMonth&&Z1!=="OneMonth")||this._iSize>1){j[0].setStartDate();}switch(Z1){case d1.Hour:W1.setUTCHours(W1.getUTCHours()+1);break;case d1.Day:case d1.Week:W1.setUTCDate(W1.getUTCDate()+1);break;case d1.OneMonth:case"OneMonth":if(this._iSize<2){var $1=new Date(x.getTime());if(a.monthsDiffer(this.getStartDate(),x)){this.setStartDate(x);this._getHeader().setPickerText(this._formatPickerText());}this._setRowsStartDate($1);this._oOneMonthsRow._focusDate(b.fromLocalJSDate($1),true);}else if(a._isNextMonth(x,this.getStartDate())){this.shiftToDate(x);this._addMonthFocusDelegate(this._getRowInstanceByViewKey(this.getViewKey()));return;}W1.setUTCDate(W1.getUTCDate()+1);break;case d1.Month:W1.setUTCMonth(W1.getUTCMonth()+1);break;default:throw new Error("Unknown IntervalType: "+Z1+"; "+this);}W1.setUTCMilliseconds(W1.getUTCMilliseconds()-1);W1=a._createLocalDate(W1,true);this._formatPickerText();this.fireIntervalSelect({startDate:x,endDate:W1,subInterval:false,row:undefined});};function x1(i){var j=i.getParameter("startDate");var x=this.getViewKey();var W1=this._getView(x);var X1=W1.getIntervalType();if((X1===d1.OneMonth||X1==="OneMonth")&&a._isNextMonth(j,this.getStartDate())){this.shiftToDate(j);this._addMonthFocusDelegate(this._getRowInstanceByViewKey(this.getViewKey()));return;}var Y1=i.getParameter("endDate");var Z1=i.getParameter("subInterval");var $1=I1(i.oSource.getParent());this._formatPickerText();this.fireIntervalSelect({startDate:j,endDate:Y1,subInterval:Z1,row:$1});}k1.prototype._applyContextualSettings=function(i){return C.prototype._applyContextualSettings.call(this,i);};function y1(i,j){this.$().toggleClass("sapMPlanCalWithWeekNumbers",i&&j);}function z1(i,j){this.$().toggleClass("sapMPlanCalWithDayNamesLine",i&&j);}function A1(j,x){if(j.size.width<=0){return;}if(Math.abs(this.iWidth-j.size.width)<15){return;}this.iWidth=j.size.width;this._applyContextualSettings({contextualWidth:this.iWidth});var W1=this.getRows();var X1;var i=0;var Y1;var Z1=this._iSize;N1.call(this,j.size.width);if(Z1!=this._iSize){O1.call(this,this._iSize);var $1=this.getViewKey();var _1=this._getView($1);var a2=_1.getIntervalType();var b2=_1.getIntervalSize();var c2=this._getIntervals(_1);for(i=0;i<W1.length;i++){X1=W1[i];var d2=L1(X1);if(c2!=d2.getIntervals()){d2.setIntervals(c2);}else{d2.handleResize();}}switch(a2){case d1.Hour:if(this._oTimesRow&&this._oTimesRow.getItems()!=c2){this._oTimesRow.setItems(c2);this._dateNav.setStep(c2*b2);}break;case d1.Day:if(this._oDatesRow&&this._oDatesRow.getDays()!=c2){this._oDatesRow.setDays(c2);this._dateNav.setStep(c2*b2);}break;case d1.Month:if(this._oMonthsRow&&this._oMonthsRow.getMonths()!=c2){this._oMonthsRow.setMonths(c2);this._dateNav.setStep(c2*b2);}break;case d1.Week:if(this._oWeeksRow&&this._oWeeksRow.getDays()!=c2){this._oWeeksRow.setDays(c2);this._dateNav.setStep(c2*b2);}break;case d1.OneMonth:case"OneMonth":if(this._oOneMonthsRow&&this._oOneMonthsRow.getDays()!=c2){this._oOneMonthsRow.setDays(c2);this._dateNav.setStep(c2*b2);if(this._iSize>1){this._setRowsStartDate(new Date(this.getStartDate().getTime()));}}break;default:throw new Error("Unknown IntervalType: "+a2+"; "+this);}T1.call(this);this._updatePickerSelection();}else if(!x){for(i=0;i<W1.length;i++){X1=W1[i];L1(X1).handleResize();}}if(this._oOneMonthsRow&&(this.getViewKey()===d1.OneMonth||this.getViewKey()==="OneMonth")){Y1=(this._getSelectedDates().length&&this._getSelectedDates()[0].getStartDate())?this._getSelectedDates()[0].getStartDate():this.getStartDate();this._oOneMonthsRow.setMode(this._iSize);this._adjustSelectedDate(b.fromLocalJSDate(Y1));}if(this.getStickyHeader()){this._adjustColumnHeadersTopOffset();this._updateStickyHeader();}}function B1(x){var W1=x.getParameter("appointment"),X1=x.getParameter("multiSelect"),Y1=x.getParameter("appointments"),Z1=x.getParameter("domRefId"),$1,_1,a2,b2,c2,i,j;if(!X1){_1=this.getRows();for(i=0;i<_1.length;i++){a2=_1[i];if(x.oSource!=L1(a2)){b2=a2.getAppointments();for(j=0;j<b2.length;j++){c2=b2[j];c2.setSelected(false);}}}}$1={appointment:W1,appointments:Y1,multiSelect:X1,domRefId:Z1};this.fireAppointmentSelect($1);}k1.prototype._setRowsStartDate=function(j){var x=this.getRows(),W1,i;for(i=0;i<x.length;i++){W1=x[i];L1(W1).setStartDate(j);}};k1.prototype._toggleAppointmentsColumnPopinState=function(i){var j=this.getAggregation("table"),x=j.getColumns()[1];x.setDemandPopin(i);x.setMinScreenWidth(i?n1:"");};k1.prototype._getViews=function(){var i=this.getViews(),j=this.getBuiltInViews(),x,W1=[],X1=_,Y1=d1;if(!this._oViews){this._oViews={};}if(j.length){W1=j;}else{W1=i.length?[]:o1;}x=W1.map(function($1){switch($1){case X1.Hour:if(!this._oViews[X1.Hour]){this._oViews[X1.Hour]=new L(this.getId()+"-HourView",{key:X1.Hour,intervalType:Y1.Hour,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_HOURS"),intervalsS:6,intervalsM:6,intervalsL:12});}return this._oViews[X1.Hour];case X1.Day:if(!this._oViews[X1.Day]){this._oViews[X1.Day]=new L(this.getId()+"-DayView",{key:X1.Day,intervalType:Y1.Day,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_DAYS"),intervalsS:7,intervalsM:7,intervalsL:14});}return this._oViews[X1.Day];case X1.Month:if(!this._oViews[X1.Month]){this._oViews[X1.Month]=new L(this.getId()+"-MonthView",{key:X1.Month,intervalType:Y1.Month,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_MONTHS"),intervalsS:3,intervalsM:6,intervalsL:12});}return this._oViews[X1.Month];case X1.Week:if(!this._oViews[X1.Week]){this._oViews[X1.Week]=new L(this.getId()+"-WeekView",{key:X1.Week,intervalType:Y1.Week,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_WEEK"),intervalsS:7,intervalsM:7,intervalsL:7});}return this._oViews[X1.Week];case X1.OneMonth:case"OneMonth":if(!this._oViews[X1.OneMonth]){this._oViews[X1.OneMonth]=new L(this.getId()+"-OneMonthView",{key:X1.OneMonth,intervalType:Y1.OneMonth,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_ONE_MONTH"),intervalsS:1,intervalsM:1,intervalsL:31});}return this._oViews[X1.OneMonth];default:V.error("Cannot get PlanningCalendar views. Invalid view key "+$1);break;}},this);for(var Z1 in this._oViews){if(W1.indexOf(Z1)<0){this._oViews[Z1].destroy();delete this._oViews[Z1];}}if(i.length){x=x.concat(i);}return x;};k1.prototype.getSelectedAppointments=function(){var i=[];this.getRows().filter(function(j){i.push.apply(i,L1(j).aSelectedAppointments);});return i;};k1.prototype.setCustomAppointmentsSorterCallback=function(i){if(typeof i==="function"||i===null||i===undefined){this.getRows().forEach(function(j){L1(j)._setCustomAppointmentsSorterCallback(i);});this._fnCustomSortedAppointments=i;}else{V.warning("Your custom sort function won't be used, but the old one will be preserved.",this);}return this;};k1.prototype.setWidth=function(i){var j=this.getStartDate();this.getRows().forEach(function(x){L1(x).setStartDate(j);});return this.setProperty("width",i);};k1.prototype.getCustomAppointmentsSorterCallback=function(){return this._fnCustomSortedAppointments;};k1.prototype._onRowDeselectAppointment=function(){var x=this.getRows();for(var i=0;i<x.length;i++){var W1=L1(x[i]).aSelectedAppointments;for(var j=0;j<W1.length;j++){var X1=m.byId(W1[j]);if(X1){X1.setProperty("selected",false,true);X1.$().removeClass("sapUiCalendarAppSel");}}L1(x[i]).aSelectedAppointments=[];}};k1.prototype._updateRowTimeline=function(i){var j=L1(i),x,W1,X1,Y1,Z1,$1=(this.getViewKey()===_.OneMonth||this.getViewKey()==="OneMonth")&&this._iSize<2,_1=this.getStartDate();j.setNonWorkingDays(i.getNonWorkingDays());j.setNonWorkingHours(i.getNonWorkingHours());if($1&&this._oOneMonthsRow&&this._oOneMonthsRow.getSelectedDates().length){_1=this._oOneMonthsRow.getSelectedDates()[0].getStartDate();}j.setStartDate(_1);j.setShowIntervalHeaders(this.getShowIntervalHeaders());j.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());j.setGroupAppointmentsMode(this.getGroupAppointmentsMode());j.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());j.setAppointmentRoundWidth(this.getAppointmentRoundWidth());j.setLegend(this.getLegend());j.setAppointmentsVisualization(this.getAppointmentsVisualization());j.setAppointmentHeight(this.getAppointmentHeight());j.attachEvent("select",B1,this);j.attachEvent("startDateChange",this._handleStartDateChange,this);j.attachEvent("leaveRow",R1,this);j.attachEvent("intervalSelect",x1,this);S1.call(this);if(U1.call(this)){x=this.getViewKey();W1=this._getView(x);X1=W1.getIntervalType();Z1=W1.getIntervalSize();Y1=this._getIntervals(W1);j.setIntervalType(X1);j.setIntervals(Y1);j.setIntervalSize(Z1);j.setShowSubIntervals(W1.getShowSubIntervals());}this._setSelectionMode.call(this);if(this._fnCustomSortedAppointments){j._setCustomAppointmentsSorterCallback(this._fnCustomSortedAppointments);}};k1.prototype._observeRowChanges=function(i){var j=J1(i),x=K1(i),W1=L1(i);var X1={destroy:function(){j.destroy();},change:{title:function(Y1){x.setProperty(Y1.name,Y1.current);},icon:function(Y1){if(x.setIcon){x.setIcon(Y1.current);}else{x.setProperty(Y1.name,Y1.current);}},text:function(Y1){W1.toggleStyleClass("sapMPlanCalRowLarge",!!Y1.current);x.setProperty("description",Y1.current);},enableAppointmentsDragAndDrop:function(Y1){this._enableAppointmentsDragAndDrop(i);}.bind(this),enableAppointmentsResize:function(Y1){this._enableAppointmentsResize(i);}.bind(this),enableAppointmentsCreate:function(Y1){this._enableAppointmentsCreate(i);}.bind(this),nonWorkingDays:function(Y1){W1.setProperty(Y1.name,Y1.current);},nonWorkingHours:function(Y1){W1.setProperty(Y1.name,Y1.current);},selected:function(Y1){S1.call(this);j.setProperty(Y1.name,Y1.current);}.bind(this),tooltip:function(Y1){if(Y1.mutation==="insert"){x.setTooltip(Y1.child);}else if(Y1.mutation==="remove"){x.setTooltip();}},intervalHeaders:function(Y1){W1.invalidate();},appointments:function(Y1){W1.invalidate();}}};new M(function(Y1){if(Y1.type==="destroy"){X1.destroy();}else if(X1.change[Y1.name]){X1.change[Y1.name](Y1);}}).observe(i,{properties:["icon","text","title","nonWorkingDays","nonWorkingHours","selected","enableAppointmentsDragAndDrop","enableAppointmentsResize","enableAppointmentsCreate"],aggregations:["tooltip","appointments","intervalHeaders","headerContent"],destroy:true});i.invalidate=function(Y1){if(!Y1||!(Y1 instanceof g)){E.prototype.invalidate.apply(this,arguments);}else if(j){W1.invalidate(Y1);}};i.applyFocusInfo=function(Y1){W1.applyFocusInfo(Y1);return this;};};k1.prototype._createPlanningCalendarListItem=function(i){var j,x,W1;if(i.getHeaderContent().length||i.getBindingInfo("headerContent")){x=i._getPlanningCalendarCustomRowHeader();}else{x=new C1(i.getId()+"-Head",{icon:i.getIcon(),description:i.getText(),title:i.getTitle(),tooltip:i.getTooltip(),iconDensityAware:false});}W1=new E1(i.getId()+"-CalRow",{checkResize:false,updateCurrentTime:false,ariaLabelledBy:x.getId()});W1._getRelativeInfo=this._getRelativeInfo.bind(this);W1.getAppointments=function(){return i.getAppointments();};W1.getIntervalHeaders=function(){return i.getIntervalHeaders();};W1.setAssociation("row",i.getId());j=new G1(i.getId()+j1,{cells:[x,W1]});this._updateRowTimeline(i);this._observeRowChanges(i);this._enableAppointmentsDragAndDrop(i);this._enableAppointmentsResize(i);this._enableAppointmentsCreate(i);return j;};k1.prototype._handleRowRemoval=function(i){var j=L1(i);j.detachEvent("select",B1,this);j.detachEvent("startDateChange",this._handleStartDateChange,this);j.detachEvent("leaveRow",R1,this);j.detachEvent("intervalSelect",x1,this);if(this._fnCustomSortedAppointments){j._fnCustomSortedAppointments=undefined;}J1(i).destroy();};var C1=G.extend("sap.m._PlanningCalendarRowHeader",{renderer:{apiVersion:2,renderTabIndex:function(i,j){},getAriaRole:function(i,j){}},TagName:"div"});C1.prototype.isSelectable=function(){return false;};var D1=R.extend(k);D1.apiVersion=2;D1.getLegendItems=function(i){var j=[],x,W1=i.getLegend();if(W1){x=m.byId(W1);if(x){j=x.getAppointmentItems?x.getAppointmentItems():x.getItems();}else{V.error("PlanningCalendarLegend with id '"+W1+"' does not exist!",i);}}return j;};D1.renderBeforeAppointments=function(j,x){var W1=I1(x.getParent()),X1;if(!W1.getEnableAppointmentsDragAndDrop()&&!W1.getEnableAppointmentsResize()&&!W1.getEnableAppointmentsCreate()||x._isOneMonthsRowOnSmallSizes()){return;}X1=x.getAggregation("_intervalPlaceholders");j.openStart("div");j.class("sapUiCalendarRowAppsOverlay");j.openEnd();if(X1){for(var i=0;i<X1.length;i++){var Y1=X1[i];Y1.setWidth(100/X1.length+"%");j.renderControl(Y1);}}j.close("div");};D1.renderResizeHandle=function(i,j,x){if(!I1(j.getParent()).getEnableAppointmentsResize()||j._isOneMonthsRowOnSmallSizes()||(x._aAppointments&&x._aAppointments.length>0)){return;}i.openStart("span");i.class("sapUiCalendarAppResizeHandle");i.openEnd();i.close("span");};D1.writeCustomAttributes=function(i,j){if(I1(j.getParent()).getEnableAppointmentsCreate()){i.attr("draggable","true");}};D1.renderInterval=function(j,x,W1,X1,Y1,Z1,$1,_1,a2,b2,c2,d2,e2){var f2=x.getIntervalType(),g2;if(x._getRelativeInfo().bIsRelative){var h2=[];return k.renderInterval(j,x,W1,X1,Y1,h2,$1,_1,a2,b2,c2,d2,e2,g2);}if(f2===d1.Day||f2===d1.Week||f2===d1.OneMonth||f2==="OneMonth"){var i2=I1(x.getParent()),j2=i2.getParent(),k2=function(u2){return u2.getType()===Y.NonWorking;},l2=i2._getSpecialDates().filter(k2),m2=j2._getSpecialDates().filter(k2),n2=x.getStartDate(),o2,p2,q2,r2;if(m2&&l2){o2=m2.concat(l2);}else if(l2){o2=l2;}if(o2&&o2.length){var s2=function(u2){return u2===p2.getDay();};p2=new Date(n2.getTime());p2.setHours(0,0,0);p2.setDate(n2.getDate()+W1);for(var i=0;i<o2.length;i++){if(o2[i].getStartDate()){q2=new Date(o2[i].getStartDate().getTime());}if(o2[i].getEndDate()){r2=new Date(o2[i].getEndDate().getTime());}else{r2=new Date(o2[i].getStartDate().getTime());r2.setHours(23,59,59);}if(p2.getTime()>=q2.getTime()&&p2.getTime()<=r2.getTime()){var t2=Z1.some(s2);if(!t2){g2="sapUiCalendarRowAppsNoWork";}}}}}k.renderInterval(j,x,W1,X1,Y1,Z1,$1,_1,a2,b2,c2,d2,e2,g2);};var E1=h.extend("sap.m._PlanningCalendarRowTimeline",{metadata:{aggregations:{intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true},_intervalPlaceholders:{type:"sap.m._PlanningCalendarIntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}}},associations:{row:{type:"sap.m.PlanningCalendarRow",multiple:false}},dnd:true},renderer:D1});E1.prototype._updatePlaceholders=function(){var j=this.getProperty("intervals");if(this.getIntervalType()===d1.Hour){j*=2;}this.removeAllAggregation("_intervalPlaceholders");for(var i=0;i<j;i++){this.addAggregation("_intervalPlaceholders",new F1());}};E1.prototype._getRelativeInfo=function(){};E1.prototype.onBeforeRendering=function(){h.prototype.onBeforeRendering.call(this);this._updatePlaceholders();};E1.prototype.onmousedown=function(i){var j=i.target.classList;this._isResizeHandleMouseDownTarget=j.contains("sapUiCalendarAppResizeHandle");this._isRowAppsIntervalMouseDownTarget=j.contains("sapUiCalendarRowAppsInt");};E1.prototype._isResizingPerformed=function(){return this._isResizeHandleMouseDownTarget;};E1.prototype._isDraggingPerformed=function(){return!this._isResizeHandleMouseDownTarget&&!this._isRowAppsIntervalMouseDownTarget;};E1.prototype._isCreatingPerformed=function(){return this._isRowAppsIntervalMouseDownTarget;};var F1=C.extend("sap.m._PlanningCalendarIntervalPlaceholder",{metadata:{properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}}},renderer:function(i,j){i.openStart("div",j);i.style("width",j.getWidth());i.class("sapUiCalendarRowAppsPlaceholder");i.openEnd();i.close("div");}});var G1=z.extend("sap.m.internal.PlanningCalendarRowListItem",{metadata:{library:"sap.m"},renderer:A});G1.prototype.getHeader=function(){return this.getCells()[0];};G1.prototype.getTimeline=function(){return this.getCells()[1];};G1.prototype.getCustomData=function(){return I1(this).getCustomData();};k1.prototype._getSelectedDates=function(){var i=this.getViewKey(),j=this._getView(i),x=j.getIntervalType(),W1=m1[x];return this[W1.sInstanceName].getSelectedDates();};k1.prototype._enableAppointmentsDragAndDrop=function(i){var j=L1(i),x;if(i.getEnableAppointmentsDragAndDrop()){x=i.getDragDropConfig().some(function(W1){return W1.getGroupName()===g1;});if(!x){this._addDragDropInfo(i,L1(i));}}else{i.getDragDropConfig().forEach(function(W1){if(W1.getGroupName()===g1){i.removeDragDropConfig(W1);W1.destroy();}});j.getDragDropConfig().forEach(function(W1){if(W1.getGroupName()===g1){j.removeDragDropConfig(W1);W1.destroy();}});}};k1.prototype._enableAppointmentsResize=function(i){var j=i.getEnableAppointmentsResize(),x=this._getConfigFromDragDropConfigAggregation(i.getAggregation("dragDropConfig"),h1),W1;if(j&&!x){W1=this._createResizeConfig(i);i.addAggregation("dragDropConfig",W1,true);}if(!j&&x){i.removeAggregation("dragDropConfig",x,true);x.destroy();}};k1.prototype._enableAppointmentsCreate=function(i){var j=i.getEnableAppointmentsCreate(),x=L1(i),W1=this._getConfigFromDragDropConfigAggregation(x.getAggregation("dragDropConfig"),i1),X1;if(j&&!W1){X1=this._createAppointmentsCreateConfig(i);x.addAggregation("dragDropConfig",X1,true);}if(!j&&W1){x.removeAggregation("dragDropConfig",W1,true);W1.destroy();}};k1.prototype._addDragDropInfo=function(i,j){i.addDragDropConfig(new p({groupName:g1,sourceAggregation:"appointments",dragStart:function(x){var W1=function(){var X1=W(".sapUiCalendarRowAppsOverlay");setTimeout(function(){X1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);W(document).one("dragend",function(){X1.removeClass("sapUiCalendarRowAppsOverlayDragging");});};if(j._isOneMonthsRowOnSmallSizes()||!j._isDraggingPerformed()){x.preventDefault();return;}W1();}}));j.addDragDropConfig(new q({groupName:g1,targetAggregation:"_intervalPlaceholders",dragEnter:function(x){var W1=x.getParameter("dragSession"),X1=W1.getDragControl(),Y1=j.getIntervalType(),Z1=j.getStartDate(),$1=j.indexOfAggregation("_intervalPlaceholders",W1.getDropControl()),_1=j.getId(),a2,b2=function(){var d2=W(W1.getIndicator()),e2=W1.getDropControl().getDomRef().getBoundingClientRect(),f2=m.byId(_1).getDomRef().getBoundingClientRect(),g2=W1.getDragControl().$().outerWidth(),h2=m.getConfiguration().getRTL(),i2=h2?Math.ceil(e2.right)-f2.left:f2.right-Math.ceil(e2.left);d2.css("min-width",(g2<i2)?g2:i2).css(h2?"border-left-width":"border-right-width",(g2>i2)?"0":"").css("margin-left",h2?-(d2.outerWidth()-parseFloat(d2.context.style.width)):"");};if(i.hasListeners("appointmentDragEnter")){if(Y1===d1.Hour){a2=this._calcNewHoursAppPos(Z1,X1.getStartDate(),X1.getEndDate(),$1);}else if(Y1===d1.Day||Y1===d1.Week||((Y1===d1.OneMonth||Y1==="OneMonth")&&!j._isOneMonthsRowOnSmallSizes())){a2=this._calcNewDaysAppPos(Z1,X1.getStartDate(),X1.getEndDate(),$1);}else if(Y1===d1.Month){a2=this._calcNewMonthsAppPos(Z1,X1.getStartDate(),X1.getEndDate(),$1);}var c2=i.fireAppointmentDragEnter({appointment:X1,startDate:a2.startDate,endDate:a2.endDate,calendarRow:I1(j.getParent())});if(!c2){x.preventDefault();return;}}else if(L1(X1.getParent())!==j){x.preventDefault();return;}if(j.getIntervalType()!==d1.Hour){return;}if(!W1.getIndicator()){setTimeout(b2,0);}else{b2();}}.bind(this),drop:function(x){var W1=x.getParameter("dragSession"),X1=W1.getDragControl(),Y1=j.getIntervalType(),Z1=j.getStartDate(),$1=j.indexOfAggregation("_intervalPlaceholders",W1.getDropControl()),_1,a2=x.getParameter("browserEvent"),b2=(a2.metaKey||a2.ctrlKey);if(Y1===d1.Hour){_1=this._calcNewHoursAppPos(Z1,X1.getStartDate(),X1.getEndDate(),$1);}else if(Y1===d1.Day||Y1===d1.Week||((Y1===d1.OneMonth||Y1==="OneMonth")&&!j._isOneMonthsRowOnSmallSizes())){_1=this._calcNewDaysAppPos(Z1,X1.getStartDate(),X1.getEndDate(),$1);}else if(Y1===d1.Month){_1=this._calcNewMonthsAppPos(Z1,X1.getStartDate(),X1.getEndDate(),$1);}j.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");if(X1.getStartDate().getTime()===_1.startDate.getTime()&&X1.getParent()===I1(j.getParent())){return;}i.fireAppointmentDrop({appointment:X1,startDate:_1.startDate,endDate:_1.endDate,calendarRow:I1(j.getParent()),copy:b2});}.bind(this)}));};k1.prototype._calcNewHoursAppPos=function(i,j,x,W1){var X1=a._createUniversalUTCDate(i,null,true),Y1=a._createUniversalUTCDate(j,null,true),Z1=a._createUniversalUTCDate(x,null,true),$1=new Date(X1.setUTCMinutes(0,0,0)+(W1*30*60*1000));return{startDate:a._createLocalDate($1,true),endDate:a._createLocalDate(new Date($1.getTime()+Z1.getTime()-Y1.getTime()),true)};};k1.prototype._calcNewDaysAppPos=function(i,j,x,W1){var X1=a._createUniversalUTCDate(i,null,true),Y1=a._createUniversalUTCDate(j,null,true),Z1=a._createUniversalUTCDate(x,null,true),$1=Z1.getTime()-Y1.getTime();Y1.setUTCFullYear(X1.getUTCFullYear(),X1.getUTCMonth(),X1.getUTCDate()+W1);Z1=new Date(Y1.getTime()+$1);return{startDate:a._createLocalDate(Y1,true),endDate:a._createLocalDate(Z1,true)};};k1.prototype._calcNewMonthsAppPos=function(i,j,x,W1){var X1=a._createUniversalUTCDate(i,null,true),Y1=a._createUniversalUTCDate(j,null,true),Z1=a._createUniversalUTCDate(x,null,true),$1=Z1.getTime()-Y1.getTime();Y1.setUTCFullYear(X1.getUTCFullYear(),X1.getUTCMonth()+W1);Z1=new Date(Y1.getTime()+$1);return{startDate:a._createLocalDate(Y1,true),endDate:a._createLocalDate(Z1,true)};};k1.prototype._createResizeConfig=function(i){var j=L1(i),x=new r({sourceAggregation:"appointments",targetAggregation:"_intervalPlaceholders",targetElement:L1(i),dragStart:function(W1){if(!i.getEnableAppointmentsResize()||j._isOneMonthsRowOnSmallSizes()||!j._isResizingPerformed()){W1.preventDefault();return;}var X1=W1.getParameter("dragSession"),Y1=j.$().find(".sapUiCalendarRowAppsOverlay"),Z1=W(X1.getIndicator()),$1=X1.getDragControl().$();Z1.addClass("sapUiDnDIndicatorHide");setTimeout(function(){Y1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);W(document).one("dragend",function(){Y1.removeClass("sapUiCalendarRowAppsOverlayDragging");Z1.removeClass("sapUiDnDIndicatorHide");$1.css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});});W1.getParameter("browserEvent").dataTransfer.setDragImage(H1(),0,0);},dragEnter:function(W1){var X1=W1.getParameter("dragSession"),Y1=this.getTargetElement(),Z1=function(){var c2=W(X1.getIndicator());c2.addClass("sapUiDnDIndicatorHide");},$1=X1.getDropControl().getDomRef().getBoundingClientRect(),_1=m.byId(Y1).getDomRef().getBoundingClientRect(),a2={width:$1.left+$1.width-(X1.getDragControl().$().position().left+_1.left),"z-index":1,opacity:0.8},b2=a2.width;if($1.width>0){while(b2<=0){b2+=$1.width;}while(b2>$1.width){b2-=$1.width;}}a2["min-width"]=b2;X1.getDragControl().$().css(a2);if(!X1.getIndicator()){setTimeout(Z1,0);}else{Z1();}},drop:function(W1){var j=L1(i),X1=W1.getParameter("dragSession"),Y1=X1.getDragControl(),Z1=j.getIntervalType(),$1=j.getStartDate(),_1=j.indexOfAggregation("_intervalPlaceholders",X1.getDropControl()),a2;if(Z1===d1.Hour){a2=this._calcResizeNewHoursAppPos($1,Y1.getStartDate(),Y1.getEndDate(),_1);}else if(Z1===d1.Day||Z1===d1.Week||((Z1===d1.OneMonth||Z1==="OneMonth")&&!j._isOneMonthsRowOnSmallSizes())){a2=this._calcResizeNewDaysAppPos($1,Y1.getStartDate(),Y1.getEndDate(),_1);}else if(Z1===d1.Month){a2=this._calcResizeNewMonthsAppPos($1,Y1.getStartDate(),Y1.getEndDate(),_1);}j.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");W(X1.getIndicator()).removeClass("sapUiDnDIndicatorHide");Y1.$().css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});if(Y1.getEndDate().getTime()===a2.endDate.getTime()){return;}i.fireAppointmentResize({appointment:Y1,startDate:a2.startDate,endDate:a2.endDate,calendarRow:i});}.bind(this)});x.setProperty("groupName",h1);return x;};k1.prototype._calcResizeNewHoursAppPos=function(i,j,x,W1){var X1=a._createUniversalUTCDate(new Date(i.getTime()),null,true),Y1=30*60*1000,Z1=a._createUniversalUTCDate(j,null,true),$1=new Date(X1.setUTCMinutes(0,0,0)+((W1+1)*Y1));if($1.getTime()<=Z1.getTime()){$1=new Date(Z1.getTime()+Y1);}return{startDate:a._createLocalDate(Z1,true),endDate:a._createLocalDate($1,true)};};k1.prototype._calcResizeNewDaysAppPos=function(i,j,x,W1){var X1=a._createUniversalUTCDate(i,null,true),Y1=a._createUniversalUTCDate(j,null,true),Z1=new Date(X1.setUTCDate(X1.getUTCDate()+W1+1)),$1={};$1.startDate=a._createLocalDate(Y1);$1.startDateTime=a._createLocalDate(Y1,true);$1.endDate=a._createLocalDate(Z1);if($1.endDate<=$1.startDate){$1.endDate=a._createLocalDate(new Date(Z1.setUTCDate(Y1.getUTCDate()+1)));}return{startDate:$1.startDateTime,endDate:$1.endDate};};k1.prototype._calcResizeNewMonthsAppPos=function(i,j,x,W1){var X1=a._createUniversalUTCDate(i,null,true),Y1=a._createUniversalUTCDate(j,null,true),Z1=new Date(X1.setUTCMonth(X1.getUTCMonth()+W1+1,1));if(a._monthsBetween(Y1,Z1,true)<0){Z1=new Date(Z1.setUTCFullYear(Y1.getUTCFullYear(),Y1.getUTCMonth()+1,1));}return{startDate:a._createLocalDate(Y1,true),endDate:a._createLocalDate(Z1)};};k1.prototype._calcCreateNewAppHours=function(i,j,x){var W1=a._createUniversalUTCDate(i,null,true),X1=30*60*1000,Y1=(j<=x)?j:x,Z1=(j<=x)?x+1:j,$1=new Date(W1.setUTCMinutes(0,0,0)),_1=new Date($1.getTime()+Y1*X1),a2=new Date($1.getTime()+Z1*X1);return{startDate:a._createLocalDate(_1,true),endDate:a._createLocalDate(a2,true)};};k1.prototype._calcCreateNewAppDays=function(i,j,x){var W1=a._createUniversalUTCDate(i,null,true),X1=(j<=x)?j:x,Y1=(j<=x)?x+1:j,Z1=new Date(W1.getTime()),$1=new Date(W1.getTime());return{startDate:a._createLocalDate(new Date(Z1.setUTCDate(Z1.getUTCDate()+X1))),endDate:a._createLocalDate(new Date($1.setUTCDate($1.getUTCDate()+Y1)))};};k1.prototype._calcCreateNewAppMonths=function(i,j,x){var W1=a._createUniversalUTCDate(i,null,true),X1=(j<=x)?j:x,Y1=(j<=x)?x+1:j,Z1=new Date(W1.getTime()),$1=new Date(W1.getTime());return{startDate:a._createLocalDate(new Date(Z1.setUTCMonth(Z1.getUTCMonth()+X1,1))),endDate:a._createLocalDate(new Date($1.setUTCMonth($1.getUTCMonth()+Y1,1)))};};k1.prototype._getConfigFromDragDropConfigAggregation=function(j,x){var W1=j,X1=W1&&W1.length;for(var i=0;i<X1;i++){if(W1[i].getGroupName()===x){return W1[i];}}return null;};k1.prototype._createAppointmentsCreateConfig=function(i){var j=L1(i),x=new r({targetAggregation:"_intervalPlaceholders",dragStart:function(W1){if(!i.getEnableAppointmentsCreate()||j._isOneMonthsRowOnSmallSizes()||!j._isCreatingPerformed()){W1.preventDefault();return;}var X1=W1.getParameter("dragSession"),Y1=j.$().find(".sapUiCalendarRowAppsOverlay"),Z1=W(X1.getIndicator());setTimeout(function(){Y1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);W(document).one("dragend",function(){Y1.removeClass("sapUiCalendarRowAppsOverlayDragging");Z1.html("");Z1.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");});W1.getParameter("browserEvent").dataTransfer.setDragImage(H1(),0,0);},dragEnter:function(W1){var X1=W1.getParameter("dragSession"),Y1=X1.getDropControl().getDomRef().getBoundingClientRect(),Z1=function(){var _1=W(X1.getIndicator());_1.addClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");};var $1=X1.getData("text")?parseFloat(X1.getData("text").split("|")[0]):0;if($1){if($1<=Y1.left){X1.setIndicatorConfig({left:$1,width:Math.max((Y1.left+Y1.width-$1),Y1.width)});}else{X1.setIndicatorConfig({left:Y1.left,width:$1-Y1.left});}}else{X1.setData("text",Y1.left+"|"+j.indexOfAggregation("_intervalPlaceholders",X1.getDropControl()));}if(!X1.getIndicator()){setTimeout(Z1,0);}else{Z1();}},drop:function(W1){var X1=W1.getParameter("dragSession"),Y1=W(X1.getIndicator()),Z1=j.getIntervalType(),$1=L1(i).getStartDate(),_1=parseInt(X1.getData("text").split("|")[1]),a2=j.indexOfAggregation("_intervalPlaceholders",X1.getDropControl()),b2;if(Z1===d1.Hour){b2=this._calcCreateNewAppHours($1,_1,a2);}else if(Z1===d1.Day||Z1===d1.Week||((Z1===d1.OneMonth||Z1==="OneMonth")&&!j._isOneMonthsRowOnSmallSizes())){b2=this._calcCreateNewAppDays($1,_1,a2);}else if(Z1===d1.Month){b2=this._calcCreateNewAppMonths($1,_1,a2);}i.fireAppointmentCreate({startDate:b2.startDate,endDate:b2.endDate,calendarRow:i});Y1.html("");Y1.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");}.bind(this)});x.setProperty("groupName",i1);return x;};k1.prototype._updateHeaderButtons=function(){var i=this.getViewKey(),j=this._getView(i,true),x=j&&j.getIntervalType(),W1=new Date(this._dateNav.getStart().getTime()),X1=new Date(this._dateNav.getEnd().getTime()),Y1=this.getMinDate()?new Date(this.getMinDate().getTime()):undefined,Z1=this.getMaxDate()?new Date(this.getMaxDate().getTime()):undefined;if(x!=="Hour"){Y1&&Y1.setHours(0,0,0,0);Z1&&Z1.setHours(23,59,59,999);W1.setHours(0,0,0,0);X1.setHours(23,59,59,999);}this._getHeader()._oPrevBtn.setEnabled(!Y1||W1.getTime()>Y1.getTime());this._getHeader()._oNextBtn.setEnabled(!Z1||X1.getTime()<Z1.getTime());};k1.prototype._getSpecialDates=function(){var j=this.getSpecialDates();for(var i=0;i<j.length;i++){var x=j[i].getSecondaryType()===u.CalendarDayType.NonWorking&&j[i].getType()!==u.CalendarDayType.NonWorking;if(x){var W1=new f();W1.setType(u.CalendarDayType.NonWorking);W1.setStartDate(j[i].getStartDate());if(j[i].getEndDate()){W1.setEndDate(j[i].getEndDate());}j.push(W1);}}return j;};function H1(){var i=W("<span></span>").addClass("sapUiCalAppResizeGhost");i.appendTo(document.body);setTimeout(function(){i.remove();},0);return i.get(0);}function I1(i){var j=i.getId();return m.byId(j.substring(0,j.indexOf(j1)));}function J1(i){return m.byId(i.getId()+j1);}function K1(i){var j=J1(i);return j?j.getHeader():null;}function L1(i){var j=J1(i);return j?j.getTimeline():null;}function M1(j){var x=[];var W1=this.getRows();for(var i=0;i<W1.length;i++){var X1=W1[i];var Y1=J1(X1);var Z1=Y1.getSelected();if(X1.getSelected()!=Z1){X1.setProperty("selected",Z1,true);x.push(X1);}}if(!this.getSingleSelection()){S1.call(this);}if(x.length>0){this.fireRowSelectionChange({rows:x});}}function N1(i){if(i<this._iBreakPointTablet){this._iSize=0;}else if(i<this._iBreakPointDesktop){this._iSize=1;}else{this._iSize=2;}if(i<p1.PHONE){this._iSizeScreen=0;}else if(i<p1.TABLET){this._iSizeScreen=1;}else{this._iSizeScreen=2;}}function O1(j){var x='sapMSize'+j,i,W1;for(i=0;i<3;i++){W1='sapMSize'+i;if(W1===x){this.addStyleClass(W1);}else{this.removeStyleClass(W1);}}}function P1(){var j=this._getViews();this._oIntervalTypeSelect.destroyItems();var i;var x;for(i=0;i<j.length;i++){var W1=j[i];x=new F(this.getId()+"-"+i,{key:W1.getKey(),text:W1.getDescription(),tooltip:W1.getTooltip()});this._oIntervalTypeSelect.addItem(x);}if(this._oIntervalTypeSelect.getItems().length>4){this._getHeader()._convertViewSwitchToSelect();}else{this._getHeader()._convertViewSwitchToSegmentedButton();}this._oIntervalTypeSelect.setVisible(!(j.length===1));}function Q1(i){var j=i.getParameter("selected");var x=this.getRows();if(j){x=this.getRows().filter(function(W1){return!W1.getSelected();});}this.selectAllRows(j);this.fireRowSelectionChange({rows:x});}function R1(j){var x=j.oSource;var W1=j.getParameter("type");var X1=this.getRows();var Y1;var Z1;var $1;var _1;var i=0;var a2=0;var b2;for(i=0;i<X1.length;i++){Y1=X1[i];if(L1(Y1)==x){a2=i;break;}}switch(W1){case"sapup":$1=x.getFocusedAppointment();_1=$1.getStartDate();if(a2>0){a2--;}Z1=X1[a2];L1(Z1).focusNearestAppointment(_1);break;case"sapdown":$1=x.getFocusedAppointment();_1=$1.getStartDate();if(a2<X1.length-1){a2++;}Z1=X1[a2];L1(Z1).focusNearestAppointment(_1);break;case"saphome":if(a2>0){Z1=X1[0];b2=new W.Event(W1);b2._bPlanningCalendar=true;L1(Z1).onsaphome(b2);}break;case"sapend":if(a2<X1.length-1){Z1=X1[X1.length-1];b2=new W.Event(W1);b2._bPlanningCalendar=true;L1(Z1).onsapend(b2);}break;default:break;}}function S1(){if(this._oSelectAllCheckBox){var i=this.getRows();var j=this.getSelectedRows();if(i.length==j.length&&j.length>0){this._oSelectAllCheckBox.setSelected(true);}else{this._oSelectAllCheckBox.setSelected(false);}}}function T1(){if(this.getSingleSelection()){if(this._oCalendarHeader.getAllCheckBox()){this._oCalendarHeader.setAllCheckBox();}else if(this._oInfoToolbar.getContent().length>2){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}}else{if(!this._oSelectAllCheckBox){this._oSelectAllCheckBox=new N(this.getId()+"-All",{text:this._oRB.getText("COLUMNSPANEL_SELECT_ALL")});this._oSelectAllCheckBox.attachEvent("select",Q1,this);}if(this._iSizeScreen<2||!this.getShowRowHeaders()){var i=this._oInfoToolbar.indexOfContent(this._oSelectAllCheckBox);if(this._iSizeScreen<2){if(i<this._oInfoToolbar.getContent().length-1){this._oInfoToolbar.addContent(this._oSelectAllCheckBox);}}else if(i<0||i>1){if(i>1){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}this._oInfoToolbar.insertContent(this._oSelectAllCheckBox,1);}}else{this._oCalendarHeader.setAllCheckBox(this._oSelectAllCheckBox);}}}k1.prototype._setSelectionMode=function(){var i=this.getAggregation("table");var j=i.getMode();var x;if(this.getSingleSelection()){if(!this.getShowRowHeaders()&&this.getRows().length==1){x=Z.None;}else{x=Z.SingleSelectMaster;}}else{x=Z.MultiSelect;}if(j!=x){i.setMode(x);}};k1.prototype.calcIntervalOffset=function(i){var j=Date.UTC(i.getFullYear(),i.getMonth(),i.getDate());var x=this.getMinDate()||i;var W1=Date.UTC(x.getFullYear(),x.getMonth(),x.getDate());return Math.round((j-W1)/1000/60/60/24/this._getView(this.getViewKey()).getIntervalSize());};k1.prototype._getDateFromIndex=function(i){var j=new Date(this.getMinDate());j.setDate(j.getDate()+i*this._getView(this.getViewKey()).getIntervalSize());return j;};k1.prototype._getRelativeInfo=function(){var i={},j=this._getView(this.getViewKey(),true);i.iIntervalSize=j.getIntervalSize();i.bIsRelative=j.getRelative();i.oMinDate=this.getMinDate();i._getDateFromIndex=this._getDateFromIndex.bind(this);i.intervalLabelFormatter=j.getIntervalLabelFormatter()?j.getIntervalLabelFormatter():function(x){return x;};i._getIndexFromDate=this.calcIntervalOffset.bind(this);return i;};function U1(){return this._oTimesRow||this._oDatesRow||this._oMonthsRow||this._oWeeksRow||this._oOneMonthsRow;}function V1(){if(!this._getHeader()){return 0;}var i=this._getHeader().getDomRef(),j=0,x;if(i){x=i.getBoundingClientRect();j=parseInt(x.height);}return j;}return k1;});
