/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Core','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/Item','./SelectListRenderer','sap/base/Log',"sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(l,C,a,I,b,S,L,q){"use strict";var t=l.touch;var c=l.SelectListKeyboardNavigationMode;var d=a.extend("sap.m.SelectList",{metadata:{library:"sap.m",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},_columnRatio:{type:"sap.m.SelectColumnRatio",group:"Appearance",visibility:"hidden"},_tabIndex:{type:"string",group:"Misc",visibility:"hidden",defaultValue:""},keyboardNavigationMode:{type:"sap.m.SelectListKeyboardNavigationMode",group:"Behavior",defaultValue:c.Delimited},hideDisabledItems:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{selectionChange:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}},itemPress:{parameters:{item:{type:"sap.ui.core.Item"}}}}}});d.prototype._setSelectedIndex=function(i,_){var o;_=_||this.getItems();i=(i>_.length-1)?_.length-1:Math.max(0,i);o=_[i];if(o){this.setSelection(o);}};d.prototype.updateItems=function(r,e){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(e&&(e.detailedReason==="AddVirtualContext"||e.detailedReason==="RemoveVirtualContext")){this._bHasVirtualContext=true;return;}this._bHasVirtualContext=false;this.synchronizeSelection({forceSelection:false});setTimeout(this.synchronizeSelection.bind(this),0);};d.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};d.prototype._activateItem=function(i){if(i instanceof b&&i&&i.getEnabled()){this.fireItemPress({item:i});if(this.getSelectedItem()!==i){this.setSelection(i);this.fireSelectionChange({selectedItem:i});}}};d.prototype._queryEnabledItemsDomRefs=function(){return this.getItems().reduce(function(r,i){if(i.getEnabled()&&!(i.isA("sap.ui.core.SeparatorItem"))){r.push(i.getDomRef());}return r;},[]);};d.prototype._handleARIAActivedescendant=function(){var A=q(document.activeElement).control(0),D=this.getDomRef();if(A&&D){D.setAttribute("aria-activedescendant",A.getId());}};d.prototype.init=function(){this._iStartTimeout=0;this._iActiveTouchId=0;this._fStartX=0;this._fStartY=0;this._oItemNavigation=null;this._$ItemPressed=null;};d.prototype.onBeforeRendering=function(){this.synchronizeSelection({forceSelection:false});};d.prototype.onAfterRendering=function(){if(this.getKeyboardNavigationMode()===c.None){this.destroyItemNavigation();}else{this.createItemNavigation();}};d.prototype.exit=function(){this.destroyItemNavigation();this._$ItemPressed=null;};d.prototype.ontouchstart=function(e){if(t.countContained(e.touches,this.getId())>1||!this.getEnabled()){return;}e.setMarked();var T=e.targetTouches[0];this._iActiveTouchId=T.identifier;this._fStartX=T.pageX;this._fStartY=T.pageY;this._iStartTimeout=setTimeout(function(){var i=e.srcControl.$();if(i){i.addClass(this.getRenderer().CSS_CLASS+"ItemBasePressed");this._$ItemPressed=i;}}.bind(this),100);};d.prototype.ontouchmove=function(e){var T=null;if(!this.getEnabled()){return;}T=t.find(e.changedTouches,this._iActiveTouchId);if(T&&((Math.abs(T.pageX-this._fStartX)>10)||(Math.abs(T.pageY-this._fStartY)>10))){clearTimeout(this._iStartTimeout);if(this._$ItemPressed){this._$ItemPressed.removeClass(this.getRenderer().CSS_CLASS+"ItemBasePressed");this._$ItemPressed=null;}}};d.prototype.ontouchend=function(e){var T=null;if(!this.getEnabled()){return;}e.setMarked();T=t.find(e.changedTouches,this._iActiveTouchId);if(T){setTimeout(function(){if(this._$ItemPressed){this._$ItemPressed.removeClass(this.getRenderer().CSS_CLASS+"ItemBasePressed");this._$ItemPressed=null;}this._iStartTimeout=null;}.bind(this),100);}};d.prototype.ontouchcancel=d.prototype.ontouchend;d.prototype.ontap=function(e){if(this.getEnabled()){e.setMarked();this._activateItem(e.srcControl);}};d.prototype.onsapselect=function(e){if(this.getEnabled()){e.setMarked();e.preventDefault();this._activateItem(e.srcControl);}};d.prototype.onAfterFocus=function(o){this._handleARIAActivedescendant();};d.prototype.findFirstEnabledItem=function(e){e=e||this.getItems();for(var i=0;i<e.length;i++){if(e[i].getEnabled()){return e[i];}}return null;};d.prototype.setSelection=function(i){this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",(i instanceof b)?i.getId():i);if(typeof i==="string"){i=C.byId(i);}this.setProperty("selectedKey",i?i.getKey():"",true);return this;};d.prototype.synchronizeSelection=function(o){var k=this.getSelectedKey(),i=this.getItemByKey(""+k),f=true;if(o){f=!!o.forceSelection;}if(this.isSelectionSynchronized({selectedKey:k,firstItemWithKey:i,forceSelection:f})){return;}if(i&&(k!=="")){this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",i.getId(),true);}else if(f&&!this._bHasVirtualContext&&this.getDefaultSelectedItem()&&(!this.isBound("items")||this.bItemsUpdated)){try{this.setSelection(this.getDefaultSelectedItem());}catch(e){L.warning('Update failed due to exception. Loggable in support mode log',null,null,function(){return{exception:e};});}}};d.prototype.isSelectionSynchronized=function(o){var s=this.getSelectedItem(),e,f,F;if(o){e=o.selectedKey;f=o.firstItemWithKey;F=o.forceSelection;}else{e=this.getSelectedKey();f=this.getItemByKey(e);F=this.getForceSelection();}if(F){if(!s){return false;}if(e===""&&s.getKey()===""){return true;}return e===s.getKey()&&s===f;}else{if(s===null&&e===""){return true;}if(e===""){return false;}return e===(s&&s.getKey())&&s===f;}};d.prototype.getForceSelection=function(){return false;};d.prototype.findLastEnabledItem=function(i){i=i||this.getItems();return this.findFirstEnabledItem(i.reverse());};d.prototype.getVisibleItems=function(){for(var i=0,o,e=this.getItems(),v=[];i<e.length;i++){o=e[i];if(o.bVisible||(o.bVisible===undefined)){v.push(o);}}return v;};d.prototype._getColumnsPercentages=function(){var r=this.getProperty("_columnRatio"),R,T,f;if(!r){return null;}R=r.split(":").map(function(n){return parseInt(n);});T=R[0]+R[1];f=Math.round(R[0]/T*100);return{firstColumn:f+"%",secondColumn:100-f+"%"};};d.prototype.getSelectableItems=function(){return this.getEnabledItems(this.getVisibleItems()).filter(function(i){return!(i.isA("sap.ui.core.SeparatorItem"));});};d.prototype.findItem=function(p,v){var m="get"+p.charAt(0).toUpperCase()+p.slice(1);for(var i=0,e=this.getItems();i<e.length;i++){if(e[i][m]()===v){return e[i];}}return null;};d.prototype.getItemByText=function(T){return this.findItem("text",T);};d.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};d.prototype._getNonSeparatorItemsCount=function(){return this.getEnabledItems().filter(function(i){return!(i.isA("sap.ui.core.SeparatorItem"));}).length;};d.prototype.getDefaultSelectedItem=function(i){return null;};d.prototype.clearSelection=function(){this.setSelection(null);};d.prototype.createItemNavigation=function(){var D;if(!this._oItemNavigation){this._oItemNavigation=new I(null,null,!this.getEnabled());this._oItemNavigation.attachEvent(I.Events.AfterFocus,this.onAfterFocus,this);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addEventDelegate(this._oItemNavigation);}D=this.getDomRef();this._oItemNavigation.setRootDomRef(D);this._oItemNavigation.setItemDomRefs(this._queryEnabledItemsDomRefs(D));this._oItemNavigation.setCycling(false);this._oItemNavigation.setSelectedIndex(this.indexOfItem(this.getSelectedItem()));this._oItemNavigation.setPageSize(10);};d.prototype.destroyItemNavigation=function(){if(this._oItemNavigation){this.removeEventDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}};d.prototype.getItemNavigation=function(){return this._oItemNavigation;};d.prototype.setSelectedItem=function(i){if(typeof i==="string"){this.setAssociation("selectedItem",i,true);i=C.byId(i);}if(!(i instanceof b)&&i!==null){return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);return this;};d.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);this.setSelection(i);return this;};d.prototype.setSelectedKey=function(k){k=this.validateProperty("selectedKey",k);var i=this.getItemByKey(k);if(i||(k==="")){if(!i&&k===""){i=this.getDefaultSelectedItem();}this.setSelection(i);return this;}return this.setProperty("selectedKey",k);};d.prototype.getSelectedItem=function(){var s=this.getAssociation("selectedItem");return(s===null)?null:C.byId(s)||null;};d.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};d.prototype.getFirstItem=function(){return this.getItems()[0]||null;};d.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};d.prototype.getEnabledItems=function(i){i=i||this.getItems();return i.filter(function(o){return o.getEnabled();});};d.prototype.getItemByKey=function(k){return this.findItem("key",k);};d.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){this.setSelection(this.getDefaultSelectedItem());}return i;};d.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items",true);this.$().children("li").remove();return i;};d.prototype.destroyItems=function(){this.destroyAggregation("items",true);return this;};d.prototype.setNoDataText=function(){};return d;});
