/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Element','./DynamicDateOption','./Label','./StepInput','./RadioButton','./RadioButtonGroup','sap/ui/unified/Calendar','sap/ui/unified/calendar/MonthPicker','sap/ui/core/format/DateFormat','./StandardDynamicDateRangeKeys','sap/ui/core/date/UniversalDateUtils','sap/ui/core/date/UniversalDate','sap/m/DynamicDateValueHelpUIType','./library'],function(E,D,L,S,R,a,C,M,b,c,U,d,e,l){"use strict";var f=D.extend("sap.m.StandardDynamicDateOption",{metadata:{library:"sap.m"}});var g=1;var h=6000;var K={"DATE":"DATE","DATERANGE":"DATERANGE","TODAY":"TODAY","YESTERDAY":"YESTERDAY","TOMORROW":"TOMORROW","SPECIFICMONTH":"SPECIFICMONTH","THISWEEK":"THISWEEK","THISMONTH":"THISMONTH","THISQUARTER":"THISQUARTER","THISYEAR":"THISYEAR","LASTWEEK":"LASTWEEK","LASTMONTH":"LASTMONTH","LASTQUARTER":"LASTQUARTER","LASTYEAR":"LASTYEAR","NEXTWEEK":"NEXTWEEK","NEXTMONTH":"NEXTMONTH","NEXTQUARTER":"NEXTQUARTER","NEXTYEAR":"NEXTYEAR","LASTDAYS":"LASTDAYS","LASTWEEKS":"LASTWEEKS","LASTMONTHS":"LASTMONTHS","LASTQUARTERS":"LASTQUARTERS","LASTYEARS":"LASTYEARS","NEXTDAYS":"NEXTDAYS","NEXTWEEKS":"NEXTWEEKS","NEXTMONTHS":"NEXTMONTHS","NEXTQUARTERS":"NEXTQUARTERS","NEXTYEARS":"NEXTYEARS","FROM":"FROM","TO":"TO","YEARTODATE":"YEARTODATE","TODAYFROMTO":"TODAYFROMTO","QUARTER1":"QUARTER1","QUARTER2":"QUARTER2","QUARTER3":"QUARTER3","QUARTER4":"QUARTER4"};var _={"SingleDates":1,"DateRanges":2,"Weeks":3,"Months":4,"Quarters":5,"Years":6};var j={"DATE":_.SingleDates,"DATERANGE":_.DateRanges,"TODAY":_.SingleDates,"YESTERDAY":_.SingleDates,"TOMORROW":_.SingleDates,"SPECIFICMONTH":_.Months,"THISWEEK":_.Weeks,"THISMONTH":_.Months,"THISQUARTER":_.Quarters,"THISYEAR":_.Years,"LASTWEEK":_.Weeks,"LASTMONTH":_.Months,"LASTQUARTER":_.Quarters,"LASTYEAR":_.Years,"NEXTWEEK":_.Weeks,"NEXTMONTH":_.Months,"NEXTQUARTER":_.Quarters,"NEXTYEAR":_.Years,"LASTDAYS":_.DateRanges,"LASTWEEKS":_.DateRanges,"LASTMONTHS":_.DateRanges,"LASTQUARTERS":_.DateRanges,"LASTYEARS":_.DateRanges,"NEXTDAYS":_.DateRanges,"NEXTWEEKS":_.DateRanges,"NEXTMONTHS":_.DateRanges,"NEXTQUARTERS":_.DateRanges,"NEXTYEARS":_.DateRanges,"FROM":_.DateRanges,"TO":_.DateRanges,"YEARTODATE":_.DateRanges,"TODAYFROMTO":_.DateRanges,"QUARTER1":_.Quarters,"QUARTER2":_.Quarters,"QUARTER3":_.Quarters,"QUARTER4":_.Quarters};var k=["LASTDAYS","LASTWEEKS","LASTMONTHS","LASTQUARTERS","LASTYEARS"];var n=["NEXTDAYS","NEXTWEEKS","NEXTMONTHS","NEXTQUARTERS","NEXTYEARS"];f.LastXKeys=k;f.NextXKeys=n;var m=sap.ui.getCore().getLibraryResourceBundle("sap.m");f.Keys=K;f.prototype.getText=function(i){var s=this.getKey();var O=i._getOptions();var p=this.getValueHelpUITypes(i);var q=this._getOptionParams(k,O);var N=this._getOptionParams(n,O);if(q){p.push(q);}if(N){p.push(N);}switch(s){case K.LASTDAYS:case K.LASTWEEKS:case K.LASTMONTHS:case K.LASTQUARTERS:case K.LASTYEARS:return m.getText("DYNAMIC_DATE_LASTX_TITLE",p[1].getOptions().join(" / "));case K.NEXTDAYS:case K.NEXTWEEKS:case K.NEXTMONTHS:case K.NEXTQUARTERS:case K.NEXTYEARS:return m.getText("DYNAMIC_DATE_NEXTX_TITLE",p[1].getOptions().join(" / "));default:return m.getText("DYNAMIC_DATE_"+s+"_TITLE");}};f.prototype.getValueHelpUITypes=function(i){var s=this.getKey();switch(s){case K.TODAY:case K.YESTERDAY:case K.TOMORROW:case K.THISWEEK:case K.THISMONTH:case K.THISQUARTER:case K.THISYEAR:case K.LASTWEEK:case K.LASTMONTH:case K.LASTQUARTER:case K.LASTYEAR:case K.NEXTWEEK:case K.NEXTMONTH:case K.NEXTQUARTER:case K.NEXTYEAR:case K.YEARTODATE:case K.QUARTER1:case K.QUARTER2:case K.QUARTER3:case K.QUARTER4:return[];case K.DATE:case K.FROM:case K.TO:return[new e({type:"date"})];case K.DATERANGE:return[new e({type:"daterange"})];case K.SPECIFICMONTH:return[new e({type:"month"})];case K.LASTDAYS:case K.LASTWEEKS:case K.LASTMONTHS:case K.LASTQUARTERS:case K.LASTYEARS:case K.NEXTDAYS:case K.NEXTWEEKS:case K.NEXTMONTHS:case K.NEXTQUARTERS:case K.NEXTYEARS:return[new e({text:m.getText("DDR_LASTNEXTX_LABEL"),type:"int"})];case K.TODAYFROMTO:return[new e({text:m.getText("DDR_TODAYFROMTO_FROM_LABEL"),type:"int"}),new e({text:m.getText("DDR_TODAYFROMTO_TO_LABEL"),type:"int"})];}};f.prototype.createValueHelpUI=function(i,p){var O=i._getOptions();var v=i.getValue();var P=this.getValueHelpUITypes(i);var q=[];if(!i.aControlsByParameters){i.aControlsByParameters={};}i.aControlsByParameters[this.getKey()]=[];var r=this._getOptionParams(k,O);var N=this._getOptionParams(n,O);if(r){P.push(r);}if(N){P.push(N);}for(var I=0;I<P.length;I++){if(P[I].getOptions()&&P[I].getOptions().length<=1){break;}else if(P[I].getText()){q.push(new L({text:P[I].getText(),width:"100%"}));}var s;switch(P[I].getType()){case"int":s=this._createIntegerControl(v,I,p);if(v&&P[1]&&P[1].getOptions()&&P[1].getOptions().indexOf(v.operator.slice(4).toLowerCase())!==-1){s.setValue(v.values[I]);}break;case"date":s=this._createDateControl(v,I,p);break;case"daterange":s=this._createDateRangeControl(v,I,p);break;case"month":s=this._createMonthControl(v,I,p);break;case"options":s=this._createOptionsControl(v,I,p,P);break;}q.push(s);i.aControlsByParameters[this.getKey()].push(s);}return q;};f.prototype._createIntegerControl=function(v,i,p){var q=D.prototype._createIntegerControl.call(this,v,i,p);var r=this.getKey()==="TODAYFROMTO"?-h:g;var u=!v||this.getKey()!==v.operator;if(this.getKey()==="TODAYFROMTO"&&u){q.setValue(1);}q.setMin(r);q.setMax(h);return q;};f.prototype._createOptionsControl=function(v,i,p,P){var q=new a({buttons:[P[i].getOptions().map(o)]});if(v){var O=P[i].getOptions().indexOf(v.operator.slice(4).toLowerCase());if(O!==-1){q.setSelectedIndex(O);}}if(p instanceof Function){q.attachSelect(function(){p(this);},this);}return q;};f.prototype._getOptionParams=function(G,O){if(G.indexOf(this.getKey())!==-1){return new e({text:"Time Periods:",type:"options",options:O?O.filter(function(i){return G.indexOf(i.getKey())!==-1;}).map(function(i){return i.getKey().slice(4).toLowerCase();}):[]});}return undefined;};f.prototype.validateValueHelpUI=function(p){var P=this.getValueHelpUITypes();for(var i=0;i<P.length;i++){var I=p.aControlsByParameters[this.getKey()][i];switch(P[i].getType()){case"int":if(I._isLessThanMin(I.getValue())||I._isMoreThanMax(I.getValue())){return false;}break;case"month":case"date":case"daterange":if(!I.getSelectedDates()||I.getSelectedDates().length==0){return false;}break;case"options":if(I.getSelectedIndex()<0){return false;}break;}}return true;};f.prototype.getValueHelpOutput=function(p){var O=p._getOptions();var P=this.getValueHelpUITypes(p),r={},v;if(k.indexOf(this.getKey())!==-1&&p.aControlsByParameters[this.getKey()].length>1){r.operator=O.filter(function(s){return k.indexOf(s.getKey())!==-1;})[p.aControlsByParameters[this.getKey()][1].getSelectedIndex()].getKey();}else if(n.indexOf(this.getKey())!==-1&&p.aControlsByParameters[this.getKey()].length>1){r.operator=O.filter(function(s){return n.indexOf(s.getKey())!==-1;})[p.aControlsByParameters[this.getKey()][1].getSelectedIndex()].getKey();}else{r.operator=this.getKey();}r.values=[];for(var i=0;i<P.length;i++){var I=p.aControlsByParameters[this.getKey()][i];switch(P[i].getType()){case"int":v=I.getValue();break;case"month":if(!I.getSelectedDates()||!I.getSelectedDates().length){return null;}v=I.getSelectedDates()[0].getStartDate().getMonth();break;case"date":if(!I.getSelectedDates().length){return null;}v=I.getSelectedDates()[0].getStartDate();break;case"daterange":if(!I.getSelectedDates().length){return null;}var q=I.getSelectedDates()[0].getEndDate()||I.getSelectedDates()[0].getStartDate();v=[I.getSelectedDates()[0].getStartDate(),q];break;}if(Array.isArray(v)){r.values=Array.prototype.concat.apply(r.values,v);}else{v!==null&&v!==undefined&&r.values.push(v);}}return r;};f.prototype.getGroup=function(){return j[this.getKey()];};f.prototype.getGroupHeader=function(){return m.getText("DDR_OPTIONS_GROUP_"+j[this.getKey()]);};f.prototype.format=function(O,F){return F.format(O);};f.prototype.parse=function(v,F){return F.parse(v,this.getKey());};f.prototype.toDates=function(v){if(!v){return null;}var s=v.operator;var p=v.values[0]||0;switch(s){case"SPECIFICMONTH":var i=new d();i.setMonth(v.values[0]);i=U.getMonthStartDate(i);return U.getRange(0,"MONTH",i);case"DATE":return U.getRange(0,"DAY",d.getInstance(v.values[0]));case"DATERANGE":var q=d.getInstance(v.values[0]);var r=d.getInstance(v.values[1]);return[U.resetStartTime(q),U.resetEndTime(r)];case"TODAY":return U.ranges.today();case"YESTERDAY":return U.ranges.yesterday();case"TOMORROW":return U.ranges.tomorrow();case"THISWEEK":return U.ranges.currentWeek();case"THISMONTH":return U.ranges.currentMonth();case"THISQUARTER":return U.ranges.currentQuarter();case"THISYEAR":return U.ranges.currentYear();case"LASTWEEK":return U.ranges.lastWeek();case"LASTMONTH":return U.ranges.lastMonth();case"LASTQUARTER":return U.ranges.lastQuarter();case"LASTYEAR":return U.ranges.lastYear();case"NEXTWEEK":return U.ranges.nextWeek();case"NEXTMONTH":return U.ranges.nextMonth();case"NEXTQUARTER":return U.ranges.nextQuarter();case"NEXTYEAR":return U.ranges.nextYear();case"LASTDAYS":return U.ranges.lastDays(p);case"LASTWEEKS":return U.ranges.lastWeeks(p);case"LASTMONTHS":return U.ranges.lastMonths(p);case"LASTQUARTERS":return U.ranges.lastQuarters(p);case"LASTYEARS":return U.ranges.lastYears(p);case"NEXTDAYS":return U.ranges.nextDays(p);case"NEXTWEEKS":return U.ranges.nextWeeks(p);case"NEXTMONTHS":return U.ranges.nextMonths(p);case"NEXTQUARTERS":return U.ranges.nextQuarters(p);case"NEXTYEARS":return U.ranges.nextYears(p);case"FROM":return[v.values[0],v.values[0]];case"TO":return[v.values[0],v.values[0]];case"YEARTODATE":return U.ranges.yearToDate();case"TODAYFROMTO":if(v.values.length!==2){return[];}var x=v.values[0];var y=v.values[1];var q=x>=0?U.ranges.lastDays(x)[0]:U.ranges.nextDays(-x)[1];var r=y>=0?U.ranges.nextDays(y)[1]:U.ranges.lastDays(-y)[0];if(q.oDate.getTime()>r.oDate.getTime()){r=[q,q=r][0];}return[U.resetStartTime(q),U.resetEndTime(r)];case"QUARTER1":return U.ranges.quarter(1);case"QUARTER2":return U.ranges.quarter(2);case"QUARTER3":return U.ranges.quarter(3);case"QUARTER4":return U.ranges.quarter(4);default:return[];}};f.prototype.enhanceFormattedValue=function(){switch(this.getKey()){case"TODAY":case"YESTERDAY":case"TOMORROW":case"THISWEEK":case"THISMONTH":case"THISQUARTER":case"THISYEAR":case"LASTWEEK":case"LASTMONTH":case"LASTQUARTER":case"LASTYEAR":case"NEXTWEEK":case"NEXTMONTH":case"NEXTQUARTER":case"NEXTYEAR":case"YEARTODATE":case"QUARTER1":case"QUARTER2":case"QUARTER3":case"QUARTER4":return true;default:return false;}};function o(O){return new R({text:O});}return f;});
