/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/library","sap/ui/core/IconPool","sap/ui/core/theming/Parameters","sap/ui/Device","./library","./ListItemBase","./Image","./StandardListItemRenderer","sap/base/Log"],function(c,I,T,D,l,L,a,S,b){"use strict";var d=c.TextDirection;var V=c.ValueState;var e=L.extend("sap.m.StandardListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},description:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconInset:{type:"boolean",group:"Appearance",defaultValue:true},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},info:{type:"string",group:"Misc",defaultValue:null},infoState:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:V.None},adaptTitleSize:{type:"boolean",group:"Appearance",defaultValue:true},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:d.Inherit},infoTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:d.Inherit},wrapping:{type:"boolean",group:"Behavior",defaultValue:false},infoStateInverted:{type:"boolean",group:"Appearance",defaultValue:false},wrapCharLimit:{type:"int",group:"Behavior",defaultValue:0}},designtime:"sap/m/designtime/StandardListItem.designtime"}});e.prototype.exit=function(){if(this._oImage){this._oImage.destroy("KeepDom");}L.prototype.exit.apply(this,arguments);};e.prototype.setIcon=function(i){var o=this.getIcon();this.setProperty("icon",i);if(this._oImage&&(!i||I.isIconURI(i)!=I.isIconURI(o))){this._oImage.destroy("KeepDom");this._oImage=undefined;}return this;};e.prototype.setWrapCharLimit=function(i){var o=this.getWrapCharLimit();if(o===i){return this;}if(i<0){b.error("The property wrapCharLimit must be 0 or greater than 0 - "+this.getId());return this;}this.setProperty("wrapCharLimit",i);return this;};e.prototype._getImage=function(){var i=this._oImage;if(i){i.setSrc(this.getIcon());if(i.setDensityAware){i.setDensityAware(this.getIconDensityAware());}}else{i=I.createControlByURI({id:this.getId()+"-img",src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false},a).setParent(this,null,true);}var s=this.getIconInset()?"sapMSLIImg":"sapMSLIImgNoInset";i.addStyleClass(i instanceof a?s:s+"Icon",true);this._oImage=i;return this._oImage;};e.prototype._activeHandlingInheritor=function(){if(this._oImage){var A=this.getActiveIcon();A&&this._oImage.setSrc(A);}};e.prototype._inactiveHandlingInheritor=function(){if(this._oImage){this._oImage.setSrc(this.getIcon());}};e.prototype.getContentAnnouncement=function(B){var i=this.getInfoState(),t=this.getTitle(),s,f=this.getDescription(),g,o,h,O=[],j=this.getInfo();if(this.getWrapping()){o=this.getDomRef("titleButton");h=this.getDomRef("descriptionButton");t=this._bTitleTextExpanded?t:this._getCollapsedText(t);f=this._bDescriptionTextExpanded?f:this._getCollapsedText(f);O.push(t);if(o){s=o.textContent+" "+B.getText("ACC_CTR_TYPE_BUTTON");s&&O.push(s);}O.push(f);if(h){g=h.textContent+" . "+B.getText("ACC_CTR_TYPE_BUTTON");g&&O.push(g);}}else{t&&O.push(t);f&&O.push(f);}j&&O.push(j);if(i!="None"&&i!=this.getHighlight()){O.push(B.getText("LIST_ITEM_STATE_"+i.toUpperCase()));}return O.join(" . ").trim();};e.prototype._measureInfoTextWidth=function(t){if(!e._themeInfo){e._themeInfo={};}var B=parseFloat(l.BaseFontSize)||16;if(!e._themeInfo.sFontFamily||t){e._themeInfo.sFontFamily=T.get({name:"sapUiFontFamily"})||"Arial";}if(!e._themeInfo.sFontStyleInfoStateInverted||t){e._themeInfo.sFontStyleInfoStateInverted="bold "+parseFloat(T.get({name:"sapMFontSmallSize"})||"0.75rem")*B+"px "+e._themeInfo.sFontFamily;}if(!e._themeInfo.sFontStyle||t){e._themeInfo.sFontStyle=parseFloat(T.get({name:"sapMFontMediumSize"})||"0.875rem")*B+"px "+e._themeInfo.sFontFamily;}if(!e._oCtx){e._oCtx=document.createElement("canvas").getContext("2d");}e._oCtx.font=e._themeInfo[this.getInfoStateInverted()?"sFontStyleInfoStateInverted":"sFontStyle"];return Math.ceil(e._oCtx.measureText(this.getInfo()).width)/B;};e.prototype._getInfoTextMinWidth=function(w){if(this.getInfoStateInverted()&&w<=7.5){return w+0.625+"rem";}if(w<=7.5){return w+"rem";}return"7.5rem";};e.prototype.ontap=function(E){this._checkExpandCollapse(E);return L.prototype.ontap.apply(this,arguments);};e.prototype.ontouchstart=function(E){var i=E.target&&E.target.id,s=this.getId();if(i===s+"-titleButton"||i===s+"-descriptionButton"){E.setMarked();}return L.prototype.ontouchstart.apply(this,arguments);};e.prototype.onsapspace=function(E){this._checkExpandCollapse(E,true);if(!E.isMarked()){return L.prototype.onsapspace.apply(this,arguments);}};e.prototype._checkExpandCollapse=function(E,p){var t=E.target,i=t&&t.id;if(i&&i===this.getId()+"-titleButton"){if(p){E.preventDefault();}E.setMarked();return this._toggleExpandCollapse("title",this._bTitleTextExpanded);}if(i&&i===this.getId()+"-descriptionButton"){if(p){E.preventDefault();}E.setMarked();return this._toggleExpandCollapse("description",this._bDescriptionTextExpanded);}};e.prototype._toggleExpandCollapse=function(w,t){var o=this.getDomRef(w+"Text"),f=this.getDomRef(w+"ThreeDots"),B=this.getDomRef(w+"Button"),s=w==="title"?this.getTitle():this.getDescription(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(!t){o.textContent=s;f.textContent=" ";B.textContent=r.getText("TEXT_SHOW_LESS");t=true;}else{o.textContent=this._getCollapsedText(s);f.textContent=" ... ";B.textContent=r.getText("TEXT_SHOW_MORE");t=false;}if(w==="title"){this._bTitleTextExpanded=t;}else{this._bDescriptionTextExpanded=t;}};e.prototype._getCollapsedText=function(t){return t.substr(0,this._getWrapCharLimit());};e.prototype._getWrapCharLimit=function(){return this.getWrapCharLimit()||(D.system.phone?100:300);};e.prototype.onThemeChanged=function(E){L.prototype.onThemeChanged.apply(this,arguments);var t=E.theme;if(!this._initialRender){this._initialRender=true;if(!e._themeInfo){e._themeInfo={};}if(!e._themeInfo.sCurrentTheme){e._themeInfo.sCurrentTheme=t;}return;}var i=this.getDomRef("info");if(i){var w;if(e._themeInfo.sCurrentTheme!==t){e._themeInfo.sCurrentTheme=t;w=this._measureInfoTextWidth(true);}else{w=this._measureInfoTextWidth();}i.style.minWidth=this._getInfoTextMinWidth(w);}};return e;});
