/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/Device','sap/ui/base/EventProvider','sap/ui/core/InvisibleText','sap/ui/core/ValueStateSupport','sap/m/library','sap/ui/core/library','sap/m/Button','sap/m/GroupHeaderListItem','sap/m/List',"sap/m/ValueStateHeader","sap/m/inputUtils/scrollToItem","sap/m/inputUtils/SuggestionsPopoverDialogMixin","sap/m/inputUtils/SuggestionsPopoverPopoverMixin","sap/m/inputUtils/ListHelpers"],function(D,E,I,V,l,c,B,G,L,a,s,S,b,d){"use strict";var e=l.ListMode;var f=l.ListSeparators;var C="sapMSuggestionsPopover",g="sapUiNoContentPadding";var h=c.ValueState;var j=E.extend("sap.m.SuggestionsPopover",{constructor:function(){E.apply(this,arguments);this._sPopoverContentWidth=null;this._sOldValueState=h.None;if(D.system.phone){S.apply(j.prototype);}else{b.apply(j.prototype);}},destroy:function(){this._destroySuggestionPopup();}});j.M_EVENTS={SELECTION_CHANGE:"selectionChange"};j.prototype.isOpen=function(){var p=this.getPopover();return p&&p.isOpen();};j.prototype.setPopover=function(p){this._oPopover=p;};j.prototype.getPopover=function(){return this._oPopover;};j.prototype.destroyPopover=function(){if(this._oPopover){this._oPopover.destroy();}this._oPopover=null;};j.prototype.setInputLabels=function(i){this._fnInputLabels=i;};j.prototype.createSuggestionPopup=function(p,o){var P,i=this.getItemsContainer();o=o||[];P=this.createPopover(p,o);this.setPopover(P);P.addStyleClass(C);P.addStyleClass(g);P.addAriaLabelledBy(I.getStaticId("sap.m","INPUT_AVALIABLE_VALUES"));if(i){this.addContent(i);}};j.prototype.initContent=function(p,o){var i=o,P=this.getPopover();if(!P){return;}if(!i){i=new L(p+"-popup-list",{showNoData:false,mode:e.SingleSelectMaster,rememberSelections:false,width:"100%",showSeparators:f.None,busyIndicatorDelay:0});}this.addContent(i);};j.prototype._destroySuggestionPopup=function(){this.destroyPopover();this._oValueStateHeader=null;};j.prototype.addContent=function(o){this.getPopover().addContent(o);};j.prototype.getItemsContainer=function(){var p=this.getPopover(),i=p&&p.getContent();return i&&i.filter(function(o){return(o.isA("sap.m.List")&&o.getId().indexOf("-popup-list")>-1)||o.isA("sap.m.Table");})[0];};j.prototype.handleListNavigation=function(p,o){var P=this.getPopover();if(o.isMarked()){return;}if(!p.getEnabled()||!p.getEditable()){return;}if(!P||!P.isOpen()){return;}o.preventDefault();o.stopPropagation();var i=this.getItemsContainer(),v=this._getValueStateHeader(),H=v&&v.getVisible(),F=p.hasStyleClass("sapMFocus"),k=i&&i.getItems().filter(function(q){return q.getVisible&&q.getVisible();}),m=k.indexOf(this.getFocusedListItem()),n;switch(o.type){case"sapdown":n=this.handleArrowDown(k,m,F,H);break;case"sapup":n=this.handleArrowUp(k,m,F,H);break;case"sapend":n=this.handleEnd(k,H);break;case"saphome":n=this.handleHome(k,H);break;case"sappagedown":n=this.handlePageDown(k,m,H);break;case"sappageup":n=this.handlePageUp(k,m,H);break;}this.updateFocus(p,n);if(p.handleSelectionFromList){p.handleSelectionFromList(n);}else{this.handleSelectionFromList(n);}this.updateAriaActiveDescendant(p,n);if(D.system.desktop&&n){s(n,this.getPopover());}};j.prototype.handleArrowDown=function(i,k,F,H){if(F&&!H){return i[0];}if(!F&&!this.getValueStateActiveState()){if(k===i.length-1){return i[k];}return i[k+1];}if(this.getValueStateActiveState()){this.setValueStateActiveState(false);return i[0];}else{this.setValueStateActiveState(true);}};j.prototype.handleArrowUp=function(i,k,F,H){if(F){return;}if(k>0){return i[k-1];}if(H){this.setValueStateActiveState(!this.getValueStateActiveState());}};j.prototype.handleEnd=function(i,H){if(H){this.setValueStateActiveState(false);}return i.length&&i[i.length-1];};j.prototype.handleHome=function(i,H){if(H){this.setValueStateActiveState(true);return;}return i.length&&i[0];};j.prototype.handlePageDown=function(i,k,H){if(H){this.setValueStateActiveState(false);}return i[Math.min(i.length-1,k+10)];};j.prototype.handlePageUp=function(i,k,H){if(k-10>=0){return i[k-10];}if(H){this.setValueStateActiveState(true);return;}return i[0];};j.prototype.updateFocus=function(p,i){var o=this.getItemsContainer(),P=this.getFocusedListItem(),v=this._getValueStateHeader(),H=v&&v.getVisible();o&&o.removeStyleClass("sapMListFocus");P&&P.removeStyleClass("sapMLIBFocused");p.hasStyleClass("sapMFocus")&&p.removeStyleClass("sapMFocus");H&&v.removeStyleClass("sapMPseudoFocus");if(i){i.addStyleClass("sapMLIBFocused");o.addStyleClass("sapMListFocus");this.updateListDataAttributes(o);}else if(this.getValueStateActiveState()){v.addStyleClass("sapMPseudoFocus");}else{p.addStyleClass("sapMFocus");}};j.prototype.updateListDataAttributes=function(o){if(!o){return;}var v=o.getVisibleItems();if(!v){return;}v.forEach(function(k){var m=k.getDomRef();if(m&&m.hasAttribute("data-sap-ui-first-suggestion-item")){m.removeAttribute("data-sap-ui-first-suggestion-item");}if(m&&m.hasAttribute("data-sap-ui-last-suggestion-item")){m.removeAttribute("data-sap-ui-last-suggestion-item");}});if(v[0]){var F=v[0].getDomRef();F&&F.setAttribute("data-sap-ui-first-suggestion-item","");}if(v[v.length-1]){var i=v[v.length-1].getDomRef();i&&i.setAttribute("data-sap-ui-last-suggestion-item","");}};j.prototype.handleSelectionFromList=function(i){var o=this.getItemsContainer(),p=this.getFocusedListItem(),k=i&&i.isA("sap.m.GroupHeaderListItem");if(!i||k){o.removeSelections(true);}else{o.setSelectedItem(i,true);}this.fireEvent(j.M_EVENTS.SELECTION_CHANGE,{previousItem:p,newItem:i});};j.prototype.updateAriaActiveDescendant=function(p,i){var o=p.getFocusDomRef(),v=this._getValueStateHeader(),F=v&&v.getFormattedText(),k;if(p.hasStyleClass("sapMFocus")){o.removeAttribute("aria-activedescendant");return;}if(i){o.setAttribute("aria-activedescendant",i.getId());return;}if(this.getValueStateActiveState()){k=F?F.getId():v.getId();o.setAttribute("aria-activedescendant",k);}};j.prototype.getFocusedListItem=function(){var o=this.getItemsContainer(),k=o&&o.getItems()||[];for(var i=0;i<k.length;i++){if(k[i].hasStyleClass("sapMLIBFocused")){return k[i];}}};j.prototype.setValueStateActiveState=function(A){this.bMessageValueStateActive=A;};j.prototype.getValueStateActiveState=function(){return this.bMessageValueStateActive;};j.prototype.updateValueState=function(v,i,k){var m=k&&v!==h.None;i=i||V.getAdditionalText(v);if(!this.getPopover()){return this;}if(this.getInput()){this.getInput().setValueState(v);}var o=this._getValueStateHeader();o.setValueState(v);if(o&&typeof i==="string"){o.setText(i);}else if(o&&typeof i==="object"){o.setFormattedText(i);}if(o){o.setVisible(m);}this._alignValueStateStyles(v);return this;};j.prototype._handleValueStateLinkNav=function(p,o){if(!this.getValueStateActiveState()||(this.getValueStateActiveState()&&document.activeElement.tagName==="A")){return;}var v=this.getValueStateLinks(),i=v[v.length-1];o.preventDefault();v[0].focus();this._getValueStateHeader().removeStyleClass("sapMPseudoFocus");v.forEach(function(k){k.addDelegate({onsapup:function(o){p.getFocusDomRef().focus();this.handleListNavigation(p,o);},onsapdown:function(o){p.getFocusDomRef().focus();this.handleListNavigation(p,o);}},this);},this);i.addDelegate({onsaptabnext:function(o){this.setValueStateActiveState(false);p.onsapfocusleave(o);this.getPopover().close();setTimeout(function(){p.closeValueStateMessage();},0);}},this);v[0].addDelegate({onsaptabprevious:function(o){o.preventDefault();p.getFocusDomRef().focus();this._getValueStateHeader().addStyleClass("sapMPseudoFocus");p.removeStyleClass("sapMFocus");}},this);};j.prototype.getValueStateLinks=function(){var H=this._getValueStateHeader(),F=H&&typeof H.getFormattedText==="function"&&H.getFormattedText(),i=F&&typeof F.getControls==="function"&&F.getControls();return i||[];};j.prototype._alignValueStateStyles=function(v){var p=C+"ValueState",o=C+this._sOldValueState+"State",i=C+v+"State",P=this.getPopover();P.addStyleClass(p);P.removeStyleClass(o);P.addStyleClass(i);this._sOldValueState=v;};j.prototype.decorateParent=function(p){p.addEventDelegate({onsaptabnext:this._handleValueStateLinkNav.bind(this,p),onsaptabprevious:this._handleValueStateLinkNav.bind(this,p)},this);};j.prototype.getInput=function(){return null;};j.prototype.getPickerTitle=function(){return null;};j.prototype.getOkButton=function(){return null;};j.prototype.getCancelButton=function(){return null;};j.prototype.getFilterSelectedButton=function(){return null;};j.prototype.setOkPressHandler=function(){return null;};j.prototype.setCancelPressHandler=function(){return null;};j.prototype.setShowSelectedPressHandler=function(){return null;};j.prototype.resizePopup=function(){};j.prototype._getValueStateHeader=function(){return null;};j.prototype._createValueStateHeader=function(){return null;};return j;});
