/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./InputBase','./DateTimeField','./MaskInputRule','./Toolbar','./ToolbarSpacer','./Popover','./ResponsivePopover','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','./TimePickerInternals','./TimePickerClocks','./TimePickerInputs','./MaskEnabler','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/Locale','sap/m/library','sap/ui/core/LocaleData','./TimePickerRenderer',"sap/ui/events/KeyCodes","sap/base/Log","sap/ui/core/InvisibleText",'./Button',"sap/ui/thirdparty/jquery"],function(I,D,M,T,a,P,R,E,b,c,d,e,f,g,h,L,l,j,k,K,m,n,B,q){"use strict";var o=l.PlacementType,p=l.TimePickerMaskMode,r=l.ButtonType,s=1;var t=D.extend("sap.m.TimePicker",{metadata:{library:"sap.m",designtime:"sap/m/designtime/TimePicker.designtime",properties:{localeId:{type:"string",group:"Data"},title:{type:"string",group:"Misc",defaultValue:null},minutesStep:{type:"int",group:"Misc",defaultValue:s},secondsStep:{type:"int",group:"Misc",defaultValue:s},placeholderSymbol:{type:"string",group:"Misc",defaultValue:"_"},mask:{type:"string",group:"Misc",defaultValue:null},maskMode:{type:"sap.m.TimePickerMaskMode",group:"Misc",defaultValue:p.On},support2400:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{rules:{type:"sap.m.MaskInputRule",multiple:true,singularName:"rule"},_picker:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"},_numPicker:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},dnd:{draggable:false,droppable:true}}});b.insertFontFaceStyle();E.call(t.prototype,true);f.call(t.prototype);var u={Short:"short",Medium:"medium",Long:"long"},v={Hour:"hour",Minute:"minute",Second:"second"},w='-';t.prototype.init=function(){D.prototype.init.apply(this,arguments);f.init.apply(this,arguments);this.setDisplayFormat(y());this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._bValid=false;this._sUsedDisplayPattern=null;this._sUsedValuePattern=null;this._oDisplayFormat=null;this._sValueFormat=null;this._oPopoverKeydownEventDelegate=null;this._rPlaceholderRegEx=new RegExp(w,'g');this._sLastChangeValue=null;var i=this.addEndIcon({id:this.getId()+"-icon",src:this.getIconSrc(),noTabStop:true,title:"",tooltip:this._oResourceBundle.getText("OPEN_PICKER_TEXT")});this._bShouldClosePicker=false;this._bShouldCloseNumericPicker=false;i.addEventDelegate({onmousedown:function(z){this._bShouldClosePicker=this.isOpen();}},this);i.attachPress(function(){this.toggleOpen(this._bShouldClosePicker);},this);this._sMinutes="00";this._sSeconds="00";};t.prototype.onBeforeRendering=function(){D.prototype.onBeforeRendering.apply(this,arguments);var V=this._getValueHelpIcon();if(V){V.setProperty("visible",this.getEditable(),true);}};t.prototype.exit=function(){if(this._oTimeSemanticMaskHelper){this._oTimeSemanticMaskHelper.destroy();}f.exit.apply(this,arguments);this._removePickerEvents();this._oResourceBundle=null;this._bValid=false;this._sUsedDisplayPattern=null;this._oDisplayFormat=null;this._oPopoverKeydownEventDelegate=null;this._sUsedValuePattern=null;this._sValueFormat=null;this._sLastChangeValue=null;};t.prototype.getIconSrc=function(){return b.getIconURI("time-entry-request");};t.prototype.isOpen=function(){return this._getPicker()&&this._getPicker().isOpen();};t.prototype.toggleOpen=function(O){if(this.getEditable()&&this.getEnabled()){this[O?"_closePicker":"_openPicker"]();}};t.prototype.isNumericOpen=function(){return this._getNumericPicker()&&this._getNumericPicker().isOpen();};t.prototype.toggleNumericOpen=function(O){if(this.getEditable()&&this.getEnabled()){this[O?"_closeNumericPicker":"_openNumericPicker"]();this._openByFocusIn=false;this._openByClick=false;}};t.prototype.onfocusin=function(i){var z=this._getPicker(),A=this._isIconClicked(i),N=this._getNumericPicker(),O=N&&N.isOpen();if(!this._isMobileDevice()){f.onfocusin.apply(this,arguments);}if(z&&z.isOpen()&&!A){this._closePicker();return;}if(this._openByClick){this._openByClick=false;return;}if(!this._isMobileDevice()){return;}if(!A){this.toggleNumericOpen(O);}this._openByFocusIn=true;};t.prototype.onclick=function(i){var z=this._isIconClicked(i),A=this._getNumericPicker(),O=A&&A.isOpen();if(this._openByFocusIn){this._openByFocusIn=false;return;}if(!this._isMobileDevice()){return;}if(!z){this.toggleNumericOpen(O);}this._openByClick=true;};t.prototype._isIconClicked=function(i){return q(i.target).hasClass("sapUiIcon")||q(i.target).hasClass("sapMInputBaseIconContainer");};t.prototype.onBeforeOpen=function(){var C=this._getClocks(),i=this.getDateValue(),z=this._$input.val(),F=this.getValueFormat(),A=F.indexOf("HH"),G=F.indexOf("H");C.setValue(z);if(this._shouldSetInitialFocusedDateValue()){i=this.getInitialFocusedDateValue();}C._setTimeValues(i,c._isHoursValue24(z,A,G));this.$().addClass(I.ICON_PRESSED_CSS_CLASS);};t.prototype.onAfterOpen=function(){var C=this._getClocks();if(C){this._handleAriaOnExpandCollapse(true);C.showFirstClock();C._focusActiveButton();}};t.prototype.onBeforeClose=function(){this._handleAriaOnExpandCollapse(false);};t.prototype.onAfterClose=function(){this.$().removeClass(I.ICON_PRESSED_CSS_CLASS);this._getClocks().showFirstClock();};t.prototype._isMobileDevice=function(){return!g.system.desktop&&(g.system.phone||g.system.tablet);};t.prototype.onBeforeNumericOpen=function(){var i=this._getInputs(),z=this.getDateValue(),A=this._$input.val(),F=this.getValueFormat(),C=F.indexOf("HH"),G=F.indexOf("H");i.setValue(A);if(this._shouldSetInitialFocusedDateValue()){z=this.getInitialFocusedDateValue();}i._setTimeValues(z,c._isHoursValue24(A,C,G));};t.prototype.onAfterNumericOpen=function(){var i=this._getInputs();if(i){this._handleAriaOnExpandCollapse(true);}};t.prototype.onBeforeNumericClose=function(){this._handleAriaOnExpandCollapse(false);};t.prototype._getValueHelpIcon=function(){var V=this.getAggregation("_endIcon");return V&&V[0];};t.prototype._handleInputChange=function(V){var i,z,A,C,F=this.getValueFormat(),G=F.indexOf("HH"),H=F.indexOf("H");V=V||this._$input.val();z=V;A=c._isHoursValue24(z,G,H);C=this.getSupport2400()&&A;this._bValid=true;if(V!==""){i=this._parseValue(A?c._replace24HoursWithZero(V,G,H):V,true);if(C){i.setMinutes(0,0);}if(!i){this._bValid=false;}else{V=this._formatValue(i);if(this.getMaskMode()&&this.getMask()){this._setupMaskVariables();}}}z=C?"24:"+V.replace(/[0-9]/g,"0").slice(0,-3):V;this.updateDomValue(z);if(i){z=V=this._formatValue(i,true);if(C&&i&&i.getHours()===0){z=V=c._replaceZeroHoursWith24(V,G,H);}}this.setProperty("value",z,true);this.setLastValue(V);if(this._bValid){this.setProperty("dateValue",i,true);}this.fireChangeEvent(z,{valid:this._bValid});return true;};t.prototype.onChange=function(i){var V=i?i.value:null;if(this.getEditable()&&this.getEnabled()){return this._handleInputChange(V);}return false;};t.prototype.setMinutesStep=function(i){var C=this._getClocks(),z=this._getInputs();i=Math.max(s,i||s);if(C){C.setMinutesStep(i);}if(z){z.setMinutesStep(i);}return this.setProperty("minutesStep",i,true);};t.prototype.setSecondsStep=function(i){var C=this._getClocks(),z=this._getInputs();i=Math.max(s,i||s);if(C){C.setSecondsStep(i);}if(z){z.setSecondsStep(i);}return this.setProperty("secondsStep",i,true);};t.prototype.setTitle=function(i){var C=this._getClocks();if(C){C.setLabelText(i);}this.setProperty("title",i,true);return this;};t.prototype._handleDateValidation=function(i){if(!i){this._bValid=false;m.warning("Value can not be converted to a valid date",this);}else{this._bValid=true;this.setProperty("dateValue",i,true);var V=this._formatValue(i);if(this.isActive()){this.updateDomValue(V);}else{this.setProperty("value",V,true);this.setLastValue(V);this._sLastChangeValue=V;}}};t.prototype.setSupport2400=function(S){var C=this._getClocks(),i=this._getInputs();this.setProperty("support2400",S,true);if(C){C.setSupport2400(S);}if(i){i.setSupport2400(S);}this._initMask();return this;};t.prototype.setDisplayFormat=function(i){var C=this._getClocks(),z=this._getInputs();this.setProperty("displayFormat",i,true);this._initMask();if(C){C.setDisplayFormat(i);}if(z){z.setDisplayFormat(i);}var A=this.getDateValue();if(!A){return this;}var O=this._formatValue(A);this.updateDomValue(O);this.setLastValue(O);return this;};t.prototype.setValue=function(V){var i,O,F=this.getValueFormat(),z=F.indexOf("HH"),A=F.indexOf("H"),C=this._getClocks(),G=this._getInputs();V=this.validateProperty("value",V);this._initMask();if(this.getValue()!==V){this._sLastChangeValue=V;}f.setValue.call(this,V);if(this.getMask()){this._setupMaskVariables();}this._bValid=true;if(V){i=this._parseValue(c._isHoursValue24(V,z,A)?c._replace24HoursWithZero(V,z,A):V);if(!i){this._bValid=false;m.warning("Value can not be converted to a valid date",this);}}if(this._bValid){this.setProperty("dateValue",i,true);}if(i&&!this.getSupport2400()){O=this._formatValue(i);}else{O=V;}if(C){C.setValue(V);}if(G){G.setValue(V);}this.updateDomValue(O);this.setLastValue(O);return this;};t.prototype.setDateValue=function(i){this._initMask();return D.prototype.setDateValue.apply(this,arguments);};t.prototype.setTooltip=function(i){var z=this.getDomRef(),A;this._refreshTooltipBaseDelegate(i);this.setAggregation("tooltip",i,true);if(!z){return this;}A=this.getTooltip_AsString();if(A){z.setAttribute("title",A);}else{z.removeAttribute("title");}return this;};t.prototype.setLocaleId=function(i){var C=this.getValue(),z=this._getClocks(),A=this._getInputs();this.setProperty("localeId",i,true);this._initMask();this._oDisplayFormat=null;this._sValueFormat=null;if(C){this.setValue(C);}if(z){z.setLocaleId(i);}if(A){A.setLocaleId(i);}return this;};t.prototype._getDefaultDisplayStyle=function(){return u.Medium;};t.prototype._getDefaultValueStyle=function(){return u.Medium;};t.prototype._getLocale=function(){var i=this.getLocaleId();return i?new L(i):sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();};t.prototype._getFormatterInstance=function(F,i,z,C,A){var G=this._getLocale();if(i===u.Short||i===u.Medium||i===u.Long){F=h.getTimeInstance({style:i,strictParsing:true,relative:z},G);}else{F=h.getTimeInstance({pattern:i,strictParsing:true,relative:z},G);}if(A){this._sUsedDisplayPattern=i;this._oDisplayFormat=F;}else{this._sUsedValuePattern=i;this._sValueFormat=F;}return F;};t.prototype._getFormat=function(){var F=this._getDisplayFormatPattern();if(!F){F=u.Medium;}if(Object.keys(u).indexOf(F)!==-1){F=y();}return F;};t.prototype.onsappageup=function(i){this._increaseTime(1,v.Hour);i.preventDefault();};t.prototype.onsappageupmodifiers=function(i){if(!(i.ctrlKey||i.metaKey||i.altKey)&&i.shiftKey){this._increaseTime(1,v.Minute);}if(!i.altKey&&i.shiftKey&&(i.ctrlKey||i.metaKey)){this._increaseTime(1,v.Second);}i.preventDefault();};t.prototype.onsappagedown=function(i){this._increaseTime(-1,v.Hour);i.preventDefault();};t.prototype.onsappagedownmodifiers=function(i){if(!(i.ctrlKey||i.metaKey||i.altKey)&&i.shiftKey){this._increaseTime(-1,v.Minute);}if(!i.altKey&&i.shiftKey&&(i.ctrlKey||i.metaKey)){this._increaseTime(-1,v.Second);}i.preventDefault();};t.prototype.onkeydown=function(i){var z=K,A=i.which||i.keyCode,C=i.altKey,F;if(A===z.F4||(C&&(A===z.ARROW_UP||A===z.ARROW_DOWN))){F=this._getPicker()&&this._getPicker().isOpen();if(!F){this._openPicker();}else{this._closePicker();}i.preventDefault();}else if(!this._isMobileDevice()){f.onkeydown.call(this,i);}else{if(A===K.ENTER||A===K.SPACE){this._openNumericPicker();}}};t.prototype._getPicker=function(){return this.getAggregation("_picker");};t.prototype._getNumericPicker=function(){return this.getAggregation("_numPicker");};t.prototype._removePickerEvents=function(){var i,z=this._getPicker();if(z){i=z.getAggregation("_popup");if(typeof this._oPopoverKeydownEventDelegate==='function'){i.removeEventDelegate(this._oPopoverKeydownEventDelegate);}}};t.prototype._openPicker=function(){var i=this._getPicker();if(!i){i=this._createPicker(this._getDisplayFormatPattern());}i.open();i.getContent()[0]._sMinutes=this._sMinutes;i.getContent()[0]._sSeconds=this._sSeconds;return i;};t.prototype._closePicker=function(){var i=this._getPicker();if(i){this._sMinutes=i.getContent()[0]._sMinutes;this._sSeconds=i.getContent()[0]._sSeconds;i.close();}else{m.warning("There is no picker to close.");}return i;};t.prototype._openNumericPicker=function(){var i=this._getNumericPicker();if(!i){i=this._createNumericPicker(this._getDisplayFormatPattern());}i.open();i.getContent()[0]._sMinutes=this._sMinutes;i.getContent()[0]._sSeconds=this._sSeconds;return i;};t.prototype._closeNumericPicker=function(){var i=this._getNumericPicker();if(i){this._sMinutes=i.getContent()[0]._sMinutes;this._sSeconds=i.getContent()[0]._sSeconds;i.close();this.getDomRef("inner").select();}else{m.warning("There is no picker to close.");}return i;};t.prototype._createPicker=function(F){var i=this,z,A,C,G,O,H,J,N=this.getAggregation("_endIcon")[0],Q=this._getLocale().getLanguage(),S,U,V;G=sap.ui.getCore().getLibraryResourceBundle("sap.m");O=G.getText("TIMEPICKER_SET");H=G.getText("TIMEPICKER_CANCEL");J=this._oResourceBundle.getText("TIMEPICKER_SET_TIME");C=new d(this.getId()+"-clocks",{support2400:this.getSupport2400(),displayFormat:F,valueFormat:this.getValueFormat(),localeId:Q,minutesStep:this.getMinutesStep(),secondsStep:this.getSecondsStep()});C._setAcceptCallback(this._handleOkPress.bind(this));var W=this._getValueStateHeader();A=new R(i.getId()+"-RP",{showCloseButton:false,showHeader:false,horizontalScrolling:false,verticalScrolling:true,title:J,placement:o.VerticalPreferredBottom,contentWidth:"20rem",beginButton:new B(this.getId()+"-OK",{text:O,type:r.Emphasized,press:this._handleOkPress.bind(this)}),endButton:new B(this.getId()+"-Cancel",{text:H,press:this._handleCancelPress.bind(this)}),content:[W,C],ariaLabelledBy:n.getStaticId("sap.m","TIMEPICKER_SET_TIME"),beforeOpen:this.onBeforeOpen.bind(this),beforeClose:this.onBeforeClose.bind(this),afterOpen:this.onAfterOpen.bind(this),afterClose:this.onAfterClose.bind(this)});W.setPopup(A._oControl);z=A.getAggregation("_popup");if(z.setShowArrow){z.setShowArrow(false);}z.oPopup.setAutoCloseAreas([N]);if(g.system.phone){S=this.$("inner").attr("aria-labelledby");U=S&&S.split(" ")[0];V=U?document.getElementById(U).getAttribute("aria-label"):"";if(V){A.setTitle(V);}A.setShowHeader(true);}else{this._oPopoverKeydownEventDelegate={onkeydown:function(X){var Y=K,Z=X.which||X.keyCode,$=X.altKey;if(($&&(Z===Y.ARROW_UP||Z===Y.ARROW_DOWN))||Z===Y.F4){this._handleOkPress(X);this.focus();X.preventDefault();}}};z.addEventDelegate(this._oPopoverKeydownEventDelegate,this);}A.addStyleClass(this.getRenderer().CSS_CLASS+"DropDown");A.open=function(){return this.openBy(i);};this.setAggregation("_picker",A,true);return A;};t.prototype._createNumericPicker=function(F){var i=this,z,A,O,C,G=this._getLocale().getLanguage();A=sap.ui.getCore().getLibraryResourceBundle("sap.m");O=A.getText("TIMEPICKER_SET");C=A.getText("TIMEPICKER_CANCEL");z=new P(i.getId()+"-NP",{showArrow:false,showHeader:false,horizontalScrolling:false,verticalScrolling:false,placement:o.VerticalPreferredBottom,content:[new e(this.getId()+"-inputs",{support2400:this.getSupport2400(),displayFormat:F,valueFormat:this.getValueFormat(),localeId:G,minutesStep:this.getMinutesStep(),secondsStep:this.getSecondsStep()})],footer:[new T({content:[new a(),new B(this.getId()+"-NumericOK",{text:O,type:r.Emphasized,press:this._handleNumericOkPress.bind(this)}),new B(this.getId()+"-NumericCancel",{text:C,press:this._handleNumericCancelPress.bind(this)})]})],ariaLabelledBy:n.getStaticId("sap.m","TIMEPICKER_SET_TIME"),beforeOpen:this.onBeforeNumericOpen.bind(this),afterOpen:this.onAfterNumericOpen.bind(this),beforeClose:this.onBeforeNumericClose.bind(this)});z.open=function(){return this.openBy(i);};this.setAggregation("_numPicker",z,true);return z;};t.prototype._getClocks=function(){var i=this._getPicker();if(!i){return null;}return i.getContent()[1];};t.prototype._getInputs=function(){var i=this._getNumericPicker();if(!i){return null;}return i.getContent()[0];};t.prototype._handleOkPress=function(i){var z=this._getClocks().getTimeValues(),V;this._isClockPicker=true;this._isNumericPicker=false;V=this._formatValue(z);this.updateDomValue(V);this._handleInputChange();this._closePicker();};t.prototype._handleCancelPress=function(i){this._closePicker();};t.prototype._handleNumericOkPress=function(i){var z=this._getInputs().getTimeValues(),V;this._isClockPicker=false;this._isNumericPicker=true;V=this._formatValue(z);this.updateDomValue(V);this._handleInputChange();this.getDomRef("inner").select();this._closeNumericPicker();};t.prototype._handleNumericCancelPress=function(i){this._closeNumericPicker();};t.prototype._getLocaleBasedPattern=function(i){return j.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()).getTimePattern(i);};t.prototype._parseValue=function(V,i){if(i){V=this._oTimeSemanticMaskHelper.stripValueOfLeadingSpaces(V);V=V.replace(this._rPlaceholderRegEx,'');}return D.prototype._parseValue.call(this,V,i);};t.prototype._formatValue=function(i,V){var z=D.prototype._formatValue.apply(this,arguments),F=this.getValueFormat(),A=F.indexOf("HH"),C=F.indexOf("H"),G;if(i){if(!V&&this._oTimeSemanticMaskHelper){z=this._oTimeSemanticMaskHelper.formatValueWithLeadingTrailingSpaces(z);}}if((this._isNumericPicker&&this.isNumericOpen()&&this._getInputs()&&this._getInputs()._getHoursInput()&&this._getInputs()._getHoursInput().getValue()==="24")||(this._isClockPicker&&this.isOpen()&&this._getClocks()&&this._getClocks()._getHoursClock()&&this._getClocks()._getHoursClock().getSelectedValue()===24)){G=true;}if(i&&i.getHours()===0&&this.getSupport2400()&&G){z=c._replaceZeroHoursWith24(z,A,C);}return z;};t.prototype._handleAriaOnExpandCollapse=function(i){this.getFocusDomRef().setAttribute("aria-expanded",i);};t.prototype._increaseTime=function(N,U){var O=this.getDateValue(),i,z;if(O&&this.getEditable()&&this.getEnabled()){i=new Date(O.getTime());switch(U){case v.Hour:i.setHours(i.getHours()+N);z=60*60*1000;break;case v.Minute:i.setMinutes(i.getMinutes()+N);z=60*1000;break;case v.Second:z=1000;i.setSeconds(i.getSeconds()+N);}if(N<0&&i.getTime()-O.getTime()!==N*z){i=new Date(O.getTime()+N*z);}this.setDateValue(i);this.fireChangeEvent(this.getValue(),{valid:true});}};t.prototype._initMask=function(){if(this._oTimeSemanticMaskHelper){this._oTimeSemanticMaskHelper.destroy();}this._oTimeSemanticMaskHelper=new x(this);};t.prototype._isMaskEnabled=function(){return this.getMaskMode()===p.On&&!this._isMobileDevice();};t.prototype._shouldSetInitialFocusedDateValue=function(){if(!this._isValidValue()){return true;}return!this.getValue()&&!!this.getInitialFocusedDateValue();};t.prototype._isValidValue=function(){return this._bValid;};t.prototype.fireChangeEvent=function(V,i){if(V){V=V.trim();}if(V!==this._sLastChangeValue){this._sLastChangeValue=V;D.prototype.fireChangeEvent.call(this,V,i);}};var x=function(z){var A=z._getDisplayFormatPattern(),C,F,G=z._getLocale(),i;if(z._checkStyle(A)){C=j.getInstance(G).getTimePattern(A);}else{A=A.replace(/'/g,"");C=A;}this._oTimePicker=z;this.aOriginalAmPmValues=j.getInstance(G).getDayPeriods("abbreviated");this.aAmPmValues=this.aOriginalAmPmValues.slice(0);this.iAmPmValueMaxLength=Math.max(this.aAmPmValues[0].length,this.aAmPmValues[1].length);for(i=0;i<this.aAmPmValues.length;i++){while(this.aAmPmValues[i].length<this.iAmPmValueMaxLength){this.aAmPmValues[i]+=" ";}}this.b24H=A.indexOf("H")!==-1;this.bLeadingZero=A.indexOf("HH")!==-1||A.indexOf("hh")!==-1;this.sLeadingChar=this.bLeadingZero?"0":" ";this.sAlternativeLeadingChar=this.bLeadingZero?" ":"0";this.sLeadingRegexChar=this.bLeadingZero?"0":"\\s";z.setPlaceholderSymbol(w);C=C.replace(/hh/ig,"h").replace(/h/ig,"h9");if(this.b24H){F="["+this.sLeadingRegexChar+"012]";}else{F="["+this.sLeadingRegexChar+"1]";}this._maskRuleHours=new M({maskFormatSymbol:"h",regex:F});z.addRule(this._maskRuleHours);this.iHourNumber1Index=C.indexOf("h9");this.iHourNumber2Index=this.iHourNumber1Index!==-1?this.iHourNumber1Index+1:-1;this.iMinuteNumber1Index=C.indexOf("mm");C=C.replace(/mm/g,"59");this.iSecondNumber1Index=C.indexOf("ss");C=C.replace(/ss/g,"59");this._maskRuleMinSec=new M({maskFormatSymbol:"5",regex:"[0-5]"});z.addRule(this._maskRuleMinSec);this.aAllowedHours=U.call(this,this.b24H,this.sLeadingChar);this.aAllowedMinutesAndSeconds=V.call(this);this.iAmPmChar1Index=C.indexOf("a");this.iAfterAmPmValueIndex=-1;if(this.iAmPmChar1Index!==-1){this.iAfterAmPmValueIndex=this.iAmPmChar1Index+this.iAmPmValueMaxLength;var H=this.iAmPmValueMaxLength-"a".length;this.shiftIndexes(H);var J=65;var N="";var O="";var Q="";for(i=0;i<this.iAmPmValueMaxLength;i++){O="[";if(this.aAmPmValues[0][i]){O+=this.aAmPmValues[0][i];}else{O+="\\s";}if(this.aAmPmValues[1][i]!==this.aAmPmValues[0][i]){if(this.aAmPmValues[1][i]){O+=this.aAmPmValues[1][i];}else{O+="\\s";}}O+="]";Q=String.fromCharCode(J++);N+=Q;this._maskRuleChars=new M({maskFormatSymbol:Q,regex:O});z.addRule(this._maskRuleChars);}C=C.replace(/a/g,N);}z.setMask(C);function S(W,X,Y){var Z=[],$,i;for(i=W;i<=X;i++){$=i.toString();if(i<10){$=Y+$;}Z.push($);}return Z;}function U(W,X){var Y=W?0:1,Z=this._oTimePicker.getSupport2400()?24:23,$=W?Z:12;return S(Y,$,X);}function V(){return S(0,59,"0");}};x.prototype.replaceChar=function(C,z,A){var F=z-this.iAmPmChar1Index,G,H,J,S,N,O,i;if(z===this.iHourNumber1Index&&this.sAlternativeLeadingChar===C){if(this.aAllowedHours.indexOf(this.sLeadingChar+C)!==-1){return this.sLeadingChar+C;}else{return this.sLeadingChar;}}else if(z===this.iHourNumber1Index&&!this._oTimePicker._isCharAllowed(C,z)&&this.aAllowedHours.indexOf(this.sLeadingChar+C)!==-1){return this.sLeadingChar+C;}else if(z===this.iHourNumber2Index&&A[this.iHourNumber1Index]===w){this._oTimePicker._oTempValue.setCharAt(this.sLeadingChar,this.iHourNumber1Index);return C;}else if(z===this.iHourNumber2Index&&this.aAllowedHours.indexOf(A[this.iHourNumber1Index]+C)===-1){return"";}else if((z===this.iMinuteNumber1Index||z===this.iSecondNumber1Index)&&!this._oTimePicker._isCharAllowed(C,z)&&this.aAllowedMinutesAndSeconds.indexOf("0"+C)!==-1){return"0"+C;}else if(F>=0&&z<this.iAfterAmPmValueIndex){G=A.slice(this.iAmPmChar1Index,z);H=this.aAmPmValues[0].slice(0,F);J=this.aAmPmValues[1].slice(0,F);N=this.aAmPmValues[0].slice(F,this.iAfterAmPmValueIndex);O=this.aAmPmValues[1].slice(F,this.iAfterAmPmValueIndex);S=(H===J);var Q="";for(i=F;i<this.iAmPmValueMaxLength;i++){if(this.aAmPmValues[0][i]===this.aAmPmValues[1][i]){Q+=this.aAmPmValues[0][i];}else{break;}}if(i===this.iAmPmValueMaxLength||i!==F){return Q;}else{if(!S){if(G===H){return N;}else if(G===J){return O;}else{return C;}}else{if(this.aAmPmValues[0][F].toLowerCase()===C.toLowerCase()&&this.aAmPmValues[0]===G+N){return N;}else if(this.aAmPmValues[1][F].toLowerCase()===C.toLowerCase()&&this.aAmPmValues[1]===G+O){return O;}else{return C;}}}}else{return C;}};x.prototype.formatValueWithLeadingTrailingSpaces=function(i){var z=this._oTimePicker.getMask().length;if(this.aOriginalAmPmValues[0]!==this.aAmPmValues[0]){i=i.replace(this.aOriginalAmPmValues[0],this.aAmPmValues[0]);}if(this.aOriginalAmPmValues[1]!==this.aAmPmValues[1]){i=i.replace(this.aOriginalAmPmValues[1],this.aAmPmValues[1]);}while(z>i.length){i=[i.slice(0,this.iHourNumber1Index)," ",i.slice(this.iHourNumber1Index)].join('');}return i;};x.prototype.stripValueOfLeadingSpaces=function(i){if(i[this.iHourNumber1Index]===" "){i=[i.slice(0,this.iHourNumber1Index),i.slice(this.iHourNumber1Index+1)].join('');}return i;};x.prototype.shiftIndexes=function(i){if(this.iAmPmChar1Index<this.iHourNumber1Index){this.iHourNumber1Index+=i;this.iHourNumber2Index+=i;}if(this.iAmPmChar1Index<this.iMinuteNumber1Index){this.iMinuteNumber1Index+=i;}if(this.iAmPmChar1Index<this.iSecondNumber1Index){this.iSecondNumber1Index+=i;}};x.prototype.destroy=function(){if(this._maskRuleHours){this._maskRuleHours.destroy();this._maskRuleHours=null;}if(this._maskRuleMinSec){this._maskRuleMinSec.destroy();this._maskRuleMinSec=null;}if(this._maskRuleChars){this._maskRuleChars.destroy();this._maskRuleChars=null;}};t.prototype._feedReplaceChar=function(C,i,z){return this._oTimeSemanticMaskHelper.replaceChar(C,i,z);};t.prototype._getAlteredUserInputValue=function(V){return V?this._formatValue(this._parseValue(V),true):V;};t.prototype.getAccessibilityInfo=function(){var i=this.getRenderer();var z=D.prototype.getAccessibilityInfo.apply(this,arguments);var V=this.getValue()||"";if(this._bValid){var A=this.getDateValue();if(A){V=this._formatValue(A);}}q.extend(true,z,{role:i.getAriaRole(this),type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_TIMEINPUT"),description:[V,i.getLabelledByAnnouncement(this),i.getDescribedByAnnouncement(this)].join(" ").trim(),autocomplete:"none",expanded:false,haspopup:true,owns:this.getId()+"-clocks"});return z;};function y(){var i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),z=j.getInstance(i);return z.getTimePattern(u.Medium);}t.prototype._revertKey=function(i,S){S=S||this._getTextSelection();var z=S.iFrom,A=S.iTo,C=z,F,G;if(!S.bHasSelection){if(i.bBackspace){C=z=this._oRules.previousTo(z);}else if(i.bDelete){F=this.getPlaceholderSymbol();G=this._oTempValue._aContent.length;while((this._oTempValue._aContent[z]===F||this._oTempValue._aInitial[z]!==F)&&z<G){z++;}A=z;}}if(i.bBackspace||(i.bDelete&&S.bHasSelection)){A=A-1;}this._resetTempValue(z,A);this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(Math.max(this._iUserInputStartPosition,C));};t._PICKER_CONTENT_HEIGHT="25rem";return t;});
