/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./BarInPageEnabler','./ToolbarLayoutData','./ToolbarSpacer','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator',"sap/ui/events/KeyCodes",'./ToolbarRenderer',"sap/ui/core/library"],function(B,T,a,l,C,E,K,b,c){"use strict";var d=l.ToolbarDesign,e=l.ToolbarStyle;var f=C.extend("sap.m.Toolbar",{metadata:{interfaces:["sap.ui.core.Toolbar","sap.m.IBar"],library:"sap.m",properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},active:{type:"boolean",group:"Behavior",defaultValue:false},enabled:{type:"boolean",group:"Behavior",defaultValue:true},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:''},design:{type:"sap.m.ToolbarDesign",group:"Appearance",defaultValue:d.Auto},style:{type:"sap.m.ToolbarStyle",group:"Appearance",defaultValue:e.Standard},ariaHasPopup:{type:"string",group:"Accessibility",defaultValue:null}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{parameters:{srcControl:{type:"sap.ui.core.Control"}}}},designtime:"sap/m/designtime/Toolbar.designtime"}});E.call(f.prototype);f.shrinkClass="sapMTBShrinkItem";f.isRelativeWidth=function(w){return/^([-+]?\d+%|auto|inherit|)$/i.test(w);};f.getOrigWidth=function(i){var o=sap.ui.getCore().byId(i);if(!o||!o.getWidth){return"";}return o.getWidth();};f.checkShrinkable=function(o,s){if(o instanceof a){return this.isRelativeWidth(o.getWidth());}s=s||this.shrinkClass;o.removeStyleClass(s);var w=this.getOrigWidth(o.getId());if(!this.isRelativeWidth(w)){return;}var L=o.getLayoutData();if(L instanceof T){return L.getShrinkable()&&o.addStyleClass(s);}if(w.indexOf("%")>0||o.getMetadata().isInstanceOf("sap.ui.core.IShrinkable")){return o.addStyleClass(s);}var D=o.getDomRef();if(D&&(D.firstChild||{}).nodeType==3){return o.addStyleClass(s);}};f.prototype._setEnableAccessibilty=function(g){var F=g?"true":"false",r=g?"toolbar":"none";this.data("sap-ui-fastnavgroup",F,g);this._setRootAccessibilityRole(r);return this;};f.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);this._oContentDelegate={onAfterRendering:this._onAfterContentRendering};};f.prototype.onAfterRendering=function(){this._checkContents();};f.prototype.onLayoutDataChange=function(){this.rerender();};f.prototype.addContent=function(o){this.addAggregation("content",o);this._onContentInserted(o);return this;};f.prototype.insertContent=function(o,i){this.insertAggregation("content",o,i);this._onContentInserted(o);return this;};f.prototype.removeContent=function(v){v=this.removeAggregation("content",v);this._onContentRemoved(v);return v;};f.prototype.removeAllContent=function(){var g=this.removeAllAggregation("content")||[];g.forEach(this._onContentRemoved,this);return g;};f.prototype.ontap=function(o){if(this.getActive()&&!o.isMarked()){o.setMarked();this.firePress({srcControl:o.srcControl});}};f.prototype.onsapenter=function(o){if(this.getActive()&&o.srcControl===this&&!o.isMarked()){o.setMarked();this.firePress({srcControl:this});}};f.prototype.onsapspace=function(o){if(o.srcControl===this){o.preventDefault();}};f.prototype.onkeyup=function(o){if(o.which===K.SPACE){this.onsapenter(o);}};f.prototype.ontouchstart=function(o){this.getActive()&&o.setMarked();};f.prototype._checkContents=function(){this.getContent().forEach(function(o){f.checkShrinkable(o);});};f.prototype._onContentInserted=function(o){if(o){o.attachEvent("_change",this._onContentPropertyChanged,this);o.addEventDelegate(this._oContentDelegate,o);}};f.prototype._onContentRemoved=function(o){if(o){o.detachEvent("_change",this._onContentPropertyChanged,this);o.removeEventDelegate(this._oContentDelegate,o);}};f.prototype._onAfterContentRendering=function(){var L=this.getLayoutData();if(L instanceof T){L.applyProperties();}};f.prototype._onContentPropertyChanged=function(o){if(o.getParameter("name")!="width"){return;}var g=o.getSource();var p=g.getWidth().indexOf("%")>0;g.toggleStyleClass(f.shrinkClass,p);};f.prototype._getAccessibilityRole=function(){var r=this._getRootAccessibilityRole();if(this.getActive()){r="button";}return r;};f.prototype.setDesign=function(D,s){if(!s){return this.setProperty("design",D);}this._sAutoDesign=this.validateProperty("design",D);return this;};f.prototype.getActiveDesign=function(){var D=this.getDesign();if(D!=d.Auto){return D;}return this._sAutoDesign||D;};f.prototype.getTitleControl=function(){var g=sap.ui.require("sap/m/Title");if(!g){return;}var h=this.getContent();for(var i=0;i<h.length;i++){var o=h[i];if(o instanceof g&&o.getVisible()){return o;}}};f.prototype.getTitleId=function(){var t=this.getTitleControl();return t?t.getId():"";};f.prototype.isContextSensitive=B.prototype.isContextSensitive;f.prototype.setHTMLTag=B.prototype.setHTMLTag;f.prototype.getHTMLTag=B.prototype.getHTMLTag;f.prototype.applyTagAndContextClassFor=B.prototype.applyTagAndContextClassFor;f.prototype._applyContextClassFor=B.prototype._applyContextClassFor;f.prototype._applyTag=B.prototype._applyTag;f.prototype._getContextOptions=B.prototype._getContextOptions;f.prototype._setRootAccessibilityRole=B.prototype._setRootAccessibilityRole;f.prototype._getRootAccessibilityRole=B.prototype._getRootAccessibilityRole;f.prototype._setRootAriaLevel=B.prototype._setRootAriaLevel;f.prototype._getRootAriaLevel=B.prototype._getRootAriaLevel;return f;});
