ace.define("ace/mode/haskell_highlight_rules",[],function(r,e,m){"use strict";var o=r("../lib/oop");var T=r("./text_highlight_rules").TextHighlightRules;var H=function(){this.$rules={start:[{token:['punctuation.definition.entity.haskell','keyword.operator.function.infix.haskell','punctuation.definition.entity.haskell'],regex:'(`)([a-zA-Z_\']*?)(`)',comment:'In case this regex seems unusual for an infix operator, note that Haskell allows any ordinary function application (elem 4 [1..10]) to be rewritten as an infix expression (4 `elem` [1..10]).'},{token:'constant.language.unit.haskell',regex:'\\(\\)'},{token:'constant.language.empty-list.haskell',regex:'\\[\\]'},{token:'keyword.other.haskell',regex:'\\b(module|signature)\\b',push:[{token:'keyword.other.haskell',regex:'\\bwhere\\b',next:'pop'},{include:'#module_name'},{include:'#module_exports'},{token:'invalid',regex:'[a-z]+'},{defaultToken:'meta.declaration.module.haskell'}]},{token:'keyword.other.haskell',regex:'\\bclass\\b',push:[{token:'keyword.other.haskell',regex:'\\bwhere\\b',next:'pop'},{token:'support.class.prelude.haskell',regex:'\\b(?:Monad|Functor|Eq|Ord|Read|Show|Num|(?:Frac|Ra)tional|Enum|Bounded|Real(?:Frac|Float)?|Integral|Floating)\\b'},{token:'entity.other.inherited-class.haskell',regex:'[A-Z][A-Za-z_\']*'},{token:'variable.other.generic-type.haskell',regex:'\\b[a-z][a-zA-Z0-9_\']*\\b'},{defaultToken:'meta.declaration.class.haskell'}]},{token:'keyword.other.haskell',regex:'\\binstance\\b',push:[{token:'keyword.other.haskell',regex:'\\bwhere\\b|$',next:'pop'},{include:'#type_signature'},{defaultToken:'meta.declaration.instance.haskell'}]},{token:'keyword.other.haskell',regex:'import',push:[{token:'meta.import.haskell',regex:'$|;|^',next:'pop'},{token:'keyword.other.haskell',regex:'qualified|as|hiding'},{include:'#module_name'},{include:'#module_exports'},{defaultToken:'meta.import.haskell'}]},{token:['keyword.other.haskell','meta.deriving.haskell'],regex:'(deriving)(\\s*\\()',push:[{token:'meta.deriving.haskell',regex:'\\)',next:'pop'},{token:'entity.other.inherited-class.haskell',regex:'\\b[A-Z][a-zA-Z_\']*'},{defaultToken:'meta.deriving.haskell'}]},{token:'keyword.other.haskell',regex:'\\b(?:deriving|where|data|type|case|of|let|in|newtype|default)\\b'},{token:'keyword.operator.haskell',regex:'\\binfix[lr]?\\b'},{token:'keyword.control.haskell',regex:'\\b(?:do|if|then|else)\\b'},{token:'constant.numeric.float.haskell',regex:'\\b(?:[0-9]+\\.[0-9]+(?:[eE][+-]?[0-9]+)?|[0-9]+[eE][+-]?[0-9]+)\\b',comment:'Floats are always decimal'},{token:'constant.numeric.haskell',regex:'\\b(?:[0-9]+|0(?:[xX][0-9a-fA-F]+|[oO][0-7]+))\\b'},{token:['meta.preprocessor.c','punctuation.definition.preprocessor.c','meta.preprocessor.c'],regex:'^(\\s*)(#)(\\s*\\w+)',comment:'In addition to Haskell\'s "native" syntax, GHC permits the C preprocessor to be run on a source file.'},{include:'#pragma'},{token:'punctuation.definition.string.begin.haskell',regex:'"',push:[{token:'punctuation.definition.string.end.haskell',regex:'"',next:'pop'},{token:'constant.character.escape.haskell',regex:'\\\\(?:NUL|SOH|STX|ETX|EOT|ENQ|ACK|BEL|BS|HT|LF|VT|FF|CR|SO|SI|DLE|DC1|DC2|DC3|DC4|NAK|SYN|ETB|CAN|EM|SUB|ESC|FS|GS|RS|US|SP|DEL|[abfnrtv\\\\\\"\'\\&])'},{token:'constant.character.escape.octal.haskell',regex:'\\\\o[0-7]+|\\\\x[0-9A-Fa-f]+|\\\\[0-9]+'},{token:'constant.character.escape.control.haskell',regex:'\\^[A-Z@\\[\\]\\\\\\^_]'},{defaultToken:'string.quoted.double.haskell'}]},{token:['punctuation.definition.string.begin.haskell','string.quoted.single.haskell','constant.character.escape.haskell','constant.character.escape.octal.haskell','constant.character.escape.hexadecimal.haskell','constant.character.escape.control.haskell','punctuation.definition.string.end.haskell'],regex:'(\')(?:([\\ -\\[\\]-~])|(\\\\(?:NUL|SOH|STX|ETX|EOT|ENQ|ACK|BEL|BS|HT|LF|VT|FF|CR|SO|SI|DLE|DC1|DC2|DC3|DC4|NAK|SYN|ETB|CAN|EM|SUB|ESC|FS|GS|RS|US|SP|DEL|[abfnrtv\\\\\\"\'\\&]))|(\\\\o[0-7]+)|(\\\\x[0-9A-Fa-f]+)|(\\^[A-Z@\\[\\]\\\\\\^_]))(\')'},{token:['meta.function.type-declaration.haskell','entity.name.function.haskell','meta.function.type-declaration.haskell','keyword.other.double-colon.haskell'],regex:'^(\\s*)([a-z_][a-zA-Z0-9_\']*|\\([|!%$+\\-.,=</>]+\\))(\\s*)(::)',push:[{token:'meta.function.type-declaration.haskell',regex:'$',next:'pop'},{include:'#type_signature'},{defaultToken:'meta.function.type-declaration.haskell'}]},{token:'support.constant.haskell',regex:'\\b(?:Just|Nothing|Left|Right|True|False|LT|EQ|GT|\\(\\)|\\[\\])\\b'},{token:'constant.other.haskell',regex:'\\b[A-Z]\\w*\\b'},{include:'#comments'},{token:'support.function.prelude.haskell',regex:'\\b(?:abs|acos|acosh|all|and|any|appendFile|applyM|asTypeOf|asin|asinh|atan|atan2|atanh|break|catch|ceiling|compare|concat|concatMap|const|cos|cosh|curry|cycle|decodeFloat|div|divMod|drop|dropWhile|elem|encodeFloat|enumFrom|enumFromThen|enumFromThenTo|enumFromTo|error|even|exp|exponent|fail|filter|flip|floatDigits|floatRadix|floatRange|floor|fmap|foldl|foldl1|foldr|foldr1|fromEnum|fromInteger|fromIntegral|fromRational|fst|gcd|getChar|getContents|getLine|head|id|init|interact|ioError|isDenormalized|isIEEE|isInfinite|isNaN|isNegativeZero|iterate|last|lcm|length|lex|lines|log|logBase|lookup|map|mapM|mapM_|max|maxBound|maximum|maybe|min|minBound|minimum|mod|negate|not|notElem|null|odd|or|otherwise|pi|pred|print|product|properFraction|putChar|putStr|putStrLn|quot|quotRem|read|readFile|readIO|readList|readLn|readParen|reads|readsPrec|realToFrac|recip|rem|repeat|replicate|return|reverse|round|scaleFloat|scanl|scanl1|scanr|scanr1|seq|sequence|sequence_|show|showChar|showList|showParen|showString|shows|showsPrec|significand|signum|sin|sinh|snd|span|splitAt|sqrt|subtract|succ|sum|tail|take|takeWhile|tan|tanh|toEnum|toInteger|toRational|truncate|uncurry|undefined|unlines|until|unwords|unzip|unzip3|userError|words|writeFile|zip|zip3|zipWith|zipWith3)\\b'},{include:'#infix_op'},{token:'keyword.operator.haskell',regex:'[|!%$?~+:\\-.=</>\\\\]+',comment:'In case this regex seems overly general, note that Haskell permits the definition of new operators which can be nearly any string of punctuation characters, such as $%^&*.'},{token:'punctuation.separator.comma.haskell',regex:','}],'#block_comment':[{token:'punctuation.definition.comment.haskell',regex:'\\{-(?!#)',push:[{include:'#block_comment'},{token:'punctuation.definition.comment.haskell',regex:'-\\}',next:'pop'},{defaultToken:'comment.block.haskell'}]}],'#comments':[{token:'punctuation.definition.comment.haskell',regex:'--.*',push_:[{token:'comment.line.double-dash.haskell',regex:'$',next:'pop'},{defaultToken:'comment.line.double-dash.haskell'}]},{include:'#block_comment'}],'#infix_op':[{token:'entity.name.function.infix.haskell',regex:'\\([|!%$+:\\-.=</>]+\\)|\\(,+\\)'}],'#module_exports':[{token:'meta.declaration.exports.haskell',regex:'\\(',push:[{token:'meta.declaration.exports.haskell.end',regex:'\\)',next:'pop'},{token:'entity.name.function.haskell',regex:'\\b[a-z][a-zA-Z_\']*'},{token:'storage.type.haskell',regex:'\\b[A-Z][A-Za-z_\']*'},{token:'punctuation.separator.comma.haskell',regex:','},{include:'#infix_op'},{token:'meta.other.unknown.haskell',regex:'\\(.*?\\)',comment:'So named because I don\'t know what to call this.'},{defaultToken:'meta.declaration.exports.haskell.end'}]}],'#module_name':[{token:'support.other.module.haskell',regex:'[A-Z][A-Za-z._\']*'}],'#pragma':[{token:'meta.preprocessor.haskell',regex:'\\{-#',push:[{token:'meta.preprocessor.haskell',regex:'#-\\}',next:'pop'},{token:'keyword.other.preprocessor.haskell',regex:'\\b(?:LANGUAGE|UNPACK|INLINE)\\b'},{defaultToken:'meta.preprocessor.haskell'}]}],'#type_signature':[{token:['meta.class-constraint.haskell','entity.other.inherited-class.haskell','meta.class-constraint.haskell','variable.other.generic-type.haskell','meta.class-constraint.haskell','keyword.other.big-arrow.haskell'],regex:'(\\(\\s*)([A-Z][A-Za-z]*)(\\s+)([a-z][A-Za-z_\']*)(\\)\\s*)(=>)'},{include:'#pragma'},{token:'keyword.other.arrow.haskell',regex:'->'},{token:'keyword.other.big-arrow.haskell',regex:'=>'},{token:'support.type.prelude.haskell',regex:'\\b(?:Int(?:eger)?|Maybe|Either|Bool|Float|Double|Char|String|Ordering|ShowS|ReadS|FilePath|IO(?:Error)?)\\b'},{token:'variable.other.generic-type.haskell',regex:'\\b[a-z][a-zA-Z0-9_\']*\\b'},{token:'storage.type.haskell',regex:'\\b[A-Z][a-zA-Z0-9_\']*\\b'},{token:'support.constant.unit.haskell',regex:'\\(\\)'},{include:'#comments'}]};this.normalizeRules();};H.metaData={fileTypes:['hs'],keyEquivalent:'^~H',name:'Haskell',scopeName:'source.haskell'};o.inherits(H,T);e.HaskellHighlightRules=H;});ace.define("ace/mode/folding/cstyle",[],function(r,e,a){"use strict";var o=r("../../lib/oop");var R=r("../../range").Range;var B=r("./fold_mode").FoldMode;var F=e.FoldMode=function(c){if(c){this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+c.start));this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+c.end));}};o.inherits(F,B);(function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/;this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/;this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/;this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/;this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/;this._getFoldWidgetBase=this.getFoldWidget;this.getFoldWidget=function(s,f,b){var l=s.getLine(b);if(this.singleLineBlockCommentRe.test(l)){if(!this.startRegionRe.test(l)&&!this.tripleStarBlockCommentRe.test(l))return"";}var c=this._getFoldWidgetBase(s,f,b);if(!c&&this.startRegionRe.test(l))return"start";return c;};this.getFoldWidgetRange=function(s,f,b,c){var l=s.getLine(b);if(this.startRegionRe.test(l))return this.getCommentRegionBlock(s,l,b);var m=l.match(this.foldingStartMarker);if(m){var i=m.index;if(m[1])return this.openingBracketBlock(s,m[1],b,i);var d=s.getCommentFoldRange(b,i+m[0].length,1);if(d&&!d.isMultiLine()){if(c){d=this.getSectionRange(s,b);}else if(f!="all")d=null;}return d;}if(f==="markbegin")return;var m=l.match(this.foldingStopMarker);if(m){var i=m.index+m[0].length;if(m[1])return this.closingBracketBlock(s,m[1],b,i);return s.getCommentFoldRange(b,i,-1);}};this.getSectionRange=function(s,b){var l=s.getLine(b);var c=l.search(/\S/);var d=b;var f=l.length;b=b+1;var g=b;var m=s.getLength();while(++b<m){l=s.getLine(b);var i=l.search(/\S/);if(i===-1)continue;if(c>i)break;var h=this.getFoldWidgetRange(s,"all",b);if(h){if(h.start.row<=d){break;}else if(h.isMultiLine()){b=h.end.row;}else if(c==i){break;}}g=b;}return new R(d,f,g,s.getLine(g).length);};this.getCommentRegionBlock=function(s,l,b){var c=l.search(/\s*$/);var d=s.getLength();var f=b;var g=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/;var h=1;while(++b<d){l=s.getLine(b);var m=g.exec(l);if(!m)continue;if(m[1])h--;else h++;if(!h)break;}var i=b;if(i>f){return new R(f,c,i,l.length);}};}).call(F.prototype);});ace.define("ace/mode/haskell",[],function(r,e,m){"use strict";var o=r("../lib/oop");var T=r("./text").Mode;var H=r("./haskell_highlight_rules").HaskellHighlightRules;var F=r("./folding/cstyle").FoldMode;var M=function(){this.HighlightRules=H;this.foldingRules=new F();this.$behaviour=this.$defaultBehaviour;};o.inherits(M,T);(function(){this.lineCommentStart="--";this.blockComment=null;this.$id="ace/mode/haskell";this.snippetFileId="ace/snippets/haskell";}).call(M.prototype);e.Mode=M;});(function(){ace.require(["ace/mode/haskell"],function(m){if(typeof module=="object"&&typeof exports=="object"&&module){module.exports=m;}});})();
