/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./LabelEnablement','sap/ui/base/Object','sap/ui/performance/trace/Interaction','sap/base/util/uid',"sap/ui/util/ActivityDetection","sap/ui/thirdparty/jquery","sap/base/security/encodeXML","sap/base/security/encodeCSS","sap/base/assert","sap/ui/performance/Measurement","sap/base/Log","sap/base/util/extend","./InvisibleRenderer","./Patcher"],function(L,B,I,u,A,q,a,b,c,M,d,f,g,P){"use strict";var C=["renderControl","cleanupControlWithoutRendering","accessibilityState","icon"];var s=["write","writeEscaped","writeAcceleratorKey","writeControlData","writeElementData","writeAttribute","writeAttributeEscaped","addClass","writeClasses","addStyle","writeStyles","writeAccessibilityState","writeIcon","translate","getConfiguration","getHTML"];var D=["openStart","voidStart","attr","class","style","openEnd","voidEnd","text","unsafeHtml","close"];var n=["render","flush","destroy"];var t=document.createElement("template");var h="data-sap-ui-stylekey";function R(){var p=this,v,x,J,S,K,N,O="",V=false,Q,T="",U={},W={},X=[],Y=new P(),Z,$;this._setFocusHandler=function(e){c(e&&B.isA(e,'sap.ui.core.FocusHandler'),"oFocusHandler must be an sap.ui.core.FocusHandler");v=e;};function _(){c(!(Z=$=""));x=p.aBuffer=[];J=p.aRenderedControls=[];S=p.aStyleStack=[{}];Q=undefined;V=false;O="";}function a1(e,i){c(e&&typeof e=="string"&&/^[a-z_][a-zA-Z0-9_\-]*$/.test(e),"The "+i+" name provided '"+e+"' is not valid; it must contain alphanumeric characters, hyphens or underscores");}function b1(e){c(O,"There is no open tag; '"+e+"' must not be called without an open tag");}function c1(e){var i=(e===undefined)?!O:e;c(i,"There is an open tag; '"+O+"' tag has not yet ended with '"+(V?"voidEnd":"openEnd")+"'");}function d1(e){a1(e,"attr");c((e!="class"||$!="class"&&($="attr"))&&(e!="style"||Z!="style"&&(Z="attr")),"Attributes 'class' and 'style' must not be written when the methods with the same name"+" have been called for the same element already");}function e1(e){c($!="attr"&&($="class"),"Method class() must not be called after the 'class' attribute has been written for the same element");c(typeof e=="string"&&!/\s/.test(e)&&arguments.length===1,"Method 'class' must be called with exactly one class name");}function f1(e){c(Z!="attr"&&(Z="style"),"Method style() must not be called after the 'style' attribute has been written for the same element");c(e&&typeof e=="string"&&!/\s/.test(e),"Method 'style' must be called with a non-empty string name");}this.write=function(e){c((typeof e==="string")||(typeof e==="number"),"sText must be a string or number");x.push.apply(x,arguments);return this;};this.writeEscaped=function(e,i){if(e!=null){e=a(String(e));if(i){e=e.replace(/&#xa;/g,"<br>");}x.push(e);}return this;};this.writeAttribute=function(e,i){c(typeof e==="string","sName must be a string");c(typeof i==="string"||typeof i==="number"||typeof i==="boolean","value must be a string, number or boolean");x.push(" ",e,"=\"",i,"\"");return this;};this.writeAttributeEscaped=function(e,i){c(typeof e==="string","sName must be a string");x.push(" ",e,"=\"",a(String(i)),"\"");return this;};this.addStyle=function(e,i){c(typeof e==="string","sName must be a string");if(i!=null&&i!=""){c((typeof i==="string"||typeof i==="number"),"value must be a string or number");var j=S[S.length-1];if(!j.aStyle){j.aStyle=[];}j.aStyle.push(e+": "+i+";");}return this;};this.writeStyles=function(){var e=S[S.length-1];if(e.aStyle&&e.aStyle.length){this.writeAttribute(h,X.push(e.aStyle.join(" "))-1);}e.aStyle=null;return this;};this.addClass=function(e){if(e){c(typeof e==="string","sName must be a string");var i=S[S.length-1];if(!i.aClasses){i.aClasses=[];}i.aClasses.push(e);}return this;};this.writeClasses=function(e){c(!e||typeof e==="boolean"||B.isA(e,'sap.ui.core.Element'),"oElement must be empty, a boolean, or an sap.ui.core.Element");var i=S[S.length-1];var j;if(e){j=e.aCustomStyleClasses;}else if(e===false){j=[];}else{j=i.aCustomStyleClasses;}if(i.aClasses||j){var m1=[].concat(i.aClasses||[],j||[]);if(m1.length){this.writeAttribute("class",m1.join(" "));}}if(!e){i.aCustomStyleClasses=null;}i.aClasses=null;return this;};this.openStart=function(e,i){a1(e,"tag");c1();c(!(Z=$=""));O=e;this.write("<"+e);if(i){if(typeof i=="string"){this.attr("id",i);}else{this.writeElementData(i);}}return this;};this.openEnd=function(e){b1("openEnd");c1(!V);c(e===undefined||e===true,"The private parameter bExludeStyleClasses must be true or omitted!");O="";this.writeClasses(e===true?false:undefined);this.writeStyles();this.write(">");return this;};this.close=function(e){a1(e,"tag");c1();this.write("</"+e+">");return this;};this.voidStart=function(e,i){this.openStart(e,i);V=true;return this;};this.voidEnd=function(e){b1("voidEnd");c1(V||!O);V=false;O="";this.writeClasses(e?false:undefined);this.writeStyles();this.write(">");return this;};this.unsafeHtml=function(e){c1();this.write(e);return this;};this.text=function(e){c1();this.writeEscaped(e);return this;};this.attr=function(e,i){d1(e);if(e=="style"){S[S.length-1].aStyle=[i];}else{this.writeAttributeEscaped(e,i);}return this;};this.class=function(e){if(e){e1.apply(this,arguments);this.addClass(a(e));}return this;};this.style=function(e,i){f1(e);this.addStyle(e,i);return this;};this.accessibilityState=this.writeAccessibilityState;this.icon=this.writeIcon;W.openStart=function(e,i){a1(e,"tag");c1();c(!(Z=$=""));O=e;if(!i){Y.openStart(e);}else if(typeof i=="string"){Y.openStart(e,i);}else{Y.openStart(e,i.getId());F(this,i);}return this;};W.voidStart=function(e,i){this.openStart(e,i);V=true;return this;};W.attr=function(e,i){d1(e);b1("attr");Y.attr(e,i);return this;};W.class=function(e){if(e){e1.apply(this,arguments);b1("class");Y.class(e);}return this;};W.style=function(e,i){f1(e);b1("style");Y.style(e,i);return this;};W.openEnd=function(e){if(e!==true){var i=S[S.length-1];var j=i.aCustomStyleClasses;if(j){j.forEach(Y.class,Y);i.aCustomStyleClasses=null;}}b1("openEnd");c1(!V);c(e===undefined||e===true,"The private parameter bExludeStyleClasses must be true or omitted!");O="";Y.openEnd();return this;};W.voidEnd=function(e){if(!e){var i=S[S.length-1];var j=i.aCustomStyleClasses;if(j){j.forEach(Y.class,Y);i.aCustomStyleClasses=null;}}b1("voidEnd");c1(V||!O);V=false;O="";Y.voidEnd();return this;};W.text=function(e){c1();if(e!=null){Y.text(e);}return this;};W.unsafeHtml=function(e){c1();Y.unsafeHtml(e);return this;};W.close=function(e){a1(e,"tag");c1();Y.close(e);return this;};function g1(e){N=true;try{var i=new q.Event("BeforeRendering");i.srcControl=e;e._handleEvent(i);}finally{N=false;}}this.cleanupControlWithoutRendering=function(e){c(!e||B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control or empty");if(!e){return;}var i=e.getDomRef();if(i){g1(e);R.preserveContent(i,false,false);if(!i.hasAttribute(o)){e.bOutput=false;}}};this.renderControl=function(e){c(!e||B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control or empty");if(!e){return this;}if(!K){K=[];}if(K&&K.length>0){M.pause(K[0]+"---renderControl");}else if(e.getParent()&&e.getParent().getMetadata().getName()=="sap.ui.core.UIArea"){M.pause(e.getParent().getId()+"---rerender");}K.unshift(e.getId());M.start(e.getId()+"---renderControl","Rendering of "+e.getMetadata().getName(),["rendering","control"]);g1(e);M.pause(e.getId()+"---renderControl");var j;var m1=e.getMetadata();var n1=e.getVisible();if(n1){j=m1.getRenderer();}else{var o1=m1.getProperty("visible");var p1=o1&&o1._oParent&&o1._oParent.getName()=="sap.ui.core.Control";j=p1?g:m1.getRenderer();}M.resume(e.getId()+"---renderControl");var q1=e.aBindParameters,r1;if(q1&&q1.length>0&&(r1=e.getDomRef())){var s1=q(r1);for(var i=0;i<q1.length;i++){var t1=q1[i];s1.off(t1.sEventType,t1.fnProxy);}}if(j&&typeof j.render==="function"){if(x.length){Q=false;}else if(Q===undefined){if(R.getApiVersion(j)==2){r1=r1||e.getDomRef()||g.getDomRef(e);if(R.isPreservedContent(r1)){Q=false;}else{if(r1&&v){v.storePatchingControlFocusInfo(r1);}Y.setRootNode(r1);Q=true;}}else{Q=false;}}else if(!T&&Q){if(R.getApiVersion(j)!=2){T=e.getId();Q=false;}}var u1={};if(e.aCustomStyleClasses&&e.aCustomStyleClasses.length>0){u1.aCustomStyleClasses=e.aCustomStyleClasses;}S.push(u1);if(Q){var v1=Y.getCurrentNode();j.render(W,e);if(Y.getCurrentNode()==v1){Y.unsafeHtml("",e.getId());e.bOutput=false;}else{e.bOutput=true;}}else{var w1=x.length;j.render(U,e);e.bOutput=(x.length!==w1);}S.pop();if(T&&T===e.getId()){Y.unsafeHtml(x.join(""),T,k1);T="";Q=true;x=[];}}else{d.error("The renderer for class "+m1.getName()+" is not defined or does not define a render function! Rendering of "+e.getId()+" will be skipped!");}J.push(e);var x1=e.getUIArea();if(x1){x1._onControlRendered(e);}if(j===g){e.bOutput="invisible";}M.end(e.getId()+"---renderControl");K.shift();if(K&&K.length>0){M.resume(K[0]+"---renderControl");}else if(e.getParent()&&e.getParent().getMetadata().getName()=="sap.ui.core.UIArea"){M.resume(e.getParent().getId()+"---rerender");}return this;};this.getHTML=function(e){c(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control");var i=x;var j=x=this.aBuffer=[];this.renderControl(e);x=this.aBuffer=i;return j.join("");};function h1(m1){var i,n1=J.length;for(i=0;i<n1;i++){J[i]._sapui_bInAfterRenderingPhase=true;}N=true;try{for(i=0;i<n1;i++){var o1=J[i];if(o1.bOutput&&o1.bOutput!=="invisible"){var p1=new q.Event("AfterRendering");p1.srcControl=o1;M.start(o1.getId()+"---AfterRendering","AfterRendering of "+o1.getMetadata().getName(),["rendering","after"]);o1._handleEvent(p1);M.end(o1.getId()+"---AfterRendering");}}}finally{for(i=0;i<n1;i++){delete J[i]._sapui_bInAfterRenderingPhase;}N=false;}try{v.restoreFocus(m1);}catch(e){d.warning("Problems while restoring the focus after rendering: "+e,null);}for(i=0;i<n1;i++){var o1=J[i],q1=o1.aBindParameters,r1;if(q1&&q1.length>0&&(r1=o1.getDomRef())){var s1=q(r1);for(var j=0;j<q1.length;j++){var t1=q1[j];s1.on(t1.sEventType,t1.fnProxy);}}}}function i1(e,i,j){var m1;if(!Q){m1=v&&v.getControlFocusInfo();var n1=x.join("");if(n1&&X.length){if(j instanceof SVGElement&&j.localName!="foreignObject"){t.innerHTML="<svg>"+n1+"</svg>";t.replaceWith.apply(t.content.firstChild,t.content.firstChild.childNodes);}else{t.innerHTML=n1;}k1(t.content.childNodes);e(t.content);}else{e(n1);}}else{var o1=Y.getRootNode();if(o1.nodeType==11){m1=v&&v.getControlFocusInfo();e(o1.lastChild?o1:"");}else{m1=v&&v.getPatchingControlFocusInfo();}Y.reset();}h1(m1);_();A.refresh();if(i){i();}}function j1(e,i){var j=e.getAttribute(h);if(j!=i){return 0;}e.style=X[i];e.removeAttribute(h);return 1;}function k1(e){if(!X.length){return;}var i=0;e.forEach(function(j){if(j.nodeType==1){i+=j1(j,i);j.querySelectorAll("["+h+"]").forEach(function(m1){i+=j1(m1,i);});}});X=[];}this.flush=function(e,j,m1){c((typeof e==="object")&&(e.ownerDocument==document),"oTargetDomNode must be a DOM element");var n1=I.notifyAsyncStep();if(!j&&(typeof m1!=="number")&&!m1){R.preserveContent(e);}i1(function(o1){for(var i=0;i<J.length;i++){var p1=J[i].getDomRef();if(p1&&!R.isPreservedContent(p1)){if(R.isInlineTemplate(p1)){q(p1).empty();}else{q(p1).remove();}}}if(typeof m1==="number"){if(m1<=0){H(e,"prepend",o1);}else{var q1=e.children[m1-1];if(q1){H(q1,"after",o1);}else{H(e,"append",o1);}}}else if(!m1){q(e).html(o1);}else{H(e,"append",o1);}},n1,e);};this.render=function(e,i){c(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be a control");c(typeof i==="object"&&i.ownerDocument==document,"oTargetDomNode must be a DOM element");if(N){d.error("Render must not be called within Before or After Rendering Phase. Call ignored.",null,this);return;}var j=I.notifyAsyncStep();_();this.renderControl(e);i1(function(m1){if(e&&i){var n1=e.getDomRef();if(!n1||R.isPreservedContent(n1)){n1=g.getDomRef(e)||document.getElementById(k.Dummy+e.getId());}var o1=n1&&n1.parentNode!=i;if(o1){if(!R.isPreservedContent(n1)){if(R.isInlineTemplate(n1)){q(n1).empty();}else{q(n1).remove();}}if(m1){H(i,"append",m1);}}else{if(m1){if(n1){if(R.isInlineTemplate(n1)){q(n1).html(m1);}else{H(n1,"after",m1);q(n1).remove();}}else{H(i,"append",m1);}}else{if(R.isInlineTemplate(n1)){q(n1).empty();}else{if(!e.getParent()||!e.getParent()._onChildRerenderedEmpty||!e.getParent()._onChildRerenderedEmpty(e,n1)){q(n1).remove();}}}}}},j,i);};this.destroy=function(){_();};var l1={};C.forEach(function(e){U[e]=W[e]=l1[e]=this[e];},this);D.forEach(function(e){U[e]=l1[e]=this[e];},this);s.forEach(function(e){U[e]=l1[e]=this[e];},this);n.forEach(function(e){l1[e]=this[e];},this);this.getRendererInterface=function(){return U;};this.getInterface=function(){return l1;};_();}R.prototype.getConfiguration=function(){return sap.ui.getCore().getConfiguration();};R.prototype.translate=function(K){};R.prototype.writeAcceleratorKey=function(){return this;};R.prototype.writeControlData=function(e){c(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control");this.writeElementData(e);return this;};R.prototype.writeElementData=function(e){c(e&&B.isA(e,'sap.ui.core.Element'),"oElement must be an sap.ui.core.Element");this.attr("id",e.getId());F(this,e);return this;};R.prototype.writeAccessibilityState=function(e,j){if(!sap.ui.getCore().getConfiguration().getAccessibility()){return this;}if(arguments.length==1&&!(B.isA(e,'sap.ui.core.Element'))){j=e;e=null;}var J={};if(e!=null){var K=e.getMetadata();var N=function(i,v,V){var W=K.getProperty(i);if(W&&e[W._sGetter]()===V){J[v]="true";}};var O=function(v,V){var W=K.getAssociation(v);if(W&&W.multiple){var X=e[W._sGetter]();if(v=="ariaLabelledBy"){var Y=L.getReferencingLabels(e);var Z=Y.length;if(Z){var $=[];for(var i=0;i<Z;i++){if(X.indexOf(Y[i])<0){$.push(Y[i]);}}X=$.concat(X);}}if(X.length>0){J[V]=X.join(" ");}}};N("editable","readonly",false);N("enabled","disabled",false);N("visible","hidden",false);if(L.isRequired(e)){J["required"]="true";}N("selected","selected",true);N("checked","checked",true);O("ariaDescribedBy","describedby");O("ariaLabelledBy","labelledby");}if(j){var Q=function(v){var i=typeof(v);return v===null||i==="number"||i==="string"||i==="boolean";};var S={};var x,T,U;for(x in j){T=j[x];if(Q(T)){S[x]=T;}else if(typeof(T)==="object"&&Q(T.value)){U="";if(T.append&&(x==="describedby"||x==="labelledby")){U=J[x]?J[x]+" ":"";}S[x]=U+T.value;}}Object.assign(J,S);}if(B.isA(e,'sap.ui.core.Element')&&e.getParent()&&e.getParent().enhanceAccessibilityState){e.getParent().enhanceAccessibilityState(e,J);}for(var p in J){if(J[p]!=null&&J[p]!==""){this.attr(p==="role"?p:"aria-"+p,J[p]);}}return this;};R.prototype.writeIcon=function(U,e,i){var j=sap.ui.require("sap/ui/core/IconPool");if(!j){d.warning("Synchronous loading of IconPool due to sap.ui.core.RenderManager#icon call. "+"Ensure that 'sap/ui/core/IconPool is loaded before this function is called","SyncXHR",null,function(){return{type:"SyncXHR",name:"rendermanager-icon"};});j=sap.ui.requireSync("sap/ui/core/IconPool");}var p=j.isIconURI(U),v=false,x,J,K,N,O;if(typeof e==="string"){e=[e];}if(p){J=j.getIconInfo(U);if(!J){d.error("An unregistered icon: "+U+" is used in sap.ui.core.RenderManager's writeIcon method.");return this;}if(!e){e=[];}e.push("sapUiIcon");if(!J.suppressMirroring){e.push("sapUiIconMirrorInRTL");}}if(p){this.openStart("span");}else{this.voidStart("img");}if(Array.isArray(e)){e.forEach(function(Q){this.class(Q);},this);}if(p){K={"data-sap-ui-icon-content":J.content,"role":"presentation","title":J.text||null};this.style("font-family","'"+b(J.fontFamily)+"'");}else{K={role:"presentation",alt:"",src:U};}i=f(K,i);if(!i.id){i.id=u();}if(p){N=i.alt||i.title||J.text||J.name;O=i.id+"-label";if(i["aria-labelledby"]){v=true;i["aria-labelledby"]+=(" "+O);}else if(!i.hasOwnProperty("aria-label")){i["aria-label"]=N;}}if(typeof i==="object"){for(x in i){if(i.hasOwnProperty(x)&&i[x]!==null){this.attr(x,i[x]);}}}if(p){this.openEnd();if(v){this.openStart("span");this.style("display","none");this.attr("id",O);this.openEnd();this.text(N);this.close("span");}this.close("span");}else{this.voidEnd();}return this;};R.prototype.getRenderer=function(e){c(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control");return R.getRenderer(e);};var k=R.RenderPrefixes={Invisible:g.PlaceholderPrefix,Dummy:"sap-ui-dummy-",Temporary:"sap-ui-tmp-"};R.getRenderer=function(e){c(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control");return e.getMetadata().getRenderer();};R.forceRepaint=function(v){var e=v?window.document.getElementById(v):null;var i=typeof v=="string"?e:v;if(i){d.debug("forcing a repaint for "+(i.id||String(i)));var O=i.style.display;var j=document.activeElement;i.style.display="none";i.offsetHeight;i.style.display=O;if(document.activeElement!==j&&j){j.focus();}}};R.createInvisiblePlaceholderId=function(e){return g.createInvisiblePlaceholderId(e);};var l="sap-ui-preserve",m="sap-ui-static",o="data-sap-ui-preserve",r="data-sap-ui-area";function w(){var $=q(document.getElementById(l));if($.length===0){$=q("<div></div>",{"aria-hidden":"true",id:l}).addClass("sapUiHidden").addClass("sapUiForcedHidden").css("width","0").css("height","0").css("overflow","hidden").appendTo(document.body);}return $;}function y(e){q("<div></div>",{id:k.Dummy+e.id}).addClass("sapUiHidden").insertBefore(e);}var z=[];R.attachPreserveContent=function(e,i){R.detachPreserveContent(e);z.push({fn:e,context:i});};R.detachPreserveContent=function(e){z=z.filter(function(i){return i.fn!==e;});};R.preserveContent=function(e,p,j,v){c(typeof e==="object"&&e.ownerDocument==document,"oRootNode must be a DOM element");z.forEach(function(i){i.fn.call(i.context||R,{domNode:e});});var $=w();function x(i){while(i&&i!=e&&i.parentNode){i=i.parentNode;if(i.hasAttribute(o)){return true;}if(i.hasAttribute("data-sap-ui")){break;}}}function J(i,N,O){if(i===N){return true;}for(var Q=N.getParent();Q;Q=Q.isA("sap.ui.core.UIComponent")?Q.oContainer:Q.getParent()){if(Q.isA("sap.ui.core.Control")){if(!Q.getVisible()){return false;}var S=Q.getDomRef();if(S&&!S.contains(O)){return false;}}if(Q===i){return true;}}}function K(i){if(i.id===l||i.id===m){return;}var N=i.getAttribute(o);if(N){if(v){var O=sap.ui.getCore().byId(N);if(O&&J(v,O,i)){return;}}if(i===e||x(i)){y(i);}$.append(i);}else if(j&&i.id){R.markPreservableContent(q(i),i.id);$.append(i);return;}if(!i.hasAttribute(r)){var Q=i.firstChild;while(Q){i=Q;Q=Q.nextSibling;if(i.nodeType===1){K(i);}}}}M.start(e.id+"---preserveContent","preserveContent for "+e.id,["rendering","preserve"]);if(p){K(e);}else{q(e).children().each(function(i,N){K(N);});}M.end(e.id+"---preserveContent");};R.findPreservedContent=function(i){c(typeof i==="string","sId must be a string");var $=w(),e=$.children("["+o+"='"+i.replace(/(:|\.)/g,'\\$1')+"']");return e;};R.markPreservableContent=function($,i){$.attr(o,i);};R.isPreservedContent=function(e){return(e&&e.getAttribute(o)&&e.parentNode&&e.parentNode.id==l);};R.getPreserveAreaRef=function(){return w()[0];};var E="data-sap-ui-template";R.markInlineTemplate=function($){$.attr(E,"");};R.isInlineTemplate=function(e){return(e&&e.hasAttribute(E));};R.getApiVersion=function(e){if(e.hasOwnProperty("apiVersion")){return e.apiVersion;}return 1;};function F(e,i){var j=i.getId();e.attr("data-sap-ui",j);if(i.__slot){e.attr("slot",i.__slot);}i.getCustomData().forEach(function(x){var J=x._checkWriteToDom(i);if(J){e.attr(J.key.toLowerCase(),J.value);}});var p=i.getDragDropConfig().some(function(x){return x.isDraggable(i);});if(!p){var v=i.getParent();if(v&&v.getDragDropConfig){p=v.getDragDropConfig().some(function(x){return x.isDraggable(i);});}}if(p){e.attr("draggable","true");e.attr("data-sap-ui-draggable","true");}return this;}var G={before:"beforebegin",prepend:"afterbegin",append:"beforeend",after:"afterend"};function H(e,p,v){if(typeof v=="string"){e.insertAdjacentHTML(G[p],v);}else{e[p](v);}}return R;},true);
