/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/XMLCompositeMetadata','sap/ui/model/base/ManagedObjectModel','sap/ui/core/Fragment','sap/ui/model/resource/ResourceModel','sap/base/Log','sap/ui/performance/Measurement'],function(C,X,M,F,R,L,a){"use strict";var x="sap.ui.core.XMLComposite";var b=C.extend("sap.ui.core.XMLComposite",{metadata:{interfaces:["sap.ui.core.IDScope"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%',invalidate:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null,invalidate:true},displayBlock:{type:"boolean",group:"Appearance",defaultValue:true,invalidate:true}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden",invalidate:true}}},constructor:function(){this._bIsCreating=true;C.apply(this,arguments);delete this._bIsCreating;},renderer:{apiVersion:2,render:function(r,c){L.debug("Start rendering '"+c.sId,x);a.start(c.getId()+"---renderControl","Rendering of "+c.getMetadata().getName(),["rendering","control"]);r.openStart("div",c);r.accessibilityState(c);if(!c.getDisplayBlock()&&(c.getWidth()!=="100%"||c.getHeight()!=="100%")){r.style("display","inline-block");}r.style("height",c.getHeight());r.style("width",c.getWidth());r.openEnd();var o=c._renderingContent?c._renderingContent():c._getCompositeAggregation();if(o){r.renderControl(o);}r.close("div");a.end(c.getId()+"---renderControl");L.debug("Stop rendering '"+c.sId,x);}}},X);b.prototype.byId=function(i){return sap.ui.getCore().byId(F.createId(this.getId(),i));};b.prototype._getManagedObjectModel=function(){if(!this._oManagedObjectModel){this._oManagedObjectModel=new M(this);}return this._oManagedObjectModel;};b.prototype.getSuppressInvalidateAggregation=function(n,s){var m=this.getMetadata(),A=m.getAggregation(n)||m.getAllPrivateAggregations()[n];if(!A){return true;}s=m._suppressInvalidate(A,s);return s;};b.prototype.setProperty=function(n,v,s){var m=this.getMetadata(),p=m.getManagedProperty(n);if(!p){return this;}s=m._suppressInvalidate(p,s);return C.prototype.setProperty.apply(this,[n,v,s]);};b.prototype.setAggregation=function(n,o,s){return C.prototype.setAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};b.prototype.addAggregation=function(n,o,s){return C.prototype.addAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};b.prototype.insertAggregation=function(n,o,i,s){return C.prototype.insertAggregation.apply(this,[n,o,i,this.getSuppressInvalidateAggregation(n,s)]);};b.prototype.removeAggregation=function(n,o,s){return C.prototype.removeAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};b.prototype.removeAllAggregation=function(n,s){return C.prototype.removeAllAggregation.apply(this,[n,this.getSuppressInvalidateAggregation(n,s)]);};b.prototype.destroyAggregation=function(n,s){return C.prototype.destroyAggregation.apply(this,[n,this.getSuppressInvalidateAggregation(n,s)]);};b.prototype.updateAggregation=function(n,s){var A=this.getMetadata().getAggregation(n);if(A&&A.type==="TemplateMetadataContext"){this.invalidate();return;}C.prototype.updateAggregation.apply(this,arguments);};b.prototype.setVisible=function(v){this.setProperty("visible",v);if(this.getParent()){this.getParent().invalidate();}return this;};b.prototype._destroyCompositeAggregation=function(){var c=this._getCompositeAggregation();if(c){c.destroy("KeepDom");}return this;};b.prototype.updateBindings=function(){if(this._bIsCreating){return;}var r=C.prototype.updateBindings.apply(this,arguments);for(var n in this.mBindingInfos){var A=this.getMetadata().getAggregation(n);if(A&&A.multiple&&!A._doesNotRequireFactory&&this.isBound(n)&&!this.getBinding(n)){this[A._sDestructor]();}}return r;};b.prototype._getCompositeAggregation=function(){var c=this.getMetadata().getCompositeAggregationName();return this.getAggregation(c);};b.prototype._setCompositeAggregation=function(n){var c=this.getMetadata().getCompositeAggregationName();this._destroyCompositeAggregation();if(!this._oManagedObjectModel){this._getManagedObjectModel();}if(Array.isArray(n)){this.setAggregation(c,null);return;}if(n){if(!n.enhanceAccessibilityState){n.enhanceAccessibilityState=function(e,A){this.enhanceAccessibilityState(e,A);}.bind(this);}n.bindObject("$"+this.alias+">/");n.setModel(this._oManagedObjectModel,"$"+this.alias);if(this.bUsesI18n){var r=this._getResourceModel();if(r){n.setModel(r,"$"+this.alias+".i18n");}}}this.setAggregation(c,n);};b.mResourceModels={};b.getLibraryResourceModel=function(l){var o=b.mResourceModels[l];if(!o){o=new R({bundleName:l+".messagebundle",async:true});b.mResourceModels[l]=o;}return o;};b.prototype._getResourceModel=function(){if(this.resourceModel){return this.resourceModel;}if(this.messageBundle){this.resourceModel=new R({bundleName:this.messageBundle,async:true});return this.resourceModel;}else{this.sLibraryName=this.sLibraryName||this.getMetadata().getLibraryName();if(this.sLibraryName){return b.getLibraryResourceModel(this.sLibraryName);}}};b.prototype.getResourceBundle=function(){var r=this._getResourceModel();return r?r.getResourceBundle():null;};b.prototype.destroy=function(){C.prototype.destroy.apply(this,arguments);if(this.resourceModel){this.resourceModel.destroy();}if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();}};b.prototype._initCompositeSupport=function(s){var m=this.getMetadata(),f=m._fragment,A=m.getCompositeAggregationName();this._destroyCompositeAggregation();if(s&&A&&s[A]){var n=s[A];if(n.localName==="FragmentDefinition"){f=n;delete s[A];}}var c=f?(new XMLSerializer()).serializeToString(f):undefined;this.bUsesI18n=c?(c.indexOf("$"+this.alias+".i18n")!=-1):true;this._setCompositeAggregation(sap.ui.xmlfragment({sId:this.getId(),fragmentContent:f,oController:this}));this._bIsInitialized=true;};b.prototype.enhanceAccessibilityState=function(e,A){var p=this.getParent();if(p&&p.enhanceAccessibilityState){p.enhanceAccessibilityState(this,A);}};b.prototype.getFocusDomRef=function(){var c=this._renderingContent?this._renderingContent():this._getCompositeAggregation();return c.getFocusDomRef();};b.prototype.getFocusInfo=function(){var c=this._renderingContent?this._renderingContent():this._getCompositeAggregation();return c.getFocusInfo();};b.prototype.getIdForLabel=function(){var c=this._renderingContent?this._renderingContent():this._getCompositeAggregation();return c.getIdForLabel();};return b;});
