/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/Object','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/base/Log','sap/base/assert','sap/base/util/extend'],function(B,L,a,b,c,e){"use strict";var N=B.extend("sap.ui.core.format.NumberFormat",{constructor:function(F){throw new Error();}});var r=/0+(\.0+)?/;var d=/^0+$/;var n={INTEGER:"integer",FLOAT:"float",CURRENCY:"currency",UNIT:"unit",PERCENT:"percent"};var R={FLOOR:"FLOOR",CEILING:"CEILING",TOWARDS_ZERO:"TOWARDS_ZERO",AWAY_FROM_ZERO:"AWAY_FROM_ZERO",HALF_FLOOR:"HALF_FLOOR",HALF_CEILING:"HALF_CEILING",HALF_TOWARDS_ZERO:"HALF_TOWARDS_ZERO",HALF_AWAY_FROM_ZERO:"HALF_AWAY_FROM_ZERO"};var m={};m[R.FLOOR]=Math.floor;m[R.CEILING]=Math.ceil;m[R.TOWARDS_ZERO]=function(i){return i>0?Math.floor(i):Math.ceil(i);};m[R.AWAY_FROM_ZERO]=function(i){return i>0?Math.ceil(i):Math.floor(i);};m[R.HALF_TOWARDS_ZERO]=function(i){return i>0?Math.ceil(i-0.5):Math.floor(i+0.5);};m[R.HALF_AWAY_FROM_ZERO]=function(i){return i>0?Math.floor(i+0.5):Math.ceil(i-0.5);};m[R.HALF_FLOOR]=function(i){return Math.ceil(i-0.5);};m[R.HALF_CEILING]=Math.round;N.RoundingMode=R;N.oDefaultIntegerFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:0,groupingEnabled:false,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:true,type:n.INTEGER,showMeasure:false,style:"standard",showNumber:true,parseAsString:false,preserveDecimals:false,roundingMode:N.RoundingMode.TOWARDS_ZERO,emptyString:NaN,showScale:true};N.oDefaultFloatFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.FLOAT,showMeasure:false,style:"standard",showNumber:true,parseAsString:false,preserveDecimals:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultPercentFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",percentSign:"%",isInteger:false,type:n.PERCENT,showMeasure:false,style:"standard",showNumber:true,parseAsString:false,preserveDecimals:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultCurrencyFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.CURRENCY,showMeasure:true,currencyCode:true,currencyContext:'standard',style:"standard",showNumber:true,customCurrencies:undefined,parseAsString:false,preserveDecimals:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true,ignorePrecision:true};N.oDefaultUnitFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.UNIT,showMeasure:true,style:"standard",showNumber:true,customUnits:undefined,allowedUnits:undefined,parseAsString:false,preserveDecimals:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.getInstance=function(F,i){return this.getFloatInstance(F,i);};N.getFloatInstance=function(F,i){var w=this.createInstance(F,i),x=this.getLocaleFormatOptions(w.oLocaleData,n.FLOAT);w.oFormatOptions=e({},this.oDefaultFloatFormat,x,F);return w;};N.getIntegerInstance=function(F,i){var w=this.createInstance(F,i),x=this.getLocaleFormatOptions(w.oLocaleData,n.INTEGER);w.oFormatOptions=e({},this.oDefaultIntegerFormat,x,F);return w;};N.getCurrencyInstance=function(F,i){var w=this.createInstance(F,i);var C=F&&F.currencyContext;var S=h(F);if(S){C=C||this.oDefaultCurrencyFormat.style;C="sap-"+C;}var x=this.getLocaleFormatOptions(w.oLocaleData,n.CURRENCY,C);w.oFormatOptions=e({},this.oDefaultCurrencyFormat,x,F);w.oFormatOptions.trailingCurrencyCode=S;w._defineCustomCurrencySymbols();return w;};N.getUnitInstance=function(F,i){var w=this.createInstance(F,i),x=this.getLocaleFormatOptions(w.oLocaleData,n.UNIT);w.oFormatOptions=e({},this.oDefaultUnitFormat,x,F);return w;};N.getPercentInstance=function(F,i){var w=this.createInstance(F,i),x=this.getLocaleFormatOptions(w.oLocaleData,n.PERCENT);w.oFormatOptions=e({},this.oDefaultPercentFormat,x,F);return w;};N.createInstance=function(F,i){var w=Object.create(this.prototype),P;if(F instanceof L){i=F;F=undefined;}if(!i){i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}w.oLocale=i;w.oLocaleData=a.getInstance(i);w.oOriginalFormatOptions=F;if(F){if(F.pattern){P=this.parseNumberPattern(F.pattern);Object.keys(P).forEach(function(x){F[x]=P[x];});}if(F.emptyString!==undefined){c(F.emptyString===""||F.emptyString===0||F.emptyString===null||F.emptyString!==F.emptyString,"The format option 'emptyString' must be either 0, null or NaN");}}return w;};N.getDefaultUnitPattern=function(S){return"{0} "+S;};N.getLocaleFormatOptions=function(i,T,C){var w,x;switch(T){case n.PERCENT:x=i.getPercentPattern();break;case n.CURRENCY:x=i.getCurrencyPattern(C);break;case n.UNIT:x=i.getDecimalPattern();break;default:x=i.getDecimalPattern();}w=this.parseNumberPattern(x);w.plusSign=i.getNumberSymbol("plusSign");w.minusSign=i.getNumberSymbol("minusSign");w.decimalSeparator=i.getNumberSymbol("decimal");w.groupingSeparator=i.getNumberSymbol("group");w.percentSign=i.getNumberSymbol("percentSign");w.pattern=x;switch(T){case n.UNIT:case n.FLOAT:case n.PERCENT:w.minFractionDigits=0;w.maxFractionDigits=99;break;case n.INTEGER:w.minFractionDigits=0;w.maxFractionDigits=0;w.groupingEnabled=false;break;case n.CURRENCY:w.minFractionDigits=undefined;w.maxFractionDigits=undefined;break;}return w;};N.parseNumberPattern=function(F){var M=0,w=0,x=0,G=false,y=0,z=0,S=F.indexOf(";"),A={Integer:0,Fraction:1},C=A.Integer;if(S!==-1){F=F.substring(0,S);}for(var i=0;i<F.length;i++){var D=F[i];switch(D){case",":if(G){y=z;z=0;}G=true;break;case".":C=A.Fraction;break;case"0":if(C===A.Integer){M++;if(G){z++;}}else{w++;x++;}break;case"#":if(C===A.Integer){if(G){z++;}}else{x++;}break;}}if(!y){y=z;z=0;}return{minIntegerDigits:M,minFractionDigits:w,maxFractionDigits:x,groupingEnabled:G,groupingSize:y,groupingBaseSize:z};};N.prototype._defineCustomCurrencySymbols=function(){var O=this.oFormatOptions;var C=this.oLocaleData.getCurrencySymbols();var F=function(S,i){var U=[];var w;for(var K in S){w=S[K];if(U.indexOf(w)===-1){U.push(w);}else if(w!==undefined){i[w]=true;b.error("Symbol '"+w+"' is defined multiple times in custom currencies.",undefined,"NumberFormat");}}};if(O.customCurrencies&&typeof O.customCurrencies==="object"){this.mKnownCurrencySymbols={};this.mKnownCurrencyCodes={};Object.keys(O.customCurrencies).forEach(function(K){if(O.customCurrencies[K].symbol){this.mKnownCurrencySymbols[K]=O.customCurrencies[K].symbol;}else{var i=O.customCurrencies[K].isoCode;if(i){this.mKnownCurrencySymbols[K]=C[i];}}this.mKnownCurrencyCodes[K]=K;}.bind(this));}else{this.mKnownCurrencySymbols=C;this.mKnownCurrencyCodes=this.oLocaleData.getCustomCurrencyCodes();}this.mDuplicatedSymbols={};F(this.mKnownCurrencySymbols,this.mDuplicatedSymbols);};function s(i,w){if(i.indexOf(".")>=0&&!k(i)&&i.endsWith("0")){var F=i.length-i.lastIndexOf(".")-1;var x=F-w;if(x>0){while(i.endsWith("0")&&(x-->0)){i=i.substring(0,i.length-1);}if(i.endsWith(".")){i=i.substring(0,i.length-1);}}}return i;}N.prototype.format=function(V,M){if(Array.isArray(V)){M=V[1];V=V[0];}var i="",F="",G="",w="",x="",P="",y=0,z=0,A=0,C=0,D=V<0,E=-1,O=Object.assign({},this.oFormatOptions),H=this.oOriginalFormatOptions,I=O.type===n.CURRENCY&&M==="INR"&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",J,S,K,Q,U,T,W=V===undefined||V===null;if(O.showNumber&&(V===O.emptyString||(isNaN(V)&&isNaN(O.emptyString)))){return"";}if(M!==undefined&&M!==null&&typeof M!=="string"&&!(M instanceof String)){return"";}if(!O.showNumber&&!M){return"";}if(W&&(!M||!O.showMeasure||O.showNumber)){return"";}if(M&&O.customCurrencies&&!O.customCurrencies[M]){b.error("Currency '"+M+"' is unknown.");return"";}if(!O.showNumber&&!O.showMeasure){return"";}if(M&&O.type===n.UNIT){if(O.customUnits&&typeof O.customUnits==="object"){U=O.customUnits[M];}else{T=this.oLocaleData.getUnitFromMapping(M)||M;U=this.oLocaleData.getUnitFormat(T);}if(O.showMeasure){var X=!O.allowedUnits||O.allowedUnits.indexOf(M)>=0;if(!X){return"";}}if(!U&&!O.showNumber){return this._addOriginInfo(M);}O.decimals=(U&&(typeof U.decimals==="number"&&U.decimals>=0))?U.decimals:O.decimals;O.precision=(U&&(typeof U.precision==="number"&&U.precision>=0))?U.precision:O.precision;}if(O.type==n.CURRENCY){if(M&&O.trailingCurrencyCode){if(!this.mKnownCurrencyCodes[M]&&!/(^[A-Z]{3}$)/.test(M)){O.trailingCurrencyCode=false;O.pattern=this.oLocaleData.getCurrencyPattern(O.currencyContext);}}if(!O.showNumber){if(!O.currencyCode){var Y;if(O.customCurrencies&&typeof O.customCurrencies==="object"){Y=this.mKnownCurrencySymbols[M];}else{Y=this.oLocaleData.getCurrencySymbol(M);}if(Y&&Y!==M){M=Y;}}return M;}if(O.customCurrencies&&O.customCurrencies[M]){O.decimals=O.customCurrencies[M].decimals!==undefined?O.customCurrencies[M].decimals:O.decimals;}}if(O.decimals!==undefined){O.minFractionDigits=O.decimals;O.maxFractionDigits=O.decimals;}if(O.shortLimit===undefined||Math.abs(V)>=O.shortLimit){K=O.shortRefNumber===undefined?V:O.shortRefNumber;S=g(K,O,this.oLocaleData,I);if(S&&S.formatString!="0"){V=V/S.magnitude;if(O.shortDecimals!==undefined){O.minFractionDigits=O.shortDecimals;O.maxFractionDigits=O.shortDecimals;}else{if(H.minFractionDigits===undefined&&H.maxFractionDigits===undefined&&H.decimals===undefined&&H.precision===undefined&&H.pattern===undefined){O.precision=2;O.minFractionDigits=0;O.maxFractionDigits=99;}if(H.maxFractionDigits===undefined&&H.decimals===undefined){O.maxFractionDigits=99;}}O.roundingMode=N.RoundingMode.HALF_AWAY_FROM_ZERO;}}if((S||!O.ignorePrecision)&&O.precision!==undefined){O.maxFractionDigits=Math.min(O.maxFractionDigits,p(V,O.precision));O.minFractionDigits=Math.min(O.minFractionDigits,O.maxFractionDigits);}if(O.type==n.PERCENT){V=N._shiftDecimalPoint(V,2);}if(O.type==n.CURRENCY){var Z=this.oLocaleData.getCurrencyDigits(M);if(O.customCurrencies&&O.customCurrencies[M]&&O.customCurrencies[M].decimals!==undefined){Z=O.customCurrencies[M].decimals;}if(O.maxFractionDigits===undefined){O.maxFractionDigits=Z;}if(O.minFractionDigits===undefined){O.minFractionDigits=Z;}}if(typeof V==="number"&&!O.preserveDecimals){V=o(V,O.maxFractionDigits,O.roundingMode);}if(V==0){D=false;}if(O.preserveDecimals&&(typeof V==="string"||V instanceof String)){V=s(V,O.maxFractionDigits);}if(!W){x=this.convertToDecimal(V);}if(x=="NaN"){return x;}if(D){x=x.substr(1);}E=x.indexOf(".");if(E>-1){i=x.substr(0,E);F=x.substr(E+1);}else{i=x;}if(i.length<O.minIntegerDigits){i=i.padStart(O.minIntegerDigits,"0");}else if(i.length>O.maxIntegerDigits){i="".padStart(O.maxIntegerDigits,"?");}if(F.length<O.minFractionDigits){F=F.padEnd(O.minFractionDigits,"0");}else if(F.length>O.maxFractionDigits&&!O.preserveDecimals){F=F.substr(0,O.maxFractionDigits);}if(O.type===n.UNIT&&!O.showNumber){if(U){Q=this.oLocaleData.getPluralCategory(i+"."+F);P=U["unitPattern-count-"+Q];if(!P){P=U["unitPattern-count-other"];}if(!P){return this._addOriginInfo(M);}if(Q!=="other"&&P.indexOf("{0}")===-1){P=U["unitPattern-count-other"];if(!P){return this._addOriginInfo(M);}}if(P.indexOf("{0}")===-1){b.warning("Cannot separate the number from the unit because unitPattern-count-other '"+P+"' does not include the number placeholder '{0}' for unit '"+M+"'");}else{return this._addOriginInfo(P.replace("{0}","").trim());}}}z=i.length;if(O.groupingEnabled){if(I){var $=[3,2,2],_,a1=0;y=i.length;while(y>0){_=$[a1%3];y-=_;if(a1>0){G=O.groupingSeparator+G;}if(y<0){_+=y;y=0;}G=i.substr(y,_)+G;a1++;}}else{A=O.groupingSize;C=O.groupingBaseSize||A;y=Math.max(z-C,0)%A||A;G=i.substr(0,y);while(z-y>=C){G+=O.groupingSeparator;G+=i.substr(y,A);y+=A;}G+=i.substr(y);}}else{G=i;}if(D){w=O.minusSign;}w+=G;if(F){w+=O.decimalSeparator+F;}if(S&&S.formatString&&O.showScale&&O.type!==n.CURRENCY){Q=this.oLocaleData.getPluralCategory(i+"."+F);S.formatString=this.oLocaleData.getDecimalFormat(O.style,S.key,Q);w=S.formatString.replace(S.valueSubString,w);w=w.replace(/'.'/g,".");}if(O.type===n.CURRENCY){P=O.pattern;if(S&&S.formatString&&O.showScale){var b1;if(O.trailingCurrencyCode){b1="sap-short";}else{b1="short";}Q=this.oLocaleData.getPluralCategory(i+"."+F);if(I){P=j(b1,S.key,Q);}else{P=this.oLocaleData.getCurrencyFormat(b1,S.key,Q);}P=P.replace(/'.'/g,".");}J=P.split(";");if(J.length===2){P=D?J[1]:J[0];if(D){w=w.substring(O.minusSign.length);}}if(!O.currencyCode){var Y;if(O.customCurrencies&&typeof O.customCurrencies==="object"){Y=this.mKnownCurrencySymbols[M];}else{Y=this.oLocaleData.getCurrencySymbol(M);}if(Y&&Y!==M){M=Y;}}w=this._composeCurrencyResult(P,w,M,{showMeasure:O.showMeasure,negative:D,minusSign:O.minusSign});}if(O.type===n.PERCENT){P=O.pattern;w=P.replace(/[0#.,]+/,w);w=w.replace(/%/,O.percentSign);}if(O.showMeasure&&M&&O.type===n.UNIT){Q=this.oLocaleData.getPluralCategory(i+"."+F);if(U){P=U["unitPattern-count-"+Q];if(!P){P=U["unitPattern-count-other"];}if(!P){P=N.getDefaultUnitPattern(M);}}else{P=N.getDefaultUnitPattern(M);}w=P.replace("{0}",w);}return this._addOriginInfo(w);};N.prototype._addOriginInfo=function(i){if(sap.ui.getCore().getConfiguration().getOriginInfo()){i=new String(i);i.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString()};}return i;};N.prototype._composeCurrencyResult=function(P,F,M,O){var i=O.minusSign;P=P.replace(/[0#.,]+/,F);if(O.showMeasure&&M){var w="\u00a4",x={"[:digit:]":/\d/,"[:^S:]":/[^\$\xA2-\xA5\u058F\u060B\u09F2\u09F3\u09FB\u0AF1\u0BF9\u0E3F\u17DB\u20A0-\u20BD\uA838\uFDFC\uFE69\uFF04\uFFE0\uFFE1\uFFE5\uFFE6]/},y=P.indexOf(w),z=y<P.length/2?"after":"before",S=this.oLocaleData.getCurrencySpacing(z),C=(z==="after"?M.charAt(M.length-1):M.charAt(0)),A,D=x[S.currencyMatch],E=x[S.surroundingMatch],I;P=P.replace(w,M);A=(z==="after"?P.charAt(y+M.length):P.charAt(y-1));if(D&&D.test(C)&&E&&E.test(A)){if(z==="after"){I=y+M.length;}else{I=y;}P=P.slice(0,I)+S.insertBetween+P.slice(I);}else if(O.negative&&z==="after"){i="\ufeff"+O.minusSign;}}else{P=P.replace(/\s*\u00a4\s*/,"");}if(O.negative){P=P.replace(/-/,i);}return P;};N.prototype.parse=function(V){var O=this.oFormatOptions,P=O.plusSign+this.oLocaleData.getLenientNumberSymbols("plusSign"),M=O.minusSign+this.oLocaleData.getLenientNumberSymbols("minusSign"),w=q(P+M),G=q(O.groupingSeparator),D=q(O.decimalSeparator),x="^\\s*(["+w+"]?(?:[0-9"+G+"]+|[0-9"+G+"]*"+D+"[0-9]*)(?:[eE][+-][0-9]+)?)\\s*$",y="^\\s*(["+w+"]?[0-9"+G+"]+)\\s*$",z=new RegExp(G,"g"),A=new RegExp(D,"g"),C=this.oLocaleData.getNumberSymbol("percentSign"),I=O.type===n.CURRENCY&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",E,F,H,J,K=0,S,Q;if(V===""){if(!O.showNumber){return null;}Q=O.emptyString;if(O.parseAsString&&(O.emptyString===0||isNaN(O.emptyString))){Q=O.emptyString+"";}if(O.type===n.CURRENCY||O.type===n.UNIT){return[Q,undefined];}else{return Q;}}if(typeof V!=="string"&&!(V instanceof String)){return null;}if(O.groupingSeparator===O.decimalSeparator){b.error("The grouping and decimal separator both have the same value '"+O.groupingSeparator+"'. "+"They must be different from each other such that values can be parsed correctly.");}J=O.type===n.PERCENT?O.pattern:this.oLocaleData.getPercentPattern();if(J.charAt(0)==="%"){x=x.slice(0,1)+"%?"+x.slice(1);}else if(J.charAt(J.length-1)==="%"){x=x.slice(0,x.length-1)+"%?"+x.slice(x.length-1);}var U;if(O.type===n.UNIT&&O.showMeasure){var T;if(O.customUnits&&typeof O.customUnits==="object"){T=O.customUnits;}else{T=this.oLocaleData.getUnitFormats();}c(T,"Unit patterns cannot be loaded");if(O.allowedUnits){var W={};for(var i=0;i<O.allowedUnits.length;i++){var X=O.allowedUnits[i];W[X]=T[X];}T=W;}var Y=t(T,V,O.showNumber);var Z=false;U=Y.cldrCode;if(U.length===1){H=U[0];if(!O.showNumber){return[undefined,H];}}else if(U.length===0){if(O.unitOptional){Y.numberValue=V;}else{return null;}}else{c(U.length===1,"Ambiguous unit ["+U.join(", ")+"] for input: '"+(V)+"'");H=undefined;Z=true;}if(O.strictParsing){if(Z){return null;}}V=Y.numberValue||V;}var $;if(O.type===n.CURRENCY&&O.showMeasure){$=v({value:V,currencySymbols:this.mKnownCurrencySymbols,customCurrencyCodes:this.mKnownCurrencyCodes,duplicatedSymbols:this.mDuplicatedSymbols,customCurrenciesAvailable:!!O.customCurrencies});if(!$){return null;}if(O.strictParsing){if(!$.currencyCode||$.duplicatedSymbolFound){return null;}}V=$.numberValue;H=$.currencyCode;if(O.customCurrencies&&H===null){return null;}if(!O.showNumber){if(V){return null;}return[undefined,H];}}V=V.replace(/[\u202a\u200e\u202c\u202b\u200f]/g,"");V=V.replace(/\s/g,"");S=f(V,this.oLocaleData,I);if(S){V=S.number;}var _=k(V);if(O.isInteger&&!S&&!_){E=new RegExp(y);}else{E=new RegExp(x);}if(!E.test(V)){return O.type===n.CURRENCY||O.type===n.UNIT?null:NaN;}V=V.replace(z,"");var a1=V.length;for(var b1=0;b1<a1;b1++){var c1=V[b1];if(P.includes(c1)){V=V.replace(c1,"+");break;}else if(M.includes(c1)){V=V.replace(c1,"-");break;}}V=V.replace(/^\+/,"");if(S){V=V.replace(A,".");V=N._shiftDecimalPoint(V,Math.round(Math.log(S.factor)/Math.LN10));}if(O.isInteger){var d1;if(_){V=V.replace(A,".");d1=l(V);if(d1===undefined){return NaN;}}else{d1=parseInt(V);}K=O.parseAsString?V:d1;}else{V=V.replace(A,".");if(V.indexOf(C)!==-1){F=true;V=V.replace(C,"");}K=O.parseAsString?V:parseFloat(V);if(F){K=N._shiftDecimalPoint(K,-2);}}if(O.parseAsString){K=N._shiftDecimalPoint(V,0);}if(O.type===n.CURRENCY||O.type===n.UNIT){return[K,H];}return K;};N.prototype.convertToDecimal=function(V){var w=""+V,x,y,D,F,E,P;if(w.indexOf("e")==-1&&w.indexOf("E")==-1){return w;}var z=w.match(/^([+-]?)((\d+)(?:\.(\d+))?)[eE]([+-]?\d+)$/);x=z[1]=="-";y=z[2].replace(/\./g,"");D=z[3]?z[3].length:0;F=z[4]?z[4].length:0;E=parseInt(z[5]);if(E>0){if(E<F){P=D+E;w=y.substr(0,P)+"."+y.substr(P);}else{w=y;E-=F;for(var i=0;i<E;i++){w+="0";}}}else{if(-E<D){P=D+E;w=y.substr(0,P)+"."+y.substr(P);}else{w=y;E+=D;for(var i=0;i>E;i--){w="0"+w;}w="0."+w;}}if(x){w="-"+w;}return w;};N.prototype.getScale=function(){if((this.oFormatOptions.style!=="short"&&this.oFormatOptions.style!=="long")||this.oFormatOptions.shortRefNumber===undefined){return;}var S=g(this.oFormatOptions.shortRefNumber,this.oFormatOptions,this.oLocaleData),i;if(S&&S.formatString){i=S.formatString.replace(r,"").replace(/'.'/g,".").trim();if(i){return i;}}};N._shiftDecimalPoint=function(V,S){if(typeof S!=="number"){return NaN;}var M="";var E=V.toString().toLowerCase().split("e");if(typeof V==="number"){S=E[1]?(+E[1]+S):S;return+(E[0]+"e"+S);}else if(typeof V==="string"){if(parseFloat(V)===0&&S>=0){return d.test(V)?"0":V;}var F=E[0].charAt(0);M=F==="-"?F:"";if(M){E[0]=E[0].slice(1);}V=E[0];var D=V.indexOf("."),A,i,w;if(D===-1){V=V+".";D=V.length-1;}if(E[1]){D+=(+E[1]);}A=D+S;if(A<=0){V=V.padStart(V.length-A+1,'0');A=1;}else if(A>=V.length-1){V=V.padEnd(A+1,'0');A=V.length-1;}V=V.replace(".","");i=V.substring(0,A);w=V.substring(A);i=i.replace(/^(-?)0+(\d)/,"$1$2");return M+i+(w?("."+w):"");}else{return null;}};function g(V,O,w,I){var S,K,x,C,y=O.style,P=O.precision!==undefined?O.precision:2;if(y!="short"&&y!="long"){return undefined;}for(var i=0;i<15;i++){K=Math.pow(10,i);if(o(Math.abs(V)/K,P-1)<10){break;}}x=K.toString();if(O.type===n.CURRENCY){if(O.trailingCurrencyCode){y="sap-short";}if(I){C=j(y,x,"other",true);}else{C=w.getCurrencyFormat(y,x,"other");}}else{C=w.getDecimalFormat(y,x,"other");}if(!C||C=="0"){return undefined;}else{S={};S.key=x;S.formatString=C;var z=C.match(r);if(z){S.valueSubString=z[0];var A=S.valueSubString.indexOf(".");if(A==-1){S.decimals=0;S.magnitude=K*Math.pow(10,1-S.valueSubString.length);}else{S.decimals=S.valueSubString.length-A-1;S.magnitude=K*Math.pow(10,1-A);}}else{return undefined;}}return S;}function f(V,w,I){var x,F=1,K=10,P=w.getPluralCategories(),C,y={number:undefined,factor:F},G=function(A,K,S,D){if(D){C=j(S,K.toString(),A,true);}else{C=w.getDecimalFormat(S,K.toString(),A);}if(C){C=C.replace(/[\s\u00a0\u200F]/g,"");C=C.replace(/'.'/g,".");var E=C.match(r);if(E){var H=E[0];var U=C.replace(H,"");if(!U){return;}var J=V.indexOf(U);if(J>=0){x=V.replace(U,"");x=x.replace(/\u200F/g,"");F=K;F*=Math.pow(10,1-H.length);if(y.number===undefined||x.length<y.number.length){y.number=x;y.factor=F;}}}}};["long","short"].forEach(function(S){K=10;while(K<1e15){for(var i=0;i<P.length;i++){var z=P[i];G(z,K,S);}K=K*10;}});if(I&&!x){K=10;while(K<1e15){for(var i=0;i<P.length;i++){var z=P[i];G(z,K,"short",true);}K=K*10;}}if(!x){return;}return y;}function h(F){var S=sap.ui.getCore().getConfiguration().getFormatSettings().getTrailingCurrencyCode();if(F){if(F.trailingCurrencyCode!==undefined){S=F.trailingCurrencyCode;}if(F.pattern){S=false;}if(F.currencyCode===false){S=false;}}return S;}function j(S,K,P,D){var F,C={"short":{"1000-one":"\xa40000","1000-other":"\xa40000","10000-one":"\xa400000","10000-other":"\xa400000","100000-one":"\xa40 Lk","100000-other":"\xa40 Lk","1000000-one":"\xa400 Lk","1000000-other":"\xa400 Lk","10000000-one":"\xa40 Cr","10000000-other":"\xa40 Cr","100000000-one":"\xa400 Cr","100000000-other":"\xa400 Cr","1000000000-one":"\xa4000 Cr","1000000000-other":"\xa4000 Cr","10000000000-one":"\xa40000 Cr","10000000000-other":"\xa40000 Cr","100000000000-one":"\xa400000 Cr","100000000000-other":"\xa400000 Cr","1000000000000-one":"\xa40 Lk Cr","1000000000000-other":"\xa40 Lk Cr","10000000000000-one":"\xa400 Lk Cr","10000000000000-other":"\xa400 Lk Cr","100000000000000-one":"\xa40 Cr Cr","100000000000000-other":"\xa40 Cr Cr"},"sap-short":{"1000-one":"0000\xa0\xa4","1000-other":"0000\xa0\xa4","10000-one":"00000\xa0\xa4","10000-other":"00000\xa0\xa4","100000-one":"0 Lk\xa0\xa4","100000-other":"0 Lk\xa0\xa4","1000000-one":"00 Lk\xa0\xa4","1000000-other":"00 Lk\xa0\xa4","10000000-one":"0 Cr\xa0\xa4","10000000-other":"0 Cr\xa0\xa4","100000000-one":"00 Cr\xa0\xa4","100000000-other":"00 Cr\xa0\xa4","1000000000-one":"000 Cr\xa0\xa4","1000000000-other":"000 Cr\xa0\xa4","10000000000-one":"0000 Cr\xa0\xa4","10000000000-other":"0000 Cr\xa0\xa4","100000000000-one":"00000 Cr\xa0\xa4","100000000000-other":"00000 Cr\xa0\xa4","1000000000000-one":"0 Lk Cr\xa0\xa4","1000000000000-other":"0 Lk Cr\xa0\xa4","10000000000000-one":"00 Lk Cr\xa0\xa4","10000000000000-other":"00 Lk Cr\xa0\xa4","100000000000000-one":"0 Cr Cr\xa0\xa4","100000000000000-other":"0 Cr Cr\xa0\xa4"}},i={"short":{"1000-one":"0000","1000-other":"0000","10000-one":"00000","10000-other":"00000","100000-one":"0 Lk","100000-other":"0 Lk","1000000-one":"00 Lk","1000000-other":"00 Lk","10000000-one":"0 Cr","10000000-other":"0 Cr","100000000-one":"00 Cr","100000000-other":"00 Cr","1000000000-one":"000 Cr","1000000000-other":"000 Cr","10000000000-one":"0000 Cr","10000000000-other":"0000 Cr","100000000000-one":"00000 Cr","100000000000-other":"00000 Cr","1000000000000-one":"0 Lk Cr","1000000000000-other":"0 Lk Cr","10000000000000-one":"00 Lk Cr","10000000000000-other":"00 Lk Cr","100000000000000-one":"0 Cr Cr","100000000000000-other":"0 Cr Cr"}};i["sap-short"]=i["short"];var T=D?i:C;var w=T[S];if(!w){w=T["short"];}if(P!=="one"){P="other";}F=w[K+"-"+P];return F;}function k(V){return V.indexOf("e")>0||V.indexOf("E")>0;}function l(V){var i=N._shiftDecimalPoint(V,0);if(i.indexOf(".")>0&&!d.test(i.split(".")[1])){return undefined;}var F=parseFloat(i);var w=""+F;if(k(w)){w=N._shiftDecimalPoint(w,0);}var I=parseInt(w);if(I!==F){return undefined;}return I;}function o(V,M,i){if(typeof V!=="number"){return NaN;}i=i||N.RoundingMode.HALF_AWAY_FROM_ZERO;M=parseInt(M);var w=""+V;if(!k(w)){var I=w.indexOf(".");if(I<0){return V;}if(w.substring(I+1).length<=M){return V;}}if(typeof i==="function"){V=i(V,M);}else{if(i.match(/^[a-z_]+$/)){i=i.toUpperCase();}if(!M){return m[i](V);}V=N._shiftDecimalPoint(m[i](N._shiftDecimalPoint(V,M)),-M);}return V;}function q(i){return i.replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1");}function p(V,P){var i=Math.floor(Math.log(Math.abs(V))/Math.LN10);return Math.max(0,P-i-1);}function t(U,V,S){var i={numberValue:undefined,cldrCode:[]};var w=Number.POSITIVE_INFINITY;var x,K;for(x in U){for(K in U[x]){if(K.indexOf("unitPattern")===0){var y=U[x][K];var z=y.indexOf("{0}");var C=z>-1;if(C&&!S){y=y.replace("{0}","").trim();C=false;}if(C){var P=y.substring(0,z);var A=y.substring(z+"{0}".length);var M=V.startsWith(P)&&V.endsWith(A);var D=M&&V.substring(P.length,V.length-A.length);if(D){if(D.length<w){w=D.length;i.numberValue=D;i.cldrCode=[x];}else if(D.length===w&&i.cldrCode.indexOf(x)===-1){i.cldrCode.push(x);}}}else if(y===V){if(S){i.cldrCode=[x];var E;if(K.endsWith("-zero")){E="0";}else if(K.endsWith("-one")){E="1";}else if(K.endsWith("-two")){E="2";}i.numberValue=E;return i;}else if(i.cldrCode.indexOf(x)===-1){i.cldrCode.push(x);}}}}}return i;}function u(V,C){var S="",i,w;for(var x in C){w=C[x];if(V.indexOf(w)>=0&&S.length<w.length){S=w;i=x;}}return{symbol:S,code:i};}function v(C){var V=C.value;var M=u(V,C.currencySymbols);if(!M.code){M=u(V,C.customCurrencyCodes);if(!M.code&&!C.customCurrenciesAvailable){var i=V.match(/(^[A-Z]{3}|[A-Z]{3}$)/);M.code=i&&i[0];}}if(M.code){var w=M.code.length-1;var x=M.code.charAt(w);var D;var y=/[\-\s]+/;if(/\d$/.test(x)){if(V.startsWith(M.code)){D=w+1;if(!y.test(V.charAt(D))){return undefined;}}}else if(/^\d/.test(M.code)){if(V.endsWith(M.code)){D=V.indexOf(M.code)-1;if(!y.test(V.charAt(D))){return undefined;}}}V=V.replace(M.symbol||M.code,"");}var z=false;if(C.duplicatedSymbols&&C.duplicatedSymbols[M.symbol]){M.code=undefined;z=true;b.error("The parsed currency symbol '"+M.symbol+"' is defined multiple "+"times in custom currencies.Therefore the result is not distinct.");}return{numberValue:V,currencyCode:M.code||undefined,duplicatedSymbolFound:z};}return N;});
