/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/base/ManagedObjectMetadata","sap/ui/core/ComponentContainer","sap/ui/core/Placeholder","sap/ui/core/library"],function(L,M,C,P,c){"use strict";var a=c.ComponentLifecycle;return{display:function(d){var s=Promise.resolve();return this._display(d,s);},_display:function(d,s,t){if(this._oParent){s=this._oParent._display(d,s,Object.assign({},t));}return this._place(d,s,t);},suspend:function(){if(this._oParent){this._oParent.suspend();}if(this._isLoaded()){var o=this._get(),r;if(o.isA("sap.ui.core.UIComponent")&&(r=o.getRouter())&&o.hasNativeRouter()){r.stop();}}else{L.warning("The target with name '"+this._oOptions._name+"' can't be suspended because it's being loaded or not loaded yet");}return this;},resume:function(){if(this._oParent){this._oParent.resume();}if(this._isLoaded()){var o=this._get(),r;if(o.isA("sap.ui.core.UIComponent")&&(r=o.getRouter())&&o.hasNativeRouter()){r.initialize(true);}}return this;},_isLoaded:function(){return this._bIsLoaded;},_getCreateOptions:function(t){var n=this._getEffectiveObjectName(this._oOptions.name),o=this._oOptions,b;t=t||{};switch(o.type){case"View":b={name:n,type:o.viewType,id:o.id,async:true};break;case"Component":b={id:o.id};if(o.usage){b.usage=o.usage;}else{b.name=n;}b=Object.assign({},o.options||{},b);break;default:throw new Error("The given type "+o.type+" isn't support by sap.ui.core.routing.Target");}return b;},_get:function(t){var o=this._getCreateOptions(t);return this._oCache._get(o,this._oOptions.type,this._bUseRawViewId,t);},_load:function(t){var o=this._get(t),p;if(!(o instanceof Promise)){if(o.isA("sap.ui.core.mvc.View")){p=o.loaded();}else{p=Promise.resolve(o);}}else{p=o;}return p.then(function(o){this._bIsLoaded=true;return o;}.bind(this));},load:function(t){return this._load(t).then(function(l){return{object:l,nestedComponentReady:this.waitForComponentTarget({target:l,createInfo:t})};}.bind(this));},waitForComponentTarget:function(t){return new Promise(function(r,b){var l=t.target;var T=t.createInfo;var i=true;if(l.isA("sap.ui.core.UIComponent")){var R=l.getRouter();if(R&&l.hasNativeRouter()){var h=R.getHashChanger().getHash();var o=R.getRouteByHash(h);var I=T&&T.ignoreInitialHash;if(!R._oConfig.async){throw new Error("The router of component '"+l.getId()+"' which is loaded via the target '"+this._oOptions._name+"' is defined as synchronous which is not supported using as a nested component.");}if(R._oOwner&&T){R._oOwner._bRoutingPropagateTitle=T.propagateTitle;}if(!I&&(!R.isInitialized()||R._bMatchingProcessStarted)&&o&&o._oConfig.target){i=false;R.attachRouteMatched(r);}if(R.isStopped()){R.initialize(I);}}}if(i){r();}}.bind(this));},resolveContainerControl:function(p){return Promise.resolve().then(function(){p=p||{};var o=this._oOptions;var v=this._isValid(p);var e;if(v!==true){e=v;return this._refuseInvalidTarget(o._name,e);}var V=p.view,b=p.control,d,f;if(V&&V.isA("sap.ui.core.ComponentContainer")){V=V.getComponentInstance().getRootControl();}if(!V&&o.rootView){d=Promise.resolve(o.rootView).then(function(r){var g;if(r){g=sap.ui.getCore().byId(r);o.rootView=r;}if(!g){e="Did not find the root view with the id "+o.rootView;return this._refuseInvalidTarget(o._name,e);}else{return g;}}.bind(this));}else{d=Promise.resolve(V);}d=d.then(function(g){if(g&&g.isA("sap.ui.core.mvc.View")){return g.loaded();}else{return g;}});if(o.controlId){f=d.then(function(g){var h;if(g){h=g.byId(o.controlId);}if(!h){h=sap.ui.getCore().byId(o.controlId);}return h;});}else{f=Promise.resolve(b);}return f.then(function(g){if(!g){e="Control with ID "+o.controlId+" could not be found";return this._refuseInvalidTarget(o._name,e);}else{return g;}}.bind(this));}.bind(this));},displayPlaceholder:function(t,o){var O,b=this._oOptions,i=b.type==="Component",h=false,p=t.placeholder||b.placeholder||{},d=Promise.resolve();if(P.hasProviders()){Object.assign(p,P.getPlaceholderFromProviders({name:b.name,type:b.type}));}if(Object.keys(p).length>0){if(p.autoClose===undefined){p.autoClose=true;}h=true;}if(i){var e=this._oCache._oComponent;var s=t.componentId+"-container";O=(e&&e.byId(s))||sap.ui.getCore().byId(s);if(!O){var f=Object.assign({height:"100%",width:"100%",lifecycle:a.Application},b.containerOptions);if(e){e.runAsOwner(function(){O=new C(e.createId(s),f);});}else{O=new C(s,f);}}if(h){p.container=O;}}if(h&&o.isA("sap.ui.core.IPlaceholderSupport")){p.container=o;}if(p.container&&!t.repeatedRoute){p.aggregation=this._oOptions.controlAggregation;var g=this._getCreateOptions(t);var j=this._oCache.fetch(g,this._oOptions.type);if(j&&i){p.object=O;}else{p.object=j;}if(p.html){p.placeholder=new P({html:p.html});}if(p.placeholder&&sap.ui.getCore().getConfiguration().getPlaceholder()){d=this.showPlaceholder(p);}}return d.then(function(k){return{containerControl:o,object:O,placeholderConfig:p,placeholderShown:!!k};});},_place:function(d,s,t){var o=this._oOptions,b=this,e,i=o.type==="Component";var p,f;if(d instanceof Promise){t=s;s=d;d=undefined;}t=t||{};if(i){t.componentId=o.id||M.uid("uicomponent");}if((o.name||o.usage)&&o.type){p=this.load(t);if(this._oParent||t.legacy){f=s.then(this.resolveContainerControl.bind(this));}else{f=this.resolveContainerControl();}f=f.then(this.displayPlaceholder.bind(this,t));s=Promise.all([p,f,s]).then(function(A){var O=A[0].object,v=A[1],V,r;v.nestedComponentReady=A[0].nestedComponentReady;if(i){var g=O.destroy;O.destroy=function(){if(g){g.apply(this);}v.object.destroy();};v.object.setComponent(O);r=O.getRootControl();if(r&&r.isA("sap.ui.core.mvc.View")){V=r;}}else{v.object=O;V=O;}b._bindTitleInTitleProvider(V);b._addTitleProviderAsDependent(V);return v;}).then(function(v){var g=v.containerControl,O=v.object;b._beforePlacingViewIntoContainer({container:g,view:O,data:d});var A=g.getMetadata().getJSONKeys()[o.controlAggregation];if(!A){e="Control "+o.controlId+" does not have an aggregation called "+o.controlAggregation;return b._refuseInvalidTarget(o._name,e);}if(o.clearControlAggregation===true){g[A._sRemoveAllMutator]();}L.info("Did place the "+o.type.toLowerCase()+" target '"+(o.name?b._getEffectiveObjectName(o.name):o.usage)+"' with the id '"+O.getId()+"' into the aggregation '"+o.controlAggregation+"' of a control with the id '"+g.getId()+"'",b);g[A._sMutator](O);return{name:o._name,view:O,control:g,nestedComponentReady:v.nestedComponentReady,placeholderConfig:v.placeholderConfig,placeholderShown:v.placeholderShown};});}else{s=s.then(function(){return{name:o._name};});}return s.then(function(g){var h=g.nestedComponentReady||Promise.resolve();return h.then(function(){var j=g.control,O=g.view,k=g.placeholderConfig;if(j&&O){b.fireDisplay({view:O.isA("sap.ui.core.mvc.View")?O:undefined,object:O,control:j,config:b._oOptions,data:d,routeRelevant:t.routeRelevant});}if(k&&k.container&&k.autoClose&&b.hidePlaceholder){b.hidePlaceholder(k);}return g;});});},showPlaceholder:function(s){if(s.container&&s.container.showPlaceholder){return s.container.showPlaceholder(s);}else{return Promise.resolve();}},hidePlaceholder:function(s){if(s.container.hidePlaceholder){s.container.hidePlaceholder();}},_isValid:function(p){var o=this._oOptions,b=p&&p.control,h=(b||o.controlId),i=true,l="";if(!h){l="The target "+o._name+" has no controlId set and no parent so the target cannot be displayed.";i=false;}if(!o.controlAggregation){l="The target "+o._name+" has a control id or a parent but no 'controlAggregation' was set, so the target could not be displayed.";i=false;}if(l){L.error(l,this);}return i||l;},_refuseInvalidTarget:function(n,m){return Promise.reject(new Error(m+" - Target: "+n));}};});
