/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseTreeModifier","sap/ui/base/ManagedObject","sap/ui/base/DataType","sap/base/util/merge","sap/ui/util/XMLHelper","sap/ui/core/mvc/EventHandlerResolver","sap/base/util/includes","sap/base/util/ObjectPath","sap/base/util/isPlainObject","sap/ui/core/Fragment"],function(B,M,D,m,X,E,a,O,b,F){"use strict";var C="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1";var c=m({},B,{targets:"xmlTree",setVisible:function(o,v){if(v){o.removeAttribute("visible");}else{o.setAttribute("visible",v);}},getVisible:function(o){return c.getProperty(o,"visible");},setStashed:function(o,s){if(!s){o.removeAttribute("stashed");}else{o.setAttribute("stashed",s);}c.setVisible(o,!s);},getStashed:function(o){return Promise.all([c.getProperty(o,"stashed"),c.getProperty(o,"visible")]).then(function(p){return!!p[0]||!p[1];});},bindProperty:function(o,p,v){o.setAttribute(p,"{"+v+"}");},unbindProperty:function(o,p){o.removeAttribute(p);},_setProperty:function(o,p,P,e){var v=c._getSerializedValue(P);if(e){v=c._escapeCurlyBracketsInString(v);}o.setAttribute(p,v);},setProperty:function(o,p,P){c._setProperty(o,p,P,true);},getProperty:function(o,p){var P;var t;var v=o.getAttribute(p);return c.getControlMetadata(o).then(function(d){P=d.getProperty(p);if(P){t=P.getType();if(p==="value"&&c.getControlType(o)==="sap.ui.core.CustomData"){return c.getProperty(o,"key").then(function(k){if(k==="sap-ui-custom-settings"){t=D.getType("object");}});}}return undefined;}).then(function(){if(P){if(v===null){v=P.getDefaultValue()||t.getDefaultValue();}else{var u=M.bindingParser(v,undefined,true);if(b(u)){if(u.path||u.parts){v=undefined;}else{v=u;}}else{v=t.parseValue(u||v);}}}return v;});},isPropertyInitial:function(o,p){var P=o.getAttribute(p);return(P==null);},setPropertyBinding:function(o,p,P){if(typeof P!=="string"){throw new Error("For XML, only strings are supported to be set as property binding.");}o.setAttribute(p,P);},getPropertyBinding:function(o,p){var P=o.getAttribute(p);if(P){var u=M.bindingParser(P,undefined,true);if(u&&(u.path||u.parts)){return u;}}return undefined;},createAndAddCustomData:function(o,s,v){o.setAttributeNS(C,"custom.data.via.modifier:"+s,c._escapeCurlyBracketsInString(v));return Promise.resolve();},createControl:function(s,A,v,S,d,e){var i,l,o;if(!c.bySelector(S,A,v)){var f=s.split('.');var n="";if(f.length>1){l=f.pop();n=f.join('.');}var N=v.ownerDocument.createElementNS(n,l);i=c.getControlIdBySelector(S,A);if(i){N.setAttribute("id",i);}return Promise.resolve().then(function(){if(d){return c.applySettings(N,d);}return undefined;}).then(function(){return Promise.resolve(N);});}else{o=new Error("Can't create a control with duplicated ID "+i);return Promise.reject(o);}},applySettings:function(o,s){return c.getControlMetadata(o).then(function(d){var e=d.getJSONKeys();Object.keys(s).forEach(function(k){var K=e[k];var v=s[k];switch(K._iKind){case 0:c._setProperty(o,k,v,false);break;case 3:c.setAssociation(o,k,v);break;default:throw new Error("Unsupported in applySettings on XMLTreeModifier: "+k);}});});},_byId:function(i,v){if(v){if(v.ownerDocument&&v.ownerDocument.getElementById&&v.ownerDocument.getElementById(i)){return v.ownerDocument.getElementById(i);}return v.querySelector("[id='"+i+"']");}return undefined;},getId:function(o){return o.getAttribute("id");},getParent:function(o){var p=o.parentNode;if(!c.getId(p)&&!c._isExtensionPoint(p)){p=p.parentNode;}return p;},_getLocalName:function(x){return x.localName||x.baseName||x.nodeName;},getControlType:function(o){return c._getControlTypeInXml(o);},setAssociation:function(p,n,i){if(typeof i!=="string"){i=c.getId(i);}p.setAttribute(n,i);},getAssociation:function(p,n){return p.getAttribute(n);},getAllAggregations:function(o){return c.getControlMetadata(o).then(function(d){return d.getAllAggregations();});},getAggregation:function(p,n){var d=[];var s;return c._isSingleValueAggregation(p,n).then(function(S){s=S;return c._findAggregationNode(p,n);}).then(function(A){if(A){return c._getControlsInAggregation(p,A).then(function(e){d=e;});}return c._isAltTypeAggregation(p,n).then(function(i){if(i&&s){return c.getProperty(p,n).then(function(o){d.push(o);});}return undefined;});}).then(function(){if(n==="customData"){var e;var N=Array.prototype.slice.call(p.attributes).reduce(function(f,A){var l=c._getLocalName(A);if(A.namespaceURI===C){var o=p.ownerDocument.createElementNS("sap.ui.core","CustomData");o.setAttribute("key",l);o.setAttribute("value",A.value);f.push(o);}else if(A.namespaceURI&&A.name.indexOf("xmlns:")!==0){if(!e){e={};}if(!e.hasOwnProperty(A.namespaceURI)){e[A.namespaceURI]={};}e[A.namespaceURI][l]=A.nodeValue;}return f;},[]);d=d.concat(N);if(e){var o=p.ownerDocument.createElementNS("sap.ui.core","CustomData");o.setAttribute("key","sap-ui-custom-settings");c.setProperty(o,"value",e);d.push(o);}}return s?d[0]:d;});},insertAggregation:function(p,n,o,I,v,s){return c._findAggregationNode(p,n).then(function(A){if(!A){var N=p.namespaceURI;return c.createControl(N+"."+n,undefined,v).then(function(A){p.appendChild(A);return A;});}return A;}).then(function(A){if(!s){var d=A.children;var e=0;var S=(I<d.length)?I:d.length;for(var i=0;i<S;i++){if(d[i].namespaceURI==="sap.ui.core"&&d[i].tagName.indexOf("ExtensionPoint")>-1){e=e+1-d[i].children.length;}}I=I+e;}if(I>=A.childElementCount){A.appendChild(o);}else{return c._getControlsInAggregation(p,A).then(function(r){A.insertBefore(o,r[I]);});}return undefined;});},removeAggregation:function(p,n,o){return c._findAggregationNode(p,n).then(function(A){A.removeChild(o);});},removeAllAggregation:function(o,n){return c._findAggregationNode(o,n).then(function(A){if(o===A){return c._getControlsInAggregation(o,o).then(function(d){d.forEach(function(e){o.removeChild(e);});});}return o.removeChild(A);});},_findAggregationNode:function(p,n){var A;var d=c._children(p);for(var i=0;i<d.length;i++){var N=d[i];if(N.localName===n){A=N;break;}}var P=Promise.resolve(A);if(!A){P=P.then(c._isDefaultAggregation.bind(c,p,n)).then(function(I){if(I){return p;}return A;});}return P;},_isDefaultAggregation:function(p,A){return c.getControlMetadata(p).then(function(o){var d=o.getDefaultAggregation();return d&&A===d.name;});},_isNotNamedAggregationNode:function(p,o){return c.getAllAggregations(p).then(function(A){var d=A[o.localName];return p.namespaceURI!==o.namespaceURI||!d;});},_isSingleValueAggregation:function(p,A){return c.getAllAggregations(p).then(function(d){var o=d[A];return!o.multiple;});},_isAltTypeAggregation:function(p,A){return c.getControlMetadata(p).then(function(o){return o.getAllAggregations()[A];}).then(function(o){return!!o.altTypes;});},_isExtensionPoint:function(o){return c._getControlTypeInXml(o)==="sap.ui.core.ExtensionPoint";},getControlMetadata:function(o){return c._getControlMetadataInXml(o);},_getControlsInAggregation:function(p,A){var d=Array.prototype.slice.call(c._children(A));return Promise.all(d.map(function(o){return c._isNotNamedAggregationNode(p,o).then(function(i){return i?o:undefined;});})).then(function(d){return d.filter(function(o){return!!o;});});},_children:function(p){if(p.children){return p.children;}else{var d=[];for(var i=0;i<p.childNodes.length;i++){var n=p.childNodes[i];if(n.nodeType===n.ELEMENT_NODE){d.push(n);}}return d;}},getBindingTemplate:function(o,A){return c._findAggregationNode(o,A).then(function(d){if(d){var e=c._children(d);if(e.length===1){return e[0];}}return undefined;});},updateAggregation:function(o,A){},findIndexInParentAggregation:function(o){var p=c.getParent(o);if(!p){return Promise.resolve(-1);}return c.getParentAggregationName(o,p).then(function(A){return c.getAggregation(p,A);}).then(function(d){if(Array.isArray(d)){var P=d.map(function(o){return Promise.resolve().then(function(){if(c._isExtensionPoint(o)){return o;}return c.getProperty(o,"stashed").then(function(e){return!e?o:undefined;});});});return Promise.all(P).then(function(d){return d.filter(function(o){return!!o;}).indexOf(o);});}else{return 0;}});},getParentAggregationName:function(o,p){return Promise.resolve().then(function(){if(!p.isSameNode(o.parentNode)){return false;}else{return c._isNotNamedAggregationNode(p,o);}}).then(function(n){if(n){return c.getControlMetadata(p).then(function(d){return d.getDefaultAggregationName();});}else{return c._getLocalName(o.parentNode);}});},findAggregation:function(o,A){return c.getControlMetadata(o).then(function(d){return d.getAllAggregations();}).then(function(d){if(d){return d[A];}return undefined;});},validateType:function(o,A,p,f,i){var t=A.type;return c.getAggregation(p,A.name).then(function(d){if(A.multiple===false&&d&&d.length>0){return false;}return F.load({definition:f});}).then(function(d){if(!Array.isArray(d)){d=[d];}var r=d[i].isA(t);d.forEach(function(e){e.destroy();});return r;});},instantiateFragment:function(f,n,v){var o=X.parse(f);return c._checkAndPrefixIdsInFragment(o,n).then(function(o){var d;if(o.localName==="FragmentDefinition"){d=c._getElementNodeChildren(o);}else{d=[o];}d.forEach(function(N){if(c._byId(N.getAttribute("id"),v)){throw Error("The following ID is already in the view: "+N.getAttribute("id"));}});return d;});},templateControlFragment:function(f,p){return B._templateFragment(f,p).then(function(o){return c._children(o);});},destroy:function(o){var p=o.parentNode;if(p){p.removeChild(o);}},_getFlexCustomData:function(o,t){if(!o){return undefined;}return o.getAttributeNS("sap.ui.fl",t);},attachEvent:function(n,e,f,d){if(typeof O.get(f)!=="function"){return Promise.reject(new Error("Can't attach event because the event handler function is not found or not a function."));}return c.getProperty(n,e).then(function(v){v=v||"";var g=E.parse(v);var s=f;var p=["$event"];if(d){p.push(JSON.stringify(d));}s+="("+p.join(",")+")";if(!a(g,s)){g.push(s);}n.setAttribute(e,g.join(";"));});},detachEvent:function(n,e,f){if(typeof O.get(f)!=="function"){return Promise.reject(new Error("Can't attach event because the event handler function is not found or not a function."));}return c.getProperty(n,e).then(function(v){v=v||"";var d=E.parse(v);var i=d.findIndex(function(s){return s.includes(f);});if(i>-1){d.splice(i,1);}if(d.length){n.setAttribute(e,d.join(";"));}else{n.removeAttribute(e);}});},bindAggregation:function(n,A,v,V){return Promise.resolve().then(function(){c.bindProperty(n,A,v.path);return c.insertAggregation(n,A,v.template,0,V);});},unbindAggregation:function(n,A){return Promise.resolve().then(function(){if(n.hasAttribute(A)){n.removeAttribute(A);return c.removeAllAggregation(n,A);}return undefined;});},getExtensionPointInfo:function(e,v){return Promise.resolve().then(function(){if(v&&e){var d=Array.prototype.slice.call(v.getElementsByTagNameNS("sap.ui.core","ExtensionPoint"));var f=d.filter(function(g){return g.getAttribute("name")===e;});var o=(f.length===1)?f[0]:undefined;if(o){var p=c.getParent(o);return Promise.all([c.getParentAggregationName(o,p),c.findIndexInParentAggregation(o)]).then(function(P){var g={parent:p,aggregationName:P[0],index:P[1]+1,defaultContent:Array.prototype.slice.call(c._children(o))};return g;});}}return undefined;});}});return c;},true);
