/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/Device","sap/ui/documentation/sdk/controller/MasterTreeBaseController","sap/m/library","sap/base/Log","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/Highlighter"],function(D,M,m,L,F,a,A,J,H){"use strict";var S=m.SplitAppMode;return M.extend("sap.ui.documentation.sdk.controller.ApiMaster",{onInit:function(){var c=this.getOwnerComponent();this._oRouter=this.getRouter();this._oRouter.getRoute("api").attachPatternMatched(this._onMatched,this);this._oRouter.getRoute("apiSpecialRoute").attachPatternMatched(this._onTopicMatched,this);this._oRouter.getRoute("deprecated").attachPatternMatched(this._onTopicMatched,this);this._oRouter.getRoute("experimental").attachPatternMatched(this._onTopicMatched,this);this._oRouter.getRoute("since").attachPatternMatched(this._onTopicMatched,this);this.bIsInitial=true;this._oTreeModel=new J();this._oTreeModel.setSizeLimit(10000);this.setModel(this._oTreeModel,"treeData");this._bIncludeDeprecated=false;this._oTree=this.byId("tree");this._oDataLoadedPromise=c.loadVersionInfo().then(function(){this._aAllowedMembers=c.aAllowedMembers;}.bind(this)).then(A.getIndexJsonPromise).then(this._bindTreeModel.bind(this)).then(function(){this.buildAndApplyFilters();this._initTreeUtil("name","nodes");}.bind(this));},onAfterRendering:function(){if(!this.highlighter){this.highlighter=new H(this._oTree.getDomRef(),{useExternalStyles:false,shouldBeObserved:true,isCaseSensitive:false});}},onExit:function(){this.highlighter.destroy();},_bindTreeModel:function(t){var f=function(n,b){return n.filter(function(N){if(N.hasOwnProperty('nodes')){N.nodes=f(N.nodes,b);}return!N.hasOwnProperty('visibility')||b.indexOf(N.visibility.toLowerCase())>=0;});};if(t.length>0){t.push({isSelected:false,name:"experimental",displayName:"Experimental APIs",bAllContentDeprecated:false,visibility:"public"},{isSelected:false,name:"deprecated",displayName:"Deprecated APIs",bAllContentDeprecated:false,visibility:"public"},{isSelected:false,name:"since",displayName:"Index by Version",bAllContentDeprecated:false,visibility:"public"});}t=f(t,this._aAllowedMembers);this._oTreeModel.setData(t,false);},selectDeprecatedSymbol:function(t){this._bIncludeDeprecated=true;this.byId("includeDeprecated").setSelected(true);this.buildAndApplyFilters();this._expandTreeToNode(t,this.getModel("treeData"));},_onTopicMatched:function(e){var t=decodeURIComponent(e.getParameter("arguments").id)||e.getParameter("name"),s;if(e.getParameter("name")==="apiSpecialRoute"){s=this._oRouter._decodeSpecialRouteArguments(e);t=s.id;}if(this.bIsInitial){this.showMasterSide();this.bIsInitial=false;}this._oDataLoadedPromise.then(function(){this._expandTreeToNode(t,this._oTreeModel);}.bind(this));},_onMatched:function(){var s=this.getView().getParent().getParent(),b=this._oTree.getSelectedItem();b&&b.setSelected(false);this._oDataLoadedPromise.then(function(){this._oTree.collapseAll().expand(0);}.bind(this));s.setMode(S.ShowHideMode);if(D.system.desktop){setTimeout(function(){this.getView().byId("searchField").getFocusDomRef().focus();}.bind(this),0);}},onNodeSelect:function(e){this._oRouter.navTo("apiId",{id:e.getParameter("listItem").getTarget()},false);},onTreeFilter:function(){M.prototype.onTreeFilter.apply(this,arguments);if(this.highlighter){this.highlighter.highlight(this._sFilter);}return this;},buildAndApplyFilters:function(){var f=[];if(!this._bIncludeDeprecated){f.push(new F({path:"bAllContentDeprecated",operator:a.EQ,value1:false}));}if(this._sFilter){f.push(new F({and:false,filters:[new F({path:"name",operator:a.Contains,value1:this._sFilter}),new F({path:"name",operator:a.Contains,value1:this._sFilter.replace(/\s/g,'')})]}));}this._oTree.getBinding("items").filter(new F({and:true,filters:f}));return!!this._sFilter;},onIncludeDeprecatedItemsChange:function(e){this._bIncludeDeprecated=e.getParameter("selected");this.buildAndApplyFilters();}});});
