/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/SearchUtil","sap/ui/core/mvc/Controller","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/json/JSONModel","sap/ui/core/ResizeHandler","sap/ui/Device","sap/ui/core/Fragment","sap/base/util/UriParameters","sap/ui/documentation/library","sap/ui/core/IconPool","sap/m/MessageBox","sap/m/library","sap/base/Log","sap/base/util/Version","sap/ui/core/syncStyleClass","sap/ui/core/Core","sap/ui/documentation/sdk/model/formatter","sap/m/ResponsivePopover","sap/ui/documentation/sdk/controller/util/Highlighter","sap/m/Button","sap/m/Toolbar","sap/ui/documentation/sdk/util/Resources",'sap/base/util/LoaderExtensions'],function(K,q,B,S,C,F,c,J,R,D,d,U,f,I,M,m,L,V,s,g,h,k,H,n,T,o,p){"use strict";var r=m.SplitAppMode;var t="Demo Kit - \uFFFD SDK",W={topic:"Documentation - "+t,api:"API Reference - "+t,controls:"Samples - "+t,demoapps:"Demo Apps - "+t,tools:"Tools - "+t,home:t};function u(a){return o.getResourcesVersion()&&!self['sap-ui-documentation-config']?window.origin+a:o.getResourceOriginPath(a);}var v=m.URLHelper,N=u("/neo-app.json"),w=u("/versionoverview.json"),A="about",x="feedback",y="https://demokit-feedback-proxy.cfapps.eu12.hana.ondemand.com/issue",z="change_version",E="settings",G="cookie_preferences",O="en",P="light",Q="dark",X="auto",Y=Object.create(null),Z="language",$="appearance",_="sitemap";Y[P]="sap_fiori_3";Y[Q]="sap_fiori_3_dark";Y[X]="sap_fiori_3";return B.extend("sap.ui.documentation.sdk.controller.App",{formatter:h,_arrToTreeConverter:function(){var a,b=this._aNeoAppVersions.slice(),e=[],j=0,l="";for(var i=0;i<b.length;i++){l=b[i].groupTitle;j=0;a=[];while(b[i]&&b[i].groupTitle&&b[i].groupTitle===l){a.push(b[i]);j++;i++;}i--;e.push({"groupTitle":l,"version":l+" ("+j+" versions)","nodes":a});}return e;},onInit:function(){B.prototype.onInit.call(this);var a=new J({busy:false,delay:0,bPhoneSize:false,bShowVersionSwitchInHeader:false,bShowVersionSwitchInMenu:false,bLandscape:D.orientation.landscape,bHasMaster:false,bSearchMode:false,bHideTopicSection:!!window['sap-ui-documentation-hideTopicSection'],bHideApiSection:!!window['sap-ui-documentation-hideApiSection'],sAboutInfoSAPUI5:"Looking for the Demo Kit for a specific SAPUI5 version? "+"Check at <a href = 'https://sapui5.hana.ondemand.com/versionoverview.html'>https://sapui5.hana.ondemand.com/versionoverview.html</a> "+"which versions are available. "+"You can view the version-specific Demo Kit by adding the version number to the URL, e.g. "+"<a href='https://sapui5.hana.ondemand.com/1.52.4/'>https://sapui5.hana.ondemand.com/1.52.4/</a>",sAboutInfoOpenUI5:"Looking for the Demo Kit for a specific OpenUI5 version? "+"Check at <a href = 'https://openui5.hana.ondemand.com/versionoverview.html'>https://openui5.hana.ondemand.com/versionoverview.html</a> "+"which versions are available. "+"You can view the version-specific Demo Kit by adding the version number to the URL, e.g. "+"<a href='https://openui5.hana.ondemand.com/1.52.4/'>https://openui5.hana.ondemand.com/1.52.4/</a>"});var b=this.getOwnerComponent();this.MENU_LINKS_MAP={"legal":"https://www.sap.com/corporate/en/legal/impressum.html","privacy":"https://www.sap.com/corporate/en/legal/privacy.html","terms_of_use":"https://www.sap.com/corporate/en/legal/terms-of-use.html","copyright":"https://www.sap.com/corporate/en/legal/copyright.html","trademark":"https://www.sap.com/corporate/en/legal/trademark.html","disclaimer":"https://help.sap.com/viewer/disclaimer","sitemap":"sitemap","license":"LICENSE.txt"};this.getOwnerComponent().loadVersionInfo().then(function(){var e;if(this.getModel("versionData").getProperty("/isOpenUI5")){this.MENU_LINKS_MAP["Terms of Use"]="TermsOfUse.txt";e="OPENUI5";}else{e="SAPUI5";}t=t.replace("\uFFFD",e);Object.keys(W).forEach(function(i){W[i]=W[i].replace("\uFFFD",e);});if(this._sKey){this.appendPageTitle(null).appendPageTitle(W[this._sKey]);}}.bind(this));this._oSupportedLangModel=new J();this.setModel(this._oSupportedLangModel,"supportedLanguages");this.setModel(new J(),"messagesData");this._oView=this.getView();this.setModel(a,"appView");this.oHeader=this._oView.byId("headerToolbar");this.oRouter=this.getRouter();this._selectHeader=this._oView.byId("selectHeader");this._tabHeader=this._oView.byId("tabHeader");this._oConfigUtil=this.getOwnerComponent().getConfigUtil();this._oCookieNames=this._oConfigUtil.COOKIE_NAMES;this._bSupportsPrefersColorScheme=!!(window.matchMedia&&(window.matchMedia('(prefers-color-scheme: dark)').matches||window.matchMedia('(prefers-color-scheme: light)').matches));R.register(this.oHeader,this.onHeaderResize.bind(this));this.oRouter.attachRouteMatched(this.onRouteChange.bind(this));this.oRouter.attachBypassed(this.onRouteNotFound.bind(this));this._registerFeedbackRatingIcons();this._requestVersionInfo();this.byId("splitApp").attachEvent("afterMasterClose",function(e){a.setProperty("/bIsShownMaster",false);},this);this.bus=g.getEventBus();this._createConfigurationBasedOnURIInput();this.getOwnerComponent().loadMessagesInfo().then(function(e){if(e){this._updateMessagesModel(e);}}.bind(this));if(this._oConfigUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES)==="1"&&this._aConfiguration.length>0){this._applyCookiesConfiguration(this._aConfiguration);}else{this._applyDefaultConfiguration(this._aConfiguration);}this.initSearch();document.addEventListener("keydown",function(e){if(e.keyCode===K.F&&e.shiftKey&&e.ctrlKey){this.byId("searchControl")._toggleOpen(true);}}.bind(this));b.getCookiesManagement().enable(b.getRootControl());},_updateMessagesModel:function(a){var b=this._oConfigUtil.getCookieValue(this._oCookieNames["DEMOKIT_IMPORTANT_MESSAGES_READ"]),i=0;a.messages.length&&a.messages.forEach(function(e){e.isMessageVisible=(new Date(e.expire).getTime()-new Date())>0&&!b.includes(e.id);e.isMessageVisible&&i++;});a.iVisibleMessagesCount=i;this.getModel("messagesData").setData(a);},onBeforeRendering:function(){D.orientation.detachHandler(this._onOrientationChange,this);},onAfterRendering:function(){q(document.body).addClass(this.getOwnerComponent().getContentDensityClass());D.orientation.attachHandler(this._onOrientationChange,this);},onExit:function(){D.orientation.detachHandler(this._onOrientationChange,this);if(this.highlighter){this.highlighter.destroy();}},onRouteChange:function(e){if(!this.oRouter.getRoute(e.getParameter("name"))._oConfig.target){return;}var a=e.getParameter("name"),b=this.oRouter.getRoute(a)._oConfig.target[0]+"Tab",i=this._oView.byId(b),j=i?i.getKey():"home",l=this.getModel("appView"),a1=l.getProperty("/bPhoneSize"),b1=l.getProperty("/bSearchMode"),c1=D.system.phone,d1=this.getOwnerComponent().getConfigUtil().hasMasterView(a),e1,f1;this._setHeaderSelectedKey(j);l.setProperty("/bHasMaster",d1);if(a1&&!b1){this._selectHeader.setVisible(true);}if(c1&&d1){e1=this.getOwnerComponent().getConfigUtil().getMasterView(a);f1=e1&&e1.getId();l.setProperty("/sMasterViewId",f1);}this.byId("splitApp").hideMaster();l.setProperty("/bIsShownMaster",false);this.appendPageTitle(null).appendPageTitle(W[j]);},toggleMaster:function(e){var b=e.getParameter("pressed"),a=D.system.phone,i=this.byId("splitApp"),j=i.getMode()===r.ShowHideMode,l=i.getMode()===r.HideMode,a1=this.getModel("appView").getProperty("/sMasterViewId"),b1;if(!a&&(j||l)){b1=(b)?i.showMaster:i.hideMaster;b1.call(i);return;}if(a){if(b){i.to(a1);}else{i.backDetail();}}},navigateToSection:function(e){var a=e.getParameter("key"),i;if(!a){i=e.getParameter("selectedItem");i&&(a=i.getKey());}e.preventDefault();if(a&&a!=="home"){this.getRouter().navTo(a,{});}else{this.getRouter().navTo("welcome",{});this._setHeaderSelectedKey("home");}},handleMenuItemClick:function(e){var a=e.getParameter("item").getKey(),b=this.MENU_LINKS_MAP[a];if(a===A){this.aboutDialogOpen();}else if(a===x){this.feedbackDialogOpen();}else if(a===E){this.settingsDialogOpen();}else if(a===G){this.getOwnerComponent().getCookiesManagement().cookieSettingsDialogOpen({showCookieDetails:true},this.getView());}else if(a===z){this.onChangeVersionButtonPress();}else if(Y[a]){this._updateAppearance(a);}else if(b===_){this.onSiteMapPress();}else if(b){v.redirect(b,true);}this.sTarget=b;},createSearchPopover:function(){var a=m.PlacementType,b=this.getView().byId("searchControl"),e=new k({showArrow:false,showHeader:false,contentWidth:"600px",placement:a.Vertical,horizontalScrolling:false,initialFocus:this.getView().byId("searchControl-searchField")}).addStyleClass("sapMSltPicker-CTX");e.open=function(){e.openBy(b);};this.getView().addDependent(e);return e;},createSearchPicker:function(){var a=D.system.phone?this.createSearchDialog():this.createSearchPopover();this.createSearchPickerContent().then(function(b){a.addContent(b);});return a;},createSearchDialog:function(){var a,b,e,i,j,l,a1;var b1=this.getView().byId("searchControl");e=new(sap.ui.require('sap/m/SearchField'))({liveChange:function(d1){var e1=d1.getParameter("newValue");b1._updateValue(e1);b1.fireLiveChange({newValue:e1});},search:function(d1){if(!d1.getParameter("clearButtonPressed")){a.close();a1=true;}}});l=new n({icon:"sap-icon://decline",press:function(){a._oCloseTrigger=true;a.close();b1._updateValue(b);}});i=new T({content:[e,l]});j=new n({text:g.getLibraryResourceBundle("sap.m").getText("MSGBOX_OK"),press:function(){a.close();}});function c1(el){if(typeof el.selectionStart=="number"){el.selectionStart=el.selectionEnd=el.value.length;}else if(typeof el.createTextRange!="undefined"){el.focus();var d1=el.createTextRange();d1.collapse(false);d1.select();}}a=new(sap.ui.require('sap/m/Dialog'))({stretch:true,customHeader:i,beginButton:j,beforeClose:function(){b1._bSuggestionSuppressed=true;},beforeOpen:function(){b=b1.getValue();e._updateValue(b);a1=false;},afterOpen:function(){var d1=e.$().find('input');d1.trigger("focus");c1(d1.get(0));},afterClose:function(d1){if(a1){b1.fireSearch({query:b1.getValue(),clearButtonPressed:false});}}});this.getView().addDependent(a);return a;},createSearchPickerContent:function(){return d.load({name:"sap.ui.documentation.sdk.view.GlobalSearchPicker",controller:this}).then(function(a){var b=g.byId("shortList"),e=this,i;b.addEventDelegate({onAfterRendering:function(){var j={useExternalStyles:false,shouldBeObserved:true,isCaseSensitive:false};e.highlighter=new H(b.getDomRef(),j);i=e.getModel("searchData").getProperty("/query");i&&e.highlighter.highlight(i);b.removeEventDelegate(this);}});return a;}.bind(this));},initSearch:function(){var a=this.getModel("searchData"),b={"topics":["topic","topicId","subTopicId"],"entity":["sample","controlsMaster","controls","code","entity"],"apiref":["api","apiSpecialRoute","apiId"]};this.oRouter.attachRouteMatched(function(){a.setProperty("/preferencedCategory",null);});Object.keys(b).forEach(function(e){var i=b[e];i.forEach(function(j){this.oRouter.getRoute(j).attachPatternMatched(function(){a.setProperty("/preferencedCategory",e);});}.bind(this));}.bind(this));},getSearchPickerTitle:function(a){var b=g.getLibraryResourceBundle("sap.ui.documentation"),e;switch(this.getModel("searchData").getProperty("/preferencedCategory")){case"topics":e=b.getText("SEARCH_SUGGESTIONS_TITLE_DOCUMENTATION");break;case"apiref":e=b.getText("SEARCH_SUGGESTIONS_TITLE_API_REFERENCE");break;case"entity":e=b.getText("SEARCH_SUGGESTIONS_TITLE_SAMPLES");break;default:e=b.getText("SEARCH_SUGGESTIONS_TITLE_ALL");}return e;},onSearchResultsSummaryPress:function(e){var a=e.oSource.data("category");this.navToSearchResults(a);},onSearchPickerItemPress:function(e){var a=e.oSource.getBindingContextPath(),b=this.getModel("searchData").getProperty(a);this.getRouter().parsePath(b.path);this.oPicker.close();},_updateAppearance:function(a){if(a===X&&this._bSupportsPrefersColorScheme){this._toggleLightOrDarkAppearance(window.matchMedia('(prefers-color-scheme: dark)').matches);this._attachPrefersColorSchemeChangeListener();}else{g.applyTheme(Y[a]);}this._sLastKnownAppearanceKey=a;this.bus.publish("themeChanged","onDemoKitThemeChanged",{sThemeActive:Y[a]});if(this._oConfigUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES)==="1"){this._oConfigUtil.setCookie($,a);}},_toggleLightOrDarkAppearance:function(i){if(i){g.applyTheme(Y[Q]);}else{g.applyTheme(Y[P]);}},_attachPrefersColorSchemeChangeListener:function(){var a=this;if(!this._bAttachedPrefersColorSchemeChangeListener){var b=window.matchMedia('(prefers-color-scheme: dark)');var i=function(e){if(a._sLastKnownAppearanceKey===X){a._toggleLightOrDarkAppearance(e.matches);a.bus.publish("themeChanged","onDemoKitThemeChanged",{sThemeActive:Y[e.matches?Q:P]});}};if(b.addEventListener){b.addEventListener('change',i);}else{b.addListener(i);}this._bAttachedPrefersColorSchemeChangeListener=true;}},_createConfigurationBasedOnURIInput:function(){var a=U.fromQuery(window.location.search);this._aConfiguration=[];if(!(a.has('sap-ui-language')||a.has('sap-language'))){this._aConfiguration.push(Z);}if(!(a.has('sap-ui-theme')||a.has('sap-theme'))){this._aConfiguration.push($);}},_applyDefaultConfiguration:function(){this._aConfiguration.forEach(function(a){if(a===Z){g.getConfiguration().setLanguage(O);}else if(a===$){this._updateAppearance(X);}},this);this._oSupportedLangModel.setProperty("/selectedLang",g.getConfiguration().getLanguage());},_applyCookiesConfiguration:function(){var a,b,i;for(i=0;i<this._aConfiguration.length;i++){b=this._aConfiguration[i];a=this._oConfigUtil.getCookieValue(b);if(a!==""){if(b===Z){this._setSelectedLanguage(a);}else if(b===$){this._updateAppearance(a);}this._aConfiguration.splice(i,1);i--;}}if(this._aConfiguration.length>0){this._applyDefaultConfiguration();}},_prepareSupportedLangModelData:function(){return g.getConfiguration().getLanguagesDeliveredWithCore().reduce(function(a,l){var b,e=l,i=l;if(typeof l==="string"&&l.length>0){switch(l){case"sh":e="sr_Latn";break;case"no":e="nb";break;case"iw":e="he";i="he";break;case"zh_TW":i="zh_Hant";break;case"zh_CN":i="zh_Hans";break;}a.push(new Promise(function(j,a1){p.loadResource("sap/ui/core/cldr/"+e+".json",{async:true}).then(function(b1){b=b1.languages[i];j({"text":typeof b==='string'?b.charAt(0).toUpperCase()+b.substring(1):"Unknown","key":l});});}));}return a;},[]);},_setSelectedLanguage:function(l){this._oSupportedLangModel.setProperty("/selectedLang",l);g.getConfiguration().setLanguage(l);if(this._oConfigUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES)==="1"){this._oConfigUtil.setCookie(Z,l);}},_getSelectedLanguage:function(){return this._oSupportedLangModel.getProperty("/selectedLang");},settingsDialogOpen:function(){var a;if(!this._oSettingsDialog){d.load({name:"sap.ui.documentation.sdk.view.globalSettingsDialog",controller:this}).then(function(b){this._oView.addDependent(b);this._oSettingsDialog=b;g.byId("LanguageSelect").setSelectedKey(this._getSelectedLanguage());this._oSettingsDialog.open();}.bind(this));}else{this._oSettingsDialog.open();}if(!this._oSupportedLangModel.getProperty("/langs")){a=this._oSupportedLangModel;a.setProperty("/selectBusy",true);Promise.all(this._prepareSupportedLangModelData()).then(function(b){a.setProperty("/selectBusy",false);a.setProperty("/langs",b);});}},handleCloseAppSettings:function(){this._oSettingsDialog.close();},handleSaveAppSettings:function(){var l=g.byId('LanguageSelect').getSelectedKey();this._oSettingsDialog.close();this._applyAppConfiguration(l);},_applyAppConfiguration:function(l){this._setSelectedLanguage(l);},aboutDialogOpen:function(){if(!this._oAboutDialog){this._oAboutDialog=new sap.ui.xmlfragment("aboutDialogFragment","sap.ui.documentation.sdk.view.AboutDialog",this);this._oView.addDependent(this._oAboutDialog);}else{this._oAboutDialog.getContent()[0].backToTop();}this._oAboutDialog.open();},aboutDialogClose:function(e){this._oAboutDialog.close();},onAboutVersionDetails:function(e){var a=this.getModel("appView"),b=a.getData(),j=this;f._loadAllLibInfo("","_getLibraryInfo","",function(c1,d1){var e1={};var f1=f._getLibraryInfoSingleton();for(var i=0,l=c1.length;i<l;i++){c1[i]=d1[c1[i]];c1[i].libDefaultComponent=f1._getDefaultComponent(c1[i]);}e1.libs=c1;b.oVersionInfo=e1;a.setData(b);j.setModel(a,"appView");});var a1=d.byId("aboutDialogFragment","aboutNavCon"),b1=d.byId("aboutDialogFragment","aboutDetail");a1.to(b1);},onAboutThirdParty:function(e){var l=this.getModel("appView"),a1=l.getData(),b1=this;f._loadAllLibInfo("","_getThirdPartyInfo",function(e1,f1){if(!e1){return;}var g1={};g1.thirdparty=[];for(var j=0;j<e1.length;j++){var h1=f1[e1[j]];for(var i=0;i<h1.libs.length;i++){var i1=h1.libs[i];i1._lib=e1[j];g1.thirdparty.push(i1);}}g1.thirdparty.sort(function(a,b){var j1=(a.displayName||"").toUpperCase();var k1=(b.displayName||"").toUpperCase();if(j1>k1){return 1;}else if(j1<k1){return-1;}else{return 0;}});a1.oThirdPartyInfo=g1;l.setData(a1);b1.setModel(l,"appView");});var c1=d.byId("aboutDialogFragment","aboutNavCon"),d1=d.byId("aboutDialogFragment","aboutThirdParty");c1.to(d1);},onReleaseDialogOpen:function(e){var l=f._getLibraryInfoSingleton(),a=e.getSource().data("version"),b=e.getSource().data("library"),i=new J(),j=new J(),a1=this;if(!this._oReleaseDialog){this._oReleaseDialog=new sap.ui.xmlfragment("releaseDialogFragment","sap.ui.documentation.sdk.view.ReleaseDialog",this);this._oView.addDependent(this._oReleaseDialog);}if(!this._oNotesView){this._oNotesView=sap.ui.view({id:"notesView",viewName:"sap.ui.documentation.sdk.view.ReleaseNotesView",type:"Template"});this._oNotesView.setModel(i);}l._getReleaseNotes(b,a,function(b1,a){var c1={};if(b1&&b1[a]&&b1[a].notes&&b1[a].notes.length>0){a1._oNotesView.getModel().setData(b1);a1._oNotesView.bindObject("/"+a);}else{c1.noData=true;}c1.library=b;j.setData(c1);});this._oReleaseDialog.setModel(j);this._oReleaseDialog.addContent(this._oNotesView);this._oReleaseDialog.open();},onReleaseDialogClose:function(e){this._oReleaseDialog.close();},onAboutNavBack:function(e){var a=d.byId("aboutDialogFragment","aboutNavCon");a.back();},onChangeVersionButtonPress:function(){this.getVersionSwitchDialog().open();},onCloseVersionDialog:function(){this.getVersionSwitchDialog().close();},onChangeVersionDialogSearch:function(e){var a=e.getParameter("newValue"),b=new F("version",c.Contains,a),i=g.byId("versionList"),j=i.getBinding("items");j.filter([b]);if(j.getChildCount()===1){j.expand(0);}else{i.collapseAll();}},onLogoIconPress:function(){this.oRouter.navTo("welcome",{});},onSiteMapPress:function(){this.oRouter.navTo("sitemap",{});},onLatestVersionItemPress:function(){if(o.getResourcesVersion()){window.sessionStorage.removeItem("versionPrefixPath");window.location.reload();}else{window.location.href="/";}},onVersionItemPress:function(e){var a=sap.ui.getCore().byId("versionList").getSelectedItem(),b=a.getCustomData()[0];if(b&&b.getKey()==="path"){if(o.getHasProxy()){window.sessionStorage.setItem("versionPrefixPath",b.getValue());window.location.reload();}else{window.location.href=b.getValue();}}},getVersionSwitchDialog:function(){if(!this._oChangeVersionDialog){this._createVersionDialog();}return this._oChangeVersionDialog;},versionSwitchCustomComparator:function(a,b){return V(a).compareTo(V(b));},_updateVersionSwitchVisibility:function(){var a=this.getModel("appView"),b=a.getProperty("/bPhoneSize");a.setProperty("/bShowVersionSwitchInHeader",!b&&!!this._aNeoAppVersions);a.setProperty("/bShowVersionSwitchInMenu",b&&!!this._aNeoAppVersions);},_createVersionDialog:function(){this._oChangeVersionDialog=new sap.ui.xmlfragment("sap.ui.documentation.sdk.view.ChangeVersionDialog",this);this._oChangeVersionDialog.setModel(this._buildVersionDialogModel());this._oView.addDependent(this._oChangeVersionDialog);},_buildVersionDialogModel:function(){var a=new J();a.setSizeLimit(1000);a.setData(this._aNeoAppVersions);a.setData(this._arrToTreeConverter(this._aNeoAppVersions));return a;},feedbackDialogOpen:function(){var a=this;var b;if(!this._oFeedbackDialog){b=this.getModel("i18n").getResourceBundle();this._oFeedbackDialog=new sap.ui.xmlfragment("feedbackDialogFragment","sap.ui.documentation.sdk.view.FeedbackDialog",this);this._oView.addDependent(this._oFeedbackDialog);this._oFeedbackDialog.textInput=d.byId("feedbackDialogFragment","feedbackInput");this._oFeedbackDialog.contextCheckBox=d.byId("feedbackDialogFragment","pageContext");this._oFeedbackDialog.contextData=d.byId("feedbackDialogFragment","contextData");this._oFeedbackDialog.ratingStatus=d.byId("feedbackDialogFragment","ratingStatus");this._oFeedbackDialog.ratingStatus.value=0;this._oFeedbackDialog.sendButton=d.byId("feedbackDialogFragment","sendButton");this._oFeedbackDialog.ratingBar=[{button:d.byId("feedbackDialogFragment","excellent"),status:"Excellent",displayStatus:b.getText("FEEDBACK_DIALOG_STATUS_EXCELLENT")},{button:d.byId("feedbackDialogFragment","good"),status:"Good",displayStatus:b.getText("FEEDBACK_DIALOG_STATUS_GOOD")},{button:d.byId("feedbackDialogFragment","average"),status:"Average",displayStatus:b.getText("FEEDBACK_DIALOG_STATUS_AVERAGE")},{button:d.byId("feedbackDialogFragment","poor"),status:"Poor",displayStatus:b.getText("FEEDBACK_DIALOG_STATUS_POOR")},{button:d.byId("feedbackDialogFragment","veryPoor"),status:"Very Poor",displayStatus:b.getText("FEEDBACK_DIALOG_STATUS_VERY_POOR")}];this._oFeedbackDialog.reset=function(){this.sendButton.setEnabled(false);this.textInput.setValue("");this.contextCheckBox.setSelected(true);this.ratingStatus.setText("");this.ratingStatus.setState("None");this.ratingStatus.value=0;this.contextData.setVisible(false);this.ratingBar.forEach(function(e){if(e.button.getPressed()){e.button.setPressed(false);}});};this._oFeedbackDialog.updateContextData=function(){var e=a._getUI5Version(),i=a._getUI5Distribution();if(this.contextCheckBox.getSelected()){this.contextData.setValue("Location: "+a._getCurrentPageRelativeURL()+"\n"+i+" Version: "+e);}else{this.contextData.setValue(i+" Version: "+e);}};this._oFeedbackDialog.updateContextData();}this._oFeedbackDialog.updateContextData();if(!this._oFeedbackDialog.isOpen()){s("sapUiSizeCompact",this.getView(),this._oFeedbackDialog);this._oFeedbackDialog.open();}},onFeedbackDialogSend:function(){var a=V(sap.ui.version),b={"text":this._oFeedbackDialog.textInput.getValue(),"rating":this._oFeedbackDialog.ratingStatus.value,"major":a.getMajor(),"minor":a.getMinor(),"patch":a.getPatch(),"distribution":this._getUI5Distribution(),"snapshot":a.getSuffix().indexOf("SNAPSHOT")>-1,"url":this._getCurrentURL(),"page":this._getCurrentPageRelativeURL(),"pageContext":this._oFeedbackDialog.contextCheckBox.getSelected()},e=this.getModel("i18n").getResourceBundle();this._oFeedbackDialog.setBusyIndicatorDelay(0);this._oFeedbackDialog.setBusy(true);q.ajax({url:y,type:"POST",contentType:"application/json",data:JSON.stringify(b)}).done(function(){M.success(e.getText("FEEDBACK_DIALOG_TEXT_SUCCESS"),{title:e.getText("FEEDBACK_DIALOG_TITLE_SUCCESS")});this._oFeedbackDialog.reset();this._oFeedbackDialog.close();this._oFeedbackDialog.setBusy(false);}.bind(this)).fail(function(i,j,l){var a1=l;M.error(e.getText("FEEDBACK_DIALOG_TEXT_ERROR")+a1,{title:e.getText("FEEDBACK_DIALOG_TITLE_ERROR")});this._oFeedbackDialog.setBusy(false);}.bind(this));},onFeedbackDialogCancel:function(){this._oFeedbackDialog.reset();this._oFeedbackDialog.close();},onShowHideContextData:function(){this._oFeedbackDialog.contextData.setVisible(!this._oFeedbackDialog.contextData.getVisible());},onContextSelect:function(){this._oFeedbackDialog.updateContextData();},onPressRatingButton:function(e){var a=this;var b=e.getSource();a._oFeedbackDialog.ratingBar.forEach(function(j){if(b!==j.button){j.button.setPressed(false);}else{if(!j.button.getPressed()){i("None","",0);}else{switch(j.status){case"Excellent":i("Success",j.displayStatus,5);break;case"Good":i("Success",j.displayStatus,4);break;case"Average":i("None",j.displayStatus,3);break;case"Poor":i("Warning",j.displayStatus,2);break;case"Very Poor":i("Error",j.displayStatus,1);}}}});function i(j,l,a1){a._oFeedbackDialog.ratingStatus.setState(j);a._oFeedbackDialog.ratingStatus.setText(l);a._oFeedbackDialog.ratingStatus.value=a1;if(a1){a._oFeedbackDialog.sendButton.setEnabled(true);}else{a._oFeedbackDialog.sendButton.setEnabled(false);}}},onSearch:function(e){var a=encodeURIComponent(e.getParameter("query"));if(!a){return;}this.getRouter().navTo("search",{searchParam:a},false);this.oPicker.close();},navToSearchResults:function(a){var b=this.getModel("searchData").getProperty("/query"),e={searchParam:b};if(!b){return;}if(a){e["?options"]={category:a};}this.getRouter().navTo("search",e,true);this.oPicker.close();},onSearchLiveChange:function(e){var a=this.getModel("searchData"),b=e.getParameter("newValue"),i=a.getProperty("/preferencedCategory"),j=a.getProperty("/includeDeprecated");if(!this.oPicker){this.oPicker=this.createSearchPicker();}if(!this.oPicker.isOpen()){this.oPicker.open();}if(this.highlighter){this.highlighter.highlight(b);}a.setProperty("/query",b);S.search(b,{preferencedCategory:i,includeDeprecated:j}).then(function(l){a.setProperty("/matches",l.matches);});},onHeaderResize:function(e){var i=e.size.width,b=D.system.phone||i<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0],a=this.getModel("appView"),j=a.getProperty("/bSearchMode");if(b!==a.getProperty("/bPhoneSize")){a.setProperty("/bPhoneSize",b);this._updateVersionSwitchVisibility();this._tabHeader.setVisible(!b);this._selectHeader.setVisible(b);}if(j){this._selectHeader.setVisible(false);}},_onOrientationChange:function(){this.getModel("appView").setProperty("/bLandscape",D.orientation.landscape);},onToggleSearchMode:function(e){var b=e.getParameter("isOpen"),a=this.getModel("appView"),i=a.getProperty("/bPhoneSize");a.setProperty("/bSearchMode",b);if(b){S.init();setTimeout(function(){this._oView.byId("searchControl").getAggregation("_searchField").getFocusDomRef().focus();}.bind(this),0);if(i){this._selectHeader.setVisible(false);}}else if(i){this._selectHeader.setVisible(true);}},_registerFeedbackRatingIcons:function(){I.addIcon("icon-face-very-bad","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E086",suppressMirroring:true});I.addIcon("icon-face-bad","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E087",suppressMirroring:true});I.addIcon("icon-face-neutral","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E089",suppressMirroring:true});I.addIcon("icon-face-happy","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E08B",suppressMirroring:true});I.addIcon("icon-face-very-happy","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E08C",suppressMirroring:true});},_processVersionOverview:function(a){var b=a.versions,e=[];if(Array.isArray(b)){b=b.filter(function(i){return!!i.hidden;}).forEach(function(i){var j=i.hidden.split(",").map(function(l){return l.trim();});e=e.concat(j);});}return e;},_processNeoAppJSON:function(a){var b=this.getModel("versionData"),i=b.getProperty("/isInternal"),e=b.getProperty("/isSnapshotVersion"),j=[];if(!(a&&a.routes)){L.warning("No versions were found");return;}j=a.routes;j.pop();if(!i&&!e){j=j.filter(function(l){return l.target.version.indexOf("-beta")===-1;});}j=j.map(function(l){var a1=V(l.target.version),b1={};b1.patchVersion=a1.getPatch();b1.groupTitle=a1.getMajor()+"."+a1.getMinor();b1.version=a1.toString();b1.path=l.path;return b1;});return j;},_requestVersionInfo:function(){Promise.all([q.ajax(N),q.ajax(w)]).then(function(a){var b=this._processNeoAppJSON(a[0]),e=this._processVersionOverview(a[1]);if(Array.isArray(b)){b=b.filter(function(i){return e.indexOf(i.version)===-1;});this._aNeoAppVersions=b;this._updateVersionSwitchVisibility();this.getModel("versionData").setProperty("/latestVersion",this._aNeoAppVersions[0].version);}else{L.warning("No multi-version environment detected");}}.bind(this),function(){L.warning("No neo-app.json or versionoverview.json was detected");});},_getUI5Version:function(){return o.getResourcesVersion()?window.sessionStorage.getItem("versionPrefixPath"):this.getModel("versionData").getProperty("/version");},_getUI5VersionGav:function(){return this.getModel("versionData").getProperty("/versionGav");},_getUI5Distribution:function(){var a=this._getUI5VersionGav();var b="SAPUI5";if(a&&/openui5/i.test(a)){b="OpenUI5";}return b;},_getCurrentPageRelativeURL:function(){var a=window.location;return a.pathname+a.hash+a.search;},_getCurrentURL:function(){var a=window.location;return a.href;},_setHeaderSelectedKey:function(a){this._selectHeader.setSelectedKey(a);this._tabHeader.setSelectedKey(a);this._sKey=a;},onCloseImportantMessage:function(e){var a=this._oConfigUtil.getCookieValue(this._oCookieNames["DEMOKIT_IMPORTANT_MESSAGES_READ"]).split(",").filter(function(j){return j!=='';}),b=e.getSource().getCustomData().find(function(b){return b.getKey()==="messageID";}),i=b.getValue();a.push(i);this._oConfigUtil.setCookie(this._oCookieNames["DEMOKIT_IMPORTANT_MESSAGES_READ"],a.join(","));this._updateMessagesModel(this.getModel("messagesData").getData());}});});
