/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/SampleBaseController","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/model/formatter","sap/ui/model/json/JSONModel","sap/base/util/merge","sap/ui/core/Component","sap/ui/core/Core"],function(q,S,C,f,J,m,a,b){"use strict";return S.extend("sap.ui.documentation.sdk.controller.Code",{onInit:function(){S.prototype.onInit.call(this);this.oModel=new J();this.getView().setModel(this.oModel);this.router=this.getRouter();this.router.getRoute("code").attachPatternMatched(this.onRouteMatched,this);this.router.getRoute("codeFile").attachPatternMatched(this.onRouteMatched,this);this._aFilesAvailable=[];this._bFirstLoad=true;this.bus=b.getEventBus();this.bus.subscribe("themeChanged","onDemoKitThemeChanged",this.onDemoKitThemeChanged,this);},onDemoKitThemeChanged:function(c,e,d){this._updateCodeEditorTheme(d.sThemeActive);},onRouteMatched:function(e){var A=e.getParameter("arguments");this.showMasterSide();this._sId=A.sampleId;this._sEntityId=A.entityId;this._sFileName=f.routeParamsToFilePath(A);C.loadData().then(this._loadCode.bind(this));},_loadCode:function(d){var F=this._sFileName,s=d.samples[this._sId];if(!s||(s.contexts&&!s.contexts[this._sEntityId])){this.onRouteNotFound();return;}if(!this._oData||s.id!==this._oData.id){this._createComponent().then(function(c){var M=c.getMetadata();var p=[];var o=(M)?M.getConfig():null;this._oData={id:s.id,title:"Code: "+s.name,name:s.name,stretch:o.sample?o.sample.stretch:false,files:[],iframe:o.sample.iframe,fileName:F,includeInDownload:o.sample.additionalDownloadFiles};if(o&&o.sample&&o.sample.files){var r=sap.ui.require.toUrl((s.id).replace(/\./g,"/"));for(var i=0;i<o.sample.files.length;i++){var e=o.sample.files[i];p.push(this._updateFileContent(r,e));this._oData.files.push({name:e});this._aFilesAvailable.push(e);}}return Promise.all(p);}.bind(this)).then(this._showCode.bind(this,F));}else{this._oData.fileName=F;this._showCode(F);}},_showCode:function(F){this.getAPIReferenceCheckPromise(this._sEntityId).then(function(h){this.getView().byId("apiRefButton").setVisible(h);}.bind(this));this.oModel.setData(this._oData);if(F===undefined){F=this._getInitialFileName();}if(this._aFilesAvailable.indexOf(F)===-1){this.onRouteNotFound();return;}this._updateCodeEditor(F);this._getTabHeader().setSelectedKey(F);var p=this.byId("page");p.scrollTo(0);this.appendPageTitle(this.getModel().getProperty("/title"));},_updateFileContent:function(r,F){return this.fetchSourceFile(r+"/"+F).then(function(c){this._oData.files.some(function(o){if(o.name===F){o.raw=c;o.code=this._convertCodeToHtml(c);return true;}},this);this.oModel.setData(this._oData);}.bind(this));},onAPIRefPress:function(){this.getRouter().navTo("apiId",{id:this._sEntityId});},onNavBack:function(){this.router.navTo("sample",{sampleId:this._sId,entityId:this._sEntityId});},_convertCodeToHtml:function(c){c=c.toString();c=c.replace(/^function.+{/,"");c=c.replace(/}[!}]*$/,"");c=c.replace(/^[\n\s\S]*\/\/\s*CODESNIP_START\n/,"");c=c.replace(/\/\/\s*CODESNIP_END[\n\s\S]*$/,"");c=c.replace(/\t/g,"  ");return c;},handleTabSelectEvent:function(e){var F=e.getParameter("selectedKey"),r=m(f.filePathToRouteParams(F),{entityId:this._sEntityId,sampleId:this._sId});this._bFirstLoad=false;this.router.navTo("codeFile",r,false);},_updateCodeEditor:function(F){var c=this._getCodeEditor(),A=c.getInternalEditorInstance(),o=A.renderer;c.setValue(this._getCode(F));c.setType(this._getFileType(F));A.gotoLine(0,0,false);if(this._bFirstLoad){setTimeout(function(){o.onResize();},0);}this._updateCodeEditorTheme(b.getConfiguration().getTheme().toLowerCase());},_updateCodeEditorTheme:function(t){var e="tomorrow";if(t.indexOf("hcb")>-1){e="chaos";}else if(t.indexOf("hcw")>-1){e="github";}else if(t==="sap_fiori_3"){e="crimson_editor";}else if(t==="sap_fiori_3_dark"){e="clouds_midnight";}this._getCodeEditor().setColorTheme(e);},_getCode:function(F){var c=this.getModel().getData().files,s="";c.forEach(function(o){if(o.name===F){s=o.raw;return true;}});return s;},_getFileType:function(F){var s=F.split('.').pop();return s==="js"?"javascript":s;},_getInitialFileName:function(){return(this._oData&&this._oData.files&&this._oData.files.length>0&&this._oData.files[0].name)||null;},_getCodeEditor:function(){if(!this.oCodeEditor){this.oCodeEditor=this.byId("codeEditor");}return this.oCodeEditor;},_getTabHeader:function(){if(!this.oTabHeader){this.oTabHeader=this.byId("tabHeader");}return this.oTabHeader;},_createComponent:function(){var c='sampleComp-'+this._sId;var s=this._sId;var o=a.get(c);if(o){o.destroy();}return a.create({id:c,name:s});}});});
