/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/dt/TaskManager","sap/ui/dt/Util","sap/base/Log"],function(T,D,B){"use strict";var a=function(p){if(!p||!p.taskManager||!(p.taskManager instanceof T)){throw D.createError("TaskRunner#constructor","sap.ui.dt.TaskRunner: TaskManager required");}this._oTaskManager=p.taskManager;this._sInitialTaskType=p.taskType;this._sObservedTaskType=p.taskType;this._iRequestId=undefined;this.bIsStopped=true;this._oTaskPromise=Promise.resolve();};a.prototype._shouldObserveBreak=function(){if(this.bIsStopped||!this._oTaskManager||this._oTaskManager.bIsDestroyed){this.bIsStopped=true;return true;}return false;};a.prototype._observe=function(e){this._oTaskPromise=this._oTaskPromise.then(function(){if(this._shouldObserveBreak()){return this.stop();}this._runTasksFromManager(e);}.bind(this));};a.prototype._runTasksFromManager=function(){var t=this._oTaskManager.getQueuedTasks(this._sObservedTaskType);if(t.length){this._runTasks(t);}};a.prototype._runTasks=function(t){var b=[];for(var i=0,n=t.length;i<n;i++){if(t[i].callbackFn){try{b.push(t[i].callbackFn().then(this._oTaskManager.complete.bind(this._oTaskManager,t[i].id)));}catch(e){B.error(D.errorToString(e));}}}};a.prototype.run=function(t){this._sObservedTaskType=t||this._sInitialTaskType;this.bIsStopped=false;this._oTaskManager.attachAdd(this._observe,this);this._observe();};a.prototype.stop=function(){this.bIsStopped=true;this._oTaskManager.detachAdd(this._observe,this);};return a;});
