/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/each","sap/ui/core/support/Plugin","sap/ui/core/support/Support","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/model/json/JSONModel","sap/ui/fl/FlexController","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/Utils","sap/ui/fl/support/apps/uiFlexibilityDiagnostics/helper/Extractor","sap/ui/core/mvc/XMLView","sap/ui/core/Component"],function(e,P,S,J,a,F,C,U,E,X,b){"use strict";var c=P.extend("sap.ui.fl.support.Flexibility",{constructor:function(s){P.apply(this,["sapUiSupportFlexibility","Flexibility",s]);this._oStub=s;if(this.runsAsToolPlugin()){this._aEventIds=[this.getId()+"SetApps",this.getId()+"SetChangesMaps"];}else{this._aEventIds=[this.getId()+"GetApps",this.getId()+"GetChangesMaps"];}}});c.prototype.sDelimiter=";";c.prototype.init=function(s){P.prototype.init.apply(this,arguments);var p="<div class='sapUiSmallMargin'>The applications listed below have been handled by the sap.ui.fl library in this session.</div>"+"<div class='sapUiSmallMarginBegin'>You can download a file containing the data that has been applied to an application as well as "+"relevant runtime information, and then upload this file to the UI Flexibility Diagnostics application for further investigation.</div>"+"<div class='sapUiSmallMarginBegin'>The UI Flexibility Diagnostics application displays graphs and is only available with SAPUI5.</div>";if(s.isToolStub()){this.addStylesheet("sap/ui/fl/support/flexibility");this.oChangesModel=new a();this.oAppModel=new a();this.oToolSettings=new a({hideDependingChanges:false,panelInfoText:p});this.oChangeDetails=new a();this._renderToolPlugin([]);S.getStub().sendEvent(this.getId()+"GetApps",{});}else{this.onsapUiSupportFlexibilityGetApps();}};c.prototype._renderToolPlugin=function(){var _=function(){var r=sap.ui.getCore().createRenderManager();r.write("<div id='"+this.getId()+"-FlexCacheArea' class='sapUiSizeCompact'></div>");r.flush(this.$().get(0));r.destroy();}.bind(this);var d=function(){this.oViewPromise=X.create({viewName:"sap.ui.fl.support.diagnostics.Flexibility",viewData:{plugin:this}}).then(function(v){this.oView=v;this.oView.placeAt(this.getId()+"-FlexCacheArea");this.oView.setModel(this.oAppModel,"flexApps");this.oView.setModel(this.oToolSettings,"flexToolSettings");this.oView.setModel(this.oChangesModel,"flexChanges");this.oView.setModel(this.oChangeDetails,"flexChangeDetails");}.bind(this));}.bind(this);_();d();};c.prototype.onRefresh=function(){S.getStub().sendEvent(this.getId()+"GetApps",{});};c.prototype.onsapUiSupportFlexibilityGetApps=function(){var A=[];if(C._instanceCache){e(C._instanceCache,function(r,o){A.push({key:r,text:r,additionalText:this.getAppVariantHierarchy(r),data:E.extractData(o)});}.bind(this));}this._oStub.sendEvent(this.getId()+"SetApps",A);};c.prototype.getAppVariantHierarchy=function(r){var R=b.registry.all();var A=[];Object.values(R).find(function(o){var i=o.getMetadata().getManifestEntry("/sap.app/id");var u=o.getMetadata().getManifestEntry("sap.ui5");if(i===r){u.appVariantIdHierarchy.forEach(function(h){A.push(h.appVariantId+" ("+h.version+")"+(h.layer?" in layer "+h.layer:""));});return true;}});return A.length?"App variant based on:\n"+A.join("\n"):"";};c.prototype.onsapUiSupportFlexibilityGetChangesMaps=function(o){var A=o.mParameters.appKey;var d=A.split(this.sDelimiter);var s=d[0];this._getChangesMapForApp(s);};c.prototype.onsapUiSupportFlexibilitySetApps=function(o){var A=o.getParameters();this.oAppModel.setData(A);};c.prototype.onsapUiSupportFlexibilitySetChangesMaps=function(o){var m=o.getParameters();this.oChangesModel.setData(m);this.oView.byId("Tree").expandToLevel(1000);};c.prototype.exit=function(){P.prototype.exit.apply(this,arguments);};c.prototype._getChangesMapForApp=function(A){function _(m,s){j[s]=[];var l=k[s];var n=sap.ui.getCore().byId(s);var p=[];var q=[];var r=[];if(n){if(n.data(F.appliedChangesCustomDataKey)){p=n.data(F.appliedChangesCustomDataKey).split(",");}if(n.data(F.failedChangesCustomDataKeyJs)){q=n.data(F.failedChangesCustomDataKeyJs).split(",");}if(n.data(F.failedChangesCustomDataKeyXml)){r=n.data(F.failedChangesCustomDataKeyXml).split(",");}}j[s]=l.map(d.bind(this,n,p,q,r,m));}function d(l,n,p,q,m,r){var s={id:r.getId(),changeType:r.getChangeType(),selector:r.getSelector(),controlPresent:!!l,indexInAppliedChanges:undefined,indexOfFirstFailing:undefined,dependentControls:[],dependentChanges:[],someDirectDependingChangesFailed:false,someDirectDependingChangesNotApplied:false,isInSubTree:false};var u=p.concat(q);if(s.controlPresent&&n.indexOf(r.getId())>-1){s.indexInAppliedChanges=n.indexOf(r.getId());}if(s.controlPresent&&p.indexOf(r.getId())>-1){s.modifier="JS";s.indexOfFirstFailing=u.indexOf(r.getId());}if(s.controlPresent&&q.indexOf(r.getId())>-1){s.modifier="XML";s.indexOfFirstFailing=u.indexOf(r.getId());}if(r._aDependentSelectorList){var v=E.getAppComponentInstance(A);s.dependentControls=r._aDependentSelectorList.map(function(w){return{id:w.id,controlPresent:J.bySelector(w,v)};});}m[r.getId()]=s;return s;}function f(l,K,n){var p=n.dependencies;if(p.indexOf(l.id)!==-1){var s=JSON.stringify(m[K].selector)===JSON.stringify(l.selector);l.isInSubTree=l.isInSubTree||s;}}function g(s,l){l.forEach(function(n){jQuery.each(D,f.bind(this,n));n.allDependendingControlsPresent=n.dependentControls.every(function(p){return p.controlPresent;});if(D[n.id]&&D[n.id].dependencies){D[n.id].dependencies.forEach(function(p){var q=m[p];var r=q.indexInAppliedChanges===undefined;q=m[p];n.someDirectDependingChangesNotApplied=n.someDirectDependingChangesNotApplied||r;var u=q.indexOfFirstFailing===undefined;var v=u&&r;n.someDirectDependingChangesFailed=n.someDirectDependingChangesFailed||u;n.someDirectDependingChangesNotSuccessfulApplied=n.someDirectDependingChangesNotSuccessfulApplied||v;n.dependentChanges.push(q);});}n.isApplicable=!n.someDirectDependingChangesNotApplied&&n.controlPresent&&n.allDependendingControlsPresent&&!n.someDirectDependingChangesNotApplied;n.isPossibleRootCause=n.isApplicable&&n.indexInAppliedChanges===undefined;});}function h(l){l=l.filter(function(n){return!l.some(function(p){return p.dependentChanges.some(function(q){return q.id===n.id;});});});return l.map(function(n){return{id:n.id,text:n.changeType,nodes:n.dependentChanges?h(n.dependentChanges):[]};});}function i(s,l){t.push({text:s,nodes:h(l)});}var m={};var j={};var t=[];var o=C.getChangePersistenceForComponent(A);var k=o._mChanges.mChanges;var D=o._mChangesInitial.mDependencies;Object.keys(k).forEach(_.bind(this,m));jQuery.each(j,g);jQuery.each(j,i);this._oStub.sendEvent(this.getId()+"SetChangesMaps",{changes:m,tree:t});};return c;});
