/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseContentRenderer","sap/ui/core/Core","sap/ui/core/Control","sap/ui/integration/model/ObservableModel","sap/ui/base/ManagedObjectObserver","sap/ui/integration/util/LoadingProvider"],function(B,C,a,O,M,L){"use strict";var b=a.extend("sap.ui.integration.cards.BaseContent",{metadata:{library:"sap.ui.integration",aggregations:{_content:{multiple:false,visibility:"hidden"},_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}},events:{press:{},ready:{}}},renderer:B});b.prototype.init=function(){this._oAwaitedEvents=new Set();this._bReady=false;this._mObservers={};this.setAggregation("_loadingProvider",new L());};b.prototype.ontap=function(e){if(!e.isMarked()){this.firePress({});}};b.prototype.exit=function(){this._oAwaitedEvents=null;if(this._mObservers){Object.keys(this._mObservers).forEach(function(k){this._mObservers[k].disconnect();delete this._mObservers[k];},this);}this._oServiceManager=null;this._oDataProviderFactory=null;this._oIconFormatter=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}if(this._oLoadingPlaceholder){this._oLoadingPlaceholder.destroy();this._oLoadingPlaceholder=null;}this._sContentBindingPath=null;};b.prototype.loadDependencies=function(c){return Promise.resolve();};b.prototype.getActions=function(){return this._oActions;};b.prototype.setActions=function(A){this._oActions=A;};b.prototype.awaitEvent=function(e){if(this._oAwaitedEvents.has(e)){return;}this._bReady=false;this._oAwaitedEvents.add(e);this.showLoadingPlaceholders();this.attachEventOnce(e,function(){this._oAwaitedEvents.delete(e);if(this._oAwaitedEvents.size===0){this._bReady=true;this.hideLoadingPlaceholders();this.fireReady();}}.bind(this));};b.prototype.setConfiguration=function(c,t){this._oConfiguration=c;this.awaitEvent("_dataReady");this.awaitEvent("_actionContentReady");if(!c){return this;}this._oLoadingPlaceholder=this.getAggregation("_loadingProvider").createContentPlaceholder(c,t,this.getCardInstance());this._setDataConfiguration(c.data);return this;};b.prototype.getConfiguration=function(){return this._oConfiguration;};b.prototype._setDataConfiguration=function(d){var c=this.getCardInstance(),m;if(!d){this._sContentBindingPath=null;this.fireEvent("_dataReady");return;}this._sContentBindingPath=d.path||"/";this.bindObject(this._sContentBindingPath);if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(d,this._oServiceManager);this.getAggregation("_loadingProvider").setDataProvider(this._oDataProvider);if(d.name){m=c.getModel(d.name);}else if(this._oDataProvider){m=new O();this.setModel(m);}if(!m){this.fireEvent("_dataReady");return;}m.attachEvent("change",function(){this.onDataChanged();this.onDataRequestComplete();}.bind(this));if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.onDataRequested();}.bind(this));this._oDataProvider.attachDataChanged(function(e){m.setData(e.getParameter("data"));});this._oDataProvider.attachError(function(e){this.handleError(e.getParameter("message"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();}else{this.fireEvent("_dataReady");}};b.prototype.onDataRequested=function(){this.awaitEvent("_dataReady");};b.prototype.onDataRequestComplete=function(){this.fireEvent("_dataReady");};b.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate();}};b.prototype.showLoadingPlaceholders=function(){var l=this.getAggregation("_loadingProvider");if(l){l.setLoading(true);}};b.prototype.hideLoadingPlaceholders=function(){var l=this.getAggregation("_loadingProvider");if(l){l.setLoading(false);}};b.prototype.onDataChanged=function(){};b.prototype._bindAggregationToControl=function(A,c,o){var d;if(!o){return;}if(!o.path){o.path=this._sContentBindingPath;}if(!o.path){d=this.getCardInstance().getBindingContext();o.path=d&&d.getPath();}if(!o.path){return;}c.bindAggregation(A,o);this._observeAggregation(A,c);};b.prototype._observeAggregation=function(A,c){var p=this.getCardInstance().getModel("parameters"),o;if(this._mObservers[A]){return;}o=new M(function(d){var e;if(d.name!==A){return;}if(!(d.mutation==="insert"||d.mutation==="remove")){return;}e=c.getMetadata().getAggregation(A).get(c);p.setProperty("/visibleItems",e.length);});o.observe(c,{aggregations:[A]});this._mObservers[A]=o;};b.prototype.isReady=function(){return this._bReady;};b.prototype.handleError=function(l,d){this.fireEvent("_error",{logMessage:l,displayMessage:d});};b.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};b.prototype.setDataProviderFactory=function(d){this._oDataProviderFactory=d;return this;};b.prototype.setIconFormatter=function(i){this._oIconFormatter=i;return this;};b.prototype.isLoading=function(){var l=this.getAggregation("_loadingProvider"),c=this.getCardInstance();return!l.isDataProviderJson()&&(l.getLoading()||(c&&c.isLoading()));};b.prototype.attachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");a.prototype.attachEvent.apply(this,m);this.invalidate();return this;};b.prototype.detachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");a.prototype.detachEvent.apply(this,m);this.invalidate();return this;};b.prototype.onActionSubmitStart=function(f){};b.prototype.onActionSubmitEnd=function(r,e){};b.prototype.getCardInstance=function(){return C.byId(this.getCard());};return b;});
