/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Core","sap/base/util/isEmptyObject","sap/f/cards/Header","sap/f/cards/HeaderRenderer","sap/m/library","sap/ui/integration/util/BindingHelper","sap/ui/model/json/JSONModel","sap/ui/integration/util/LoadingProvider"],function(C,i,F,a,l,B,J,L){"use strict";var A=l.AvatarColor;var H=F.extend("sap.ui.integration.cards.Header",{constructor:function(c,o,I){c=c||{};this._bIsEmpty=i(c);var s={title:c.title,subtitle:c.subTitle,dataTimestamp:c.dataTimestamp};if(c.status&&c.status.text&&!c.status.text.format){s.statusText=c.status.text;}if(c.icon){s.iconSrc=c.icon.src;s.iconDisplayShape=c.icon.shape;s.iconInitials=c.icon.text;s.iconAlt=c.icon.alt;s.iconBackgroundColor=c.icon.backgroundColor||(c.icon.text?A.Accent6:A.Transparent);}if(s.iconSrc){s.iconSrc=B.formattedProperty(s.iconSrc,function(v){return I.formatSrc(v);});}s.toolbar=o;F.call(this,s);if(o){o.attachVisibilityChange(this._handleToolbarVisibilityChange.bind(this));}},metadata:{library:"sap.ui.integration",aggregations:{_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:a});H.prototype.init=function(){F.prototype.init.call(this);this._bReady=false;this.setAggregation("_loadingProvider",new L());this._aReadyPromises=[];this._awaitEvent("_dataReady");this._awaitEvent("_actionHeaderReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));};H.prototype.exit=function(){F.prototype.exit.call(this);this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}};H.prototype.isReady=function(){return this._bReady;};H.prototype.isLoading=function(){var o=this.getAggregation("_loadingProvider"),c=this.getCardInstance(),b=c&&c.isA("sap.ui.integration.widgets.Card")?c.isLoading():false;return!o.isDataProviderJson()&&(o.getLoading()||b);};H.prototype._handleError=function(s){this.fireEvent("_error",{logMessage:s});};H.prototype._handleToolbarVisibilityChange=function(e){var t=e.getParameter("visible");if(this._bIsEmpty&&this.getVisible()!==t){this.setVisible(t);}};H.prototype._awaitEvent=function(e){this._aReadyPromises.push(new Promise(function(r){this.attachEventOnce(e,function(){r();});}.bind(this)));};H.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};H.prototype.setDataProviderFactory=function(d){this._oDataProviderFactory=d;return this;};H.prototype._setDataConfiguration=function(d){var c=this.getCardInstance(),p="/",m;if(d&&d.path){p=d.path;}this.bindObject(p);if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=c.getDataProviderFactory().create(d,this._oServiceManager);this.getAggregation("_loadingProvider").setDataProvider(this._oDataProvider);if(d&&d.name){m=c.getModel(d.name);}else if(this._oDataProvider){m=new J();this.setModel(m);}if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.showLoadingPlaceholders();}.bind(this));this._oDataProvider.attachDataChanged(function(e){m.setData(e.getParameter("data"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.attachError(function(e){this._handleError(e.getParameter("message"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();}else{this.fireEvent("_dataReady");}};H.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate();}};H.prototype.showLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(true);};H.prototype.hideLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(false);};H.prototype.onDataRequestComplete=function(){this.fireEvent("_dataReady");this.hideLoadingPlaceholders();};H.prototype.getCardInstance=function(){return C.byId(this.getCard());};return H;});
