/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseListContent","./ListContentRenderer","sap/ui/util/openWindow","sap/m/library","sap/m/List","sap/m/ObjectStatus","sap/ui/integration/library","sap/ui/integration/util/BindingHelper","sap/ui/integration/controls/Microchart","sap/ui/integration/controls/MicrochartLegend","sap/ui/integration/controls/ListContentItem","sap/ui/integration/controls/ActionsStrip"],function(B,L,o,l,a,O,b,c,M,d,e,A){"use strict";var f=l.AvatarSize;var g=l.AvatarColor;var h=l.ListType;var j=l.ListSeparators;var k=b.CardActionArea;var E=l.EmptyIndicatorMode;var m="_legendColorsLoad";var n=B.extend("sap.ui.integration.cards.ListContent",{metadata:{library:"sap.ui.integration",aggregations:{_legend:{multiple:false,visibility:"hidden"}}},renderer:L});n.prototype.init=function(){B.prototype.init.apply(this,arguments);var p=this._getList();var t=this;this.setAggregation("_content",p);p.attachUpdateFinished(function(){if(t._iVisibleItems){var I=p.getItems();for(var i=t._iVisibleItems+1;i<I.length;i++){I[i].setVisible(false);}}});};n.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null;}};n.prototype.loadDependencies=function(C){if(C.get("/sap.card/content/item/chart")){return M.loadDependencies();}return Promise.resolve();};n.prototype.setConfiguration=function(C){B.prototype.setConfiguration.apply(this,arguments);if(!C){return this;}if(C.items){this._setStaticItems(C.items);return this;}if(C.item){this._setItem(C.item);}return this;};n.prototype.onDataChanged=function(){this._checkHiddenNavigationItems(this.getConfiguration().item);};n.prototype._getList=function(){if(this._bIsBeingDestroyed){return null;}if(!this._oList){this._oList=new a({id:this.getId()+"-list",growing:false,showNoData:false});}return this._oList;};n.prototype._setItem=function(i){var p=this._getList(),s={iconDensityAware:false,title:i.title&&(i.title.value||i.title),description:i.description&&(i.description.value||i.description),highlight:i.highlight,info:i.info&&i.info.value,infoState:i.info&&i.info.state,attributes:[]};if(i.icon){s.icon=c.formattedProperty(i.icon.src,function(v){return this._oIconFormatter.formatSrc(v);}.bind(this));s.iconAlt=i.icon.alt;s.iconDisplayShape=i.icon.shape;s.iconInitials=i.icon.text;if(s.title&&s.description){s.iconSize=f.S;}else{s.iconSize=f.XS;}s.iconSize=i.icon.size||s.iconSize;s.iconBackgroundColor=i.icon.backgroundColor||(i.icon.text?undefined:g.Transparent);}if(i.attributesLayoutType){s.attributesLayoutType=i.attributesLayoutType;}if(i.attributes){i.attributes.forEach(function(r){s.attributes.push(new O({text:r.value,state:r.state,emptyIndicatorMode:E.On}));});}if(i.chart){s.microchart=this._createChartAndAddLegend(i.chart);}if(i.actionsStrip){s.actionsStrip=A.create(this.getCardInstance(),i.actionsStrip);p.setShowSeparators(j.All);}else{p.setShowSeparators(j.None);}this._oItemTemplate=new e(s);this._oActions.attach({area:k.ContentItem,actions:i.actions,control:this,actionControl:this._oItemTemplate,enabledPropertyName:"type",enabledPropertyValue:h.Navigation,disabledPropertyValue:h.Inactive});var G=this.getConfiguration().group;if(G){this._oSorter=this._getGroupSorter(G);}var q={template:this._oItemTemplate,sorter:this._oSorter};this._filterHiddenNavigationItems(i,q);this._bindAggregationToControl("items",p,q);};n.prototype._createChartAndAddLegend=function(C){var i=M.create(C);this.destroyAggregation("_legend");if(C.type==="StackedBar"){var p=new d({chart:i.getChart(),colorsLoad:function(){this.fireEvent(m);}.bind(this)});p.initItemsTitles(C.bars,this.getBindingContext().getPath());this.setAggregation("_legend",p);this.awaitEvent(m);}return i;};n.prototype._setStaticItems=function(i){var p=this._getList();i.forEach(function(I){var q=new e({iconDensityAware:false,title:I.title?I.title:"",description:I.description?I.description:"",icon:I.icon?I.icon:"",infoState:I.infoState?I.infoState:"None",info:I.info?I.info:"",highlight:I.highlight?I.highlight:"None"});if(I.action){q.setType("Navigation");if(I.action.url){q.attachPress(function(){o(I.action.url,I.target||"_blank");});}}p.addItem(q);});this.fireEvent("_actionContentReady");};n.prototype.getInnerList=function(){return this._getList();};return n;});
