/*!
* OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["sap/ui/integration/library","sap/ui/integration/cards/BaseContent","sap/m/library","sap/m/HBox","sap/m/VBox","sap/m/Text","sap/m/Title","sap/m/Avatar","sap/m/Link","sap/m/Label","sap/base/Log","sap/ui/core/ResizeHandler","sap/ui/layout/AlignedFlowLayout","sap/ui/dom/units/Rem","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/Utils"],function(l,B,L,H,V,T,a,A,b,c,d,R,e,f,g,U){"use strict";var h=L.AvatarSize;var i=L.AvatarColor;var F=L.FlexRendertype;var j=l.CardActionArea;var O=B.extend("sap.ui.integration.cards.ObjectContent",{metadata:{library:"sap.ui.integration"},renderer:{apiVersion:2}});O.prototype._getRootContainer=function(){if(this._bIsBeingDestroyed){return null;}var o=this.getAggregation("_content");if(!o){o=new e();this.setAggregation("_content",o);}this._sResizeListenerId=R.register(o,this.onAlignedFlowLayoutResize.bind(this));o.addEventDelegate({"onAfterRendering":function(){this.getContent().forEach(function(E){if(!E.getVisible()){document.getElementById("sap-ui-invisible-"+E.getId()).parentElement.classList.add("sapFCardInvisibleContent");}});}},o);return o;};O.prototype.onAlignedFlowLayoutResize=function(E){if(E&&(E.size.width===E.oldSize.width)&&!E.control){return;}var C=E.control,m=C.getMinItemWidth(),n=C.getContent().length,M;if(m.lastIndexOf("rem")!==-1){M=f.toPx(m);}else if(m.lastIndexOf("px")!==-1){M=parseFloat(m);}var k=Math.floor(E.size.width/M);if(k>n){k=n;}if(this._iColsOld===k){return;}this._iColsOld=k;var o=k-1,r=Math.ceil(n/k);C.getContent().forEach(function(I,p){I.addStyleClass("sapFCardObjectSpaceBetweenGroup");if(o===p&&o<n){I.removeStyleClass("sapFCardObjectSpaceBetweenGroup");o+=k;}if(p+1>(r-1)*k){I.addStyleClass("sapFCardObjectGroupLastInColumn");}else{I.removeStyleClass("sapFCardObjectGroupLastInColumn");}});};O.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId="";}};O.prototype.setConfiguration=function(C){B.prototype.setConfiguration.apply(this,arguments);if(!C){return this;}if(C.groups){this._addGroups(C);}return this;};O.prototype._addGroups=function(C){var o=this._getRootContainer(),G=C.groups||[];G.forEach(function(k){var v;if(typeof k.visible=="string"){v=!U.hasFalsyValueAsString(k.visible);}else{v=k.visible;}var m=new V({visible:v,renderType:F.Bare}).addStyleClass("sapFCardObjectGroup");if(k.title){m.addItem(new a({text:k.title}).addStyleClass("sapFCardObjectItemTitle"));m.addStyleClass("sapFCardObjectGroupWithTitle");}k.items.forEach(function(I){var n=I.label,p=I.value,q,v,r,s,t=[];if(typeof I.visible=="string"){v=!U.hasFalsyValueAsString(I.visible);}else{v=I.visible;}if(n){n=g.formattedProperty(n,function(y){return y&&y[y.length-1]===":"?y:y+":";});q=new c({text:n,visible:v}).addStyleClass("sapFCardObjectItemLabel");}if(p&&I.actions){r=new b({text:p,visible:g.reuse(v)});this._oActions.attach({area:j.ContentItemDetail,actions:I.actions,control:this,actionControl:r,enabledPropertyName:"enabled"});}if(p&&!I.actions&&I.type){d.warning("Usage of Object Group Item property 'type' is deprecated. Use Card Actions for navigation.",null,"sap.ui.integration.widgets.Card");switch(I.type){case'link':r=new b({href:I.url||p,text:p,target:I.target||'_blank',visible:g.reuse(v)});break;case'email':if(I.value){t.push(I.value);}if(I.emailSubject){t.push(I.emailSubject);}s=g.formattedProperty(t,function(y,E){if(E){return"mailto:"+y+"?subject="+E;}else{return"mailto:"+y;}});r=new b({href:s,text:p,visible:g.reuse(v)});break;case'phone':s=g.formattedProperty(p,function(y){return"tel:"+y;});r=new b({href:s,text:p,visible:g.reuse(v)});break;default:}}if(p&&!r){r=new T({text:p,visible:g.reuse(v)});}if(r){r.addStyleClass("sapFCardObjectItemText");}if(I.icon){var S=g.formattedProperty(I.icon.src,function(y){return this._oIconFormatter.formatSrc(y);}.bind(this));var u=new A({displaySize:I.icon.size||h.XS,src:S,initials:I.icon.text,displayShape:I.icon.shape,tooltip:I.icon.alt,backgroundColor:I.icon.backgroundColor||(I.icon.text?undefined:i.Transparent)}).addStyleClass("sapFCardObjectItemAvatar sapFCardIcon");var w=new V({renderType:F.Bare,items:[q,r]});var x=new H({visible:v,renderType:F.Bare,items:[u,w]}).addStyleClass("sapFCardObjectItemLabel");m.addItem(x);}else{m.addItem(q);m.addItem(r);}},this);o.addContent(m);},this);this._oActions.attach({area:j.Content,actions:C.actions,control:this});};return O;});
