/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseContent","./WebPageContentRenderer","sap/ui/core/Core","sap/ui/integration/util/BindingHelper"],function(B,W,C,a){"use strict";var F="_frameLoaded";var L=15*1000;var r=C.getLibraryResourceBundle("sap.ui.integration");var b=B.extend("sap.ui.integration.cards.WebPageContent",{metadata:{properties:{minHeight:{type:"sap.ui.core.CSSSize",defaultValue:W.MIN_WEB_PAGE_CONTENT_HEIGHT,bindable:true},src:{type:"sap.ui.core.URI",defaultValue:"",bindable:true},sandbox:{type:"string",defaultValue:"",bindable:true}},library:"sap.ui.integration"},renderer:W});b.prototype.init=function(){B.prototype.init.apply(this,arguments);this._onFrameLoadedBound=this._onFrameLoaded.bind(this);this._sPrevSrc=this.getSrc();};b.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._iLoadTimeout){clearTimeout(this._iLoadTimeout);}};b.prototype.onBeforeRendering=function(){B.prototype.onBeforeRendering.apply(this,arguments);if(this.getDomRef()){this.getDomRef("frame").removeEventListener("load",this._onFrameLoadedBound);}};b.prototype.onAfterRendering=function(){B.prototype.onAfterRendering.apply(this,arguments);this.getDomRef("frame").addEventListener("load",this._onFrameLoadedBound);this._checkSrc();};b.prototype.setConfiguration=function(c){B.prototype.setConfiguration.apply(this,arguments);this.fireEvent("_actionContentReady");if(!c){return this;}var s=a.formattedProperty(c.src,function(v){return this._oIconFormatter.formatSrc(v);}.bind(this));if(s){this.bindSrc(s);}if(typeof c.sandbox==="object"){this.bindSandbox(a.reuse(c.sandbox));}else{this.setSandbox(c.sandbox);}if(typeof c.minHeight==="object"){this.bindMinHeight(a.reuse(c.minHeight));}else{this.setMinHeight(c.minHeight);}return this;};b.prototype._checkSrc=function(){var c=this.getSrc();if(c===""){this.handleError("Src of WebPage content is empty",r.getText("CARD_WEB_PAGE_EMPTY_URL_ERROR"));return;}if(!c.startsWith("https://")){this.handleError("Please use a secure URL (https://)",r.getText("CARD_WEB_PAGE_HTTPS_URL_ERROR"));return;}if(this._sPrevSrc!==c){this._raceFrameLoad();this._sPrevSrc=c;}};b.prototype._raceFrameLoad=function(){this.awaitEvent(F);this._iLoadTimeout=setTimeout(function(){var s=L/1000;this.handleError("Failed to load '"+this.getSrc()+"' after "+s+" seconds.",r.getText("CARD_WEB_PAGE_TIMEOUT_ERROR",[s]));}.bind(this),L);};b.prototype._onFrameLoaded=function(){this.fireEvent(F);clearTimeout(this._iLoadTimeout);};return b;});
