/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/ui/integration/designtime/baseEditor/validator/ValidatorRegistry","sap/ui/integration/designtime/baseEditor/PropertyEditors","sap/ui/integration/designtime/baseEditor/util/binding/resolveBinding","sap/ui/integration/designtime/baseEditor/util/binding/ObjectBinding","sap/ui/integration/designtime/baseEditor/util/hasTag","sap/ui/integration/designtime/baseEditor/util/cleanupDesigntimeMetadata","sap/ui/core/Control","sap/ui/model/resource/ResourceModel","sap/base/util/ObjectPath","sap/base/util/each","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/values","sap/base/util/includes","sap/base/util/isPlainObject","sap/base/util/isEmptyObject","sap/base/util/restricted/_intersection","sap/base/util/restricted/_flatten","sap/base/util/restricted/_mergeWith","sap/base/util/restricted/_merge","sap/base/util/restricted/_omit","sap/base/util/restricted/_union","sap/base/util/restricted/_isNil","sap/base/util/restricted/_castArray","sap/ui/model/json/JSONModel","sap/base/i18n/ResourceBundle","sap/base/Log","sap/ui/integration/designtime/baseEditor/util/unset"],function(c,P,V,a,r,O,h,b,C,R,d,f,g,i,v,j,k,l,_,m,n,o,p,q,s,t,J,u,L,w){"use strict";var x="customProperty--";var B=C.extend("sap.ui.integration.designtime.baseEditor.BaseEditor",{metadata:{library:"sap.ui.integration",properties:{"json":{type:"object"},"config":{type:"object",defaultValue:{"i18n":["sap/ui/integration/designtime/baseEditor/i18n/i18n.properties"]}},"designtimeMetadata":{type:"object"},"layout":{type:"string",defaultValue:"list"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true}},events:{jsonChange:{parameters:{json:{type:"object"}}},designtimeMetadataChange:{parameters:{designtimeMetadata:{type:"object"}}},configChange:{parameters:{config:{type:"object"}}},propertyEditorsReady:{parameters:{propertyEditors:{type:"array"}}},validationErrorChange:{parameters:{hasError:{type:"boolean"}}}}},constructor:function(){this._oSetConfigPromise=Promise.resolve();this._mObservableConfig={};this._mPropertyEditors={};this._aCancelHandlers=[];this._oDataModel=this._createModel();this._oDesigntimeMetadataModel=this._createModel();this._bInitFinished=false;this._bValidatorsReady=false;this._setReady(false);C.prototype.constructor.apply(this,arguments);this._oDataModel.setData(this._prepareData(this.getJson()));this.attachJsonChange(function(e){var D=e.getParameter("json");this._oDataModel.setData(this._prepareData(D));this._checkReady();},this);},renderer:function(e,D){var E=D.getContent();e.openStart("div",D);e.openEnd();if(E.length){E.forEach(function(F){e.renderControl(F);});}else{D.getPropertyEditorsSync().forEach(function(F){e.renderControl(F);});}e.close("div");}});B.prototype.init=function(){};B.prototype.exit=function(){this._reset();this._oDataModel.destroy();this._oDesigntimeMetadataModel.destroy();};B.prototype._prepareData=function(e){var D=g(e);f(this._mObservableConfig,function(E,F){var G=F.path;if(G[0]==="/"){G=G.substr(1);}if(typeof d.get(G.split("/"),D)==="undefined"&&typeof F.defaultValue!=="undefined"){d.set(G.split("/"),g(F.defaultValue),D);}});return D;};B.prototype.setJson=function(D){var E;if(typeof D==="string"){try{E=JSON.parse(D);}catch(e){L.error("sap.ui.integration.designtime.baseEditor.BaseEditor: invalid JSON string is specified");}}else if(k(D)){E=o({},D);}else{L.error("sap.ui.integration.designtime.baseEditor.BaseEditor: unsupported data type specified in setJson()");}if(E&&JSON.stringify(this.getProperty("json"))!==JSON.stringify(E)){this.setProperty("json",E);this.fireJsonChange({json:E});}};B.prototype.setPreventInitialization=function(e){this._bPreventInitialization=e;};B.prototype.setConfig=function(e,I){this._bIsDefaultConfig=I;e=e||{};this._oSetConfigPromise=this._oSetConfigPromise.then(this._registerPropertyEditorTypes.bind(this,e.propertyEditors)).then(this._setConfig.bind(this,e,I));return this._oSetConfigPromise;};B.prototype._registerPropertyEditorTypes=function(e){P.deregisterAllTypes();return P.registerTypes(e||{});};B.prototype._setConfig=function(e,I,D){this._initValidators(e.validators||{});var T={propertyEditors:{},properties:{}};var N=y(T,e);if(this._oSpecificConfig){N=I?this._oSpecificConfig:A(N,this._oSpecificConfig,D);}N.i18n=q(N.i18n&&t(N.i18n),this.getMetadata().getProperty("config").getDefaultValue().i18n);this.setProperty("config",N,false);this.fireConfigChange({config:g(N)});this.initialize();};B.prototype.addConfig=function(e,I){this._bIsDefaultConfig=I;this._oSetConfigPromise=this._oSetConfigPromise.then(function(){e=y(this.getConfig(),e);return e.propertyEditors;}.bind(this)).then(this._registerPropertyEditorTypes).then(function(D){this._setConfig(e,I,D);}.bind(this));return this._oSetConfigPromise;};function y(T,e){var D=o({},T,e);D.i18n=[].concat(T.i18n||[],e.i18n||[]);return D;}B.prototype._addSpecificConfig=function(S){var e;this._oSetConfigPromise=this._oSetConfigPromise.then(function(){this._oSpecificConfig=S;e=o({},this.getConfig());e.propertyEditors=z(e,S);return e.propertyEditors;}.bind(this)).then(this._registerPropertyEditorTypes).then(function(D){this._setConfig(e,this._bIsDefaultConfig,D);}.bind(this));return this._oSetConfigPromise;};function z(e,S){var D={};var E=e.propertyEditors||{};var F=S.propertyEditors||{};q(Object.keys(E),Object.keys(F)).forEach(function(G){D[G]=F[G]||E[G];});return D;}function A(e,S,D){e.i18n=q(e.i18n,S.i18n);var N=Object.assign({},e,p(S,["properties","i18n","propertyEditors"]),p(e,["properties","i18n","propertyEditors"]));N.properties={};f(e.properties,function(E,F){var G=e.propertyEditors[F.type]&&e.propertyEditors[F.type].split("/").join(".");var H=G&&D[G].configMetadata;if(H&&S.properties[E]){f(F,function(K,T){var I;var M=H[K]&&H[K].mergeStrategy;if(M){if(M==="mostRestrictiveWins"){var Q=H[K].mostRestrictiveValue||false;if(T===Q){I=Q;}else{I=S.properties[E][K];}}else if(M==="intersection"){I=_(T,S.properties[E][K]);}}else{I=T;}N.properties[E]=N.properties[E]||{};N.properties[E][K]=I;});}});return N;}B.prototype.setDesigntimeMetadata=function(D,I){var N=g(D,15);if(!i(N,this.getDesigntimeMetadata())){this.setProperty("designtimeMetadata",N);this._oDesigntimeMetadataModel.setData(N);if(!I){this.fireDesigntimeMetadataChange({designtimeMetadata:this._formatExportedDesigntimeMetadata(N)});}}};B.prototype._formatExportedDesigntimeMetadata=function(M){var F={};var e=function(D,E){Object.keys(D).forEach(function(K){var G=D[K];if(K==="__value"){F[E.join("/")]=G;}else if(k(G)){e(G,[].concat(E,K));}});};e(M||{},[]);return F;};B.prototype._initValidators=function(e){V.deregisterAllValidators();V.registerValidators(e);V.ready().then(function(){this._bValidatorsReady=true;this._checkReady();}.bind(this));};B.prototype._reset=function(){this._bInitFinished=false;this._setReady(false);this._aCancelHandlers.forEach(function(e){e();});if(this._oI18nModel){this._oI18nModel.destroy();delete this._oI18nModel;}if(this._oConfigObserver){this._oConfigObserver.destroy();}f(this._mPropertyEditors,function(e,D){D.forEach(function(E){this.deregisterPropertyEditor(E,e);},this);}.bind(this));if(this._oRootWrapper){this._oRootWrapper.destroy();}};B.prototype.initialize=function(){if(!this._bPreventInitialization){this._initialize();}};B.prototype._initialize=function(){this._reset();var e=this.getConfig();if(typeof this.getProperty("json")==="undefined"){this.attachEventOnce("jsonChange",this._initialize);return;}if(e){this._oConfigObserver=new O();this._loadI18nBundles(e.i18n).then(function(D){this._oI18nModel=this._createI18nModel(D);this.setModel(this._oI18nModel,"i18n");this._oConfigObserver.addToIgnore(["template","itemLabel"]);this._oConfigObserver.setModel(this._oDataModel);this._oConfigObserver.setModel(this._oDesigntimeMetadataModel,"designtimeMetadata");this._oConfigObserver.setModel(this._oI18nModel,"i18n");var E=this._getContextPath();if(E){this._oConfigObserver.setModel(this._oDataModel,"context");this._oConfigObserver.setBindingContext(this._oDataModel.getContext(E),"context");}var F=r(e.properties,{"i18n":this._oI18nModel});this._mObservableConfig=Object.assign(this._mObservableConfig,this._prepareConfig(F));this._oConfigObserver.setObject(this._mObservableConfig);this._oConfigObserver.attachChange(this._onConfigChange,this);var G=this.getContent();if(G.length===0||G.length===1&&G[0]===this._oRootWrapper){this.removeAllContent();this._createEditors(this._oConfigObserver.getObject());}this._bInitFinished=true;this._checkReady();}.bind(this));}};B.prototype._onConfigChange=function(e){var D=e.getParameter("changes").reduce(function(F,G){var H=g(G);H.path=H.path.split("/");H.propertyKey=H.path.shift();if(!F[H.propertyKey]){F[H.propertyKey]=[];}F[H.propertyKey].push(H);return F;},{});var E=Object.keys(D).reduce(function(F,G){var H=(this.getPropertyEditorsByNameSync(G)||[]).map(function(K){return{editor:K,propertyName:G};});F=F.concat(H);return F;}.bind(this),[]);var I=E.filter(function(F){return!this._oRootWrapper||!j(this._oRootWrapper._aEditorWrappers,F.editor);}.bind(this));I.forEach(function(F){var G=F.propertyName;var H=e.getSource().getObject();var K=p(g(H[G]),"value");var N=false;var Q=D[G]||[];Q.forEach(function(S){if(S.path[0]==="value"){F.editor.setValue(S.value);}else{d.set(S.path,S.value,K);N=true;}});if(N){F.editor.setConfig(K);}});if(I.length<E.length){var M=g(this._oRootWrapper.getConfig()).map(function(F){var G=D[F.__propertyName]||[];G.forEach(function(H){d.set(H.path,H.value,F);});return F;});this._oRootWrapper.setConfig(M);}};B.prototype._createModel=function(){var M=new J();M.setDefaultBindingMode("OneWay");return M;};B.prototype.getI18nProperty=function(N,e){if(this.getModel("i18n")){return this.getModel("i18n").getResourceBundle().getText(N,e);}return N;};B.prototype._loadI18nBundles=function(e){return this._createPromise(function(D,E){Promise.all(e.map(function(I){return new Promise(function(D,F){u.create({url:sap.ui.require.toUrl(I),async:true}).then(D,F);});})).then(D,E);});};B.prototype._createI18nModel=function(e){var D=e.slice();var I=new R({bundle:D.shift()});I.setDefaultBindingMode("OneWay");D.forEach(function(E){I.enhance(E);});return I;};B.prototype._prepareConfig=function(e){var D={};f(e,function(K,E){D[K]=Object.assign({},this._preparePropertyConfig(E),{__propertyName:K});}.bind(this));return D;};B.prototype._preparePropertyConfig=function(e){var D=this._getContextPath();if(D&&!D.endsWith("/")){D=D+"/";}var E=e.path;if(!E.startsWith("/")&&D){E=D+E;}return Object.assign({},e,{path:E,value:"{"+E+"}",designtime:"{designtimeMetadata>"+E+"}"});};B.prototype._createEditors=function(e){var D=d.get(["layout",this.getLayout()],this.getConfig());if(k(D)||Array.isArray(D)){D=r(D,{"i18n":this._oI18nModel});}this._oRootWrapper=new a({config:v(e),layout:this.getLayout(),layoutConfig:D});this.addContent(this._oRootWrapper);return(Promise.all(v(this._mPropertyEditors).reduce(function(E,F){return E.concat(F);},[]).map(function(E){return E.ready();})).then(this._checkReady.bind(this)));};B.prototype._getRegistrationKey=function(e,K){if(typeof K!=="string"){if(e.isA("sap.ui.integration.designtime.baseEditor.PropertyEditor")&&!e.getConfig()&&!e.getBindingInfo("config")&&e.getPropertyName()){K=e.getPropertyName();}else{K=x+e.getId();}}return K;};B.prototype._addCustomProperty=function(K,e){var D=Object.assign({},this._mObservableConfig);D[K]=this._preparePropertyConfig(e);this._mObservableConfig=D;this._oConfigObserver.setObject(D);};B.prototype._removeCustomProperty=function(K){var e=p(this._mObservableConfig,K);this._mObservableConfig=e;this._oConfigObserver.setObject(e);};B.prototype.registerPropertyEditor=function(e,K){K=this._getRegistrationKey(e,K);var D=Array.isArray(this._mPropertyEditors[K])?this._mPropertyEditors[K]:[];this._mPropertyEditors[K]=D.concat(e);if(K.startsWith(x)){this._addCustomProperty(K,e.getConfig());}var E=d.get([K],this._oConfigObserver.getObject()).value;e.setValue(E);e.attachValueChange(this._onValueChange,this);e.attachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this);e.attachReady(this._checkReady,this);e.attachValidationErrorChange(function(){this.fireValidationErrorChange({hasError:this.hasError()});}.bind(this));};B.prototype.deregisterPropertyEditor=function(e,K){K=this._getRegistrationKey(e,K);var D=this._mPropertyEditors[K];if(K.startsWith(x)){this._removeCustomProperty(K);}e.detachValueChange(this._onValueChange,this);e.detachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this);if(Array.isArray(D)){this._mPropertyEditors[K]=D.filter(function(I){return e!==I;});if(this._mPropertyEditors[K].length===0){delete this._mPropertyEditors[K];}}};B.prototype._setReady=function(e){var D=this._bIsReady;this._bIsReady=e;if(D!==true&&e===true){this.firePropertyEditorsReady({propertyEditors:this.getPropertyEditorsSync()});}};B.prototype._checkReady=function(){var e=this.getContent().filter(function(E){return(E.isA("sap.ui.integration.designtime.baseEditor.PropertyEditors")||E.isA("sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"));});e.forEach(function(E){if(!sap.ui.base.EventProvider.hasListener(E,"ready",this._checkReady,this)){E.attachReady(this._checkReady,this);}},this);var D=[].concat(e,this.getPropertyEditorsSync());var I=(this._bInitFinished&&this._bValidatorsReady&&D.every(function(E){return E.isReady();}));this._setReady(I);};B.prototype.isReady=function(){return this._bIsReady;};B.prototype.ready=function(){return new Promise(function(e){if(this.isReady()){e();}else{this.attachEventOnce("propertyEditorsReady",e);}}.bind(this));};B.prototype.hasError=function(){return m(Object.values(this._mPropertyEditors||{})).some(function(e){return e.hasError();});};B.prototype._createPromise=function(e){var D=c(e);this._aCancelHandlers.push(D.cancel);var E=function(F,G){this._aCancelHandlers=this._aCancelHandlers.filter(function(e){return e!==F;});return G;}.bind(this,D.cancel);return D.promise.then(E,E);};B.prototype.getPropertyConfigByName=function(e){return p(d.get([e],this._oConfigObserver.getObject()),"value");};B.prototype.getPropertyEditorsByName=function(e){return new Promise(function(D){if(!this._mPropertyEditors||Object.keys(this._mPropertyEditors).length===0){this.attachEventOnce("propertyEditorsReady",D);}else{D();}}.bind(this)).then(function(){return this.getPropertyEditorsByNameSync(e);}.bind(this));};B.prototype.getPropertyEditorsByNameSync=function(e){var D=this._mPropertyEditors[e];return Array.isArray(D)&&D.slice()||null;};B.prototype.getPropertyEditorsByTag=function(T){return new Promise(function(e){if(!this._mPropertyEditors||Object.keys(this._mPropertyEditors).length===0){this.attachEventOnce("propertyEditorsReady",e);}else{e();}}.bind(this)).then(function(){return this.getPropertyEditorsByTagSync(T);}.bind(this));};B.prototype.getConfigsByTag=function(T){var e=this.getConfig().properties;return Object.keys(e).filter(function(D){return h(e[D],T);}).map(function(D){return e[D];});};B.prototype.getPropertyEditorsByTagSync=function(T){return this.getPropertyEditorsSync().filter(function(e){return h(e.getConfig(),T);});};B.prototype.getPropertyEditorsSync=function(){return v(this._mPropertyEditors).reduce(function(e,D){return e.concat(D);},[]).sort(function(e,D){return parseInt(e.getId().match(/\d+$/))-parseInt(D.getId().match(/\d+$/));});};B.prototype.getJson=function(){return o({},this.getProperty("json"));};B.prototype.getDesigntimeMetadata=function(){return o({},this.getProperty("designtimeMetadata"));};B.prototype._getContextPath=function(){var e=this.getConfig();var D=e&&e.context||null;if(D&&D[0]!=="/"){D="/"+D;}return D;};B.prototype._onValueChange=function(e){var D=e.getSource();var E=e.getParameter("path");var F=this.getJson()||{};var G=e.getParameter("value");if(E[0]==="/"){E=E.substr(1);}else{throw new Error("BaseEditor._onValueChange: unknown relative path - '"+E+"'");}var H=E.split("/");d.set(H,G,F);if(typeof G==="undefined"||i(G,D.getRuntimeConfig().defaultValue)||Array.isArray(G)&&G.length===0||k(G)&&l(G)){w(F,H);}this.setJson(F);};B.prototype._onDesigntimeMetadataChange=function(e){var D=e.getParameter("path");var E=this.getDesigntimeMetadata()||{};var F=e.getParameter("value");if(D[0]==="/"){D=D.substr(1);}else{throw new Error("BaseEditor._onDesigntimeMetadataChange: unknown relative path - '"+D+"'");}var G=D.split("/");d.set(G,F,E);b(E);this.setDesigntimeMetadata(E);};return B;});
