/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/base/util/deepClone","sap/base/util/ObjectPath","sap/base/util/isPlainObject","sap/ui/base/BindingParser","sap/base/util/includes","sap/base/util/deepEqual"],function(M,d,O,i,B,a,b){"use strict";var c=M.extend("sap.ui.integration.designtime.baseEditor.util.ObjectBinding",{metadata:{library:"sap.ui.integration",properties:{object:{type:"object"},_value:{type:"any",hidden:true}},events:{change:{parameters:{path:{type:"string"},value:{type:"any"}}}}},_originalObject:null});c.prototype.init=function(){this._aIgnoreList=[];this._oModelMap={};};c.prototype.exit=function(){this._cleanup();};c.prototype.setObject=function(o){this._setOriginalObject(o);this._init();return this;};c.prototype._setObject=function(o){var C=d(o,50);return this.setProperty("object",C);};c.prototype._setOriginalObject=function(o){this._originalObject=d(o,50);};c.prototype._getOriginalObject=function(){return this._originalObject;};c.prototype.setModel=function(m,n){var e=false;var E=Object.keys(this.oModels||{}).find(function(s){if(this.oModels[s]===m){e=true;return true;}return false;}.bind(this));this._oModelMap[n]=e?this._oModelMap[E]:n;var r=M.prototype.setModel.apply(this,arguments);this._init();return r;};c.prototype.setBindingContext=function(){var r=M.prototype.setBindingContext.apply(this,arguments);this._init();return r;};c.prototype._init=function(){this._cleanup();var o=this._getOriginalObject();if(o){this._setObject(o);this._createPropertyBindings(o);}};c.prototype._cleanup=function(){if(this._mSimpleBindings){Object.keys(this._mSimpleBindings).forEach(function(k){var o=this._mSimpleBindings[k].binding;o.getModel().removeBinding(o);o.destroy();}.bind(this));}this._mSimpleBindings={};};c.prototype._createPropertyBindings=function(o,p){Object.keys(o).filter(function(k){return!this.isIgnored(k);},this).forEach(function(k){var C=p?p+"/"+k:k;if(typeof o[k]==="string"){var e=B.complexParser(o[k]);if(e){if(e.parts){if(!e.parts.find(function(P){return!this.getModel(P.model);}.bind(this))){e.parts.forEach(function(P){this._createSimpleBinding(P,C,e);}.bind(this));}else{return;}}else if(this.getModel(e.model)){this._createSimpleBinding(e,C,e);}else{return;}this._updateValue([{path:C,bindingInfo:e}]);}}else if(o[k]&&(i(o[k])||Array.isArray(o[k]))){this._createPropertyBindings(o[k],C);}},this);};c.prototype._updateValue=function(v){var C=[];v.forEach(function(u){var o=this.getObject();var p=u.path.split("/");var k=p.pop();if(p.length){o=O.get(p,o);}this.bindProperty("_value",d(u.bindingInfo));var V=d(this.getProperty("_value"));this.unbindProperty("_value");if(V!==o[k]&&(k!=="value"||!(o.value===undefined&&b(V,o.defaultValue)))){o[k]=V;C.push({path:u.path,value:V});}}.bind(this));if(C.length){this.fireChange({changes:C});}};c.prototype._createSimpleBinding=function(s,C,o){var e=this.getBindingContext(s.model);var m=this._oModelMap[s.model];var f=this.oModels[s.model];var A=f.resolve(s.path,e);var h=m+">"+A;var g=this._mSimpleBindings[h];if(!g){g=this.getModel(s.model).bindProperty(s.path,e);this._mSimpleBindings[h]={binding:g,properties:[]};g.attachChange(function(){this._updateValue(this._mSimpleBindings[h].properties);}.bind(this));}this._mSimpleBindings[h].properties.push({path:C,bindingInfo:o});return g;};c.prototype.addToIgnore=function(k){this._aIgnoreList=this._aIgnoreList.concat(k);this._init();};c.prototype.removeFromIgnore=function(k){this._aIgnoreList=this._aIgnoreList.filter(function(I){return I!==k;});this._init();};c.prototype.isIgnored=function(k){return a(this._aIgnoreList,k);};return c;});
