/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["ui5loader","sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/Manifest","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/merge","sap/ui/base/Interface","sap/ui/integration/Designtime","sap/ui/model/json/JSONModel","sap/ui/integration/util/Utils","sap/ui/integration/util/Destinations","sap/ui/integration/util/DataProviderFactory","sap/m/Label","sap/m/Title","sap/m/Panel","sap/m/HBox","sap/m/VBox","sap/ui/core/Icon","sap/m/ResponsivePopover","sap/m/Popover","sap/m/Text","sap/base/Log","sap/ui/core/Popup","sap/base/i18n/ResourceBundle","sap/ui/thirdparty/URI","sap/ui/dom/includeStylesheet","sap/base/util/LoaderExtensions","sap/ui/core/theming/Parameters","sap/base/util/ObjectPath","sap/m/FormattedText","sap/m/MessageStrip","sap/m/ToolbarSpacer","sap/base/util/includes","sap/ui/model/resource/ResourceModel","./Manifest","./Merger","./Settings","sap/m/FlexItemData","sap/m/FlexBox","sap/m/Button"],function(u,C,c,M,d,f,g,I,D,J,U,h,p,L,T,P,H,V,q,R,r,t,v,w,x,y,A,B,E,O,F,G,S,K,N,Q,W,X,Y,Z,$){"use strict";var _=r.prototype.init;r.prototype.init=function(){_.apply(this,arguments);var a=this.oPopup._applyPosition,b=this;this.oPopup._applyPosition=function(){var e=b.close;b.close=function(){};a.apply(this,arguments);b.close=e;};};function a1(s){if(s&&s.nodeType!==1){return 0;}var z=parseInt(window.getComputedStyle(s).getPropertyValue('z-index'));if(isNaN(z)){return a1(s.parentNode);}return z+1;}var b1=/\{\{(?!parameters.)(?!destinations.)([^\}\}]+)\}\}/g,c1=/\{\{parameters\.([^\}\}]+)/g,d1=5000,e1=c.getLibraryResourceBundle("sap.ui.integration"),f1="__strip0";var g1=C.extend("sap.ui.integration.editor.Editor",{metadata:{library:"sap.ui.integration",properties:{mode:{type:"string",defaultValue:"admin"},language:{type:"string",defaultValue:""},allowDynamicValues:{type:"boolean",defaultValue:false},allowSettings:{type:"boolean",defaultValue:false},designtime:{type:"object"},section:{type:"string",defaultValue:"sap.card"},host:{type:"string",defaultValue:""},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},json:{type:"object"},previewPosition:{type:"string",defaultValue:"right"}},aggregations:{_formContent:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},_preview:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_messageStrip:{type:"sap.m.MessageStrip",multiple:false,visibility:"hidden"},_extension:{type:"sap.ui.integration.editor.Extension",multiple:false,visibility:"hidden"}},events:{ready:{},manifestReady:{}}},renderer:function(o,a){var b=a.getAggregation("_preview");var s=a.getMode()!=="translation"&&a.hasPreview();var e=a.getPreviewPosition();if(s&&(e==="top"||e==="bottom")){o.openStart("div");o.writeElementData(a);o.openEnd();if(a.isReady()&&e==="top"){o.renderControl(b);o.close("div");}}o.openStart("div");o.addClass("sapUiIntegrationEditor");if(s&&e==="left"){o.writeElementData(a);o.openEnd();if(a.isReady()){o.renderControl(b);o.close("div");}}else if(s&&(e==="bottom"||e==="top")){o.openEnd();}else{o.writeElementData(a);o.openEnd();}if(a.isReady()){o.openStart("div");o.addClass("sapUiIntegrationEditorForm");if(a.getMode()!=="translation"){o.addClass("settingsButtonSpace");}o.writeClasses();o.openEnd();if(a.getMode()!=="translation"){o.renderControl(a.getAggregation("_messageStrip"));}var j=a.getAggregation("_formContent");if(j){var k;var l;var m;var z=[];var h1;var i1=function(){if(z.length>0){var C1=2-z.length;for(var n=0;n<C1;n++){z.push(new V());}k.addContent(new Z({alignItems:"Start",justifyContent:"SpaceBetween",items:z}));z=[];}};for(var i=0;i<j.length;i++){var j1=j[i];if(a.getMode()!=="translation"){if(j1.isA("sap.m.Panel")){if(k){i1();if(k.getContent().length>0){o.renderControl(k);}}k=j1;k.addStyleClass("sapUiIntegrationEditorItem");if(i===j.length-1){i1();if(k.getContent().length>0){o.renderControl(k);}}continue;}if(j1.isA("sap.m.FormattedText")){k.addContent(j1.addStyleClass("sapUiIntegrationEditorHint"));if(i===j.length-1){i1();if(k.getContent().length>0){o.renderControl(k);}}continue;}var k1=j1._layout;if(j1.isA("sap.m.Label")){j1.addStyleClass("sapUiIntegrationEditorItemLabel");if(k1&&!f(k1,{})){if(k1.alignment&&k1.alignment.label==="end"){j1.setTextAlign("End");}m=j1;}else{if(j1._cols===2||(j1._cols===1&&z.length===2)){i1();}k.addContent(j1);}}else if(j1.isA("sap.m.ToolbarSpacer")){i1();if(j1._hasLine){j1.addStyleClass("sapUiIntegrationEditorSpacerWithLine");}else{j1.addStyleClass("sapUiIntegrationEditorSpacerWithoutLine");}k.addContent(j1);}else{var l1=j1.getConfiguration(),m1=new H(),n1=0.1,o1=0,p1;if(j1._descriptionIcon){m1.addItem(j1._descriptionIcon);n1+=0.9;}var q1=c.byId(j1.getAssociation("_messageIcon"));if(j1.getAssociation("_messageIcon")&&q1){m1.addItem(q1);n1+=1.2;}if(j1._settingsButton){j1._settingsButton.addStyleClass("sapUiIntegrationEditorSettingsButton");o1=2;}var r1=new Y({growFactor:10,maxWidth:"calc(100% - "+o1+"rem)"});var s1=new Y({maxWidth:"calc(100% - "+n1+"rem)"});if(m){var t1,u1,v1="50%";if(k1&&k1["label-width"]){v1=k1["label-width"];}var w1=parseInt(v1);var x1=100-w1;if(j1._cols===2){w1=w1-0.5;x1=x1-0.5;}if(k1.alignment&&k1.alignment.field==="end"){j1.addStyleClass("sapUiIntegrationEditorFieldAlignEnd");}if(k1.alignment&&k1.alignment.label==="end"){m.setLayoutData(new Y({maxWidth:"calc(100% - "+n1+"rem)",minWidth:"calc(100% - "+n1+"rem)"}));}else{m.setLayoutData(s1);}if(m1.getItems().length>0){m.addStyleClass("sapUiIntegrationEditorItemLabelWithInfo");p1=new H({items:[m,m1]});}else{p1=m;}if(k1&&k1.position&&k1.position==="field-label"){p1.setLayoutData(r1);u1=new H({alignItems:"Start",justifyContent:"SpaceBetween",items:[p1,j1._settingsButton]});u1.setLayoutData(new Y({growFactor:w1,maxWidth:w1+"%"}));j1.setLayoutData(new Y({growFactor:x1,maxWidth:x1+"%"}));t1=new H({alignItems:"Start",justifyContent:"SpaceBetween",items:[j1,u1]});}else{j1.setLayoutData(r1);u1=new H({alignItems:"Start",justifyContent:"SpaceBetween",items:[j1,j1._settingsButton]});p1.setLayoutData(new Y({growFactor:w1,maxWidth:w1+"%"}));u1.setLayoutData(new Y({growFactor:x1,maxWidth:x1+"%"}));t1=new H({alignItems:"Start",justifyContent:"SpaceBetween",items:[p1,u1]});}if(j1._cols===1){if(z.length===2){i1();}if(l1.hint){var y1=a._createHint(l1.hint);var z1=new V({items:[t1,y1.addStyleClass("sapUiIntegrationEditorHint")]});z1.addStyleClass("col1");z.push(z1);}else{t1.addStyleClass("col1");z.push(t1);}}else{i1();k.addContent(t1);}m=null;}else{var A1=k.getContent().pop();A1.setLayoutData(s1);if(m1.getItems().length>0){A1.addStyleClass("sapUiIntegrationEditorItemLabelWithInfo");p1=new H({items:[A1,m1]});}else{p1=A1;}p1.setLayoutData(r1);var B1=new Z({alignItems:"Start",justifyContent:"SpaceBetween",items:[p1,j1._settingsButton]});if(j1._cols===1){var z1=new V({items:[B1,j1]});if(l1.hint){var y1=a._createHint(l1.hint);z1.addItem(y1.addStyleClass("sapUiIntegrationEditorHint"));}z1.addStyleClass("col1");z.push(z1);}else{k.addContent(B1);k.addContent(j1);}}}if(i===j.length-1){i1();if(k.getContent().length>0){o.renderControl(k);}}}else{if(i===0){l=j1;o.renderControl(l);l.addStyleClass("sapUiIntegrationEditorTranslationPanel");continue;}if(j1.isA("sap.m.Panel")){if(k&&k.getContent().length>0){l.addContent(k);}k=j1;k.addStyleClass("sapUiIntegrationEditorTranslationSubPanel");continue;}if(j1.isA("sap.m.ToolbarSpacer")){continue;}if(j1.isA("sap.m.FormattedText")){continue;}if(j1.isA("sap.m.Label")){k.addContent(j1);continue;}if(j1.isOrigLangField){h1=j1;continue;}h1.addStyleClass("sapUiIntegrationFieldTranslationText");var t1=new H({items:[h1,j1]}).addStyleClass("notWrappingRow");k.addContent(t1);if(i===j.length-1){l.addContent(k);}}}}o.close("div");if(s&&e==="right"){o.renderControl(b);}}o.close("div");if(a.isReady()&&s&&e==="bottom"){o.renderControl(b);o.close("div");}}});g1.prototype.init=function(){this._ready=false;this._aFieldReadyPromise=[];this._oResourceBundle=c.getLibraryResourceBundle("sap.ui.integration");this._appliedLayerManifestChanges=[];this._currentLayerManifestChanges={};this._mDestinationDataProviders={};this.setAggregation("_messageStrip",new G({showIcon:false}));this._oLimitedInterface=new I(this,["getParameters","resolveDestination","request","getModel"]);};g1.prototype.getParameters=function(){if(!this._isManifestReady){v.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.editor.Editor");return null;}var o=this._oEditorManifest.getProcessedParameters(),a={},k;for(k in o){a[k]=o[k].value;}return a;};g1.prototype.resolveDestination=function(k){return this._oDestinations.getUrl(k);};g1.prototype.isReady=function(){return this._ready;};g1.prototype.hasPreview=function(){var o=this.getAggregation("_preview");if(o&&o.visible!==false){return true;}return false;};g1.prototype.flattenData=function(o,s,a,b){b=b||"";a=a||[];if(typeof o==="object"){if(!o[s]){for(var n in o){this.flattenData(o[n],s,a,b+"/"+n);}}else{if(o.type){a.push({path:o.pathvalue||b.substring(1),value:o.pathvalue||"{context>"+b.substring(1)+"/value}",object:o});}else{a.push({path:b.substring(1),object:o});for(var n in o){this.flattenData(o[n],s,a,b+"/"+n);}}}}return a;};g1.prototype.setJson=function(i,s){this._ready=false;if(f(i,this._preIdOrSettings)){return this;}this._preIdOrSettings=d(i,500);if(typeof i==="string"){try{i=JSON.parse(i);}catch(e){}}if(typeof i==="object"){if(i.manifestChanges){this._filterManifestChangesByLayer(i);}if(this._manifestModel){return;}if(this._oDesigntimeInstance){this._oDesigntimeInstance.destroy();}if(i.host){this.setProperty("host",i.host);}if(i.baseUrl){this.setProperty("baseUrl",i.baseUrl);}this._appliedLayerManifestChanges=i.manifestChanges;this.createManifest(i,s);}};g1.prototype.createManifest=function(i,s){var b=this.getBaseUrl();var o={},m=i.manifest;this._isManifestReady=false;if(typeof m==="string"){o.manifestUrl=m;m=null;}if(this._oEditorManifest){this._oEditorManifest.destroy();}this.destroyAggregation("_extension");var a=W.layers[this.getMode()];this._oEditorManifest=new Q(this.getSection(),m,b,i.manifestChanges);this._oEditorManifest.load(o).then(function(){this._registerManifestModulePath();this._oInitialManifestModel=new J(this._oEditorManifest._oInitialJson);this.setProperty("json",this._oEditorManifest._oInitialJson,s);var e=this._oEditorManifest._oManifest.getRawJson();var j=g({},e);this._beforeManifestModel=new J(j);if(a<W.layers["translation"]&&this._currentLayerManifestChanges){e=W.mergeDelta(e,[this._currentLayerManifestChanges]);}this._manifestModel=new J(e);this._isManifestReady=true;this.fireManifestReady();this._loadDefaultTranslations();this._createContextModel();if(this._oEditorManifest.getResourceBundle()){this._enhanceI18nModel(this._oEditorManifest.getResourceBundle());}return this._loadExtension().then(function(){this._initInternal();}.bind(this));}.bind(this));};g1.prototype._registerManifestModulePath=function(){if(!this._oEditorManifest){return;}this._sAppId=this._oEditorManifest.get("/sap.app/id");if(this._sAppId){B.registerResourcePath(this._sAppId.replace(/\./g,"/"),this._oEditorManifest.getUrl()||"/");}else{v.error("sap.app/id entry in the manifest is mandatory");}};g1.prototype._loadDefaultTranslations=function(){if(this._defaultTranslationsLoaded){return;}var e1=c.getLibraryResourceBundle("sap.ui.integration");this._enhanceI18nModel(e1);this._defaultTranslationsLoaded=true;};g1.prototype._enhanceI18nModel=function(e1){var o=this.getModel("i18n");if(o){if(o.getResourceBundle().oUrlInfo.url!==e1.oUrlInfo.url){o.enhance(e1);this._oResourceBundle=o.getResourceBundle();}return;}o=new N({bundle:e1});this.setModel(o,"i18n");this._oResourceBundle=e1;};g1.prototype._loadExtension=function(){var e=this._oEditorManifest.get(this.getConfigurationPath()+"/extension")||this._oEditorManifest.get("/"+this.getSection()+"/extension");if(!e){v.info("Extension is not defined in manifest, do not load it.");return new Promise(function(a,b){a();});}var s=this._sAppId.replace(/\./g,"/")+"/"+e;return new Promise(function(a,b){sap.ui.require([s],function(i){var o=new i();o._setEditor(this,this._oLimitedInterface);this.setAggregation("_extension",o);a();}.bind(this),function(i){v.error("Failed to load "+e+". Check if the path is correct. Reason: "+i);b(i);});}.bind(this));};g1.prototype.request=function(o){return this._oDataProviderFactory.create({request:o}).setAllowCustomDataType(true).getData();};g1.prototype.initDestinations=function(a){var o=this.getHostInstance();if(a&&!o){v.error("Host with id '"+a+"' is not available during editor initialization. It must be available for host specific features to work.","Make sure that the host already exists, before assigning it to the editor.","sap.ui.integration.editor.Editor");}if(this._oDestinations){this._oDestinations.setHost(o);}else{var s=this.getConfigurationPath();this._oDestinations=new h(o,this._manifestModel.getProperty(s+"/destinations"));}};g1.prototype.initDataProviderFactory=function(){if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();}var e=this.getAggregation("_extension");this._oDataProviderFactory=new p(this._oDestinations,e,undefined,this);};g1.prototype.getRuntimeUrl=function(s){var a=this._sAppId,b,e=s&&s.trim().replace(/^\//,"");if(a===null){v.error("The manifest is not ready so the URL can not be resolved. Consider using the 'manifestReady' event.","sap.ui.integration.editor.Editor");return null;}if(!a||s.startsWith("http://")||s.startsWith("https://")||s.startsWith("//")){return s;}b=a.replace(/\./g,"/");return sap.ui.require.toUrl(b)+"/"+e;};g1.prototype.getBindingNamespaces=function(){var n={},e=this.getAggregation("_extension");if(e){n.extension={formatters:e.getFormatters()};}return n;};g1.prototype.getHostInstance=function(){var s=this.getHost();if(!s){return null;}return c.byId(s);};g1.prototype.setLanguage=function(s,b){if(!s||typeof s!=="string"){return this;}this._language=s.replaceAll('_','-');if(this.getLanguage()!=s){var e1=c.getLibraryResourceBundle("sap.ui.integration");this._enhanceI18nModel(e1);}this.setProperty("language",s,b);if(!g1._languages[this._language]){this._language=this._language.split("-")[0];}if(!g1._languages[this._language]){v.warning("The language: "+s+" is currently unknown, some UI controls might show "+s+" instead of the language name.");}return this;};g1.prototype.onAfterRendering=function(){if(this.getDomRef()){this._iZIndex=a1(this.getDomRef());w.setInitialZIndex(this._iZIndex);}};g1.prototype._filterManifestChangesByLayer=function(m){var a=[],o={":layer":W.layers[this.getMode()]},i=W.layers[this.getMode()];m.manifestChanges.forEach(function(b){var l=b.hasOwnProperty(":layer")?b[":layer"]:1000;if(l<i){a.push(b);}else if(l===i){o=b;}});m.manifestChanges=a;this._currentLayerManifestChanges=o;};g1.prototype._initInternal=function(){var a=this;var s=a.getConfigurationPath();var b=a._oEditorManifest.get(s+"/editor");if(!b){b=a._oEditorManifest.get("/"+a.getSection()+"/designtime");}var o=a._manifestModel.getProperty(s),e,i=a.getDesigntime();if(i){if(typeof i==="function"){e=new Promise(function(j,k){var l=new i();a._applyDesigntimeDefaults(l.getSettings());j(l);});}else if(typeof i==="object"){e=new Promise(function(j,k){sap.ui.require(["sap/ui/integration/Designtime"],function(D){var l=D.extend("test.Designtime");l.prototype.create=function(){return i;};var m=new l();a._applyDesigntimeDefaults(m.getSettings());j(m);});});}}else if(b){e=a.loadDesigntime().then(function(j){a._applyDesigntimeDefaults(j.getSettings());return j;});}else{e=Promise.resolve(a._createParameterDesigntime(o));}e.then(function(j){a._oDesigntimeInstance=j;a.initDestinations();a.initDataProviderFactory();if(a.getMode()==="admin"||a.getMode()==="all"){a._addDestinationSettings(o,a._oDesigntimeInstance);}a._settingsModel=new J(a._oDesigntimeInstance.getSettings());a.setModel(a._settingsModel,"currentSettings");a.setModel(a._settingsModel,"items");return a._loadValueContextInDesigntime();}).then(function(){a._applyDesigntimeLayers();return a._requestExtensionData();}).then(function(){a._requireFields().then(function(){a._startEditor();});});};g1.prototype.loadDesigntime=function(){if(this._oDesigntime){return Promise.resolve(this._oDesigntime);}if(!this._oEditorManifest){return new Promise(function(a,b){this.attachManifestReady(function(){this.loadDesigntime().then(a,b);}.bind(this));}.bind(this));}if(!this._sAppId){return Promise.reject("App id not maintained");}return new Promise(function(a,b){var s=this._oEditorManifest.get(this.getConfigurationPath()+"/editor");if(!s){s=this._oEditorManifest.get("/"+this.getSection()+"/designtime");}var e=this._sAppId.replace(/\./g,"/")+"/"+s;if(e){sap.ui.require([e],function(o){o=new o();o._readyPromise(this._oLimitedInterface,this).then(function(){this._oDesigntime=o;a(o);}.bind(this));}.bind(this),function(){b({error:e+" not found"});});}else{b();}}.bind(this));};g1.prototype.getConfigurationPath=function(){return"/"+this.getSection()+"/configuration";};g1.prototype.getCurrentSettings=function(){var s=this._settingsModel.getProperty("/"),m={},a;if(s&&s.form&&s.form.items){for(var n in s.form.items){var i=s.form.items[n];if(i.editable&&i.visible){var b="";if(i.manifestpath){b=i.manifestpath.substring(0,i.manifestpath.lastIndexOf("/"))+"/valueTranslations";}if(this.getMode()!=="translation"){if(i.translatable&&!i._changed&&i._translatedPlaceholder&&!this._currentLayerManifestChanges[i.manifestpath]&&!this._currentLayerManifestChanges[b]){continue;}else{m[i.manifestpath]=i.value;if(i.valueItems){m[i.manifestpath.substring(0,i.manifestpath.lastIndexOf("/"))+"/valueItems"]=i.valueItems;}}}else if(i.translatable&&i.value){m[i.manifestpath]=i.value;}if(i._next&&(this.getAllowSettings())){var e=typeof(i.visibleToUser)==="undefined"?true:i.visibleToUser;var j=typeof(i.editableToUser)==="undefined"?true:i.editableToUser;if(i._next.visible===!e){a=a||{};a[i._settingspath+"/visible"]=i._next.visible;}if(i._next.editable===!j){a=a||{};a[i._settingspath+"/editable"]=i._next.editable;}if(i._next.pageAdminValues){a=a||{};a[i._settingspath+"/pageAdminValues"]=i._next.pageAdminValues;}if(typeof i._next.allowDynamicValues==="boolean"&&this.getAllowDynamicValues()){a=a||{};a[i._settingspath+"/allowDynamicValues"]=i._next.allowDynamicValues;}}}}}if(this.getMode()!=="translation"){m[":multipleLanguage"]=true;}m[":layer"]=W.layers[this.getMode()];m[":errors"]=this.checkCurrentSettings()[":errors"];if(a){m[":designtime"]=a;}return m;};g1.prototype.checkCurrentSettings=function(){var s=this._settingsModel.getProperty("/"),m={};if(s&&s.form&&s.form.items){for(var n in s.form.items){var i=s.form.items[n];if(i.editable){if((i.isValid||i.required)&&!(this.getMode()==="translation"&&i.translatable)){if(i.isValid){m[i.manifestpath]=i.isValid(i);}m[i.manifestpath]=true;var a=i.value;var b=i.type;if(b==="string"&&a===""){m[i.manifestpath]=a;}if((b==="date"||b==="datetime")&&isNaN(Date.parse(a))){m[i.manifestpath]=a;}if(b==="integer"){if(isNaN(parseInt(a))){m[i.manifestpath]=a;}else if(a<i.min||a>i.max){m[i.manifestpath]=a;}}if(b==="number"){if(isNaN(parseFloat(a))){m[i.manifestpath]=a;}else if(a<i.min||a>i.max){m[i.manifestpath]=a;}}}}}m[":layer"]=W.layers[this.getMode()];}m[":errors"]=Object.values(m).indexOf(false)>-1;return m;};g1.prototype._createContextModel=function(){var b=this.getHostInstance(),e=new J({}),i=new J([]);this.setModel(e,"context");this.setModel(i,"contextflat");e._aPendingPromises=[];i._getPathObject=function(s){var a=this.getData().filter(function(o){if(o.path===s){return true;}});return a.length?a[0]:null;};i._getValueObject=function(s){var a=this.getData()||[];a=a.filter(function(o){if(o.value===s||o.object.value===s){return true;}});return a.length?a[0]:null;};var j=new Promise(function(a,k){if(b&&b.getContext){var l=false;setTimeout(function(){if(l){return;}v.error("Editor context could not be determined with "+d1+".");l=true;a({});},d1);b.getContext().then(function(o){if(l){v.error("Editor context returned after more than "+d1+". Context is ignored.");}l=true;a(o||{});});}else{a({});}});j.then(function(o){var a=this._mergeContextData(o);e.setData(a);i.setData(this.flattenData(a,"label"));}.bind(this));e.getProperty=function(s,o){if(s&&!s.startsWith("/")&&!o){s="/"+s;}var a=this.resolve(s,o),k;if(a.endsWith("/value")){this._mValues=this._mValues||{};if(this._mValues.hasOwnProperty(a)){return this._mValues[a];}this._mValues[a]=undefined;k=U.timeoutPromise(b.getContextValue(a.substring(1)));k=k.then(function(l){this._mValues[a]=l;this.checkUpdate();}.bind(this)).catch(function(l){this._mValues[a]=null;this.checkUpdate();v.error("Path "+a+" could not be resolved. Reason: "+l);}.bind(this));this._aPendingPromises.push(k);return undefined;}else{return J.prototype.getProperty.apply(this,arguments);}};};g1.prototype._mergeContextData=function(o){var a={};a["empty"]=g1._contextEntries.empty;for(var n in o){a[n]=o[n];}a["editor.internal"]=g1._contextEntries["editor.internal"];return a;};g1.prototype._loadValueContextInDesigntime=function(){var o=this.getModel("context");var s=this._oDesigntimeInstance.getSettings();var i;if(s&&s.form&&s.form.items){i=JSON.stringify(s.form.items);}if(i){var a=/\{context\>[\/?\w+.]+\}/g;var b=i.match(a);var e;if(b&&b.length>0){b=b.filter(function(j){return j.endsWith("value}");});e=b.map(function(j){return j.substring("{context>".length,j.length-1);});e.forEach(function(j){o.getProperty(j);});return Promise.all(o._aPendingPromises).then(function(){o._aPendingPromises=[];});}}return Promise.resolve();};g1.fieldMap={"string":"sap/ui/integration/editor/fields/StringField","integer":"sap/ui/integration/editor/fields/IntegerField","number":"sap/ui/integration/editor/fields/NumberField","boolean":"sap/ui/integration/editor/fields/BooleanField","date":"sap/ui/integration/editor/fields/DateField","datetime":"sap/ui/integration/editor/fields/DateTimeField","string[]":"sap/ui/integration/editor/fields/ListField","destination":"sap/ui/integration/editor/fields/DestinationField"};g1.Fields=null;g1.prototype._requireFields=function(){if(g1.Fields){return Promise.resolve();}return new Promise(function(a){sap.ui.require(Object.values(g1.fieldMap),function(){g1.Fields={};for(var n in g1.fieldMap){g1.Fields[n]=arguments[Object.keys(g1.fieldMap).indexOf(n)];}a();});});};g1.prototype._createDescription=function(o){var a=new q({src:"sap-icon://message-information",color:"Marker",size:"12px",useIconTooltip:false,visible:o.visible,objectBindings:{currentSettings:{path:"currentSettings>"+o._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});a.addStyleClass("sapUiIntegrationEditorDescriptionIcon");a.onmouseover=function(a){this._getPopover().getContent()[0].applySettings({text:o.description});this._getPopover().openBy(a);a.addDependent(this._getPopover());}.bind(this,a);a.onmouseout=function(a){this._getPopover().close();a.removeDependent(this._getPopover());}.bind(this,a);return a;};g1.prototype._createMessageIcon=function(o){var a=o.getConfiguration();var m=new q({src:"sap-icon://message-information",size:"12px",visible:a.visible,useIconTooltip:false,objectBindings:{currentSettings:{path:"currentSettings>"+a._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});m.onmouseover=function(o){o._showMessage();}.bind(this,o);m.onmouseout=function(o){o._hideMessage();}.bind(this,o);m.addStyleClass("sapUiIntegrationEditorMessageIcon");return m;};g1.prototype._createLabel=function(o){var l=new L({text:o.label,tooltip:o.tooltip||o.label,required:o.required&&o.editable||false,visible:o.visible,objectBindings:{currentSettings:{path:"currentSettings>"+o._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});l._cols=o.cols||2;if(o.layout){l._layout=o.layout;}l._sOriginalType=o.type;return l;};g1.prototype._createSettingsButton=function(o){var a=o.getConfiguration();var s=new $({icon:"{= ${currentSettings>_hasDynamicValue} ? 'sap-icon://display-more' : 'sap-icon://enter-more'}",type:"Transparent",tooltip:this._oResourceBundle.getText("EDITOR_FIELD_MORE_SETTINGS"),press:function(e){this._openSettingsDialog(200,e.oSource,o);}.bind(this),visible:a.visible,objectBindings:{currentSettings:{path:"currentSettings>"+a._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});return s;};g1.prototype._getSettingsPanel=function(o){if(!o._oSettingsPanel){o._oSettingsPanel=new X();}return o._oSettingsPanel;};g1.prototype._openSettingsDialog=function(i,s,o){var a=this._getSettingsPanel(o);window.setTimeout(function(){a.setConfiguration(o.getConfiguration());var b=this.getAggregation("_preview");a.open(s,s,b,o.getHost(),o,o._applySettings.bind(o),o._cancelSettings.bind(o));}.bind(this),i||600);};g1.prototype._getPopover=function(){if(this._oPopover){return this._oPopover;}var o=new t({text:""});o.addStyleClass("sapUiTinyMargin sapUiIntegrationEditorDescriptionText");this._oPopover=new R({showHeader:false,content:[o]});this._oPopover.addStyleClass("sapUiIntegrationEditorPopover");return this._oPopover;};g1.prototype._createField=function(o){var a=new g1.Fields[o.type]({configuration:o,mode:this.getMode(),host:this.getHostInstance(),objectBindings:{currentSettings:{path:"currentSettings>"+o._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}},visible:o.visible});this._aFieldReadyPromise.push(a._readyPromise.then(function(){if(o.require||o.validation||(o.validations&&o.validations.length>0)||(o.values&&o.values.data&&!o.values.data.json)){var m=this._createMessageIcon(a);a.setAssociation("_messageIcon",m);}if(o.description&&this.getMode()!=="translation"){a._descriptionIcon=this._createDescription(o);}if(o._changeDynamicValues){a._settingsButton=this._createSettingsButton(a);a._applyButtonStyles();}}.bind(this)));var b=this._settingsModel.bindProperty(o._settingspath+"/value");b.attachChange(function(){if(!this._bIgnoreUpdates){o._changed=true;if(o._dependentFields&&o._dependentFields.length>0){this._updateEditor(o._dependentFields);}this._updatePreview();}}.bind(this));if(a.isFilterBackend()){var s=this._settingsModel.bindProperty(o._settingspath+"/suggestValue");s.attachChange(function(){var e=g({},o);e._cancel=false;this._addValueListModel(e,a,true);}.bind(this));}this._addValueListModel(o,a);a._cols=o.cols||2;if(o.layout){a._layout=o.layout;}a._oDataProviderFactory=this._oDataProviderFactory;a.setAssociation("_messageStrip",this.getAggregation("_messageStrip"));return a;};g1.prototype._updateEditor=function(a){if(this._ready){if(a.length===0){return;}for(var i=0;i<a.length;i++){var o=a[i];o.config._cancel=true;}if(!this._oDataProviderFactory){return;}this._bIgnoreUpdates=true;for(var i=0;i<a.length;i++){var o=a[i];o.config._cancel=false;this._addValueListModel(o.config,o.field,true,500*i);}this._bIgnoreUpdates=false;}};g1.prototype._updatePreview=function(){var o=this.getAggregation("_preview");if(o&&o.update){o.update();}};g1.prototype._requestData=function(o,a){var b=this._oDataProviderFactory.create(o.values.data);b.bindObject({path:"items>/form/items"});b.bindObject({path:"currentSettings>"+o._settingspath});b.bindObject({path:"context>/"});var e=b.getData();e.then(function(m){if(o._cancel){o._values=[];this._settingsModel.setProperty(o._settingspath+"/_loading",false);return;}var s=o.values.data.path,z,h1=[];if(s&&s!=="/"){if(s.startsWith("/")){s=s.substring(1);}if(s.endsWith("/")){s=s.substring(0,s.length-1);}z=s.split("/");h1=O.get(z,m);}else{h1=m;}if(this.getMode()==="content"&&o.pageAdminValues&&o.pageAdminValues.length>0){var i1=o.pageAdminValues,j1=o.value,k1=o.valueItems,l1=[],m1=[],n1=[];this.prepareFieldsInKey(o);if(i1.length>0){for(var i=0;i<i1.length;i++){for(var j=0;j<h1.length;j++){var o1=this.getKeyFromItem(h1[j]);if(i1[i]===o1){l1.push(h1[j]);}}if(Array.isArray(j1)){for(var k=0;k<j1.length;k++){if(i1[i]===j1[k]){m1.push(j1[k]);}}for(var l=0;l<k1.length;l++){var p1=this.getKeyFromItem(k1[l]);if(i1[i]===p1){n1.push(k1[l]);}}}}if(m1.length>0){o.value=[];o.value=m1;}if(n1.length>0){o.valueItems=[];o.valueItems=n1;}}if(o.values.data.path&&o.values.data.path!=="/"){delete m[z];O.set(z,l1,m);}else{m=[];m=l1;}}var q1=a.getConfiguration();if(o.type==="string[]"){var r1=o.values.data.path;if(r1&&r1!=="/"){if(r1.startsWith("/")){r1=r1.substring(1);}if(r1.endsWith("/")){r1=r1.substring(0,r1.length-1);}var z=r1.split("/");var s1=O.get(z,m);if(Array.isArray(s1)){for(var n in s1){var t1=a.getKeyFromItem(s1[n]);if(Array.isArray(q1.value)&&q1.value.length>0&&K(q1.value,t1)){s1[n].Selected=this._oResourceBundle.getText("EDITOR_ITEM_SELECTED");}else{s1[n].Selected=this._oResourceBundle.getText("EDITOR_ITEM_UNSELECTED");}}O.set(z,s1,m);}}else if(Array.isArray(m)){for(var n in m){var t1=a.getKeyFromItem(m[n]);if(Array.isArray(q1.value)&&q1.value.length>0&&K(q1.value,t1)){m[n].Selected=this._oResourceBundle.getText("EDITOR_ITEM_SELECTED");}else{m[n].Selected=this._oResourceBundle.getText("EDITOR_ITEM_UNSELECTED");}}}}o._values=m;var u1=a.getModel();u1.setData(m);u1.checkUpdate(true);u1.firePropertyChange();this._settingsModel.setProperty(o._settingspath+"/_loading",false);a._hideValueState(true,true);}.bind(this)).catch(function(i){this._settingsModel.setProperty(o._settingspath+"/_loading",false);var s=this._oResourceBundle.getText("EDITOR_BAD_REQUEST");if(Array.isArray(i)&&i.length>0){s=i[0];var j=i[1];if(j){var k;if(j.responseJSON){k=j.responseJSON.error;}else if(j.responseText){if(U.isJson(j.responseText)){k=JSON.parse(j.responseText).error;}else{s=j.responseText;}}if(k){s=(k.code||k.errorCode||j.status)+": "+k.message;}}}else if(typeof(i)==="string"){s=i;}var l=a.getModel();l.firePropertyChange();a._showValueState("error",s,true);}.bind(this));};g1.prototype._requestExtensionData=function(){var e=this.getAggregation("_extension");if(!e){v.info("Extension is not defined or created, do not load data of it.");return new Promise(function(k,l){k();});}var b=false;var o={};var a=this._oEditorManifest.get(this.getConfigurationPath()+"/data/extension");var s;if(a){b=true;s=this._oEditorManifest.get(this.getConfigurationPath()+"/data/path");o={"extension":a};if(s){o.path=s;}}else{a=this._oEditorManifest.get("/"+this.getSection()+"/data/extension");if(a){b=true;s=this._oEditorManifest.get("/"+this.getSection()+"/data/path");o={"extension":a};if(s){o.path=s;}}}if(!b){v.info("Extension data is not defined in manifest, do not load data of it.");return new Promise(function(k,l){k();});}var i=this._oDataProviderFactory.create(o);var j=i.getData();return j.then(function(k){var l=e.getModel();if(!l){l=new J(k||{});e.setModel(l,undefined);}else{l.setData(k);}l.checkUpdate(true);}).catch(function(k){var l=this._oResourceBundle.getText("EDITOR_BAD_REQUEST");if(Array.isArray(k)&&k.length>0){l=k[0];var m=k[1];if(m){var n;if(m.responseJSON){n=m.responseJSON.error;}else if(m.responseText){if(U.isJson(m.responseText)){n=JSON.parse(m.responseText).error;}else{l=m.responseText;}}if(n){l=(n.code||n.errorCode||m.status)+": "+n.message;}}}else if(typeof(k)==="string"){l=k;}v.error("Request extension data failed, "+l);}.bind(this));};g1.prototype._addValueListModel=function(o,a,b,n){if(o.values){var e;if(o.values.data){if(this._oDataProviderFactory){e=a.getModel();if(!e){e=new J({});a.setModel(e,undefined);}this._settingsModel.setProperty(o._settingspath+"/_loading",true);if(!n){this._requestData(o,a);}else{setTimeout(function(){this._requestData(o,a);}.bind(this),n);}}a.bindObject({path:o.values.data.path||"/"});}else if(this.getAggregation("_extension")){e=this.getAggregation("_extension").getModel();if(e&&this.getMode()==="content"&&o.pageAdminValues&&o.pageAdminValues.length>0){this.prepareFieldsInKey(o);var k=o.values.path;if(k.length>1){k=k.substring(1);}var l=O.get([k],e.getData()),s=o.pageAdminValues,z=[];for(var m=0;m<s.length;m++){for(var j=0;j<l.length;j++){var h1=this.getKeyFromItem(l[j]);if(s[m]===h1){z.push(l[j]);}}}delete l[k];O.set(k,z,l);e.setData(l);}a.bindObject({path:o.values.path||"/"});a.setModel(e,undefined);}if(!b){var i1=JSON.stringify(o.values.data);if(i1){var j1=/parameters\.([^\}\}]+)|destinations\.([^\}\}]+)|\{items\>[\/?\w+]+\}/g,k1=i1.match(j1);if(k1){for(var i=0;i<k1.length;i++){var l1="/value";var m1=this.getConfigurationPath();if(k1[i].indexOf("destinations.")===0||k1[i].indexOf("parameters.")===0){if(k1[i].indexOf("destinations.")===0){l1="/name";}m1=m1+k1[i].replace(".","/")+"/"+l1;}else if(k1[i].indexOf("{items>")===0){m1=m1+"/parameters/"+k1[i].slice(7,-1);}var n1=this._mItemsByPaths[m1];if(n1){if(n1._settingspath===o._settingspath){o=g({},o);}n1._dependentFields=n1._dependentFields||[];n1._dependentFields.push({field:a,config:o});}}}}}}};g1.prototype._addItem=function(o){var m=this.getMode();if(this.getAllowDynamicValues()===false||!o.allowDynamicValues){o.allowDynamicValues=false;}if(this.getAllowSettings()===false){o.allowSettings=false;}o.__cols=o.cols||2;if(o.visible===false||(!o.translatable&&m==="translation"&&o.type!=="group")){return;}if(o.type==="group"){var a=new P({headerText:o.label,visible:o.visible,expandable:o.expandable!==false,expanded:o.expanded!==false,width:"auto",backgroundDesign:"Transparent",objectBindings:{currentSettings:{path:"currentSettings>"+o._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}},expand:function(i){var j=i.getSource();if(!i.mParameters.expand&&j.getParent().getAggregation("_messageStrip")!==null){f1=j.getParent().getAggregation("_messageStrip").getId();}if(i.mParameters.expand){var k=c.byId(f1);j.addContent(k);j.focus();}}});this.addAggregation("_formContent",a);a._cols=o.cols||2;if(o.hint){this._addHint(o.hint);}return;}if(o.type==="separator"){var s=new S();this.addAggregation("_formContent",s);return;}var n=null;if(m==="translation"){if((typeof o.value==="string"&&o.value.indexOf("{")===0)||typeof o.values!=="undefined"){return;}o._language={value:o.value};o.cols=1;delete o.values;var b=d(o,500);b._settingspath+="/_language";b.editable=false;b.required=false;if(!b.value){b.value="-";}var l=this._createLabel(b);this.addAggregation("_formContent",l);var e=this._createField(b);e.isOrigLangField=true;this.addAggregation("_formContent",e);o.value=o._translatedValue||"";o.editable=o.visible=o.translatable;if(this._currentLayerManifestChanges){o.value=this._currentLayerManifestChanges[o.manifestpath]||o.value;}o.label=o._translatedLabel||"";o.required=false;var e=this._createField(o);this.addAggregation("_formContent",e);}else{n=this._createLabel(o);this.addAggregation("_formContent",n);if(this._currentLayerManifestChanges){o.value=this._currentLayerManifestChanges[o.manifestpath]||o.value;}var e=this._createField(o);this.addAggregation("_formContent",e);}if(o.hint&&(!o.cols||o.cols===2)){this._addHint(o.hint);}o.cols=o.__cols;delete o.__cols;};g1.prototype._createHint=function(s){s=s.replace(/<a href/g,"<a target='blank' href");var o=new F({htmlText:s});return o;};g1.prototype._addHint=function(s){var o=this._createHint(s);this.addAggregation("_formContent",o);};g1.prototype._getCurrentLanguageSpecificText=function(k){var l=this._language;if(this._oTranslationBundle){var s=this._oTranslationBundle.getText(k,[],true);if(s===undefined){return"";}return s;}if(!l){return"";}var i=this._oEditorManifest.get("/sap.app/i18n");if(!i){return"";}if(typeof i==="string"){var a=[l];if(l.indexOf("-")>-1){a.push(l.substring(0,l.indexOf("-")));}if(!K(a,"en")){a.push("en");}this._oTranslationBundle=x.create({url:this.getBaseUrl()+i,async:false,locale:l,supportedLocales:a,fallbackLocale:"en"});return this._getCurrentLanguageSpecificText(k);}};g1.prototype._startEditor=function(){var o=this.getAggregation("_formContent");if(o&&o.length>0){this.destroyAggregation("_formContent");}var s=this._settingsModel.getProperty("/");var i;if(s.form&&s.form.items){i=s.form.items;var l=this._language||this.getLanguage()||c.getConfiguration().getLanguage().replaceAll('_','-');if(this.getMode()==="translation"){this._addItem({type:"group",translatable:true,expandable:false,label:this._oResourceBundle.getText("EDITOR_ORIGINALLANG")+": "+g1._languages[l]});}var a=false;for(var m in i){var b=i[m];if(b.type==="group"){break;}else if(b.visible){a=true;break;}}if(a){this._addItem({type:"group",translatable:true,label:this._oResourceBundle.getText("EDITOR_PARAMETERS_GENERALSETTINGS")});}this._mItemsByPaths={};for(var n in i){var b=i[n];if(b){b.label=b.label||n;var e;if(b.manifestpath){this._mItemsByPaths[b.manifestpath]=b;e=this._currentLayerManifestChanges[b.manifestpath];}b._changed=e!==undefined&&this.getMode()!=="translation";if(b.values){b.translatable=false;}b._beforeValue=this._getManifestBeforelValue(b.manifestpath);if(b.type==="string"){b._translatedDefaultPlaceholder=this._getManifestDefaultValue(b.manifestpath);var j=null,k=b._translatedDefaultPlaceholder;if(k){if(this._isValueWithParameterSyntax(k)){b.translatable=false;}if(this._isValueWithHandlebarsTranslation(k)){j=k.substring(2,k.length-2);}else if(k.startsWith("{i18n>")){j=k.substring(6,k.length-1);}if(j){b.translatable=true;}}b._translatedPlaceholder=b._beforeValue;j=null;k=b._translatedPlaceholder;if(k){if(this._isValueWithParameterSyntax(k)){b.translatable=false;}if(this._isValueWithHandlebarsTranslation(k)){j=k.substring(2,k.length-2);}else if(k.startsWith("{i18n>")){j=k.substring(6,k.length-1);}if(j){b._translatedValue=this.getModel("i18n").getResourceBundle().getText(j);if(b._changed){b.value=e;}else{b.value=b._translatedValue;}if(b.valueTranslations&&b.valueTranslations[l]){b.value=b.valueTranslations[l];}if(this.getMode()==="translation"){b._translatedValue=this._getCurrentLanguageSpecificText(j);}}else if(b.translatable&&this.getMode()==="translation"){b._translatedValue=b._translatedPlaceholder;b.value=b._beforeValue;}}if(this.getMode()==="translation"){if(b.valueTranslations&&b.valueTranslations[l]){b._translatedValue=b.valueTranslations[l];}if(this._isValueWithHandlebarsTranslation(b.label)){b._translatedLabel=this._getCurrentLanguageSpecificText(b.label.substring(2,b.label.length-2),true);}else if(b.label&&b.label.startsWith("{i18n>")){b._translatedLabel=this._getCurrentLanguageSpecificText(b.label.substring(6,b.label.length-1),true);}}}else if(b.type==="string[]"){var z=b.manifestpath.substring(0,b.manifestpath.lastIndexOf("/"))+"/valueItems";var h1=this._manifestModel.getProperty(z);if(h1){b.valueItems=h1;}}if(b.label&&this._isValueWithHandlebarsTranslation(b.label)){var i1=b.label.substring(2,b.label.length-2);if(i1){b.label=this.getModel("i18n").getResourceBundle().getText(i1);}}}}}for(var n in i){var b=i[n];this._addItem(b);}if(this.getMode()!=="translation"){Promise.resolve(this._initPreview()).then(function(){Promise.all(this._aFieldReadyPromise).then(function(){this._ready=true;this.fireReady();}.bind(this));}.bind(this));}else{Promise.all(this._aFieldReadyPromise).then(function(){this._ready=true;this.fireReady();}.bind(this));}};g1.prototype.destroy=function(){if(this._oPopover){this._oPopover.destroy();}if(this._oDesigntimeInstance){this._oDesigntimeInstance.destroy();}var o=this.getAggregation("_preview");if(o&&o.destroy){o.destroy();}var m=c.byId(f1);if(m){m.destroy();}this._manifestModel=null;this._beforeManifestModel=null;this._oInitialManifestModel=null;this._settingsModel=null;C.prototype.destroy.apply(this,arguments);};g1.prototype._initPreview=function(){return new Promise(function(a,b){a();});};g1.prototype._applyDesigntimeDefaults=function(s){s=s||{};s.form=s.form||{};s.form.items=s.form.items||{};var i=s.form.items||s.form.items;for(var n in i){var o=i[n];if(o.manifestpath){o.value=this._manifestModel.getProperty(o.manifestpath);}if(o.visible===undefined||o.visible===null){o.visible=true;}if(o.editable===undefined||o.editable===null){o.editable=true;}if(this.getMode()!=="admin"){if(o.visibleToUser!==undefined){o.visible=o.visibleToUser;}if(o.editableToUser!==undefined){o.editable=o.editableToUser;}}if(typeof o.translatable!=="boolean"){o.translatable=false;}if(!o.label){o.label=n;}if(!o.type||o.type==="enum"){o.type="string";}if(o.value===undefined||o.value===null){switch(o.type){case"boolean":o.value=false;break;case"integer":case"number":o.value=0;break;case"string[]":o.value=[];break;default:o.value="";}}if(o.type==="group"){if(o.visible===undefined||o.value===null){o.visible=true;}}o._settingspath="/form/items/"+n;}};g1.prototype._applyDesigntimeLayers=function(s){if(this._appliedLayerManifestChanges&&Array.isArray(this._appliedLayerManifestChanges)){for(var i=0;i<this._appliedLayerManifestChanges.length;i++){var o=this._appliedLayerManifestChanges[i][":designtime"];if(o){var k=Object.keys(o);for(var j=0;j<k.length;j++){this._settingsModel.setProperty(k[j],o[k[j]]);}}}}if(this._currentLayerManifestChanges){var o=this._currentLayerManifestChanges[":designtime"];if(o){var k=Object.keys(o);for(var j=0;j<k.length;j++){var a=k[j],n=a.substring(0,a.lastIndexOf("/")+1)+"_next";if(!this._settingsModel.getProperty(n)){this._settingsModel.setProperty(n,{});}var n=a.substring(0,a.lastIndexOf("/")+1)+"_next",b=a.substring(a.lastIndexOf("/")+1);this._settingsModel.setProperty(n+"/"+b,o[k[j]]);}}}};g1.prototype._createParameterDesigntime=function(o){var s={},b=this.getConfigurationPath()+"/parameters",m=this.getMode();if(o&&o.parameters){s.form=s.form||{};s.form.items=s.form.items||{};var i=s.form.items;Object.keys(o.parameters).forEach(function(n){i[n]=g({manifestpath:b+"/"+n+"/value",editable:(m!=="translation"),_settingspath:"/form/items/"+n},o.parameters[n]);var a=i[n];if(!a.type){a.type="string";}if(!a.hasOwnProperty("visible")){a.visible=true;}});}return new D(s);};g1.prototype._addDestinationSettings=function(o){var s=this._oDesigntimeInstance.getSettings(),i=this.getConfigurationPath()+"/destinations";s.form=s.form||{};s.form.items=s.form.items||{};if(s&&o&&o.destinations){if(!s.form.items["destination.group"]){s.form.items["destination.group"]={label:this._oResourceBundle.getText("EDITOR_DESTINATIONS")||"Destinations",type:"group",visible:true};}var j=s.form.items,k=this.getHostInstance();Object.keys(o.destinations).forEach(function(n){j[n+".destinaton"]=g({manifestpath:i+"/"+n+"/name",visible:true,type:"destination",editable:true,allowDynamicValues:false,allowSettings:false,value:o.destinations[n].name,defaultValue:o.destinations[n].defaultUrl,_settingspath:"/form/items/"+[n+".destinaton"],_values:[],_destinationName:n},o.destinations[n]);if(typeof j[n+".destinaton"].label==="undefined"){j[n+".destinaton"].label=n;}if(k){j[n+".destinaton"]._loading=true;}});var l=false;if(k){this.getHostInstance().getDestinations().then(function(a){l=true;Object.keys(o.destinations).forEach(function(n){j[n+".destinaton"]._values=a;j[n+".destinaton"]._loading=false;this._settingsModel.checkUpdate(true);}.bind(this));}.bind(this)).catch(function(){return this.getHostInstance().getDestinations();}.bind(this)).then(function(b){if(l){return;}Object.keys(o.destinations).forEach(function(n){j[n+".destinaton"]._values=b;j[n+".destinaton"]._loading=false;this._settingsModel.checkUpdate(true);}.bind(this));}.bind(this)).catch(function(e){Object.keys(o.destinations).forEach(function(n){j[n+".destinaton"]._loading=false;this._settingsModel.checkUpdate(true);}.bind(this));v.error("Can not get destinations list from '"+k.getId()+"'.");}.bind(this));}}};g1.prototype._getManifestDefaultValue=function(s){return this._oInitialManifestModel.getProperty(s);};g1.prototype._getManifestBeforelValue=function(s){return this._beforeManifestModel.getProperty(s);};g1.prototype._isValueWithHandlebarsTranslation=function(a){if(typeof a==="string"){return!!a.match(b1);}return false;};g1.prototype._isValueWithParameterSyntax=function(a){if(typeof a==="string"){return!!a.match(c1);}return false;};g1._contextEntries={empty:{label:e1.getText("EDITOR_CONTEXT_EMPTY_VAL"),type:"string",description:e1.getText("EDITOR_CONTEXT_EMPTY_DESC"),placeholder:"",value:""},"editor.internal":{label:e1.getText("EDITOR_CONTEXT_EDITOR_INTERNAL_VAL"),todayIso:{type:"string",label:e1.getText("EDITOR_CONTEXT_EDITOR_TODAY_VAL"),description:e1.getText("EDITOR_CONTEXT_EDITOR_TODAY_DESC"),tags:[],placeholder:e1.getText("EDITOR_CONTEXT_EDITOR_TODAY_VAL"),customize:["format.dataTime"],value:"{{parameters.TODAY_ISO}}"},nowIso:{type:"string",label:e1.getText("EDITOR_CONTEXT_EDITOR_NOW_VAL"),description:e1.getText("EDITOR_CONTEXT_EDITOR_NOW_DESC"),tags:[],placeholder:e1.getText("EDITOR_CONTEXT_EDITOR_NOW_VAL"),customize:["dateFormatters"],value:"{{parameters.NOW_ISO}}"},currentLanguage:{type:"string",label:e1.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),description:e1.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),tags:["technical"],customize:["languageFormatters"],placeholder:e1.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),value:"{{parameters.LOCALE}}"}}};g1._languages={};g1._appendThemeVars=function(){var a=["sapUiButtonHoverBackground","sapUiBaseBG","sapUiContentLabelColor","sapUiTileSeparatorColor","sapUiHighlight","sapUiListSelectionBackgroundColor","sapUiNegativeText","sapUiCriticalText","sapUiPositiveText","sapUiChartScrollbarBorderColor"];var m=E.get({name:a,callback:function(b){}});if(m){for(var n in m){document.body.style.setProperty("--"+n,m[n]);}}};g1.prototype.prepareFieldsInKey=function(o){this._sKeySeparator=o.values.keySeparator;if(!this._sKeySeparator){this._sKeySeparator="#";}var k=o.values.item.key;this._aFields=k.split(this._sKeySeparator);for(var n in this._aFields){if(this._aFields[n].startsWith("{")){this._aFields[n]=this._aFields[n].substring(1);}if(this._aFields[n].endsWith("}")){this._aFields[n]=this._aFields[n].substring(0,this._aFields[n].length-1);}}};g1.prototype.getKeyFromItem=function(i){var s="";this._aFields.forEach(function(a){s+=i[a].toString()+this._sKeySeparator;}.bind(this));if(s.endsWith(this._sKeySeparator)){s=s.substring(0,s.length-this._sKeySeparator.length);}return s;};g1.init=function(){this.init=function(){};g1._appendThemeVars();c.attachThemeChanged(function(){g1._appendThemeVars();});var s=sap.ui.require.toUrl("sap.ui.integration.editor.css.Editor".replace(/\./g,"/")+".css");A(s);B.loadResource("sap/ui/integration/editor/languages.json",{dataType:"json",failOnError:false,async:true}).then(function(o){g1._languages=o;});};g1.init();return g1;});
