/*!
* OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["./library","./PaneContainer","./ResponsiveSplitterPage","./ResponsiveSplitterRenderer","./ResponsiveSplitterUtilities","./SplitPane","./Splitter","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","sap/ui/core/ResizeHandler","sap/ui/core/RenderManager"],function(l,P,R,c,d,S,e,C,f,I,g,h){"use strict";var j=f.extend("sap.ui.layout.ResponsiveSplitter",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'}},defaultAggregation:"rootPaneContainer",aggregations:{rootPaneContainer:{type:"sap.ui.layout.PaneContainer",multiple:false},_pages:{type:"sap.ui.layout.ResponsiveSplitterPage",multiple:true,visibility:"hidden"}},associations:{defaultPane:{type:"sap.ui.layout.SplitPane",multiple:false}},events:{}},renderer:c});var k={MAX_VISIBLE_BUTTONS:7};j.prototype.init=function(){this._aPaneContainers=[];this._aPanes=[];this._oResourceBundle=C.getLibraryResourceBundle("sap.ui.layout");this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._iDefaultPageIndex=0;};j.prototype.onBeforeRendering=function(){var r=this.getRootPaneContainer();if(r){this._oSplitterDelegate=this._oSplitterDelegate||{onAfterRendering:function(){this._setSplitterBarsTooltips(r._oSplitter);this._updatePaginatorButtonsTooltips();}};r._oSplitter.addEventDelegate(this._oSplitterDelegate,this);this._createWidthIntervals();this._createPages();this._detachResizeHandler();}};j.prototype.onAfterRendering=function(){this._parentResizeHandler=g.register(this,this._onParentResize.bind(this));var r=this.getRootPaneContainer();if(r){this._onParentResize();this._updatePaginatorButtonsTooltips();}this._setItemNavigation();};j.prototype.exit=function(){this._detachResizeHandler();this._clearItemNavigation();this._oSplitterDelegate=null;};j.prototype._setSplitterBarsTooltips=function(o,p){var s=o.$().find(" > .sapUiLoSplitterBar"),a=o.$().find(" > .sapUiLoSplitterContent"),t="",b,n,A,m;for(var i=0;i<a.length;i++){m=a[i].childNodes[0].id;A=C.byId(m);b=i+1;n=i+2;if(p){t+=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_RESIZE",[p+"."+b,p+"."+n]);}else{t+=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_RESIZE",[b,n]);}if(s[i]){s[i].setAttribute("title",t);t="";}if(A instanceof e){this._setSplitterBarsTooltips(A,b);}}};j.prototype._updatePaginatorButtonsTooltips=function(){var v=Array.prototype.slice.call(this._getVisibleButtons()),H=this.getRootPaneContainer()._oSplitter.getAssociatedContentAreas().length,s=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_HOME")+" ",a=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_AND"),t="",b=this,o;if(v.length>0){o=v.shift();for(var i=1;i<=H;i++){s+=i;if(i<(H-1)){s+=", ";}else if(i===H-1){s+=" "+a+" ";}}o.setAttribute("title",s);[].forEach.call(v,function(B){t=b._oResourceBundle.getText("RESPONSIVE_SPLITTER_GOTO")+" "+(H+1);H+=1;B.setAttribute("title",t);});}};j.prototype.onsapright=function(E){this._handleArrowNavigation(6,"Forward",E);};j.prototype.onsapleft=function(E){this._handleArrowNavigation(0,"Back",E);};j.prototype._setItemNavigation=function(){var b=this._getVisibleButtons(),D=[];this._oItemNavigation.setRootDomRef(this.$().find(".sapUiResponsiveSplitterPaginator")[0]);for(var i=0;i<b.length;i++){if(b[i]){D.push(b[i]);}}this._oItemNavigation.setItemDomRefs(D);this._oItemNavigation.setFocusedIndex(this._iDefaultPageIndex);};j.prototype._clearItemNavigation=function(){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;};j.prototype._handleArrowNavigation=function(b,D,E){if(E.target===this._getVisibleButtons()[b]){this["_handlePaginator"+D](E);this._setItemNavigation();}else{return;}};j.prototype._onParentResize=function(){var i=this._intervalHasChanged(),r=this.getRootPaneContainer();if(i&&r){this._arrangeContent();this._setPaginatorVisibility();}};j.prototype._detachResizeHandler=function(){if(this._parentResizeHandler){g.deregister(this._parentResizeHandler);this._parentResizeHandler=null;}};j.prototype._createWidthIntervals=function(){var B=[];this._aIntervals=[];d.visitPanes(this.getRootPaneContainer(),function(p){var r=p.getRequiredParentWidth();if(B.indexOf(r)==-1){B.push(r);}});B.push(Number.NEGATIVE_INFINITY);B.push(Number.POSITIVE_INFINITY);B.sort(function(a,b){return a-b;});for(var i=0;i<B.length-1;i++){var o=new d.splitterInterval(B[i],B[i+1],this.getRootPaneContainer());this._aIntervals.push(o);}};j.prototype._createPages=function(){var m=this._getMaxPageCount(),p=this.getAggregation("_pages")||[],i=p.length;if(i<m){while(i<m){i++;var o=new R();this.addAggregation("_pages",o,true);}}else if(i>m){while(i>m){i--;if(p[i].getDomRef()){h.preserveContent(p[i].getDomRef());}p[i].destroy();}}};j.prototype._intervalHasChanged=function(){var w=this.getDomRef().clientWidth,o=null,a=this._aIntervals;for(var i=0;i<a.length;i++){if(a[i].iFrom<w&&w<=a[i].iTo){o=a[i];break;}}if(this._currentInterval!==o){this._currentInterval=o;return true;}return false;};j.prototype._setPaginatorVisibility=function(){var b=this.$().find(".sapUiResponsiveSplitterPaginatorButton"),n=this.$().find(".sapUiResponsiveSplitterPaginatorNavButton"),p=this.$().find(".sapUiResponsiveSplitterPaginator"),i=(this._getHiddenPanes().length+1),m=this._getMaxPageCount(),s=i<k.MAX_VISIBLE_BUTTONS;b.addClass("sapUiResponsiveSplitterHiddenElement");if(m>1&&i>1){this.addStyleClass("sapUiRSVisiblePaginator");b=b.slice(0,s?i:k.MAX_VISIBLE_BUTTONS);b.removeClass("sapUiResponsiveSplitterHiddenElement");b.removeClass("sapUiResponsiveSplitterHiddenPaginatorButton");n.toggleClass("sapUiResponsiveSplitterHiddenPaginatorButton",s);p.toggleClass("sapUiResponsiveSplitterWithNavButtons",!s);}else{this.removeStyleClass("sapUiRSVisiblePaginator");}};j.prototype._getMaxPageCount=function(){var t=0;this._aIntervals.forEach(function(i){if(i.iPagesCount>t){t=i.iPagesCount;}});return t;};j.prototype._arrangeContent=function(){var p=this.getAggregation("_pages")||[],D=0,o=C.byId(this.getDefaultPane()),a,s,i;this._clearContent();p.forEach(function(b){b.setVisible(false);});this._fillPageContent(this.getRootPaneContainer());if(o){a=o.getContent();if(a){s=a.getId();for(i=0;i<p.length;i++){if(p[i].containsControl(s)){D=i;break;}}}}this._iDefaultPageIndex=D;this._activatePage(D);};j.prototype._activatePage=function(p){var $=this.$().find(".sapUiResponsiveSplitterPaginatorButton"),o=this.$().find(".sapUiResponsiveSplitterPaginatorSelectedButton"),O=$.index(o),a=this.getAggregation("_pages")||[];a[O]&&a[O].setVisible(false);a[p]&&a[p].setVisible(true);o.removeClass("sapUiResponsiveSplitterPaginatorSelectedButton");$.eq(p).addClass("sapUiResponsiveSplitterPaginatorSelectedButton");o.attr("aria-checked",false);$.eq(p).attr("aria-checked",true);};j.prototype._fillPageContent=function(s){var b=s instanceof P,a=s instanceof S,o=s.getParent(),m=o instanceof P,p=this.getAggregation("_pages"),H,n,q,D,r,M;if(b&&p){this._aPaneContainers.push(s);n=this._getAllPanesInInterval(s,this._currentInterval.iFrom).length>0;q=s._oSplitter;if(m&&n){o._oSplitter.addAssociatedContentArea(q);}else if(!m){p[0].setContent(q);}s.getPanes().forEach(function(t){this._fillPageContent(t);},this);}else if(a&&p){this._assignDefault(s);this._aPanes.push(s);D=s.getDemandPane();H=this._getHiddenPanes();r=H.length;M=this._getMaxPageCount();var i;if(s._isInInterval(this._currentInterval.iFrom)){o._oSplitter.addAssociatedContentArea(s.getContent());}else if(D&&(r<M)){for(i=0;i<r;i++){p[i+1].setContent(H[i].getContent());}}else if(D&&r===M){for(i=0;i<r;i++){p[i].setContent(H[i].getContent());}}else if(this._isDefault(s)){p[0].setContent(s.getContent());}}};j.prototype._isDefault=function(p){return this.getDefaultPane()===p.getId();};j.prototype._assignDefault=function(p){var D=this.getDefaultPane();this.setDefaultPane(D||p);};j.prototype._getAllPanesInInterval=function(p,F){var a=[];function v(p){p.getPanes().forEach(function(o){if(o instanceof P){v(o);}else if(o._isInInterval(F)){a.push(o);}});return a;}return v(p,F);};j.prototype._getHiddenPanes=function(){return this._aPanes.filter(function(p){return p.getDemandPane()&&!p._isInInterval(this._currentInterval.iFrom);},this);};j.prototype._clearContent=function(){this._aPaneContainers.forEach(function(p){p._oSplitter.removeAllAssociatedContentAreas();});this._aPaneContainers=[];this._aPanes=[];};j.prototype._getVisibleButtons=function(){return this.$().find(".sapUiResponsiveSplitterPaginatorButton:not(.sapUiResponsiveSplitterHiddenElement, .sapUiResponsiveSplitterHiddenPaginatorButton)");};j.prototype._handlePaginatorButtonTap=function(E){var t=E.target,T=E.target.classList,p;if(T&&T.contains("sapUiResponsiveSplitterPaginatorButton")){p=parseInt(t.getAttribute("page-index"));this._activatePage(p);}else if(T&&T.contains("sapUiResponsiveSplitterPaginatorNavButton")){if(T.contains("sapUiResponsiveSplitterPaginatorButtonForward")){this._handlePaginatorForward(E);}else{this._handlePaginatorBack(E);}}};j.prototype._handlePaginatorForward=function(E){var v=this._getVisibleButtons(),H=this._getHiddenPanes().length,$=this.$().find(".sapUiResponsiveSplitterPaginatorButton.sapUiResponsiveSplitterHiddenElement"),p,a=$.filter(function(){p=parseInt(this.getAttribute("page-index"));return p>=k.MAX_VISIBLE_BUTTONS&&p<=H;});if(a.length>0){v.first().addClass("sapUiResponsiveSplitterHiddenElement");a.last().removeClass("sapUiResponsiveSplitterHiddenElement");}};j.prototype._handlePaginatorBack=function(E){var v=this._getVisibleButtons(),m=this._getMaxPageCount()-k.MAX_VISIBLE_BUTTONS,H=this.$().find(".sapUiResponsiveSplitterPaginatorButton.sapUiResponsiveSplitterHiddenElement"),$=H.filter(function(){return parseInt(this.getAttribute("page-index"))<m;});if($.length>0){v.last().addClass("sapUiResponsiveSplitterHiddenElement");$.last().removeClass("sapUiResponsiveSplitterHiddenElement");}};j.prototype.ontap=j.prototype._handlePaginatorButtonTap;j.prototype.onsapenter=j.prototype._handlePaginatorButtonTap;j.prototype.onsapspace=j.prototype._handlePaginatorButtonTap;return j;});
