/*
 * ! OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Control","./ActionToolbar","./table/TableSettings","./table/GridTableType","./table/ResponsiveTableType","./table/PropertyHelper","./mixin/FilterIntegrationMixin","./library","sap/m/Text","sap/m/Title","sap/m/ColumnHeaderPopover","sap/m/OverflowToolbar","sap/m/library","sap/ui/core/Core","sap/ui/core/format/NumberFormat","sap/ui/core/dnd/DragDropInfo","sap/ui/core/Item","sap/ui/core/format/ListFormat","sap/ui/events/KeyCodes","sap/ui/model/Sorter","sap/ui/dom/containsOrEquals","sap/base/strings/capitalize","sap/base/util/deepEqual","sap/base/util/Deferred","sap/ui/core/InvisibleMessage","sap/ui/core/InvisibleText","sap/ui/mdc/p13n/subcontroller/ColumnController","sap/ui/mdc/p13n/subcontroller/SortController","sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/mdc/p13n/subcontroller/GroupController","sap/ui/mdc/p13n/subcontroller/AggregateController","sap/m/ColumnPopoverSelectListItem","sap/m/ColumnPopoverActionItem","sap/ui/mdc/p13n/subcontroller/ColumnWidthController","sap/ui/mdc/actiontoolbar/ActionToolbarAction"],function(C,A,T,G,R,P,F,l,a,b,c,O,M,d,N,D,I,L,K,S,e,f,g,h,i,j,k,m,n,o,p,q,r,s,t){"use strict";var u=l.SelectionMode;var v=l.TableType;var w=l.RowAction;var x=M.ToolbarDesign;var y=M.ToolbarStyle;var z=l.MultiSelectMode;var B="sap.ui.mdc.IFilter";var E=new window.WeakMap();var H=function(d1){if(!E.has(d1)){E.set(d1,{oFilterInfoBar:null});}return E.get(d1);};function J(d1,e1){sap.ui.require(["sap/m/MessageToast"],function(f1){var g1=d.getLibraryResourceBundle("sap.ui.mdc");f1.show(g1.getText(d1,e1));});}var Q=C.extend("sap.ui.mdc.Table",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/table/Table.designtime",interfaces:["sap.ui.mdc.IFilterSource","sap.ui.mdc.IxState"],defaultAggregation:"columns",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null,invalidate:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null,invalidate:true},rowAction:{type:"sap.ui.mdc.RowAction[]",defaultValue:[]},p13nMode:{type:"sap.ui.mdc.TableP13nMode[]",defaultValue:[]},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/TableDelegate",payload:{}}},headerLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:sap.ui.core.TitleLevel.Auto},autoBindOnInit:{type:"boolean",group:"Misc",defaultValue:true},header:{type:"string",group:"Misc",defaultValue:null},headerVisible:{type:"boolean",group:"Misc",defaultValue:true},selectionMode:{type:"sap.ui.mdc.SelectionMode",defaultValue:u.None},showRowCount:{type:"boolean",group:"Misc",defaultValue:true},threshold:{type:"int",group:"Appearance",defaultValue:-1},noDataText:{type:"string"},sortConditions:{type:"object"},filterConditions:{type:"object",defaultValue:{}},groupConditions:{type:"object"},aggregateConditions:{type:"object"},enableExport:{type:"boolean",defaultValue:false},busyIndicatorDelay:{type:"int",defaultValue:100},enableColumnResize:{type:"boolean",group:"Behavior",defaultValue:true},showPasteButton:{type:"boolean",group:"Behavior",defaultValue:false},enablePaste:{type:"boolean",group:"Behavior",defaultValue:true},multiSelectMode:{type:"sap.ui.mdc.MultiSelectMode",group:"Behavior",defaultValue:z.Default},enableAutoColumnWidth:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},type:{type:"sap.ui.mdc.table.TableTypeBase",altTypes:["sap.ui.mdc.TableType"],multiple:false},columns:{type:"sap.ui.mdc.table.Column",multiple:true},creationRow:{type:"sap.ui.mdc.table.CreationRow",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_createToolbar",aggregation:"actions"}},variant:{type:"sap.ui.fl.variants.VariantManagement",multiple:false},quickFilter:{type:"sap.ui.core.Control",multiple:false},rowSettings:{type:"sap.ui.mdc.table.RowSettings",multiple:false},dataStateIndicator:{type:"sap.m.plugins.DataStateIndicator",multiple:false}},associations:{filter:{type:B,multiple:false}},events:{rowPress:{parameters:{bindingContext:{type:"sap.ui.model.Context"}}},selectionChange:{parameters:{bindingContext:{type:"sap.ui.model.Context"},selected:{type:"boolean"},selectAll:{type:"boolean"}}},beforeExport:{parameters:{exportSettings:{type:"object"},userExportSettings:{type:"object"}}},paste:{parameters:{data:{type:"string[][]"}}}}},constructor:function(){this._oTableReady=new h();this._oFullInitialize=new h();C.apply(this,arguments);this.bCreated=true;this._doOneTimeOperations();this._initializeContent();},renderer:{apiVersion:2,render:function(d1,e1){d1.openStart("div",e1);d1.class("sapUiMdcTable");d1.style("height",e1.getHeight());d1.style("width",e1.getWidth());d1.openEnd();d1.renderControl(e1.getAggregation("_content"));d1.close("div");}}});var U=["variant","quickFilter"];F.call(Q.prototype);U.forEach(function(d1){var e1=f(d1),f1="_o"+e1,g1="get"+e1,h1="set"+e1,i1="destroy"+e1;Q.prototype[g1]=function(){return this[f1];};Q.prototype[i1]=function(){var j1=this[f1];this[h1]();if(j1){j1.destroy();}return this;};Q.prototype[h1]=function(j1){this.validateAggregation(d1,j1,false);var k1=this._createToolbar(),l1=j1!==this[f1];if(!j1||l1){k1.removeBetween((this[g1]()));this[f1]=j1;}if(l1&&j1){this._setToolbarBetween(k1);}return this;};});Q.prototype.init=function(){C.prototype.init.apply(this,arguments);this._bForceRebind=true;this._updateAdaptation(this.getP13nMode());this.mSkipPropagation={rowSettings:true};};Q.prototype.applySettings=function(){C.prototype.applySettings.apply(this,arguments);this.initControlDelegate();};Q.prototype._setToolbarBetween=function(d1){[this._oVariant,this._oQuickFilter].forEach(function(e1){if(e1){d1.addBetween(e1);}});};Q.prototype.initialized=function(){return this._oTableReady.promise;};Q.prototype._fullyInitialized=function(){return this._oFullInitialize.promise;};Q.prototype.getDataStateIndicatorPluginOwner=function(d1){return this._oTable||this._oFullInitialize.promise;};Q.prototype.setDataStateIndicator=function(d1){this._handleDataStateEvents(this.getDataStateIndicator(),"detach");this.setAggregation("dataStateIndicator",d1,true);this._handleDataStateEvents(this.getDataStateIndicator(),"attach");return this;};Q.prototype._handleDataStateEvents=function(d1,e1){if(d1){d1[e1+"ApplyFilter"](this._onApplyMessageFilter,this);d1[e1+"ClearFilter"](this._onClearMessageFilter,this);d1[e1+"Event"]("filterInfoPress",c1,this);}};Q.prototype._onApplyMessageFilter=function(d1){this._oMessageFilter=d1.getParameter("filter");d1.preventDefault();this.rebind();};Q.prototype._onClearMessageFilter=function(d1){this._oMessageFilter=null;d1.preventDefault();this.rebind();};Q.prototype._getStringType=function(d1){var e1,f1=e1=d1||this.getType();if(!f1){e1=v.Table;}else if(typeof f1==="object"){if(f1.isA("sap.ui.mdc.table.ResponsiveTableType")){e1=v.ResponsiveTable;}else{e1=v.Table;}}return e1;};Q.prototype._isOfType=function(d1){return this._getStringType()===d1;};Q.prototype._updateTypeSettings=function(){var d1=this.getType();if(d1&&typeof d1==="object"){d1.updateTableSettings();}else{if(d1==="ResponsiveTable"){d1=R;}else{d1=G;}d1.updateDefault(this._oTable);}};Q.prototype.scrollToIndex=function(d1){return new Promise(function(e1,f1){if(!this._oTable){return f1();}if(typeof d1!=="number"){return f1("The iIndex parameter has to be a number");}if(this._isOfType(v.ResponsiveTable)){this._oTable.scrollToIndex(d1).then(e1).catch(f1);}else{if(d1===-1){d1=this._getRowCount(false);}if(this._oTable._setFirstVisibleRowIndex(d1)){this._oTable.attachEventOnce("rowsUpdated",function(){e1();});}else{e1();}}}.bind(this));};Q.prototype.focusRow=function(d1,e1){return this.scrollToIndex(d1).then(function(){return this._oTable._setFocus(d1,e1);}.bind(this));};Q.prototype.setType=function(d1){var e1=this._getStringType(d1);var f1=this._getStringType();this.setAggregation("type",d1,true);if(e1===f1&&this._oTable){this._updateTypeSettings();return this;}if(this.bCreated){if(this._oTable){if(f1==="ResponsiveTable"){this._oTable.setHeaderToolbar();}else{this._oTable.removeExtension(this._oToolbar);}this._oTable.destroy("KeepDom");this._oTable=null;this._bTableExists=false;}else{this._onAfterTableCreated();this._onAfterFullInitialization();}if(this._oTemplate){this._oTemplate.destroy();this._oTemplate=null;}this._oTableReady=new h();this._oFullInitialize=new h();this._bFullyInitialized=false;this._initializeContent();}return this;};Q.prototype.setRowSettings=function(d1){this.setAggregation("rowSettings",d1,true);if(this._oTable){if(this._isOfType(v.ResponsiveTable)){R.updateRowSettings(this._oTemplate,d1);}else{G.updateRowSettings(this._oTable,d1);}this._bForceRebind=true;this.checkAndRebind();}return this;};Q.prototype.setHeaderLevel=function(d1){if(this.getHeaderLevel()===d1){return this;}this.setProperty("headerLevel",d1,true);this._oTitle&&this._oTitle.setLevel(d1);return this;};Q.prototype.focus=function(d1){var e1=this.getDomRef();if(this._oTable&&e1&&!e(e1,document.activeElement)){this._oTable.focus();}};Q.prototype.setBusy=function(d1){this.setProperty('busy',d1,true);if(this._oTable){this._oTable.setBusy(d1);}return this;};Q.prototype.setBusyIndicatorDelay=function(d1){this.setProperty('busyIndicatorDelay',d1,true);if(this._oTable){this._oTable.setBusyIndicatorDelay(d1);}return this;};Q.prototype.setSelectionMode=function(d1){var e1=this.getSelectionMode();this.setProperty("selectionMode",d1,true);if(this._oTable&&e1!=this.getSelectionMode()){this._updateSelectionBehavior();}return this;};Q.prototype.setMultiSelectMode=function(d1){var e1=this.getMultiSelectMode();this.setProperty("multiSelectMode",d1,true);if(this._oTable&&e1!=this.getMultiSelectMode()){this._updateMultiSelectMode();}return this;};Q.prototype.setRowAction=function(d1){var e1=this.getRowAction();this.setProperty("rowAction",d1,true);if(!g(e1.sort(),this.getRowAction().sort())){this._updateRowAction();}return this;};Q.prototype.setCreationRow=function(d1){this.setAggregation("creationRow",d1,true);if(d1){d1.update();}return this;};Q.prototype.setEnableColumnResize=function(d1){var e1=this.getEnableColumnResize();this.setProperty("enableColumnResize",d1,true);if(this.getEnableColumnResize()!==e1){this._updateColumnResizer();this._updateAdaptation(this.getP13nMode());}return this;};Q.prototype._onModifications=function(){if(!this._oTable){return;}var d1=this.getCurrentState().xConfig;var e1=d1.aggregations&&d1.aggregations.columns;this.getColumns().forEach(function(f1,g1){var h1=e1&&e1[f1.getDataProperty()]&&e1[f1.getDataProperty()].width;var i1=this._oTable.getColumns()[g1];if(!h1&&i1.getWidth()!==f1.getWidth()){i1.setWidth(f1.getWidth());}else if(h1&&h1!==i1.getWidth()){i1.setWidth(h1);}},this);};Q.prototype.setP13nMode=function(d1){var e1=this.getP13nMode();var f1=null;if(d1&&d1.length>1){f1=[];var g1=d1.reduce(function(h1,i1,j1){h1[i1]=true;return h1;},{});if(g1.Column){f1.push("Column");}if(g1.Sort){f1.push("Sort");}if(g1.Filter){f1.push("Filter");}if(g1.Group){f1.push("Group");}if(g1.Aggregate){f1.push("Aggregate");}}else{f1=d1;}this.setProperty("p13nMode",f1,true);this._updateAdaptation(this.getP13nMode());if(!g(e1.sort(),this.getP13nMode().sort())){V(this);}return this;};Q.prototype._updateAdaptation=function(d1){var e1={controller:{}};var f1={Column:k,Sort:m,Group:o,Filter:n,Aggregate:p,ColumnWidth:s};d1.forEach(function(g1){var h1=g1;e1.controller[h1]=f1[g1];});if(this.getEnableColumnResize()){e1.controller["ColumnWidth"]=f1["ColumnWidth"];}this.getEngine().registerAdaptation(this,e1);};function V(d1){if(d1._oToolbar){d1._oToolbar.destroyEnd();d1._getP13nButtons().forEach(function(f1){d1._oToolbar.addEnd(f1);});}if(d1._oTable){var e1=d1._oTable.getDragDropConfig()[0];if(e1){e1.setEnabled(d1.getP13nMode().indexOf("Column")>-1);}}if(d1.isFilteringEnabled()){X(d1);}W(d1);}Q.prototype.setFilterConditions=function(d1){this.setProperty("filterConditions",d1,true);var e1=this.getInbuiltFilter();if(e1){e1.setFilterConditions(d1);}W(this);return this;};function W(d1){var e1=Z(d1);var f1=$(d1);var g1=_(d1);if(!e1){return;}if(g1.length===0||!d1.isFilteringEnabled()){var h1=e1.getDomRef();if(h1&&h1.contains(document.activeElement)){d1.focus();}e1.setVisible(false);d1._oTable.removeAriaLabelledBy(f1);return;}d1._fullyInitialized().then(function(){var i1=g1.map(function(m1){return d1.getPropertyHelper().getLabel(m1);});var j1=d.getLibraryResourceBundle("sap.ui.mdc");var k1=L.getInstance();var l1=j1.getText("table.FILTER_INFO",k1.format(i1));if(!e1.getVisible()){e1.setVisible(true);d1._oTable.addAriaLabelledBy(f1);}f1.setText(l1);});}function X(d1){if(!d1._oTable){return;}var e1=Z(d1);if(!e1){e1=Y(d1);}if(d1._bMobileTable){if(d1._oTable.getInfoToolbar()!==e1){d1._oTable.setInfoToolbar(e1);}}else if(d1._oTable.indexOfExtension(e1)===-1){d1._oTable.insertExtension(e1,1);}if(e1.getVisible()){d1._oTable.addAriaLabelledBy($(d1));}}function Y(d1){var e1=d1.getId()+"-filterInfoBar";var f1=H(d1).oFilterInfoBar;if(f1&&!f1.bIsDestroyed){f1.destroy();}f1=new O({id:e1,active:true,design:x.Info,visible:false,content:[new a({id:e1+"-text",wrapping:false})],press:[c1,d1]});f1.focus=function(){if(this.getDomRef()){O.prototype.focus.apply(this,arguments);}else{d1.focus();}};H(d1).oFilterInfoBar=f1;W(d1);return f1;}function Z(d1){var e1=H(d1).oFilterInfoBar;if(e1&&(e1.bIsDestroyed||e1.bIsBeingDestroyed)){return null;}return H(d1).oFilterInfoBar;}function $(d1){var e1=Z(d1);return e1?e1.getContent()[0]:null;}Q.prototype.setThreshold=function(d1){this.setProperty("threshold",d1,true);if(!this._oTable){return this;}d1=this.getThreshold()>-1?this.getThreshold():undefined;if(this._bMobileTable){this._oTable.setGrowingThreshold(d1);}else{this._oTable.setThreshold(d1);}return this;};Q.prototype._onFilterProvided=function(d1){this._updateInnerTableNoDataText();};Q.prototype._onFilterRemoved=function(d1){this._updateInnerTableNoDataText();};Q.prototype._onFiltersChanged=function(d1){if(this.isTableBound()&&d1.getParameter("conditionsBased")){this._oTable.setShowOverlay(true);}};Q.prototype._onFilterSearch=function(d1){this._bIgnoreChange=true;this._bAnnounceTableUpdate=true;};Q.prototype.setNoDataText=function(d1){this.setProperty("noDataText",d1,true);this._updateInnerTableNoDataText();return this;};Q.prototype._updateInnerTableNoDataText=function(){if(!this._oTable){return;}var d1=this._getNoDataText();if(this._bMobileTable){this._oTable.setNoDataText(d1);}else{this._oTable.setNoData(d1);}};Q.prototype._getNoDataText=function(){var d1=this.getNoDataText();if(d1){return d1;}var e1=d.getLibraryResourceBundle("sap.ui.mdc");if(!this.isTableBound()){if(this.getFilter()){return e1.getText("table.NO_DATA_WITH_FILTERBAR");}return e1.getText("table.NO_DATA");}return e1.getText("table.NO_RESULTS");};Q.prototype._updateRowAction=function(){if(!this._oTable){return;}var d1=this.getRowAction().indexOf(w.Navigation)>-1;var e1=this._bMobileTable?R:G;e1.updateRowAction(this,d1,this._bMobileTable?undefined:this._onRowActionPress);};Q.prototype._initializeContent=function(){var d1,e1=this._getStringType();if(this._isOfType(v.ResponsiveTable)){d1=R;}else{d1=G;}var f1=[this.awaitControlDelegate(),d1.loadTableModules()];if(this.isFilteringEnabled()){f1.push(this.retrieveInbuiltFilter());}Promise.all(f1).then(function(){if(this.bIsDestroyed){return;}var g1=this.getControlDelegate();if(g1.preInit){this._pDelegatePreInit=g1.preInit(this);}if(!this._bTableExists&&e1===this._getStringType()){this._bMobileTable=e1==="ResponsiveTable";this._createContent();this._bTableExists=true;}}.bind(this)).catch(function(g1){this._onAfterTableCreated();throw g1;}.bind(this));};Q.prototype._doOneTimeOperations=function(){if(!this.bColumnsOrdered){this.bColumnsOrdered=true;this._orderColumns();}};Q.prototype._onAfterTableCreated=function(d1){this._oTableReady[d1?"resolve":"reject"](this);};Q.prototype._onAfterFullInitialization=function(d1){this._oFullInitialize[d1?"resolve":"reject"](this);};Q.prototype._createContent=function(){this._createToolbar();this._createTable();this._updateColumnResizer();this._updateRowAction();this.getColumns().forEach(this._insertInnerColumn,this);this.setAggregation("_content",this._oTable);this._onAfterTableCreated(true);var d1=this.initialized().then(function(){this.initPropertyHelper(P);var e1=this.getCreationRow();if(e1){e1.update();}if(this.getAutoBindOnInit()){this.checkAndRebind();}return this.awaitPropertyHelper();}.bind(this));Promise.all([d1,this._pDelegatePreInit]).then(function(){delete this._pDelegatePreInit;this._bFullyInitialized=true;this._onAfterFullInitialization(true);}.bind(this)).catch(function(e1){this._onAfterFullInitialization();throw e1;}.bind(this));};Q.prototype.setHeader=function(d1){this.setProperty("header",d1,true);this._updateHeaderText();this._updateExportState(true);return this;};Q.prototype.setHeaderVisible=function(d1){this.setProperty("headerVisible",d1,true);if(this._oTitle){this._oTitle.setWidth(this.getHeaderVisible()?undefined:"0px");}return this;};Q.prototype.setShowRowCount=function(d1){this.setProperty("showRowCount",d1,true);this._updateHeaderText();return this;};Q.prototype.setEnableExport=function(d1){if(d1!==this.getEnableExport()){this.setProperty("enableExport",d1,true);if(d1&&!this._oExportButton&&this._oToolbar){this._oToolbar.addEnd(this._getExportButton());}else if(this._oExportButton){this._oExportButton.setVisible(d1);}}return this;};Q.prototype.setShowPasteButton=function(d1){if((d1=!!d1)==this.getShowPasteButton()){return this;}this.setProperty("showPasteButton",d1,true);if(d1&&!this._oPasteButton&&this._oToolbar){this._oToolbar.insertEnd(this._getPasteButton(),0);this._oPasteButton.setEnabled(this.getEnablePaste());}else if(this._oPasteButton){this._oPasteButton.setVisible(d1);this._oPasteButton.setEnabled(this.getEnablePaste());}return this;};Q.prototype.setEnablePaste=function(d1){this.setProperty("enablePaste",d1,true);if(this._oPasteButton){this._oPasteButton.setEnabled(this.getEnablePaste());}return this;};Q.prototype._createToolbar=function(){if(this.isDestroyStarted()||this.isDestroyed()){return;}if(!this._oToolbar){this._oTitle=new b(this.getId()+"-title",{text:this.getHeader(),width:this.getHeaderVisible()?undefined:"0px",level:this.getHeaderLevel()});this._oToolbar=new A(this.getId()+"-toolbar",{design:x.Transparent,style:this._isOfType(v.ResponsiveTable)?y.Standard:y.Clear,begin:[this._oTitle],end:[this._getPasteButton(),this._getP13nButtons(),this._getExportButton()]});}return this._oToolbar;};Q.prototype._getVisibleProperties=function(){var d1=[],e1;this.getColumns().forEach(function(f1,g1){e1=f1&&f1.getDataProperty();if(e1){d1.push({name:e1});}});return d1;};Q.prototype.getConditions=function(){return this.getInbuiltFilter()?this.getInbuiltFilter().getConditions():[];};Q.prototype._getSortedProperties=function(){return this.getSortConditions()?this.getSortConditions().sorters:[];};Q.prototype._getGroupedProperties=function(){return this.getGroupConditions()?this.getGroupConditions().groupLevels:[];};Q.prototype._getAggregatedProperties=function(){return this.getAggregateConditions()?this.getAggregateConditions():{};};Q.prototype._getXConfig=function(){return this.getEngine().readXConfig(this);};function _(d1){var e1=d1.getFilterConditions();return Object.keys(e1).filter(function(f1){return e1[f1].length>0;});}Q.prototype.getCurrentState=function(){var d1={};var e1=this.getP13nMode();if(e1.indexOf("Column")>-1){d1.items=this._getVisibleProperties();}if(this.isSortingEnabled()){d1.sorters=this._getSortedProperties();}if(this.isFilteringEnabled()){d1.filter=this.getFilterConditions();}if(this.isGroupingEnabled()){d1.groupLevels=this._getGroupedProperties();}if(this.isAggregationEnabled()){d1.aggregations=this._getAggregatedProperties();}if(this.getEnableColumnResize()){d1.xConfig=this._getXConfig();}return d1;};Q.prototype.isFilteringEnabled=function(){return this.getP13nMode().indexOf("Filter")>-1;};Q.prototype.isSortingEnabled=function(){return this.getP13nMode().indexOf("Sort")>-1;};Q.prototype.isGroupingEnabled=function(){return this.getP13nMode().indexOf("Group")>-1;};Q.prototype.isAggregationEnabled=function(){return this.getP13nMode().indexOf("Aggregate")>-1;};Q.prototype._getP13nButtons=function(){var d1=this.getP13nMode();var e1=[];var f1=d1.length===1&&d1[0]==="Aggregate";if(d1.length>0&&!f1){e1.push(T.createSettingsButton(this.getId(),[b1,this]));}return e1;};Q.prototype._getPasteButton=function(){if(this.getShowPasteButton()){if(!this._oPasteButton){this._oPasteButton=T.createPasteButton(this.getId());}return this._oPasteButton;}};Q.prototype._getExportButton=function(){if(!this.getEnableExport()){return null;}var d1={fileName:this.getHeader()};if(!this._cachedExportSettings){this._cachedExportSettings=d1;}if(!this._oExportButton){this._oExportButton=T.createExportButton(this.getId(),{"default":[function(){this._onExport(d1);},this],"exportAs":[this._onExportAs,this]});}this._updateExportState();return this._oExportButton;};Q.prototype._updateExportState=function(d1){if(this._oExportButton){this._oExportButton.setEnabled(this._getRowCount(false)>0);if(d1&&this._cachedExportSettings){this._cachedExportSettings.fileName=this.getHeader();}}};Q.prototype._createExportColumnConfiguration=function(d1){var e1=d1&&d1.splitCells;var f1=this.getColumns();return this._fullyInitialized().then(function(){var g1=this.getPropertyHelper();var h1=[];f1.forEach(function(i1){var j1=g1.getColumnExportSettings(i1,e1);h1=h1.concat(j1);},this);return[h1,g1];}.bind(this));};Q.prototype._onExport=function(d1){var e1=this;return this._createExportColumnConfiguration(d1).then(function(f1){var g1=f1[0];var h1=f1[1];if(!g1||!g1.length){sap.ui.require(["sap/m/MessageBox"],function(k1){k1.error(d.getLibraryResourceBundle("sap.ui.mdc").getText("table.NO_COLS_EXPORT"),{styleClass:(this.$()&&this.$().closest(".sapUiSizeCompact").length)?"sapUiSizeCompact":""});}.bind(e1));return;}var i1=e1._getRowBinding();var j1={workbook:{columns:g1},dataSource:i1,fileType:d1.selectedFileType=="pdf"?"PDF":"XLSX",fileName:d1?d1.fileName:e1.getHeader()};e1._loadExportLibrary().then(function(){sap.ui.require(["sap/ui/export/ExportUtils"],function(k1){var l1=Promise.resolve();if(d1.includeFilterSettings){l1=k1.parseFilterConfiguration(i1,function(m1){return h1.getLabel(m1);}).then(function(m1){if(m1){j1.workbook.context={metaSheetName:m1.name,metainfo:[m1]};}});}l1.then(function(){var m1={splitCells:false,includeFilterSettings:false};if(d1){m1.splitCells=d1.splitCells;m1.includeFilterSettings=d1.includeFilterSettings;}k1.getExportInstance(j1).then(function(n1){n1.attachBeforeExport(function(o1){var p1=o1.getParameter("exportSettings");e1.fireBeforeExport({exportSettings:p1,userExportSettings:m1});},e1);n1.build().finally(function(){n1.destroy();});});});});});});};Q.prototype._onExportAs=function(d1){var e1=this;this._loadExportLibrary().then(function(){sap.ui.require(['sap/ui/export/ExportUtils'],function(f1){var g1=new URL(window.location.href).search.indexOf("sap-ui-xx-enablePDFExport=true");f1.getExportSettingsViaDialog(e1._cachedExportSettings,e1,undefined,g1).then(function(h1){e1._cachedExportSettings=h1;e1._onExport(h1);});});});};Q.prototype._loadExportLibrary=function(){if(!this._oExportLibLoadPromise){this._oExportLibLoadPromise=d.loadLibrary("sap.ui.export",true);}return this._oExportLibLoadPromise;};Q.prototype.onkeydown=function(d1){if(d1.isMarked()){return;}if((d1.metaKey||d1.ctrlKey)&&d1.shiftKey&&d1.which===K.E){if(this.getEnableExport()&&this._oExportButton&&this._oExportButton.getEnabled()){this._onExportAs();d1.setMarked();d1.preventDefault();}}if((d1.metaKey||d1.ctrlKey)&&d1.which===K.COMMA){var e1=d.byId(this.getId()+"-settings");if(e1&&e1.getEnabled()&&e1.getVisible()){e1.firePress();d1.setMarked();d1.preventDefault();}}};Q.prototype._createTable=function(){var d1=this.getThreshold()>-1?this.getThreshold():undefined;var e1=this.getRowSettings()?this.getRowSettings().getAllSettings():{};if(this._bMobileTable){this._oTable=R.createTable(this.getId()+"-innerTable",{autoPopinMode:true,contextualWidth:"Auto",growing:true,sticky:["ColumnHeaders","HeaderToolbar","InfoToolbar"],itemPress:[this._onItemPress,this],selectionChange:[this._onSelectionChange,this],growingThreshold:d1,noDataText:this._getNoDataText(),headerToolbar:this._oToolbar,ariaLabelledBy:[this._oTitle]});this._oTemplate=R.createTemplate(this.getId()+"-innerTableRow",e1);this._createColumn=Q.prototype._createMobileColumn;this._sAggregation="items";this._oTable.bindRows=this._oTable.bindItems;this._oTable.bActiveHeaders=true;this._oTable.attachEvent("columnPress",this._onResponsiveTableColumnPress,this);}else{this._oTable=G.createTable(this.getId()+"-innerTable",{enableBusyIndicator:true,enableColumnReordering:false,threshold:d1,cellClick:[this._onCellClick,this],noData:this._getNoDataText(),extension:[this._oToolbar],ariaLabelledBy:[this._oTitle],plugins:[G.createMultiSelectionPlugin(this,[this._onRowSelectionChange,this])],columnSelect:[this._onGridTableColumnPress,this],rowSettingsTemplate:e1});this._createColumn=Q.prototype._createColumn;this._sAggregation="rows";}this._updateTypeSettings();this._updateSelectionBehavior();this._updateMultiSelectMode();var f1=new D({sourceAggregation:"columns",targetAggregation:"columns",dropPosition:"Between",enabled:this.getP13nMode().indexOf("Column")>-1,drop:[this._onColumnRearrange,this]});f1.bIgnoreMetadataCheck=true;this._oTable.addDragDropConfig(f1);this._oTable.setBusyIndicatorDelay(this.getBusyIndicatorDelay());this._oTable.attachPaste(this._onInnerTablePaste,this);if(this.isFilteringEnabled()){X(this);}};Q.prototype._updateColumnResizer=function(){if(!this._oTable){return;}var d1=this.getEnableColumnResize();var e1=this._bMobileTable?R:G;if(d1){e1.enableColumnResizer(this,this._oTable);}else{e1.disableColumnResizer(this,this._oTable);}var f1=this.getColumns();f1.forEach(function(g1){g1.updateColumnResizing(d1);},this);};Q.prototype._updateSelectionBehavior=function(){var d1=this._bMobileTable?R:G;d1.updateSelection(this);};Q.prototype._updateMultiSelectMode=function(){if(this._bMobileTable){R.updateMultiSelectMode(this);}};Q.prototype._onColumnRearrange=function(d1){var e1=d1.getParameter("draggedControl");var f1=d1.getParameter("droppedControl");if(e1===f1){return;}var g1=d1.getParameter("dropPosition");var h1=this._oTable.indexOfColumn(e1);var i1=this._oTable.indexOfColumn(f1);var j1=i1+(g1=="Before"?0:1)+(h1<i1?-1:0);T.moveColumn(this,h1,j1);};Q.prototype._onColumnPress=function(d1){if(this._bSuppressOpenMenu){return;}var e1=d1.getParent(),f1=e1.indexOfColumn(d1),g1=this.getColumns()[f1],h1=this._bMobileTable&&this.getEnableColumnResize();this._fullyInitialized().then(function(){var i1=d.getLibraryResourceBundle("sap.ui.mdc");if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}if(this.isSortingEnabled()){var j1=[],k1=[];this.getPropertyHelper().getSortableProperties(g1.getDataProperty()).forEach(function(q1){j1.push(new I({text:q1.getLabel(),key:q1.getName()}));k1.push(new I({text:q1.getLabel(),key:q1.getName()}));});if(j1.length>0){this._oPopover=new c({items:[new q({items:j1,label:i1.getText("table.SETTINGS_ASCENDING"),icon:"sap-icon://sort-ascending",action:[false,this._onCustomSort,this]}),new q({items:k1,label:i1.getText("table.SETTINGS_DESCENDING"),icon:"sap-icon://sort-descending",action:[true,this._onCustomSort,this]})]});d1.addDependent(this._oPopover);}}var l1=[];var m1=[];var n1=this.getControlDelegate();l1=(n1.addColumnMenuItems&&n1.addColumnMenuItems(this,g1))||[];this.getPropertyHelper().getFilterableProperties(g1.getDataProperty()).forEach(function(q1){m1.push(new I({text:q1.getLabel(),key:q1.getName()}));});if(this.isFilteringEnabled()&&m1.length){var o1=new q({label:i1.getText("table.SETTINGS_FILTER"),icon:"sap-icon://filter",action:[c1,this]});l1.unshift(o1);}if(h1){var p1=R.startColumnResize(this._oTable,d1);p1&&l1.push(p1);}l1.forEach(function(q1){this._createPopover(q1,d1);},this);if(this._oPopover){this._oPopover.openBy(d1);this._oPopover.getAggregation("_popover").attachAfterClose(function(){this._bSuppressOpenMenu=false;},this);this._bSuppressOpenMenu=true;}}.bind(this));};Q.prototype._createPopover=function(d1,e1){if(this._oPopover){this._oPopover.addItem(d1);}else{this._oPopover=new c({items:d1});e1.addDependent(this._oPopover);}};Q.prototype._onCustomSort=function(d1,e1){var f1=d1.getParameter("property");T.createSort(this,f1,e1,true);};Q.prototype._onColumnResize=function(d1){var e1=d1.getParameter("column");var f1=d1.getParameter("width");var g1=this._oTable.indexOfColumn(e1);var h1=this.getColumns()[g1];var i1=h1.getDataProperty();T.createColumnWidth(this,i1,f1);};Q.prototype._onCustomGroup=function(d1){T.createGroup(this,d1);};Q.prototype._onCustomAggregate=function(d1){T.createAggregation(this,d1);};Q.prototype._setColumnWidth=function(d1){if(!this.getEnableAutoColumnWidth()||d1.getWidth()||d1.isBound("width")){return;}var e1=this._oPropertyHelper;if(e1){e1.setColumnWidth(d1);}else{this.awaitPropertyHelper().then(this._setColumnWidth.bind(this,d1));}};Q.prototype._insertInnerColumn=function(d1,e1){if(!this._oTable){return;}this._setColumnWidth(d1);var f1=this._createColumn(d1);a1(this,d1,f1,e1);this._bForceRebind=true;if(e1===undefined){this._oTable.addColumn(f1);}else{this._oTable.insertColumn(f1,e1);}};Q.prototype._orderColumns=function(){var d1,e1=[],f1=this.getColumns();f1.forEach(function(g1){d1=g1.getInitialIndex();if(d1>-1){e1.push({index:d1,column:this.removeColumn(g1)});}},this);e1.sort(function(g1,h1){return g1-h1;});e1.forEach(function(g1){this.insertColumn(g1.column,g1.index);},this);};function a1(d1,e1,f1,g1){var h1=e1.getTemplate(true);if(!d1._bMobileTable){var i1=e1.getCreationTemplate(true);[h1,i1].forEach(function(j1){if(!j1){return;}if(j1.setWrapping){j1.setWrapping(false);}if(j1.setRenderWhitespace){j1.setRenderWhitespace(false);}});f1.setTemplate(h1);f1.setCreationTemplate(i1);}else if(g1>=0){d1._oTemplate.insertCell(h1,g1);d1._oTable.getItems().forEach(function(j1){j1.insertAggregation("cells",new j(),g1,true);});}else{d1._oTemplate.addCell(h1);}}Q.prototype._createColumn=function(d1){return G.createColumn(d1.getId()+"-innerColumn",{width:d1.getWidth(),minWidth:Math.round(d1.getMinWidth()*parseFloat(M.BaseFontSize)),hAlign:d1.getHAlign(),label:d1.getColumnHeaderControl(this._bMobileTable,this.getEnableColumnResize()),resizable:this.getEnableColumnResize(),autoResizable:this.getEnableColumnResize()});};Q.prototype._createMobileColumn=function(d1){return R.createColumn(d1.getId()+"-innerColumn",{width:d1.getWidth(),autoPopinWidth:d1.getMinWidth(),hAlign:d1.getHAlign(),header:d1.getColumnHeaderControl(this._bMobileTable,this.getEnableColumnResize()),importance:d1.getImportance(),popinDisplay:"Inline"});};Q.prototype.moveColumn=function(d1,e1){var f1;this.removeAggregation("columns",d1,true);this.insertAggregation("columns",d1,e1,true);if(this._oTable){f1=this._oTable.removeColumn(d1.getId()+"-innerColumn");this._oTable.insertColumn(f1,e1);if(this._bMobileTable){this._updateColumnTemplate(d1,e1);}}};Q.prototype.removeColumn=function(d1){d1=this.removeAggregation("columns",d1,true);if(this._oTable){var e1=this._oTable.removeColumn(d1.getId()+"-innerColumn");e1.destroy("KeepDom");if(this._bMobileTable){this._updateColumnTemplate(d1,-1);}this._onModifications();}return d1;};Q.prototype.addColumn=function(d1){this.addAggregation("columns",d1,true);this._insertInnerColumn(d1);return this;};Q.prototype.insertColumn=function(d1,e1){this.insertAggregation("columns",d1,e1,true);this._insertInnerColumn(d1,e1);this._onModifications();return this;};Q.prototype._updateColumnTemplate=function(d1,e1){var f1,g1;if(this._oTemplate){f1=d1.getTemplate(true);g1=this._oTemplate.indexOfCell(f1);Q._removeItemCell(this._oTemplate,g1,e1);}if(g1>-1){this._oTable.getItems().forEach(function(h1){if(h1.removeCell){Q._removeItemCell(h1,g1,e1);}});}};Q._removeItemCell=function(d1,e1,f1){var g1=d1.removeCell(e1);if(g1){if(f1>-1){d1.insertCell(g1,f1);}else{g1.destroy();}}};Q.prototype._onItemPress=function(d1){this.fireRowPress({bindingContext:d1.getParameter("listItem").getBindingContext()});};Q.prototype._onSelectionChange=function(d1){var e1=d1.getParameter("selectAll");this.fireSelectionChange({bindingContext:d1.getParameter("listItem").getBindingContext(),selected:d1.getParameter("selected"),selectAll:e1});if(e1){var f1=this.getRowBinding();if(f1&&this._oTable){var g1=f1.getLength();var h1=this._oTable.getItems().length;var i1=f1.isLengthFinal();if(h1!=g1||!i1){J("table.SELECTION_LIMIT_MESSAGE",[h1]);}}}};Q.prototype._onResponsiveTableColumnPress=function(d1){this._onColumnPress(d1.getParameter("column"));};Q.prototype._onCellClick=function(d1){this.fireRowPress({bindingContext:d1.getParameter("rowBindingContext")});};Q.prototype._onRowActionPress=function(d1){var e1=d1.getParameter("row");this.fireRowPress({bindingContext:e1.getBindingContext()});};Q.prototype._onRowSelectionChange=function(d1){if(!this._bSelectionChangedByAPI){this.fireSelectionChange({bindingContext:d1.getParameter("rowContext"),selected:d1.getSource().isIndexSelected(d1.getParameter("rowIndex")),selectAll:d1.getParameter("selectAll")});}};Q.prototype._onGridTableColumnPress=function(d1){d1.preventDefault();this._onColumnPress(d1.getParameter("column"));};Q.prototype.getSelectedContexts=function(){if(this._oTable){if(this._bMobileTable){return this._oTable.getSelectedContexts();}var d1=this._oTable.getPlugins()[0].getSelectedIndices();return d1.map(function(e1){return this._oTable.getContextByIndex(e1);},this);}return[];};Q.prototype.clearSelection=function(){if(this._oTable){if(this._bMobileTable){this._oTable.removeSelections(true);}else{this._bSelectionChangedByAPI=true;this._oTable.getPlugins()[0].clearSelection();this._bSelectionChangedByAPI=false;}}};Q.prototype._registerInnerFilter=function(d1){d1.attachSearch(function(){this.rebind();},this);};Q.prototype.isTableBound=function(){return this._oTable?this._oTable.isBound(this._bMobileTable?"items":"rows"):false;};Q.prototype.bindRows=function(){if(!this.bDelegateInitialized||!this._oTable){return;}var d1={};this.getControlDelegate().updateBindingInfo(this,this.getPayload(),d1);if(d1.path){this._oTable.setShowOverlay(false);if(this._bMobileTable&&this._oTemplate){d1.template=this._oTemplate;}else{delete d1.template;}Q._addBindingListener(d1,"dataRequested",this._onDataRequested.bind(this));Q._addBindingListener(d1,"dataReceived",this._onDataReceived.bind(this));Q._addBindingListener(d1,"change",this._onBindingChange.bind(this));this._updateColumnsBeforeBinding(d1);this.getControlDelegate().updateBinding(this,d1,this._bForceRebind?null:this.getRowBinding());this._updateInnerTableNoDataText();this._bForceRebind=false;}};Q.prototype._onDataRequested=function(){this._bIgnoreChange=true;};Q.prototype._onDataReceived=function(){this._bIgnoreChange=false;this._updateHeaderText();this._updateExportState();};Q.prototype._onBindingChange=function(){if(this._bIgnoreChange){return;}this._updateHeaderText();};Q.prototype._updateHeaderText=function(){var d1,e1;if(!this._oNumberFormatInstance){this._oNumberFormatInstance=N.getFloatInstance();}if(this._oTitle&&this.getHeader()){d1=this.getHeader();if(this.getShowRowCount()){e1=this._getRowCount(true);if(e1>0){var f1=this._oNumberFormatInstance.format(e1);d1+=" ("+f1+")";}}this._oTitle.setText(d1);}if(!this._bIgnoreChange&&this._bAnnounceTableUpdate){this._bAnnounceTableUpdate=false;this._announceTableUpdate(e1);}};Q.prototype._announceTableUpdate=function(d1){var e1=i.getInstance();if(e1){var f1=d.getLibraryResourceBundle("sap.ui.mdc");var g1=this.getHeader();if(d1===undefined&&this._getRowCount(false)>0){e1.announce(f1.getText("table.ANNOUNCEMENT_TABLE_UPDATED",[g1]));}else if(d1>1){e1.announce(f1.getText("table.ANNOUNCEMENT_TABLE_UPDATED_MULT",[g1,d1]));}else if(d1===1){e1.announce(f1.getText("table.ANNOUNCEMENT_TABLE_UPDATED_SING",[g1,d1]));}else{e1.announce(f1.getText("table.ANNOUNCEMENT_TABLE_UPDATED_NOITEMS",[g1]));}}};Q.prototype._updateColumnsBeforeBinding=function(d1){var e1=[].concat(d1.sorter||[]);var f1=this.getColumns();var g1=this._bMobileTable;var h1=this.getPropertyHelper();f1.forEach(function(i1){var j1=d.byId(i1.getId()+"-innerColumn");var k1=h1.getSortableProperties(i1.getDataProperty()).map(function(n1){return n1.getPath();});if(k1.length>0){var l1=e1.find(function(l1){return k1.indexOf(l1.sPath)>-1;});var m1=l1&&l1.bDescending?"Descending":"Ascending";if(g1){j1.setSortIndicator(l1?m1:"None");}else{j1.setSorted(!!l1).setSortOrder(m1);}}});};Q.prototype._getRowCount=function(d1){var e1=this._getRowBinding();if(!e1){return d1?undefined:0;}var f1;if(!d1){f1=e1.getLength();}else{if(typeof e1.getCount==='function'){f1=e1.getCount();}else if(e1.isLengthFinal()){f1=e1.getLength();}}if(f1<0||f1==="0"){f1=0;}return f1;};Q.prototype.getRowBinding=function(){return this._getRowBinding();};Q.prototype._getRowBinding=function(){if(this._oTable){return this._oTable.getBinding(this._sAggregation);}};Q._addBindingListener=function(d1,e1,f1){if(!d1.events){d1.events={};}if(!d1.events[e1]){d1.events[e1]=f1;}else{var g1=d1.events[e1];d1.events[e1]=function(){f1.apply(this,arguments);g1.apply(this,arguments);};}};Q.prototype.rebindTable=function(){this.rebind();};Q.prototype.rebind=function(){if(this._bFullyInitialized){this.bindRows();}else{this._fullyInitialized().then(this.rebind.bind(this));}};function b1(d1){T.showPanel(this,"Columns",d1.getSource());}function c1(d1){T.showPanel(this,"Filter",d1.getSource());}Q.prototype._getSorters=function(){var d1=this.getSortConditions()?this.getSortConditions().sorters:[];var e1=[],f1=this.getPropertyHelper();d1.forEach(function(g1){var h1=f1.getPath(g1.name);e1.push(new S(h1,g1.descending));});return e1;};Q.prototype._onInnerTablePaste=function(d1){if(!this.getEnablePaste()){return;}this.firePaste({data:d1.getParameter("data")});};Q.prototype.exit=function(){if(this._oTemplate){this._oTemplate.destroy();}this._oTemplate=null;this._oTable=null;if(this._oToolbar&&!this._bTableExists){this._oToolbar.destroy();}this._oToolbar=null;this._oTitle=null;this._oNumberFormatInstance=null;U.forEach(function(d1){var e1=f(d1),f1="_o"+e1;this[f1]=null;},this);this._oTableReady=null;this._oFullInitialize=null;this._oPasteButton=null;C.prototype.exit.apply(this,arguments);};Q.prototype.addAction=function(d1){if(d1.getMetadata().getName()!=="sap.ui.mdc.actiontoolbar.ActionToolbarAction"){d1=new t(d1.getId()+"-action",{action:d1});}return C.prototype.addAggregation.apply(this,["actions",d1]);};return Q;});
