/*
 * ! OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define([
    "sap/ui/core/Control",
    "sap/ui/mdc/actiontoolbar/ActionToolbarActionRenderer",
    "sap/ui/mdc/enum/ActionToolbarActionAlignment"
], function(Control, ActionToolbarActionRenderer, ActionToolbarActionAlignment) {
    "use strict";

	/**
	 * Constructor for a new ActionToolbarAction.<br>
	 * <b>Note:</b><br>
	 * The control is experimental and the API / behavior is not finalized. It should only be used internally in other mdc controls (e.g.
	 * chart/table).<br>
	 *
	 * @param {string} [sId] ID for the new control, generated automatically if no ID is given
	 * @param {object} [mSettings] Initial settings for the new control
	 * @class The action for an {@link sap.ui.mdc.ActionToolbar ActionToolbar}) control
	 * @extends sap.ui.core.Control
	 * @author SAP SE
	 * @version 1.96.3
	 * @constructor
	 * @private
	 * @since 1.58
	 * @experimental As of version 1.58
	 * @ui5-restricted sap.ui.mdc
	 * @alias sap.ui.mdc.actiontoolbar.ActionToolbarAction
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
    var ActionToolbarAction = Control.extend("sap.ui.mdc.actiontoolbar.ActionToolbarAction", {
        metadata: {
            library: "sap.ui.mdc",
            interfaces : [
				"sap.m.IOverflowToolbarContent"
			],
            properties: {
                /**
                 * Layout information
                 */
                layoutInformation: {
                    type: "object",
                    defaultValue: {
                        // available aggragation names: "beginning", "between", "end"
                        aggregationName: "end",
                        alignment: ActionToolbarActionAlignment.Begin
                    }
                }
            },
            defaultAggregation: "action",
            aggregations: {
                /**
                 * Action
                 */
                action: {
                    type: "sap.ui.core.Control",
					multiple: false
                }
            },
            renderer: ActionToolbarActionRenderer
        }
    });

    /**
	 * Sets the behavior of the <code>ActionToolbarAction</code> inside an <code>OverflowToolbar</code> configuration.
	 *
	 * @public
	 * @returns {object} Configuration information for the <code>sap.m.IOverflowToolbarContent</code> interface.
	 */
    ActionToolbarAction.prototype.getOverflowToolbarConfig = function() {
        var oConfig = {
			canOverflow: true
		};
        oConfig.onBeforeEnterOverflow = this._onBeforeEnterOverflow.bind(this);
        oConfig.onAfterExitOverflow = this._onAfterExitOverflow.bind(this);

		return oConfig;
    };

    ActionToolbarAction.prototype._onBeforeEnterOverflow = function() {
        if (this.getParent()) {
            this.getParent()._updateSeparators();
        }
    };

    ActionToolbarAction.prototype._onAfterExitOverflow = function() {
        if (this.getParent()) {
            this.getParent()._updateSeparators();
        }
    };

    /**
     *
     * @returns {String} a text defining the label of this <code>ActionToolbarAction</code> defined by the inner action.
     */
    ActionToolbarAction.prototype.getLabel = function() {
        var oAction = this.getAction();
        return oAction && oAction.getText ? oAction.getText() : this.getId();
    };

    return ActionToolbarAction;
});