/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(['sap/ui/base/Object','sap/ui/model/Filter',"sap/ui/model/FilterOperator",'sap/ui/model/ParseException','sap/base/Log','sap/base/util/ObjectPath','sap/base/util/merge','sap/base/util/deepEqual','./Condition','sap/ui/mdc/enum/ConditionValidated','sap/base/strings/escapeRegExp'],function(B,F,a,P,L,O,m,d,C,b,e){"use strict";var M=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");sap.ui.getCore().attachLocalizationChanged(function(){M=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");});var c=B.extend("sap.ui.mdc.condition.Operator",{constructor:function(o){B.apply(this,arguments);if(!o){throw new Error("Operator configuration missing");}if(!o.name){L.warning("Operator configuration expects a name property");}if(!o.filterOperator&&!o.getModelFilter){throw new Error("Operator configuration for "+o.name+" needs a default filter operator from sap.ui.model.FilterOperator or the function getModelFilter");}this.name=o.name;if(o.alias){this.alias=o.alias;}this.filterOperator=o.filterOperator;this.valueTypes=o.valueTypes;this.paramTypes=o.paramTypes;this.displayFormats=o.displayFormats;var t="operators."+this.name;var l=t+".longText";var T=t+".tokenText";this.longText=o.longText||_(l)||"";this.tokenText=o.tokenText||_(T)||"";if(this.longText===l){this.longText=this.tokenText.replace(/\{0\}/g,"X").replace(/\{1\}/g,"Y");}if(this.tokenText===T){this.tokenText=this.longText;}if(this.tokenText){var r;var s;if(o.tokenParse){s=e(this.tokenText);this.tokenParse=o.tokenParse.replace(/#tokenText#/g,s);for(var i=0;i<this.valueTypes.length;i++){var R=this.paramTypes?this.paramTypes[i]:this.valueTypes[i];this.tokenParse=this.tokenParse.replace(new RegExp("\\\\\\$"+i+"|"+i+"\\\\\\$"+"|"+"\\\\\\{"+i+"\\\\\\}","g"),R);}r=this.tokenParse;}else{r=e(this.tokenText);}this.tokenParseRegExp=new RegExp(r,"i");if(o.tokenFormat){s=this.tokenText;this.tokenFormat=o.tokenFormat.replace(/\#tokenText\#/g,s);}else{this.tokenFormat=this.tokenText;}}if(o.format){this.format=o.format;}if(o.parse){this.parse=o.parse;}if(o.validate){this.validate=o.validate;}if(o.getModelFilter){this.getModelFilter=o.getModelFilter;}if(o.isEmpty){this.isEmpty=o.isEmpty;}if(o.createControl){this.createControl=o.createControl;}if(o.getCheckValue){this.getCheckValue=o.getCheckValue;}if(o.getValues){this.getValues=o.getValues;}if(o.checkValidated){this.checkValidated=o.checkValidated;}if(o.additionalInfo!==undefined){this.additionalInfo=o.additionalInfo;}this.exclude=!!o.exclude;this.validateInput=!!o.validateInput;this.group={id:!this.exclude?"1":"2"};if(!this.group.text){this.group.text=M.getText("VALUEHELP.OPERATOR.GROUP"+this.group.id);}}});c.ValueType={Self:"self",Static:"static",SelfNoParse:"selfNoParse"};function _(k,t){var f=k+(t?"."+t:""),T;T=M.getText(f,undefined,true);if(T===f||T===undefined){if(t){T=M.getText(k,undefined,true);if(T===f||T===undefined){T=k;}}else{T=f;}}return T;}c.prototype.getTypeText=function(k,t){return _(k,t);};c.prototype.getModelFilter=function(o,f,t,g){var v=o.values[0];var h;var i;var j=f.split(",");if(Array.isArray(v)&&j.length>1){v=v[0];f=j[0];i=new F({path:j[1],operator:a.EQ,value1:o.values[0][1]});}if(i&&v===undefined){h=i;i=undefined;}else if(!this.valueTypes[1]){if(!g&&o.validated===b.Validated){g=true;}h=new F({path:f,operator:this.filterOperator,value1:v,caseSensitive:g===false?false:undefined});}else{var V=o.values[1];if(Array.isArray(V)&&j.length>1){V=V[0];}h=new F({path:f,operator:this.filterOperator,value1:v,value2:V,caseSensitive:g===false?false:undefined});}if(i){h=new F({filters:[h,i],and:true});}if(o.inParameters){var k=[h];for(var I in o.inParameters){if(I.startsWith("conditions/")){k.push(new F({path:I.slice(11),operator:a.EQ,value1:o.inParameters[I]}));}}if(k.length>1){h=new F({filters:k,and:true});}}return h;};c.prototype.isEmpty=function(o,t){var f=false;if(o){for(var i=0;i<this.valueTypes.length;i++){if(this.valueTypes[i]!==c.ValueType.Static){var v=o.values[i];if(v===null||v===undefined||v===""){f=true;break;}}}}return f;};c.prototype.format=function(o,t,D,h){var v=o.values;var f=this.valueTypes.length;var T=h&&f===1?"{0}":this.tokenFormat;for(var i=0;i<f;i++){if(this.valueTypes[i]!==c.ValueType.Static){if(this.valueTypes[i]!==c.ValueType.Self){t=this._createLocalType(this.valueTypes[i],t);}var V=v[i];if(V===undefined||V===null){V=t?t.parseValue("","string"):"";}var r=t?t.formatValue(V,"string"):V;T=T.replace(new RegExp("\\$"+i+"|"+i+"\\$"+"|"+"\\{"+i+"\\}","g"),r);}}return T;};c.prototype.parse=function(t,T,D,f){var v=this.getValues(t,D,f);var r;if(v){r=[];for(var i=0;i<this.valueTypes.length;i++){if(this.valueTypes[i]&&[c.ValueType.Self,c.ValueType.Static].indexOf(this.valueTypes[i])===-1){T=this._createLocalType(this.valueTypes[i],T);}try{if(this.valueTypes[i]!==c.ValueType.Static){var V;if(this.valueTypes[i]){V=this._parseValue(v[i],T);}else{V=v[i];}r.push(V);}}catch(g){L.warning(g.message);throw g;}}}return r;};c.prototype._parseValue=function(v,t){if(v===undefined){return v;}var f;if(t&&t.isA("sap.ui.model.CompositeType")&&t._aCurrentValue&&t.getParseWithValues()){f=t._aCurrentValue;}var V=t?t.parseValue(v,"string",f):v;if(t&&t._aCurrentValue&&Array.isArray(V)){for(var j=0;j<V.length;j++){if(V[j]===undefined){V[j]=t._aCurrentValue[j]===undefined?null:t._aCurrentValue[j];}}}return V;};c.prototype.validate=function(v,t){var f=this.valueTypes.length;for(var i=0;i<f;i++){if(this.valueTypes[i]&&this.valueTypes[i]!==c.ValueType.Static){if([c.ValueType.Self,c.ValueType.Static].indexOf(this.valueTypes[i])===-1){t=this._createLocalType(this.valueTypes[i],t);}if(v.length<i+1){throw new Error("value "+i+" for operator "+this.getName()+" missing");}if(t){var V=v[i];if(V===undefined||V===null){V=t?t.parseValue("","string"):"";}t.validateValue(V);}}}};c.prototype._createLocalType=function(t,T){if(!this._aTypes){this._aTypes=[];}var s;var f;var o;var u;if(t===c.ValueType.SelfNoParse){s=T.getMetadata().getName();f=m({},T.getFormatOptions());o=m(T.getConstraints());}else if(typeof t==="string"){s=t;}else if(t&&typeof t==="object"){s=t.name;f=t.formatOptions;o=t.constraints;}for(var i=0;i<this._aTypes.length;i++){var g=this._aTypes[i];if(g.name===s&&d(g.formatOptions,f)&&d(g.constraints,o)){u=g.type;break;}}if(!u){var h=O.get(s||"");u=new h(f,o);u._bCreatedByOperator=true;if(t===c.ValueType.SelfNoParse){u.parseValue=function(v,S){h.prototype.parseValue.apply(this,arguments);return v;};u.validateValue=function(v){var V=h.prototype.parseValue.apply(this,[v,"string"]);h.prototype.validateValue.apply(this,[V]);};u.formatValue=function(v,j){h.prototype.formatValue.apply(this,arguments);return v;};}this._aTypes.push({name:s,formatOptions:f,constraints:o,type:u});}return u;};c.prototype.test=function(t){return this.tokenParseRegExp.test(t);};c.prototype.getValues=function(t,D,f){var g=t.match(this.tokenParseRegExp);var v;if(g||(f&&t)){v=[];for(var i=0;i<this.valueTypes.length;i++){var V;if(g){V=g[i+1];}else if(f){if(i>0){break;}V=t;}v.push(V);}}return v;};c.prototype.getCondition=function(t,T,D,f){if(this.test(t)||(f&&t&&this.hasRequiredValues())){var v=this.parse(t,T,D,f);if(v.length==this.valueTypes.length||this.valueTypes[0]===c.ValueType.Static||(v.length===1&&this.valueTypes.length===2&&!this.valueTypes[1])){var o=C.createCondition(this.name,v);this.checkValidated(o);return o;}else{throw new P("Parsed value don't meet operator");}}return null;};c.prototype.isSingleValue=function(){if(this.valueTypes.length>1&&this.valueTypes[1]){return false;}return true;};c.prototype.getCheckValue=function(o){if(this.valueTypes[0]&&this.valueTypes[0]===c.ValueType.Static){return{};}else{return{values:o.values};}};c.prototype.hasRequiredValues=function(){if(this.valueTypes[0]&&this.valueTypes[0]!==c.ValueType.Static){return true;}else{return false;}};c.prototype.compareConditions=function(o,f){var E=false;if(o.operator===this.name&&o.operator===f.operator){var g=this.getCheckValue(o);var h=this.getCheckValue(f);if(o.inParameters&&f.inParameters){g.inParameters=o.inParameters;h.inParameters=f.inParameters;}if(o.outParameters&&f.outParameters){g.outParameters=o.outParameters;h.outParameters=f.outParameters;}if(o.validated&&f.validated){g.validated=o.validated;h.validated=f.validated;}var s=JSON.stringify(g);var i=JSON.stringify(h);if(s===i){E=true;}}return E;};c.prototype.checkValidated=function(o){o.validated=b.NotValidated;};return c;});
