/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/base/ManagedObjectObserver','sap/base/util/merge','sap/base/util/deepEqual','sap/ui/mdc/condition/Condition','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Operator','sap/ui/mdc/field/ConditionType','sap/ui/mdc/enum/EditMode','sap/ui/mdc/enum/FieldDisplay','sap/ui/mdc/enum/BaseType','sap/ui/mdc/enum/ConditionValidated','sap/ui/mdc/Field','sap/ui/mdc/field/ListFieldHelp','sap/ui/mdc/field/ListFieldHelpItem','sap/ui/model/base/ManagedObjectModel','sap/ui/model/json/JSONModel','sap/ui/model/resource/ResourceModel','sap/ui/model/type/String','sap/ui/core/library','sap/ui/core/InvisibleText','sap/ui/core/ListItem','sap/ui/layout/Grid','sap/ui/layout/GridData','sap/m/library','sap/m/ScrollContainer','sap/m/Button','sap/m/Panel','sap/base/Log'],function(C,M,m,d,a,F,O,b,E,c,B,e,f,L,g,h,J,R,S,k,I,l,G,o,p,q,r,P,s){"use strict";var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");sap.ui.getCore().attachLocalizationChanged(function(){t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");});var u=p.ButtonType;var V=k.ValueState;var D=C.extend("sap.ui.mdc.field.DefineConditionPanel",{metadata:{library:"sap.ui.mdc",properties:{conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true},formatOptions:{type:"object",defaultValue:{}},label:{type:"string",defaultValue:""},inputOK:{type:"boolean",defaultValue:true}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{conditionProcessed:{}}},_oManagedObjectModel:null,renderer:{apiVersion:2,render:function(i,j){i.openStart("section",j);i.class("sapUiMdcDefineConditionPanel");i.openEnd();i.renderControl(j.getAggregation("_content"));i.close("section");}},init:function(){sap.ui.getCore().getMessageManager().registerObject(this,true);C.prototype.init.apply(this,arguments);this._oManagedObjectModel=new h(this);this._oObserver=new M(_.bind(this));this._oObserver.observe(this,{properties:["conditions","formatOptions"]});X.call(this);this.setModel(this._oManagedObjectModel,"$this");this.setModel(this._oManagedObjectModel,"$condition");},exit:function(){sap.ui.getCore().getMessageManager().unregisterObject(this,true);this._oObserver.disconnect();this._oObserver=undefined;if(this._sConditionsTimer){clearTimeout(this._sConditionsTimer);this._sConditionsTimer=null;}if(this._oDefaultType){this._oDefaultType.destroy();delete this._oDefaultType;}this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;},byId:function(i){return sap.ui.getCore().byId(this.getId()+"--"+i);},onBeforeRendering:function(){if(!this.getModel("$i18n")){this.setModel(new R({bundleName:"sap/ui/mdc/messagebundle",async:false}),"$i18n");}if(this.getConditions().length===0){this.updateDefineConditions();}},removeCondition:function(j){var n=j.oSource;var m1=n.getBindingContext("$this");var n1=this.getConditions();var o1=m1.getPath();var p1=o1.match(/^.*\/(\d+)\/$/);var q1;if(p1){q1=parseInt(p1[1]);}if(q1>0&&n1.length-1===q1){this._bFocusLastRemoveBtn=true;}var r1=this.byId("conditions");var s1=r1.getContent();var t1=0;for(var i=0;i<s1.length&&t1<=q1;i++){var u1=s1[i];if(t1===q1&&u1 instanceof f&&u1.hasOwnProperty("_iValueIndex")){if(u1._bParseError){u1.setValue(null);}}if(u1 instanceof r&&u1.getId().endsWith("-removeBtnLarge")){t1++;}}n1.splice(q1,1);this.setProperty("conditions",n1,true);this.fireConditionProcessed();},addCondition:function(i){var j=this.getConditions();var n=this.getFormatOptions();var m1=n.maxConditions;if(m1===-1||j.length<m1){this.addDummyCondition(j.length+1);if(this.getConditions().length===m1){this._bFocusLastCondition=true;}}},addDummyCondition:function(i){var j=A.call(this);var n=z.call(this);var m1=n.name;var n1=a.createCondition(m1,n.valueDefaults?n.valueDefaults:[],undefined,undefined,e.NotValidated);n1.isInitial=true;F.updateConditionValues(n1);F.checkConditionsEmpty(n1,j);var o1=this.getConditions();if(i!==undefined){o1.splice(i,0,n1);}else{o1.push(n1);}this.setProperty("conditions",o1,true);},updateDefineConditions:function(){var i=this.getConditions().filter(function(j){var n=F.getOperator(j.operator);return j.validated!==e.Validated||n.exclude;});W.call(this,i,true,false);if(i.length===0){this.addDummyCondition();}},onChange:function(i){var j=A.call(this);var n=this.getConditions();F.checkConditionsEmpty(n,j);F.updateConditionsValues(n,j);if(i){n.forEach(function(m1){if(!m1.isEmpty){delete m1.isInitial;}});}this.setProperty("conditions",n,true);},onSelectChange:function(i){var j=i.getSource();var n=j.getValue();var m1=j._sOldKey;var n1=F.getOperator(n);var o1=m1&&F.getOperator(m1);if(n1&&o1){var p1=false;var q1=j.getBindingContext("$this").getObject();var r1=this.getConditions();var s1=F.indexOfCondition(q1,r1);if(!d(n1.valueTypes[0],o1.valueTypes[0])&&n1.valueTypes[0]!==O.ValueType.Static){if(s1>=0){q1=r1[s1];q1.values.forEach(function(t1,u1){if(t1!==null){if((n1.valueTypes[u1]===O.ValueType.Self&&o1.valueTypes[u1]===O.ValueType.SelfNoParse)||(n1.valueTypes[u1]===O.ValueType.SelfNoParse&&o1.valueTypes[u1]===O.ValueType.Self)){var v1=x.call(this,n1.name,u1);var w1=x.call(this,o1.name,u1);var x1=w1.formatValue(q1.values[u1],"string");var y1=v1.parseValue(x1,"string");if(y1!==q1.values[u1]){q1.values[u1]=v1.parseValue(x1,"string");p1=true;}}else{q1.values[u1]=null;p1=true;}}}.bind(this));}}if(s1>=0&&n1.valueDefaults){q1=r1[s1];q1.values.forEach(function(t1,u1){if((q1.isInitial&&t1!==n1.valueDefaults[u1])||(t1===null)){q1.values[u1]=n1.valueDefaults[u1];q1.isInitial=true;p1=true;}});}if(!n1.valueTypes[1]&&o1.valueTypes[1]){if(s1>=0){q1=r1[s1];if(q1.values.length>1&&q1.values[1]){q1.values=q1.values.slice(0,1);p1=true;}}}if(p1){F.checkConditionsEmpty(q1,A.call(this));this.setProperty("conditions",r1,true);}}delete j._sOldKey;},onPaste:function(n){var m1;var n1=n.srcControl;var o1=this.getFormatOptions();var p1=o1.hasOwnProperty("maxConditions")?o1.maxConditions:-1;var q1=n1.getBindingContext("$condition").getPath();var r1=parseInt(q1.split("/")[2]);if(window.clipboardData){m1=window.clipboardData.getData("Text");}else{m1=n.originalEvent.clipboardData.getData('text/plain');}var s1=m1.split(/\r\n|\r|\n/g);if(s1&&s1.length>1){setTimeout(function(){var o1=m({},this.getFormatOptions());delete o1.fieldHelpID;delete o1.conditionModelName;o1.maxConditions=1;o1.display=c.Value;var t1=new b(o1);var u1=s1.length;var v1=this.getConditions();for(var i=0;i<u1;i++){if(s1[i]){var w1=s1[i].trim();var x1=w1.split(/\t/g);if(x1.length==2&&x1[0]&&x1[1]){var y1=F.getOperator("BT");w1=y1.tokenFormat;for(var j=0;j<2;j++){w1=w1.replace(new RegExp("\\{"+j+"\\}","g"),x1[j]);}}try{var z1=t1.parseValue(w1,"string");t1.validateValue(z1);if(v1.length>r1){v1.splice(r1,1,z1);}else{v1.push(z1);}r1++;}catch(A1){s.error("Paste handling","the pasted value '"+w1+"' could not be handled! "+A1.message);}}}if(p1>=0&&v1.length>p1){v1.splice(p1,v1.length-p1);}if(n1.setDOMValue){n1.setDOMValue("");}F.checkConditionsEmpty(v1);this.setProperty("conditions",v1,true);this.fireConditionProcessed();}.bind(this),0);}},cleanUp:function(){var j=this.byId("conditions");var n=j.getContent();for(var i=0;i<n.length;i++){var m1=n[i];if(m1 instanceof f&&m1.hasOwnProperty("_iValueIndex")){if(m1._bParseError){m1.setValue();}}}this.setProperty("inputOK",true,true);}});function _(i){if(i.name==="value"){v.call(this,i.object,i.current,i.old);}if(i.name==="formatOptions"){var j=this.getConditions();var n=i.current&&i.current.operators;var m1=i.old&&i.old.operators;var n1=false;if(!d(n,m1)){n1=true;K.call(this);}var o1=i.current&&i.current.valueType&&i.current.valueType.getMetadata().getName();var p1=i.old&&i.old.valueType&&i.old.valueType.getMetadata().getName();if(o1!==p1&&j.length>0){if(!n1){K.call(this);}this._bUpdateType=true;$.call(this);this._bUpdateType=false;W.call(this,j,true,true);}}if(i.name==="conditions"){if(this._sConditionsTimer){clearTimeout(this._sConditionsTimer);this._sConditionsTimer=null;}this._sConditionsTimer=setTimeout(function(){this._sConditionsTimer=null;this.updateDefineConditions();$.call(this);}.bind(this),0);}}function v(j,n,m1){j._sOldKey=m1;var n1=0;if(n&&m1){var o1=F.getOperator(n);var p1=F.getOperator(m1);var q1=j.getParent();var r1;var s1;n1=q1.indexOfContent(j);r1=q1.getContent()[n1+2];if(r1&&r1.hasOwnProperty("_iValueIndex")&&r1._iValueIndex===0){if(r1 instanceof f&&!r1._bParseError){r1.setValueState(V.None);r1.setValueStateText();}s1=q1.getContent()[n1+3];if(s1&&s1.hasOwnProperty("_iValueIndex")&&s1._iValueIndex===1){if(s1 instanceof f&&!s1._bParseError){s1.setValueState(V.None);s1.setValueStateText();}}else{s1=undefined;}}else{r1=undefined;}if(o1.createControl||p1.createControl){if(r1){r1.destroy();}if(s1){s1.destroy();}}else{if(r1&&o1.valueTypes[0]!==p1.valueTypes[0]){r1.unbindProperty("value");}if(s1&&o1.valueTypes[1]!==p1.valueTypes[1]&&p1.valueTypes[1]){s1.unbindProperty("value");}}}if(!n){var t1=j.getBindingContext("$this").getObject();if(t1){var u1=this.getConditions();n1=F.indexOfCondition(t1,u1);if(n1>=0){t1=u1[n1];t1.operator=m1;this.setProperty("conditions",u1,true);}}}var v1=this.oOperatorModel.getData();var w1;for(var i=0;i<v1.length;i++){var x1=v1[i];if(x1.key===n){w1=x1.text;break;}}j.setAdditionalValue(w1);this.onChange();}function w(i,j,n,m1){var n1=F.getOperator(i.operator);if(!n1||!n1.valueTypes[j]){return null;}var o1=x.call(this,n1.name,j);var p1=this._oManagedObjectModel.getContext(m1.getPath()+"values/"+j+"/");var q1;if(n1.createControl){q1=n1.createControl(o1,"$this>",j,n);}if(!q1){q1=new f(n,{delegate:U.call(this),value:{path:"$this>",type:o1,mode:'TwoWay',targetType:'raw'},editMode:{path:"$condition>operator",formatter:c1},width:"100%"});}if(q1.getMetadata().hasProperty("placeholder")){if(j===0){q1.bindProperty("placeholder",{path:"$condition>operator",formatter:g1});}else{q1.bindProperty("placeholder",{path:"$condition>operator",formatter:h1});}}q1._iValueIndex=j;if(q1.attachChange){q1.attachChange(this.onChange.bind(this));}q1.onpaste=this.onPaste.bind(this);q1.setLayoutData(new o({span:{path:"$condition>",formatter:f1.bind(this)}}));q1.setBindingContext(p1,"$this");q1.setBindingContext(m1,"$condition");q1.setFieldGroupIds([m1.getPath()]);return q1;}function x(i,j){var n=N.call(this);var m1=F.getOperator(i);if(m1.valueTypes[j]&&[O.ValueType.Self,O.ValueType.Static].indexOf(m1.valueTypes[j])===-1){n=m1._createLocalType(m1.valueTypes[j],n);}var n1=false;if(m1.valueTypes[j]===O.ValueType.Static){n1=true;n=Q.call(this);}var o1=n1?B.String:T.call(this,n);var p1;switch(o1){case B.Numeric:var q1=n.getFormatOptions();if(q1&&q1.hasOwnProperty("emptyString")&&q1.emptyString===null){p1=n;}else{p1=y(n,{emptyString:null});}break;case B.Date:case B.Time:case B.DateTime:p1=n;break;default:if(n.getConstraints()&&n.getConstraints().hasOwnProperty("nullable")&&n.getConstraints().nullable===false){p1=y(n);if(n._bCreatedByOperator){p1=m1._createLocalType(m1.valueTypes[j],n);}}else{p1=n;}break;}return p1;}function y(i,n,j){var m1=sap.ui.require(i.getMetadata().getName().replace(/\./g,"/"));var n1=m(i.getFormatOptions(),n||{});var o1=m(i.getConstraints(),j||{});if(o1.hasOwnProperty("nullable")&&o1.nullable===false){o1.nullable=true;}return new m1(n1,o1);}function z(){var j=A.call(this);var n;var m1=this.getFormatOptions().defaultOperatorName;if(m1){n=F.getOperator(m1);}else{var n1=N.call(this);var o1=T.call(this,n1);n=F.getDefaultOperator(o1);}if(n&&j.indexOf(n.name)<0){for(var i=0;i<j.length;i++){n=F.getOperator(j[i]);if(n.exclude||!n.hasRequiredValues()){n=undefined;}else{break;}}}if(!n){n=F.getOperator(j[0]);}return n;}function A(){var i=this.getFormatOptions();var j=i&&i.operators;if(!j||j.length===0){j=F.getOperatorsForType(B.String);}return j;}function H(){var j;var n=A.call(this);for(var i=0;i<n.length;i++){var m1=n[i];var n1=F.getOperator(m1);if(!j){j=n1.group.id;}else if(j!==n1.group.id){return true;}}return false;}function K(){if(!this.oOperatorModel){return;}var j=N.call(this);var n=A.call(this);var m1=[];var n1=H.call(this);var o1=this.getId()+"--rowSelect-help";var p1=sap.ui.getCore().byId(o1);var q1;if(n1){q1=new g({key:"{om>key}",text:"{om>text}",additionalText:"{om>additionalText}",groupKey:"{om>groupId}",groupText:"{om>groupText}"});}else{q1=new l({key:"{om>key}",text:"{om>text}",additionalText:"{om>additionalText}"});}p1.bindAggregation("items",{path:'om>/',templateShareable:false,template:q1});for(var i=0;i<n.length;i++){var r1=n[i];var s1=F.getOperator(r1);if(!s1||(s1.showInSuggest!==undefined&&s1.showInSuggest==false)){continue;}var t1=s1.textKey||"operators."+s1.name+".longText";var u1=s1.getTypeText(t1,T.call(this,j).toLowerCase());if(u1===t1){u1=s1.longText;}var v1=s1.additionalInfo;if(v1===undefined){if(v1!==""&&s1.formatRange){v1=s1.formatRange(s1._getRange(undefined,j),j);}else if(!n1){v1=s1.group.text;}}m1.push({key:s1.name,text:u1,additionalText:v1,groupId:s1.group.id,groupText:s1.group.text});}this.oOperatorModel.setData(m1);}function N(){var i=this.getFormatOptions();var j=i&&i.valueType;if(!j){j=Q.call(this);}return j;}function Q(){if(!this._oDefaultType){this._oDefaultType=new S();}return this._oDefaultType;}function T(i){var j=i.getMetadata().getName();var n=i.getFormatOptions();var m1=i.getConstraints();var n1=this.getFormatOptions().delegate;var o1=this.getFormatOptions().payload;var p1=n1?n1.getTypeUtil(o1).getBaseType(j,n,m1):B.String;if(p1===B.Unit){p1=B.Numeric;}return p1;}function U(){var i=this.getFormatOptions();var n=i.delegateName||"sap/ui/mdc/field/FieldBaseDelegate";var j=i.payload;return{name:n,payload:j};}function W(j,n,m1){var n1=N.call(this);var o1=[];var i=0;for(i=0;i<j.length;i++){var p1=j[i];var q1=F.getOperator(p1.operator);if(q1&&q1.valueTypes[0]===O.ValueType.Static&&(p1.values.length===0||m1)){if(q1.getStaticText){var r1=q1.getStaticText(n1);if(p1.values.length>0){p1.values[0]=r1;}else{p1.values.push(r1);}o1.push(i);}}}if(o1.length>0){this.setProperty("conditions",j,true);}}function X(){var i=new I(this.getId()+"--ivtOperator",{text:"{$i18n>valuehelp.DEFINECONDITIONS_OPERATORLABEL}"});var j=new P({headerText:"{$this>/label}",expanded:true,height:"100%",backgroundDesign:"Transparent"}).addStyleClass("sapMdcDefineconditionPanel");j.addDependent(new L(this.getId()+"--rowSelect-help",{filterList:false,useFirstMatch:true}));var n=new G(this.getId()+"--conditions",{width:"100%",hSpacing:0,vSpacing:0,containerQuery:true}).addStyleClass("sapUiMdcDefineConditionGrid");b1.call(this,undefined,n,0,null,0);j.addContent(i);j.addContent(n);var m1=new r(this.getId()+"--addBtn",{press:this.addCondition.bind(this),type:u.Default,text:"{$i18n>valuehelp.DEFINECONDITIONS_ADDCONDITION}",layoutData:new o({span:"XL2 L3 M3 S3",indent:"XL9 L8 M8 S7",linebreak:true,visibleS:{path:"$this>/conditions",formatter:Y.bind(this)},visibleM:{path:"$this>/conditions",formatter:Y.bind(this)},visibleL:{path:"$this>/conditions",formatter:Y.bind(this)},visibleXL:{path:"$this>/conditions",formatter:Y.bind(this)}})});n.addContent(m1);n.attachValidateFieldGroup(j1,this);this.setAggregation("_content",j);}function Y(i){var j=this.getFormatOptions();var n=j.hasOwnProperty("maxConditions")?j.maxConditions:-1;return n===-1||i.length<n;}function Z(i){var j=this.getFormatOptions();var n=j.hasOwnProperty("maxConditions")?j.maxConditions:-1;return n!==1;}function $(){var j=this.getConditions();var n=this.byId("conditions");var m1;var n1=-1;var o1=0;for(var i=0;i<j.length;i++){var p1=j[i];var q1=F.getOperator(p1.operator);if(p1.validated!==e.Validated||q1.exclude){var r1=this._oManagedObjectModel.getContext("/conditions/"+i+"/");n1++;if(!this.oOperatorModel){this.oOperatorModel=new J();this.setModel(this.oOperatorModel,"om");K.call(this);}m1=n.getContent();if(m1[o1]&&m1[o1].isA("sap.ui.mdc.Field")){o1=i1.call(this,p1,n,o1,r1,n1);}else{o1=b1.call(this,p1,n,o1,r1,n1);}}}m1=n.getContent();while(m1[o1]&&m1[o1]!==this.byId("addBtn")){m1[o1].destroy();o1++;}if(this._bFocusLastCondition){m1[0].focus();this._bFocusLastCondition=false;}if(this._bFocusLastRemoveBtn){o1=a1.call(this,["-removeBtnLarge","-removeBtnSmall"]);m1[o1].focus();this._bFocusLastRemoveBtn=false;}}function a1(j){var m1=this.byId("conditions");var n1=m1.getContent();var n=n1.length-1;if(!Array.isArray(j)){j=[j];}var i=0;var o1=j[i];while(n>=0&&o1!==undefined){var p1=n1[n];if(p1.getId().endsWith(o1)){var q1=jQuery(p1.getDomRef());if(q1.is(":visible")){return n;}else{i++;o1=j[i];}}n--;}return 0;}function b1(j,n,m1,n1,o1){var p1=this.getId()+"--"+o1;if(!this._oOperatorFieldType){this._oOperatorFieldType=new S({},{minLength:1});}var q1=new f(p1+"-operator",{value:{path:"$this>operator",type:this._oOperatorFieldType},width:"100%",display:"Description",fieldHelp:this.getId()+"--rowSelect-help",change:this.onSelectChange.bind(this),ariaLabelledBy:this.getId()+"--ivtOperator"}).setLayoutData(new o({span:{path:"$this>/conditions",formatter:e1.bind(this)},linebreak:true})).setBindingContext(n1,"$this");if(n1){q1.setFieldGroupIds([n1.getPath()]);}this._oObserver.observe(q1,{properties:["value"]});n.insertContent(q1,m1);m1++;var r1=new r(p1+"--removeBtnSmall",{press:this.removeCondition.bind(this),type:u.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.DEFINECONDITIONS_REMOVECONDITION}"}).setLayoutData(new o({span:"XL1 L1 M1 S2",indent:{path:"$this>operator",formatter:d1},visibleS:{path:"$this>/conditions",formatter:Z.bind(this)},visibleM:false,visibleL:false,visibleXL:false})).setBindingContext(n1,"$this");if(n1){r1.setFieldGroupIds([n1.getPath()]);}n.insertContent(r1,m1);m1++;if(j){for(var i=0;i<j.values.length;i++){var s1=w.call(this,j,i,p1+"-values"+i,n1);if(s1){n.insertContent(s1,m1);m1++;}}}var t1=new r(p1+"--removeBtnLarge",{press:this.removeCondition.bind(this),type:u.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.DEFINECONDITIONS_REMOVECONDITION}"}).setLayoutData(new o({span:"XL1 L1 M1 S1",indent:{path:"$this>operator",formatter:d1},visibleS:false,visibleM:{path:"$this>/conditions",formatter:Z.bind(this)},visibleL:{path:"$this>/conditions",formatter:Z.bind(this)},visibleXL:{path:"$this>/conditions",formatter:Z.bind(this)}})).setBindingContext(n1,"$this");n.insertContent(t1,m1);m1++;return m1;}function c1(i){if(!i){return E.Display;}var j=F.getOperator(i);var n=false;if(j&&j.valueTypes[0]===O.ValueType.Static){n=true;}return n?E.Display:E.Editable;}function d1(i){var j=i&&F.getOperator(i);if(!j||!j.valueTypes[0]){return"XL8 L8 M8 S0";}else{return"";}}function e1(i){var j=this.getFormatOptions();var n=j.hasOwnProperty("maxConditions")?j.maxConditions:-1;var m1="XL3 L3 M3 ";if(n===1){m1+="S12";}else{m1+="S10";}return m1;}function f1(i){var j=this.getFormatOptions();var n=j.hasOwnProperty("maxConditions")?j.maxConditions:-1;var m1=i&&F.getOperator(i.operator);var n1="";if(m1&&m1.valueTypes[1]){n1="XL4 L4 M4 ";}else{n1="XL8 L8 M8 ";}if(n===1){n1+="S12";}else{n1+="S10";}return n1;}function g1(i){var j=i&&F.getOperator(i);if(j&&j.aLabels){return j.aLabels[0];}else if(j&&j.valueTypes[1]){return t.getText("valuehelp.DEFINECONDITIONS_FROM");}else{return t.getText("valuehelp.DEFINECONDITIONS_VALUE");}}function h1(i){var j=i&&F.getOperator(i);if(j&&j.aLabels){return j.aLabels[1];}else if(j&&j.valueTypes[1]){return t.getText("valuehelp.DEFINECONDITIONS_TO");}}function i1(j,n,m1,n1,o1){var p1=this.getId()+"--"+o1;var q1=n.getContent();var r1;var s1=q1[m1];s1.setBindingContext(n1,"$this");if(n1){s1.setFieldGroupIds([n1.getPath()]);}m1++;var t1=q1[m1];t1.setBindingContext(n1,"$this");if(n1){t1.setFieldGroupIds([n1.getPath()]);}m1++;var u1;var v1=q1[m1];var w1;if(v1.hasOwnProperty("_iValueIndex")&&v1._iValueIndex===0){var x1=c1(j.operator);if(j.values.length>0||x1===E.Display){u1=this._oManagedObjectModel.getContext(n1.getPath()+"values/0/");v1.setBindingContext(u1,"$this");v1.setBindingContext(n1,"$condition");if(v1.getMetadata().hasProperty("value")&&(this._bUpdateType||!v1.getBindingInfo("value"))){r1=x.call(this,j.operator,0);v1.bindProperty("value",{path:"$this>",type:r1});}m1++;w1=q1[m1];if(w1.hasOwnProperty("_iValueIndex")&&w1._iValueIndex===1){if(j.values.length>1){u1=this._oManagedObjectModel.getContext(n1.getPath()+"values/1/");w1.setBindingContext(u1,"$this");if(w1.getMetadata().hasProperty("value")&&(this._bUpdateType||!w1.getBindingInfo("value"))){r1=x.call(this,j.operator,1);w1.bindProperty("value",{path:"$this>",type:r1});}m1++;}else{w1.destroy();}}else if(j.values.length>1){w1=w.call(this,j,1,p1+"-values1",n1);if(w1){n.insertContent(w1,m1);m1++;}}}else{v1.destroy();v1=undefined;w1=q1[m1+1];if(w1&&w1.hasOwnProperty("_iValueIndex")&&w1._iValueIndex===1){w1.destroy();}}}else if(j.values.length>0){for(var i=0;i<j.values.length;i++){var y1=w.call(this,j,i,p1+"-values"+i,n1);if(y1){n.insertContent(y1,m1);m1++;}}}q1=n.getContent();var z1=q1[m1];z1.setBindingContext(n1,"$this");m1++;return m1;}function j1(i){var j=i.getSource();while(!(j.getParent()instanceof G)){j=j.getParent();}k1.call(this,j);}function k1(i){var j=i.getParent();var n=j.indexOfContent(i);var m1;if(i.getId().endsWith("-operator")){m1=i.getBindingContext("$this");n=n+2;i=j.getContent()[n];}else if(i.getId().endsWith("-removeBtnSmall")){m1=i.getBindingContext("$this");n=n+1;i=j.getContent()[n];}else{m1=i.getBindingContext("$condition");}var n1;var o1=m1.getObject();var p1=F.getOperator(o1.operator);var q1=false;if(p1.valueTypes.length>0&&p1.valueTypes[0]!==O.ValueType.Static){if(p1.valueTypes.length>1&&p1.valueTypes[1]){if(i.hasOwnProperty("_iValueIndex")&&i._iValueIndex===0){n1=j.getContent()[n+1];}else if(i.hasOwnProperty("_iValueIndex")&&i._iValueIndex===1){n1=j.getContent()[n-1];}}if(i.getMetadata().getAllProperties().valueState&&!i._bParseError&&(!n1||!n1._bParseError)){var r1=i.getBinding("value").getType();try{p1.validate(o1.values,r1);i.setValueState(V.None);i.setValueStateText();if(n1&&n1.getMetadata().getAllProperties().valueState){n1.setValueState(V.None);n1.setValueStateText();}}catch(s1){q1=true;i.setValueState(V.Error);i.setValueStateText(s1.message);if(n1&&n1.getMetadata().getAllProperties().valueState){n1.setValueState(V.Error);n1.setValueStateText(s1.message);}}}}l1.call(this,q1);this.fireConditionProcessed();}function l1(j){if(j!==true){var n=this.byId("conditions");var m1=n.getContent();j=false;for(var i=0;i<m1.length;i++){var n1=m1[i];if(n1 instanceof f&&n1.hasOwnProperty("_iValueIndex")&&n1.getValueState()===V.Error){j=true;break;}}}this.setProperty("inputOK",!j,true);}return D;});
