/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/Device','sap/ui/mdc/enum/EditMode','sap/ui/mdc/enum/FieldDisplay','sap/ui/mdc/enum/ConditionValidated','sap/ui/mdc/field/FieldBaseRenderer','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Condition','sap/ui/mdc/field/ConditionType','sap/ui/mdc/field/ConditionsType','sap/ui/mdc/enum/BaseType','sap/ui/mdc/field/content/ContentFactory','sap/ui/mdc/Control','sap/ui/core/library','sap/ui/core/LabelEnablement','sap/ui/core/message/MessageMixin','sap/base/util/deepEqual','sap/base/util/merge','sap/base/Log','sap/ui/dom/containsOrEquals','sap/ui/model/Filter','sap/ui/model/BindingMode','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/ui/model/base/ManagedObjectModel','sap/ui/base/ManagedObjectObserver','sap/ui/base/SyncPromise','sap/base/util/restricted/_debounce','sap/ui/events/KeyCodes'],function(q,D,E,F,C,a,b,c,d,e,B,f,g,h,L,M,k,m,l,n,o,p,r,P,V,s,t,S,u,K){"use strict";var v=h.ValueState;var T=h.TextAlign;var w=h.TextDirection;var x=g.extend("sap.ui.mdc.field.FieldBase",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.ui.core.ISemanticFormContent"],library:"sap.ui.mdc",properties:{dataType:{type:"string",group:"Data",defaultValue:'sap.ui.model.type.String'},dataTypeConstraints:{type:"object",group:"Data",defaultValue:null},dataTypeFormatOptions:{type:"object",group:"Data",defaultValue:null},editMode:{type:"sap.ui.mdc.enum.EditMode",group:"Data",defaultValue:E.Editable},required:{type:"boolean",group:"Data",defaultValue:false},display:{type:"sap.ui.mdc.enum.FieldDisplay",defaultValue:F.Value},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:w.Inherit},placeholder:{type:"string",group:"Misc",defaultValue:""},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:v.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},multipleLines:{type:"boolean",group:"Appearance",defaultValue:false},maxConditions:{type:"int",group:"Behavior",defaultValue:-1},conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true},label:{type:"string",group:"Misc",defaultValue:""},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/field/FieldBaseDelegate",payload:{}}},showEmptyIndicator:{type:"boolean",group:"Appearance",defaultValue:false},_fieldHelpEnabled:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"},_ariaAttributes:{type:"object",defaultValue:{},byValue:true,visibility:"hidden"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false},contentEdit:{type:"sap.ui.core.Control",multiple:false},contentDisplay:{type:"sap.ui.core.Control",multiple:false},_content:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},fieldInfo:{type:"sap.ui.mdc.field.FieldInfoBase",multiple:false}},associations:{fieldHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},press:{},submit:{parameters:{promise:{type:"Promise"}}}},publicMethods:[],defaultAggregation:"content"},renderer:a,_oManagedObjectModel:null});M.call(x.prototype);var y={onsapprevious:f1,onsapnext:f1,onsapup:f1,onsapdown:f1,onsapbackspace:f1};var z={onsapenter:I};var A;x._init=function(){if(A&&A.bool&&A.bool.control){A.bool.control.destroy();}if(A&&A.defineConditions&&A.defineConditions.control){A.defineConditions.control.destroy();}A={bool:{name:"sap/ui/mdc/field/BoolFieldHelp",id:"BoolDefaultHelp",getDelegate:"getDefaultFieldHelpBaseDelegate",properties:{},control:undefined},defineConditions:{name:"sap/ui/mdc/field/FieldValueHelp",id:"Field-DefineConditions-Help",getDelegate:"getDefaultFieldValueHelpDelegate",properties:{showConditionPanel:true},control:undefined}};};x._init();x.prototype.init=function(){g.prototype.init.apply(this,arguments);this._oManagedObjectModel=new s(this);this._oObserver=new t(this._observeChanges.bind(this));this._oObserver.observe(this,{properties:["display","editMode","dataType","dataTypeFormatOptions","dataTypeConstraints","multipleLines","maxConditions","conditions","delegate"],aggregations:["fieldInfo","content","contentEdit","contentDisplay"],associations:["fieldHelp","ariaLabelledBy"]});this._oDatePickerRequested={};this.attachEvent("modelContextChange",this._handleModelContextChange,this);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._aAsyncChanges=[];this._bPreventGetDescription=false;this._oContentFactory=new f(this.getId()+"-contentFactory",{field:this,handleTokenUpdate:w1.bind(this),handleContentChange:q1.bind(this),handleContentLiveChange:t1.bind(this),handleValueHelpRequest:B1.bind(this),handleEnter:I.bind(this),handleContentPress:v1.bind(this)});this._oCreateContentPromise=undefined;this._sFilterValue="";};x.prototype.exit=function(){var i=this.getFieldInfo();if(i){i.detachEvent("dataUpdate",L1,this);}var j=this.getContent();if(j){$.call(this,j);}var S1=this.getContentEdit();if(S1){$.call(this,S1);}var T1=this.getContentDisplay();if(T1){$.call(this,T1);}this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;this._oObserver.disconnect();this._oObserver=undefined;this._oCreateContentPromise=undefined;var U1=z1.call(this);if(U1){U1.detachEvent("dataUpdate",G1,this);if(this._bConnected){H1.call(this);U1.connect();}}if(this._oContentFactory){this._oContentFactory.destroy();this._oContentFactory=undefined;}u1.call(this);delete this._fnLiveChangeTimer;};x.prototype.applySettings=function(){g.prototype.applySettings.apply(this,arguments);if(!this.bDelegateInitialized&&!this.bDelegateLoading){this.initControlDelegate();}return this;};x.prototype.setProperty=function(i,j,S1){if(i!=="width"&&i!=="editMode"&&i!=="multipleLines"&&i!=="showEmptyIndicator"){S1=true;}return g.prototype.setProperty.apply(this,[i,j,S1]);};x.prototype.onBeforeRendering=function(){a1.call(this);};x.prototype.onAfterRendering=function(){};x.prototype.onfocusin=function(i){I1.call(this);};x.prototype.onsapfocusleave=function(i){u1.call(this);};function _(i){var j=i.indexOf(this.getId());if(j>-1){if(this._bPendingChange){var S1=document.activeElement;var T1=z1.call(this);if(!(S1&&T1&&n(T1.getDomRef(),S1))){var U1=N1.call(this);if(U1){H.call(this,undefined,undefined,undefined,U1);}else{H.call(this,this.getConditions(),!this._bParseError);}}}if(i.length>1){i.splice(j,1);this.fireValidateFieldGroup({fieldGroupIds:i});}}}x.prototype.onsapup=function(i){var j=z1.call(this);var S1=i.srcControl;if(j&&(!j.valueHelpEnabled||j.valueHelpEnabled()||j.isOpen())&&(!this._oContentFactory.isMeasure()||S1.getShowValueHelp())){i.preventDefault();i.stopPropagation();j.setFilterValue(this._sFilterValue);j.navigate(-1);}};x.prototype.onsapdown=function(i){var j=z1.call(this);var S1=i.srcControl;if(j&&(!j.valueHelpEnabled||j.valueHelpEnabled()||j.isOpen())&&(!this._oContentFactory.isMeasure()||S1.getShowValueHelp())){i.preventDefault();i.stopPropagation();j.setFilterValue(this._sFilterValue);j.navigate(1);}};x.prototype.onsapenter=function(i){var j=z1.call(this);if(j&&j.isOpen(true)){j.close();}this._sFilterValue="";};x.prototype.onsapescape=function(i){this.onsapenter(i);};x.prototype.ontap=function(i){var j=z1.call(this);if(j){if(j.shouldOpenOnClick()&&!j.isOpen(true)){j.open(true);}var S1=i.srcControl;if(j.isOpen(true)&&(!this._oContentFactory.isMeasure()||(S1.getShowValueHelp&&S1.getShowValueHelp()))){S1.addStyleClass("sapMFocus");j.removeFocus();}}};x.prototype.clone=function(i,j){this.detachEvent("modelContextChange",this._handleModelContextChange,this);var S1=this.getContent();if(S1){$.call(this,S1);}var T1=this.getContentEdit();if(T1){$.call(this,T1);}var U1=this.getContentDisplay();if(U1){$.call(this,U1);}var V1=this.getFieldInfo();if(V1){V1.detachEvent("dataUpdate",L1,this);}var W1=g.prototype.clone.apply(this,arguments);this.attachEvent("modelContextChange",this._handleModelContextChange,this);if(S1){Z.call(this,S1);}if(T1){Z.call(this,T1);}if(U1){Z.call(this,U1);}if(V1){V1.attachEvent("dataUpdate",L1,this);}if(this._bTriggerable){W1._bTriggerable=this._bTriggerable;}return W1;};x.prototype.getFieldPath=function(){var i=this.getBindingPath("conditions");if(i&&i.startsWith("/conditions/")){return i.slice(12);}else{return"";}};function G(i,j,S1,T1){if(this._getContent().length>1){this._bPendingChange=true;}else{H.call(this,i,j,S1,T1);}}function H(i,j,S1,T1){if(!T1){if(j){T1=Promise.resolve(this._getResultForPromise(i));}else{T1=Promise.reject(S1);}}this._fireChange(i,j,S1,T1);this._bPendingChange=false;}x.prototype._fireChange=function(i,j,S1,T1){};function I(i){var j=this.getEditMode();if(f._getEditable(j)&&(this.hasListeners("submit")||this._bPendingChange)){var S1=N1.call(this);var T1=false;if(S1){T1=true;}else if(this._bParseError){S1=Promise.reject();}else{S1=Promise.resolve(this._getResultForPromise(this.getConditions()));}if(this._bPendingChange){if(T1){H.call(this,undefined,undefined,undefined,S1);}else{H.call(this,this.getConditions(),!this._bParseError,undefined,S1);}}this.fireSubmit({promise:S1});}}x.prototype._initDataType=function(){if(this._oContentFactory.getDataType()){this._oContentFactory.getDataType().destroy();this._oContentFactory.setDataType(undefined);}if(this._oContentFactory.getDateOriginalType()){if(this._oContentFactory.getDateOriginalType()._bCreatedByField){this._oContentFactory.getDateOriginalType().destroy();}this._oContentFactory.setDateOriginalType(undefined);}if(this._oContentFactory.getUnitOriginalType()){if(this._oContentFactory.getUnitOriginalType()._bCreatedByField){this._oContentFactory.getUnitOriginalType().destroy();}this._oContentFactory.getUnitOriginalType(undefined);}};function J(){if(this._oContentFactory.getDataType()&&typeof this._oContentFactory.getDataType()==="object"){return this._oContentFactory.getDataType().getMetadata().getName();}else if(this.bDelegateInitialized){return this.getControlDelegate().getDataTypeClass(this.getPayload(),this.getDataType());}else{return this.getDataType();}}function N(){var i=this._oContentFactory.getDataType();if(i&&typeof i==="object"&&i.getConstraints()){return i.getConstraints();}else{return this.getDataTypeConstraints();}}function O(){var i=this._oContentFactory.getDataType();if(i&&typeof i==="object"&&i.getFormatOptions()){return i.getFormatOptions();}else{return this.getDataTypeFormatOptions();}}x.prototype.getBaseType=function(){var i=J.call(this);var j=N.call(this);var S1=O.call(this);var T1=this.getTypeUtil().getBaseType(i,S1,j);return T1;};function Q(i,j){var S1=z1.call(this);if(S1&&this._bConnected){A1.call(this,i,S1);}}x.prototype._getContent=function(){var i=this.getContent();if(!i){if(this.getEditMode()===E.Display){i=this.getContentDisplay();}else{i=this.getContentEdit();}}if(i){return[i];}else{return this.getAggregation("_content",[]);}};x.prototype._handleModelContextChange=function(i){};function R(i){this.setValueState(v.Error);this.setValueStateText(i);}x.prototype._removeUIMessage=function(){this.setValueState(v.None);this.setValueStateText();};x.prototype._observeChanges=function(j){var S1=function(){if(this.getAggregation("_content",[]).length>0){a1.call(this);}};if(j.name==="dataType"){if(this._oContentFactory.getDataType()){var T1=function(W1){var X1=this.getTypeUtil().getDataTypeClass(j.current);if(!(this._oContentFactory.getDataType()instanceof X1)){this._initDataType();this.destroyAggregation("_content");this._oContentFactory.updateConditionType();}}.bind(this);if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){T1.call(this,j.current);}.bind(this));return;}T1.call(this,j.current);}}if(j.name==="dataTypeFormatOptions"||j.name==="dataTypeConstraints"){if(this._oContentFactory.getDataType()){this._initDataType();this.destroyAggregation("_content");this._oContentFactory.updateConditionType();}}if(j.name==="maxConditions"){S1.call(this);this._oContentFactory.updateConditionType();}if(j.name==="conditions"){this._bParseError=false;Q.call(this,j.current,j.old);var U1=false;var i=0;for(i=0;i<this._aAsyncChanges.length;i++){var V1=this._aAsyncChanges[i];if(V1.waitForUpdate&&k(V1.result,j.current)){r1.call(this,V1);U1=true;break;}}if(U1){this._aAsyncChanges.splice(i,1);}if((j.current.length===0||j.old.length===0)&&this.getShowEmptyIndicator()&&this.getEditMode()===E.Display&&!this.getContent()&&!this.getContentDisplay()){this.invalidate();}}if(j.name==="display"){d1.call(this);this._oContentFactory.updateConditionType();}if(j.name==="fieldHelp"&&j.ids){x1.call(this,j.ids,j.mutation);this._oContentFactory.updateConditionType();}if(j.name==="fieldInfo"&&j.child){K1.call(this,j.child,j.mutation);}if(j.name==="content"&&j.child){Y.call(this,j.child,j.mutation,j.name);}if(j.name==="contentEdit"&&j.child){Y.call(this,j.child,j.mutation,j.name);}if(j.name==="contentDisplay"&&j.child){Y.call(this,j.child,j.mutation,j.name);}if(j.name==="delegate"&&!this.bDelegateInitialized&&!this.bDelegateLoading){this.initControlDelegate.call(this);}if(j.name==="ariaLabelledBy"&&j.ids){U.call(this,j.ids,j.mutation);}if(j.name==="editMode"){X.call(this);}};x.prototype.getFocusDomRef=function(){var i=this._getContent();if(i.length>0){return i[0].getFocusDomRef();}else{return this.getDomRef();}};x.prototype.getIdForLabel=function(){var i;var j=this._getContent();if(j.length>0){i=j[0].getIdForLabel();}else{i=c1.call(this);}return i;};x.prototype.getEditable=function(){return f._getEditable(this.getEditMode());};x.prototype.getControlForSuggestion=function(){var i=this._getContent();if(i.length>0){if(this._oContentFactory.isMeasure()){return i[1];}else{return i[0];}}else{return this;}};x.prototype.getFocusElementForValueHelp=function(j){var S1=this.getControlForSuggestion();var T1=S1&&S1.getMetadata().getAllPrivateAggregations()._endIcon&&S1.getAggregation("_endIcon");var U1;for(var i=0;i<T1.length;i++){if(T1[i].getVisible()){U1=T1[i];break;}}return j||!U1?S1:U1;};x.prototype.getMaxConditionsForHelp=function(){if(this._oContentFactory.isMeasure()){return 1;}else{return this.getMaxConditions();}};x.prototype.getFormFormattedValue=function(){var i=this.getConditions();var j=this.getShowEmptyIndicator()&&i.length===0&&!this.getContent()&&!this.getContentDisplay();if(j){if(!this._oResourceBundleM){this._oResourceBundleM=sap.ui.getCore().getLibraryResourceBundle("sap.m");}return this._oResourceBundleM.getText("EMPTY_INDICATOR");}else if(this._oContentFactory.isMeasure()&&this._oContentFactory.getUnitOriginalType()){var S1=i.length>0?i[0].values[0]:[0,null];return this._oContentFactory.getUnitOriginalType().formatValue(S1,"string");}else if(this._oContentFactory.getDateOriginalType()){var T1=i.length>0?i[0].values[0]:null;return this._oContentFactory.getDateOriginalType().formatValue(T1,"string");}else{var U1=this._oContentFactory.getConditionsType();return U1.formatValue(i);}};x.prototype.getFormValueProperty=function(){return"conditions";};x.prototype.enhanceAccessibilityState=function(i,j){var S1=this.getParent();if(S1&&S1.enhanceAccessibilityState){S1.enhanceAccessibilityState(this,j);}};x.prototype.getAccessibilityInfo=function(){var i=this._getContent();if(i.length>0&&i[0].getAccessibilityInfo){return i[0].getAccessibilityInfo();}else{return{};}};function U(j,S1){var T1=this.getAggregation("_content",[]);var U1=this.getContent();if(U1){T1.push(U1);}U1=this.getContentDisplay();if(U1){T1.push(U1);}U1=this.getContentEdit();if(U1){T1.push(U1);}for(var i=0;i<T1.length;i++){U1=T1[i];if(U1.getMetadata().getAllAssociations().ariaLabelledBy){if(S1==="remove"){U1.removeAriaLabelledBy(j);}else if(S1==="insert"){U1.addAriaLabelledBy(j);}}}}function W(i,j){var S1={aria:{}};var T1=z1.call(this);if(T1){var U1=T1.getAriaAttributes(this.getMaxConditionsForHelp());var V1=U1.roleDescription;S1["role"]=U1.role;if(V1){S1.aria["roledescription"]=V1;}S1.aria["haspopup"]=U1.ariaHasPopup;S1["autocomplete"]="off";if(i){S1.aria["expanded"]="true";S1.aria["controls"]=U1.contentId;if(j){S1.aria["activedescendant"]=j;}}else{S1.aria["expanded"]="false";}S1["valueHelpEnabled"]=U1.valueHelpEnabled;}this.setProperty("_ariaAttributes",S1,true);}x.prototype.connectLabel=function(i){e1.call(this,i);i.bindProperty("text",{path:"$field>/label"});i.setLabelFor(this);return this;};function X(){var j=L.getReferencingLabels(this);for(var i=0;i<j.length;i++){var S1=sap.ui.getCore().byId(j[i]);S1.invalidate();}}function Y(i,j,S1){if(j==="remove"){$.call(this,i);h1.call(this,i);j1.call(this,i);if(this._oContentFactory.getContentConditionTypes()){delete this._oContentFactory.getContentConditionTypes()[S1];}i.setModel(null,"$field");}else if(j==="insert"){if(!i.isA("sap.ui.core.IFormContent")){throw new Error(i+" is not a valid content! Only use valid content in "+this);}g1.call(this,i,true);Z.call(this,i);i1.call(this,i,true);if(this.getAggregation("_content",[]).length>0){d1.call(this);}if(!this._oContentFactory.getContentConditionTypes()){this._oContentFactory.setContentConditionTypes({});}if(!this._oContentFactory.getContentConditionTypes()[S1]){this._oContentFactory.getContentConditionTypes()[S1]={};}var T1;var U1;for(U1 in i.getMetadata().getAllProperties()){if(i.getBindingPath(U1)==="/conditions"){T1=i.getBindingInfo(U1);if(T1&&T1.type&&T1.type instanceof e){this._oContentFactory.getContentConditionTypes()[S1].oConditionsType=T1.type;}this._oContentFactory.setBoundProperty(U1);}if(U1==="editable"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/editMode",formatter:f._getEditable});}if(U1==="enabled"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/editMode",formatter:f._getEnabled});}if(U1==="displayOnly"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/editMode",formatter:f._getDisplayOnly});}if(U1==="required"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/required"});}if(U1==="textAlign"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/textAlign"});}if(U1==="textDirection"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/textDirection"});}if(U1==="valueState"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/valueState"});}if(U1==="valueStateText"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/valueStateText"});}if(U1==="placeholder"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/placeholder"});}if(U1==="showValueHelp"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/_fieldHelpEnabled"});}if(U1==="valueHelpIconSrc"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.setValueHelpIconSrc(this._getFieldHelpIcon());}}for(var V1 in i.getMetadata().getAllAggregations()){if(i.getBindingPath(V1)==="/conditions"){T1=i.getBindingInfo(V1);if(T1&&T1.template){for(U1 in T1.template.getMetadata().getAllProperties()){var W1=T1.template.getBindingInfo(U1);if(W1&&W1.type&&W1.type instanceof d){this._oContentFactory.getContentConditionTypes()[S1].oConditionType=W1.type;break;}}}}if(V1==="tooltip"&&!i.getBindingPath(V1)&&!i.getAggregation(V1)){i.bindProperty(V1,{path:"$field>/tooltip"});}}if(i.getMetadata().getAllAssociations().ariaLabelledBy){this._oContentFactory.setAriaLabelledBy(i);}}}function Z(i){if(i.getMetadata().getEvents().change){i.attachEvent("change",q1,this);}if(i.getMetadata().getEvents().liveChange){i.attachEvent("liveChange",t1,this);}if(i.getMetadata().getEvents().press){i.attachEvent("press",v1,this);}if(i.getMetadata().getEvents().valueHelpRequest){i.attachEvent("valueHelpRequest",B1,this);}}function $(i){if(i.getMetadata().getEvents().change){i.detachEvent("change",q1,this);}if(i.getMetadata().getEvents().liveChange){i.detachEvent("liveChange",t1,this);}if(i.getMetadata().getEvents().press){i.detachEvent("press",v1,this);}if(i.getMetadata().getEvents().valueHelpRequest){i.detachEvent("valueHelpRequest",B1,this);}}function a1(){var i=function(){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){a1.call(this);}.bind(this));}else{b1.call(this);}};if(this._oCreateContentPromise){this._oCreateContentPromise.then(function(){i.call(this);}.bind(this));}else{i.call(this);}}function b1(){var i=this.getEditMode();var j=this.getContent();this._oContentFactory._setUsedConditionType(j,i);y1.call(this,this.getFieldHelp());W.call(this,false);if(j||this._bIsBeingDestroyed||(i===E.Display&&this.getContentDisplay())||(i!==E.Display&&this.getContentEdit())){d1.call(this);var S1=this._getContent();if(S1.length===1){e1.call(this,S1[0]);}return;}var T1=this.getMaxConditions();var U1=this._getOperators();var V1;var W1=this.getAggregation("_content",[]);var X1;var Y1;var Z1=this.getMultipleLines();var $1=this._bTriggerable;var _1=this._oContentFactory.getContentType(this.getBaseType(),this.getMaxConditions(),$1);if(W1.length>0){X1=W1[0];Y1=X1.getMetadata().getName().replace(/\./g,"/");}var a2=this._oContentFactory.getContentMode(_1,i,T1,Z1,U1);var b2=_1.getControlNames(a2,U1[0]);V1=b2[0];if(V1!==Y1){this._oContentFactory.setHideOperator(n1.call(this,U1));if(X1){d1.call(this);if(X1.isA("sap.m.DateTimeField")){this._initDataType();}this._oContentFactory.updateConditionType();}if(m1.call(this,_1,U1,i,T1)){k1.call(this,_1.getUseDefaultFieldHelp().name);}else if(this._sDefaultFieldHelp){delete this._sDefaultFieldHelp;}var c2=c1.call(this);this._oCreateContentPromise=this._oContentFactory.createContent(_1,a2,c2);this._oCreateContentPromise.then(function(d2){for(var e2=0;e2<d2.length;e2++){var f2=d2[e2];f2.attachEvent("parseError",o1,this);f2.attachEvent("validationError",p1,this);g1.call(this,f2,_1.getUseDefaultEnterHandler());i1.call(this,f2,false);e1.call(this,f2);if(this._bConnected&&((e2===0&&!this._oContentFactory.isMeasure())||(e2===1&&this._oContentFactory.isMeasure()))){J1.call(this,f2);}this.addAggregation("_content",f2);}X.call(this);}.bind(this));}}function c1(){return this.getId()+"-inner";}function d1(){this.destroyAggregation("_content");if(this._oContentFactory.getDateOriginalType()){this._oContentFactory.setDataType(this._oContentFactory.getDateOriginalType());this._oContentFactory.setDateOriginalType(undefined);}else if(this._oContentFactory.getUnitOriginalType()){this._oContentFactory.setDataType(this._oContentFactory.getUnitOriginalType());this._oContentFactory.setUnitOriginalType(undefined);}if(this._bParseError){this._bParseError=false;this._removeUIMessage();}if(this._oContentFactory.isMeasure()){this._oContentFactory.setIsMeasure(false);}}function e1(i){i.setModel(this._oManagedObjectModel,"$field");}function f1(i){var j=false;var S1=z1.call(this);if(!S1){return;}else if(S1.isOpen()){j=true;}else{switch(i.type){case"sapprevious":case"sapup":if(i.keyCode===K.ARROW_UP){j=true;}break;case"sapnext":case"sapdown":if(i.keyCode===K.ARROW_DOWN){j=true;}break;default:break;}}if(j){i.stopPropagation();i.stopImmediatePropagation(true);switch(i.type){case"sapup":this.onsapup(i);break;case"sapdown":this.onsapdown(i);break;default:break;}}}function g1(i,j){i.addDelegate(y,true,this);if(j){i.addDelegate(z,false,this);}}function h1(i){i.removeDelegate(y);i.removeDelegate(z);}function i1(i,j){if(j){i._OriginalGetFieldGroupIds=i._getFieldGroupIds;i._OriginalTriggerValidateFieldGroup=i.triggerValidateFieldGroup;}i._getFieldGroupIds=function(){var S1=this.getFieldGroupIds();var T1=this.getParent();if(T1){S1=S1.concat(T1._getFieldGroupIds());}return S1;};i.triggerValidateFieldGroup=function(S1){var T1=this.getParent();if(T1){var U1=S1.indexOf(T1.getId());if(U1>-1){_.call(T1,S1);}else{T1.fireValidateFieldGroup({fieldGroupIds:S1});}}};}function j1(i){if(i._OriginalGetFieldGroupIds&&i._OriginalTriggerValidateFieldGroup){i._getFieldGroupIds=i._OriginalGetFieldGroupIds;delete i._OriginalGetFieldGroupIds;i.triggerValidateFieldGroup=i._OriginalTriggerValidateFieldGroup;delete i._OriginalTriggerValidateFieldGroup;}}function k1(i){this.setProperty("_fieldHelpEnabled",true,true);this._sDefaultFieldHelp=A[i].id;var j=A[i].control;if(j&&j.bIsDestroyed){A[i].control=undefined;j=undefined;}if(!j){if(A[i].promise){A[i].promise.then(l1.bind(this,A[i].id));}var S1=sap.ui.require(A[i].name);if(!S1&&!A[i].promise){A[i].promise=new Promise(function(V1){A[i].resolve=V1;sap.ui.require([A[i].name],function(W1){k1.call(this,i);}.bind(this));}.bind(this)).then(l1.bind(this,A[i].id));}if(S1){var T1=this.bDelegateInitialized&&this.getControlDelegate()[A[i].getDelegate]();var U1=m({delegate:T1},A[i].properties);j=new S1(A[i].id,U1);j._bIsDefaultHelp=true;A[i].control=j;j.connect(this);if(A[i].resolve){A[i].resolve();delete A[i].resolve;}if(!A[i].promise){l1.call(this,A[i].id);}}}else{l1.call(this,A[i].id);}W.call(this,false);}function l1(i){x1.call(this,i,"insert");}function m1(i,j,S1,T1){if(i.getUseDefaultFieldHelp()&&!this.getFieldHelp()&&S1!==E.Display){if(j.length===1){var U1=n1.call(this,j);if(T1===1){if(!(i.getEditOperator()&&i.getEditOperator()[j[0]])&&(i.getUseDefaultFieldHelp().oneOperatorSingle||!U1)){return true;}}else if(i.getUseDefaultFieldHelp().oneOperatorMulti||!U1){return true;}}else{return true;}}return false;}function n1(i){if(i.length===1){var j=b.getOperator(i[0]);return!j||j.isSingleValue();}else{return false;}}function o1(i){this._bParseError=true;this._sFilterValue="";}function p1(S1){this._bParseError=true;this._sFilterValue="";var T1=S1.getParameter("newValue");var U1=false;var i=0;for(i=0;i<this._aAsyncChanges.length;i++){var V1=this._aAsyncChanges[i];if(V1.waitForUpdate&&Array.isArray(V1.result)){if(V1.result.length===0&&T1===""){V1.reject(S1.getParameter("exception"));U1=true;}else{for(var j=0;j<V1.result.length;j++){var W1=V1.result[j];if(k(W1.values[0],T1)||(W1.operator==="BT"&&k(W1.values[1],T1))){V1.reject(S1.getParameter("exception"));U1=true;break;}}}if(U1){break;}}}if(U1){this._aAsyncChanges.splice(i,1);}}function q1(i){var j={parameters:m({},i.getParameters()),source:i.getSource()};var S1=this._aAsyncChanges.length;if(S1>0&&!this._aAsyncChanges[S1-1].changeFired){this._aAsyncChanges[S1-1].changeFired=true;this._aAsyncChanges[S1-1].changeEvent=j;G.call(this,undefined,undefined,undefined,this._aAsyncChanges[S1-1].promise);return;}var T1={changeEvent:j};r1.call(this,T1);}function r1(i){var j=this.getConditions();var S1;var T1=true;var U1;var V1;var W1=i.changeEvent.source;var X1=false;var Y1=true;var Z1=false;if(i.changeEvent.parameters.hasOwnProperty("valid")){T1=i.changeEvent.parameters["valid"];if(!T1&&i.changeEvent.parameters.hasOwnProperty("value")){U1=i.changeEvent.parameters["value"];}}var $1=false;var _1=this._oContentFactory.getBoundProperty();var a2=_1&&W1.getBinding(_1);if(a2&&a2.getBindingMode()!==p.OneWay&&a2.getPath()==="/conditions"&&T1){V1=j[0];S1=j[0]&&j[0].values[0];}else if(i.changeEvent.parameters.hasOwnProperty("value")){S1=i.changeEvent.parameters["value"];if(T1){$1=true;}}else{V1=j[0];S1=j[0]&&j[0].values[0];}if($1){this._removeUIMessage();var b2;var c2;if(this._bIgnoreInputValue){this._bIgnoreInputValue=false;W1.setDOMValue("");if(W1.getMetadata().hasProperty("value")){W1.setValue();}return;}V1=S.resolve().then(function(){var e2=this.getMaxConditions();if(this._oNavigateCondition){T1=true;return this._oNavigateCondition;}else if(S1===""&&e2!==1){return null;}else{b2=this._oContentFactory.getConditionType();var f2=b2.parseValue(S1);var g2=this._aAsyncChanges.length;if(g2>0&&!this._aAsyncChanges[g2-1].changeFired){c2=this._aAsyncChanges[g2-1];c2.changeFired=true;c2.changeEvent=i.changeEvent;G.call(this,undefined,undefined,undefined,c2.promise);}return f2;}}.bind(this)).then(function(V1){Y1=s1.call(this,V1,j,b2,T1,S1,W1,c2||i);Y1=Y1||Z1;return V1;}.bind(this)).catch(function(e2){if(e2&&!(e2 instanceof P)&&!(e2 instanceof r)&&!(e2 instanceof V)){throw e2;}T1=false;U1=S1;this._bParseError=true;this._sFilterValue="";R.call(this,e2.message);if(c2&&c2.reject){if(P1.call(this,c2)){c2.reject(e2);}}else if(X1){G.call(this,j,T1,U1);}}.bind(this)).unwrap();if(V1 instanceof Promise){X1=true;}}else if(!i.changeEvent.parameters.hasOwnProperty("valid")&&this._bParseError){U1=i.changeEvent.parameters["value"];T1=false;}var d2=z1.call(this);if(d2&&this._bConnected){if(sap.ui.getCore().getCurrentFocusedControlId()===W1.getId()){d2.close();}this._sFilterValue="";if(!X1&&T1){A1.call(this,j,d2);d2.onControlChange();}u1.call(this);}if(this._oNavigateCondition){this._oNavigateCondition=undefined;this._oContentFactory.updateConditionType();}if(i.resolve){O1.call(this,i);}else if(!X1&&Y1){G.call(this,j,T1,U1);}}function s1(i,j,S1,T1,U1,V1,W1){var X1=this.getMaxConditions();var Y1=false;if(i===null&&X1!==1){return true;}if(S1){S1.validateValue(i);}if(T1){if(i){if(this._oContentFactory.isMeasure()&&j.length===1&&j[0].values[0][0]===undefined){j=[];}if(X1!==1&&b.indexOfCondition(i,j)>=0){throw new P(this._oResourceBundle.getText("field.CONDITION_ALREADY_EXIST",[U1]));}else{if(X1>0&&X1<=j.length){j.splice(0,j.length-X1+1);}j.push(i);}}else if(X1===1){j=[];}if(!k(j,this.getConditions())){this.setProperty("conditions",j,true);Y1=true;}if(X1!==1){V1.setValue("");}}if(W1.resolve){var Z1=z1.call(this);if(Z1&&this._bConnected){A1.call(this,j,Z1);Z1.onControlChange();}W1.result=j;O1.call(this,W1);P1.call(this,W1);}return Y1;}function t1(j){var S1;var T1;var U1=false;var V1=j.getSource();this._oNavigateCondition=undefined;this._oContentFactory.updateConditionType();if("value"in j.getParameters()){S1=j.getParameter("value");}else if("newValue"in j.getParameters()){S1=j.getParameter("newValue");}if("escPressed"in j.getParameters()){U1=j.getParameter("escPressed");}if("previousValue"in j.getParameters()){T1=j.getParameter("previousValue");}else{var W1=this.getConditions();T1=W1[0]&&W1[0].values[0];}this._bParseError=false;var X1=z1.call(this);if(X1&&(!this._oContentFactory.isMeasure()||V1.getShowValueHelp())){if(U1){if(X1.isOpen(true)){X1.close();A1.call(this,this.getConditions(),X1);u1.call(this);this._sFilterValue="";}}else{var Y1=this._getOperators();var Z1=false;for(var i=0;i<Y1.length;i++){var $1=b.getOperator(Y1[i]);if($1.validateInput){Z1=true;break;}}if(Z1){this._bIgnoreInputValue=false;this._vLiveChangeValue=S1;if(!this._fnLiveChangeTimer){this._fnLiveChangeTimer=u(function(){var a2=this.getDisplay();this._sFilterValue="";if(this._vLiveChangeValue){var $1=b.getEQOperator();var b2=$1.getValues(this._vLiveChangeValue,a2,true);if(b2[0]){this._sFilterValue=b2[0];if(b2[1]){this._sFilterValue=this._sFilterValue+" ";}}if(b2[1]){this._sFilterValue=this._sFilterValue+b2[1];}}var _1=this.hasOwnProperty("_bOpenByTyping")?this._bOpenByTyping:X1.isTypeaheadSupported();if(this._bConnected&&this._getContent()[0]&&_1&&(sap.ui.getCore().getCurrentFocusedControlId()===this._getContent()[0].getId()||(this._getContent()[1]&&sap.ui.getCore().getCurrentFocusedControlId()===this._getContent()[1].getId()))){X1.setFilterValue(this._sFilterValue);if(this.getMaxConditionsForHelp()===1&&X1.getConditions().length>0){X1.setConditions([]);}X1.open(true);W.call(this,true);delete this._vLiveChangeValue;}}.bind(this),300,{leading:false,trailing:true});X1.initBeforeOpen(true);}var _1=X1.isTypeaheadSupported();if(_1 instanceof Promise){_1.then(function(a2){var b2=document.activeElement;if(b2&&(n(this.getDomRef(),b2))&&this._fnLiveChangeTimer){this._fnLiveChangeTimer();}this._bOpenByTyping=a2;}.bind(this));}this._fnLiveChangeTimer();}}}this.fireLiveChange({value:S1,escPressed:U1,previousValue:T1});}function u1(){if(this._fnLiveChangeTimer){this._fnLiveChangeTimer.cancel();delete this._vLiveChangeValue;}}function v1(i){var j=this.getFieldInfo();if(j){j.getTriggerHref().then(function(S1){if(!S1){j.open(this._getContent()[0]);W.call(this,true);}}.bind(this));}this.firePress();}function w1(j){if(j.getParameter("type")==="removed"){var S1=j.getParameter("removedTokens");var T1=this.getConditions();var U1;var i;for(i=0;i<S1.length;i++){var V1=S1[i];var W1=V1.getBindingContext("$field").sPath;var X1=parseInt(W1.slice(W1.lastIndexOf("/")+1));T1[X1].delete=true;}for(i=T1.length-1;i>=0;i--){if(T1[i].delete){if(this._oContentFactory.isMeasure()){U1=T1[i].values[0][1];}T1.splice(i,1);}}if(this._oContentFactory.isMeasure()&&U1&&T1.length===0){T1=[c.createItemCondition([undefined,U1],undefined)];}this.setProperty("conditions",T1,true);H.call(this,T1,true);j.preventDefault(true);}}function x1(i,j){if(j==="remove"){var S1=sap.ui.getCore().byId(i);if(S1){S1.detachEvent("select",C1,this);S1.detachEvent("navigated",D1,this);S1.detachEvent("dataUpdate",G1,this);S1.detachEvent("disconnect",H1,this);S1.detachEvent("afterClose",E1,this);S1.detachEvent("switchToValueHelp",F1,this);}this.setProperty("_fieldHelpEnabled",false,true);this._bConnected=false;}else if(j==="insert"){y1.call(this,i);}var T1=this._getContent()[0];if(T1&&T1.setValueHelpIconSrc){T1.setValueHelpIconSrc(this._getFieldHelpIcon());}Q.call(this,this.getConditions());}function y1(i){if(i&&!this.getProperty("_fieldHelpEnabled")){var j=sap.ui.getCore().byId(i);if(j){j.attachEvent("dataUpdate",G1,this);if(!j.valueHelpEnabled||j.valueHelpEnabled()){this.setProperty("_fieldHelpEnabled",true,true);}}}}function z1(){var i=this.getFieldHelp();var j;if(!i&&this._sDefaultFieldHelp){i=this._sDefaultFieldHelp;}if(i){j=sap.ui.getCore().byId(i);}return j;}function A1(j,S1){if(!S1){S1=z1.call(this);}if(this._oContentFactory.isMeasure()){var T1=[];for(var i=0;i<j.length;i++){var U1=j[i];if(U1.values[0]&&U1.values[0][1]){var V1=c.createItemCondition(U1.values[0][1],undefined,U1.inParameters,U1.outParameters);T1.push(V1);}}S1.setConditions(T1);}else{S1.setConditions(j);}}function B1(i){var j=z1.call(this);if(j){j.setFilterValue(this._sFilterValue);var S1=this.getConditions();A1.call(this,S1,j);j.toggleOpen(false);W.call(this,true);if(!j.isFocusInHelp()){var T1=i.getSource();if(T1.bValueHelpRequested){T1.bValueHelpRequested=false;}}}}function C1(j){var S1=this.getConditions();var T1=j.getParameter("conditions");var U1=j.getParameter("add");var V1=j.getParameter("close");var W1=j.oSource;var X1=this.getMaxConditions();var Y1;var Z1=this.getControlForSuggestion();var $1;var i=0;if(this._oContentFactory.isMeasure()){if(T1.length>1){throw new Error("Only one item must be selected! "+this);}if(T1[0].operator!=="EQ"){throw new Error("Only EQ allowed! "+this);}if(S1.length>0){for(i=0;i<S1.length;i++){S1[i].values[0][1]=T1[0].values[0];if(S1[i].operator==="BT"){S1[i].values[1][1]=T1[0].values[0];}if(T1[0].inParameters){S1[i].inParameters=T1[0].inParameters;}if(T1[0].outParameters){S1[i].outParameters=T1[0].outParameters;}}}else{var _1=b.getEQOperator(this._getOperators());var a2=this.getControlDelegate().enhanceValueForUnit(this.getPayload(),[null,T1[0].values[0]],this._oTypeInitialization);Y1=c.createCondition(_1.name,[a2],T1[0].inParameters,T1[0].outParameters,C.NotValidated);S1.push(Y1);var b2=this._oContentFactory.getConditionType(true);var c2=this._oContentFactory.getUnitConditionsType(true);if(b2){$1=b2.formatValue(Y1);}else if(c2){$1=c2.formatValue(S1);}}}else{if(!U1){S1=[];}for(i=0;i<T1.length;i++){Y1=T1[i];if(!Q1.call(this,Y1.operator)){continue;}var d2=U1?-1:b.indexOfCondition(Y1,S1);if(d2===-1){S1.push(Y1);}else if(Y1.values[1]!==S1[d2].values[1]&&S1[d2].values[1]){S1[d2].values[1]=Y1.values[1];}}}if(X1>0&&X1<S1.length){S1.splice(0,S1.length-X1);}if(Z1&&Z1.setDOMValue){if(this.getMaxConditionsForHelp()===1&&S1.length>0){if(this._oContentFactory.isMeasure()&&this._oContentFactory.getUnitConditionsType()){$1=this._oContentFactory.getUnitConditionsType().formatValue(S1);}else if(this._oContentFactory.getConditionType(true)){$1=this._oContentFactory.getConditionType().formatValue(S1[0]);}else if(this._oContentFactory.getConditionsType(true)){$1=this._oContentFactory.getConditionsType().formatValue(S1);}if($1 instanceof Promise){$1.then(function(f2){Z1.setDOMValue("");Z1.setDOMValue(f2);});}else{Z1.setDOMValue("");Z1.setDOMValue($1);}this._sFilterValue="";}else if(V1){if(this.getMaxConditions()!==1&&!this._oContentFactory.getBoundProperty()&&Z1.getMetadata().hasProperty("value")&&Z1.getProperty("value")){Z1.setValue();}Z1.setDOMValue("");this._sFilterValue="";this._bIgnoreInputValue=false;}else{this._bIgnoreInputValue=true;}if(this._bParseError){this._bParseError=false;this._removeUIMessage();}}var e2=this.getConditions();if(!k(S1,e2)){this._oNavigateCondition=undefined;this._oContentFactory.updateConditionType();this.setProperty("conditions",S1,true);if(!b.compareConditionsArray(S1,e2)){W1.onControlChange();G.call(this,S1,true);}}}function D1(i){var j=i.getParameter("value");var S1=i.getParameter("key");var T1=i.getParameter("condition");var U1=i.getParameter("itemId");var V1=i.getParameter("leaveFocus");if(!T1&&S1){T1=c.createItemCondition(S1,j);}var W1;var X1;var Y1=this.getControlForSuggestion();var Z1=b.getEQOperator(this._getOperators());var $1=z1.call(this);if(V1){Y1.addStyleClass("sapMFocus");Y1.focus();$1.removeFocus();return;}if(T1){this._oNavigateCondition=m({},T1);this._oNavigateCondition.operator=Z1.name;S1=T1.values[0];j=T1.values[1];}else{this._oNavigateCondition=c.createCondition(Z1.name,[S1,j],undefined,undefined,C.Validated);}if(this._oContentFactory.isMeasure()){var _1=this.getConditions();if(_1.length>0){this._oNavigateCondition.operator=_1[0].operator;this._oNavigateCondition.values[0]=[_1[0].values[0][0],S1];if(_1[0].operator==="BT"){this._oNavigateCondition.values[1]=[_1[0].values[1][0],this._oNavigateCondition.values[0][1]];}else if(this._oNavigateCondition.values.length>1){this._oNavigateCondition.values.splice(1);}}else{this._oNavigateCondition.values=[this.getControlDelegate().enhanceValueForUnit(this.getPayload(),[null,S1],this._oTypeInitialization)];}}this._bPreventGetDescription=true;this._oContentFactory.updateConditionType();if(this.getDisplay()!==F.Value){W1=S1;}else if(j){W1=j;}else{W1=S1;}if(Y1&&Y1.setDOMValue){if(!X1){if(this._oContentFactory.isMeasure()&&this._oContentFactory.getUnitConditionsType()&&this._oNavigateCondition){X1=this._oContentFactory.getUnitConditionsType().formatValue([this._oNavigateCondition]);}else if(this._oContentFactory.getConditionType(true)&&this._oNavigateCondition){X1=this._oContentFactory.getConditionType().formatValue(this._oNavigateCondition);}else if(this._oContentFactory.getConditionsType(true)&&this._oNavigateCondition){X1=this._oContentFactory.getConditionsType().formatValue([this._oNavigateCondition]);}else{X1=j||S1;}}Y1.setDOMValue(X1);Y1._doSelect();if($1.isOpen()){Y1.removeStyleClass("sapMFocus");}}this._bPreventGetDescription=false;this._oContentFactory.updateConditionType();W.call(this,true,U1);this._bIgnoreInputValue=false;this.fireLiveChange({value:W1});}function E1(i){if(this._bIgnoreInputValue){var j=this.getControlForSuggestion();this._bIgnoreInputValue=false;j.setDOMValue("");if(this.getMaxConditions()!==1&&!this._oContentFactory.getBoundProperty()&&j.getMetadata().hasProperty("value")&&j.getProperty("value")){j.setValue();}}W.call(this,false);}function F1(i){var j=this.getControlForSuggestion();j.focus();if(j.fireValueHelpRequest){j.bValueHelpRequested=true;j.fireValueHelpRequest();}}function G1(i){var j=this.getEditMode()===E.Editable&&this._getContent().length>0&&sap.ui.getCore().getCurrentFocusedControlId()===this._getContent()[0].getId();if(!j&&!this._bPendingConditionUpdate&&this.getConditions().length>0&&(this.getMaxConditions()!==1||(this.getDisplay()!==F.Value&&!this._bParseError))){this._oManagedObjectModel.checkUpdate(true);}}function H1(i){var j=z1.call(this);j.detachEvent("select",C1,this);j.detachEvent("navigated",D1,this);j.detachEvent("disconnect",H1,this);j.detachEvent("afterClose",E1,this);j.detachEvent("switchToValueHelp",F1,this);j.detachEvent("closed",E1,this);this._bConnected=false;}function I1(){var i=z1.call(this);if(i&&!this._bConnected){var j=R1.call(this);var S1={maxConditions:this.getMaxConditions(),dataType:this._oContentFactory.getDataType(),operators:this._getOperators(),display:this._oContentFactory.isMeasure()?F.Value:this.getDisplay(),delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),conditionModel:j.model,conditionModelName:j.name};i.connect(this,S1);this._bConnected=true;i.attachEvent("select",C1,this);i.attachEvent("navigated",D1,this);i.attachEvent("disconnect",H1,this);i.attachEvent("afterClose",E1,this);i.attachEvent("switchToValueHelp",F1,this);i.attachEvent("closed",E1,this);var T1=this.getConditions();A1.call(this,T1,i);var U1=this.getControlForSuggestion();J1.call(this,U1);if(i._bIsDefaultHelp&&i.setTitle){i.setTitle(this.getLabel());}}}function J1(i){if(i&&!i.orgOnsapfocusleave&&i.onsapfocusleave){i.orgOnsapfocusleave=i.onsapfocusleave;i.onsapfocusleave=function(j){var S1=z1.call(this.getParent());if(S1){var T1=sap.ui.getCore().byId(j.relatedControlId);if(T1){if(n(S1.getDomRef(),T1.getFocusDomRef())){j.stopPropagation();return;}else{S1.skipOpening();}}}this.orgOnsapfocusleave(j);};}}x.prototype._getFieldHelpIcon=function(){var i=z1.call(this);if(i){return i.getIcon();}};function K1(i,j){if(j==="remove"){i.detachEvent("dataUpdate",L1,this);}else if(j==="insert"){i.attachEvent("dataUpdate",L1,this);L1.call(this);}}function L1(){var i=this.getFieldInfo();var j=this;i.isTriggerable().then(function(S1){j._bTriggerable=S1;var T1=j.getAggregation("_content",[]);if(T1.length>0&&j.getEditMode()===E.Display){a1.call(j);if(j._bTriggerable){T1=j.getAggregation("_content",[]);var U1=T1[0];i.getDirectLinkHrefAndTarget().then(function(V1){f._updateLink(U1,V1);});}}});}x.prototype._getFormatOptions=function(){if(!this._asyncParsingCall){this._asyncParsingCall=M1.bind(this);}var i=R1.call(this);return{valueType:this._oContentFactory.retrieveDataType(),originalDateType:this._oContentFactory.getDateOriginalType()||this._oContentFactory.getUnitOriginalType(),additionalType:this._oContentFactory.getUnitType(),display:this._oContentFactory.isMeasure()?F.Value:this.getDisplay(),fieldHelpID:this._oContentFactory.isMeasure()?undefined:this.getFieldHelp()||this._sDefaultFieldHelp,operators:this._getOperators(),hideOperator:this._oContentFactory.getHideOperator(),maxConditions:this.getMaxConditions(),bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),preventGetDescription:this._bPreventGetDescription,conditionModel:i.model,conditionModelName:i.name,defaultOperatorName:this.getDefaultOperator?this.getDefaultOperator():null};};x.prototype._checkValueInitial=function(i){if(i===null||i===undefined){return true;}if(i===""||(typeof(i)==="string"&&i.match(/^0+$/))){var j=this._oContentFactory.retrieveDataType();var S1=j.parseValue("","string");if(S1===i){return true;}else{try{j.validateValue(S1);}catch(T1){return true;}}}else{var U1=J.call(this);if(this.getTypeUtil().getBaseType(U1)===B.Unit&&Array.isArray(i)&&i.length>1&&(i[0]===undefined||i[0]===null)&&!i[1]){return true;}}return false;};x.prototype._getUnitFormatOptions=function(){if(!this._asyncParsingCall){this._asyncParsingCall=M1.bind(this);}var i=R1.call(this);return{valueType:this._oContentFactory.getUnitType(),originalDateType:this._oContentFactory.getDateOriginalType()||this._oContentFactory.getUnitOriginalType(),additionalType:this._oContentFactory.retrieveDataType(),display:this.getDisplay(),fieldHelpID:this.getFieldHelp()||this._sDefaultFieldHelp,operators:["EQ"],hideOperator:true,maxConditions:1,bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),preventGetDescription:this._bPreventGetDescription,conditionModel:i.model,conditionModelName:i.name,getConditions:this.getConditions.bind(this)};};function M1(i){var j=z1.call(this);if(j&&j.isOpen()){var S1=document.activeElement;if(S1&&(n(this.getDomRef(),S1)||n(j.getDomRef(),S1))){j.close();}}var T1={};var U1=new Promise(function(V1,W1){T1.resolve=V1;T1.reject=W1;i.then(function(X1){T1.result=X1;this._bParseError=false;var Y1=this.getConditions();if(k(X1,Y1)){O1.call(this,T1);P1.call(this,T1);}else{T1.waitForUpdate=true;}}.bind(this)).catch(function(X1){if(X1&&!(X1 instanceof P)&&!(X1 instanceof r)&&!(X1 instanceof V)){throw X1;}this._bParseError=true;W1(X1);P1.call(this,T1);}.bind(this));}.bind(this));T1.promise=U1;this._aAsyncChanges.push(T1);}function N1(){var j=[];for(var i=0;i<this._aAsyncChanges.length;i++){j.push(this._aAsyncChanges[i].promise);}if(j.length>0){return Promise.all(j).then(function(){return this._getResultForPromise(this.getConditions());}.bind(this));}return null;}x.prototype._getResultForPromise=function(i){return i;};function O1(i){i.resolve(this._getResultForPromise(i.result));}function P1(j){var S1=false;var i=0;for(i=0;i<this._aAsyncChanges.length;i++){if(j===this._aAsyncChanges[i]){S1=true;break;}}if(S1){this._aAsyncChanges.splice(i,1);}return S1;}x.prototype._getOperators=function(){var i=new RegExp("^\\*(.*)\\*|\\$search$");if(i.test(this.getFieldPath())&&this.getMaxConditions()===1){return["Contains"];}var j=this.getBaseType();if(j===B.Unit){j=B.Numeric;}return b.getOperatorsForType(j);};function Q1(j){var S1=this._getOperators();for(var i=0;i<S1.length;i++){if(j===S1[i]){return true;}}return false;}function R1(){var i;var j;var S1=this.getBinding("conditions");if(S1){var T1=S1.getModel();if(T1&&T1.isA("sap.ui.mdc.condition.ConditionModel")){i=T1;var U1=this.getBindingInfo("conditions");if(U1.model){j=U1.model;}else if(U1.parts&&U1.parts.length===1){j=U1.parts[0].model;}}}return{name:j,model:i};}return x;});
