/*!
 * OpenUI5
 * (c) Copyright 2009-2021 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/ui/mdc/enum/EditMode","sap/ui/mdc/enum/ContentMode","sap/ui/mdc/util/loadModules","sap/ui/mdc/field/content/DefaultContent","sap/ui/mdc/field/content/SearchContent","sap/ui/mdc/field/content/DateContent","sap/ui/mdc/field/content/TimeContent","sap/ui/mdc/field/content/DateTimeContent","sap/ui/mdc/field/content/LinkContent","sap/ui/mdc/field/content/BooleanContent","sap/ui/mdc/field/content/UnitContent",'sap/ui/mdc/field/ConditionType','sap/ui/mdc/field/ConditionsType',"sap/ui/base/SyncPromise"],function(B,E,C,l,D,S,a,T,b,L,c,U,d,e,f){"use strict";var g=B.extend("sap.ui.mdc.field.content.ContentFactory",{metadata:{library:"sap.ui.mdc"},constructor:function(i,s){this._oField=s?s.field:null;this._fnHandleTokenUpdate=s?s.handleTokenUpdate:null;this._fnHandleContentChange=s?s.handleContentChange:null;this._fnHandleContentLiveChange=s?s.handleContentLiveChange:null;this._fnHandleValueHelpRequest=s?s.handleValueHelpRequest:null;this._fnHandleEnter=s?s.handleEnter:null;this._fnHandleContentPress=s?s.handleContentPress:null;B.prototype.constructor.apply(this,arguments);}});var m={Default:D,Search:S,Date:a,Time:T,DateTime:b,Link:L,Boolean:c,Unit:U};g.prototype.init=function(){this._oContentTypeClass;this._sOperator;};g.prototype.exit=function(){this._oField=undefined;this._fnHandleTokenUpdate=undefined;this._fnHandleContentChange=undefined;this._fnHandleContentLiveChange=undefined;this._fnHandleValueHelpRequest=undefined;this._fnHandleEnter=undefined;this._fnHandleContentPress=undefined;this._oContentTypeClass=undefined;this._sOperator=undefined;if(this._oConditionType&&this._oConditionType._bCreatedByField){this._oConditionType.destroy();this._oConditionType=undefined;}if(this._oConditionsType&&this._oConditionsType._bCreatedByField){this._oConditionsType.destroy();this._oConditionsType=undefined;}};g.prototype.createContent=function(o,s,i){var h=o.getControlNames(s,this._sOperator);var j;if(h.every(function(n){return!n;})){return Promise.resolve([]);}try{j=l(h).catch(function(k){throw new Error("loadModules promise rejected in sap.ui.mdc.field.content.ContentFactory:createContent function call - could not load controls "+JSON.stringify(h));}).then(function(n){return o.create(this,s,this._sOperator,n,i);}.bind(this)).unwrap();}catch(k){throw new Error("Error in sap.ui.mdc.field.content.ContentFactory:createContent function call ErrorMessage: '"+k.message+"'");}if(j.then){j.catch(function(k){throw new Error("Error in sap.ui.mdc.field.content.ContentFactory:createContent function call ErrorMessage: '"+k.message+"'");});return j;}return f.resolve(j);};g.prototype.getContentMode=function(o,s,M,h,O){var i=C.Edit;if(s===E.Display){if(M!==1){i=C.DisplayMultiValue;}else if(h){i=C.DisplayMultiLine;}else{i=C.Display;}}else if(M!==1){i=C.EditMultiValue;}else if(h){i=C.EditMultiLine;}else if(O.length===1&&o.getEditOperator()&&o.getEditOperator()[O[0]]){this._sOperator=O[0];i=C.EditOperator;}else if(this.getField().getFieldHelp()){i=C.EditForHelp;}return i;};g.prototype.getContentType=function(s,M,i){var F=this.getField();var o=m[s]?m[s]:null;if(!o){if(F.getFieldInfo()&&i){o=m.Link;}else{var r=new RegExp("^\\*(.*)\\*|\\$search$");if(r.test(F.getFieldPath())&&M===1){o=m.Search;}else{o=m.Default;}}}return o;};g._updateLink=function(o,h){if(h){o.setHref(h.href);o.setTarget(h.target);}};g._getEnabled=function(s){return(s&&s!==E.Disabled);};g._getEditable=function(s){return(s===E.Editable||s===E.EditableReadOnly||s===E.EditableDisplay);};g._getDisplayOnly=function(s){return s&&s!==E.Editable;};g._getEditableUnit=function(s){return s===E.Editable;};g.prototype.getField=function(){return this._oField;};g.prototype.getFieldHelpIcon=function(){return this.getField()._getFieldHelpIcon();};g.prototype.getHandleTokenUpdate=function(){return this._fnHandleTokenUpdate;};g.prototype.getHandleContentChange=function(){return this._fnHandleContentChange;};g.prototype.getHandleContentLiveChange=function(){return this._fnHandleContentLiveChange;};g.prototype.getHandleValueHelpRequest=function(){return this._fnHandleValueHelpRequest;};g.prototype.getHandleEnter=function(){return this._fnHandleEnter;};g.prototype.getHandleContentPress=function(){return this._fnHandleContentPress;};g.prototype.setBoundProperty=function(s){this._sBoundProperty=s;};g.prototype.getBoundProperty=function(){return this._sBoundProperty;};g.prototype.setAriaLabelledBy=function(o){if(o.addAriaLabelledBy){var A=this.getField().getAriaLabelledBy();for(var i=0;i<A.length;i++){var I=A[i];o.addAriaLabelledBy(I);}}};g.prototype.setHideOperator=function(h){this._bHideOperator=h;};g.prototype.getHideOperator=function(){return this._bHideOperator;};g.prototype.getConditionType=function(s){if(!s&&!this._oConditionType){var F=this.getField()._getFormatOptions();this._oConditionType=new d(F);this._oConditionType._bCreatedByField=true;}return this._oConditionType;};g.prototype.setConditionType=function(o){this._oConditionType=o;};g.prototype.getConditionsType=function(s){if(!s&&!this._oConditionsType){var F=this.getField()._getFormatOptions();this._oConditionsType=new e(F);this._oConditionsType._bCreatedByField=true;}return this._oConditionsType;};g.prototype.setConditionsType=function(o){this._oConditionsType=o;};g.prototype.getUnitConditionsType=function(s){if(!s&&!this._oUnitConditionsType){var F=this.getField()._getUnitFormatOptions();this._oUnitConditionsType=new e(F);this._oUnitConditionsType._bCreatedByField=true;}return this._oUnitConditionsType;};g.prototype.getContentConditionTypes=function(){return this._oContentConditionTypes;};g.prototype.setContentConditionTypes=function(o){this._oContentConditionTypes=o;};g.prototype._setUsedConditionType=function(o,s){if(this._oConditionType&&!this._oConditionType._bCreatedByField){this._oConditionType=undefined;}if(this._oConditionsType&&!this._oConditionsType._bCreatedByField){this._oConditionsType=undefined;}var h;var i;if(o){if(this._oContentConditionTypes.content){h=this._oContentConditionTypes.content.oConditionType;i=this._oContentConditionTypes.content.oConditionsType;}}else if(s===E.Display&&this.getField().getContentDisplay()){if(this._oContentConditionTypes.contentDisplay){h=this._oContentConditionTypes.contentDisplay.oConditionType;i=this._oContentConditionTypes.contentDisplay.oConditionsType;}}else if(s!==E.Display&&this.getField().getContentEdit()){if(this._oContentConditionTypes.contentEdit){h=this._oContentConditionTypes.contentEdit.oConditionType;i=this._oContentConditionTypes.contentEdit.oConditionsType;}}if(h){if(this._oConditionType&&this._oConditionType._bCreatedByField){this._oConditionType.destroy();}this._oConditionType=h;}if(i){if(this._oConditionsType&&this._oConditionsType._bCreatedByField){this._oConditionsType.destroy();}this._oConditionsType=i;}this.updateConditionType();};g.prototype.getDataType=function(){return this._oDataType;};g.prototype.setDataType=function(o){this._oDataType=o;};g.prototype.retrieveDataType=function(){if(!this._oDataType){var s=this.getField().getDataType();if(typeof s==="string"){this._oDataType=this.getField().getTypeUtil().getDataTypeInstance(s,this.getField().getDataTypeFormatOptions(),this.getField().getDataTypeConstraints());this._oDataType._bCreatedByField=true;}}return this._oDataType;};g.prototype.getDateOriginalType=function(){return this._oDateOriginalType;};g.prototype.setDateOriginalType=function(o){this._oDateOriginalType=o;};g.prototype.getUnitOriginalType=function(){return this._oUnitOriginalType;};g.prototype.setUnitOriginalType=function(u){this._oUnitOriginalType=u;};g.prototype.getUnitType=function(){return this._oUnitType;};g.prototype.setUnitType=function(u){this._oUnitType=u;};g.prototype.isMeasure=function(){return this._bIsMeasure;};g.prototype.setIsMeasure=function(i){this._bIsMeasure=i;};g.prototype.getDisplayFormat=function(){return this._sDisplayFormat;};g.prototype.setDisplayFormat=function(s){this._sDisplayFormat=s;};g.prototype.getValueFormat=function(){return this._sValueFormat;};g.prototype.setValueFormat=function(v){this._sValueFormat=v;};g.prototype.getCalendarType=function(){return this._sCalendarType;};g.prototype.setCalendarType=function(s){this._sCalendarType=s;};g.prototype.getFieldTypeInitialization=function(){return this.getField()._oTypeInitialization;};g.prototype.updateConditionType=function(){var o=this._oConditionType;var h=this._oConditionsType;if(o||h){var F=this.getField()._getFormatOptions();if(o){o.setFormatOptions(F);}if(h){h.setFormatOptions(F);}if(this._oUnitConditionsType){F=this.getField()._getUnitFormatOptions();this._oUnitConditionsType.setFormatOptions(F);}}};return g;});
